<?php

$pdo = new PDO('mysql:host=167.86.105.17:3306;dbname=ca_new;charset=utf8mb4', 'root', 'Meninblack@777');

// Fetch all workflows with related_field_id = 68 (or others if needed)
$stmt = $pdo->query("SELECT id, conditions FROM uv_workflow WHERE related_field_id = 68");

$update = $pdo->prepare("UPDATE uv_workflow SET condition_meta = :meta WHERE id = :id");

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $id = $row['id'];
    $conditions = @unserialize($row['conditions']);

    if (!is_array($conditions)) continue;

    $meta = [];
    foreach ($conditions as $cond) {
        if (!isset($cond['type'], $cond['value'])) continue;

        $type = $cond['type'];
        $value = $cond['value'];

        // Map to meta fields
        if ($type === 'TicketType') {
            $meta['ticket_type'] = $value;
        } elseif ($type === 'TicketStatus') {
            $meta['ticket_status'] = $value;
        } elseif (preg_match('/^custom_field_(\\d+)$/', $type, $matches)) {
            $cfId = $matches[1];
            $meta["custom_field_$cfId"][] = $value;
        }
    }

    $jsonMeta = json_encode($meta);
    $update->execute([':meta' => $jsonMeta, ':id' => $id]);

    echo "Updated workflow $id\n";
}
