<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20250321182533 extends AbstractMigration
{
    public function getDescription(): string
    {
        return 'Adds time_spent column as DECIMAL(10,2) to uv_thread table';
    }

    public function up(Schema $schema): void
    {
        $this->abortIf(
            $this->connection->getDatabasePlatform()->getName() !== 'mysql',
            'Migration can only be executed safely on \'mysql\'.'
        );

        // Check if the column exists before dropping it
        $schemaManager = $this->connection->getSchemaManager();
        $columns = $schemaManager->listTableColumns('uv_thread');

        if (isset($columns['time_spent'])) {
            $this->addSql('ALTER TABLE uv_thread DROP COLUMN time_spent');
        }

        // Add 'time_spent' column as DECIMAL(10,2)
        $this->addSql('ALTER TABLE uv_thread ADD COLUMN time_spent DECIMAL(10,2) DEFAULT NULL');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs

    }
}
