<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @UVDeskCoreFramework/mxClient.js */
class __TwigTemplate_b0edce53632cefc3102c4fd670796664 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "@UVDeskCoreFramework/mxClient.js"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "@UVDeskCoreFramework/mxClient.js"));

        // line 1
        yield "/**
 * Copyright (c) 2006-2017, JGraph Ltd
 * Copyright (c) 2006-2017, Gaudenz Alder
 */
var mxClient =
{
\t/**
\t * Class: mxClient
\t *
\t * Bootstrapping mechanism for the mxGraph thin client. The production version
\t * of this file contains all code required to run the mxGraph thin client, as
\t * well as global constants to identify the browser and operating system in
\t * use. You may have to load chrome://global/content/contentAreaUtils.js in
\t * your page to disable certain security restrictions in Mozilla.
\t * 
\t * Variable: VERSION
\t *
\t * Contains the current version of the mxGraph library. The strings that
\t * communicate versions of mxGraph use the following format.
\t * 
\t * versionMajor.versionMinor.buildNumber.revisionNumber
\t * 
\t * Current version is 4.2.2.
\t */
\tVERSION: '4.2.2',

\t/**
\t * Variable: IS_IE
\t *
\t * True if the current browser is Internet Explorer 10 or below. Use <mxClient.IS_IE11>
\t * to detect IE 11.
\t */
\tIS_IE: navigator.userAgent != null && navigator.userAgent.indexOf('MSIE') >= 0,

\t/**
\t * Variable: IS_IE6
\t *
\t * True if the current browser is Internet Explorer 6.x.
\t */
\tIS_IE6: navigator.userAgent != null && navigator.userAgent.indexOf('MSIE 6') >= 0,

\t/**
\t * Variable: IS_IE11
\t *
\t * True if the current browser is Internet Explorer 11.x.
\t */
\tIS_IE11: navigator.userAgent != null && !!navigator.userAgent.match(/Trident\\/7\\./),

\t/**
\t * Variable: IS_EDGE
\t *
\t * True if the current browser is Microsoft Edge.
\t */
\tIS_EDGE: navigator.userAgent != null && !!navigator.userAgent.match(/Edge\\//),

\t/**
\t * Variable: IS_QUIRKS
\t *
\t * True if the current browser is Internet Explorer and it is in quirks mode.
\t */
\tIS_QUIRKS: navigator.userAgent != null && navigator.userAgent.indexOf('MSIE') >= 0 &&
\t\t(document.documentMode == null || document.documentMode == 5),

\t/**
\t * Variable: IS_EM
\t * 
\t * True if the browser is IE11 in enterprise mode (IE8 standards mode).
\t */
\tIS_EM: 'spellcheck' in document.createElement('textarea') && document.documentMode == 8,

\t/**
\t * Variable: VML_PREFIX
\t * 
\t * Prefix for VML namespace in node names. Default is 'v'.
\t */
\tVML_PREFIX: 'v',

\t/**
\t * Variable: OFFICE_PREFIX
\t * 
\t * Prefix for VML office namespace in node names. Default is 'o'.
\t */
\tOFFICE_PREFIX: 'o',

\t/**
\t * Variable: IS_NS
\t *
\t * True if the current browser is Netscape (including Firefox).
\t */
  \tIS_NS: navigator.userAgent != null &&
  \t\tnavigator.userAgent.indexOf('Mozilla/') >= 0 &&
  \t\tnavigator.userAgent.indexOf('MSIE') < 0 &&
  \t\tnavigator.userAgent.indexOf('Edge/') < 0,

\t/**
\t * Variable: IS_OP
\t *
\t * True if the current browser is Opera.
\t */
  \tIS_OP: navigator.userAgent != null &&
  \t\t(navigator.userAgent.indexOf('Opera/') >= 0 ||
  \t\tnavigator.userAgent.indexOf('OPR/') >= 0),

\t/**
\t * Variable: IS_OT
\t *
\t * True if -o-transform is available as a CSS style, ie for Opera browsers
\t * based on a Presto engine with version 2.5 or later.
\t */
  \tIS_OT: navigator.userAgent != null &&
  \t\tnavigator.userAgent.indexOf('Presto/') >= 0 &&
  \t\tnavigator.userAgent.indexOf('Presto/2.4.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Presto/2.3.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Presto/2.2.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Presto/2.1.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Presto/2.0.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Presto/1.') < 0,
  \t
\t/**
\t * Variable: IS_SF
\t *
\t * True if the current browser is Safari.
\t */
  \tIS_SF: /Apple Computer, Inc/.test(navigator.vendor),

\t/**
\t * Variable: IS_ANDROID
\t * 
\t * Returns true if the user agent contains Android.
\t */
  \tIS_ANDROID: navigator.appVersion.indexOf('Android') >= 0,

\t/**
\t * Variable: IS_IOS
\t * 
\t * Returns true if the user agent is an iPad, iPhone or iPod.
\t */
  \tIS_IOS: (/iP(hone|od|ad)/.test(navigator.platform)),

\t/**
\t * Variable: IS_GC
\t *
\t * True if the current browser is Google Chrome.
\t */
  \tIS_GC: /Google Inc/.test(navigator.vendor),
\t
\t/**
\t * Variable: IS_CHROMEAPP
\t *
\t * True if the this is running inside a Chrome App.
\t */
  \tIS_CHROMEAPP: window.chrome != null && chrome.app != null && chrome.app.runtime != null,

\t/**
\t * Variable: IS_FF
\t *
\t * True if the current browser is Firefox.
\t */
  \tIS_FF: typeof InstallTrigger !== 'undefined',
  \t
\t/**
\t * Variable: IS_MT
\t *
\t * True if -moz-transform is available as a CSS style. This is the case
\t * for all Firefox-based browsers newer than or equal 3, such as Camino,
\t * Iceweasel, Seamonkey and Iceape.
\t */
  \tIS_MT: (navigator.userAgent.indexOf('Firefox/') >= 0 &&
\t\tnavigator.userAgent.indexOf('Firefox/1.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Firefox/2.') < 0) ||
  \t\t(navigator.userAgent.indexOf('Iceweasel/') >= 0 &&
  \t\tnavigator.userAgent.indexOf('Iceweasel/1.') < 0 &&
  \t\tnavigator.userAgent.indexOf('Iceweasel/2.') < 0) ||
  \t\t(navigator.userAgent.indexOf('SeaMonkey/') >= 0 &&
  \t\tnavigator.userAgent.indexOf('SeaMonkey/1.') < 0) ||
  \t\t(navigator.userAgent.indexOf('Iceape/') >= 0 &&
  \t\tnavigator.userAgent.indexOf('Iceape/1.') < 0),

\t/**
\t * Variable: IS_VML
\t *
\t * True if the browser supports VML.
\t */
  \tIS_VML: navigator.appName.toUpperCase() == 'MICROSOFT INTERNET EXPLORER',

\t/**
\t * Variable: IS_SVG
\t *
\t * True if the browser supports SVG.
\t */
  \tIS_SVG: navigator.appName.toUpperCase() != 'MICROSOFT INTERNET EXPLORER',

\t/**
\t * Variable: NO_FO
\t *
\t * True if foreignObject support is not available. This is the case for
\t * Opera, older SVG-based browsers and all versions of IE.
\t */
  \tNO_FO: !document.createElementNS || document.createElementNS('http://www.w3.org/2000/svg',
  \t\t'foreignObject') != '[object SVGForeignObjectElement]' || navigator.userAgent.indexOf('Opera/') >= 0,

\t/**
\t * Variable: IS_WIN
\t *
\t * True if the client is a Windows.
\t */
  \tIS_WIN: navigator.appVersion.indexOf('Win') > 0,

\t/**
\t * Variable: IS_MAC
\t *
\t * True if the client is a Mac.
\t */
  \tIS_MAC: navigator.appVersion.indexOf('Mac') > 0,
\t
\t/**
\t * Variable: IS_CHROMEOS
\t *
\t * True if the client is a Chrome OS.
\t */
  \tIS_CHROMEOS: /\\bCrOS\\b/.test(navigator.appVersion),

\t/**
\t * Variable: IS_TOUCH
\t * 
\t * True if this device supports touchstart/-move/-end events (Apple iOS,
\t * Android, Chromebook and Chrome Browser on touch-enabled devices).
\t */
  \tIS_TOUCH: 'ontouchstart' in document.documentElement,

\t/**
\t * Variable: IS_POINTER
\t * 
\t * True if this device supports Microsoft pointer events (always false on Macs).
\t */
  \tIS_POINTER: window.PointerEvent != null && !(navigator.appVersion.indexOf('Mac') > 0),

\t/**
\t * Variable: IS_LOCAL
\t *
\t * True if the documents location does not start with http:// or https://.
\t */
  \tIS_LOCAL: document.location.href.indexOf('http://') < 0 &&
  \t\t\t  document.location.href.indexOf('https://') < 0,

\t/**
\t * Variable: defaultBundles
\t * 
\t * Contains the base names of the default bundles if mxLoadResources is false.
\t */
  \tdefaultBundles: [],

\t/**
\t * Function: isBrowserSupported
\t *
\t * Returns true if the current browser is supported, that is, if
\t * <mxClient.IS_VML> or <mxClient.IS_SVG> is true.
\t * 
\t * Example:
\t * 
\t * (code)
\t * if (!mxClient.isBrowserSupported())
\t * {
\t *   mxUtils.error('Browser is not supported!', 200, false);
\t * }
\t * (end)
\t */
\tisBrowserSupported: function()
\t{
\t\treturn mxClient.IS_VML || mxClient.IS_SVG;
\t},

\t/**
\t * Function: link
\t *
\t * Adds a link node to the head of the document. Use this
\t * to add a stylesheet to the page as follows:
\t *
\t * (code)
\t * mxClient.link('stylesheet', filename);
\t * (end)
\t *
\t * where filename is the (relative) URL of the stylesheet. The charset
\t * is hardcoded to ISO-8859-1 and the type is text/css.
\t * 
\t * Parameters:
\t * 
\t * rel - String that represents the rel attribute of the link node.
\t * href - String that represents the href attribute of the link node.
\t * doc - Optional parent document of the link node.
\t * id - unique id for the link element to check if it already exists
\t */
\tlink: function(rel, href, doc, id)
\t{
\t\tdoc = doc || document;

\t\t// Workaround for Operation Aborted in IE6 if base tag is used in head
\t\tif (mxClient.IS_IE6)
\t\t{
\t\t\tdoc.write('<link rel=\"' + rel + '\" href=\"' + href + '\" charset=\"UTF-8\" type=\"text/css\"/>');
\t\t}
\t\telse
\t\t{\t
\t\t\tvar link = doc.createElement('link');
\t\t\t
\t\t\tlink.setAttribute('rel', rel);
\t\t\tlink.setAttribute('href', href);
\t\t\tlink.setAttribute('charset', 'UTF-8');
\t\t\tlink.setAttribute('type', 'text/css');
\t\t\t
\t\t\tif (id)
\t\t\t{
\t\t\t\tlink.setAttribute('id', id);
\t\t\t}
\t\t\t
\t\t\tvar head = doc.getElementsByTagName('head')[0];
\t   \t\thead.appendChild(link);
\t\t}
\t},
\t
\t/**
\t * Function: loadResources
\t * 
\t * Helper method to load the default bundles if mxLoadResources is false.
\t * 
\t * Parameters:
\t * 
\t * fn - Function to call after all resources have been loaded.
\t * lan - Optional string to pass to <mxResources.add>.
\t */
\tloadResources: function(fn, lan)
\t{
\t\tvar pending = mxClient.defaultBundles.length;
\t\t
\t\tfunction callback()
\t\t{
\t\t\tif (--pending == 0)
\t\t\t{
\t\t\t\tfn();
\t\t\t}
\t\t}
\t\t
\t\tfor (var i = 0; i < mxClient.defaultBundles.length; i++)
\t\t{
\t\t\tmxResources.add(mxClient.defaultBundles[i], lan, callback);
\t\t}
\t},
\t
\t/**
\t * Function: include
\t *
\t * Dynamically adds a script node to the document header.
\t * 
\t * In production environments, the includes are resolved in the mxClient.js
\t * file to reduce the number of requests required for client startup. This
\t * function should only be used in development environments, but not in
\t * production systems.
\t */
\tinclude: function(src)
\t{
\t\tdocument.write('<script src=\"'+src+'\"></script>');
\t}
};

/**
 * Variable: mxLoadResources
 * 
 * Optional global config variable to toggle loading of the two resource files
 * in <mxGraph> and <mxEditor>. Default is true. NOTE: This is a global variable,
 * not a variable of mxClient. If this is false, you can use <mxClient.loadResources>
 * with its callback to load the default bundles asynchronously.
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tvar mxLoadResources = false;
 * </script>
 * <script type=\"text/javascript\" src=\"/path/to/core/directory/js/mxClient.js\"></script>
 * (end)
 */
if (typeof(mxLoadResources) == 'undefined')
{
\tmxLoadResources = true;
}

/**
 * Variable: mxForceIncludes
 * 
 * Optional global config variable to force loading the JavaScript files in
 * development mode. Default is undefined. NOTE: This is a global variable,
 * not a variable of mxClient.
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tvar mxLoadResources = true;
 * </script>
 * <script type=\"text/javascript\" src=\"/path/to/core/directory/js/mxClient.js\"></script>
 * (end)
 */
if (typeof(mxForceIncludes) == 'undefined')
{
\tmxForceIncludes = false;
}

/**
 * Variable: mxResourceExtension
 * 
 * Optional global config variable to specify the extension of resource files.
 * Default is true. NOTE: This is a global variable, not a variable of mxClient.
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tvar mxResourceExtension = '.txt';
 * </script>
 * <script type=\"text/javascript\" src=\"/path/to/core/directory/js/mxClient.js\"></script>
 * (end)
 */
if (typeof(mxResourceExtension) == 'undefined')
{
\tmxResourceExtension = '.txt';
}

/**
 * Variable: mxLoadStylesheets
 * 
 * Optional global config variable to toggle loading of the CSS files when
 * the library is initialized. Default is true. NOTE: This is a global variable,
 * not a variable of mxClient.
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tvar mxLoadStylesheets = false;
 * </script>
 * <script type=\"text/javascript\" src=\"/path/to/core/directory/js/mxClient.js\"></script>
 * (end)
 */
if (typeof(mxLoadStylesheets) == 'undefined')
{
\tmxLoadStylesheets = true;
}

/**
 * Variable: basePath
 *
 * Basepath for all URLs in the core without trailing slash. Default is '.'.
 * Set mxBasePath prior to loading the mxClient library as follows to override
 * this setting:
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tmxBasePath = '/path/to/core/directory';
 * </script>
 * <script type=\"text/javascript\" src=\"/path/to/core/directory/js/mxClient.js\"></script>
 * (end)
 * 
 * When using a relative path, the path is relative to the URL of the page that
 * contains the assignment. Trailing slashes are automatically removed.
 */
if (typeof(mxBasePath) != 'undefined' && mxBasePath.length > 0)
{
\t// Adds a trailing slash if required
\tif (mxBasePath.substring(mxBasePath.length - 1) == '/')
\t{
\t\tmxBasePath = mxBasePath.substring(0, mxBasePath.length - 1);
\t}

\tmxClient.basePath = mxBasePath;
}
else
{
\tmxClient.basePath = '.';
}

/**
 * Variable: imageBasePath
 *
 * Basepath for all images URLs in the core without trailing slash. Default is
 * <mxClient.basePath> + '/images'. Set mxImageBasePath prior to loading the
 * mxClient library as follows to override this setting:
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tmxImageBasePath = '/path/to/image/directory';
 * </script>
 * <script type=\"text/javascript\" src=\"/path/to/core/directory/js/mxClient.js\"></script>
 * (end)
 * 
 * When using a relative path, the path is relative to the URL of the page that
 * contains the assignment. Trailing slashes are automatically removed.
 */
if (typeof(mxImageBasePath) != 'undefined' && mxImageBasePath.length > 0)
{
\t// Adds a trailing slash if required
\tif (mxImageBasePath.substring(mxImageBasePath.length - 1) == '/')
\t{
\t\tmxImageBasePath = mxImageBasePath.substring(0, mxImageBasePath.length - 1);
\t}

\tmxClient.imageBasePath = mxImageBasePath;
}
else
{
\tmxClient.imageBasePath = mxClient.basePath + '/images';\t
}

/**
 * Variable: language
 *
 * Defines the language of the client, eg. en for english, de for german etc.
 * The special value 'none' will disable all built-in internationalization and
 * resource loading. See <mxResources.getSpecialBundle> for handling identifiers
 * with and without a dash.
 * 
 * Set mxLanguage prior to loading the mxClient library as follows to override
 * this setting:
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tmxLanguage = 'en';
 * </script>
 * <script type=\"text/javascript\" src=\"js/mxClient.js\"></script>
 * (end)
 * 
 * If internationalization is disabled, then the following variables should be
 * overridden to reflect the current language of the system. These variables are
 * cleared when i18n is disabled.
 * <mxEditor.askZoomResource>, <mxEditor.lastSavedResource>,
 * <mxEditor.currentFileResource>, <mxEditor.propertiesResource>,
 * <mxEditor.tasksResource>, <mxEditor.helpResource>, <mxEditor.outlineResource>,
 * <mxElbowEdgeHandler.doubleClickOrientationResource>, <mxUtils.errorResource>,
 * <mxUtils.closeResource>, <mxGraphSelectionModel.doneResource>,
 * <mxGraphSelectionModel.updatingSelectionResource>, <mxGraphView.doneResource>,
 * <mxGraphView.updatingDocumentResource>, <mxCellRenderer.collapseExpandResource>,
 * <mxGraph.containsValidationErrorsResource> and
 * <mxGraph.alreadyConnectedResource>.
 */
if (typeof(mxLanguage) != 'undefined' && mxLanguage != null)
{
\tmxClient.language = mxLanguage;
}
else
{
\tmxClient.language = (mxClient.IS_IE) ? navigator.userLanguage : navigator.language;
}

/**
 * Variable: defaultLanguage
 * 
 * Defines the default language which is used in the common resource files. Any
 * resources for this language will only load the common resource file, but not
 * the language-specific resource file. Default is 'en'.
 * 
 * Set mxDefaultLanguage prior to loading the mxClient library as follows to override
 * this setting:
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tmxDefaultLanguage = 'de';
 * </script>
 * <script type=\"text/javascript\" src=\"js/mxClient.js\"></script>
 * (end)
 */
if (typeof(mxDefaultLanguage) != 'undefined' && mxDefaultLanguage != null)
{
\tmxClient.defaultLanguage = mxDefaultLanguage;
}
else
{
\tmxClient.defaultLanguage = 'en';
}

// Adds all required stylesheets and namespaces
if (mxLoadStylesheets)
{
\tmxClient.link('stylesheet', mxClient.basePath + '/css/common.css');
}

/**
 * Variable: languages
 *
 * Defines the optional array of all supported language extensions. The default
 * language does not have to be part of this list. See
 * <mxResources.isLanguageSupported>.
 *
 * (code)
 * <script type=\"text/javascript\">
 * \t\tmxLanguages = ['de', 'it', 'fr'];
 * </script>
 * <script type=\"text/javascript\" src=\"js/mxClient.js\"></script>
 * (end)
 * 
 * This is used to avoid unnecessary requests to language files, ie. if a 404
 * will be returned.
 */
if (typeof(mxLanguages) != 'undefined' && mxLanguages != null)
{
\tmxClient.languages = mxLanguages;
}

// Adds required namespaces, stylesheets and memory handling for older IE browsers
if (mxClient.IS_VML)
{
\tif (mxClient.IS_SVG)
\t{
\t\tmxClient.IS_VML = false;
\t}
\telse
\t{
\t\t// Enables support for IE8 standards mode. Note that this requires all attributes for VML
\t\t// elements to be set using direct notation, ie. node.attr = value, not setAttribute.
\t\tif (document.namespaces != null)
\t\t{
\t\t\tif (document.documentMode == 8)
\t\t\t{
\t\t\t\tdocument.namespaces.add(mxClient.VML_PREFIX, 'urn:schemas-microsoft-com:vml', '#default#VML');
\t\t\t\tdocument.namespaces.add(mxClient.OFFICE_PREFIX, 'urn:schemas-microsoft-com:office:office', '#default#VML');
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tdocument.namespaces.add(mxClient.VML_PREFIX, 'urn:schemas-microsoft-com:vml');
\t\t\t\tdocument.namespaces.add(mxClient.OFFICE_PREFIX, 'urn:schemas-microsoft-com:office:office');
\t\t\t}
\t\t}

\t\t// Workaround for limited number of stylesheets in IE (does not work in standards mode)
\t\tif (mxClient.IS_QUIRKS && document.styleSheets.length >= 30)
\t\t{
\t\t\t(function()
\t\t\t{
\t\t\t\tvar node = document.createElement('style');
\t\t\t\tnode.type = 'text/css';
\t\t\t\tnode.styleSheet.cssText = mxClient.VML_PREFIX + '\\\\:*{behavior:url(#default#VML)}' +
\t\t        \tmxClient.OFFICE_PREFIX + '\\\\:*{behavior:url(#default#VML)}';
\t\t        document.getElementsByTagName('head')[0].appendChild(node);
\t\t\t})();
\t\t}
\t\telse
\t\t{
\t\t\tdocument.createStyleSheet().cssText = mxClient.VML_PREFIX + '\\\\:*{behavior:url(#default#VML)}' +
\t\t    \tmxClient.OFFICE_PREFIX + '\\\\:*{behavior:url(#default#VML)}';
\t\t}
\t    
\t    if (mxLoadStylesheets)
\t    {
\t    \tmxClient.link('stylesheet', mxClient.basePath + '/css/explorer.css');
\t    }
\t}
}

/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxLog =
{
\t/**
\t * Class: mxLog
\t * 
\t * A singleton class that implements a simple console.
\t * 
\t * Variable: consoleName
\t * 
\t * Specifies the name of the console window. Default is 'Console'.
\t */
\tconsoleName: 'Console',
\t
\t/**
\t * Variable: TRACE
\t * 
\t * Specified if the output for <enter> and <leave> should be visible in the
\t * console. Default is false.
\t */
\tTRACE: false,

\t/**
\t * Variable: DEBUG
\t * 
\t * Specifies if the output for <debug> should be visible in the console.
\t * Default is true.
\t */
\tDEBUG: true,

\t/**
\t * Variable: WARN
\t * 
\t * Specifies if the output for <warn> should be visible in the console.
\t * Default is true.
\t */
\tWARN: true,

\t/**
\t * Variable: buffer
\t * 
\t * Buffer for pre-initialized content.
\t */
\tbuffer: '',
\t
\t/**
\t * Function: init
\t *
\t * Initializes the DOM node for the console. This requires document.body to
\t * point to a non-null value. This is called from within <setVisible> if the
\t * log has not yet been initialized.
\t */
\tinit: function()
\t{
\t\tif (mxLog.window == null && document.body != null)
\t\t{
\t\t\tvar title = mxLog.consoleName + ' - mxGraph ' + mxClient.VERSION;

\t\t\t// Creates a table that maintains the layout
\t\t\tvar table = document.createElement('table');
\t\t\ttable.setAttribute('width', '100%');
\t\t\ttable.setAttribute('height', '100%');

\t\t\tvar tbody = document.createElement('tbody');
\t\t\tvar tr = document.createElement('tr');
\t\t\tvar td = document.createElement('td');
\t\t\ttd.style.verticalAlign = 'top';
\t\t\t\t
\t\t\t// Adds the actual console as a textarea
\t\t\tmxLog.textarea = document.createElement('textarea');
\t\t\tmxLog.textarea.setAttribute('wrap', 'off');
\t\t\tmxLog.textarea.setAttribute('readOnly', 'true');
\t\t\tmxLog.textarea.style.height = '100%';
\t\t\tmxLog.textarea.style.resize = 'none';
\t\t\tmxLog.textarea.value = mxLog.buffer;

\t\t\t// Workaround for wrong width in standards mode
\t\t\tif (mxClient.IS_NS && document.compatMode != 'BackCompat')
\t\t\t{
\t\t\t\tmxLog.textarea.style.width = '99%';
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tmxLog.textarea.style.width = '100%';
\t\t\t}
\t\t\t
\t\t\ttd.appendChild(mxLog.textarea);
\t\t\ttr.appendChild(td);
\t\t\ttbody.appendChild(tr);

\t\t\t// Creates the container div
\t\t\ttr = document.createElement('tr');
\t\t\tmxLog.td = document.createElement('td');
\t\t\tmxLog.td.style.verticalAlign = 'top';
\t\t\tmxLog.td.setAttribute('height', '30px');
\t\t\t
\t\t\ttr.appendChild(mxLog.td);
\t\t\ttbody.appendChild(tr);
\t\t\ttable.appendChild(tbody);

\t\t\t// Adds various debugging buttons
\t\t\tmxLog.addButton('Info', function (evt)
\t\t\t{
\t\t\t\tmxLog.info();
\t\t\t});
\t\t
\t\t\tmxLog.addButton('DOM', function (evt)
\t\t\t{
\t\t\t\tvar content = mxUtils.getInnerHtml(document.body);
\t\t\t\tmxLog.debug(content);
\t\t\t});
\t
\t\t\tmxLog.addButton('Trace', function (evt)
\t\t\t{
\t\t\t\tmxLog.TRACE = !mxLog.TRACE;
\t\t\t\t
\t\t\t\tif (mxLog.TRACE)
\t\t\t\t{
\t\t\t\t\tmxLog.debug('Tracing enabled');
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tmxLog.debug('Tracing disabled');
\t\t\t\t}
\t\t\t});\t

\t\t\tmxLog.addButton('Copy', function (evt)
\t\t\t{
\t\t\t\ttry
\t\t\t\t{
\t\t\t\t\tmxUtils.copy(mxLog.textarea.value);
\t\t\t\t}
\t\t\t\tcatch (err)
\t\t\t\t{
\t\t\t\t\tmxUtils.alert(err);
\t\t\t\t}
\t\t\t});\t\t\t

\t\t\tmxLog.addButton('Show', function (evt)
\t\t\t{
\t\t\t\ttry
\t\t\t\t{
\t\t\t\t\tmxUtils.popup(mxLog.textarea.value);
\t\t\t\t}
\t\t\t\tcatch (err)
\t\t\t\t{
\t\t\t\t\tmxUtils.alert(err);
\t\t\t\t}
\t\t\t});\t
\t\t\t
\t\t\tmxLog.addButton('Clear', function (evt)
\t\t\t{
\t\t\t\tmxLog.textarea.value = '';
\t\t\t});

\t\t\t// Cross-browser code to get window size
\t\t\tvar h = 0;
\t\t\tvar w = 0;
\t\t\t
\t\t\tif (typeof(window.innerWidth) === 'number')
\t\t\t{
\t\t\t\th = window.innerHeight;
\t\t\t\tw = window.innerWidth;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\th = (document.documentElement.clientHeight || document.body.clientHeight);
\t\t\t\tw = document.body.clientWidth;
\t\t\t}

\t\t\tmxLog.window = new mxWindow(title, table, Math.max(0, w - 320), Math.max(0, h - 210), 300, 160);
\t\t\tmxLog.window.setMaximizable(true);
\t\t\tmxLog.window.setScrollable(false);
\t\t\tmxLog.window.setResizable(true);
\t\t\tmxLog.window.setClosable(true);
\t\t\tmxLog.window.destroyOnClose = false;
\t\t\t
\t\t\t// Workaround for ignored textarea height in various setups
\t\t\tif (((mxClient.IS_NS || mxClient.IS_IE) && !mxClient.IS_GC &&
\t\t\t\t!mxClient.IS_SF && document.compatMode != 'BackCompat') ||
\t\t\t\tdocument.documentMode == 11)
\t\t\t{
\t\t\t\tvar elt = mxLog.window.getElement();
\t\t\t\t
\t\t\t\tvar resizeHandler = function(sender, evt)
\t\t\t\t{
\t\t\t\t\tmxLog.textarea.style.height = Math.max(0, elt.offsetHeight - 70) + 'px';
\t\t\t\t}; 
\t\t\t\t
\t\t\t\tmxLog.window.addListener(mxEvent.RESIZE_END, resizeHandler);
\t\t\t\tmxLog.window.addListener(mxEvent.MAXIMIZE, resizeHandler);
\t\t\t\tmxLog.window.addListener(mxEvent.NORMALIZE, resizeHandler);

\t\t\t\tmxLog.textarea.style.height = '92px';
\t\t\t}
\t\t}
\t},
\t
\t/**
\t * Function: info
\t * 
\t * Writes the current navigator information to the console.
\t */
\tinfo: function()
\t{
\t\tmxLog.writeln(mxUtils.toString(navigator));
\t},
\t\t\t
\t/**
\t * Function: addButton
\t * 
\t * Adds a button to the console using the given label and function.
\t */
\taddButton: function(lab, funct)
\t{
\t\tvar button = document.createElement('button');
\t\tmxUtils.write(button, lab);
\t\tmxEvent.addListener(button, 'click', funct);
\t\tmxLog.td.appendChild(button);
\t},
\t\t\t\t
\t/**
\t * Function: isVisible
\t * 
\t * Returns true if the console is visible.
\t */
\tisVisible: function()
\t{
\t\tif (mxLog.window != null)
\t\t{
\t\t\treturn mxLog.window.isVisible();
\t\t}
\t\t
\t\treturn false;
\t},
\t

\t/**
\t * Function: show
\t * 
\t * Shows the console.
\t */
\tshow: function()
\t{
\t\tmxLog.setVisible(true);
\t},

\t/**
\t * Function: setVisible
\t * 
\t * Shows or hides the console.
\t */
\tsetVisible: function(visible)
\t{
\t\tif (mxLog.window == null)
\t\t{
\t\t\tmxLog.init();
\t\t}

\t\tif (mxLog.window != null)
\t\t{
\t\t\tmxLog.window.setVisible(visible);
\t\t}
\t},

\t/**
\t * Function: enter
\t * 
\t * Writes the specified string to the console
\t * if <TRACE> is true and returns the current 
\t * time in milliseconds.
\t *
\t * Example:
\t * 
\t * (code)
\t * mxLog.show();
\t * var t0 = mxLog.enter('Hello');
\t * // Do something
\t * mxLog.leave('World!', t0);
\t * (end)
\t */
\tenter: function(string)
\t{
\t\tif (mxLog.TRACE)
\t\t{
\t\t\tmxLog.writeln('Entering '+string);
\t\t\t
\t\t\treturn new Date().getTime();
\t\t}
\t},

\t/**
\t * Function: leave
\t * 
\t * Writes the specified string to the console
\t * if <TRACE> is true and computes the difference
\t * between the current time and t0 in milliseconds.
\t * See <enter> for an example.
\t */
\tleave: function(string, t0)
\t{
\t\tif (mxLog.TRACE)
\t\t{
\t\t\tvar dt = (t0 != 0) ? ' ('+(new Date().getTime() - t0)+' ms)' : '';
\t\t\tmxLog.writeln('Leaving '+string+dt);
\t\t}
\t},
\t
\t/**
\t * Function: debug
\t * 
\t * Adds all arguments to the console if <DEBUG> is enabled.
\t *
\t * Example:
\t * 
\t * (code)
\t * mxLog.show();
\t * mxLog.debug('Hello, World!');
\t * (end)
\t */
\tdebug: function()
\t{
\t\tif (mxLog.DEBUG)
\t\t{
\t\t\tmxLog.writeln.apply(this, arguments);
\t\t}
\t},
\t
\t/**
\t * Function: warn
\t * 
\t * Adds all arguments to the console if <WARN> is enabled.
\t *
\t * Example:
\t * 
\t * (code)
\t * mxLog.show();
\t * mxLog.warn('Hello, World!');
\t * (end)
\t */
\twarn: function()
\t{
\t\tif (mxLog.WARN)
\t\t{
\t\t\tmxLog.writeln.apply(this, arguments);
\t\t}
\t},

\t/**
\t * Function: write
\t * 
\t * Adds the specified strings to the console.
\t */
\twrite: function()
\t{
\t\tvar string = '';
\t\t
\t\tfor (var i = 0; i < arguments.length; i++)
\t\t{
\t\t\tstring += arguments[i];
\t\t\t
\t\t\tif (i < arguments.length - 1)
\t\t\t{
\t\t\t\tstring += ' ';
\t\t\t}
\t\t}
\t\t
\t\tif (mxLog.textarea != null)
\t\t{
\t\t\tmxLog.textarea.value = mxLog.textarea.value + string;

\t\t\t// Workaround for no update in Presto 2.5.22 (Opera 10.5)
\t\t\tif (navigator.userAgent != null &&
\t\t\t\tnavigator.userAgent.indexOf('Presto/2.5') >= 0)
\t\t\t{
\t\t\t\tmxLog.textarea.style.visibility = 'hidden';
\t\t\t\tmxLog.textarea.style.visibility = 'visible';
\t\t\t}
\t\t\t
\t\t\tmxLog.textarea.scrollTop = mxLog.textarea.scrollHeight;
\t\t}
\t\telse
\t\t{
\t\t\tmxLog.buffer += string;
\t\t}
\t},
\t
\t/**
\t * Function: writeln
\t * 
\t * Adds the specified strings to the console, appending a linefeed at the
\t * end of each string.
\t */
\twriteln: function()
\t{
\t\tvar string = '';
\t\t
\t\tfor (var i = 0; i < arguments.length; i++)
\t\t{
\t\t\tstring += arguments[i];
\t\t\t
\t\t\tif (i < arguments.length - 1)
\t\t\t{
\t\t\t\tstring += ' ';
\t\t\t}
\t\t}

\t\tmxLog.write(string + '\\n');
\t}
\t
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxObjectIdentity =
{
\t/**
\t * Class: mxObjectIdentity
\t * 
\t * Identity for JavaScript objects and functions. This is implemented using
\t * a simple incrementing counter which is stored in each object under
\t * <FIELD_NAME>.
\t * 
\t * The identity for an object does not change during its lifecycle.
\t * 
\t * Variable: FIELD_NAME
\t * 
\t * Name of the field to be used to store the object ID. Default is
\t * <code>mxObjectId</code>.
\t */
\tFIELD_NAME: 'mxObjectId',

\t/**
\t * Variable: counter
\t * 
\t * Current counter.
\t */
\tcounter: 0,

\t/**
\t * Function: get
\t * 
\t * Returns the ID for the given object or function or null if no object
\t * is specified.
\t */
\tget: function(obj)
\t{
\t\tif (obj != null)
\t\t{
\t\t\tif (obj[mxObjectIdentity.FIELD_NAME] == null)
\t\t\t{
\t\t\t\tif (typeof obj === 'object')
\t\t\t\t{
\t\t\t\t\tvar ctor = mxUtils.getFunctionName(obj.constructor);
\t\t\t\t\tobj[mxObjectIdentity.FIELD_NAME] = ctor + '#' + mxObjectIdentity.counter++;
\t\t\t\t}
\t\t\t\telse if (typeof obj === 'function')
\t\t\t\t{
\t\t\t\t\tobj[mxObjectIdentity.FIELD_NAME] = 'Function#' + mxObjectIdentity.counter++;
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\treturn obj[mxObjectIdentity.FIELD_NAME];
\t\t}
\t\t
\t\treturn null;
\t},

\t/**
\t * Function: clear
\t * 
\t * Deletes the ID from the given object or function.
\t */
\tclear: function(obj)
\t{
\t\tif (typeof(obj) === 'object' || typeof obj === 'function')
\t\t{
\t\t\tdelete obj[mxObjectIdentity.FIELD_NAME];
\t\t}
\t}

};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxDictionary
 *
 * A wrapper class for an associative array with object keys. Note: This
 * implementation uses <mxObjectIdentitiy> to turn object keys into strings.
 * 
 * Constructor: mxEventSource
 *
 * Constructs a new dictionary which allows object to be used as keys.
 */
function mxDictionary()
{
\tthis.clear();
};

/**
 * Function: map
 *
 * Stores the (key, value) pairs in this dictionary.
 */
mxDictionary.prototype.map = null;

/**
 * Function: clear
 *
 * Clears the dictionary.
 */
mxDictionary.prototype.clear = function()
{
\tthis.map = {};
};

/**
 * Function: get
 *
 * Returns the value for the given key.
 */
mxDictionary.prototype.get = function(key)
{
\tvar id = mxObjectIdentity.get(key);
\t
\treturn this.map[id];
};

/**
 * Function: put
 *
 * Stores the value under the given key and returns the previous
 * value for that key.
 */
mxDictionary.prototype.put = function(key, value)
{
\tvar id = mxObjectIdentity.get(key);
\tvar previous = this.map[id];
\tthis.map[id] = value;
\t
\treturn previous;
};

/**
 * Function: remove
 *
 * Removes the value for the given key and returns the value that
 * has been removed.
 */
mxDictionary.prototype.remove = function(key)
{
\tvar id = mxObjectIdentity.get(key);
\tvar previous = this.map[id];
\tdelete this.map[id];
\t
\treturn previous;
};

/**
 * Function: getKeys
 *
 * Returns all keys as an array.
 */
mxDictionary.prototype.getKeys = function()
{
\tvar result = [];
\t
\tfor (var key in this.map)
\t{
\t\tresult.push(key);
\t}
\t
\treturn result;
};

/**
 * Function: getValues
 *
 * Returns all values as an array.
 */
mxDictionary.prototype.getValues = function()
{
\tvar result = [];
\t
\tfor (var key in this.map)
\t{
\t\tresult.push(this.map[key]);
\t}
\t
\treturn result;
};

/**
 * Function: visit
 *
 * Visits all entries in the dictionary using the given function with the
 * following signature: function(key, value) where key is a string and
 * value is an object.
 * 
 * Parameters:
 * 
 * visitor - A function that takes the key and value as arguments.
 */
mxDictionary.prototype.visit = function(visitor)
{
\tfor (var key in this.map)
\t{
\t\tvisitor(key, this.map[key]);
\t}
};
/**
 * Copyright (c) 2006-2016, JGraph Ltd
 * Copyright (c) 2006-2016, Gaudenz Alder
 */
var mxResources =
{
\t/**
\t * Class: mxResources
\t * 
\t * Implements internationalization. You can provide any number of 
\t * resource files on the server using the following format for the 
\t * filename: name[-en].properties. The en stands for any lowercase 
\t * 2-character language shortcut (eg. de for german, fr for french).
\t *
\t * If the optional language extension is omitted, then the file is used as a 
\t * default resource which is loaded in all cases. If a properties file for a 
\t * specific language exists, then it is used to override the settings in the 
\t * default resource. All entries in the file are of the form key=value. The
\t * values may then be accessed in code via <get>. Lines without 
\t * equal signs in the properties files are ignored.
\t *
\t * Resource files may either be added programmatically using
\t * <add> or via a resource tag in the UI section of the 
\t * editor configuration file, eg:
\t * 
\t * (code)
\t * <mxEditor>
\t *   <ui>
\t *     <resource basename=\"examples/resources/mxWorkflow\"/>
\t * (end)
\t * 
\t * The above element will load examples/resources/mxWorkflow.properties as well
\t * as the language specific file for the current language, if it exists.
\t * 
\t * Values may contain placeholders of the form {1}...{n} where each placeholder
\t * is replaced with the value of the corresponding array element in the params
\t * argument passed to <mxResources.get>. The placeholder {1} maps to the first
\t * element in the array (at index 0).
\t * 
\t * See <mxClient.language> for more information on specifying the default
\t * language or disabling all loading of resources.
\t * 
\t * Lines that start with a # sign will be ignored.
\t * 
\t * Special characters
\t * 
\t * To use unicode characters, use the standard notation (eg. \\u8fd1) or %u as a
\t * prefix (eg. %u20AC will display a Euro sign). For normal hex encoded strings,
\t * use % as a prefix, eg. %F6 will display a \"o umlaut\" (&ouml;).
\t * 
\t * See <resourcesEncoded> to disable this. If you disable this, make sure that
\t * your files are UTF-8 encoded.
\t * 
\t * Asynchronous loading
\t * 
\t * By default, the core adds two resource files synchronously at load time.
\t * To load these files asynchronously, set <mxLoadResources> to false
\t * before loading mxClient.js and use <mxResources.loadResources> instead.
\t * 
\t * Variable: resources
\t * 
\t * Object that maps from keys to values.
\t */
\tresources: {},

\t/**
\t * Variable: extension
\t * 
\t * Specifies the extension used for language files. Default is <mxResourceExtension>.
\t */
\textension: mxResourceExtension,

\t/**
\t * Variable: resourcesEncoded
\t * 
\t * Specifies whether or not values in resource files are encoded with \\u or
\t * percentage. Default is false.
\t */
\tresourcesEncoded: false,

\t/**
\t * Variable: loadDefaultBundle
\t * 
\t * Specifies if the default file for a given basename should be loaded.
\t * Default is true.
\t */
\tloadDefaultBundle: true,

\t/**
\t * Variable: loadDefaultBundle
\t * 
\t * Specifies if the specific language file file for a given basename should
\t * be loaded. Default is true.
\t */
\tloadSpecialBundle: true,

\t/**
\t * Function: isLanguageSupported
\t * 
\t * Hook for subclassers to disable support for a given language. This
\t * implementation returns true if lan is in <mxClient.languages>.
\t * 
\t * Parameters:
\t *
\t * lan - The current language.
\t */
\tisLanguageSupported: function(lan)
\t{
\t\tif (mxClient.languages != null)
\t\t{
\t\t\treturn mxUtils.indexOf(mxClient.languages, lan) >= 0;
\t\t}
\t\t
\t\treturn true;
\t},

\t/**
\t * Function: getDefaultBundle
\t * 
\t * Hook for subclassers to return the URL for the special bundle. This
\t * implementation returns basename + <extension> or null if
\t * <loadDefaultBundle> is false.
\t * 
\t * Parameters:
\t * 
\t * basename - The basename for which the file should be loaded.
\t * lan - The current language.
\t */
\tgetDefaultBundle: function(basename, lan)
\t{
\t\tif (mxResources.loadDefaultBundle || !mxResources.isLanguageSupported(lan))
\t\t{
\t\t\treturn basename + mxResources.extension;
\t\t}
\t\telse
\t\t{
\t\t\treturn null;
\t\t}
\t},

\t/**
\t * Function: getSpecialBundle
\t * 
\t * Hook for subclassers to return the URL for the special bundle. This
\t * implementation returns basename + '_' + lan + <extension> or null if
\t * <loadSpecialBundle> is false or lan equals <mxClient.defaultLanguage>.
\t * 
\t * If <mxResources.languages> is not null and <mxClient.language> contains
\t * a dash, then this method checks if <isLanguageSupported> returns true
\t * for the full language (including the dash). If that returns false the
\t * first part of the language (up to the dash) will be tried as an extension.
\t * 
\t * If <mxResources.language> is null then the first part of the language is
\t * used to maintain backwards compatibility.
\t * 
\t * Parameters:
\t * 
\t * basename - The basename for which the file should be loaded.
\t * lan - The language for which the file should be loaded.
\t */
\tgetSpecialBundle: function(basename, lan)
\t{
\t\tif (mxClient.languages == null || !this.isLanguageSupported(lan))
\t\t{
\t\t\tvar dash = lan.indexOf('-');
\t\t\t
\t\t\tif (dash > 0)
\t\t\t{
\t\t\t\tlan = lan.substring(0, dash);
\t\t\t}
\t\t}

\t\tif (mxResources.loadSpecialBundle && mxResources.isLanguageSupported(lan) && lan != mxClient.defaultLanguage)
\t\t{
\t\t\treturn basename + '_' + lan + mxResources.extension;
\t\t}
\t\telse
\t\t{
\t\t\treturn null;
\t\t}
\t},

\t/**
\t * Function: add
\t * 
\t * Adds the default and current language properties file for the specified
\t * basename. Existing keys are overridden as new files are added. If no
\t * callback is used then the request is synchronous.
\t *
\t * Example:
\t * 
\t * At application startup, additional resources may be 
\t * added using the following code:
\t * 
\t * (code)
\t * mxResources.add('resources/editor');
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * basename - The basename for which the file should be loaded.
\t * lan - The language for which the file should be loaded.
\t * callback - Optional callback for asynchronous loading.
\t */
\tadd: function(basename, lan, callback)
\t{
\t\tlan = (lan != null) ? lan : ((mxClient.language != null) ?
\t\t\tmxClient.language.toLowerCase() : mxConstants.NONE);
\t\t
\t\tif (lan != mxConstants.NONE)
\t\t{
\t\t\tvar defaultBundle = mxResources.getDefaultBundle(basename, lan);
\t\t\tvar specialBundle = mxResources.getSpecialBundle(basename, lan);
\t\t\t
\t\t\tvar loadSpecialBundle = function()
\t\t\t{
\t\t\t\tif (specialBundle != null)
\t\t\t\t{
\t\t\t\t\tif (callback)
\t\t\t\t\t{
\t\t\t\t\t\tmxUtils.get(specialBundle, function(req)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tmxResources.parse(req.getText());
\t\t\t\t\t\t\tcallback();
\t\t\t\t\t\t}, function()
\t\t\t\t\t\t{
\t\t\t\t\t\t\tcallback();
\t\t\t\t\t\t});
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\ttry
\t\t\t\t\t\t{
\t\t\t\t\t   \t\tvar req = mxUtils.load(specialBundle);
\t\t\t\t\t   \t\t
\t\t\t\t\t   \t\tif (req.isReady())
\t\t\t\t\t   \t\t{
\t\t\t\t\t \t   \t\tmxResources.parse(req.getText());
\t\t\t\t\t   \t\t}
\t\t\t\t   \t\t}
\t\t\t\t   \t\tcatch (e)
\t\t\t\t   \t\t{
\t\t\t\t   \t\t\t// ignore
\t\t\t\t\t   \t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse if (callback != null)
\t\t\t\t{
\t\t\t\t\tcallback();
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tif (defaultBundle != null)
\t\t\t{
\t\t\t\tif (callback)
\t\t\t\t{
\t\t\t\t\tmxUtils.get(defaultBundle, function(req)
\t\t\t\t\t{
\t\t\t\t\t\tmxResources.parse(req.getText());
\t\t\t\t\t\tloadSpecialBundle();
\t\t\t\t\t}, function()
\t\t\t\t\t{
\t\t\t\t\t\tloadSpecialBundle();
\t\t\t\t\t});
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\ttry
\t\t\t\t\t{
\t\t\t\t   \t\tvar req = mxUtils.load(defaultBundle);
\t\t\t\t   \t\t
\t\t\t\t   \t\tif (req.isReady())
\t\t\t\t   \t\t{
\t\t\t\t \t   \t\tmxResources.parse(req.getText());
\t\t\t\t   \t\t}
\t\t\t\t   \t\t
\t\t\t\t   \t\tloadSpecialBundle();
\t\t\t\t  \t}
\t\t\t\t  \tcatch (e)
\t\t\t\t  \t{
\t\t\t\t  \t\t// ignore
\t\t\t\t  \t}
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// Overlays the language specific file (_lan-extension)
\t\t\t\tloadSpecialBundle();
\t\t\t}
\t\t}
\t},

\t/**
\t * Function: parse
\t * 
\t * Parses the key, value pairs in the specified
\t * text and stores them as local resources.
\t */
\tparse: function(text)
\t{
\t\tif (text != null)
\t\t{
\t\t\tvar lines = text.split('\\n');
\t\t\t
\t\t\tfor (var i = 0; i < lines.length; i++)
\t\t\t{
\t\t\t\tif (lines[i].charAt(0) != '#')
\t\t\t\t{
\t\t\t\t\tvar index = lines[i].indexOf('=');
\t\t\t\t\t
\t\t\t\t\tif (index > 0)
\t\t\t\t\t{
\t\t\t\t\t\tvar key = lines[i].substring(0, index);
\t\t\t\t\t\tvar idx = lines[i].length;
\t\t\t\t\t\t
\t\t\t\t\t\tif (lines[i].charCodeAt(idx - 1) == 13)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tidx--;
\t\t\t\t\t\t}
\t\t\t\t\t\t
\t\t\t\t\t\tvar value = lines[i].substring(index + 1, idx);
\t\t\t\t\t\t
\t\t\t\t\t\tif (this.resourcesEncoded)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvalue = value.replace(/\\\\(?=u[a-fA-F\\d]{4})/g,\"%\");
\t\t\t\t\t\t\tmxResources.resources[key] = unescape(value);
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\tmxResources.resources[key] = value;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t},

\t/**
\t * Function: get
\t * 
\t * Returns the value for the specified resource key.
\t *
\t * Example:
\t * To read the value for 'welomeMessage', use the following:
\t * (code)
\t * var result = mxResources.get('welcomeMessage') || '';
\t * (end)
\t *
\t * This would require an entry of the following form in
\t * one of the English language resource files:
\t * (code)
\t * welcomeMessage=Welcome to mxGraph!
\t * (end)
\t * 
\t * The part behind the || is the string value to be used if the given
\t * resource is not available.
\t * 
\t * Parameters:
\t * 
\t * key - String that represents the key of the resource to be returned.
\t * params - Array of the values for the placeholders of the form {1}...{n}
\t * to be replaced with in the resulting string.
\t * defaultValue - Optional string that specifies the default return value.
\t */
\tget: function(key, params, defaultValue)
\t{
\t\tvar value = mxResources.resources[key];
\t\t
\t\t// Applies the default value if no resource was found
\t\tif (value == null)
\t\t{
\t\t\tvalue = defaultValue;
\t\t}
\t\t
\t\t// Replaces the placeholders with the values in the array
\t\tif (value != null && params != null)
\t\t{
\t\t\tvalue = mxResources.replacePlaceholders(value, params);
\t\t}
\t\t
\t\treturn value;
\t},

\t/**
\t * Function: replacePlaceholders
\t * 
\t * Replaces the given placeholders with the given parameters.
\t * 
\t * Parameters:
\t * 
\t * value - String that contains the placeholders.
\t * params - Array of the values for the placeholders of the form {1}...{n}
\t * to be replaced with in the resulting string.
\t */
\treplacePlaceholders: function(value, params)
\t{
\t\tvar result = [];
\t\tvar index = null;
\t\t
\t\tfor (var i = 0; i < value.length; i++)
\t\t{
\t\t\tvar c = value.charAt(i);

\t\t\tif (c == '{')
\t\t\t{
\t\t\t\tindex = '';
\t\t\t}
\t\t\telse if (index != null && \tc == '}')
\t\t\t{
\t\t\t\tindex = parseInt(index)-1;
\t\t\t\t
\t\t\t\tif (index >= 0 && index < params.length)
\t\t\t\t{
\t\t\t\t\tresult.push(params[index]);
\t\t\t\t}
\t\t\t\t
\t\t\t\tindex = null;
\t\t\t}
\t\t\telse if (index != null)
\t\t\t{
\t\t\t\tindex += c;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tresult.push(c);
\t\t\t}
\t\t}
\t\t
\t\treturn result.join('');
\t},

\t/**
\t * Function: loadResources
\t * 
\t * Loads all required resources asynchronously. Use this to load the graph and
\t * editor resources if <mxLoadResources> is false.
\t * 
\t * Parameters:
\t * 
\t * callback - Callback function for asynchronous loading.
\t */
\tloadResources: function(callback)
\t{
\t\tmxResources.add(mxClient.basePath+'/resources/editor', null, function()
\t\t{
\t\t\tmxResources.add(mxClient.basePath+'/resources/graph', null, callback);
\t\t});
\t}

};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxPoint
 *
 * Implements a 2-dimensional vector with double precision coordinates.
 * 
 * Constructor: mxPoint
 *
 * Constructs a new point for the optional x and y coordinates. If no
 * coordinates are given, then the default values for <x> and <y> are used.
 */
function mxPoint(x, y)
{
\tthis.x = (x != null) ? x : 0;
\tthis.y = (y != null) ? y : 0;
};

/**
 * Variable: x
 *
 * Holds the x-coordinate of the point. Default is 0.
 */
mxPoint.prototype.x = null;

/**
 * Variable: y
 *
 * Holds the y-coordinate of the point. Default is 0.
 */
mxPoint.prototype.y = null;

/**
 * Function: equals
 * 
 * Returns true if the given object equals this point.
 */
mxPoint.prototype.equals = function(obj)
{
\treturn obj != null && obj.x == this.x && obj.y == this.y;
};

/**
 * Function: clone
 *
 * Returns a clone of this <mxPoint>.
 */
mxPoint.prototype.clone = function()
{
\t// Handles subclasses as well
\treturn mxUtils.clone(this);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxRectangle
 *
 * Extends <mxPoint> to implement a 2-dimensional rectangle with double
 * precision coordinates.
 * 
 * Constructor: mxRectangle
 *
 * Constructs a new rectangle for the optional parameters. If no parameters
 * are given then the respective default values are used.
 */
function mxRectangle(x, y, width, height)
{
\tmxPoint.call(this, x, y);

\tthis.width = (width != null) ? width : 0;
\tthis.height = (height != null) ? height : 0;
};

/**
 * Extends mxPoint.
 */
mxRectangle.prototype = new mxPoint();
mxRectangle.prototype.constructor = mxRectangle;

/**
 * Variable: width
 *
 * Holds the width of the rectangle. Default is 0.
 */
mxRectangle.prototype.width = null;

/**
 * Variable: height
 *
 * Holds the height of the rectangle. Default is 0.
 */
mxRectangle.prototype.height = null;

/**
 * Function: setRect
 * 
 * Sets this rectangle to the specified values
 */
mxRectangle.prototype.setRect = function(x, y, w, h)
{
    this.x = x;
    this.y = y;
    this.width = w;
    this.height = h;
};

/**
 * Function: getCenterX
 * 
 * Returns the x-coordinate of the center point.
 */
mxRectangle.prototype.getCenterX = function ()
{
\treturn this.x + this.width/2;
};

/**
 * Function: getCenterY
 * 
 * Returns the y-coordinate of the center point.
 */
mxRectangle.prototype.getCenterY = function ()
{
\treturn this.y + this.height/2;
};

/**
 * Function: add
 *
 * Adds the given rectangle to this rectangle.
 */
mxRectangle.prototype.add = function(rect)
{
\tif (rect != null)
\t{
\t\tvar minX = Math.min(this.x, rect.x);
\t\tvar minY = Math.min(this.y, rect.y);
\t\tvar maxX = Math.max(this.x + this.width, rect.x + rect.width);
\t\tvar maxY = Math.max(this.y + this.height, rect.y + rect.height);
\t\t
\t\tthis.x = minX;
\t\tthis.y = minY;
\t\tthis.width = maxX - minX;
\t\tthis.height = maxY - minY;
\t}
};

/**
 * Function: intersect
 * 
 * Changes this rectangle to where it overlaps with the given rectangle.
 */
mxRectangle.prototype.intersect = function(rect)
{
\tif (rect != null)
\t{
\t\tvar r1 = this.x + this.width;
\t\tvar r2 = rect.x + rect.width;
\t\t
\t\tvar b1 = this.y + this.height;
\t\tvar b2 = rect.y + rect.height;
\t\t
\t\tthis.x = Math.max(this.x, rect.x);
\t\tthis.y = Math.max(this.y, rect.y);
\t\tthis.width = Math.min(r1, r2) - this.x;
\t\tthis.height = Math.min(b1, b2) - this.y;
\t}
};

/**
 * Function: grow
 *
 * Grows the rectangle by the given amount, that is, this method subtracts
 * the given amount from the x- and y-coordinates and adds twice the amount
 * to the width and height.
 */
mxRectangle.prototype.grow = function(amount)
{
\tthis.x -= amount;
\tthis.y -= amount;
\tthis.width += 2 * amount;
\tthis.height += 2 * amount;
\t
\treturn this;
};

/**
 * Function: getPoint
 * 
 * Returns the top, left corner as a new <mxPoint>.
 */
mxRectangle.prototype.getPoint = function()
{
\treturn new mxPoint(this.x, this.y);
};

/**
 * Function: rotate90
 * 
 * Rotates this rectangle by 90 degree around its center point.
 */
mxRectangle.prototype.rotate90 = function()
{
\tvar t = (this.width - this.height) / 2;
\tthis.x += t;
\tthis.y -= t;
\tvar tmp = this.width;
\tthis.width = this.height;
\tthis.height = tmp;
};

/**
 * Function: equals
 * 
 * Returns true if the given object equals this rectangle.
 */
mxRectangle.prototype.equals = function(obj)
{
\treturn obj != null && obj.x == this.x && obj.y == this.y &&
\t\tobj.width == this.width && obj.height == this.height;
};

/**
 * Function: fromRectangle
 * 
 * Returns a new <mxRectangle> which is a copy of the given rectangle.
 */
mxRectangle.fromRectangle = function(rect)
{
\treturn new mxRectangle(rect.x, rect.y, rect.width, rect.height);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxEffects =
{

\t/**
\t * Class: mxEffects
\t * 
\t * Provides animation effects.
\t */

\t/**
\t * Function: animateChanges
\t * 
\t * Asynchronous animated move operation. See also: <mxMorphing>.
\t * 
\t * Example:
\t * 
\t * (code)
\t * graph.model.addListener(mxEvent.CHANGE, function(sender, evt)
\t * {
\t *   var changes = evt.getProperty('edit').changes;
\t * 
\t *   if (changes.length < 10)
\t *   {
\t *     mxEffects.animateChanges(graph, changes);
\t *   }
\t * });
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * graph - <mxGraph> that received the changes.
\t * changes - Array of changes to be animated.
\t * done - Optional function argument that is invoked after the
\t * last step of the animation.
\t */
\tanimateChanges: function(graph, changes, done)
\t{
\t\tvar maxStep = 10;
\t\tvar step = 0;

\t\tvar animate = function() 
\t\t{
\t\t\tvar isRequired = false;
\t\t\t
\t\t\tfor (var i = 0; i < changes.length; i++)
\t\t\t{
\t\t\t\tvar change = changes[i];
\t\t\t\t
\t\t\t\tif (change instanceof mxGeometryChange ||
\t\t\t\t\tchange instanceof mxTerminalChange ||
\t\t\t\t\tchange instanceof mxValueChange ||
\t\t\t\t\tchange instanceof mxChildChange ||
\t\t\t\t\tchange instanceof mxStyleChange)
\t\t\t\t{
\t\t\t\t\tvar state = graph.getView().getState(change.cell || change.child, false);
\t\t\t\t\t
\t\t\t\t\tif (state != null)
\t\t\t\t\t{
\t\t\t\t\t\tisRequired = true;
\t\t\t\t\t
\t\t\t\t\t\tif (change.constructor != mxGeometryChange || graph.model.isEdge(change.cell))
\t\t\t\t\t\t{
\t\t\t\t\t\t\tmxUtils.setOpacity(state.shape.node, 100 * step / maxStep);
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar scale = graph.getView().scale;\t\t\t\t\t

\t\t\t\t\t\t\tvar dx = (change.geometry.x - change.previous.x) * scale;
\t\t\t\t\t\t\tvar dy = (change.geometry.y - change.previous.y) * scale;
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tvar sx = (change.geometry.width - change.previous.width) * scale;
\t\t\t\t\t\t\tvar sy = (change.geometry.height - change.previous.height) * scale;
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tif (step == 0)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tstate.x -= dx;
\t\t\t\t\t\t\t\tstate.y -= dy;
\t\t\t\t\t\t\t\tstate.width -= sx;
\t\t\t\t\t\t\t\tstate.height -= sy;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\telse
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tstate.x += dx / maxStep;
\t\t\t\t\t\t\t\tstate.y += dy / maxStep;
\t\t\t\t\t\t\t\tstate.width += sx / maxStep;
\t\t\t\t\t\t\t\tstate.height += sy / maxStep;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tgraph.cellRenderer.redraw(state);
\t\t\t\t\t\t\t
\t\t\t\t\t\t\t// Fades all connected edges and children
\t\t\t\t\t\t\tmxEffects.cascadeOpacity(graph, change.cell, 100 * step / maxStep);
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}

\t\t\tif (step < maxStep && isRequired)
\t\t\t{
\t\t\t\tstep++;
\t\t\t\twindow.setTimeout(animate, delay);
\t\t\t}
\t\t\telse if (done != null)
\t\t\t{
\t\t\t\tdone();
\t\t\t}
\t\t};
\t\t
\t\tvar delay = 30;
\t\tanimate();
\t},
    
\t/**
\t * Function: cascadeOpacity
\t * 
\t * Sets the opacity on the given cell and its descendants.
\t * 
\t * Parameters:
\t * 
\t * graph - <mxGraph> that contains the cells.
\t * cell - <mxCell> to set the opacity for.
\t * opacity - New value for the opacity in %.
\t */
    cascadeOpacity: function(graph, cell, opacity)
\t{
\t\t// Fades all children
\t\tvar childCount = graph.model.getChildCount(cell);
\t\t
\t\tfor (var i=0; i<childCount; i++)
\t\t{
\t\t\tvar child = graph.model.getChildAt(cell, i);
\t\t\tvar childState = graph.getView().getState(child);
\t\t\t
\t\t\tif (childState != null)
\t\t\t{
\t\t\t\tmxUtils.setOpacity(childState.shape.node, opacity);
\t\t\t\tmxEffects.cascadeOpacity(graph, child, opacity);
\t\t\t}
\t\t}
\t\t
\t\t// Fades all connected edges
\t\tvar edges = graph.model.getEdges(cell);
\t\t
\t\tif (edges != null)
\t\t{
\t\t\tfor (var i=0; i<edges.length; i++)
\t\t\t{
\t\t\t\tvar edgeState = graph.getView().getState(edges[i]);
\t\t\t\t
\t\t\t\tif (edgeState != null)
\t\t\t\t{
\t\t\t\t\tmxUtils.setOpacity(edgeState.shape.node, opacity);
\t\t\t\t}
\t\t\t}
\t\t}
\t},

\t/**
\t * Function: fadeOut
\t * 
\t * Asynchronous fade-out operation.
\t */
\tfadeOut: function(node, from, remove, step, delay, isEnabled)
\t{
\t\tstep = step || 40;
\t\tdelay = delay || 30;
\t\t
\t\tvar opacity = from || 100;
\t\t
\t\tmxUtils.setOpacity(node, opacity);
\t\t
\t\tif (isEnabled || isEnabled == null)
\t\t{
\t\t\tvar f = function()
\t\t\t{
\t\t\t    opacity = Math.max(opacity-step, 0);
\t\t\t\tmxUtils.setOpacity(node, opacity);
\t\t\t\t
\t\t\t\tif (opacity > 0)
\t\t\t\t{
\t\t\t\t\twindow.setTimeout(f, delay);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tnode.style.visibility = 'hidden';
\t\t\t\t\t
\t\t\t\t\tif (remove && node.parentNode)
\t\t\t\t\t{
\t\t\t\t\t\tnode.parentNode.removeChild(node);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t};
\t\t\twindow.setTimeout(f, delay);
\t\t}
\t\telse
\t\t{
\t\t\tnode.style.visibility = 'hidden';
\t\t\t
\t\t\tif (remove && node.parentNode)
\t\t\t{
\t\t\t\tnode.parentNode.removeChild(node);
\t\t\t}
\t\t}
\t}

};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxUtils =
{
\t/**
\t * Class: mxUtils
\t * 
\t * A singleton class that provides cross-browser helper methods.
\t * This is a global functionality. To access the functions in this
\t * class, use the global classname appended by the functionname.
\t * You may have to load chrome://global/content/contentAreaUtils.js
\t * to disable certain security restrictions in Mozilla for the <open>,
\t * <save>, <saveAs> and <copy> function.
\t * 
\t * For example, the following code displays an error message:
\t * 
\t * (code)
\t * mxUtils.error('Browser is not supported!', 200, false);
\t * (end)
\t * 
\t * Variable: errorResource
\t * 
\t * Specifies the resource key for the title of the error window. If the
\t * resource for this key does not exist then the value is used as
\t * the title. Default is 'error'.
\t */
\terrorResource: (mxClient.language != 'none') ? 'error' : '',
\t
\t/**
\t * Variable: closeResource
\t * 
\t * Specifies the resource key for the label of the close button. If the
\t * resource for this key does not exist then the value is used as
\t * the label. Default is 'close'.
\t */
\tcloseResource: (mxClient.language != 'none') ? 'close' : '',

\t/**
\t * Variable: errorImage
\t * 
\t * Defines the image used for error dialogs.
\t */
\terrorImage: mxClient.imageBasePath + '/error.gif',
\t
\t/**
\t * Function: removeCursors
\t * 
\t * Removes the cursors from the style of the given DOM node and its
\t * descendants.
\t * 
\t * Parameters:
\t * 
\t * element - DOM node to remove the cursor style from.
\t */
\tremoveCursors: function(element)
\t{
\t\tif (element.style != null)
\t\t{
\t\t\telement.style.cursor = '';
\t\t}
\t\t
\t\tvar children = element.childNodes;
\t\t
\t\tif (children != null)
\t\t{
\t        var childCount = children.length;
\t        
\t        for (var i = 0; i < childCount; i += 1)
\t        {
\t            mxUtils.removeCursors(children[i]);
\t        }
\t    }
\t},

\t/**
\t * Function: getCurrentStyle
\t * 
\t * Returns the current style of the specified element.
\t * 
\t * Parameters:
\t * 
\t * element - DOM node whose current style should be returned.
\t */
\tgetCurrentStyle: function()
\t{
\t\tif (mxClient.IS_IE && (document.documentMode == null || document.documentMode < 9))
\t\t{
\t\t\treturn function(element)
\t\t\t{
\t\t\t\treturn (element != null) ? element.currentStyle : null;
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\treturn function(element)
\t\t\t{
\t\t\t\treturn (element != null) ?
\t\t\t\t\twindow.getComputedStyle(element, '') :
\t\t\t\t\tnull;
\t\t\t};
\t\t}
\t}(),
\t
\t/**
\t * Function: parseCssNumber
\t * 
\t * Parses the given CSS numeric value adding handling for the values thin,
\t * medium and thick (2, 4 and 6).
\t */
\tparseCssNumber: function(value)
\t{
\t\tif (value == 'thin')
\t\t{
\t\t\tvalue = '2';
\t\t}
\t\telse if (value == 'medium')
\t\t{
\t\t\tvalue = '4';
\t\t}
\t\telse if (value == 'thick')
\t\t{
\t\t\tvalue = '6';
\t\t}
\t\t
\t\tvalue = parseFloat(value);
\t\t
\t\tif (isNaN(value))
\t\t{
\t\t\tvalue = 0;
\t\t}
\t\t
\t\treturn value;
\t},

\t/**
\t * Function: setPrefixedStyle
\t * 
\t * Adds the given style with the standard name and an optional vendor prefix for the current
\t * browser.
\t * 
\t * (code)
\t * mxUtils.setPrefixedStyle(node.style, 'transformOrigin', '0% 0%');
\t * (end)
\t */
\tsetPrefixedStyle: function()
\t{
\t\tvar prefix = null;
\t\t
\t\tif (mxClient.IS_OT)
\t\t{
\t\t\tprefix = 'O';
\t\t}
\t\telse if (mxClient.IS_SF || mxClient.IS_GC)
\t\t{
\t\t\tprefix = 'Webkit';
\t\t}
\t\telse if (mxClient.IS_MT)
\t\t{
\t\t\tprefix = 'Moz';
\t\t}
\t\telse if (mxClient.IS_IE && document.documentMode >= 9 && document.documentMode < 10)
\t\t{
\t\t\tprefix = 'ms';
\t\t}

\t\treturn function(style, name, value)
\t\t{
\t\t\tstyle[name] = value;
\t\t\t
\t\t\tif (prefix != null && name.length > 0)
\t\t\t{
\t\t\t\tname = prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
\t\t\t\tstyle[name] = value;
\t\t\t}
\t\t};
\t}(),
\t
\t/**
\t * Function: hasScrollbars
\t * 
\t * Returns true if the overflow CSS property of the given node is either
\t * scroll or auto.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node whose style should be checked for scrollbars.
\t */
\thasScrollbars: function(node)
\t{
\t\tvar style = mxUtils.getCurrentStyle(node);

\t\treturn style != null && (style.overflow == 'scroll' || style.overflow == 'auto');
\t},
\t
\t/**
\t * Function: bind
\t * 
\t * Returns a wrapper function that locks the execution scope of the given
\t * function to the specified scope. Inside funct, the \"this\" keyword
\t * becomes a reference to that scope.
\t */
\tbind: function(scope, funct)
\t{
\t\treturn function()
\t\t{
\t\t\treturn funct.apply(scope, arguments);
\t\t};
\t},
\t
\t/**
\t * Function: eval
\t * 
\t * Evaluates the given expression using eval and returns the JavaScript
\t * object that represents the expression result. Supports evaluation of
\t * expressions that define functions and returns the function object for
\t * these expressions.
\t * 
\t * Parameters:
\t * 
\t * expr - A string that represents a JavaScript expression.
\t */
\teval: function(expr)
\t{
\t\tvar result = null;

\t\tif (expr.indexOf('function') >= 0)
\t\t{
\t\t\ttry
\t\t\t{
\t\t\t\teval('var _mxJavaScriptExpression='+expr);
\t\t\t\tresult = _mxJavaScriptExpression;
\t\t\t\t// TODO: Use delete here?
\t\t\t\t_mxJavaScriptExpression = null;
\t\t\t}
\t\t\tcatch (e)
\t\t\t{
\t\t\t\tmxLog.warn(e.message + ' while evaluating ' + expr);
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\ttry
\t\t\t{
\t\t\t\tresult = eval(expr);
\t\t\t}
\t\t\tcatch (e)
\t\t\t{
\t\t\t\tmxLog.warn(e.message + ' while evaluating ' + expr);
\t\t\t}
\t\t}
\t\t
\t\treturn result;
\t},
\t
\t/**
\t * Function: findNode
\t * 
\t * Returns the first node where attr equals value.
\t * This implementation does not use XPath.
\t */
\tfindNode: function(node, attr, value)
\t{
\t\tif (node.nodeType == mxConstants.NODETYPE_ELEMENT)
\t\t{
\t\t\tvar tmp = node.getAttribute(attr);
\t
\t\t\tif (tmp != null && tmp == value)
\t\t\t{
\t\t\t\treturn node;
\t\t\t}
\t\t}
\t\t
\t\tnode = node.firstChild;
\t\t
\t\twhile (node != null)
\t\t{
\t\t\tvar result = mxUtils.findNode(node, attr, value);
\t\t\t
\t\t\tif (result != null)
\t\t\t{
\t\t\t\treturn result;
\t\t\t}
\t\t\t
\t\t\tnode = node.nextSibling;
\t\t}
\t\t
\t\treturn null;
\t},

\t/**
\t * Function: getFunctionName
\t * 
\t * Returns the name for the given function.
\t * 
\t * Parameters:
\t * 
\t * f - JavaScript object that represents a function.
\t */
\tgetFunctionName: function(f)
\t{
\t\tvar str = null;

\t\tif (f != null)
\t\t{
\t\t\tif (f.name != null)
\t\t\t{
\t\t\t\tstr = f.name;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tstr = mxUtils.trim(f.toString());
\t\t\t\t
\t\t\t\tif (/^function\\s/.test(str))
\t\t\t\t{
\t\t\t\t\tstr = mxUtils.ltrim(str.substring(9));
\t\t\t\t\tvar idx2 = str.indexOf('(');
\t\t\t\t\t
\t\t\t\t\tif (idx2 > 0)
\t\t\t\t\t{
\t\t\t\t\t\tstr = str.substring(0, idx2);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn str;
\t},

\t/**
\t * Function: indexOf
\t * 
\t * Returns the index of obj in array or -1 if the array does not contain
\t * the given object.
\t * 
\t * Parameters:
\t * 
\t * array - Array to check for the given obj.
\t * obj - Object to find in the given array.
\t */
\tindexOf: function(array, obj)
\t{
\t\tif (array != null && obj != null)
\t\t{
\t\t\tfor (var i = 0; i < array.length; i++)
\t\t\t{
\t\t\t\tif (array[i] == obj)
\t\t\t\t{
\t\t\t\t\treturn i;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn -1;
\t},

\t/**
\t * Function: forEach
\t * 
\t * Calls the given function for each element of the given array and returns
\t * the array.
\t * 
\t * Parameters:
\t * 
\t * array - Array that contains the elements.
\t * fn - Function to be called for each object.
\t */
\tforEach: function(array, fn)
\t{
\t\tif (array != null && fn != null)
\t\t{
\t\t\tfor (var i = 0; i < array.length; i++)
\t\t\t{
\t\t\t\tfn(array[i]);
\t\t\t}
\t\t}
\t\t
\t\treturn array;
\t},

\t/**
\t * Function: remove
\t * 
\t * Removes all occurrences of the given object in the given array or
\t * object. If there are multiple occurrences of the object, be they
\t * associative or as an array entry, all occurrences are removed from
\t * the array or deleted from the object. By removing the object from
\t * the array, all elements following the removed element are shifted
\t * by one step towards the beginning of the array.
\t * 
\t * The length of arrays is not modified inside this function.
\t * 
\t * Parameters:
\t * 
\t * obj - Object to find in the given array.
\t * array - Array to check for the given obj.
\t */
\tremove: function(obj, array)
\t{
\t\tvar result = null;
\t\t
\t\tif (typeof(array) == 'object')
\t\t{
\t\t\tvar index = mxUtils.indexOf(array, obj);
\t\t\t
\t\t\twhile (index >= 0)
\t\t\t{
\t\t\t\tarray.splice(index, 1);
\t\t\t\tresult = obj;
\t\t\t\tindex = mxUtils.indexOf(array, obj);
\t\t\t}
\t\t}

\t\tfor (var key in array)
\t\t{
\t\t\tif (array[key] == obj)
\t\t\t{
\t\t\t\tdelete array[key];
\t\t\t\tresult = obj;
\t\t\t}
\t\t}
\t\t
\t\treturn result;
\t},
\t
\t/**
\t * Function: isNode
\t * 
\t * Returns true if the given value is an XML node with the node name
\t * and if the optional attribute has the specified value.
\t * 
\t * This implementation assumes that the given value is a DOM node if the
\t * nodeType property is numeric, that is, if isNaN returns false for
\t * value.nodeType.
\t * 
\t * Parameters:
\t * 
\t * value - Object that should be examined as a node.
\t * nodeName - String that specifies the node name.
\t * attributeName - Optional attribute name to check.
\t * attributeValue - Optional attribute value to check.
\t */
\t isNode: function(value, nodeName, attributeName, attributeValue)
\t {
\t \tif (value != null && !isNaN(value.nodeType) && (nodeName == null ||
\t \t\tvalue.nodeName.toLowerCase() == nodeName.toLowerCase()))
 \t\t{
 \t\t\treturn attributeName == null ||
 \t\t\t\tvalue.getAttribute(attributeName) == attributeValue;
 \t\t}
\t \t
\t \treturn false;
\t },
\t
\t/**
\t * Function: isAncestorNode
\t * 
\t * Returns true if the given ancestor is an ancestor of the
\t * given DOM node in the DOM. This also returns true if the
\t * child is the ancestor.
\t * 
\t * Parameters:
\t * 
\t * ancestor - DOM node that represents the ancestor.
\t * child - DOM node that represents the child.
\t */
\t isAncestorNode: function(ancestor, child)
\t {
\t \tvar parent = child;
\t \t
\t \twhile (parent != null)
\t \t{
\t \t\tif (parent == ancestor)
\t \t\t{
\t \t\t\treturn true;
\t \t\t}

\t \t\tparent = parent.parentNode;
\t \t}
\t \t
\t \treturn false;
\t },

\t/**
\t * Function: getChildNodes
\t * 
\t * Returns an array of child nodes that are of the given node type.
\t * 
\t * Parameters:
\t * 
\t * node - Parent DOM node to return the children from.
\t * nodeType - Optional node type to return. Default is
\t * <mxConstants.NODETYPE_ELEMENT>.
\t */
\tgetChildNodes: function(node, nodeType)
\t{
\t\tnodeType = nodeType || mxConstants.NODETYPE_ELEMENT;
\t\t
\t\tvar children = [];
\t\tvar tmp = node.firstChild;
\t\t
\t\twhile (tmp != null)
\t\t{
\t\t\tif (tmp.nodeType == nodeType)
\t\t\t{
\t\t\t\tchildren.push(tmp);
\t\t\t}
\t\t\t
\t\t\ttmp = tmp.nextSibling;
\t\t}
\t\t
\t\treturn children;
\t},

\t/**
\t * Function: importNode
\t * 
\t * Cross browser implementation for document.importNode. Uses document.importNode
\t * in all browsers but IE, where the node is cloned by creating a new node and
\t * copying all attributes and children into it using importNode, recursively.
\t * 
\t * Parameters:
\t * 
\t * doc - Document to import the node into.
\t * node - Node to be imported.
\t * allChildren - If all children should be imported.
\t */
\timportNode: function(doc, node, allChildren)
\t{
\t\tif (mxClient.IS_IE && (document.documentMode == null || document.documentMode < 10))
\t\t{
\t\t\treturn mxUtils.importNodeImplementation(doc, node, allChildren);
\t\t}
\t\telse
\t\t{
\t\t\treturn doc.importNode(node, allChildren);
\t\t}
\t},

\t/**
\t * Function: importNodeImplementation
\t * 
\t * Full DOM API implementation for importNode without using importNode API call.
\t * 
\t * Parameters:
\t * 
\t * doc - Document to import the node into.
\t * node - Node to be imported.
\t * allChildren - If all children should be imported.
\t */
\timportNodeImplementation: function(doc, node, allChildren)
\t{
\t\tswitch (node.nodeType)
\t\t{
\t\t\tcase 1: /* element */
\t\t\t{
\t\t\t\tvar newNode = doc.createElement(node.nodeName);
\t\t\t\t
\t\t\t\tif (node.attributes && node.attributes.length > 0)
\t\t\t\t{
\t\t\t\t\tfor (var i = 0; i < node.attributes.length; i++)
\t\t\t\t\t{
\t\t\t\t\t\tnewNode.setAttribute(node.attributes[i].nodeName,
\t\t\t\t\t\t\tnode.getAttribute(node.attributes[i].nodeName));
\t\t\t\t\t}\t
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (allChildren && node.childNodes && node.childNodes.length > 0)
\t\t\t\t{
\t\t\t\t\tfor (var i = 0; i < node.childNodes.length; i++)
\t\t\t\t\t{
\t\t\t\t\t\tnewNode.appendChild(mxUtils.importNodeImplementation(doc, node.childNodes[i], allChildren));
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\treturn newNode;
\t\t\t\tbreak;
\t\t\t}
\t\t\tcase 3: /* text */
\t\t    case 4: /* cdata-section */
\t\t    case 8: /* comment */
\t\t    {
\t\t    \treturn doc.createTextNode((node.nodeValue != null) ? node.nodeValue : node.value);
\t\t    \tbreak;
\t\t    }
\t\t};
\t},

\t/**
\t * Function: createXmlDocument
\t * 
\t * Returns a new, empty XML document.
\t */
\tcreateXmlDocument: function()
\t{
\t\tvar doc = null;
\t\t
\t\tif (document.implementation && document.implementation.createDocument)
\t\t{
\t\t\tdoc = document.implementation.createDocument('', '', null);
\t\t}
\t\telse if (\"ActiveXObject\" in window)
\t\t{
\t\t\tdoc = mxUtils.createMsXmlDocument();
\t \t}
\t \t
\t \treturn doc;
\t},

\t/**
\t * Function: createMsXmlDocument
\t * 
\t * Returns a new, empty Microsoft.XMLDOM document using ActiveXObject.
\t */
\tcreateMsXmlDocument: function()
\t{
\t\tvar doc = new ActiveXObject('Microsoft.XMLDOM');
\t\tdoc.async = false;

\t\t// Workaround for parsing errors with SVG DTD
\t\tdoc.validateOnParse = false;
\t\tdoc.resolveExternals = false;
\t \t
\t \treturn doc;
\t},

\t/**
\t * Function: parseXml
\t * 
\t * Parses the specified XML string into a new XML document and returns the
\t * new document.
\t * 
\t * Example:
\t * 
\t * (code)
\t * var doc = mxUtils.parseXml(
\t *   '<mxGraphModel><root><MyDiagram id=\"0\"><mxCell/></MyDiagram>'+
\t *   '<MyLayer id=\"1\"><mxCell parent=\"0\" /></MyLayer><MyObject id=\"2\">'+
\t *   '<mxCell style=\"strokeColor=blue;fillColor=red\" parent=\"1\" vertex=\"1\">'+
\t *   '<mxGeometry x=\"10\" y=\"10\" width=\"80\" height=\"30\" as=\"geometry\"/>'+
\t *   '</mxCell></MyObject></root></mxGraphModel>');
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * xml - String that contains the XML data.
\t */
\tparseXml: function()
\t{
\t\tif (window.DOMParser)
\t\t{
\t\t\treturn function(xml)
\t\t\t{
\t\t\t\tvar parser = new DOMParser();
\t\t\t\t
\t\t\t\treturn parser.parseFromString(xml, 'text/xml');
\t\t\t};
\t\t}
\t\telse // IE<=9
\t\t{
\t\t\treturn function(xml)
\t\t\t{
\t\t\t\tvar doc = mxUtils.createMsXmlDocument();
\t\t\t\tdoc.loadXML(xml);
\t\t\t\t
\t\t\t\treturn doc;
\t\t\t};
\t\t}
\t}(),

\t/**
\t * Function: clearSelection
\t * 
\t * Clears the current selection in the page.
\t */
\tclearSelection: function()
\t{
\t\tif (document.selection)
\t\t{
\t\t\treturn function()
\t\t\t{
\t\t\t\tdocument.selection.empty();
\t\t\t};
\t\t}
\t\telse if (window.getSelection)
\t\t{
\t\t\treturn function()
\t\t\t{
\t\t\t\tif (window.getSelection().empty)
\t\t\t\t{
\t\t\t\t\twindow.getSelection().empty();
\t\t\t\t}
\t\t\t\telse if (window.getSelection().removeAllRanges)
\t\t\t\t{
\t\t\t\t\twindow.getSelection().removeAllRanges();
\t\t\t\t}
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\treturn function() { };
\t\t}
\t}(),

\t/**
\t * Function: removeWhitespace
\t * 
\t * Removes the sibling text nodes for the given node that only consists
\t * of tabs, newlines and spaces.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node whose siblings should be removed.
\t * before - Optional boolean that specifies the direction of the traversal.
\t */
\tremoveWhitespace: function(node, before)
\t{
\t\tvar tmp = (before) ? node.previousSibling : node.nextSibling;
\t\t
\t\twhile (tmp != null && tmp.nodeType == mxConstants.NODETYPE_TEXT)
\t\t{
\t\t\tvar next = (before) ? tmp.previousSibling : tmp.nextSibling;
\t\t\tvar text = mxUtils.getTextContent(tmp);
\t\t\t
\t\t\tif (mxUtils.trim(text).length == 0)
\t\t\t{
\t\t\t\ttmp.parentNode.removeChild(tmp);
\t\t\t}
\t\t\t
\t\t\ttmp = next;
\t\t}
\t},
\t
\t/**
\t * Function: htmlEntities
\t * 
\t * Replaces characters (less than, greater than, newlines and quotes) with
\t * their HTML entities in the given string and returns the result.
\t * 
\t * Parameters:
\t * 
\t * s - String that contains the characters to be converted.
\t * newline - If newlines should be replaced. Default is true.
\t */
\thtmlEntities: function(s, newline)
\t{
\t\ts = String(s || '');
\t\t
\t\ts = s.replace(/&/g,'&amp;'); // 38 26
\t\ts = s.replace(/\"/g,'&quot;'); // 34 22
\t\ts = s.replace(/\\'/g,'&#39;'); // 39 27
\t\ts = s.replace(/</g,'&lt;'); // 60 3C
\t\ts = s.replace(/>/g,'&gt;'); // 62 3E

\t\tif (newline == null || newline)
\t\t{
\t\t\ts = s.replace(/\\n/g, '&#xa;');
\t\t}
\t\t
\t\treturn s;
\t},
\t
\t/**
\t * Function: isVml
\t * 
\t * Returns true if the given node is in the VML namespace.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node whose tag urn should be checked.
\t */
\tisVml: function(node)
\t{
\t\treturn node != null && node.tagUrn == 'urn:schemas-microsoft-com:vml';
\t},

\t/**
\t * Function: getXml
\t * 
\t * Returns the XML content of the specified node. For Internet Explorer,
\t * all \\r\\n\\t[\\t]* are removed from the XML string and the remaining \\r\\n
\t * are replaced by \\n. All \\n are then replaced with linefeed, or &#xa; if
\t * no linefeed is defined.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to return the XML for.
\t * linefeed - Optional string that linefeeds are converted into. Default is
\t * &#xa;
\t */
\tgetXml: function(node, linefeed)
\t{
\t\tvar xml = '';
\t\t
\t\tif (mxClient.IS_IE || mxClient.IS_IE11)
\t\t{
\t\t\txml = mxUtils.getPrettyXml(node, '', '', '');
\t\t}
\t\telse if (window.XMLSerializer != null)
\t\t{
\t\t\tvar xmlSerializer = new XMLSerializer();
\t\t\txml = xmlSerializer.serializeToString(node);     
\t\t}
\t\telse if (node.xml != null)
\t\t{
\t\t\txml = node.xml.replace(/\\r\\n\\t[\\t]*/g, '').
\t\t\t\treplace(/>\\r\\n/g, '>').
\t\t\t\treplace(/\\r\\n/g, '\\n');
\t\t}

\t\t// Replaces linefeeds with HTML Entities.
\t\tlinefeed = linefeed || '&#xa;';
\t\txml = xml.replace(/\\n/g, linefeed);
\t\t  
\t\treturn xml;
\t},
\t
\t/**
\t * Function: getPrettyXML
\t * 
\t * Returns a pretty printed string that represents the XML tree for the
\t * given node. This method should only be used to print XML for reading,
\t * use <getXml> instead to obtain a string for processing.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to return the XML for.
\t * tab - Optional string that specifies the indentation for one level.
\t * Default is two spaces.
\t * indent - Optional string that represents the current indentation.
\t * Default is an empty string.
\t * newline - Option string that represents a linefeed. Default is '\\n'.
\t */
\tgetPrettyXml: function(node, tab, indent, newline, ns)
\t{
\t\tvar result = [];
\t\t
\t\tif (node != null)
\t\t{
\t\t\ttab = (tab != null) ? tab : '  ';
\t\t\tindent = (indent != null) ? indent : '';
\t\t\tnewline = (newline != null) ? newline : '\\n';
\t\t\t
\t\t\tif (node.namespaceURI != null && node.namespaceURI != ns)
\t\t\t{
\t\t\t\tns = node.namespaceURI;
\t\t\t\t
\t\t\t\tif (node.getAttribute('xmlns') == null)
\t\t\t\t{
\t\t\t\t\tnode.setAttribute('xmlns', node.namespaceURI);
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tif (node.nodeType == mxConstants.NODETYPE_DOCUMENT)
\t\t\t{
\t\t\t\tresult.push(mxUtils.getPrettyXml(node.documentElement, tab, indent, newline, ns));
\t\t\t}
\t\t\telse if (node.nodeType == mxConstants.NODETYPE_DOCUMENT_FRAGMENT)
\t\t\t{
\t\t\t\tvar tmp = node.firstChild;
\t\t\t\t
\t\t\t\tif (tmp != null)
\t\t\t\t{
\t\t\t\t\twhile (tmp != null)
\t\t\t\t\t{
\t\t\t\t\t\tresult.push(mxUtils.getPrettyXml(tmp, tab, indent, newline, ns));
\t\t\t\t\t\ttmp = tmp.nextSibling;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t\telse if (node.nodeType == mxConstants.NODETYPE_COMMENT)
\t\t\t{
\t\t\t\tvar value = mxUtils.getTextContent(node);
\t\t\t\t
\t\t\t\tif (value.length > 0)
\t\t\t\t{
\t\t\t\t\tresult.push(indent + '<!--' + value + '-->' + newline);
\t\t\t\t}
\t\t\t}
\t\t\telse if (node.nodeType == mxConstants.NODETYPE_TEXT)
\t\t\t{
\t\t\t\tvar value = mxUtils.trim(mxUtils.getTextContent(node));
\t\t\t\t
\t\t\t\tif (value.length > 0)
\t\t\t\t{
\t\t\t\t\tresult.push(indent + mxUtils.htmlEntities(value, false) + newline);
\t\t\t\t}
\t\t\t}
\t\t\telse if (node.nodeType == mxConstants.NODETYPE_CDATA)
\t\t\t{
\t\t\t\tvar value = mxUtils.getTextContent(node);
\t\t\t\t
\t\t\t\tif (value.length > 0)
\t\t\t\t{
\t\t\t\t\tresult.push(indent + '<![CDATA[' + value + ']]' + newline);
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tresult.push(indent + '<' + node.nodeName);
\t\t\t\t
\t\t\t\t// Creates the string with the node attributes
\t\t\t\t// and converts all HTML entities in the values
\t\t\t\tvar attrs = node.attributes;
\t\t\t\t
\t\t\t\tif (attrs != null)
\t\t\t\t{
\t\t\t\t\tfor (var i = 0; i < attrs.length; i++)
\t\t\t\t\t{
\t\t\t\t\t\tvar val = mxUtils.htmlEntities(attrs[i].value);
\t\t\t\t\t\tresult.push(' ' + attrs[i].nodeName + '=\"' + val + '\"');
\t\t\t\t\t}
\t\t\t\t}

\t\t\t\t// Recursively creates the XML string for each child
\t\t\t\t// node and appends it here with an indentation
\t\t\t\tvar tmp = node.firstChild;
\t\t\t\t
\t\t\t\tif (tmp != null)
\t\t\t\t{
\t\t\t\t\tresult.push('>' + newline);
\t\t\t\t\t
\t\t\t\t\twhile (tmp != null)
\t\t\t\t\t{
\t\t\t\t\t\tresult.push(mxUtils.getPrettyXml(tmp, tab, indent + tab, newline, ns));
\t\t\t\t\t\ttmp = tmp.nextSibling;
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tresult.push(indent + '</'+ node.nodeName + '>' + newline);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tresult.push(' />' + newline);
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn result.join('');
\t},
\t
\t/**
\t * Function: extractTextWithWhitespace
\t * 
\t * Returns the text content of the specified node.
\t * 
\t * Parameters:
\t * 
\t * elems - DOM nodes to return the text for.
\t */
\textractTextWithWhitespace: function(elems)
\t{
\t    // Known block elements for handling linefeeds (list is not complete)
\t\tvar blocks = ['BLOCKQUOTE', 'DIV', 'H1', 'H2', 'H3', 'H4', 'H5', 'H6', 'OL', 'P', 'PRE', 'TABLE', 'UL'];
\t\tvar ret = [];
\t\t
\t\tfunction doExtract(elts)
\t\t{
\t\t\t// Single break should be ignored
\t\t\tif (elts.length == 1 && (elts[0].nodeName == 'BR' ||
\t\t\t\telts[0].innerHTML == '\\n'))
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t    for (var i = 0; i < elts.length; i++)
\t\t    {
\t\t        var elem = elts[i];

\t\t\t\t// DIV with a br or linefeed forces a linefeed
\t\t\t\tif (elem.nodeName == 'BR' || elem.innerHTML == '\\n' ||
\t\t\t\t\t((elts.length == 1 || i == 0) && (elem.nodeName == 'DIV' &&
\t\t\t\t\telem.innerHTML.toLowerCase() == '<br>')))
\t\t    \t{
\t    \t\t\tret.push('\\n');
\t\t    \t}
\t\t\t\telse
\t\t\t\t{
\t\t\t        if (elem.nodeType === 3 || elem.nodeType === 4)
\t\t\t        {
\t\t\t        \tif (elem.nodeValue.length > 0)
\t\t\t        \t{
\t\t\t        \t\tret.push(elem.nodeValue);
\t\t\t        \t}
\t\t\t        }
\t\t\t        else if (elem.nodeType !== 8 && elem.childNodes.length > 0)
\t\t\t\t\t{
\t\t\t\t\t\tdoExtract(elem.childNodes);
\t\t\t\t\t}
\t\t\t        
\t        \t\tif (i < elts.length - 1 && mxUtils.indexOf(blocks, elts[i + 1].nodeName) >= 0)
\t        \t\t{
\t        \t\t\tret.push('\\n');\t\t
\t        \t\t}
\t\t\t\t}
\t\t    }
\t\t};
\t\t
\t\tdoExtract(elems);
\t    
\t    return ret.join('');
\t},

\t/**
\t * Function: replaceTrailingNewlines
\t * 
\t * Replaces each trailing newline with the given pattern.
\t */
\treplaceTrailingNewlines: function(str, pattern)
\t{
\t\t// LATER: Check is this can be done with a regular expression
\t\tvar postfix = '';
\t\t
\t\twhile (str.length > 0 && str.charAt(str.length - 1) == '\\n')
\t\t{
\t\t\tstr = str.substring(0, str.length - 1);
\t\t\tpostfix += pattern;
\t\t}
\t\t
\t\treturn str + postfix;
\t},

\t/**
\t * Function: getTextContent
\t * 
\t * Returns the text content of the specified node.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to return the text content for.
\t */
\tgetTextContent: function(node)
\t{
\t\t// Only IE10-
\t\tif (mxClient.IS_IE && node.innerText !== undefined)
\t\t{
\t\t\treturn node.innerText;
\t\t}
\t\telse
\t\t{
\t\t\treturn (node != null) ? node[(node.textContent === undefined) ? 'text' : 'textContent'] : '';
\t\t}
\t},
\t
\t/**
\t * Function: setTextContent
\t * 
\t * Sets the text content of the specified node.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to set the text content for.
\t * text - String that represents the text content.
\t */
\tsetTextContent: function(node, text)
\t{
\t\tif (node.innerText !== undefined)
\t\t{
\t\t\tnode.innerText = text;
\t\t}
\t\telse
\t\t{
\t\t\tnode[(node.textContent === undefined) ? 'text' : 'textContent'] = text;
\t\t}
\t},
\t
\t/**
\t * Function: getInnerHtml
\t * 
\t * Returns the inner HTML for the given node as a string or an empty string
\t * if no node was specified. The inner HTML is the text representing all
\t * children of the node, but not the node itself.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to return the inner HTML for.
\t */
\tgetInnerHtml: function()
\t{
\t\tif (mxClient.IS_IE)
\t\t{
\t\t\treturn function(node)
\t\t\t{
\t\t\t\tif (node != null)
\t\t\t\t{
\t\t\t\t\treturn node.innerHTML;
\t\t\t\t}
\t\t\t\t
\t\t\t\treturn '';
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\treturn function(node)
\t\t\t{
\t\t\t\tif (node != null)
\t\t\t\t{
\t\t\t\t\tvar serializer = new XMLSerializer();
\t\t\t\t\treturn serializer.serializeToString(node);
\t\t\t\t}
\t\t\t\t
\t\t\t\treturn '';
\t\t\t};
\t\t}
\t}(),

\t/**
\t * Function: getOuterHtml
\t * 
\t * Returns the outer HTML for the given node as a string or an empty
\t * string if no node was specified. The outer HTML is the text representing
\t * all children of the node including the node itself.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to return the outer HTML for.
\t */
\tgetOuterHtml: function()
\t{
\t\tif (mxClient.IS_IE)
\t\t{
\t\t\treturn function(node)
\t\t\t{
\t\t\t\tif (node != null)
\t\t\t\t{
\t\t\t\t\tif (node.outerHTML != null)
\t\t\t\t\t{
\t\t\t\t\t\treturn node.outerHTML;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tvar tmp = [];
\t\t\t\t\t\ttmp.push('<'+node.nodeName);
\t\t\t\t\t\t
\t\t\t\t\t\tvar attrs = node.attributes;
\t\t\t\t\t\t
\t\t\t\t\t\tif (attrs != null)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tfor (var i = 0; i < attrs.length; i++)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tvar value = attrs[i].value;
\t\t\t\t\t\t\t\t
\t\t\t\t\t\t\t\tif (value != null && value.length > 0)
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\ttmp.push(' ');
\t\t\t\t\t\t\t\t\ttmp.push(attrs[i].nodeName);
\t\t\t\t\t\t\t\t\ttmp.push('=\"');
\t\t\t\t\t\t\t\t\ttmp.push(value);
\t\t\t\t\t\t\t\t\ttmp.push('\"');
\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t}
\t\t\t\t\t\t}
\t\t\t\t\t\t
\t\t\t\t\t\tif (node.innerHTML.length == 0)
\t\t\t\t\t\t{
\t\t\t\t\t\t\ttmp.push('/>');
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\ttmp.push('>');
\t\t\t\t\t\t\ttmp.push(node.innerHTML);
\t\t\t\t\t\t\ttmp.push('</'+node.nodeName+'>');
\t\t\t\t\t\t}
\t\t\t\t\t\t
\t\t\t\t\t\treturn tmp.join('');
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\treturn '';
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\treturn function(node)
\t\t\t{
\t\t\t\tif (node != null)
\t\t\t\t{
\t\t\t\t\tvar serializer = new XMLSerializer();
\t\t\t\t\treturn serializer.serializeToString(node);
\t\t\t\t}
\t\t\t\t
\t\t\t\treturn '';
\t\t\t};
\t\t}
\t}(),
\t
\t/**
\t * Function: write
\t * 
\t * Creates a text node for the given string and appends it to the given
\t * parent. Returns the text node.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to append the text node to.
\t * text - String representing the text to be added.
\t */
\twrite: function(parent, text)
\t{
\t\tvar doc = parent.ownerDocument;
\t\tvar node = doc.createTextNode(text);
\t\t
\t\tif (parent != null)
\t\t{
\t\t\tparent.appendChild(node);
\t\t}
\t\t
\t\treturn node;
\t},
\t
\t/**
\t * Function: writeln
\t * 
\t * Creates a text node for the given string and appends it to the given
\t * parent with an additional linefeed. Returns the text node.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to append the text node to.
\t * text - String representing the text to be added.
\t */
\twriteln: function(parent, text)
\t{
\t\tvar doc = parent.ownerDocument;
\t\tvar node = doc.createTextNode(text);
\t\t
\t\tif (parent != null)
\t\t{
\t\t\tparent.appendChild(node);
\t\t\tparent.appendChild(document.createElement('br'));
\t\t}
\t\t
\t\treturn node;
\t},
\t
\t/**
\t * Function: br
\t * 
\t * Appends a linebreak to the given parent and returns the linebreak.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to append the linebreak to.
\t */
\tbr: function(parent, count)
\t{
\t\tcount = count || 1;
\t\tvar br = null;
\t\t
\t\tfor (var i = 0; i < count; i++)
\t\t{
\t\t\tif (parent != null)
\t\t\t{
\t\t\t\tbr = parent.ownerDocument.createElement('br');
\t\t\t\tparent.appendChild(br);
\t\t\t}
\t\t}
\t\t
\t\treturn br;
\t},
\t\t
\t/**
\t * Function: button
\t * 
\t * Returns a new button with the given level and function as an onclick
\t * event handler.
\t * 
\t * (code)
\t * document.body.appendChild(mxUtils.button('Test', function(evt)
\t * {
\t *   alert('Hello, World!');
\t * }));
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * label - String that represents the label of the button.
\t * funct - Function to be called if the button is pressed.
\t * doc - Optional document to be used for creating the button. Default is the
\t * current document.
\t */
\tbutton: function(label, funct, doc)
\t{
\t\tdoc = (doc != null) ? doc : document;
\t\t
\t\tvar button = doc.createElement('button');
\t\tmxUtils.write(button, label);

\t\tmxEvent.addListener(button, 'click', function(evt)
\t\t{
\t\t\tfunct(evt);
\t\t});
\t\t
\t\treturn button;
\t},
\t
\t/**
\t * Function: para
\t * 
\t * Appends a new paragraph with the given text to the specified parent and
\t * returns the paragraph.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to append the text node to.
\t * text - String representing the text for the new paragraph.
\t */
\tpara: function(parent, text)
\t{
\t\tvar p = document.createElement('p');
\t\tmxUtils.write(p, text);

\t\tif (parent != null)
\t\t{
\t\t\tparent.appendChild(p);
\t\t}
\t\t
\t\treturn p;
\t},

\t/**
\t * Function: addTransparentBackgroundFilter
\t * 
\t * Adds a transparent background to the filter of the given node. This
\t * background can be used in IE8 standards mode (native IE8 only) to pass
\t * events through the node.
\t */
\taddTransparentBackgroundFilter: function(node)
\t{
\t\tnode.style.filter += 'progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\\'' +
\t\t\tmxClient.imageBasePath + '/transparent.gif\\', sizingMethod=\\'scale\\')';
\t},

\t/**
\t * Function: linkAction
\t * 
\t * Adds a hyperlink to the specified parent that invokes action on the
\t * specified editor.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to contain the new link.
\t * text - String that is used as the link label.
\t * editor - <mxEditor> that will execute the action.
\t * action - String that defines the name of the action to be executed.
\t * pad - Optional left-padding for the link. Default is 0.
\t */
\tlinkAction: function(parent, text, editor, action, pad)
\t{
\t\treturn mxUtils.link(parent, text, function()
\t\t{
\t\t\teditor.execute(action);
\t\t}, pad);
\t},

\t/**
\t * Function: linkInvoke
\t * 
\t * Adds a hyperlink to the specified parent that invokes the specified
\t * function on the editor passing along the specified argument. The
\t * function name is the name of a function of the editor instance,
\t * not an action name.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to contain the new link.
\t * text - String that is used as the link label.
\t * editor - <mxEditor> instance to execute the function on.
\t * functName - String that represents the name of the function.
\t * arg - Object that represents the argument to the function.
\t * pad - Optional left-padding for the link. Default is 0.
\t */
\tlinkInvoke: function(parent, text, editor, functName, arg, pad)
\t{
\t\treturn mxUtils.link(parent, text, function()
\t\t{
\t\t\teditor[functName](arg);
\t\t}, pad);
\t},
\t
\t/**
\t * Function: link
\t * 
\t * Adds a hyperlink to the specified parent and invokes the given function
\t * when the link is clicked.
\t * 
\t * Parameters:
\t * 
\t * parent - DOM node to contain the new link.
\t * text - String that is used as the link label.
\t * funct - Function to execute when the link is clicked.
\t * pad - Optional left-padding for the link. Default is 0.
\t */
\tlink: function(parent, text, funct, pad)
\t{
\t\tvar a = document.createElement('span');
\t\t
\t\ta.style.color = 'blue';
\t\ta.style.textDecoration = 'underline';
\t\ta.style.cursor = 'pointer';
\t\t
\t\tif (pad != null)
\t\t{
\t\t\ta.style.paddingLeft = pad+'px';
\t\t}
\t\t
\t\tmxEvent.addListener(a, 'click', funct);
\t\tmxUtils.write(a, text);
\t\t
\t\tif (parent != null)
\t\t{
\t\t\tparent.appendChild(a);
\t\t}
\t\t
\t\treturn a;
\t},

\t/**
\t * Function: getDocumentSize
\t * 
\t * Returns the client size for the current document as an <mxRectangle>.
\t */
\tgetDocumentSize: function()
\t{
\t\tvar b = document.body;
\t\tvar d = document.documentElement;
\t\t
\t\ttry
\t\t{
\t\t\treturn new mxRectangle(0, 0, b.clientWidth || d.clientWidth, Math.max(b.clientHeight || 0, d.clientHeight));
\t\t}
\t\tcatch (e)
\t\t{
\t\t\treturn new mxRectangle();
\t\t}
\t},
\t
\t/**
\t * Function: fit
\t * 
\t * Makes sure the given node is inside the visible area of the window. This
\t * is done by setting the left and top in the style. 
\t */
\tfit: function(node)
\t{
\t\tvar ds = mxUtils.getDocumentSize();
\t\tvar left = parseInt(node.offsetLeft);
\t\tvar width = parseInt(node.offsetWidth);
\t\t\t
\t\tvar offset = mxUtils.getDocumentScrollOrigin(node.ownerDocument);
\t\tvar sl = offset.x;
\t\tvar st = offset.y;

\t\tvar b = document.body;
\t\tvar d = document.documentElement;
\t\tvar right = (sl) + ds.width;
\t\t
\t\tif (left + width > right)
\t\t{
\t\t\tnode.style.left = Math.max(sl, right - width) + 'px';
\t\t}
\t\t
\t\tvar top = parseInt(node.offsetTop);
\t\tvar height = parseInt(node.offsetHeight);
\t\t
\t\tvar bottom = st + ds.height;
\t\t
\t\tif (top + height > bottom)
\t\t{
\t\t\tnode.style.top = Math.max(st, bottom - height) + 'px';
\t\t}
\t},

\t/**
\t * Function: load
\t * 
\t * Loads the specified URL *synchronously* and returns the <mxXmlRequest>.
\t * Throws an exception if the file cannot be loaded. See <mxUtils.get> for
\t * an asynchronous implementation.
\t *
\t * Example:
\t * 
\t * (code)
\t * try
\t * {
\t *   var req = mxUtils.load(filename);
\t *   var root = req.getDocumentElement();
\t *   // Process XML DOM...
\t * }
\t * catch (ex)
\t * {
\t *   mxUtils.alert('Cannot load '+filename+': '+ex);
\t * }
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * url - URL to get the data from.
\t */
\tload: function(url)
\t{
\t\tvar req = new mxXmlRequest(url, null, 'GET', false);
\t\treq.send();
\t\t
\t\treturn req;
\t},

\t/**
\t * Function: get
\t * 
\t * Loads the specified URL *asynchronously* and invokes the given functions
\t * depending on the request status. Returns the <mxXmlRequest> in use. Both
\t * functions take the <mxXmlRequest> as the only parameter. See
\t * <mxUtils.load> for a synchronous implementation.
\t *
\t * Example:
\t * 
\t * (code)
\t * mxUtils.get(url, function(req)
\t * {
\t *    var node = req.getDocumentElement();
\t *    // Process XML DOM...
\t * });
\t * (end)
\t * 
\t * So for example, to load a diagram into an existing graph model, the
\t * following code is used.
\t * 
\t * (code)
\t * mxUtils.get(url, function(req)
\t * {
\t *   var node = req.getDocumentElement();
\t *   var dec = new mxCodec(node.ownerDocument);
\t *   dec.decode(node, graph.getModel());
\t * });
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * url - URL to get the data from.
\t * onload - Optional function to execute for a successful response.
\t * onerror - Optional function to execute on error.
\t * binary - Optional boolean parameter that specifies if the request is
\t * binary.
\t * timeout - Optional timeout in ms before calling ontimeout.
\t * ontimeout - Optional function to execute on timeout.
\t * headers - Optional with headers, eg. {'Authorization': 'token xyz'}
\t */
\tget: function(url, onload, onerror, binary, timeout, ontimeout, headers)
\t{
\t\tvar req = new mxXmlRequest(url, null, 'GET');
\t\tvar setRequestHeaders = req.setRequestHeaders;
\t\t
\t\tif (headers)
\t\t{
\t\t\treq.setRequestHeaders = function(request, params)
\t\t\t{
\t\t\t\tsetRequestHeaders.apply(this, arguments);
\t\t\t\t
\t\t\t\tfor (var key in headers)
\t\t\t\t{
\t\t\t\t\trequest.setRequestHeader(key, headers[key]);
\t\t\t\t}
\t\t\t};
\t\t}
\t\t
\t\tif (binary != null)
\t\t{
\t\t\treq.setBinary(binary);
\t\t}
\t\t
\t\treq.send(onload, onerror, timeout, ontimeout);
\t\t
\t\treturn req;
\t},

\t/**
\t * Function: getAll
\t * 
\t * Loads the URLs in the given array *asynchronously* and invokes the given function
\t * if all requests returned with a valid 2xx status. The error handler is invoked
\t * once on the first error or invalid response.
\t *
\t * Parameters:
\t * 
\t * urls - Array of URLs to be loaded.
\t * onload - Callback with array of <mxXmlRequests>.
\t * onerror - Optional function to execute on error.
\t */
\tgetAll: function(urls, onload, onerror)
\t{
\t\tvar remain = urls.length;
\t\tvar result = [];
\t\tvar errors = 0;
\t\tvar err = function()
\t\t{
\t\t\tif (errors == 0 && onerror != null)
\t\t\t{
\t\t\t\tonerror();
\t\t\t}

\t\t\terrors++;
\t\t};
\t\t
\t\tfor (var i = 0; i < urls.length; i++)
\t\t{
\t\t\t(function(url, index)
\t\t\t{
\t\t\t\tmxUtils.get(url, function(req)
\t\t\t\t{
\t\t\t\t\tvar status = req.getStatus();
\t\t\t\t\t
\t\t\t\t\tif (status < 200 || status > 299)
\t\t\t\t\t{
\t\t\t\t\t\terr();
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tresult[index] = req;
\t\t\t\t\t\tremain--;
\t\t\t\t\t\t
\t\t\t\t\t\tif (remain == 0)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tonload(result);
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}, err);
\t\t\t})(urls[i], i);
\t\t}
\t\t
\t\tif (remain == 0)
\t\t{
\t\t\tonload(result);\t\t\t
\t\t}
\t},
\t
\t/**
\t * Function: post
\t * 
\t * Posts the specified params to the given URL *asynchronously* and invokes
\t * the given functions depending on the request status. Returns the
\t * <mxXmlRequest> in use. Both functions take the <mxXmlRequest> as the
\t * only parameter. Make sure to use encodeURIComponent for the parameter
\t * values.
\t *
\t * Example:
\t * 
\t * (code)
\t * mxUtils.post(url, 'key=value', function(req)
\t * {
\t * \tmxUtils.alert('Ready: '+req.isReady()+' Status: '+req.getStatus());
\t *  // Process req.getDocumentElement() using DOM API if OK...
\t * });
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * url - URL to get the data from.
\t * params - Parameters for the post request.
\t * onload - Optional function to execute for a successful response.
\t * onerror - Optional function to execute on error.
\t */
\tpost: function(url, params, onload, onerror)
\t{
\t\treturn new mxXmlRequest(url, params).send(onload, onerror);
\t},
\t
\t/**
\t * Function: submit
\t * 
\t * Submits the given parameters to the specified URL using
\t * <mxXmlRequest.simulate> and returns the <mxXmlRequest>.
\t * Make sure to use encodeURIComponent for the parameter
\t * values.
\t * 
\t * Parameters:
\t * 
\t * url - URL to get the data from.
\t * params - Parameters for the form.
\t * doc - Document to create the form in.
\t * target - Target to send the form result to.
\t */
\tsubmit: function(url, params, doc, target)
\t{
\t\treturn new mxXmlRequest(url, params).simulate(doc, target);
\t},
\t
\t/**
\t * Function: loadInto
\t * 
\t * Loads the specified URL *asynchronously* into the specified document,
\t * invoking onload after the document has been loaded. This implementation
\t * does not use <mxXmlRequest>, but the document.load method.
\t * 
\t * Parameters:
\t * 
\t * url - URL to get the data from.
\t * doc - The document to load the URL into.
\t * onload - Function to execute when the URL has been loaded.
\t */
\tloadInto: function(url, doc, onload)
\t{
\t\tif (mxClient.IS_IE)
\t\t{
\t\t\tdoc.onreadystatechange = function ()
\t\t\t{
\t\t\t\tif (doc.readyState == 4)
\t\t\t\t{
\t\t\t\t\tonload();
\t\t\t\t}
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\tdoc.addEventListener('load', onload, false);
\t\t}
\t\t
\t\tdoc.load(url);
\t},
\t
\t/**
\t * Function: getValue
\t * 
\t * Returns the value for the given key in the given associative array or
\t * the given default value if the value is null.
\t * 
\t * Parameters:
\t * 
\t * array - Associative array that contains the value for the key.
\t * key - Key whose value should be returned.
\t * defaultValue - Value to be returned if the value for the given
\t * key is null.
\t */
\tgetValue: function(array, key, defaultValue)
\t{
\t\tvar value = (array != null) ? array[key] : null;

\t\tif (value == null)
\t\t{
\t\t\tvalue = defaultValue;\t\t\t
\t\t}
\t\t
\t\treturn value;
\t},
\t
\t/**
\t * Function: getNumber
\t * 
\t * Returns the numeric value for the given key in the given associative
\t * array or the given default value (or 0) if the value is null. The value
\t * is converted to a numeric value using the Number function.
\t * 
\t * Parameters:
\t * 
\t * array - Associative array that contains the value for the key.
\t * key - Key whose value should be returned.
\t * defaultValue - Value to be returned if the value for the given
\t * key is null. Default is 0.
\t */
\tgetNumber: function(array, key, defaultValue)
\t{
\t\tvar value = (array != null) ? array[key] : null;

\t\tif (value == null)
\t\t{
\t\t\tvalue = defaultValue || 0;\t\t\t
\t\t}
\t\t
\t\treturn Number(value);
\t},
\t
\t/**
\t * Function: getColor
\t * 
\t * Returns the color value for the given key in the given associative
\t * array or the given default value if the value is null. If the value
\t * is <mxConstants.NONE> then null is returned.
\t * 
\t * Parameters:
\t * 
\t * array - Associative array that contains the value for the key.
\t * key - Key whose value should be returned.
\t * defaultValue - Value to be returned if the value for the given
\t * key is null. Default is null.
\t */
\tgetColor: function(array, key, defaultValue)
\t{
\t\tvar value = (array != null) ? array[key] : null;

\t\tif (value == null)
\t\t{
\t\t\tvalue = defaultValue;
\t\t}
\t\telse if (value == mxConstants.NONE)
\t\t{
\t\t\tvalue = null;
\t\t}
\t\t
\t\treturn value;
\t},

\t/**
\t * Function: clone
\t * 
\t * Recursively clones the specified object ignoring all fieldnames in the
\t * given array of transient fields. <mxObjectIdentity.FIELD_NAME> is always
\t * ignored by this function.
\t * 
\t * Parameters:
\t * 
\t * obj - Object to be cloned.
\t * transients - Optional array of strings representing the fieldname to be
\t * ignored.
\t * shallow - Optional boolean argument to specify if a shallow clone should
\t * be created, that is, one where all object references are not cloned or,
\t * in other words, one where only atomic (strings, numbers) values are
\t * cloned. Default is false.
\t */
\tclone: function(obj, transients, shallow)
\t{
\t\tshallow = (shallow != null) ? shallow : false;
\t\tvar clone = null;
\t\t
\t\tif (obj != null && typeof(obj.constructor) == 'function')
\t\t{
\t\t\tclone = new obj.constructor();
\t\t\t
\t\t    for (var i in obj)
\t\t    {
\t\t    \tif (i != mxObjectIdentity.FIELD_NAME && (transients == null ||
\t\t    \t\tmxUtils.indexOf(transients, i) < 0))
\t\t    \t{
\t\t\t    \tif (!shallow && typeof(obj[i]) == 'object')
\t\t\t    \t{
\t\t\t            clone[i] = mxUtils.clone(obj[i]);
\t\t\t        }
\t\t\t        else
\t\t\t        {
\t\t\t            clone[i] = obj[i];
\t\t\t        }
\t\t\t\t}
\t\t    }
\t\t}
\t\t
\t    return clone;
\t},

\t/**
\t * Function: equalPoints
\t * 
\t * Compares all mxPoints in the given lists.
\t * 
\t * Parameters:
\t * 
\t * a - Array of <mxPoints> to be compared.
\t * b - Array of <mxPoints> to be compared.
\t */
\tequalPoints: function(a, b)
\t{
\t\tif ((a == null && b != null) || (a != null && b == null) ||
\t\t\t(a != null && b != null && a.length != b.length))
\t\t{
\t\t\treturn false;
\t\t}
\t\telse if (a != null && b != null)
\t\t{
\t\t\tfor (var i = 0; i < a.length; i++)
\t\t\t{
\t\t\t\tif ((a[i] != null && b[i] == null) ||
\t\t\t\t\t(a[i] == null && b[i] != null) ||
\t\t\t\t\t(a[i] != null && b[i] != null &&
\t\t\t\t\t(a[i].x != b[i].x || a[i].y != b[i].y)))
\t\t\t\t{
\t\t\t\t\treturn false;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn true;
\t},

\t/**
\t * Function: equalEntries
\t * 
\t * Returns true if all properties of the given objects are equal. Values
\t * with NaN are equal to NaN and unequal to any other value.
\t * 
\t * Parameters:
\t * 
\t * a - First object to be compared.
\t * b - Second object to be compared.
\t */
\tequalEntries: function(a, b)
\t{
\t\t// Counts keys in b to check if all values have been compared
\t\tvar count = 0;

\t\tif ((a == null && b != null) || (a != null && b == null) ||
\t\t\t(a != null && b != null && a.length != b.length))
\t\t{
\t\t\treturn false;
\t\t}
\t\telse if (a != null && b != null)
\t\t{
\t\t\tfor (var key in b)
\t\t\t{
\t\t\t\tcount++;
\t\t\t}
\t\t\t
\t\t\tfor (var key in a)
\t\t\t{
\t\t\t\tcount--
\t\t\t\t
\t\t\t\tif ((!mxUtils.isNaN(a[key]) || !mxUtils.isNaN(b[key])) && a[key] != b[key])
\t\t\t\t{
\t\t\t\t\treturn false;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn count == 0;
\t},
\t
\t/**
\t * Function: removeDuplicates
\t * 
\t * Removes all duplicates from the given array.
\t */
\tremoveDuplicates: function(arr)
\t{
\t\tvar dict = new mxDictionary();
\t\tvar result = [];
\t\t
\t\tfor (var i = 0; i < arr.length; i++)
\t\t{
\t\t\tif (!dict.get(arr[i]))
\t\t\t{
\t\t\t\tresult.push(arr[i]);
\t\t\t\tdict.put(arr[i], true);
\t\t\t}
\t\t}

\t\treturn result;
\t},
\t
\t/**
\t * Function: isNaN
\t *
\t * Returns true if the given value is of type number and isNaN returns true.
\t */
\tisNaN: function(value)
\t{
\t\treturn typeof(value) == 'number' && isNaN(value);
\t},
\t
\t/**
\t * Function: extend
\t *
\t * Assigns a copy of the superclass prototype to the subclass prototype.
\t * Note that this does not call the constructor of the superclass at this
\t * point, the superclass constructor should be called explicitely in the
\t * subclass constructor. Below is an example.
\t * 
\t * (code)
\t * MyGraph = function(container, model, renderHint, stylesheet)
\t * {
\t *   mxGraph.call(this, container, model, renderHint, stylesheet);
\t * }
\t * 
\t * mxUtils.extend(MyGraph, mxGraph);
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * ctor - Constructor of the subclass.
\t * superCtor - Constructor of the superclass.
\t */
\textend: function(ctor, superCtor)
\t{
\t\tvar f = function() {};
\t\tf.prototype = superCtor.prototype;
\t\t
\t\tctor.prototype = new f();
\t\tctor.prototype.constructor = ctor;
\t},

\t/**
\t * Function: toString
\t * 
\t * Returns a textual representation of the specified object.
\t * 
\t * Parameters:
\t * 
\t * obj - Object to return the string representation for.
\t */
\ttoString: function(obj)
\t{
\t    var output = '';
\t    
\t    for (var i in obj)
\t    {
\t    \ttry
\t    \t{
\t\t\t    if (obj[i] == null)
\t\t\t    {
\t\t            output += i + ' = [null]\\n';
\t\t\t    }
\t\t\t    else if (typeof(obj[i]) == 'function')
\t\t\t    {
\t\t            output += i + ' => [Function]\\n';
\t\t        }
\t\t        else if (typeof(obj[i]) == 'object')
\t\t        {
\t\t        \tvar ctor = mxUtils.getFunctionName(obj[i].constructor); 
\t\t            output += i + ' => [' + ctor + ']\\n';
\t\t        }
\t\t        else
\t\t        {
\t\t            output += i + ' = ' + obj[i] + '\\n';
\t\t        }
\t    \t}
\t    \tcatch (e)
\t    \t{
\t    \t\toutput += i + '=' + e.message;
\t    \t}
\t    }
\t    
\t    return output;
\t},

\t/**
\t * Function: toRadians
\t * 
\t * Converts the given degree to radians.
\t */
\ttoRadians: function(deg)
\t{
\t\treturn Math.PI * deg / 180;
\t},

\t/**
\t * Function: toDegree
\t * 
\t * Converts the given radians to degree.
\t */
\ttoDegree: function(rad)
\t{
\t\treturn rad * 180 / Math.PI;
\t},
\t
\t/**
\t * Function: arcToCurves
\t * 
\t * Converts the given arc to a series of curves.
\t */
\tarcToCurves: function(x0, y0, r1, r2, angle, largeArcFlag, sweepFlag, x, y)
\t{
\t\tx -= x0;
\t\ty -= y0;
\t\t
        if (r1 === 0 || r2 === 0) 
        {
        \treturn result;
        }
        
        var fS = sweepFlag;
        var psai = angle;
        r1 = Math.abs(r1);
        r2 = Math.abs(r2);
        var ctx = -x / 2;
        var cty = -y / 2;
        var cpsi = Math.cos(psai * Math.PI / 180);
        var spsi = Math.sin(psai * Math.PI / 180);
        var rxd = cpsi * ctx + spsi * cty;
        var ryd = -1 * spsi * ctx + cpsi * cty;
        var rxdd = rxd * rxd;
        var rydd = ryd * ryd;
        var r1x = r1 * r1;
        var r2y = r2 * r2;
        var lamda = rxdd / r1x + rydd / r2y;
        var sds;
        
        if (lamda > 1) 
        {
        \tr1 = Math.sqrt(lamda) * r1;
        \tr2 = Math.sqrt(lamda) * r2;
        \tsds = 0;
        }  
        else
        {
        \tvar seif = 1;
            
        \tif (largeArcFlag === fS) 
        \t{
        \t\tseif = -1;
        \t}
            
        \tsds = seif * Math.sqrt((r1x * r2y - r1x * rydd - r2y * rxdd) / (r1x * rydd + r2y * rxdd));
        }
        
        var txd = sds * r1 * ryd / r2;
        var tyd = -1 * sds * r2 * rxd / r1;
        var tx = cpsi * txd - spsi * tyd + x / 2;
        var ty = spsi * txd + cpsi * tyd + y / 2;
        var rad = Math.atan2((ryd - tyd) / r2, (rxd - txd) / r1) - Math.atan2(0, 1);
        var s1 = (rad >= 0) ? rad : 2 * Math.PI + rad;
        rad = Math.atan2((-ryd - tyd) / r2, (-rxd - txd) / r1) - Math.atan2((ryd - tyd) / r2, (rxd - txd) / r1);
        var dr = (rad >= 0) ? rad : 2 * Math.PI + rad;
        
        if (fS == 0 && dr > 0) 
        {
        \tdr -= 2 * Math.PI;
        }
        else if (fS != 0 && dr < 0) 
        {
        \tdr += 2 * Math.PI;
        }
        
        var sse = dr * 2 / Math.PI;
        var seg = Math.ceil(sse < 0 ? -1 * sse : sse);
        var segr = dr / seg;
        var t = 8/3 * Math.sin(segr / 4) * Math.sin(segr / 4) / Math.sin(segr / 2);
        var cpsir1 = cpsi * r1;
        var cpsir2 = cpsi * r2;
        var spsir1 = spsi * r1;
        var spsir2 = spsi * r2;
        var mc = Math.cos(s1);
        var ms = Math.sin(s1);
        var x2 = -t * (cpsir1 * ms + spsir2 * mc);
        var y2 = -t * (spsir1 * ms - cpsir2 * mc);
        var x3 = 0;
        var y3 = 0;

\t\tvar result = [];
        
        for (var n = 0; n < seg; ++n) 
        {
            s1 += segr;
            mc = Math.cos(s1);
            ms = Math.sin(s1);
            
            x3 = cpsir1 * mc - spsir2 * ms + tx;
            y3 = spsir1 * mc + cpsir2 * ms + ty;
            var dx = -t * (cpsir1 * ms + spsir2 * mc);
            var dy = -t * (spsir1 * ms - cpsir2 * mc);
            
            // CurveTo updates x0, y0 so need to restore it
            var index = n * 6;
            result[index] = Number(x2 + x0);
            result[index + 1] = Number(y2 + y0);
            result[index + 2] = Number(x3 - dx + x0);
            result[index + 3] = Number(y3 - dy + y0);
            result[index + 4] = Number(x3 + x0);
            result[index + 5] = Number(y3 + y0);
            
\t\t\tx2 = x3 + dx;
            y2 = y3 + dy;
        }
        
        return result;
\t},

\t/**
\t * Function: getBoundingBox
\t * 
\t * Returns the bounding box for the rotated rectangle.
\t * 
\t * Parameters:
\t * 
\t * rect - <mxRectangle> to be rotated.
\t * angle - Number that represents the angle (in degrees).
\t * cx - Optional <mxPoint> that represents the rotation center. If no
\t * rotation center is given then the center of rect is used.
\t */
\tgetBoundingBox: function(rect, rotation, cx)
\t{
        var result = null;

        if (rect != null && rotation != null && rotation != 0)
        {
            var rad = mxUtils.toRadians(rotation);
            var cos = Math.cos(rad);
            var sin = Math.sin(rad);

            cx = (cx != null) ? cx : new mxPoint(rect.x + rect.width / 2, rect.y + rect.height / 2);

            var p1 = new mxPoint(rect.x, rect.y);
            var p2 = new mxPoint(rect.x + rect.width, rect.y);
            var p3 = new mxPoint(p2.x, rect.y + rect.height);
            var p4 = new mxPoint(rect.x, p3.y);

            p1 = mxUtils.getRotatedPoint(p1, cos, sin, cx);
            p2 = mxUtils.getRotatedPoint(p2, cos, sin, cx);
            p3 = mxUtils.getRotatedPoint(p3, cos, sin, cx);
            p4 = mxUtils.getRotatedPoint(p4, cos, sin, cx);

            result = new mxRectangle(p1.x, p1.y, 0, 0);
            result.add(new mxRectangle(p2.x, p2.y, 0, 0));
            result.add(new mxRectangle(p3.x, p3.y, 0, 0));
            result.add(new mxRectangle(p4.x, p4.y, 0, 0));
        }

        return result;
\t},

\t/**
\t * Function: getRotatedPoint
\t * 
\t * Rotates the given point by the given cos and sin.
\t */
\tgetRotatedPoint: function(pt, cos, sin, c)
\t{
\t\tc = (c != null) ? c : new mxPoint();
\t\tvar x = pt.x - c.x;
\t\tvar y = pt.y - c.y;

\t\tvar x1 = x * cos - y * sin;
\t\tvar y1 = y * cos + x * sin;

\t\treturn new mxPoint(x1 + c.x, y1 + c.y);
\t},
\t
\t/**
\t * Returns an integer mask of the port constraints of the given map
\t * @param dict the style map to determine the port constraints for
\t * @param defaultValue Default value to return if the key is undefined.
\t * @return the mask of port constraint directions
\t * 
\t * Parameters:
\t * 
\t * terminal - <mxCelState> that represents the terminal.
\t * edge - <mxCellState> that represents the edge.
\t * source - Boolean that specifies if the terminal is the source terminal.
\t * defaultValue - Default value to be returned.
\t */
\tgetPortConstraints: function(terminal, edge, source, defaultValue)
\t{
\t\tvar value = mxUtils.getValue(terminal.style, mxConstants.STYLE_PORT_CONSTRAINT,
\t\t\tmxUtils.getValue(edge.style, (source) ? mxConstants.STYLE_SOURCE_PORT_CONSTRAINT :
\t\t\t\tmxConstants.STYLE_TARGET_PORT_CONSTRAINT, null));
\t\t
\t\tif (value == null)
\t\t{
\t\t\treturn defaultValue;
\t\t}
\t\telse
\t\t{
\t\t\tvar directions = value.toString();
\t\t\tvar returnValue = mxConstants.DIRECTION_MASK_NONE;
\t\t\tvar constraintRotationEnabled = mxUtils.getValue(terminal.style, mxConstants.STYLE_PORT_CONSTRAINT_ROTATION, 0);
\t\t\tvar rotation = 0;
\t\t\t
\t\t\tif (constraintRotationEnabled == 1)
\t\t\t{
\t\t\t\trotation = mxUtils.getValue(terminal.style, mxConstants.STYLE_ROTATION, 0);
\t\t\t}
\t\t\t
\t\t\tvar quad = 0;

\t\t\tif (rotation > 45)
\t\t\t{
\t\t\t\tquad = 1;
\t\t\t\t
\t\t\t\tif (rotation >= 135)
\t\t\t\t{
\t\t\t\t\tquad = 2;
\t\t\t\t}
\t\t\t}
\t\t\telse if (rotation < -45)
\t\t\t{
\t\t\t\tquad = 3;
\t\t\t\t
\t\t\t\tif (rotation <= -135)
\t\t\t\t{
\t\t\t\t\tquad = 2;
\t\t\t\t}
\t\t\t}

\t\t\tif (directions.indexOf(mxConstants.DIRECTION_NORTH) >= 0)
\t\t\t{
\t\t\t\tswitch (quad)
\t\t\t\t{
\t\t\t\t\tcase 0:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_NORTH;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 1:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_EAST;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 2:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_SOUTH;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 3:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_WEST;
\t\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t}
\t\t\tif (directions.indexOf(mxConstants.DIRECTION_WEST) >= 0)
\t\t\t{
\t\t\t\tswitch (quad)
\t\t\t\t{
\t\t\t\t\tcase 0:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_WEST;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 1:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_NORTH;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 2:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_EAST;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 3:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_SOUTH;
\t\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t}
\t\t\tif (directions.indexOf(mxConstants.DIRECTION_SOUTH) >= 0)
\t\t\t{
\t\t\t\tswitch (quad)
\t\t\t\t{
\t\t\t\t\tcase 0:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_SOUTH;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 1:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_WEST;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 2:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_NORTH;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 3:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_EAST;
\t\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t}
\t\t\tif (directions.indexOf(mxConstants.DIRECTION_EAST) >= 0)
\t\t\t{
\t\t\t\tswitch (quad)
\t\t\t\t{
\t\t\t\t\tcase 0:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_EAST;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 1:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_SOUTH;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 2:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_WEST;
\t\t\t\t\t\tbreak;
\t\t\t\t\tcase 3:
\t\t\t\t\t\treturnValue |= mxConstants.DIRECTION_MASK_NORTH;
\t\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t}

\t\t\treturn returnValue;
\t\t}
\t},
\t
\t/**
\t * Function: reversePortConstraints
\t * 
\t * Reverse the port constraint bitmask. For example, north | east
\t * becomes south | west
\t */
\treversePortConstraints: function(constraint)
\t{
\t\tvar result = 0;
\t\t
\t\tresult = (constraint & mxConstants.DIRECTION_MASK_WEST) << 3;
\t\tresult |= (constraint & mxConstants.DIRECTION_MASK_NORTH) << 1;
\t\tresult |= (constraint & mxConstants.DIRECTION_MASK_SOUTH) >> 1;
\t\tresult |= (constraint & mxConstants.DIRECTION_MASK_EAST) >> 3;
\t\t
\t\treturn result;
\t},
\t
\t/**
\t * Function: findNearestSegment
\t * 
\t * Finds the index of the nearest segment on the given cell state for
\t * the specified coordinate pair.
\t */
\tfindNearestSegment: function(state, x, y)
\t{
\t\tvar index = -1;
\t\t
\t\tif (state.absolutePoints.length > 0)
\t\t{
\t\t\tvar last = state.absolutePoints[0];
\t\t\tvar min = null;
\t\t\t
\t\t\tfor (var i = 1; i < state.absolutePoints.length; i++)
\t\t\t{
\t\t\t\tvar current = state.absolutePoints[i];
\t\t\t\tvar dist = mxUtils.ptSegDistSq(last.x, last.y,
\t\t\t\t\tcurrent.x, current.y, x, y);
\t\t\t\t
\t\t\t\tif (min == null || dist < min)
\t\t\t\t{
\t\t\t\t\tmin = dist;
\t\t\t\t\tindex = i - 1;
\t\t\t\t}

\t\t\t\tlast = current;
\t\t\t}
\t\t}
\t\t
\t\treturn index;
\t},

\t/**
\t * Function: getDirectedBounds
\t * 
\t * Adds the given margins to the given rectangle and rotates and flips the
\t * rectangle according to the respective styles in style.
\t */
\tgetDirectedBounds: function (rect, m, style, flipH, flipV)
\t{
\t\tvar d = mxUtils.getValue(style, mxConstants.STYLE_DIRECTION, mxConstants.DIRECTION_EAST);
\t\tflipH = (flipH != null) ? flipH : mxUtils.getValue(style, mxConstants.STYLE_FLIPH, false);
\t\tflipV = (flipV != null) ? flipV : mxUtils.getValue(style, mxConstants.STYLE_FLIPV, false);

\t\tm.x = Math.round(Math.max(0, Math.min(rect.width, m.x)));
\t\tm.y = Math.round(Math.max(0, Math.min(rect.height, m.y)));
\t\tm.width = Math.round(Math.max(0, Math.min(rect.width, m.width)));
\t\tm.height = Math.round(Math.max(0, Math.min(rect.height, m.height)));
\t\t
\t\tif ((flipV && (d == mxConstants.DIRECTION_SOUTH || d == mxConstants.DIRECTION_NORTH)) ||
\t\t\t(flipH && (d == mxConstants.DIRECTION_EAST || d == mxConstants.DIRECTION_WEST)))
\t\t{
\t\t\tvar tmp = m.x;
\t\t\tm.x = m.width;
\t\t\tm.width = tmp;
\t\t}
\t\t\t
\t\tif ((flipH && (d == mxConstants.DIRECTION_SOUTH || d == mxConstants.DIRECTION_NORTH)) ||
\t\t\t(flipV && (d == mxConstants.DIRECTION_EAST || d == mxConstants.DIRECTION_WEST)))
\t\t{
\t\t\tvar tmp = m.y;
\t\t\tm.y = m.height;
\t\t\tm.height = tmp;
\t\t}
\t\t
\t\tvar m2 = mxRectangle.fromRectangle(m);
\t\t
\t\tif (d == mxConstants.DIRECTION_SOUTH)
\t\t{
\t\t\tm2.y = m.x;
\t\t\tm2.x = m.height;
\t\t\tm2.width = m.y;
\t\t\tm2.height = m.width;
\t\t}
\t\telse if (d == mxConstants.DIRECTION_WEST)
\t\t{
\t\t\tm2.y = m.height;
\t\t\tm2.x = m.width;
\t\t\tm2.width = m.x;
\t\t\tm2.height = m.y;
\t\t}
\t\telse if (d == mxConstants.DIRECTION_NORTH)
\t\t{
\t\t\tm2.y = m.width;
\t\t\tm2.x = m.y;
\t\t\tm2.width = m.height;
\t\t\tm2.height = m.x;
\t\t}
\t\t
\t\treturn new mxRectangle(rect.x + m2.x, rect.y + m2.y, rect.width - m2.width - m2.x, rect.height - m2.height - m2.y);
\t},

\t/**
\t * Function: getPerimeterPoint
\t * 
\t * Returns the intersection between the polygon defined by the array of
\t * points and the line between center and point.
\t */
\tgetPerimeterPoint: function (pts, center, point)
\t{
\t\tvar min = null;
\t\t
\t\tfor (var i = 0; i < pts.length - 1; i++)
\t\t{
\t\t\tvar pt = mxUtils.intersection(pts[i].x, pts[i].y, pts[i + 1].x, pts[i + 1].y,
\t\t\t\tcenter.x, center.y, point.x, point.y);
\t\t\t
\t\t\tif (pt != null)
\t\t\t{
\t\t\t\tvar dx = point.x - pt.x;
\t\t\t\tvar dy = point.y - pt.y;
\t\t\t\tvar ip = {p: pt, distSq: dy * dy + dx * dx};
\t\t\t\t
\t\t\t\tif (ip != null && (min == null || min.distSq > ip.distSq))
\t\t\t\t{
\t\t\t\t\tmin = ip;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn (min != null) ? min.p : null;
\t},

\t/**
\t * Function: rectangleIntersectsSegment
\t * 
\t * Returns true if the given rectangle intersects the given segment.
\t * 
\t * Parameters:
\t * 
\t * bounds - <mxRectangle> that represents the rectangle.
\t * p1 - <mxPoint> that represents the first point of the segment.
\t * p2 - <mxPoint> that represents the second point of the segment.
\t */
\trectangleIntersectsSegment: function(bounds, p1, p2)
\t{
\t\tvar top = bounds.y;
\t\tvar left = bounds.x;
\t\tvar bottom = top + bounds.height;
\t\tvar right = left + bounds.width;
\t\t\t
\t\t// Find min and max X for the segment
\t\tvar minX = p1.x;
\t\tvar maxX = p2.x;
\t\t
\t\tif (p1.x > p2.x)
\t\t{
\t\t  minX = p2.x;
\t\t  maxX = p1.x;
\t\t}
\t\t
\t\t// Find the intersection of the segment's and rectangle's x-projections
\t\tif (maxX > right)
\t\t{
\t\t  maxX = right;
\t\t}
\t\t
\t\tif (minX < left)
\t\t{
\t\t  minX = left;
\t\t}
\t\t
\t\tif (minX > maxX) // If their projections do not intersect return false
\t\t{
\t\t  return false;
\t\t}
\t\t
\t\t// Find corresponding min and max Y for min and max X we found before
\t\tvar minY = p1.y;
\t\tvar maxY = p2.y;
\t\tvar dx = p2.x - p1.x;
\t\t
\t\tif (Math.abs(dx) > 0.0000001)
\t\t{
\t\t  var a = (p2.y - p1.y) / dx;
\t\t  var b = p1.y - a * p1.x;
\t\t  minY = a * minX + b;
\t\t  maxY = a * maxX + b;
\t\t}
\t\t
\t\tif (minY > maxY)
\t\t{
\t\t  var tmp = maxY;
\t\t  maxY = minY;
\t\t  minY = tmp;
\t\t}
\t\t
\t\t// Find the intersection of the segment's and rectangle's y-projections
\t\tif (maxY > bottom)
\t\t{
\t\t  maxY = bottom;
\t\t}
\t\t
\t\tif (minY < top)
\t\t{
\t\t  minY = top;
\t\t}
\t\t
\t\tif (minY > maxY) // If Y-projections do not intersect return false
\t\t{
\t\t  return false;
\t\t}
\t\t
\t\treturn true;
\t},
\t
\t/**
\t * Function: contains
\t * 
\t * Returns true if the specified point (x, y) is contained in the given rectangle.
\t * 
\t * Parameters:
\t * 
\t * bounds - <mxRectangle> that represents the area.
\t * x - X-coordinate of the point.
\t * y - Y-coordinate of the point.
\t */
\tcontains: function(bounds, x, y)
\t{
\t\treturn (bounds.x <= x && bounds.x + bounds.width >= x &&
\t\t\t\tbounds.y <= y && bounds.y + bounds.height >= y);
\t},

\t/**
\t * Function: intersects
\t * 
\t * Returns true if the two rectangles intersect.
\t * 
\t * Parameters:
\t * 
\t * a - <mxRectangle> to be checked for intersection.
\t * b - <mxRectangle> to be checked for intersection.
\t */
\tintersects: function(a, b)
\t{
\t\tvar tw = a.width;
\t\tvar th = a.height;
\t\tvar rw = b.width;
\t\tvar rh = b.height;
\t\t
\t\tif (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0)
\t\t{
\t\t    return false;
\t\t}
\t\t
\t\tvar tx = a.x;
\t\tvar ty = a.y;
\t\tvar rx = b.x;
\t\tvar ry = b.y;
\t\t
\t\trw += rx;
\t\trh += ry;
\t\ttw += tx;
\t\tth += ty;

\t\treturn ((rw < rx || rw > tx) &&
\t\t\t(rh < ry || rh > ty) &&
\t\t\t(tw < tx || tw > rx) &&
\t\t\t(th < ty || th > ry));
\t},

\t/**
\t * Function: intersectsHotspot
\t * 
\t * Returns true if the state and the hotspot intersect.
\t * 
\t * Parameters:
\t * 
\t * state - <mxCellState>
\t * x - X-coordinate.
\t * y - Y-coordinate.
\t * hotspot - Optional size of the hostpot.
\t * min - Optional min size of the hostpot.
\t * max - Optional max size of the hostpot.
\t */
\tintersectsHotspot: function(state, x, y, hotspot, min, max)
\t{
\t\thotspot = (hotspot != null) ? hotspot : 1;
\t\tmin = (min != null) ? min : 0;
\t\tmax = (max != null) ? max : 0;
\t\t
\t\tif (hotspot > 0)
\t\t{
\t\t\tvar cx = state.getCenterX();
\t\t\tvar cy = state.getCenterY();
\t\t\tvar w = state.width;
\t\t\tvar h = state.height;
\t\t\t
\t\t\tvar start = mxUtils.getValue(state.style, mxConstants.STYLE_STARTSIZE) * state.view.scale;

\t\t\tif (start > 0)
\t\t\t{
\t\t\t\tif (mxUtils.getValue(state.style, mxConstants.STYLE_HORIZONTAL, true))
\t\t\t\t{
\t\t\t\t\tcy = state.y + start / 2;
\t\t\t\t\th = start;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tcx = state.x + start / 2;
\t\t\t\t\tw = start;
\t\t\t\t}
\t\t\t}

\t\t\tw = Math.max(min, w * hotspot);
\t\t\th = Math.max(min, h * hotspot);
\t\t\t
\t\t\tif (max > 0)
\t\t\t{
\t\t\t\tw = Math.min(w, max);
\t\t\t\th = Math.min(h, max);
\t\t\t}
\t\t\t
\t\t\tvar rect = new mxRectangle(cx - w / 2, cy - h / 2, w, h);
\t\t\tvar alpha = mxUtils.toRadians(mxUtils.getValue(state.style, mxConstants.STYLE_ROTATION) || 0);
\t\t\t
\t\t\tif (alpha != 0)
\t\t\t{
\t\t\t\tvar cos = Math.cos(-alpha);
\t\t\t\tvar sin = Math.sin(-alpha);
\t\t\t\tvar cx = new mxPoint(state.getCenterX(), state.getCenterY());
\t\t\t\tvar pt = mxUtils.getRotatedPoint(new mxPoint(x, y), cos, sin, cx);
\t\t\t\tx = pt.x;
\t\t\t\ty = pt.y;
\t\t\t}
\t\t\t
\t\t\treturn mxUtils.contains(rect, x, y);\t\t\t
\t\t}
\t\t
\t\treturn true;
\t},

\t/**
\t * Function: getOffset
\t * 
\t * Returns the offset for the specified container as an <mxPoint>. The
\t * offset is the distance from the top left corner of the container to the
\t * top left corner of the document.
\t * 
\t * Parameters:
\t * 
\t * container - DOM node to return the offset for.
\t * scollOffset - Optional boolean to add the scroll offset of the document.
\t * Default is false.
\t */
\tgetOffset: function(container, scrollOffset)
\t{
\t\tvar offsetLeft = 0;
\t\tvar offsetTop = 0;
\t\t
\t\t// Ignores document scroll origin for fixed elements
\t\tvar fixed = false;
\t\tvar node = container;
\t\tvar b = document.body;
\t\tvar d = document.documentElement;

\t\twhile (node != null && node != b && node != d && !fixed)
\t\t{
\t\t\tvar style = mxUtils.getCurrentStyle(node);
\t\t\t
\t\t\tif (style != null)
\t\t\t{
\t\t\t\tfixed = fixed || style.position == 'fixed';
\t\t\t}
\t\t\t
\t\t\tnode = node.parentNode;
\t\t}
\t\t
\t\tif (!scrollOffset && !fixed)
\t\t{
\t\t\tvar offset = mxUtils.getDocumentScrollOrigin(container.ownerDocument);
\t\t\toffsetLeft += offset.x;
\t\t\toffsetTop += offset.y;
\t\t}
\t\t
\t\tvar r = container.getBoundingClientRect();
\t\t
\t\tif (r != null)
\t\t{
\t\t\toffsetLeft += r.left;
\t\t\toffsetTop += r.top;
\t\t}
\t\t
\t\treturn new mxPoint(offsetLeft, offsetTop);
\t},

\t/**
\t * Function: getDocumentScrollOrigin
\t * 
\t * Returns the scroll origin of the given document or the current document
\t * if no document is given.
\t */
\tgetDocumentScrollOrigin: function(doc)
\t{
\t\tif (mxClient.IS_QUIRKS)
\t\t{
\t\t\treturn new mxPoint(doc.body.scrollLeft, doc.body.scrollTop);
\t\t}
\t\telse
\t\t{
\t\t\tvar wnd = doc.defaultView || doc.parentWindow;
\t\t\t
\t\t\tvar x = (wnd != null && window.pageXOffset !== undefined) ? window.pageXOffset : (document.documentElement || document.body.parentNode || document.body).scrollLeft;
\t\t\tvar y = (wnd != null && window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;
\t\t\t
\t\t\treturn new mxPoint(x, y);
\t\t}
\t},
\t
\t/**
\t * Function: getScrollOrigin
\t * 
\t * Returns the top, left corner of the viewrect as an <mxPoint>.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node whose scroll origin should be returned.
\t * includeAncestors - Whether the scroll origin of the ancestors should be
\t * included. Default is false.
\t * includeDocument - Whether the scroll origin of the document should be
\t * included. Default is true.
\t */
\tgetScrollOrigin: function(node, includeAncestors, includeDocument)
\t{
\t\tincludeAncestors = (includeAncestors != null) ? includeAncestors : false;
\t\tincludeDocument = (includeDocument != null) ? includeDocument : true;
\t\t
\t\tvar doc = (node != null) ? node.ownerDocument : document;
\t\tvar b = doc.body;
\t\tvar d = doc.documentElement;
\t\tvar result = new mxPoint();
\t\tvar fixed = false;

\t\twhile (node != null && node != b && node != d)
\t\t{
\t\t\tif (!isNaN(node.scrollLeft) && !isNaN(node.scrollTop))
\t\t\t{
\t\t\t\tresult.x += node.scrollLeft;
\t\t\t\tresult.y += node.scrollTop;
\t\t\t}
\t\t\t
\t\t\tvar style = mxUtils.getCurrentStyle(node);
\t\t\t
\t\t\tif (style != null)
\t\t\t{
\t\t\t\tfixed = fixed || style.position == 'fixed';
\t\t\t}

\t\t\tnode = (includeAncestors) ? node.parentNode : null;
\t\t}

\t\tif (!fixed && includeDocument)
\t\t{
\t\t\tvar origin = mxUtils.getDocumentScrollOrigin(doc);

\t\t\tresult.x += origin.x;
\t\t\tresult.y += origin.y;
\t\t}
\t\t
\t\treturn result;
\t},

\t/**
\t * Function: convertPoint
\t * 
\t * Converts the specified point (x, y) using the offset of the specified
\t * container and returns a new <mxPoint> with the result.
\t * 
\t * (code)
\t * var pt = mxUtils.convertPoint(graph.container,
\t *   mxEvent.getClientX(evt), mxEvent.getClientY(evt));
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * container - DOM node to use for the offset.
\t * x - X-coordinate of the point to be converted.
\t * y - Y-coordinate of the point to be converted.
\t */
\tconvertPoint: function(container, x, y)
\t{
\t\tvar origin = mxUtils.getScrollOrigin(container, false);
\t\tvar offset = mxUtils.getOffset(container);

\t\toffset.x -= origin.x;
\t\toffset.y -= origin.y;
\t\t
\t\treturn new mxPoint(x - offset.x, y - offset.y);
\t},
\t
\t/**
\t * Function: ltrim
\t * 
\t * Strips all whitespaces from the beginning of the string. Without the
\t * second parameter, this will trim these characters:
\t * 
\t * - \" \" (ASCII 32 (0x20)), an ordinary space
\t * - \"\\t\" (ASCII 9 (0x09)), a tab
\t * - \"\\n\" (ASCII 10 (0x0A)), a new line (line feed)
\t * - \"\\r\" (ASCII 13 (0x0D)), a carriage return
\t * - \"\\0\" (ASCII 0 (0x00)), the NUL-byte
\t * - \"\\x0B\" (ASCII 11 (0x0B)), a vertical tab
\t */
\tltrim: function(str, chars)
\t{
\t\tchars = chars || \"\\\\s\";
\t\t
\t\treturn (str != null) ? str.replace(new RegExp(\"^[\" + chars + \"]+\", \"g\"), \"\") : null;
\t},
\t
\t/**
\t * Function: rtrim
\t * 
\t * Strips all whitespaces from the end of the string. Without the second
\t * parameter, this will trim these characters:
\t * 
\t * - \" \" (ASCII 32 (0x20)), an ordinary space
\t * - \"\\t\" (ASCII 9 (0x09)), a tab
\t * - \"\\n\" (ASCII 10 (0x0A)), a new line (line feed)
\t * - \"\\r\" (ASCII 13 (0x0D)), a carriage return
\t * - \"\\0\" (ASCII 0 (0x00)), the NUL-byte
\t * - \"\\x0B\" (ASCII 11 (0x0B)), a vertical tab
\t */
\trtrim: function(str, chars)
\t{
\t\tchars = chars || \"\\\\s\";
\t\t
\t\treturn (str != null) ? str.replace(new RegExp(\"[\" + chars + \"]+\$\", \"g\"), \"\") : null;
\t},
\t
\t/**
\t * Function: trim
\t * 
\t * Strips all whitespaces from both end of the string.
\t * Without the second parameter, Javascript function will trim these
\t * characters:
\t * 
\t * - \" \" (ASCII 32 (0x20)), an ordinary space
\t * - \"\\t\" (ASCII 9 (0x09)), a tab
\t * - \"\\n\" (ASCII 10 (0x0A)), a new line (line feed)
\t * - \"\\r\" (ASCII 13 (0x0D)), a carriage return
\t * - \"\\0\" (ASCII 0 (0x00)), the NUL-byte
\t * - \"\\x0B\" (ASCII 11 (0x0B)), a vertical tab
\t */
\ttrim: function(str, chars)
\t{
\t\treturn mxUtils.ltrim(mxUtils.rtrim(str, chars), chars);
\t},
\t
\t/**
\t * Function: isNumeric
\t * 
\t * Returns true if the specified value is numeric, that is, if it is not
\t * null, not an empty string, not a HEX number and isNaN returns false.
\t * 
\t * Parameters:
\t * 
\t * n - String representing the possibly numeric value.
\t */
\tisNumeric: function(n)
\t{
\t\treturn !isNaN(parseFloat(n)) && isFinite(n) && (typeof(n) != 'string' || n.toLowerCase().indexOf('0x') < 0);
\t},

\t/**
\t * Function: isInteger
\t * 
\t * Returns true if the given value is an valid integer number.
\t * 
\t * Parameters:
\t * 
\t * n - String representing the possibly numeric value.
\t */
\tisInteger: function(n)
\t{
\t\treturn String(parseInt(n)) === String(n);
\t},

\t/**
\t * Function: mod
\t * 
\t * Returns the remainder of division of n by m. You should use this instead
\t * of the built-in operation as the built-in operation does not properly
\t * handle negative numbers.
\t */
\tmod: function(n, m)
\t{
\t\treturn ((n % m) + m) % m;
\t},

\t/**
\t * Function: intersection
\t * 
\t * Returns the intersection of two lines as an <mxPoint>.
\t * 
\t * Parameters:
\t * 
\t * x0 - X-coordinate of the first line's startpoint.
\t * y0 - X-coordinate of the first line's startpoint.
\t * x1 - X-coordinate of the first line's endpoint.
\t * y1 - Y-coordinate of the first line's endpoint.
\t * x2 - X-coordinate of the second line's startpoint.
\t * y2 - Y-coordinate of the second line's startpoint.
\t * x3 - X-coordinate of the second line's endpoint.
\t * y3 - Y-coordinate of the second line's endpoint.
\t */
\tintersection: function (x0, y0, x1, y1, x2, y2, x3, y3)
\t{
\t\tvar denom = ((y3 - y2) * (x1 - x0)) - ((x3 - x2) * (y1 - y0));
\t\tvar nume_a = ((x3 - x2) * (y0 - y2)) - ((y3 - y2) * (x0 - x2));
\t\tvar nume_b = ((x1 - x0) * (y0 - y2)) - ((y1 - y0) * (x0 - x2));

\t\tvar ua = nume_a / denom;
\t\tvar ub = nume_b / denom;
\t\t
\t\tif(ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0)
\t\t{
\t\t\t// Get the intersection point
\t\t\tvar x = x0 + ua * (x1 - x0);
\t\t\tvar y = y0 + ua * (y1 - y0);
\t\t\t
\t\t\treturn new mxPoint(x, y);
\t\t}
\t\t
\t\t// No intersection
\t\treturn null;
\t},
\t
\t/**
\t * Function: ptSegDistSq
\t * 
\t * Returns the square distance between a segment and a point. To get the
\t * distance between a point and a line (with infinite length) use
\t * <mxUtils.ptLineDist>.
\t * 
\t * Parameters:
\t * 
\t * x1 - X-coordinate of the startpoint of the segment.
\t * y1 - Y-coordinate of the startpoint of the segment.
\t * x2 - X-coordinate of the endpoint of the segment.
\t * y2 - Y-coordinate of the endpoint of the segment.
\t * px - X-coordinate of the point.
\t * py - Y-coordinate of the point.
\t */
\tptSegDistSq: function(x1, y1, x2, y2, px, py)
    {
\t\tx2 -= x1;
\t\ty2 -= y1;

\t\tpx -= x1;
\t\tpy -= y1;

\t\tvar dotprod = px * x2 + py * y2;
\t\tvar projlenSq;

\t\tif (dotprod <= 0.0)
\t\t{
\t\t    projlenSq = 0.0;
\t\t}
\t\telse
\t\t{
\t\t    px = x2 - px;
\t\t    py = y2 - py;
\t\t    dotprod = px * x2 + py * y2;

\t\t    if (dotprod <= 0.0)
\t\t    {
\t\t\t\tprojlenSq = 0.0;
\t\t    }
\t\t    else
\t\t    {
\t\t\t\tprojlenSq = dotprod * dotprod / (x2 * x2 + y2 * y2);
\t\t    }
\t\t}

\t\tvar lenSq = px * px + py * py - projlenSq;
\t\t
\t\tif (lenSq < 0)
\t\t{
\t\t    lenSq = 0;
\t\t}
\t\t
\t\treturn lenSq;
    },
\t
\t/**
\t * Function: ptLineDist
\t * 
\t * Returns the distance between a line defined by two points and a point.
\t * To get the distance between a point and a segment (with a specific
\t * length) use <mxUtils.ptSeqDistSq>.
\t * 
\t * Parameters:
\t * 
\t * x1 - X-coordinate of point 1 of the line.
\t * y1 - Y-coordinate of point 1 of the line.
\t * x2 - X-coordinate of point 1 of the line.
\t * y2 - Y-coordinate of point 1 of the line.
\t * px - X-coordinate of the point.
\t * py - Y-coordinate of the point.
\t */
    ptLineDist: function(x1, y1, x2, y2, px, py)
    {
\t\treturn Math.abs((y2 - y1) * px - (x2 - x1) * py + x2 * y1 - y2 * x1) /
\t\t\tMath.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
    },
    \t
\t/**
\t * Function: relativeCcw
\t * 
\t * Returns 1 if the given point on the right side of the segment, 0 if its
\t * on the segment, and -1 if the point is on the left side of the segment.
\t * 
\t * Parameters:
\t * 
\t * x1 - X-coordinate of the startpoint of the segment.
\t * y1 - Y-coordinate of the startpoint of the segment.
\t * x2 - X-coordinate of the endpoint of the segment.
\t * y2 - Y-coordinate of the endpoint of the segment.
\t * px - X-coordinate of the point.
\t * py - Y-coordinate of the point.
\t */
\trelativeCcw: function(x1, y1, x2, y2, px, py)
    {
\t\tx2 -= x1;
\t\ty2 -= y1;
\t\tpx -= x1;
\t\tpy -= y1;
\t\tvar ccw = px * y2 - py * x2;
\t\t
\t\tif (ccw == 0.0)
\t\t{
\t\t    ccw = px * x2 + py * y2;
\t\t    
\t\t    if (ccw > 0.0)
\t\t    {
\t\t\t\tpx -= x2;
\t\t\t\tpy -= y2;
\t\t\t\tccw = px * x2 + py * y2;
\t\t\t\t
\t\t\t\tif (ccw < 0.0)
\t\t\t\t{
\t\t\t\t    ccw = 0.0;
\t\t\t\t}
\t\t    }
\t\t}
\t\t
\t\treturn (ccw < 0.0) ? -1 : ((ccw > 0.0) ? 1 : 0);
    },
    
\t/**
\t * Function: animateChanges
\t * 
\t * See <mxEffects.animateChanges>. This is for backwards compatibility and
\t * will be removed later.
\t */
\tanimateChanges: function(graph, changes)
\t{
\t\t// LATER: Deprecated, remove this function
    \tmxEffects.animateChanges.apply(this, arguments);
\t},
    
\t/**
\t * Function: cascadeOpacity
\t * 
\t * See <mxEffects.cascadeOpacity>. This is for backwards compatibility and
\t * will be removed later.
\t */
    cascadeOpacity: function(graph, cell, opacity)
\t{
\t\tmxEffects.cascadeOpacity.apply(this, arguments);
\t},

\t/**
\t * Function: fadeOut
\t * 
\t * See <mxEffects.fadeOut>. This is for backwards compatibility and
\t * will be removed later.
\t */
\tfadeOut: function(node, from, remove, step, delay, isEnabled)
\t{
\t\tmxEffects.fadeOut.apply(this, arguments);
\t},
\t
\t/**
\t * Function: setOpacity
\t * 
\t * Sets the opacity of the specified DOM node to the given value in %.
\t * 
\t * Parameters:
\t * 
\t * node - DOM node to set the opacity for.
\t * value - Opacity in %. Possible values are between 0 and 100.
\t */
\tsetOpacity: function(node, value)
\t{
\t\tif (mxUtils.isVml(node))
\t\t{
\t    \tif (value >= 100)
\t    \t{
\t    \t\tnode.style.filter = '';
\t    \t}
\t    \telse
\t    \t{
\t    \t\t// TODO: Why is the division by 5 needed in VML?
\t\t\t    node.style.filter = 'alpha(opacity=' + (value/5) + ')';
\t    \t}
\t\t}
\t\telse if (mxClient.IS_IE && (typeof(document.documentMode) === 'undefined' || document.documentMode < 9))
\t    {
\t    \tif (value >= 100)
\t    \t{
\t    \t\tnode.style.filter = '';
\t    \t}
\t    \telse
\t    \t{
\t\t\t    node.style.filter = 'alpha(opacity=' + value + ')';
\t    \t}
\t\t}
\t\telse
\t\t{
\t\t    node.style.opacity = (value / 100);
\t\t}
\t},

\t/**
\t * Function: createImage
\t * 
\t * Creates and returns an image (IMG node) or VML image (v:image) in IE6 in
\t * quirks mode.
\t * 
\t * Parameters:
\t * 
\t * src - URL that points to the image to be displayed.
\t */
\tcreateImage: function(src)
\t{
        var imageNode = null;
        
\t\tif (mxClient.IS_IE6 && document.compatMode != 'CSS1Compat')
\t\t{
        \timageNode = document.createElement(mxClient.VML_PREFIX + ':image');
        \timageNode.setAttribute('src', src);
        \timageNode.style.borderStyle = 'none';
        }
\t\telse
\t\t{
\t\t\timageNode = document.createElement('img');
\t\t\timageNode.setAttribute('src', src);
\t\t\timageNode.setAttribute('border', '0');
\t\t}
\t\t
\t\treturn imageNode;
\t},

\t/**
\t * Function: sortCells
\t * 
\t * Sorts the given cells according to the order in the cell hierarchy.
\t * Ascending is optional and defaults to true.
\t */
\tsortCells: function(cells, ascending)
\t{
\t\tascending = (ascending != null) ? ascending : true;
\t\tvar lookup = new mxDictionary();
\t\tcells.sort(function(o1, o2)
\t\t{
\t\t\tvar p1 = lookup.get(o1);
\t\t\t
\t\t\tif (p1 == null)
\t\t\t{
\t\t\t\tp1 = mxCellPath.create(o1).split(mxCellPath.PATH_SEPARATOR);
\t\t\t\tlookup.put(o1, p1);
\t\t\t}
\t\t\t
\t\t\tvar p2 = lookup.get(o2);
\t\t\t
\t\t\tif (p2 == null)
\t\t\t{
\t\t\t\tp2 = mxCellPath.create(o2).split(mxCellPath.PATH_SEPARATOR);
\t\t\t\tlookup.put(o2, p2);
\t\t\t}
\t\t\t
\t\t\tvar comp = mxCellPath.compare(p1, p2);
\t\t\t
\t\t\treturn (comp == 0) ? 0 : (((comp > 0) == ascending) ? 1 : -1);
\t\t});
\t\t
\t\treturn cells;
\t},

\t/**
\t * Function: getStylename
\t * 
\t * Returns the stylename in a style of the form [(stylename|key=value);] or
\t * an empty string if the given style does not contain a stylename.
\t * 
\t * Parameters:
\t * 
\t * style - String of the form [(stylename|key=value);].
\t */
\tgetStylename: function(style)
\t{
\t\tif (style != null)
\t\t{
\t\t\tvar pairs = style.split(';');
\t\t\tvar stylename = pairs[0];
\t\t\t
\t\t\tif (stylename.indexOf('=') < 0)
\t\t\t{
\t\t\t\treturn stylename;
\t\t\t}
\t\t}
\t\t\t\t
\t\treturn '';
\t},

\t/**
\t * Function: getStylenames
\t * 
\t * Returns the stylenames in a style of the form [(stylename|key=value);]
\t * or an empty array if the given style does not contain any stylenames.
\t * 
\t * Parameters:
\t * 
\t * style - String of the form [(stylename|key=value);].
\t */
\tgetStylenames: function(style)
\t{
\t\tvar result = [];
\t\t
\t\tif (style != null)
\t\t{
\t\t\tvar pairs = style.split(';');
\t\t\t
\t\t\tfor (var i = 0; i < pairs.length; i++)
\t\t\t{
\t\t\t\tif (pairs[i].indexOf('=') < 0)
\t\t\t\t{
\t\t\t\t\tresult.push(pairs[i]);
\t\t\t\t}
\t\t\t}
\t\t}
\t\t\t\t
\t\treturn result;
\t},

\t/**
\t * Function: indexOfStylename
\t * 
\t * Returns the index of the given stylename in the given style. This
\t * returns -1 if the given stylename does not occur (as a stylename) in the
\t * given style, otherwise it returns the index of the first character.
\t */
\tindexOfStylename: function(style, stylename)
\t{
\t\tif (style != null && stylename != null)
\t\t{
\t\t\tvar tokens = style.split(';');
\t\t\tvar pos = 0;
\t\t\t
\t\t\tfor (var i = 0; i < tokens.length; i++)
\t\t\t{
\t\t\t\tif (tokens[i] == stylename)
\t\t\t\t{
\t\t\t\t\treturn pos;
\t\t\t\t}
\t\t\t\t
\t\t\t\tpos += tokens[i].length + 1;
\t\t\t}
\t\t}

\t\treturn -1;
\t},
\t
\t/**
\t * Function: addStylename
\t * 
\t * Adds the specified stylename to the given style if it does not already
\t * contain the stylename.
\t */
\taddStylename: function(style, stylename)
\t{
\t\tif (mxUtils.indexOfStylename(style, stylename) < 0)
\t\t{
\t\t\tif (style == null)
\t\t\t{
\t\t\t\tstyle = '';
\t\t\t}
\t\t\telse if (style.length > 0 && style.charAt(style.length - 1) != ';')
\t\t\t{
\t\t\t\tstyle += ';';
\t\t\t}
\t\t\t
\t\t\tstyle += stylename;
\t\t}
\t\t
\t\treturn style;
\t},
\t
\t/**
\t * Function: removeStylename
\t * 
\t * Removes all occurrences of the specified stylename in the given style
\t * and returns the updated style. Trailing semicolons are not preserved.
\t */
\tremoveStylename: function(style, stylename)
\t{
\t\tvar result = [];
\t\t
\t\tif (style != null)
\t\t{
\t\t\tvar tokens = style.split(';');
\t\t\t
\t\t\tfor (var i = 0; i < tokens.length; i++)
\t\t\t{
\t\t\t\tif (tokens[i] != stylename)
\t\t\t\t{
\t\t\t\t\tresult.push(tokens[i]);
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn result.join(';');
\t},
\t
\t/**
\t * Function: removeAllStylenames
\t * 
\t * Removes all stylenames from the given style and returns the updated
\t * style.
\t */
\tremoveAllStylenames: function(style)
\t{
\t\tvar result = [];
\t\t
\t\tif (style != null)
\t\t{
\t\t\tvar tokens = style.split(';');
\t\t\t
\t\t\tfor (var i = 0; i < tokens.length; i++)
\t\t\t{
\t\t\t\t// Keeps the key, value assignments
\t\t\t\tif (tokens[i].indexOf('=') >= 0)
\t\t\t\t{
\t\t\t\t\tresult.push(tokens[i]);
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn result.join(';');
\t},

\t/**
\t * Function: setCellStyles
\t * 
\t * Assigns the value for the given key in the styles of the given cells, or
\t * removes the key from the styles if the value is null.
\t * 
\t * Parameters:
\t * 
\t * model - <mxGraphModel> to execute the transaction in.
\t * cells - Array of <mxCells> to be updated.
\t * key - Key of the style to be changed.
\t * value - New value for the given key.
\t */
\tsetCellStyles: function(model, cells, key, value)
\t{
\t\tif (cells != null && cells.length > 0)
\t\t{
\t\t\tmodel.beginUpdate();
\t\t\ttry
\t\t\t{
\t\t\t\tfor (var i = 0; i < cells.length; i++)
\t\t\t\t{
\t\t\t\t\tif (cells[i] != null)
\t\t\t\t\t{
\t\t\t\t\t\tvar style = mxUtils.setStyle(model.getStyle(cells[i]), key, value);
\t\t\t\t\t\tmodel.setStyle(cells[i], style);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t\tfinally
\t\t\t{
\t\t\t\tmodel.endUpdate();
\t\t\t}
\t\t}
\t},
\t
\t/**
\t * Function: setStyle
\t * 
\t * Adds or removes the given key, value pair to the style and returns the
\t * new style. If value is null or zero length then the key is removed from
\t * the style. This is for cell styles, not for CSS styles.
\t * 
\t * Parameters:
\t * 
\t * style - String of the form [(stylename|key=value);].
\t * key - Key of the style to be changed.
\t * value - New value for the given key.
\t */
\tsetStyle: function(style, key, value)
\t{
\t\tvar isValue = value != null && (typeof(value.length) == 'undefined' || value.length > 0);
\t\t
\t\tif (style == null || style.length == 0)
\t\t{
\t\t\tif (isValue)
\t\t\t{
\t\t\t\tstyle = key + '=' + value + ';';
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tif (style.substring(0, key.length + 1) == key + '=')
\t\t\t{
\t\t\t\tvar next = style.indexOf(';');
\t\t\t\t
\t\t\t\tif (isValue)
\t\t\t\t{
\t\t\t\t\tstyle = key + '=' + value + ((next < 0) ? ';' : style.substring(next));
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tstyle = (next < 0 || next == style.length - 1) ? '' : style.substring(next + 1);
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tvar index = style.indexOf(';' + key + '=');
\t\t\t\t
\t\t\t\tif (index < 0)
\t\t\t\t{
\t\t\t\t\tif (isValue)
\t\t\t\t\t{
\t\t\t\t\t\tvar sep = (style.charAt(style.length - 1) == ';') ? '' : ';';
\t\t\t\t\t\tstyle = style + sep + key + '=' + value + ';';
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tvar next = style.indexOf(';', index + 1);
\t\t\t\t\t
\t\t\t\t\tif (isValue)
\t\t\t\t\t{
\t\t\t\t\t\tstyle = style.substring(0, index + 1) + key + '=' + value + ((next < 0) ? ';' : style.substring(next));
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tstyle = style.substring(0, index) + ((next < 0) ? ';' : style.substring(next));
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\treturn style;
\t},

\t/**
\t * Function: setCellStyleFlags
\t * 
\t * Sets or toggles the flag bit for the given key in the cell's styles.
\t * If value is null then the flag is toggled.
\t * 
\t * Example:
\t * 
\t * (code)
\t * var cells = graph.getSelectionCells();
\t * mxUtils.setCellStyleFlags(graph.model,
\t * \t\t\tcells,
\t * \t\t\tmxConstants.STYLE_FONTSTYLE,
\t * \t\t\tmxConstants.FONT_BOLD);
\t * (end)
\t * 
\t * Toggles the bold font style.
\t * 
\t * Parameters:
\t * 
\t * model - <mxGraphModel> that contains the cells.
\t * cells - Array of <mxCells> to change the style for.
\t * key - Key of the style to be changed.
\t * flag - Integer for the bit to be changed.
\t * value - Optional boolean value for the flag.
\t */
\tsetCellStyleFlags: function(model, cells, key, flag, value)
\t{
\t\tif (cells != null && cells.length > 0)
\t\t{
\t\t\tmodel.beginUpdate();
\t\t\ttry
\t\t\t{
\t\t\t\tfor (var i = 0; i < cells.length; i++)
\t\t\t\t{
\t\t\t\t\tif (cells[i] != null)
\t\t\t\t\t{
\t\t\t\t\t\tvar style = mxUtils.setStyleFlag(
\t\t\t\t\t\t\tmodel.getStyle(cells[i]),
\t\t\t\t\t\t\tkey, flag, value);
\t\t\t\t\t\tmodel.setStyle(cells[i], style);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t\tfinally
\t\t\t{
\t\t\t\tmodel.endUpdate();
\t\t\t}
\t\t}
\t},
\t
\t/**
\t * Function: setStyleFlag
\t * 
\t * Sets or removes the given key from the specified style and returns the
\t * new style. If value is null then the flag is toggled.
\t * 
\t * Parameters:
\t * 
\t * style - String of the form [(stylename|key=value);].
\t * key - Key of the style to be changed.
\t * flag - Integer for the bit to be changed.
\t * value - Optional boolean value for the given flag.
\t */
\tsetStyleFlag: function(style, key, flag, value)
\t{
\t\tif (style == null || style.length == 0)
\t\t{
\t\t\tif (value || value == null)
\t\t\t{
\t\t\t\tstyle = key+'='+flag;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tstyle = key+'=0';
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tvar index = style.indexOf(key+'=');
\t\t\t
\t\t\tif (index < 0)
\t\t\t{
\t\t\t\tvar sep = (style.charAt(style.length-1) == ';') ? '' : ';';

\t\t\t\tif (value || value == null)
\t\t\t\t{
\t\t\t\t\tstyle = style + sep + key + '=' + flag;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tstyle = style + sep + key + '=0';
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tvar cont = style.indexOf(';', index);
\t\t\t\tvar tmp = '';
\t\t\t\t
\t\t\t\tif (cont < 0)
\t\t\t\t{
\t\t\t\t\ttmp  = style.substring(index+key.length+1);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\ttmp = style.substring(index+key.length+1, cont);
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (value == null)
\t\t\t\t{
\t\t\t\t\ttmp = parseInt(tmp) ^ flag;
\t\t\t\t}
\t\t\t\telse if (value)
\t\t\t\t{
\t\t\t\t\ttmp = parseInt(tmp) | flag;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\ttmp = parseInt(tmp) & ~flag;
\t\t\t\t}
\t\t\t\t
\t\t\t\tstyle = style.substring(0, index) + key + '=' + tmp +
\t\t\t\t\t((cont >= 0) ? style.substring(cont) : '');
\t\t\t}
\t\t}
\t\t
\t\treturn style;
\t},
\t
\t/**
\t * Function: getAlignmentAsPoint
\t * 
\t * Returns an <mxPoint> that represents the horizontal and vertical alignment
\t * for numeric computations. X is -0.5 for center, -1 for right and 0 for
\t * left alignment. Y is -0.5 for middle, -1 for bottom and 0 for top
\t * alignment. Default values for missing arguments is top, left.
\t */
\tgetAlignmentAsPoint: function(align, valign)
\t{
\t\tvar dx = -0.5;
\t\tvar dy = -0.5;
\t\t
\t\t// Horizontal alignment
\t\tif (align == mxConstants.ALIGN_LEFT)
\t\t{
\t\t\tdx = 0;
\t\t}
\t\telse if (align == mxConstants.ALIGN_RIGHT)
\t\t{
\t\t\tdx = -1;
\t\t}

\t\t// Vertical alignment
\t\tif (valign == mxConstants.ALIGN_TOP)
\t\t{
\t\t\tdy = 0;
\t\t}
\t\telse if (valign == mxConstants.ALIGN_BOTTOM)
\t\t{
\t\t\tdy = -1;
\t\t}
\t\t
\t\treturn new mxPoint(dx, dy);
\t},
\t
\t/**
\t * Function: getSizeForString
\t * 
\t * Returns an <mxRectangle> with the size (width and height in pixels) of
\t * the given string. The string may contain HTML markup. Newlines should be
\t * converted to <br> before calling this method. The caller is responsible
\t * for sanitizing the HTML markup.
\t * 
\t * Example:
\t * 
\t * (code)
\t * var label = graph.getLabel(cell).replace(/\\n/g, \"<br>\");
\t * var size = graph.getSizeForString(label);
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * text - String whose size should be returned.
\t * fontSize - Integer that specifies the font size in pixels. Default is
\t * <mxConstants.DEFAULT_FONTSIZE>.
\t * fontFamily - String that specifies the name of the font family. Default
\t * is <mxConstants.DEFAULT_FONTFAMILY>.
\t * textWidth - Optional width for text wrapping.
\t * fontStyle - Optional font style.
\t */
\tgetSizeForString: function(text, fontSize, fontFamily, textWidth, fontStyle)
\t{
\t\tfontSize = (fontSize != null) ? fontSize : mxConstants.DEFAULT_FONTSIZE;
\t\tfontFamily = (fontFamily != null) ? fontFamily : mxConstants.DEFAULT_FONTFAMILY;
\t\tvar div = document.createElement('div');
\t\t
\t\t// Sets the font size and family
\t\tdiv.style.fontFamily = fontFamily;
\t\tdiv.style.fontSize = Math.round(fontSize) + 'px';
\t\tdiv.style.lineHeight = Math.round(fontSize * mxConstants.LINE_HEIGHT) + 'px';
\t\t
\t\t// Sets the font style
\t\tif (fontStyle != null)
\t\t{
\t\t\tif ((fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t\t\t{
\t\t\t\tdiv.style.fontWeight = 'bold';
\t\t\t}
\t\t\t
\t\t\tif ((fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t\t\t{
\t\t\t\tdiv.style.fontStyle = 'italic';
\t\t\t}
\t\t\t
\t\t\tvar txtDecor = [];
\t\t\t
\t\t\tif ((fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t\t\t{
\t\t\t\ttxtDecor.push('underline');
\t\t\t}
\t\t\t
\t\t\tif ((fontStyle & mxConstants.FONT_STRIKETHROUGH) == mxConstants.FONT_STRIKETHROUGH)
\t\t\t{
\t\t\t\ttxtDecor.push('line-through');
\t\t\t}
\t\t\t
\t\t\tif (txtDecor.length > 0)
\t\t\t{
\t\t\t\tdiv.style.textDecoration = txtDecor.join(' ');
\t\t\t}
\t\t}
\t\t
\t\t// Disables block layout and outside wrapping and hides the div
\t\tdiv.style.position = 'absolute';
\t\tdiv.style.visibility = 'hidden';
\t\tdiv.style.display = (mxClient.IS_QUIRKS) ? 'inline' : 'inline-block';
\t\tdiv.style.zoom = '1';
\t\t
\t\tif (textWidth != null)
\t\t{
\t\t\tdiv.style.width = textWidth + 'px';
\t\t\tdiv.style.whiteSpace = 'normal';
\t\t}
\t\telse
\t\t{
\t\t\tdiv.style.whiteSpace = 'nowrap';
\t\t}
\t\t
\t\t// Adds the text and inserts into DOM for updating of size
\t\tdiv.innerHTML = text;
\t\tdocument.body.appendChild(div);
\t\t
\t\t// Gets the size and removes from DOM
\t\tvar size = new mxRectangle(0, 0, div.offsetWidth, div.offsetHeight);
\t\tdocument.body.removeChild(div);
\t\t
\t\treturn size;
\t},
\t
\t/**
\t * Function: getViewXml
\t */
\tgetViewXml: function(graph, scale, cells, x0, y0)
\t{
\t\tx0 = (x0 != null) ? x0 : 0;
\t\ty0 = (y0 != null) ? y0 : 0;
\t\tscale = (scale != null) ? scale : 1;

\t\tif (cells == null)
\t\t{
\t\t\tvar model = graph.getModel();
\t\t\tcells = [model.getRoot()];
\t\t}
\t\t
\t\tvar view = graph.getView();
\t\tvar result = null;

\t\t// Disables events on the view
\t\tvar eventsEnabled = view.isEventsEnabled();
\t\tview.setEventsEnabled(false);

\t\t// Workaround for label bounds not taken into account for image export.
\t\t// Creates a temporary draw pane which is used for rendering the text.
\t\t// Text rendering is required for finding the bounds of the labels.
\t\tvar drawPane = view.drawPane;
\t\tvar overlayPane = view.overlayPane;

\t\tif (graph.dialect == mxConstants.DIALECT_SVG)
\t\t{
\t\t\tview.drawPane = document.createElementNS(mxConstants.NS_SVG, 'g');
\t\t\tview.canvas.appendChild(view.drawPane);

\t\t\t// Redirects cell overlays into temporary container
\t\t\tview.overlayPane = document.createElementNS(mxConstants.NS_SVG, 'g');
\t\t\tview.canvas.appendChild(view.overlayPane);
\t\t}
\t\telse
\t\t{
\t\t\tview.drawPane = view.drawPane.cloneNode(false);
\t\t\tview.canvas.appendChild(view.drawPane);
\t\t\t
\t\t\t// Redirects cell overlays into temporary container
\t\t\tview.overlayPane = view.overlayPane.cloneNode(false);
\t\t\tview.canvas.appendChild(view.overlayPane);
\t\t}

\t\t// Resets the translation
\t\tvar translate = view.getTranslate();
\t\tview.translate = new mxPoint(x0, y0);

\t\t// Creates the temporary cell states in the view
\t\tvar temp = new mxTemporaryCellStates(graph.getView(), scale, cells);

\t\ttry
\t\t{
\t\t\tvar enc = new mxCodec();
\t\t\tresult = enc.encode(graph.getView());
\t\t}
\t\tfinally
\t\t{
\t\t\ttemp.destroy();
\t\t\tview.translate = translate;
\t\t\tview.canvas.removeChild(view.drawPane);
\t\t\tview.canvas.removeChild(view.overlayPane);
\t\t\tview.drawPane = drawPane;
\t\t\tview.overlayPane = overlayPane;
\t\t\tview.setEventsEnabled(eventsEnabled);
\t\t}

\t\treturn result;
\t},
\t
\t/**
\t * Function: getScaleForPageCount
\t * 
\t * Returns the scale to be used for printing the graph with the given
\t * bounds across the specifies number of pages with the given format. The
\t * scale is always computed such that it given the given amount or fewer
\t * pages in the print output. See <mxPrintPreview> for an example.
\t * 
\t * Parameters:
\t * 
\t * pageCount - Specifies the number of pages in the print output.
\t * graph - <mxGraph> that should be printed.
\t * pageFormat - Optional <mxRectangle> that specifies the page format.
\t * Default is <mxConstants.PAGE_FORMAT_A4_PORTRAIT>.
\t * border - The border along each side of every page.
\t */
\tgetScaleForPageCount: function(pageCount, graph, pageFormat, border)
\t{
\t\tif (pageCount < 1)
\t\t{
\t\t\t// We can't work with less than 1 page, return no scale
\t\t\t// change
\t\t\treturn 1;
\t\t}
\t\t
\t\tpageFormat = (pageFormat != null) ? pageFormat : mxConstants.PAGE_FORMAT_A4_PORTRAIT;
\t\tborder = (border != null) ? border : 0;
\t\t
\t\tvar availablePageWidth = pageFormat.width - (border * 2);
\t\tvar availablePageHeight = pageFormat.height - (border * 2);

\t\t// Work out the number of pages required if the
\t\t// graph is not scaled.
\t\tvar graphBounds = graph.getGraphBounds().clone();
\t\tvar sc = graph.getView().getScale();
\t\tgraphBounds.width /= sc;
\t\tgraphBounds.height /= sc;
\t\tvar graphWidth = graphBounds.width;
\t\tvar graphHeight = graphBounds.height;

\t\tvar scale = 1;
\t\t
\t\t// The ratio of the width/height for each printer page
\t\tvar pageFormatAspectRatio = availablePageWidth / availablePageHeight;
\t\t// The ratio of the width/height for the graph to be printer
\t\tvar graphAspectRatio = graphWidth / graphHeight;
\t\t
\t\t// The ratio of horizontal pages / vertical pages for this 
\t\t// graph to maintain its aspect ratio on this page format
\t\tvar pagesAspectRatio = graphAspectRatio / pageFormatAspectRatio;
\t\t
\t\t// Factor the square root of the page count up and down 
\t\t// by the pages aspect ratio to obtain a horizontal and 
\t\t// vertical page count that adds up to the page count
\t\t// and has the correct aspect ratio
\t\tvar pageRoot = Math.sqrt(pageCount);
\t\tvar pagesAspectRatioSqrt = Math.sqrt(pagesAspectRatio);
\t\tvar numRowPages = pageRoot * pagesAspectRatioSqrt;
\t\tvar numColumnPages = pageRoot / pagesAspectRatioSqrt;

\t\t// These value are rarely more than 2 rounding downs away from
\t\t// a total that meets the page count. In cases of one being less 
\t\t// than 1 page, the other value can be too high and take more iterations 
\t\t// In this case, just change that value to be the page count, since 
\t\t// we know the other value is 1
\t\tif (numRowPages < 1 && numColumnPages > pageCount)
\t\t{
\t\t\tvar scaleChange = numColumnPages / pageCount;
\t\t\tnumColumnPages = pageCount;
\t\t\tnumRowPages /= scaleChange;
\t\t}
\t\t
\t\tif (numColumnPages < 1 && numRowPages > pageCount)
\t\t{
\t\t\tvar scaleChange = numRowPages / pageCount;
\t\t\tnumRowPages = pageCount;
\t\t\tnumColumnPages /= scaleChange;
\t\t}\t\t

\t\tvar currentTotalPages = Math.ceil(numRowPages) * Math.ceil(numColumnPages);

\t\tvar numLoops = 0;
\t\t
\t\t// Iterate through while the rounded up number of pages comes to
\t\t// a total greater than the required number
\t\twhile (currentTotalPages > pageCount)
\t\t{
\t\t\t// Round down the page count (rows or columns) that is
\t\t\t// closest to its next integer down in percentage terms.
\t\t\t// i.e. Reduce the page total by reducing the total
\t\t\t// page area by the least possible amount

\t\t\tvar roundRowDownProportion = Math.floor(numRowPages) / numRowPages;
\t\t\tvar roundColumnDownProportion = Math.floor(numColumnPages) / numColumnPages;
\t\t\t
\t\t\t// If the round down proportion is, work out the proportion to
\t\t\t// round down to 1 page less
\t\t\tif (roundRowDownProportion == 1)
\t\t\t{
\t\t\t\troundRowDownProportion = Math.floor(numRowPages-1) / numRowPages;
\t\t\t}
\t\t\tif (roundColumnDownProportion == 1)
\t\t\t{
\t\t\t\troundColumnDownProportion = Math.floor(numColumnPages-1) / numColumnPages;
\t\t\t}
\t\t\t
\t\t\t// Check which rounding down is smaller, but in the case of very small roundings
\t\t\t// try the other dimension instead
\t\t\tvar scaleChange = 1;
\t\t\t
\t\t\t// Use the higher of the two values
\t\t\tif (roundRowDownProportion > roundColumnDownProportion)
\t\t\t{
\t\t\t\tscaleChange = roundRowDownProportion;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tscaleChange = roundColumnDownProportion;
\t\t\t}

\t\t\tnumRowPages = numRowPages * scaleChange;
\t\t\tnumColumnPages = numColumnPages * scaleChange;
\t\t\tcurrentTotalPages = Math.ceil(numRowPages) * Math.ceil(numColumnPages);
\t\t\t
\t\t\tnumLoops++;
\t\t\t
\t\t\tif (numLoops > 10)
\t\t\t{
\t\t\t\tbreak;
\t\t\t}
\t\t}

\t\t// Work out the scale from the number of row pages required
\t\t// The column pages will give the same value
\t\tvar posterWidth = availablePageWidth * numRowPages;
\t\tscale = posterWidth / graphWidth;
\t\t
\t\t// Allow for rounding errors
\t\treturn scale * 0.99999;
\t},
\t
\t/**
\t * Function: show
\t * 
\t * Copies the styles and the markup from the graph's container into the
\t * given document and removes all cursor styles. The document is returned.
\t * 
\t * This function should be called from within the document with the graph.
\t * If you experience problems with missing stylesheets in IE then try adding
\t * the domain to the trusted sites.
\t * 
\t * Parameters:
\t * 
\t * graph - <mxGraph> to be copied.
\t * doc - Document where the new graph is created.
\t * x0 - X-coordinate of the graph view origin. Default is 0.
\t * y0 - Y-coordinate of the graph view origin. Default is 0.
\t * w - Optional width of the graph view.
\t * h - Optional height of the graph view.
\t */
\tshow: function(graph, doc, x0, y0, w, h)
\t{
\t\tx0 = (x0 != null) ? x0 : 0;
\t\ty0 = (y0 != null) ? y0 : 0;
\t\t
\t\tif (doc == null)
\t\t{
\t\t\tvar wnd = window.open();
\t\t\tdoc = wnd.document;
\t\t}
\t\telse
\t\t{
\t\t\tdoc.open();
\t\t}

\t\t// Workaround for missing print output in IE9 standards
\t\tif (document.documentMode == 9)
\t\t{
\t\t\tdoc.writeln('<!--[if IE]><meta http-equiv=\"X-UA-Compatible\" content=\"IE=9\"><![endif]-->');
\t\t}
\t\t
\t\tvar bounds = graph.getGraphBounds();
\t\tvar dx = Math.ceil(x0 - bounds.x);
\t\tvar dy = Math.ceil(y0 - bounds.y);
\t\t
\t\tif (w == null)
\t\t{
\t\t\tw = Math.ceil(bounds.width + x0) + Math.ceil(Math.ceil(bounds.x) - bounds.x);
\t\t}
\t\t
\t\tif (h == null)
\t\t{
\t\t\th = Math.ceil(bounds.height + y0) + Math.ceil(Math.ceil(bounds.y) - bounds.y);
\t\t}
\t\t
\t\t// Needs a special way of creating the page so that no click is required
\t\t// to refresh the contents after the external CSS styles have been loaded.
\t\t// To avoid a click or programmatic refresh, the styleSheets[].cssText
\t\t// property is copied over from the original document.
\t\tif (mxClient.IS_IE || document.documentMode == 11)
\t\t{
\t\t\tvar html = '<html><head>';

\t\t\tvar base = document.getElementsByTagName('base');
\t\t\t
\t\t\tfor (var i = 0; i < base.length; i++)
\t\t\t{
\t\t\t\thtml += base[i].outerHTML;
\t\t\t}

\t\t\thtml += '<style>';

\t\t\t// Copies the stylesheets without having to load them again
\t\t\tfor (var i = 0; i < document.styleSheets.length; i++)
\t\t\t{
\t\t\t\ttry
\t\t\t\t{
\t\t\t\t\thtml += document.styleSheets[i].cssText;
\t\t\t\t}
\t\t\t\tcatch (e)
\t\t\t\t{
\t\t\t\t\t// ignore security exception
\t\t\t\t}
\t\t\t}

\t\t\thtml += '</style></head><body style=\"margin:0px;\">';
\t\t\t
\t\t\t// Copies the contents of the graph container
\t\t\thtml += '<div style=\"position:absolute;overflow:hidden;width:' + w + 'px;height:' + h + 'px;\"><div style=\"position:relative;left:' + dx + 'px;top:' + dy + 'px;\">';
\t\t\thtml += graph.container.innerHTML;
\t\t\thtml += '</div></div></body><html>';

\t\t\tdoc.writeln(html);
\t\t\tdoc.close();
\t\t}
\t\telse
\t\t{
\t\t\tdoc.writeln('<html><head>');
\t\t\t
\t\t\tvar base = document.getElementsByTagName('base');
\t\t\t
\t\t\tfor (var i = 0; i < base.length; i++)
\t\t\t{
\t\t\t\tdoc.writeln(mxUtils.getOuterHtml(base[i]));
\t\t\t}
\t\t\t
\t\t\tvar links = document.getElementsByTagName('link');
\t\t\t
\t\t\tfor (var i = 0; i < links.length; i++)
\t\t\t{
\t\t\t\tdoc.writeln(mxUtils.getOuterHtml(links[i]));
\t\t\t}
\t
\t\t\tvar styles = document.getElementsByTagName('style');
\t\t\t
\t\t\tfor (var i = 0; i < styles.length; i++)
\t\t\t{
\t\t\t\tdoc.writeln(mxUtils.getOuterHtml(styles[i]));
\t\t\t}

\t\t\tdoc.writeln('</head><body style=\"margin:0px;\"></body></html>');
\t\t\tdoc.close();

\t\t\tvar outer = doc.createElement('div');
\t\t\touter.position = 'absolute';
\t\t\touter.overflow = 'hidden';
\t\t\touter.style.width = w + 'px';
\t\t\touter.style.height = h + 'px';

\t\t\t// Required for HTML labels if foreignObjects are disabled
\t\t\tvar div = doc.createElement('div');
\t\t\tdiv.style.position = 'absolute';
\t\t\tdiv.style.left = dx + 'px';
\t\t\tdiv.style.top = dy + 'px';

\t\t\tvar node = graph.container.firstChild;
\t\t\tvar svg = null;
\t\t\t
\t\t\twhile (node != null)
\t\t\t{
\t\t\t\tvar clone = node.cloneNode(true);
\t\t\t\t
\t\t\t\tif (node == graph.view.drawPane.ownerSVGElement)
\t\t\t\t{
\t\t\t\t\touter.appendChild(clone);
\t\t\t\t\tsvg = clone;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tdiv.appendChild(clone);
\t\t\t\t}
\t\t\t\t
\t\t\t\tnode = node.nextSibling;
\t\t\t}

\t\t\tdoc.body.appendChild(outer);
\t\t\t
\t\t\tif (div.firstChild != null)
\t\t\t{
\t\t\t\tdoc.body.appendChild(div);
\t\t\t}
\t\t\t\t\t\t
\t\t\tif (svg != null)
\t\t\t{
\t\t\t\tsvg.style.minWidth = '';
\t\t\t\tsvg.style.minHeight = '';
\t\t\t\tsvg.firstChild.setAttribute('transform', 'translate(' + dx + ',' + dy + ')');
\t\t\t}
\t\t}
\t\t
\t\tmxUtils.removeCursors(doc.body);
\t
\t\treturn doc;
\t},
\t
\t/**
\t * Function: printScreen
\t * 
\t * Prints the specified graph using a new window and the built-in print
\t * dialog.
\t * 
\t * This function should be called from within the document with the graph.
\t * 
\t * Parameters:
\t * 
\t * graph - <mxGraph> to be printed.
\t */
\tprintScreen: function(graph)
\t{
\t\tvar wnd = window.open();
\t\tvar bounds = graph.getGraphBounds();
\t\tmxUtils.show(graph, wnd.document);
\t\t
\t\tvar print = function()
\t\t{
\t\t\twnd.focus();
\t\t\twnd.print();
\t\t\twnd.close();
\t\t};
\t\t
\t\t// Workaround for Google Chrome which needs a bit of a
\t\t// delay in order to render the SVG contents
\t\tif (mxClient.IS_GC)
\t\t{
\t\t\twnd.setTimeout(print, 500);
\t\t}
\t\telse
\t\t{
\t\t\tprint();
\t\t}
\t},
\t
\t/**
\t * Function: popup
\t * 
\t * Shows the specified text content in a new <mxWindow> or a new browser
\t * window if isInternalWindow is false.
\t * 
\t * Parameters:
\t * 
\t * content - String that specifies the text to be displayed.
\t * isInternalWindow - Optional boolean indicating if an mxWindow should be
\t * used instead of a new browser window. Default is false.
\t */
\tpopup: function(content, isInternalWindow)
\t{
\t   \tif (isInternalWindow)
\t   \t{
\t\t\tvar div = document.createElement('div');
\t\t\t
\t\t\tdiv.style.overflow = 'scroll';
\t\t\tdiv.style.width = '636px';
\t\t\tdiv.style.height = '460px';
\t\t\t
\t\t\tvar pre = document.createElement('pre');
\t\t    pre.innerHTML = mxUtils.htmlEntities(content, false).
\t\t    \treplace(/\\n/g,'<br>').replace(/ /g, '&nbsp;');
\t\t\t
\t\t\tdiv.appendChild(pre);
\t\t\t
\t\t\tvar w = document.body.clientWidth;
\t\t\tvar h = Math.max(document.body.clientHeight || 0, document.documentElement.clientHeight)
\t\t\tvar wnd = new mxWindow('Popup Window', div,
\t\t\t\tw/2-320, h/2-240, 640, 480, false, true);

\t\t\twnd.setClosable(true);
\t\t\twnd.setVisible(true);
\t\t}
\t\telse
\t\t{
\t\t\t// Wraps up the XML content in a textarea
\t\t\tif (mxClient.IS_NS)
\t\t\t{
\t\t\t    var wnd = window.open();
\t\t\t\twnd.document.writeln('<pre>'+mxUtils.htmlEntities(content)+'</pre');
\t\t\t   \twnd.document.close();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t    var wnd = window.open();
\t\t\t    var pre = wnd.document.createElement('pre');
\t\t\t    pre.innerHTML = mxUtils.htmlEntities(content, false).
\t\t\t    \treplace(/\\n/g,'<br>').replace(/ /g, '&nbsp;');
\t\t\t   \twnd.document.body.appendChild(pre);
\t\t\t}
\t   \t}
\t},
\t
\t/**
\t * Function: alert
\t * 
\t * Displayss the given alert in a new dialog. This implementation uses the
\t * built-in alert function. This is used to display validation errors when
\t * connections cannot be changed or created.
\t * 
\t * Parameters:
\t * 
\t * message - String specifying the message to be displayed.
\t */
\talert: function(message)
\t{
\t\talert(message);
\t},
\t
\t/**
\t * Function: prompt
\t * 
\t * Displays the given message in a prompt dialog. This implementation uses
\t * the built-in prompt function.
\t * 
\t * Parameters:
\t * 
\t * message - String specifying the message to be displayed.
\t * defaultValue - Optional string specifying the default value.
\t */
\tprompt: function(message, defaultValue)
\t{
\t\treturn prompt(message, (defaultValue != null) ? defaultValue : '');
\t},
\t
\t/**
\t * Function: confirm
\t * 
\t * Displays the given message in a confirm dialog. This implementation uses
\t * the built-in confirm function.
\t * 
\t * Parameters:
\t * 
\t * message - String specifying the message to be displayed.
\t */
\tconfirm: function(message)
\t{
\t\treturn confirm(message);
\t},

\t/**
\t * Function: error
\t * 
\t * Displays the given error message in a new <mxWindow> of the given width.
\t * If close is true then an additional close button is added to the window.
\t * The optional icon specifies the icon to be used for the window. Default
\t * is <mxUtils.errorImage>.
\t * 
\t * Parameters:
\t * 
\t * message - String specifying the message to be displayed.
\t * width - Integer specifying the width of the window.
\t * close - Optional boolean indicating whether to add a close button.
\t * icon - Optional icon for the window decoration.
\t */
\terror: function(message, width, close, icon)
\t{
\t\tvar div = document.createElement('div');
\t\tdiv.style.padding = '20px';

\t\tvar img = document.createElement('img');
\t\timg.setAttribute('src', icon || mxUtils.errorImage);
\t\timg.setAttribute('valign', 'bottom');
\t\timg.style.verticalAlign = 'middle';
\t\tdiv.appendChild(img);

\t\tdiv.appendChild(document.createTextNode('\\u00a0')); // &nbsp;
\t\tdiv.appendChild(document.createTextNode('\\u00a0')); // &nbsp;
\t\tdiv.appendChild(document.createTextNode('\\u00a0')); // &nbsp;
\t\tmxUtils.write(div, message);

\t\tvar w = document.body.clientWidth;
\t\tvar h = (document.body.clientHeight || document.documentElement.clientHeight);
\t\tvar warn = new mxWindow(mxResources.get(mxUtils.errorResource) ||
\t\t\tmxUtils.errorResource, div, (w-width)/2, h/4, width, null,
\t\t\tfalse, true);

\t\tif (close)
\t\t{
\t\t\tmxUtils.br(div);
\t\t\t
\t\t\tvar tmp = document.createElement('p');
\t\t\tvar button = document.createElement('button');

\t\t\tif (mxClient.IS_IE)
\t\t\t{
\t\t\t\tbutton.style.cssText = 'float:right';
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tbutton.setAttribute('style', 'float:right');
\t\t\t}

\t\t\tmxEvent.addListener(button, 'click', function(evt)
\t\t\t{
\t\t\t\twarn.destroy();
\t\t\t});

\t\t\tmxUtils.write(button, mxResources.get(mxUtils.closeResource) ||
\t\t\t\tmxUtils.closeResource);
\t\t\t
\t\t\ttmp.appendChild(button);
\t\t\tdiv.appendChild(tmp);
\t\t\t
\t\t\tmxUtils.br(div);
\t\t\t
\t\t\twarn.setClosable(true);
\t\t}
\t\t
\t\twarn.setVisible(true);
\t\t
\t\treturn warn;
\t},

\t/**
\t * Function: makeDraggable
\t * 
\t * Configures the given DOM element to act as a drag source for the
\t * specified graph. Returns a a new <mxDragSource>. If
\t * <mxDragSource.guideEnabled> is enabled then the x and y arguments must
\t * be used in funct to match the preview location.
\t * 
\t * Example:
\t * 
\t * (code)
\t * var funct = function(graph, evt, cell, x, y)
\t * {
\t *   if (graph.canImportCell(cell))
\t *   {
\t *     var parent = graph.getDefaultParent();
\t *     var vertex = null;
\t *     
\t *     graph.getModel().beginUpdate();
\t *     try
\t *     {
\t * \t     vertex = graph.insertVertex(parent, null, 'Hello', x, y, 80, 30);
\t *     }
\t *     finally
\t *     {
\t *       graph.getModel().endUpdate();
\t *     }
\t *
\t *     graph.setSelectionCell(vertex);
\t *   }
\t * }
\t * 
\t * var img = document.createElement('img');
\t * img.setAttribute('src', 'editors/images/rectangle.gif');
\t * img.style.position = 'absolute';
\t * img.style.left = '0px';
\t * img.style.top = '0px';
\t * img.style.width = '16px';
\t * img.style.height = '16px';
\t * 
\t * var dragImage = img.cloneNode(true);
\t * dragImage.style.width = '32px';
\t * dragImage.style.height = '32px';
\t * mxUtils.makeDraggable(img, graph, funct, dragImage);
\t * document.body.appendChild(img);
\t * (end)
\t * 
\t * Parameters:
\t * 
\t * element - DOM element to make draggable.
\t * graphF - <mxGraph> that acts as the drop target or a function that takes a
\t * mouse event and returns the current <mxGraph>.
\t * funct - Function to execute on a successful drop.
\t * dragElement - Optional DOM node to be used for the drag preview.
\t * dx - Optional horizontal offset between the cursor and the drag
\t * preview.
\t * dy - Optional vertical offset between the cursor and the drag
\t * preview.
\t * autoscroll - Optional boolean that specifies if autoscroll should be
\t * used. Default is mxGraph.autoscroll.
\t * scalePreview - Optional boolean that specifies if the preview element
\t * should be scaled according to the graph scale. If this is true, then
\t * the offsets will also be scaled. Default is false.
\t * highlightDropTargets - Optional boolean that specifies if dropTargets
\t * should be highlighted. Default is true.
\t * getDropTarget - Optional function to return the drop target for a given
\t * location (x, y). Default is mxGraph.getCellAt.
\t */
\tmakeDraggable: function(element, graphF, funct, dragElement, dx, dy, autoscroll,
\t\t\tscalePreview, highlightDropTargets, getDropTarget)
\t{
\t\tvar dragSource = new mxDragSource(element, funct);
\t\tdragSource.dragOffset = new mxPoint((dx != null) ? dx : 0,
\t\t\t(dy != null) ? dy : mxConstants.TOOLTIP_VERTICAL_OFFSET);
\t\tdragSource.autoscroll = autoscroll;
\t\t
\t\t// Cannot enable this by default. This needs to be enabled in the caller
\t\t// if the funct argument uses the new x- and y-arguments.
\t\tdragSource.setGuidesEnabled(false);
\t\t
\t\tif (highlightDropTargets != null)
\t\t{
\t\t\tdragSource.highlightDropTargets = highlightDropTargets;
\t\t}
\t\t
\t\t// Overrides function to find drop target cell
\t\tif (getDropTarget != null)
\t\t{
\t\t\tdragSource.getDropTarget = getDropTarget;
\t\t}
\t\t
\t\t// Overrides function to get current graph
\t\tdragSource.getGraphForEvent = function(evt)
\t\t{
\t\t\treturn (typeof(graphF) == 'function') ? graphF(evt) : graphF;
\t\t};
\t\t
\t\t// Translates switches into dragSource customizations
\t\tif (dragElement != null)
\t\t{
\t\t\tdragSource.createDragElement = function()
\t\t\t{
\t\t\t\treturn dragElement.cloneNode(true);
\t\t\t};
\t\t\t
\t\t\tif (scalePreview)
\t\t\t{
\t\t\t\tdragSource.createPreviewElement = function(graph)
\t\t\t\t{
\t\t\t\t\tvar elt = dragElement.cloneNode(true);

\t\t\t\t\tvar w = parseInt(elt.style.width);
\t\t\t\t\tvar h = parseInt(elt.style.height);
\t\t\t\t\telt.style.width = Math.round(w * graph.view.scale) + 'px';
\t\t\t\t\telt.style.height = Math.round(h * graph.view.scale) + 'px';
\t\t\t\t\t
\t\t\t\t\treturn elt;
\t\t\t\t};
\t\t\t}
\t\t}
\t\t
\t\treturn dragSource;
\t}

};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
 var mxConstants =
 {
\t/**
\t * Class: mxConstants
\t * 
\t * Defines various global constants.
\t * 
\t * Variable: DEFAULT_HOTSPOT
\t * 
\t * Defines the portion of the cell which is to be used as a connectable
\t * region. Default is 0.3. Possible values are 0 < x <= 1. 
\t */
\tDEFAULT_HOTSPOT: 0.3,

\t/**
\t * Variable: MIN_HOTSPOT_SIZE
\t * 
\t * Defines the minimum size in pixels of the portion of the cell which is
\t * to be used as a connectable region. Default is 8.
\t */
\tMIN_HOTSPOT_SIZE: 8,

\t/**
\t * Variable: MAX_HOTSPOT_SIZE
\t * 
\t * Defines the maximum size in pixels of the portion of the cell which is
\t * to be used as a connectable region. Use 0 for no maximum. Default is 0.
\t */
\tMAX_HOTSPOT_SIZE: 0,

\t/**
\t * Variable: RENDERING_HINT_EXACT
\t * 
\t * Defines the exact rendering hint.
\t */
\tRENDERING_HINT_EXACT: 'exact',

\t/**
\t * Variable: RENDERING_HINT_FASTER
\t * 
\t * Defines the faster rendering hint.
\t */
\tRENDERING_HINT_FASTER: 'faster',

\t/**
\t * Variable: RENDERING_HINT_FASTEST
\t * 
\t * Defines the fastest rendering hint.
\t */
\tRENDERING_HINT_FASTEST: 'fastest',

\t/**
\t * Variable: DIALECT_SVG
\t * 
\t * Defines the SVG display dialect name.
\t */
\tDIALECT_SVG: 'svg',

\t/**
\t * Variable: DIALECT_VML
\t * 
\t * Defines the VML display dialect name.
\t */
\tDIALECT_VML: 'vml',

\t/**
\t * Variable: DIALECT_MIXEDHTML
\t * 
\t * Defines the mixed HTML display dialect name.
\t */
\tDIALECT_MIXEDHTML: 'mixedHtml',

\t/**
\t * Variable: DIALECT_PREFERHTML
\t * 
\t * Defines the preferred HTML display dialect name.
\t */
\tDIALECT_PREFERHTML: 'preferHtml',

\t/**
\t * Variable: DIALECT_STRICTHTML
\t * 
\t * Defines the strict HTML display dialect.
\t */
\tDIALECT_STRICTHTML: 'strictHtml',

\t/**
\t * Variable: NS_SVG
\t * 
\t * Defines the SVG namespace.
\t */
\tNS_SVG: 'http://www.w3.org/2000/svg',

\t/**
\t * Variable: NS_XHTML
\t * 
\t * Defines the XHTML namespace.
\t */
\tNS_XHTML: 'http://www.w3.org/1999/xhtml',

\t/**
\t * Variable: NS_XLINK
\t * 
\t * Defines the XLink namespace.
\t */
\tNS_XLINK: 'http://www.w3.org/1999/xlink',

\t/**
\t * Variable: SHADOWCOLOR
\t * 
\t * Defines the color to be used to draw shadows in shapes and windows.
\t * Default is gray.
\t */
\tSHADOWCOLOR: 'gray',

\t/**
\t * Variable: VML_SHADOWCOLOR
\t * 
\t * Used for shadow color in filters where transparency is not supported
\t * (Microsoft Internet Explorer). Default is gray.
\t */
\tVML_SHADOWCOLOR: 'gray',

\t/**
\t * Variable: SHADOW_OFFSET_X
\t * 
\t * Specifies the x-offset of the shadow. Default is 2.
\t */
\tSHADOW_OFFSET_X: 2,

\t/**
\t * Variable: SHADOW_OFFSET_Y
\t * 
\t * Specifies the y-offset of the shadow. Default is 3.
\t */
\tSHADOW_OFFSET_Y: 3,
\t
\t/**
\t * Variable: SHADOW_OPACITY
\t * 
\t * Defines the opacity for shadows. Default is 1.
\t */
\tSHADOW_OPACITY: 1,
 
\t/**
\t * Variable: NODETYPE_ELEMENT
\t * 
\t * DOM node of type ELEMENT.
\t */
\tNODETYPE_ELEMENT: 1,

\t/**
\t * Variable: NODETYPE_ATTRIBUTE
\t * 
\t * DOM node of type ATTRIBUTE.
\t */
\tNODETYPE_ATTRIBUTE: 2,

\t/**
\t * Variable: NODETYPE_TEXT
\t * 
\t * DOM node of type TEXT.
\t */
\tNODETYPE_TEXT: 3,

\t/**
\t * Variable: NODETYPE_CDATA
\t * 
\t * DOM node of type CDATA.
\t */
\tNODETYPE_CDATA: 4,
\t
\t/**
\t * Variable: NODETYPE_ENTITY_REFERENCE
\t * 
\t * DOM node of type ENTITY_REFERENCE.
\t */
\tNODETYPE_ENTITY_REFERENCE: 5,

\t/**
\t * Variable: NODETYPE_ENTITY
\t * 
\t * DOM node of type ENTITY.
\t */
\tNODETYPE_ENTITY: 6,

\t/**
\t * Variable: NODETYPE_PROCESSING_INSTRUCTION
\t * 
\t * DOM node of type PROCESSING_INSTRUCTION.
\t */
\tNODETYPE_PROCESSING_INSTRUCTION: 7,

\t/**
\t * Variable: NODETYPE_COMMENT
\t * 
\t * DOM node of type COMMENT.
\t */
\tNODETYPE_COMMENT: 8,
\t\t
\t/**
\t * Variable: NODETYPE_DOCUMENT
\t * 
\t * DOM node of type DOCUMENT.
\t */
\tNODETYPE_DOCUMENT: 9,

\t/**
\t * Variable: NODETYPE_DOCUMENTTYPE
\t * 
\t * DOM node of type DOCUMENTTYPE.
\t */
\tNODETYPE_DOCUMENTTYPE: 10,

\t/**
\t * Variable: NODETYPE_DOCUMENT_FRAGMENT
\t * 
\t * DOM node of type DOCUMENT_FRAGMENT.
\t */
\tNODETYPE_DOCUMENT_FRAGMENT: 11,

\t/**
\t * Variable: NODETYPE_NOTATION
\t * 
\t * DOM node of type NOTATION.
\t */
\tNODETYPE_NOTATION: 12,
\t
\t/**
\t * Variable: TOOLTIP_VERTICAL_OFFSET
\t * 
\t * Defines the vertical offset for the tooltip.
\t * Default is 16.
\t */
\tTOOLTIP_VERTICAL_OFFSET: 16,

\t/**
\t * Variable: DEFAULT_VALID_COLOR
\t * 
\t * Specifies the default valid color. Default is #0000FF.
\t */
\tDEFAULT_VALID_COLOR: '#00FF00',

\t/**
\t * Variable: DEFAULT_INVALID_COLOR
\t * 
\t * Specifies the default invalid color. Default is #FF0000.
\t */
\tDEFAULT_INVALID_COLOR: '#FF0000',

\t/**
\t * Variable: OUTLINE_HIGHLIGHT_COLOR
\t * 
\t * Specifies the default highlight color for shape outlines.
\t * Default is #0000FF. This is used in <mxEdgeHandler>.
\t */
\tOUTLINE_HIGHLIGHT_COLOR: '#00FF00',

\t/**
\t * Variable: OUTLINE_HIGHLIGHT_COLOR
\t * 
\t * Defines the strokewidth to be used for shape outlines.
\t * Default is 5. This is used in <mxEdgeHandler>.
\t */
\tOUTLINE_HIGHLIGHT_STROKEWIDTH: 5,

\t/**
\t * Variable: HIGHLIGHT_STROKEWIDTH
\t * 
\t * Defines the strokewidth to be used for the highlights.
\t * Default is 3.
\t */
\tHIGHLIGHT_STROKEWIDTH: 3,

\t/**
\t * Variable: CONSTRAINT_HIGHLIGHT_SIZE
\t * 
\t * Size of the constraint highlight (in px). Default is 2.
\t */
\tHIGHLIGHT_SIZE: 2,
\t
\t/**
\t * Variable: HIGHLIGHT_OPACITY
\t * 
\t * Opacity (in %) used for the highlights (including outline).
\t * Default is 100.
\t */
\tHIGHLIGHT_OPACITY: 100,
\t
\t/**
\t * Variable: CURSOR_MOVABLE_VERTEX
\t * 
\t * Defines the cursor for a movable vertex. Default is 'move'.
\t */
\tCURSOR_MOVABLE_VERTEX: 'move',
\t
\t/**
\t * Variable: CURSOR_MOVABLE_EDGE
\t * 
\t * Defines the cursor for a movable edge. Default is 'move'.
\t */
\tCURSOR_MOVABLE_EDGE: 'move',
\t
\t/**
\t * Variable: CURSOR_LABEL_HANDLE
\t * 
\t * Defines the cursor for a movable label. Default is 'default'.
\t */
\tCURSOR_LABEL_HANDLE: 'default',
\t
\t/**
\t * Variable: CURSOR_TERMINAL_HANDLE
\t * 
\t * Defines the cursor for a terminal handle. Default is 'pointer'.
\t */
\tCURSOR_TERMINAL_HANDLE: 'pointer',
\t
\t/**
\t * Variable: CURSOR_BEND_HANDLE
\t * 
\t * Defines the cursor for a movable bend. Default is 'crosshair'.
\t */
\tCURSOR_BEND_HANDLE: 'crosshair',

\t/**
\t * Variable: CURSOR_VIRTUAL_BEND_HANDLE
\t * 
\t * Defines the cursor for a movable bend. Default is 'crosshair'.
\t */
\tCURSOR_VIRTUAL_BEND_HANDLE: 'crosshair',
\t
\t/**
\t * Variable: CURSOR_CONNECT
\t * 
\t * Defines the cursor for a connectable state. Default is 'pointer'.
\t */
\tCURSOR_CONNECT: 'pointer',

\t/**
\t * Variable: HIGHLIGHT_COLOR
\t * 
\t * Defines the color to be used for the cell highlighting.
\t * Use 'none' for no color. Default is #00FF00.
\t */
\tHIGHLIGHT_COLOR: '#00FF00',

\t/**
\t * Variable: TARGET_HIGHLIGHT_COLOR
\t * 
\t * Defines the color to be used for highlighting a target cell for a new
\t * or changed connection. Note that this may be either a source or
\t * target terminal in the graph. Use 'none' for no color.
\t * Default is #0000FF.
\t */
\tCONNECT_TARGET_COLOR: '#0000FF',

\t/**
\t * Variable: INVALID_CONNECT_TARGET_COLOR
\t * 
\t * Defines the color to be used for highlighting a invalid target cells
\t * for a new or changed connections. Note that this may be either a source
\t * or target terminal in the graph. Use 'none' for no color. Default is
\t * #FF0000.
\t */
\tINVALID_CONNECT_TARGET_COLOR: '#FF0000',

\t/**
\t * Variable: DROP_TARGET_COLOR
\t * 
\t * Defines the color to be used for the highlighting target parent cells
\t * (for drag and drop). Use 'none' for no color. Default is #0000FF.
\t */
\tDROP_TARGET_COLOR: '#0000FF',

\t/**
\t * Variable: VALID_COLOR
\t * 
\t * Defines the color to be used for the coloring valid connection
\t * previews. Use 'none' for no color. Default is #FF0000.
\t */
\tVALID_COLOR: '#00FF00',

\t/**
\t * Variable: INVALID_COLOR
\t * 
\t * Defines the color to be used for the coloring invalid connection
\t * previews. Use 'none' for no color. Default is #FF0000.
\t */
\tINVALID_COLOR: '#FF0000',

\t/**
\t * Variable: EDGE_SELECTION_COLOR
\t * 
\t * Defines the color to be used for the selection border of edges. Use
\t * 'none' for no color. Default is #00FF00.
\t */
\tEDGE_SELECTION_COLOR: '#00FF00',

\t/**
\t * Variable: VERTEX_SELECTION_COLOR
\t * 
\t * Defines the color to be used for the selection border of vertices. Use
\t * 'none' for no color. Default is #00FF00.
\t */
\tVERTEX_SELECTION_COLOR: '#00FF00',

\t/**
\t * Variable: VERTEX_SELECTION_STROKEWIDTH
\t * 
\t * Defines the strokewidth to be used for vertex selections.
\t * Default is 1.
\t */
\tVERTEX_SELECTION_STROKEWIDTH: 1,

\t/**
\t * Variable: EDGE_SELECTION_STROKEWIDTH
\t * 
\t * Defines the strokewidth to be used for edge selections.
\t * Default is 1.
\t */
\tEDGE_SELECTION_STROKEWIDTH: 1,

\t/**
\t * Variable: SELECTION_DASHED
\t * 
\t * Defines the dashed state to be used for the vertex selection
\t * border. Default is true.
\t */
\tVERTEX_SELECTION_DASHED: true,

\t/**
\t * Variable: SELECTION_DASHED
\t * 
\t * Defines the dashed state to be used for the edge selection
\t * border. Default is true.
\t */
\tEDGE_SELECTION_DASHED: true,

\t/**
\t * Variable: GUIDE_COLOR
\t * 
\t * Defines the color to be used for the guidelines in mxGraphHandler.
\t * Default is #FF0000.
\t */
\tGUIDE_COLOR: '#FF0000',

\t/**
\t * Variable: GUIDE_STROKEWIDTH
\t * 
\t * Defines the strokewidth to be used for the guidelines in mxGraphHandler.
\t * Default is 1.
\t */
\tGUIDE_STROKEWIDTH: 1,

\t/**
\t * Variable: OUTLINE_COLOR
\t * 
\t * Defines the color to be used for the outline rectangle
\t * border.  Use 'none' for no color. Default is #0099FF.
\t */
\tOUTLINE_COLOR: '#0099FF',

\t/**
\t * Variable: OUTLINE_STROKEWIDTH
\t * 
\t * Defines the strokewidth to be used for the outline rectangle
\t * stroke width. Default is 3.
\t */
\tOUTLINE_STROKEWIDTH: (mxClient.IS_IE) ? 2 : 3,

\t/**
\t * Variable: HANDLE_SIZE
\t * 
\t * Defines the default size for handles. Default is 6.
\t */
\tHANDLE_SIZE: 6,

\t/**
\t * Variable: LABEL_HANDLE_SIZE
\t * 
\t * Defines the default size for label handles. Default is 4.
\t */
\tLABEL_HANDLE_SIZE: 4,

\t/**
\t * Variable: HANDLE_FILLCOLOR
\t * 
\t * Defines the color to be used for the handle fill color. Use 'none' for
\t * no color. Default is #00FF00 (green).
\t */
\tHANDLE_FILLCOLOR: '#00FF00',

\t/**
\t * Variable: HANDLE_STROKECOLOR
\t * 
\t * Defines the color to be used for the handle stroke color. Use 'none' for
\t * no color. Default is black.
\t */
\tHANDLE_STROKECOLOR: 'black',

\t/**
\t * Variable: LABEL_HANDLE_FILLCOLOR
\t * 
\t * Defines the color to be used for the label handle fill color. Use 'none'
\t * for no color. Default is yellow.
\t */
\tLABEL_HANDLE_FILLCOLOR: 'yellow',

\t/**
\t * Variable: CONNECT_HANDLE_FILLCOLOR
\t * 
\t * Defines the color to be used for the connect handle fill color. Use
\t * 'none' for no color. Default is #0000FF (blue).
\t */
\tCONNECT_HANDLE_FILLCOLOR: '#0000FF',

\t/**
\t * Variable: LOCKED_HANDLE_FILLCOLOR
\t * 
\t * Defines the color to be used for the locked handle fill color. Use
\t * 'none' for no color. Default is #FF0000 (red).
\t */
\tLOCKED_HANDLE_FILLCOLOR: '#FF0000',

\t/**
\t * Variable: OUTLINE_HANDLE_FILLCOLOR
\t * 
\t * Defines the color to be used for the outline sizer fill color. Use
\t * 'none' for no color. Default is #00FFFF.
\t */
\tOUTLINE_HANDLE_FILLCOLOR: '#00FFFF',

\t/**
\t * Variable: OUTLINE_HANDLE_STROKECOLOR
\t * 
\t * Defines the color to be used for the outline sizer stroke color. Use
\t * 'none' for no color. Default is #0033FF.
\t */
\tOUTLINE_HANDLE_STROKECOLOR: '#0033FF',

\t/**
\t * Variable: DEFAULT_FONTFAMILY
\t * 
\t * Defines the default family for all fonts. Default is Arial,Helvetica.
\t */
\tDEFAULT_FONTFAMILY: 'Arial,Helvetica',

\t/**
\t * Variable: DEFAULT_FONTSIZE
\t * 
\t * Defines the default size (in px). Default is 11.
\t */
\tDEFAULT_FONTSIZE: 11,

\t/**
\t * Variable: DEFAULT_TEXT_DIRECTION
\t * 
\t * Defines the default value for the <STYLE_TEXT_DIRECTION> if no value is
\t * defined for it in the style. Default value is an empty string which means
\t * the default system setting is used and no direction is set.
\t */
\tDEFAULT_TEXT_DIRECTION: '',

\t/**
\t * Variable: LINE_HEIGHT
\t * 
\t * Defines the default line height for text labels. Default is 1.2.
\t */
\tLINE_HEIGHT: 1.2,

\t/**
\t * Variable: WORD_WRAP
\t * 
\t * Defines the CSS value for the word-wrap property. Default is \"normal\".
\t * Change this to \"break-word\" to allow long words to be able to be broken
\t * and wrap onto the next line.
\t */
\tWORD_WRAP: 'normal',

\t/**
\t * Variable: ABSOLUTE_LINE_HEIGHT
\t * 
\t * Specifies if absolute line heights should be used (px) in CSS. Default
\t * is false. Set this to true for backwards compatibility.
\t */
\tABSOLUTE_LINE_HEIGHT: false,

\t/**
\t * Variable: DEFAULT_FONTSTYLE
\t * 
\t * Defines the default style for all fonts. Default is 0. This can be set
\t * to any combination of font styles as follows.
\t * 
\t * (code)
\t * mxConstants.DEFAULT_FONTSTYLE = mxConstants.FONT_BOLD | mxConstants.FONT_ITALIC;
\t * (end)
\t */
\tDEFAULT_FONTSTYLE: 0,

\t/**
\t * Variable: DEFAULT_STARTSIZE
\t * 
\t * Defines the default start size for swimlanes. Default is 40.
\t */
\tDEFAULT_STARTSIZE: 40,

\t/**
\t * Variable: DEFAULT_MARKERSIZE
\t * 
\t * Defines the default size for all markers. Default is 6.
\t */
\tDEFAULT_MARKERSIZE: 6,

\t/**
\t * Variable: DEFAULT_IMAGESIZE
\t * 
\t * Defines the default width and height for images used in the
\t * label shape. Default is 24.
\t */
\tDEFAULT_IMAGESIZE: 24,

\t/**
\t * Variable: ENTITY_SEGMENT
\t * 
\t * Defines the length of the horizontal segment of an Entity Relation.
\t * This can be overridden using <mxConstants.STYLE_SEGMENT> style.
\t * Default is 30.
\t */
\tENTITY_SEGMENT: 30,

\t/**
\t * Variable: RECTANGLE_ROUNDING_FACTOR
\t * 
\t * Defines the rounding factor for rounded rectangles in percent between
\t * 0 and 1. Values should be smaller than 0.5. Default is 0.15.
\t */
\tRECTANGLE_ROUNDING_FACTOR: 0.15,

\t/**
\t * Variable: LINE_ARCSIZE
\t * 
\t * Defines the size of the arcs for rounded edges. Default is 20.
\t */
\tLINE_ARCSIZE: 20,

\t/**
\t * Variable: ARROW_SPACING
\t * 
\t * Defines the spacing between the arrow shape and its terminals. Default is 0.
\t */
\tARROW_SPACING: 0,

\t/**
\t * Variable: ARROW_WIDTH
\t * 
\t * Defines the width of the arrow shape. Default is 30.
\t */
\tARROW_WIDTH: 30,

\t/**
\t * Variable: ARROW_SIZE
\t * 
\t * Defines the size of the arrowhead in the arrow shape. Default is 30.
\t */
\tARROW_SIZE: 30,

\t/**
\t * Variable: PAGE_FORMAT_A4_PORTRAIT
\t * 
\t * Defines the rectangle for the A4 portrait page format. The dimensions
\t * of this page format are 826x1169 pixels.
\t */
\tPAGE_FORMAT_A4_PORTRAIT: new mxRectangle(0, 0, 827, 1169),

\t/**
\t * Variable: PAGE_FORMAT_A4_PORTRAIT
\t * 
\t * Defines the rectangle for the A4 portrait page format. The dimensions
\t * of this page format are 826x1169 pixels.
\t */
\tPAGE_FORMAT_A4_LANDSCAPE: new mxRectangle(0, 0, 1169, 827),

\t/**
\t * Variable: PAGE_FORMAT_LETTER_PORTRAIT
\t * 
\t * Defines the rectangle for the Letter portrait page format. The
\t * dimensions of this page format are 850x1100 pixels.
\t */
\tPAGE_FORMAT_LETTER_PORTRAIT: new mxRectangle(0, 0, 850, 1100),

\t/**
\t * Variable: PAGE_FORMAT_LETTER_PORTRAIT
\t * 
\t * Defines the rectangle for the Letter portrait page format. The dimensions
\t * of this page format are 850x1100 pixels.
\t */
\tPAGE_FORMAT_LETTER_LANDSCAPE: new mxRectangle(0, 0, 1100, 850),

\t/**
\t * Variable: NONE
\t * 
\t * Defines the value for none. Default is \"none\".
\t */
\tNONE: 'none',

\t/**
\t * Variable: STYLE_PERIMETER
\t * 
\t * Defines the key for the perimeter style. This is a function that defines
\t * the perimeter around a particular shape. Possible values are the
\t * functions defined in <mxPerimeter>. Alternatively, the constants in this
\t * class that start with \"PERIMETER_\" may be used to access
\t * perimeter styles in <mxStyleRegistry>. Value is \"perimeter\".
\t */
\tSTYLE_PERIMETER: 'perimeter',
\t
\t/**
\t * Variable: STYLE_SOURCE_PORT
\t * 
\t * Defines the ID of the cell that should be used for computing the
\t * perimeter point of the source for an edge. This allows for graphically
\t * connecting to a cell while keeping the actual terminal of the edge.
\t * Value is \"sourcePort\".
\t */
\tSTYLE_SOURCE_PORT: 'sourcePort',
\t
\t/**
\t * Variable: STYLE_TARGET_PORT
\t * 
\t * Defines the ID of the cell that should be used for computing the
\t * perimeter point of the target for an edge. This allows for graphically
\t * connecting to a cell while keeping the actual terminal of the edge.
\t * Value is \"targetPort\".
\t */
\tSTYLE_TARGET_PORT: 'targetPort',

\t/**
\t * Variable: STYLE_PORT_CONSTRAINT
\t * 
\t * Defines the direction(s) that edges are allowed to connect to cells in.
\t * Possible values are \"DIRECTION_NORTH, DIRECTION_SOUTH, 
\t * DIRECTION_EAST\" and \"DIRECTION_WEST\". Value is
\t * \"portConstraint\".
\t */
\tSTYLE_PORT_CONSTRAINT: 'portConstraint',

\t/**
\t * Variable: STYLE_PORT_CONSTRAINT_ROTATION
\t * 
\t * Define whether port constraint directions are rotated with vertex
\t * rotation. 0 (default) causes port constraints to remain absolute, 
\t * relative to the graph, 1 causes the constraints to rotate with
\t * the vertex. Value is \"portConstraintRotation\".
\t */
\tSTYLE_PORT_CONSTRAINT_ROTATION: 'portConstraintRotation',

\t/**
\t * Variable: STYLE_SOURCE_PORT_CONSTRAINT
\t * 
\t * Defines the direction(s) that edges are allowed to connect to sources in.
\t * Possible values are \"DIRECTION_NORTH, DIRECTION_SOUTH, DIRECTION_EAST\"
\t * and \"DIRECTION_WEST\". Value is \"sourcePortConstraint\".
\t */
\tSTYLE_SOURCE_PORT_CONSTRAINT: 'sourcePortConstraint',

\t/**
\t * Variable: STYLE_TARGET_PORT_CONSTRAINT
\t * 
\t * Defines the direction(s) that edges are allowed to connect to targets in.
\t * Possible values are \"DIRECTION_NORTH, DIRECTION_SOUTH, DIRECTION_EAST\"
\t * and \"DIRECTION_WEST\". Value is \"targetPortConstraint\".
\t */
\tSTYLE_TARGET_PORT_CONSTRAINT: 'targetPortConstraint',

\t/**
\t * Variable: STYLE_OPACITY
\t * 
\t * Defines the key for the opacity style. The type of the value is 
\t * numeric and the possible range is 0-100. Value is \"opacity\".
\t */
\tSTYLE_OPACITY: 'opacity',

\t/**
\t * Variable: STYLE_FILL_OPACITY
\t * 
\t * Defines the key for the fill opacity style. The type of the value is 
\t * numeric and the possible range is 0-100. Value is \"fillOpacity\".
\t */
\tSTYLE_FILL_OPACITY: 'fillOpacity',

\t/**
\t * Variable: STYLE_STROKE_OPACITY
\t * 
\t * Defines the key for the stroke opacity style. The type of the value is 
\t * numeric and the possible range is 0-100. Value is \"strokeOpacity\".
\t */
\tSTYLE_STROKE_OPACITY: 'strokeOpacity',

\t/**
\t * Variable: STYLE_TEXT_OPACITY
\t * 
\t * Defines the key for the text opacity style. The type of the value is 
\t * numeric and the possible range is 0-100. Value is \"textOpacity\".
\t */
\tSTYLE_TEXT_OPACITY: 'textOpacity',

\t/**
\t * Variable: STYLE_TEXT_DIRECTION
\t * 
\t * Defines the key for the text direction style. Possible values are
\t * \"TEXT_DIRECTION_DEFAULT, TEXT_DIRECTION_AUTO, TEXT_DIRECTION_LTR\"
\t * and \"TEXT_DIRECTION_RTL\". Value is \"textDirection\".
\t * The default value for the style is defined in <DEFAULT_TEXT_DIRECTION>.
\t * It is used is no value is defined for this key in a given style. This is
\t * an experimental style that is currently ignored in the backends.
\t */
\tSTYLE_TEXT_DIRECTION: 'textDirection',

\t/**
\t * Variable: STYLE_OVERFLOW
\t * 
\t * Defines the key for the overflow style. Possible values are 'visible',
\t * 'hidden', 'fill' and 'width'. The default value is 'visible'. This value
\t * specifies how overlapping vertex labels are handled. A value of
\t * 'visible' will show the complete label. A value of 'hidden' will clip
\t * the label so that it does not overlap the vertex bounds. A value of
\t * 'fill' will use the vertex bounds and a value of 'width' will use the
\t * vertex width for the label. See <mxGraph.isLabelClipped>. Note that
\t * the vertical alignment is ignored for overflow fill and for horizontal
\t * alignment, left should be used to avoid pixel offsets in Internet Explorer
\t * 11 and earlier or if foreignObjects are disabled. Value is \"overflow\".
\t */
\tSTYLE_OVERFLOW: 'overflow',

\t/**
\t * Variable: STYLE_ORTHOGONAL
\t * 
\t * Defines if the connection points on either end of the edge should be
\t * computed so that the edge is vertical or horizontal if possible and
\t * if the point is not at a fixed location. Default is false. This is
\t * used in <mxGraph.isOrthogonal>, which also returns true if the edgeStyle
\t * of the edge is an elbow or entity. Value is \"orthogonal\".
\t */
\tSTYLE_ORTHOGONAL: 'orthogonal',

\t/**
\t * Variable: STYLE_EXIT_X
\t * 
\t * Defines the key for the horizontal relative coordinate connection point
\t * of an edge with its source terminal. Value is \"exitX\".
\t */
\tSTYLE_EXIT_X: 'exitX',

\t/**
\t * Variable: STYLE_EXIT_Y
\t * 
\t * Defines the key for the vertical relative coordinate connection point
\t * of an edge with its source terminal. Value is \"exitY\".
\t */
\tSTYLE_EXIT_Y: 'exitY',

\t
\t/**
\t* Variable: STYLE_EXIT_DX
\t* 
\t* Defines the key for the horizontal offset of the connection point
\t* of an edge with its source terminal. Value is \"exitDx\".
\t*/
\tSTYLE_EXIT_DX: 'exitDx',

\t/**
\t* Variable: STYLE_EXIT_DY
\t* 
\t* Defines the key for the vertical offset of the connection point
\t* of an edge with its source terminal. Value is \"exitDy\".
\t*/
\tSTYLE_EXIT_DY: 'exitDy',
\t
\t/**
\t * Variable: STYLE_EXIT_PERIMETER
\t * 
\t * Defines if the perimeter should be used to find the exact entry point
\t * along the perimeter of the source. Possible values are 0 (false) and
\t * 1 (true). Default is 1 (true). Value is \"exitPerimeter\".
\t */
\tSTYLE_EXIT_PERIMETER: 'exitPerimeter',

\t/**
\t * Variable: STYLE_ENTRY_X
\t * 
\t * Defines the key for the horizontal relative coordinate connection point
\t * of an edge with its target terminal. Value is \"entryX\".
\t */
\tSTYLE_ENTRY_X: 'entryX',

\t/**
\t * Variable: STYLE_ENTRY_Y
\t * 
\t * Defines the key for the vertical relative coordinate connection point
\t * of an edge with its target terminal. Value is \"entryY\".
\t */
\tSTYLE_ENTRY_Y: 'entryY',

\t/**
\t * Variable: STYLE_ENTRY_DX
\t * 
\t* Defines the key for the horizontal offset of the connection point
\t* of an edge with its target terminal. Value is \"entryDx\".
\t*/
\tSTYLE_ENTRY_DX: 'entryDx',

\t/**
\t * Variable: STYLE_ENTRY_DY
\t * 
\t* Defines the key for the vertical offset of the connection point
\t* of an edge with its target terminal. Value is \"entryDy\".
\t*/
\tSTYLE_ENTRY_DY: 'entryDy',

\t/**
\t * Variable: STYLE_ENTRY_PERIMETER
\t * 
\t * Defines if the perimeter should be used to find the exact entry point
\t * along the perimeter of the target. Possible values are 0 (false) and
\t * 1 (true). Default is 1 (true). Value is \"entryPerimeter\".
\t */
\tSTYLE_ENTRY_PERIMETER: 'entryPerimeter',

\t/**
\t * Variable: STYLE_WHITE_SPACE
\t * 
\t * Defines the key for the white-space style. Possible values are 'nowrap'
\t * and 'wrap'. The default value is 'nowrap'. This value specifies how
\t * white-space inside a HTML vertex label should be handled. A value of
\t * 'nowrap' means the text will never wrap to the next line until a
\t * linefeed is encountered. A value of 'wrap' means text will wrap when
\t * necessary. This style is only used for HTML labels.
\t * See <mxGraph.isWrapping>. Value is \"whiteSpace\".
\t */
\tSTYLE_WHITE_SPACE: 'whiteSpace',

\t/**
\t * Variable: STYLE_ROTATION
\t * 
\t * Defines the key for the rotation style. The type of the value is 
\t * numeric and the possible range is 0-360. Value is \"rotation\".
\t */
\tSTYLE_ROTATION: 'rotation',

\t/**
\t * Variable: STYLE_FILLCOLOR
\t * 
\t * Defines the key for the fill color. Possible values are all HTML color
\t * names or HEX codes, as well as special keywords such as 'swimlane,
\t * 'inherit' or 'indicated' to use the color code of a related cell or the
\t * indicator shape. Value is \"fillColor\".
\t */
\tSTYLE_FILLCOLOR: 'fillColor',

\t/**
\t * Variable: STYLE_POINTER_EVENTS
\t * 
\t * Specifies if pointer events should be fired on transparent backgrounds.
\t * This style is currently only supported in <mxRectangleShape>. Default
\t * is true. Value is \"pointerEvents\". This is typically set to
\t * false in groups where the transparent part should allow any underlying
\t * cells to be clickable.
\t */
\tSTYLE_POINTER_EVENTS: 'pointerEvents',

\t/**
\t * Variable: STYLE_SWIMLANE_FILLCOLOR
\t * 
\t * Defines the key for the fill color of the swimlane background. Possible
\t * values are all HTML color names or HEX codes. Default is no background.
\t * Value is \"swimlaneFillColor\".
\t */
\tSTYLE_SWIMLANE_FILLCOLOR: 'swimlaneFillColor',

\t/**
\t * Variable: STYLE_MARGIN
\t * 
\t * Defines the key for the margin between the ellipses in the double ellipse shape.
\t * Possible values are all positive numbers. Value is \"margin\".
\t */
\tSTYLE_MARGIN: 'margin',

\t/**
\t * Variable: STYLE_GRADIENTCOLOR
\t * 
\t * Defines the key for the gradient color. Possible values are all HTML color
\t * names or HEX codes, as well as special keywords such as 'swimlane,
\t * 'inherit' or 'indicated' to use the color code of a related cell or the
\t * indicator shape. This is ignored if no fill color is defined. Value is
\t * \"gradientColor\".
\t */
\tSTYLE_GRADIENTCOLOR: 'gradientColor',

\t/**
\t * Variable: STYLE_GRADIENT_DIRECTION
\t * 
\t * Defines the key for the gradient direction. Possible values are
\t * <DIRECTION_EAST>, <DIRECTION_WEST>, <DIRECTION_NORTH> and
\t * <DIRECTION_SOUTH>. Default is <DIRECTION_SOUTH>. Generally, and by
\t * default in mxGraph, gradient painting is done from the value of
\t * <STYLE_FILLCOLOR> to the value of <STYLE_GRADIENTCOLOR>. Taking the
\t * example of <DIRECTION_NORTH>, this means <STYLE_FILLCOLOR> color at the 
\t * bottom of paint pattern and <STYLE_GRADIENTCOLOR> at top, with a
\t * gradient in-between. Value is \"gradientDirection\".
\t */
\tSTYLE_GRADIENT_DIRECTION: 'gradientDirection',

\t/**
\t * Variable: STYLE_STROKECOLOR
\t * 
\t * Defines the key for the strokeColor style. Possible values are all HTML
\t * color names or HEX codes, as well as special keywords such as 'swimlane,
\t * 'inherit', 'indicated' to use the color code of a related cell or the
\t * indicator shape or 'none' for no color. Value is \"strokeColor\".
\t */
\tSTYLE_STROKECOLOR: 'strokeColor',

\t/**
\t * Variable: STYLE_SEPARATORCOLOR
\t * 
\t * Defines the key for the separatorColor style. Possible values are all
\t * HTML color names or HEX codes. This style is only used for
\t * <SHAPE_SWIMLANE> shapes. Value is \"separatorColor\".
\t */
\tSTYLE_SEPARATORCOLOR: 'separatorColor',

\t/**
\t * Variable: STYLE_STROKEWIDTH
\t * 
\t * Defines the key for the strokeWidth style. The type of the value is 
\t * numeric and the possible range is any non-negative value larger or equal
\t * to 1. The value defines the stroke width in pixels. Note: To hide a
\t * stroke use strokeColor none. Value is \"strokeWidth\".
\t */
\tSTYLE_STROKEWIDTH: 'strokeWidth',

\t/**
\t * Variable: STYLE_ALIGN
\t * 
\t * Defines the key for the align style. Possible values are <ALIGN_LEFT>,
\t * <ALIGN_CENTER> and <ALIGN_RIGHT>. This value defines how the lines of
\t * the label are horizontally aligned. <ALIGN_LEFT> mean label text lines
\t * are aligned to left of the label bounds, <ALIGN_RIGHT> to the right of
\t * the label bounds and <ALIGN_CENTER> means the center of the text lines
\t * are aligned in the center of the label bounds. Note this value doesn't
\t * affect the positioning of the overall label bounds relative to the
\t * vertex, to move the label bounds horizontally, use
\t * <STYLE_LABEL_POSITION>. Value is \"align\".
\t */
\tSTYLE_ALIGN: 'align',

\t/**
\t * Variable: STYLE_VERTICAL_ALIGN
\t * 
\t * Defines the key for the verticalAlign style. Possible values are
\t * <ALIGN_TOP>, <ALIGN_MIDDLE> and <ALIGN_BOTTOM>. This value defines how
\t * the lines of the label are vertically aligned. <ALIGN_TOP> means the
\t * topmost label text line is aligned against the top of the label bounds,
\t * <ALIGN_BOTTOM> means the bottom-most label text line is aligned against
\t * the bottom of the label bounds and <ALIGN_MIDDLE> means there is equal
\t * spacing between the topmost text label line and the top of the label
\t * bounds and the bottom-most text label line and the bottom of the label
\t * bounds. Note this value doesn't affect the positioning of the overall
\t * label bounds relative to the vertex, to move the label bounds
\t * vertically, use <STYLE_VERTICAL_LABEL_POSITION>. Value is \"verticalAlign\".
\t */
\tSTYLE_VERTICAL_ALIGN: 'verticalAlign',

\t/**
\t * Variable: STYLE_LABEL_WIDTH
\t * 
\t * Defines the key for the width of the label if the label position is not
\t * center. Value is \"labelWidth\".
\t */
\tSTYLE_LABEL_WIDTH: 'labelWidth',

\t/**
\t * Variable: STYLE_LABEL_POSITION
\t * 
\t * Defines the key for the horizontal label position of vertices. Possible
\t * values are <ALIGN_LEFT>, <ALIGN_CENTER> and <ALIGN_RIGHT>. Default is
\t * <ALIGN_CENTER>. The label align defines the position of the label
\t * relative to the cell. <ALIGN_LEFT> means the entire label bounds is
\t * placed completely just to the left of the vertex, <ALIGN_RIGHT> means
\t * adjust to the right and <ALIGN_CENTER> means the label bounds are
\t * vertically aligned with the bounds of the vertex. Note this value
\t * doesn't affect the positioning of label within the label bounds, to move
\t * the label horizontally within the label bounds, use <STYLE_ALIGN>.
\t * Value is \"labelPosition\".
\t */
\tSTYLE_LABEL_POSITION: 'labelPosition',

\t/**
\t * Variable: STYLE_VERTICAL_LABEL_POSITION
\t * 
\t * Defines the key for the vertical label position of vertices. Possible
\t * values are <ALIGN_TOP>, <ALIGN_BOTTOM> and <ALIGN_MIDDLE>. Default is
\t * <ALIGN_MIDDLE>. The label align defines the position of the label
\t * relative to the cell. <ALIGN_TOP> means the entire label bounds is
\t * placed completely just on the top of the vertex, <ALIGN_BOTTOM> means
\t * adjust on the bottom and <ALIGN_MIDDLE> means the label bounds are
\t * horizontally aligned with the bounds of the vertex. Note this value
\t * doesn't affect the positioning of label within the label bounds, to move
\t * the label vertically within the label bounds, use
\t * <STYLE_VERTICAL_ALIGN>. Value is \"verticalLabelPosition\".
\t */
\tSTYLE_VERTICAL_LABEL_POSITION: 'verticalLabelPosition',
\t
\t/**
\t * Variable: STYLE_IMAGE_ASPECT
\t * 
\t * Defines the key for the image aspect style. Possible values are 0 (do
\t * not preserve aspect) or 1 (keep aspect). This is only used in
\t * <mxImageShape>. Default is 1. Value is \"imageAspect\".
\t */
\tSTYLE_IMAGE_ASPECT: 'imageAspect',

\t/**
\t * Variable: STYLE_IMAGE_ALIGN
\t * 
\t * Defines the key for the align style. Possible values are <ALIGN_LEFT>,
\t * <ALIGN_CENTER> and <ALIGN_RIGHT>. The value defines how any image in the
\t * vertex label is aligned horizontally within the label bounds of a
\t * <SHAPE_LABEL> shape. Value is \"imageAlign\".
\t */
\tSTYLE_IMAGE_ALIGN: 'imageAlign',

\t/**
\t * Variable: STYLE_IMAGE_VERTICAL_ALIGN
\t * 
\t * Defines the key for the verticalAlign style. Possible values are
\t * <ALIGN_TOP>, <ALIGN_MIDDLE> and <ALIGN_BOTTOM>. The value defines how
\t * any image in the vertex label is aligned vertically within the label
\t * bounds of a <SHAPE_LABEL> shape. Value is \"imageVerticalAlign\".
\t */
\tSTYLE_IMAGE_VERTICAL_ALIGN: 'imageVerticalAlign',

\t/**
\t * Variable: STYLE_GLASS
\t * 
\t * Defines the key for the glass style. Possible values are 0 (disabled) and
\t * 1(enabled). The default value is 0. This is used in <mxLabel>. Value is
\t * \"glass\".
\t */
\tSTYLE_GLASS: 'glass',

\t/**
\t * Variable: STYLE_IMAGE
\t * 
\t * Defines the key for the image style. Possible values are any image URL,
\t * the type of the value is String. This is the path to the image that is
\t * to be displayed within the label of a vertex. Data URLs should use the
\t * following format: data:image/png,xyz where xyz is the base64 encoded
\t * data (without the \"base64\"-prefix). Note that Data URLs are only
\t * supported in modern browsers. Value is \"image\".
\t */
\tSTYLE_IMAGE: 'image',

\t/**
\t * Variable: STYLE_IMAGE_WIDTH
\t * 
\t * Defines the key for the imageWidth style. The type of this value is
\t * int, the value is the image width in pixels and must be greater than 0.
\t * Value is \"imageWidth\".
\t */
\tSTYLE_IMAGE_WIDTH: 'imageWidth',

\t/**
\t * Variable: STYLE_IMAGE_HEIGHT
\t * 
\t * Defines the key for the imageHeight style. The type of this value is
\t * int, the value is the image height in pixels and must be greater than 0.
\t * Value is \"imageHeight\".
\t */
\tSTYLE_IMAGE_HEIGHT: 'imageHeight',

\t/**
\t * Variable: STYLE_IMAGE_BACKGROUND
\t * 
\t * Defines the key for the image background color. This style is only used
\t * in <mxImageShape>. Possible values are all HTML color names or HEX
\t * codes. Value is \"imageBackground\".
\t */
\tSTYLE_IMAGE_BACKGROUND: 'imageBackground',

\t/**
\t * Variable: STYLE_IMAGE_BORDER
\t * 
\t * Defines the key for the image border color. This style is only used in
\t * <mxImageShape>. Possible values are all HTML color names or HEX codes.
\t * Value is \"imageBorder\".
\t */
\tSTYLE_IMAGE_BORDER: 'imageBorder',

\t/**
\t * Variable: STYLE_FLIPH
\t * 
\t * Defines the key for the horizontal image flip. This style is only used
\t * in <mxImageShape>. Possible values are 0 and 1. Default is 0. Value is
\t * \"flipH\".
\t */
\tSTYLE_FLIPH: 'flipH',

\t/**
\t * Variable: STYLE_FLIPV
\t * 
\t * Defines the key for the vertical flip. Possible values are 0 and 1.
\t * Default is 0. Value is \"flipV\".
\t */
\tSTYLE_FLIPV: 'flipV',

\t/**
\t * Variable: STYLE_NOLABEL
\t * 
\t * Defines the key for the noLabel style. If this is true then no label is
\t * visible for a given cell. Possible values are true or false (1 or 0).
\t * Default is false. Value is \"noLabel\".
\t */
\tSTYLE_NOLABEL: 'noLabel',

\t/**
\t * Variable: STYLE_NOEDGESTYLE
\t * 
\t * Defines the key for the noEdgeStyle style. If this is true then no edge
\t * style is applied for a given edge. Possible values are true or false
\t * (1 or 0). Default is false. Value is \"noEdgeStyle\".
\t */
\tSTYLE_NOEDGESTYLE: 'noEdgeStyle',

\t/**
\t * Variable: STYLE_LABEL_BACKGROUNDCOLOR
\t * 
\t * Defines the key for the label background color. Possible values are all
\t * HTML color names or HEX codes. Value is \"labelBackgroundColor\".
\t */
\tSTYLE_LABEL_BACKGROUNDCOLOR: 'labelBackgroundColor',

\t/**
\t * Variable: STYLE_LABEL_BORDERCOLOR
\t * 
\t * Defines the key for the label border color. Possible values are all
\t * HTML color names or HEX codes. Value is \"labelBorderColor\".
\t */
\tSTYLE_LABEL_BORDERCOLOR: 'labelBorderColor',

\t/**
\t * Variable: STYLE_LABEL_PADDING
\t * 
\t * Defines the key for the label padding, ie. the space between the label
\t * border and the label. Value is \"labelPadding\".
\t */
\tSTYLE_LABEL_PADDING: 'labelPadding',

\t/**
\t * Variable: STYLE_INDICATOR_SHAPE
\t * 
\t * Defines the key for the indicator shape used within an <mxLabel>.
\t * Possible values are all SHAPE_* constants or the names of any new
\t * shapes. The indicatorShape has precedence over the indicatorImage.
\t * Value is \"indicatorShape\".
\t */
\tSTYLE_INDICATOR_SHAPE: 'indicatorShape',

\t/**
\t * Variable: STYLE_INDICATOR_IMAGE
\t * 
\t * Defines the key for the indicator image used within an <mxLabel>.
\t * Possible values are all image URLs. The indicatorShape has
\t * precedence over the indicatorImage. Value is \"indicatorImage\".
\t */
\tSTYLE_INDICATOR_IMAGE: 'indicatorImage',

\t/**
\t * Variable: STYLE_INDICATOR_COLOR
\t * 
\t * Defines the key for the indicatorColor style. Possible values are all
\t * HTML color names or HEX codes, as well as the special 'swimlane' keyword
\t * to refer to the color of the parent swimlane if one exists. Value is
\t * \"indicatorColor\".
\t */
\tSTYLE_INDICATOR_COLOR: 'indicatorColor',

\t/**
\t * Variable: STYLE_INDICATOR_STROKECOLOR
\t * 
\t * Defines the key for the indicator stroke color in <mxLabel>.
\t * Possible values are all color codes. Value is \"indicatorStrokeColor\".
\t */
\tSTYLE_INDICATOR_STROKECOLOR: 'indicatorStrokeColor',

\t/**
\t * Variable: STYLE_INDICATOR_GRADIENTCOLOR
\t * 
\t * Defines the key for the indicatorGradientColor style. Possible values
\t * are all HTML color names or HEX codes. This style is only supported in
\t * <SHAPE_LABEL> shapes. Value is \"indicatorGradientColor\".
\t */
\tSTYLE_INDICATOR_GRADIENTCOLOR: 'indicatorGradientColor',

\t/**
\t * Variable: STYLE_INDICATOR_SPACING
\t * 
\t * The defines the key for the spacing between the label and the
\t * indicator in <mxLabel>. Possible values are in pixels. Value is
\t * \"indicatorSpacing\".
\t */
\tSTYLE_INDICATOR_SPACING: 'indicatorSpacing',

\t/**
\t * Variable: STYLE_INDICATOR_WIDTH
\t * 
\t * Defines the key for the indicator width. Possible values start at 0 (in
\t * pixels). Value is \"indicatorWidth\".
\t */
\tSTYLE_INDICATOR_WIDTH: 'indicatorWidth',

\t/**
\t * Variable: STYLE_INDICATOR_HEIGHT
\t * 
\t * Defines the key for the indicator height. Possible values start at 0 (in
\t * pixels). Value is \"indicatorHeight\".
\t */
\tSTYLE_INDICATOR_HEIGHT: 'indicatorHeight',

\t/**
\t * Variable: STYLE_INDICATOR_DIRECTION
\t * 
\t * Defines the key for the indicatorDirection style. The direction style is
\t * used to specify the direction of certain shapes (eg. <mxTriangle>).
\t * Possible values are <DIRECTION_EAST> (default), <DIRECTION_WEST>,
\t * <DIRECTION_NORTH> and <DIRECTION_SOUTH>. Value is \"indicatorDirection\".
\t */
\tSTYLE_INDICATOR_DIRECTION: 'indicatorDirection',

\t/**
\t * Variable: STYLE_SHADOW
\t * 
\t * Defines the key for the shadow style. The type of the value is Boolean.
\t * Value is \"shadow\".
\t */
\tSTYLE_SHADOW: 'shadow',
\t
\t/**
\t * Variable: STYLE_SEGMENT
\t * 
\t * Defines the key for the segment style. The type of this value is float
\t * and the value represents the size of the horizontal segment of the
\t * entity relation style. Default is ENTITY_SEGMENT. Value is \"segment\".
\t */
\tSTYLE_SEGMENT: 'segment',
\t
\t/**
\t * Variable: STYLE_ENDARROW
\t *
\t * Defines the key for the end arrow marker. Possible values are all
\t * constants with an ARROW-prefix. This is only used in <mxConnector>.
\t * Value is \"endArrow\".
\t *
\t * Example:
\t * (code)
\t * style[mxConstants.STYLE_ENDARROW] = mxConstants.ARROW_CLASSIC;
\t * (end)
\t */
\tSTYLE_ENDARROW: 'endArrow',

\t/**
\t * Variable: STYLE_STARTARROW
\t * 
\t * Defines the key for the start arrow marker. Possible values are all
\t * constants with an ARROW-prefix. This is only used in <mxConnector>.
\t * See <STYLE_ENDARROW>. Value is \"startArrow\".
\t */
\tSTYLE_STARTARROW: 'startArrow',

\t/**
\t * Variable: STYLE_ENDSIZE
\t * 
\t * Defines the key for the endSize style. The type of this value is numeric
\t * and the value represents the size of the end marker in pixels. Value is
\t * \"endSize\".
\t */
\tSTYLE_ENDSIZE: 'endSize',

\t/**
\t * Variable: STYLE_STARTSIZE
\t * 
\t * Defines the key for the startSize style. The type of this value is
\t * numeric and the value represents the size of the start marker or the
\t * size of the swimlane title region depending on the shape it is used for.
\t * Value is \"startSize\".
\t */
\tSTYLE_STARTSIZE: 'startSize',

\t/**
\t * Variable: STYLE_SWIMLANE_LINE
\t * 
\t * Defines the key for the swimlaneLine style. This style specifies whether
\t * the line between the title regio of a swimlane should be visible. Use 0
\t * for hidden or 1 (default) for visible. Value is \"swimlaneLine\".
\t */
\tSTYLE_SWIMLANE_LINE: 'swimlaneLine',

\t/**
\t * Variable: STYLE_ENDFILL
\t * 
\t * Defines the key for the endFill style. Use 0 for no fill or 1 (default)
\t * for fill. (This style is only exported via <mxImageExport>.) Value is
\t * \"endFill\".
\t */
\tSTYLE_ENDFILL: 'endFill',

\t/**
\t * Variable: STYLE_STARTFILL
\t * 
\t * Defines the key for the startFill style. Use 0 for no fill or 1 (default)
\t * for fill. (This style is only exported via <mxImageExport>.) Value is
\t * \"startFill\".
\t */
\tSTYLE_STARTFILL: 'startFill',

\t/**
\t * Variable: STYLE_DASHED
\t * 
\t * Defines the key for the dashed style. Use 0 (default) for non-dashed or 1
\t * for dashed. Value is \"dashed\".
\t */
\tSTYLE_DASHED: 'dashed',

\t/**
\t * Variable: STYLE_DASH_PATTERN
\t * 
\t * Defines the key for the dashed pattern style in SVG and image exports.
\t * The type of this value is a space separated list of numbers that specify
\t * a custom-defined dash pattern. Dash styles are defined in terms of the
\t * length of the dash (the drawn part of the stroke) and the length of the
\t * space between the dashes. The lengths are relative to the line width: a
\t * length of \"1\" is equal to the line width. VML ignores this style and
\t * uses dashStyle instead as defined in the VML specification. This style
\t * is only used in the <mxConnector> shape. Value is \"dashPattern\".
\t */
\tSTYLE_DASH_PATTERN: 'dashPattern',

\t/**
\t * Variable: STYLE_FIX_DASH
\t * 
\t * Defines the key for the fixDash style. Use 0 (default) for dash patterns
\t * that depend on the linewidth and 1 for dash patterns that ignore the
\t * line width. Value is \"fixDash\".
\t */
\tSTYLE_FIX_DASH: 'fixDash',

\t/**
\t * Variable: STYLE_ROUNDED
\t * 
\t * Defines the key for the rounded style. The type of this value is
\t * Boolean. For edges this determines whether or not joins between edges
\t * segments are smoothed to a rounded finish. For vertices that have the
\t * rectangle shape, this determines whether or not the rectangle is
\t * rounded. Use 0 (default) for non-rounded or 1 for rounded. Value is
\t * \"rounded\".
\t */
\tSTYLE_ROUNDED: 'rounded',

\t/**
\t * Variable: STYLE_CURVED
\t * 
\t * Defines the key for the curved style. The type of this value is
\t * Boolean. It is only applicable for connector shapes. Use 0 (default)
\t * for non-curved or 1 for curved. Value is \"curved\".
\t */
\tSTYLE_CURVED: 'curved',

\t/**
\t * Variable: STYLE_ARCSIZE
\t * 
\t * Defines the rounding factor for a rounded rectangle in percent (without
\t * the percent sign). Possible values are between 0 and 100. If this value
\t * is not specified then RECTANGLE_ROUNDING_FACTOR * 100 is used. For
\t * edges, this defines the absolute size of rounded corners in pixels. If
\t * this values is not specified then LINE_ARCSIZE is used.
\t * (This style is only exported via <mxImageExport>.) Value is \"arcSize\".
\t */
\tSTYLE_ARCSIZE: 'arcSize',

\t/**
\t * Variable: STYLE_ABSOLUTE_ARCSIZE
\t * 
\t * Defines the key for the absolute arc size style. This specifies if
\t * arcSize for rectangles is abolute or relative. Possible values are 1
\t * and 0 (default). Value is \"absoluteArcSize\".
\t */
\tSTYLE_ABSOLUTE_ARCSIZE: 'absoluteArcSize',

\t/**
\t * Variable: STYLE_SOURCE_PERIMETER_SPACING
\t * 
\t * Defines the key for the source perimeter spacing. The type of this value
\t * is numeric. This is the distance between the source connection point of
\t * an edge and the perimeter of the source vertex in pixels. This style
\t * only applies to edges. Value is \"sourcePerimeterSpacing\".
\t */
\tSTYLE_SOURCE_PERIMETER_SPACING: 'sourcePerimeterSpacing',

\t/**
\t * Variable: STYLE_TARGET_PERIMETER_SPACING
\t * 
\t * Defines the key for the target perimeter spacing. The type of this value
\t * is numeric. This is the distance between the target connection point of
\t * an edge and the perimeter of the target vertex in pixels. This style
\t * only applies to edges. Value is \"targetPerimeterSpacing\".
\t */
\tSTYLE_TARGET_PERIMETER_SPACING: 'targetPerimeterSpacing',

\t/**
\t * Variable: STYLE_PERIMETER_SPACING
\t * 
\t * Defines the key for the perimeter spacing. This is the distance between
\t * the connection point and the perimeter in pixels. When used in a vertex
\t * style, this applies to all incoming edges to floating ports (edges that
\t * terminate on the perimeter of the vertex). When used in an edge style,
\t * this spacing applies to the source and target separately, if they
\t * terminate in floating ports (on the perimeter of the vertex). Value is
\t * \"perimeterSpacing\".
\t */
\tSTYLE_PERIMETER_SPACING: 'perimeterSpacing',

\t/**
\t * Variable: STYLE_SPACING
\t * 
\t * Defines the key for the spacing. The value represents the spacing, in
\t * pixels, added to each side of a label in a vertex (style applies to
\t * vertices only). Value is \"spacing\".
\t */
\tSTYLE_SPACING: 'spacing',

\t/**
\t * Variable: STYLE_SPACING_TOP
\t * 
\t * Defines the key for the spacingTop style. The value represents the
\t * spacing, in pixels, added to the top side of a label in a vertex (style
\t * applies to vertices only). Value is \"spacingTop\".
\t */
\tSTYLE_SPACING_TOP: 'spacingTop',

\t/**
\t * Variable: STYLE_SPACING_LEFT
\t * 
\t * Defines the key for the spacingLeft style. The value represents the
\t * spacing, in pixels, added to the left side of a label in a vertex (style
\t * applies to vertices only). Value is \"spacingLeft\".
\t */
\tSTYLE_SPACING_LEFT: 'spacingLeft',

\t/**
\t * Variable: STYLE_SPACING_BOTTOM
\t * 
\t * Defines the key for the spacingBottom style The value represents the
\t * spacing, in pixels, added to the bottom side of a label in a vertex
\t * (style applies to vertices only). Value is \"spacingBottom\".
\t */
\tSTYLE_SPACING_BOTTOM: 'spacingBottom',

\t/**
\t * Variable: STYLE_SPACING_RIGHT
\t * 
\t * Defines the key for the spacingRight style The value represents the
\t * spacing, in pixels, added to the right side of a label in a vertex (style
\t * applies to vertices only). Value is \"spacingRight\".
\t */
\tSTYLE_SPACING_RIGHT: 'spacingRight',

\t/**
\t * Variable: STYLE_HORIZONTAL
\t * 
\t * Defines the key for the horizontal style. Possible values are
\t * true or false. This value only applies to vertices. If the <STYLE_SHAPE>
\t * is \"SHAPE_SWIMLANE\" a value of false indicates that the
\t * swimlane should be drawn vertically, true indicates to draw it
\t * horizontally. If the shape style does not indicate that this vertex is a
\t * swimlane, this value affects only whether the label is drawn
\t * horizontally or vertically. Value is \"horizontal\".
\t */
\tSTYLE_HORIZONTAL: 'horizontal',

\t/**
\t * Variable: STYLE_DIRECTION
\t * 
\t * Defines the key for the direction style. The direction style is used
\t * to specify the direction of certain shapes (eg. <mxTriangle>).
\t * Possible values are <DIRECTION_EAST> (default), <DIRECTION_WEST>,
\t * <DIRECTION_NORTH> and <DIRECTION_SOUTH>. Value is \"direction\".
\t */
\tSTYLE_DIRECTION: 'direction',

\t/**
\t * Variable: STYLE_ANCHOR_POINT_DIRECTION
\t * 
\t * Defines the key for the anchorPointDirection style. The defines if the
\t * direction style should be taken into account when computing the fixed
\t * point location for connected edges. Default is 1 (yes). Set this to 0
\t * to ignore the direction style for fixed connection points. Value is
\t * \"anchorPointDirection\".
\t */
\tSTYLE_ANCHOR_POINT_DIRECTION: 'anchorPointDirection',

\t/**
\t * Variable: STYLE_ELBOW
\t * 
\t * Defines the key for the elbow style. Possible values are
\t * <ELBOW_HORIZONTAL> and <ELBOW_VERTICAL>. Default is <ELBOW_HORIZONTAL>.
\t * This defines how the three segment orthogonal edge style leaves its
\t * terminal vertices. The vertical style leaves the terminal vertices at
\t * the top and bottom sides. Value is \"elbow\".
\t */
\tSTYLE_ELBOW: 'elbow',

\t/**
\t * Variable: STYLE_FONTCOLOR
\t * 
\t * Defines the key for the fontColor style. Possible values are all HTML
\t * color names or HEX codes. Value is \"fontColor\".
\t */
\tSTYLE_FONTCOLOR: 'fontColor',

\t/**
\t * Variable: STYLE_FONTFAMILY
\t * 
\t * Defines the key for the fontFamily style. Possible values are names such
\t * as Arial; Dialog; Verdana; Times New Roman. The value is of type String.
\t * Value is fontFamily.
\t */
\tSTYLE_FONTFAMILY: 'fontFamily',

\t/**
\t * Variable: STYLE_FONTSIZE
\t * 
\t * Defines the key for the fontSize style (in px). The type of the value
\t * is int. Value is \"fontSize\".
\t */
\tSTYLE_FONTSIZE: 'fontSize',

\t/**
\t * Variable: STYLE_FONTSTYLE
\t * 
\t * Defines the key for the fontStyle style. Values may be any logical AND
\t * (sum) of <FONT_BOLD>, <FONT_ITALIC> and <FONT_UNDERLINE>.
\t * The type of the value is int. Value is \"fontStyle\".
\t */
\tSTYLE_FONTSTYLE: 'fontStyle',
\t
\t/**
\t * Variable: STYLE_ASPECT
\t * 
\t * Defines the key for the aspect style. Possible values are empty or fixed.
\t * If fixed is used then the aspect ratio of the cell will be maintained
\t * when resizing. Default is empty. Value is \"aspect\".
\t */
\tSTYLE_ASPECT: 'aspect',

\t/**
\t * Variable: STYLE_AUTOSIZE
\t * 
\t * Defines the key for the autosize style. This specifies if a cell should be
\t * resized automatically if the value has changed. Possible values are 0 or 1.
\t * Default is 0. See <mxGraph.isAutoSizeCell>. This is normally combined with
\t * <STYLE_RESIZABLE> to disable manual sizing. Value is \"autosize\".
\t */
\tSTYLE_AUTOSIZE: 'autosize',

\t/**
\t * Variable: STYLE_FOLDABLE
\t * 
\t * Defines the key for the foldable style. This specifies if a cell is foldable
\t * using a folding icon. Possible values are 0 or 1. Default is 1. See
\t * <mxGraph.isCellFoldable>. Value is \"foldable\".
\t */
\tSTYLE_FOLDABLE: 'foldable',

\t/**
\t * Variable: STYLE_EDITABLE
\t * 
\t * Defines the key for the editable style. This specifies if the value of
\t * a cell can be edited using the in-place editor. Possible values are 0 or
\t * 1. Default is 1. See <mxGraph.isCellEditable>. Value is \"editable\".
\t */
\tSTYLE_EDITABLE: 'editable',

\t/**
\t * Variable: STYLE_BACKGROUND_OUTLINE
\t * 
\t * Defines the key for the backgroundOutline style. This specifies if a
\t * only the background of a cell should be painted when it is highlighted.
\t * Possible values are 0 or 1. Default is 0. Value is \"backgroundOutline\".
\t */
\tSTYLE_BACKGROUND_OUTLINE: 'backgroundOutline',

\t/**
\t * Variable: STYLE_BENDABLE
\t * 
\t * Defines the key for the bendable style. This specifies if the control
\t * points of an edge can be moved. Possible values are 0 or 1. Default is
\t * 1. See <mxGraph.isCellBendable>. Value is \"bendable\".
\t */
\tSTYLE_BENDABLE: 'bendable',

\t/**
\t * Variable: STYLE_MOVABLE
\t * 
\t * Defines the key for the movable style. This specifies if a cell can
\t * be moved. Possible values are 0 or 1. Default is 1. See
\t * <mxGraph.isCellMovable>. Value is \"movable\".
\t */
\tSTYLE_MOVABLE: 'movable',

\t/**
\t * Variable: STYLE_RESIZABLE
\t * 
\t * Defines the key for the resizable style. This specifies if a cell can
\t * be resized. Possible values are 0 or 1. Default is 1. See
\t * <mxGraph.isCellResizable>. Value is \"resizable\".
\t */
\tSTYLE_RESIZABLE: 'resizable',

\t/**
\t * Variable: STYLE_RESIZE_WIDTH
\t * 
\t * Defines the key for the resizeWidth style. This specifies if a cell's
\t * width is resized if the parent is resized. If this is 1 then the width
\t * will be resized even if the cell's geometry is relative. If this is 0
\t * then the cell's width will not be resized. Default is not defined. Value
\t * is \"resizeWidth\".
\t */
\tSTYLE_RESIZE_WIDTH: 'resizeWidth',

\t/**
\t * Variable: STYLE_RESIZE_WIDTH
\t * 
\t * Defines the key for the resizeHeight style. This specifies if a cell's
\t * height if resize if the parent is resized. If this is 1 then the height
\t * will be resized even if the cell's geometry is relative. If this is 0
\t * then the cell's height will not be resized. Default is not defined. Value
\t * is \"resizeHeight\".
\t */
\tSTYLE_RESIZE_HEIGHT: 'resizeHeight',

\t/**
\t * Variable: STYLE_ROTATABLE
\t * 
\t * Defines the key for the rotatable style. This specifies if a cell can
\t * be rotated. Possible values are 0 or 1. Default is 1. See
\t * <mxGraph.isCellRotatable>. Value is \"rotatable\".
\t */
\tSTYLE_ROTATABLE: 'rotatable',

\t/**
\t * Variable: STYLE_CLONEABLE
\t * 
\t * Defines the key for the cloneable style. This specifies if a cell can
\t * be cloned. Possible values are 0 or 1. Default is 1. See
\t * <mxGraph.isCellCloneable>. Value is \"cloneable\".
\t */
\tSTYLE_CLONEABLE: 'cloneable',

\t/**
\t * Variable: STYLE_DELETABLE
\t * 
\t * Defines the key for the deletable style. This specifies if a cell can be
\t * deleted. Possible values are 0 or 1. Default is 1. See
\t * <mxGraph.isCellDeletable>. Value is \"deletable\".
\t */
\tSTYLE_DELETABLE: 'deletable',

\t/**
\t * Variable: STYLE_SHAPE
\t * 
\t * Defines the key for the shape. Possible values are all constants with
\t * a SHAPE-prefix or any newly defined shape names. Value is \"shape\".
\t */
\tSTYLE_SHAPE: 'shape',

\t/**
\t * Variable: STYLE_EDGE
\t * 
\t * Defines the key for the edge style. Possible values are the functions
\t * defined in <mxEdgeStyle>. Value is \"edgeStyle\".
\t */
\tSTYLE_EDGE: 'edgeStyle',

\t/**
\t * Variable: STYLE_JETTY_SIZE
\t * 
\t * Defines the key for the jetty size in <mxEdgeStyle.OrthConnector>.
\t * Default is 10. Possible values are all numeric values or \"auto\".
\t * Jetty size is the minimum length of the orthogonal segment before
\t * it attaches to a shape.
\t * Value is \"jettySize\".
\t */
\tSTYLE_JETTY_SIZE: 'jettySize',

\t/**
\t * Variable: STYLE_SOURCE_JETTY_SIZE
\t * 
\t * Defines the key for the jetty size in <mxEdgeStyle.OrthConnector>.
\t * Default is 10. Possible values are numeric values or \"auto\". This has
\t * precedence over <STYLE_JETTY_SIZE>. Value is \"sourceJettySize\".
\t */
\tSTYLE_SOURCE_JETTY_SIZE: 'sourceJettySize',

\t/**
\t * Variable: targetJettySize
\t * 
\t * Defines the key for the jetty size in <mxEdgeStyle.OrthConnector>.
\t * Default is 10. Possible values are numeric values or \"auto\". This has
\t * precedence over <STYLE_JETTY_SIZE>. Value is \"targetJettySize\".
\t */
\tSTYLE_TARGET_JETTY_SIZE: 'targetJettySize',

\t/**
\t * Variable: STYLE_LOOP
\t * 
\t * Defines the key for the loop style. Possible values are the functions
\t * defined in <mxEdgeStyle>. Value is \"loopStyle\". Default is
\t * <mxGraph.defaultLoopStylean>.
\t */
\tSTYLE_LOOP: 'loopStyle',

\t/**
\t * Variable: STYLE_ORTHOGONAL_LOOP
\t * 
\t * Defines the key for the orthogonal loop style. Possible values are 0 and
\t * 1. Default is 0. Value is \"orthogonalLoop\". Use this style to specify
\t * if loops with no waypoints and defined anchor points should be routed
\t * using <STYLE_LOOP> or not routed.
\t */
\tSTYLE_ORTHOGONAL_LOOP: 'orthogonalLoop',

\t/**
\t * Variable: STYLE_ROUTING_CENTER_X
\t * 
\t * Defines the key for the horizontal routing center. Possible values are
\t * between -0.5 and 0.5. This is the relative offset from the center used
\t * for connecting edges. The type of this value is numeric. Value is
\t * \"routingCenterX\".
\t */
\tSTYLE_ROUTING_CENTER_X: 'routingCenterX',

\t/**
\t * Variable: STYLE_ROUTING_CENTER_Y
\t * 
\t * Defines the key for the vertical routing center. Possible values are
\t * between -0.5 and 0.5. This is the relative offset from the center used
\t * for connecting edges. The type of this value is numeric. Value is
\t * \"routingCenterY\".
\t */
\tSTYLE_ROUTING_CENTER_Y: 'routingCenterY',

\t/**
\t * Variable: FONT_BOLD
\t * 
\t * Constant for bold fonts. Default is 1.
\t */
\tFONT_BOLD: 1,

\t/**
\t * Variable: FONT_ITALIC
\t * 
\t * Constant for italic fonts. Default is 2.
\t */
\tFONT_ITALIC: 2,

\t/**
\t * Variable: FONT_UNDERLINE
\t * 
\t * Constant for underlined fonts. Default is 4.
\t */
\tFONT_UNDERLINE: 4,

\t/**
\t * Variable: FONT_STRIKETHROUGH
\t * 
\t * Constant for strikthrough fonts. Default is 8.
\t */
\tFONT_STRIKETHROUGH: 8,
\t
\t/**
\t * Variable: SHAPE_RECTANGLE
\t * 
\t * Name under which <mxRectangleShape> is registered in <mxCellRenderer>.
\t * Default is rectangle.
\t */
\tSHAPE_RECTANGLE: 'rectangle',

\t/**
\t * Variable: SHAPE_ELLIPSE
\t * 
\t * Name under which <mxEllipse> is registered in <mxCellRenderer>.
\t * Default is ellipse.
\t */
\tSHAPE_ELLIPSE: 'ellipse',

\t/**
\t * Variable: SHAPE_DOUBLE_ELLIPSE
\t * 
\t * Name under which <mxDoubleEllipse> is registered in <mxCellRenderer>.
\t * Default is doubleEllipse.
\t */
\tSHAPE_DOUBLE_ELLIPSE: 'doubleEllipse',

\t/**
\t * Variable: SHAPE_RHOMBUS
\t * 
\t * Name under which <mxRhombus> is registered in <mxCellRenderer>.
\t * Default is rhombus.
\t */
\tSHAPE_RHOMBUS: 'rhombus',

\t/**
\t * Variable: SHAPE_LINE
\t * 
\t * Name under which <mxLine> is registered in <mxCellRenderer>.
\t * Default is line.
\t */
\tSHAPE_LINE: 'line',

\t/**
\t * Variable: SHAPE_IMAGE
\t * 
\t * Name under which <mxImageShape> is registered in <mxCellRenderer>.
\t * Default is image.
\t */
\tSHAPE_IMAGE: 'image',
\t
\t/**
\t * Variable: SHAPE_ARROW
\t * 
\t * Name under which <mxArrow> is registered in <mxCellRenderer>.
\t * Default is arrow.
\t */
\tSHAPE_ARROW: 'arrow',
\t
\t/**
\t * Variable: SHAPE_ARROW_CONNECTOR
\t * 
\t * Name under which <mxArrowConnector> is registered in <mxCellRenderer>.
\t * Default is arrowConnector.
\t */
\tSHAPE_ARROW_CONNECTOR: 'arrowConnector',
\t
\t/**
\t * Variable: SHAPE_LABEL
\t * 
\t * Name under which <mxLabel> is registered in <mxCellRenderer>.
\t * Default is label.
\t */
\tSHAPE_LABEL: 'label',
\t
\t/**
\t * Variable: SHAPE_CYLINDER
\t * 
\t * Name under which <mxCylinder> is registered in <mxCellRenderer>.
\t * Default is cylinder.
\t */
\tSHAPE_CYLINDER: 'cylinder',
\t
\t/**
\t * Variable: SHAPE_SWIMLANE
\t * 
\t * Name under which <mxSwimlane> is registered in <mxCellRenderer>.
\t * Default is swimlane.
\t */
\tSHAPE_SWIMLANE: 'swimlane',
\t\t
\t/**
\t * Variable: SHAPE_CONNECTOR
\t * 
\t * Name under which <mxConnector> is registered in <mxCellRenderer>.
\t * Default is connector.
\t */
\tSHAPE_CONNECTOR: 'connector',

\t/**
\t * Variable: SHAPE_ACTOR
\t * 
\t * Name under which <mxActor> is registered in <mxCellRenderer>.
\t * Default is actor.
\t */
\tSHAPE_ACTOR: 'actor',
\t\t
\t/**
\t * Variable: SHAPE_CLOUD
\t * 
\t * Name under which <mxCloud> is registered in <mxCellRenderer>.
\t * Default is cloud.
\t */
\tSHAPE_CLOUD: 'cloud',
\t\t
\t/**
\t * Variable: SHAPE_TRIANGLE
\t * 
\t * Name under which <mxTriangle> is registered in <mxCellRenderer>.
\t * Default is triangle.
\t */
\tSHAPE_TRIANGLE: 'triangle',
\t\t
\t/**
\t * Variable: SHAPE_HEXAGON
\t * 
\t * Name under which <mxHexagon> is registered in <mxCellRenderer>.
\t * Default is hexagon.
\t */
\tSHAPE_HEXAGON: 'hexagon',

\t/**
\t * Variable: ARROW_CLASSIC
\t * 
\t * Constant for classic arrow markers.
\t */
\tARROW_CLASSIC: 'classic',

\t/**
\t * Variable: ARROW_CLASSIC_THIN
\t * 
\t * Constant for thin classic arrow markers.
\t */
\tARROW_CLASSIC_THIN: 'classicThin',

\t/**
\t * Variable: ARROW_BLOCK
\t * 
\t * Constant for block arrow markers.
\t */
\tARROW_BLOCK: 'block',

\t/**
\t * Variable: ARROW_BLOCK_THIN
\t * 
\t * Constant for thin block arrow markers.
\t */
\tARROW_BLOCK_THIN: 'blockThin',

\t/**
\t * Variable: ARROW_OPEN
\t * 
\t * Constant for open arrow markers.
\t */
\tARROW_OPEN: 'open',

\t/**
\t * Variable: ARROW_OPEN_THIN
\t * 
\t * Constant for thin open arrow markers.
\t */
\tARROW_OPEN_THIN: 'openThin',

\t/**
\t * Variable: ARROW_OVAL
\t * 
\t * Constant for oval arrow markers.
\t */
\tARROW_OVAL: 'oval',

\t/**
\t * Variable: ARROW_DIAMOND
\t * 
\t * Constant for diamond arrow markers.
\t */
\tARROW_DIAMOND: 'diamond',

\t/**
\t * Variable: ARROW_DIAMOND_THIN
\t * 
\t * Constant for thin diamond arrow markers.
\t */
\tARROW_DIAMOND_THIN: 'diamondThin',

\t/**
\t * Variable: ALIGN_LEFT
\t * 
\t * Constant for left horizontal alignment. Default is left.
\t */
\tALIGN_LEFT: 'left',

\t/**
\t * Variable: ALIGN_CENTER
\t * 
\t * Constant for center horizontal alignment. Default is center.
\t */
\tALIGN_CENTER: 'center',

\t/**
\t * Variable: ALIGN_RIGHT
\t * 
\t * Constant for right horizontal alignment. Default is right.
\t */
\tALIGN_RIGHT: 'right',

\t/**
\t * Variable: ALIGN_TOP
\t * 
\t * Constant for top vertical alignment. Default is top.
\t */
\tALIGN_TOP: 'top',

\t/**
\t * Variable: ALIGN_MIDDLE
\t * 
\t * Constant for middle vertical alignment. Default is middle.
\t */
\tALIGN_MIDDLE: 'middle',

\t/**
\t * Variable: ALIGN_BOTTOM
\t * 
\t * Constant for bottom vertical alignment. Default is bottom.
\t */
\tALIGN_BOTTOM: 'bottom',

\t/**
\t * Variable: DIRECTION_NORTH
\t * 
\t * Constant for direction north. Default is north.
\t */
\tDIRECTION_NORTH: 'north',

\t/**
\t * Variable: DIRECTION_SOUTH
\t * 
\t * Constant for direction south. Default is south.
\t */
\tDIRECTION_SOUTH: 'south',

\t/**
\t * Variable: DIRECTION_EAST
\t * 
\t * Constant for direction east. Default is east.
\t */
\tDIRECTION_EAST: 'east',

\t/**
\t * Variable: DIRECTION_WEST
\t * 
\t * Constant for direction west. Default is west.
\t */
\tDIRECTION_WEST: 'west',

\t/**
\t * Variable: TEXT_DIRECTION_DEFAULT
\t * 
\t * Constant for text direction default. Default is an empty string. Use
\t * this value to use the default text direction of the operating system. 
\t */
\tTEXT_DIRECTION_DEFAULT: '',

\t/**
\t * Variable: TEXT_DIRECTION_AUTO
\t * 
\t * Constant for text direction automatic. Default is auto. Use this value
\t * to find the direction for a given text with <mxText.getAutoDirection>. 
\t */
\tTEXT_DIRECTION_AUTO: 'auto',

\t/**
\t * Variable: TEXT_DIRECTION_LTR
\t * 
\t * Constant for text direction left to right. Default is ltr. Use this
\t * value for left to right text direction.
\t */
\tTEXT_DIRECTION_LTR: 'ltr',

\t/**
\t * Variable: TEXT_DIRECTION_RTL
\t * 
\t * Constant for text direction right to left. Default is rtl. Use this
\t * value for right to left text direction.
\t */
\tTEXT_DIRECTION_RTL: 'rtl',

\t/**
\t * Variable: DIRECTION_MASK_NONE
\t * 
\t * Constant for no direction.
\t */
\tDIRECTION_MASK_NONE: 0,

\t/**
\t * Variable: DIRECTION_MASK_WEST
\t * 
\t * Bitwise mask for west direction.
\t */
\tDIRECTION_MASK_WEST: 1,
\t
\t/**
\t * Variable: DIRECTION_MASK_NORTH
\t * 
\t * Bitwise mask for north direction.
\t */
\tDIRECTION_MASK_NORTH: 2,

\t/**
\t * Variable: DIRECTION_MASK_SOUTH
\t * 
\t * Bitwise mask for south direction.
\t */
\tDIRECTION_MASK_SOUTH: 4,

\t/**
\t * Variable: DIRECTION_MASK_EAST
\t * 
\t * Bitwise mask for east direction.
\t */
\tDIRECTION_MASK_EAST: 8,
\t
\t/**
\t * Variable: DIRECTION_MASK_ALL
\t * 
\t * Bitwise mask for all directions.
\t */
\tDIRECTION_MASK_ALL: 15,

\t/**
\t * Variable: ELBOW_VERTICAL
\t * 
\t * Constant for elbow vertical. Default is horizontal.
\t */
\tELBOW_VERTICAL: 'vertical',

\t/**
\t * Variable: ELBOW_HORIZONTAL
\t * 
\t * Constant for elbow horizontal. Default is horizontal.
\t */
\tELBOW_HORIZONTAL: 'horizontal',

\t/**
\t * Variable: EDGESTYLE_ELBOW
\t * 
\t * Name of the elbow edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_ELBOW: 'elbowEdgeStyle',

\t/**
\t * Variable: EDGESTYLE_ENTITY_RELATION
\t * 
\t * Name of the entity relation edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_ENTITY_RELATION: 'entityRelationEdgeStyle',

\t/**
\t * Variable: EDGESTYLE_LOOP
\t * 
\t * Name of the loop edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_LOOP: 'loopEdgeStyle',

\t/**
\t * Variable: EDGESTYLE_SIDETOSIDE
\t * 
\t * Name of the side to side edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_SIDETOSIDE: 'sideToSideEdgeStyle',

\t/**
\t * Variable: EDGESTYLE_TOPTOBOTTOM
\t * 
\t * Name of the top to bottom edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_TOPTOBOTTOM: 'topToBottomEdgeStyle',

\t/**
\t * Variable: EDGESTYLE_ORTHOGONAL
\t * 
\t * Name of the generic orthogonal edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_ORTHOGONAL: 'orthogonalEdgeStyle',

\t/**
\t * Variable: EDGESTYLE_SEGMENT
\t * 
\t * Name of the generic segment edge style. Can be used as a string value
\t * for the STYLE_EDGE style.
\t */
\tEDGESTYLE_SEGMENT: 'segmentEdgeStyle',
 
\t/**
\t * Variable: PERIMETER_ELLIPSE
\t * 
\t * Name of the ellipse perimeter. Can be used as a string value
\t * for the STYLE_PERIMETER style.
\t */
\tPERIMETER_ELLIPSE: 'ellipsePerimeter',

\t/**
\t * Variable: PERIMETER_RECTANGLE
\t *
\t * Name of the rectangle perimeter. Can be used as a string value
\t * for the STYLE_PERIMETER style.
\t */
\tPERIMETER_RECTANGLE: 'rectanglePerimeter',

\t/**
\t * Variable: PERIMETER_RHOMBUS
\t * 
\t * Name of the rhombus perimeter. Can be used as a string value
\t * for the STYLE_PERIMETER style.
\t */
\tPERIMETER_RHOMBUS: 'rhombusPerimeter',

\t/**
\t * Variable: PERIMETER_HEXAGON
\t * 
\t * Name of the hexagon perimeter. Can be used as a string value 
\t * for the STYLE_PERIMETER style.
\t */
\tPERIMETER_HEXAGON: 'hexagonPerimeter',

\t/**
\t * Variable: PERIMETER_TRIANGLE
\t * 
\t * Name of the triangle perimeter. Can be used as a string value
\t * for the STYLE_PERIMETER style.
\t */
\tPERIMETER_TRIANGLE: 'trianglePerimeter'
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxEventObject
 * 
 * The mxEventObject is a wrapper for all properties of a single event.
 * Additionally, it also offers functions to consume the event and check if it
 * was consumed as follows:
 * 
 * (code)
 * evt.consume();
 * INV: evt.isConsumed() == true
 * (end)
 * 
 * Constructor: mxEventObject
 *
 * Constructs a new event object with the specified name. An optional
 * sequence of key, value pairs can be appended to define properties.
 * 
 * Example:
 *
 * (code)
 * new mxEventObject(\"eventName\", key1, val1, .., keyN, valN)
 * (end)
 */
function mxEventObject(name)
{
\tthis.name = name;
\tthis.properties = [];
\t
\tfor (var i = 1; i < arguments.length; i += 2)
\t{
\t\tif (arguments[i + 1] != null)
\t\t{
\t\t\tthis.properties[arguments[i]] = arguments[i + 1];
\t\t}
\t}
};

/**
 * Variable: name
 *
 * Holds the name.
 */
mxEventObject.prototype.name = null;

/**
 * Variable: properties
 *
 * Holds the properties as an associative array.
 */
mxEventObject.prototype.properties = null;

/**
 * Variable: consumed
 *
 * Holds the consumed state. Default is false.
 */
mxEventObject.prototype.consumed = false;

/**
 * Function: getName
 * 
 * Returns <name>.
 */
mxEventObject.prototype.getName = function()
{
\treturn this.name;
};

/**
 * Function: getProperties
 * 
 * Returns <properties>.
 */
mxEventObject.prototype.getProperties = function()
{
\treturn this.properties;
};

/**
 * Function: getProperty
 * 
 * Returns the property for the given key.
 */
mxEventObject.prototype.getProperty = function(key)
{
\treturn this.properties[key];
};

/**
 * Function: isConsumed
 *
 * Returns true if the event has been consumed.
 */
mxEventObject.prototype.isConsumed = function()
{
\treturn this.consumed;
};

/**
 * Function: consume
 *
 * Consumes the event.
 */
mxEventObject.prototype.consume = function()
{
\tthis.consumed = true;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxMouseEvent
 * 
 * Base class for all mouse events in mxGraph. A listener for this event should
 * implement the following methods:
 * 
 * (code)
 * graph.addMouseListener(
 * {
 *   mouseDown: function(sender, evt)
 *   {
 *     mxLog.debug('mouseDown');
 *   },
 *   mouseMove: function(sender, evt)
 *   {
 *     mxLog.debug('mouseMove');
 *   },
 *   mouseUp: function(sender, evt)
 *   {
 *     mxLog.debug('mouseUp');
 *   }
 * });
 * (end)
 * 
 * Constructor: mxMouseEvent
 *
 * Constructs a new event object for the given arguments.
 * 
 * Parameters:
 * 
 * evt - Native mouse event.
 * state - Optional <mxCellState> under the mouse.
 * 
 */
function mxMouseEvent(evt, state)
{
\tthis.evt = evt;
\tthis.state = state;
\tthis.sourceState = state;
};

/**
 * Variable: consumed
 *
 * Holds the consumed state of this event.
 */
mxMouseEvent.prototype.consumed = false;

/**
 * Variable: evt
 *
 * Holds the inner event object.
 */
mxMouseEvent.prototype.evt = null;

/**
 * Variable: graphX
 *
 * Holds the x-coordinate of the event in the graph. This value is set in
 * <mxGraph.fireMouseEvent>.
 */
mxMouseEvent.prototype.graphX = null;

/**
 * Variable: graphY
 *
 * Holds the y-coordinate of the event in the graph. This value is set in
 * <mxGraph.fireMouseEvent>.
 */
mxMouseEvent.prototype.graphY = null;

/**
 * Variable: state
 *
 * Holds the optional <mxCellState> associated with this event.
 */
mxMouseEvent.prototype.state = null;

/**
 * Variable: sourceState
 * 
 * Holds the <mxCellState> that was passed to the constructor. This can be
 * different from <state> depending on the result of <mxGraph.getEventState>.
 */
mxMouseEvent.prototype.sourceState = null;

/**
 * Function: getEvent
 * 
 * Returns <evt>.
 */
mxMouseEvent.prototype.getEvent = function()
{
\treturn this.evt;
};

/**
 * Function: getSource
 * 
 * Returns the target DOM element using <mxEvent.getSource> for <evt>.
 */
mxMouseEvent.prototype.getSource = function()
{
\treturn mxEvent.getSource(this.evt);
};

/**
 * Function: isSource
 * 
 * Returns true if the given <mxShape> is the source of <evt>.
 */
mxMouseEvent.prototype.isSource = function(shape)
{
\tif (shape != null)
\t{
\t\treturn mxUtils.isAncestorNode(shape.node, this.getSource());
\t}
\t
\treturn false;
};

/**
 * Function: getX
 * 
 * Returns <evt.clientX>.
 */
mxMouseEvent.prototype.getX = function()
{
\treturn mxEvent.getClientX(this.getEvent());
};

/**
 * Function: getY
 * 
 * Returns <evt.clientY>.
 */
mxMouseEvent.prototype.getY = function()
{
\treturn mxEvent.getClientY(this.getEvent());
};

/**
 * Function: getGraphX
 * 
 * Returns <graphX>.
 */
mxMouseEvent.prototype.getGraphX = function()
{
\treturn this.graphX;
};

/**
 * Function: getGraphY
 * 
 * Returns <graphY>.
 */
mxMouseEvent.prototype.getGraphY = function()
{
\treturn this.graphY;
};

/**
 * Function: getState
 * 
 * Returns <state>.
 */
mxMouseEvent.prototype.getState = function()
{
\treturn this.state;
};

/**
 * Function: getCell
 * 
 * Returns the <mxCell> in <state> is not null.
 */
mxMouseEvent.prototype.getCell = function()
{
\tvar state = this.getState();
\t
\tif (state != null)
\t{
\t\treturn state.cell;
\t}
\t
\treturn null;
};

/**
 * Function: isPopupTrigger
 *
 * Returns true if the event is a popup trigger.
 */
mxMouseEvent.prototype.isPopupTrigger = function()
{
\treturn mxEvent.isPopupTrigger(this.getEvent());
};

/**
 * Function: isConsumed
 *
 * Returns <consumed>.
 */
mxMouseEvent.prototype.isConsumed = function()
{
\treturn this.consumed;
};

/**
 * Function: consume
 *
 * Sets <consumed> to true and invokes preventDefault on the native event
 * if such a method is defined. This is used mainly to avoid the cursor from
 * being changed to a text cursor in Webkit. You can use the preventDefault
 * flag to disable this functionality.
 * 
 * Parameters:
 * 
 * preventDefault - Specifies if the native event should be canceled. Default
 * is true.
 */
mxMouseEvent.prototype.consume = function(preventDefault)
{
\tpreventDefault = (preventDefault != null) ? preventDefault :
\t\t(this.evt.touches != null || mxEvent.isMouseEvent(this.evt));
\t
\tif (preventDefault && this.evt.preventDefault)
\t{
\t\tthis.evt.preventDefault();
\t}

\t// Workaround for images being dragged in IE
\t// Does not change returnValue in Opera
\tif (mxClient.IS_IE)
\t{
\t\tthis.evt.returnValue = true;
\t}

\t// Sets local consumed state
\tthis.consumed = true;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxEventSource
 *
 * Base class for objects that dispatch named events. To create a subclass that
 * inherits from mxEventSource, the following code is used.
 *
 * (code)
 * function MyClass() { };
 *
 * MyClass.prototype = new mxEventSource();
 * MyClass.prototype.constructor = MyClass;
 * (end)
 *
 * Known Subclasses:
 *
 * <mxGraphModel>, <mxGraph>, <mxGraphView>, <mxEditor>, <mxCellOverlay>,
 * <mxToolbar>, <mxWindow>
 * 
 * Constructor: mxEventSource
 *
 * Constructs a new event source.
 */
function mxEventSource(eventSource)
{
\tthis.setEventSource(eventSource);
};

/**
 * Variable: eventListeners
 *
 * Holds the event names and associated listeners in an array. The array
 * contains the event name followed by the respective listener for each
 * registered listener.
 */
mxEventSource.prototype.eventListeners = null;

/**
 * Variable: eventsEnabled
 *
 * Specifies if events can be fired. Default is true.
 */
mxEventSource.prototype.eventsEnabled = true;

/**
 * Variable: eventSource
 *
 * Optional source for events. Default is null.
 */
mxEventSource.prototype.eventSource = null;

/**
 * Function: isEventsEnabled
 * 
 * Returns <eventsEnabled>.
 */
mxEventSource.prototype.isEventsEnabled = function()
{
\treturn this.eventsEnabled;
};

/**
 * Function: setEventsEnabled
 * 
 * Sets <eventsEnabled>.
 */
mxEventSource.prototype.setEventsEnabled = function(value)
{
\tthis.eventsEnabled = value;
};

/**
 * Function: getEventSource
 * 
 * Returns <eventSource>.
 */
mxEventSource.prototype.getEventSource = function()
{
\treturn this.eventSource;
};

/**
 * Function: setEventSource
 * 
 * Sets <eventSource>.
 */
mxEventSource.prototype.setEventSource = function(value)
{
\tthis.eventSource = value;
};

/**
 * Function: addListener
 *
 * Binds the specified function to the given event name. If no event name
 * is given, then the listener is registered for all events.
 * 
 * The parameters of the listener are the sender and an <mxEventObject>.
 */
mxEventSource.prototype.addListener = function(name, funct)
{
\tif (this.eventListeners == null)
\t{
\t\tthis.eventListeners = [];
\t}
\t
\tthis.eventListeners.push(name);
\tthis.eventListeners.push(funct);
};

/**
 * Function: removeListener
 *
 * Removes all occurrences of the given listener from <eventListeners>.
 */
mxEventSource.prototype.removeListener = function(funct)
{
\tif (this.eventListeners != null)
\t{
\t\tvar i = 0;
\t\t
\t\twhile (i < this.eventListeners.length)
\t\t{
\t\t\tif (this.eventListeners[i+1] == funct)
\t\t\t{
\t\t\t\tthis.eventListeners.splice(i, 2);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\ti += 2;
\t\t\t}
\t\t}
\t}
};

/**
 * Function: fireEvent
 *
 * Dispatches the given event to the listeners which are registered for
 * the event. The sender argument is optional. The current execution scope
 * (\"this\") is used for the listener invocation (see <mxUtils.bind>).
 *
 * Example:
 *
 * (code)
 * fireEvent(new mxEventObject(\"eventName\", key1, val1, .., keyN, valN))
 * (end)
 * 
 * Parameters:
 *
 * evt - <mxEventObject> that represents the event.
 * sender - Optional sender to be passed to the listener. Default value is
 * the return value of <getEventSource>.
 */
mxEventSource.prototype.fireEvent = function(evt, sender)
{
\tif (this.eventListeners != null && this.isEventsEnabled())
\t{
\t\tif (evt == null)
\t\t{
\t\t\tevt = new mxEventObject();
\t\t}
\t\t
\t\tif (sender == null)
\t\t{
\t\t\tsender = this.getEventSource();
\t\t}

\t\tif (sender == null)
\t\t{
\t\t\tsender = this;
\t\t}

\t\tvar args = [sender, evt];
\t\t
\t\tfor (var i = 0; i < this.eventListeners.length; i += 2)
\t\t{
\t\t\tvar listen = this.eventListeners[i];
\t\t\t
\t\t\tif (listen == null || listen == evt.getName())
\t\t\t{
\t\t\t\tthis.eventListeners[i+1].apply(this, args);
\t\t\t}
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxEvent =
{

\t/**
\t * Class: mxEvent
\t * 
\t * Cross-browser DOM event support. For internal event handling,
\t * <mxEventSource> and the graph event dispatch loop in <mxGraph> are used.
\t * 
\t * Memory Leaks:
\t * 
\t * Use this class for adding and removing listeners to/from DOM nodes. The
\t * <removeAllListeners> function is provided to remove all listeners that
\t * have been added using <addListener>. The function should be invoked when
\t * the last reference is removed in the JavaScript code, typically when the
\t * referenced DOM node is removed from the DOM.
\t *
\t * Function: addListener
\t * 
\t * Binds the function to the specified event on the given element. Use
\t * <mxUtils.bind> in order to bind the \"this\" keyword inside the function
\t * to a given execution scope.
\t */
\taddListener: function()
\t{
\t\tvar updateListenerList = function(element, eventName, funct)
\t\t{
\t\t\tif (element.mxListenerList == null)
\t\t\t{
\t\t\t\telement.mxListenerList = [];
\t\t\t}
\t\t\t
\t\t\tvar entry = {name: eventName, f: funct};
\t\t\telement.mxListenerList.push(entry);
\t\t};
\t\t
\t\tif (window.addEventListener)
\t\t{
\t\t\treturn function(element, eventName, funct)
\t\t\t{
\t\t\t\telement.addEventListener(eventName, funct, false);
\t\t\t\tupdateListenerList(element, eventName, funct);
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\treturn function(element, eventName, funct)
\t\t\t{
\t\t\t\telement.attachEvent('on' + eventName, funct);
\t\t\t\tupdateListenerList(element, eventName, funct);\t\t\t\t
\t\t\t};
\t\t}
\t}(),

\t/**
\t * Function: removeListener
\t *
\t * Removes the specified listener from the given element.
\t */
\tremoveListener: function()
\t{
\t\tvar updateListener = function(element, eventName, funct)
\t\t{
\t\t\tif (element.mxListenerList != null)
\t\t\t{
\t\t\t\tvar listenerCount = element.mxListenerList.length;
\t\t\t\t
\t\t\t\tfor (var i = 0; i < listenerCount; i++)
\t\t\t\t{
\t\t\t\t\tvar entry = element.mxListenerList[i];
\t\t\t\t\t
\t\t\t\t\tif (entry.f == funct)
\t\t\t\t\t{
\t\t\t\t\t\telement.mxListenerList.splice(i, 1);
\t\t\t\t\t\tbreak;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (element.mxListenerList.length == 0)
\t\t\t\t{
\t\t\t\t\telement.mxListenerList = null;
\t\t\t\t}
\t\t\t}
\t\t};
\t\t
\t\tif (window.removeEventListener)
\t\t{
\t\t\treturn function(element, eventName, funct)
\t\t\t{
\t\t\t\telement.removeEventListener(eventName, funct, false);
\t\t\t\tupdateListener(element, eventName, funct);
\t\t\t};
\t\t}
\t\telse
\t\t{
\t\t\treturn function(element, eventName, funct)
\t\t\t{
\t\t\t\telement.detachEvent('on' + eventName, funct);
\t\t\t\tupdateListener(element, eventName, funct);
\t\t\t};
\t\t}
\t}(),

\t/**
\t * Function: removeAllListeners
\t * 
\t * Removes all listeners from the given element.
\t */
\tremoveAllListeners: function(element)
\t{
\t\tvar list = element.mxListenerList;

\t\tif (list != null)
\t\t{
\t\t\twhile (list.length > 0)
\t\t\t{
\t\t\t\tvar entry = list[0];
\t\t\t\tmxEvent.removeListener(element, entry.name, entry.f);
\t\t\t}
\t\t}
\t},
\t
\t/**
\t * Function: addGestureListeners
\t * 
\t * Adds the given listeners for touch, mouse and/or pointer events. If
\t * <mxClient.IS_POINTER> is true then pointer events will be registered,
\t * else the respective mouse events will be registered. If <mxClient.IS_POINTER>
\t * is false and <mxClient.IS_TOUCH> is true then the respective touch events
\t * will be registered as well as the mouse events.
\t */
\taddGestureListeners: function(node, startListener, moveListener, endListener)
\t{
\t\tif (startListener != null)
\t\t{
\t\t\tmxEvent.addListener(node, (mxClient.IS_POINTER) ? 'pointerdown' : 'mousedown', startListener);
\t\t}
\t\t
\t\tif (moveListener != null)
\t\t{
\t\t\tmxEvent.addListener(node, (mxClient.IS_POINTER) ? 'pointermove' : 'mousemove', moveListener);
\t\t}
\t\t
\t\tif (endListener != null)
\t\t{
\t\t\tmxEvent.addListener(node, (mxClient.IS_POINTER) ? 'pointerup' : 'mouseup', endListener);
\t\t}
\t\t
\t\tif (!mxClient.IS_POINTER && mxClient.IS_TOUCH)
\t\t{
\t\t\tif (startListener != null)
\t\t\t{
\t\t\t\tmxEvent.addListener(node, 'touchstart', startListener);
\t\t\t}
\t\t\t
\t\t\tif (moveListener != null)
\t\t\t{
\t\t\t\tmxEvent.addListener(node, 'touchmove', moveListener);
\t\t\t}
\t\t\t
\t\t\tif (endListener != null)
\t\t\t{
\t\t\t\tmxEvent.addListener(node, 'touchend', endListener);
\t\t\t}
\t\t}
\t},
\t
\t/**
\t * Function: removeGestureListeners
\t * 
\t * Removes the given listeners from mousedown, mousemove, mouseup and the
\t * respective touch events if <mxClient.IS_TOUCH> is true.
\t */
\tremoveGestureListeners: function(node, startListener, moveListener, endListener)
\t{
\t\tif (startListener != null)
\t\t{
\t\t\tmxEvent.removeListener(node, (mxClient.IS_POINTER) ? 'pointerdown' : 'mousedown', startListener);
\t\t}
\t\t
\t\tif (moveListener != null)
\t\t{
\t\t\tmxEvent.removeListener(node, (mxClient.IS_POINTER) ? 'pointermove' : 'mousemove', moveListener);
\t\t}
\t\t
\t\tif (endListener != null)
\t\t{
\t\t\tmxEvent.removeListener(node, (mxClient.IS_POINTER) ? 'pointerup' : 'mouseup', endListener);
\t\t}
\t\t
\t\tif (!mxClient.IS_POINTER && mxClient.IS_TOUCH)
\t\t{
\t\t\tif (startListener != null)
\t\t\t{
\t\t\t\tmxEvent.removeListener(node, 'touchstart', startListener);
\t\t\t}
\t\t\t
\t\t\tif (moveListener != null)
\t\t\t{
\t\t\t\tmxEvent.removeListener(node, 'touchmove', moveListener);
\t\t\t}
\t\t\t
\t\t\tif (endListener != null)
\t\t\t{
\t\t\t\tmxEvent.removeListener(node, 'touchend', endListener);
\t\t\t}
\t\t}
\t},
\t
\t/**
\t * Function: redirectMouseEvents
\t *
\t * Redirects the mouse events from the given DOM node to the graph dispatch
\t * loop using the event and given state as event arguments. State can
\t * either be an instance of <mxCellState> or a function that returns an
\t * <mxCellState>. The down, move, up and dblClick arguments are optional
\t * functions that take the trigger event as arguments and replace the
\t * default behaviour.
\t */
\tredirectMouseEvents: function(node, graph, state, down, move, up, dblClick)
\t{
\t\tvar getState = function(evt)
\t\t{
\t\t\treturn (typeof(state) == 'function') ? state(evt) : state;
\t\t};
\t\t
\t\tmxEvent.addGestureListeners(node, function (evt)
\t\t{
\t\t\tif (down != null)
\t\t\t{
\t\t\t\tdown(evt);
\t\t\t}
\t\t\telse if (!mxEvent.isConsumed(evt))
\t\t\t{
\t\t\t\tgraph.fireMouseEvent(mxEvent.MOUSE_DOWN, new mxMouseEvent(evt, getState(evt)));
\t\t\t}
\t\t},
\t\tfunction (evt)
\t\t{
\t\t\tif (move != null)
\t\t\t{
\t\t\t\tmove(evt);
\t\t\t}
\t\t\telse if (!mxEvent.isConsumed(evt))
\t\t\t{
\t\t\t\tgraph.fireMouseEvent(mxEvent.MOUSE_MOVE, new mxMouseEvent(evt, getState(evt)));
\t\t\t}
\t\t},
\t\tfunction (evt)
\t\t{
\t\t\tif (up != null)
\t\t\t{
\t\t\t\tup(evt);
\t\t\t}
\t\t\telse if (!mxEvent.isConsumed(evt))
\t\t\t{
\t\t\t\tgraph.fireMouseEvent(mxEvent.MOUSE_UP, new mxMouseEvent(evt, getState(evt)));
\t\t\t}
\t\t});

\t\tmxEvent.addListener(node, 'dblclick', function (evt)
\t\t{
\t\t\tif (dblClick != null)
\t\t\t{
\t\t\t\tdblClick(evt);
\t\t\t}
\t\t\telse if (!mxEvent.isConsumed(evt))
\t\t\t{
\t\t\t\tvar tmp = getState(evt);
\t\t\t\tgraph.dblClick(evt, (tmp != null) ? tmp.cell : null);
\t\t\t}
\t\t});
\t},

\t/**
\t * Function: release
\t * 
\t * Removes the known listeners from the given DOM node and its descendants.
\t * 
\t * Parameters:
\t * 
\t * element - DOM node to remove the listeners from.
\t */
\trelease: function(element)
\t{
\t\ttry
\t\t{
\t\t\tif (element != null)
\t\t\t{
\t\t\t\tmxEvent.removeAllListeners(element);
\t\t\t\t
\t\t\t\tvar children = element.childNodes;
\t\t\t\t
\t\t\t\tif (children != null)
\t\t\t\t{
\t\t\t        var childCount = children.length;
\t\t\t        
\t\t\t        for (var i = 0; i < childCount; i += 1)
\t\t\t        {
\t\t\t        \tmxEvent.release(children[i]);
\t\t\t        }
\t\t\t    }
\t\t\t}
\t\t}
\t\tcatch (e)
\t\t{
\t\t\t// ignores errors as this is typically called in cleanup code
\t\t}
\t},

\t/**
\t * Function: addMouseWheelListener
\t * 
\t * Installs the given function as a handler for mouse wheel events. The
\t * function has two arguments: the mouse event and a boolean that specifies
\t * if the wheel was moved up or down.
\t * 
\t * This has been tested with IE 6 and 7, Firefox (all versions), Opera and
\t * Safari. It does currently not work on Safari for Mac.
\t * 
\t * Example:
\t * 
\t * (code)
\t * mxEvent.addMouseWheelListener(function (evt, up, pinch)
\t * {
\t *   mxLog.show();
\t *   mxLog.debug('mouseWheel: up='+up);
\t * });
\t *(end)
\t * 
\t * Parameters:
\t * 
\t * funct - Handler function that takes the event argument, a boolean argument
\t * for the mousewheel direction and a boolean to specify if the underlying
\t * event was a pinch gesture on a touch device.
\t * target - Target for installing the listener in Google Chrome. See 
\t * https://www.chromestatus.com/features/6662647093133312.
\t */
\taddMouseWheelListener: function(funct, target)
\t{
\t\tif (funct != null)
\t\t{
\t\t\tvar wheelHandler = function(evt)
\t\t\t{
\t\t\t\t// IE does not give an event object but the
\t\t\t\t// global event object is the mousewheel event
\t\t\t\t// at this point in time.
\t\t\t\tif (evt == null)
\t\t\t\t{
\t\t\t\t\tevt = window.event;
\t\t\t\t}
\t\t\t
\t\t\t\t//To prevent window zoom on trackpad pinch
\t\t\t\tif (evt.ctrlKey) 
\t\t\t\t{
\t\t\t\t\tevt.preventDefault();
\t\t\t\t}

\t\t\t\tvar delta = -evt.deltaY;
\t\t\t\t
\t\t\t\t// Handles the event using the given function
\t\t\t\tif (Math.abs(evt.deltaX) > 0.5 || Math.abs(evt.deltaY) > 0.5)
\t\t\t\t{
\t\t\t\t\tfunct(evt, (evt.deltaY == 0) ?  -evt.deltaX > 0 : -evt.deltaY > 0);
\t\t\t\t}
\t\t\t};
\t
\t\t\ttarget = target != null ? target : window;
\t\t\t\t\t
\t\t\tif (mxClient.IS_SF && !mxClient.IS_TOUCH)
\t\t\t{
\t\t\t\tvar scale = 1;
\t\t\t\t
\t\t\t\tmxEvent.addListener(target, 'gesturestart', function(evt)
\t\t\t\t{
\t\t\t\t\tmxEvent.consume(evt);
\t\t\t\t\tscale = 1;
\t\t\t\t});
\t\t\t\t
\t\t\t\tmxEvent.addListener(target, 'gesturechange', function(evt)
\t\t\t\t{
\t\t\t\t\tmxEvent.consume(evt);
\t\t\t\t\tvar diff = scale - evt.scale;
\t\t\t\t\t
\t\t\t\t\tif (Math.abs(diff) > 0.2)
\t\t\t\t\t{
\t\t\t\t\t\tfunct(evt, diff < 0, true);
\t\t\t\t\t\tscale = evt.scale;
\t\t\t\t\t}
\t\t\t\t});

\t\t\t\tmxEvent.addListener(target, 'gestureend', function(evt)
\t\t\t\t{
\t\t\t\t\tmxEvent.consume(evt);
\t\t\t\t});
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tvar evtCache = [];
\t\t\t\tvar dx0 = 0;
\t\t\t\tvar dy0 = 0;
\t\t\t\t
\t\t\t\t// Adds basic listeners for graph event dispatching
\t\t\t\tmxEvent.addGestureListeners(target, mxUtils.bind(this, function(evt)
\t\t\t\t{
\t\t\t\t\tif (!mxEvent.isMouseEvent(evt) && evt.pointerId != null)
\t\t\t\t\t{
\t\t\t\t\t\tevtCache.push(evt);
\t\t\t\t\t}
\t\t\t\t}),
\t\t\t\tmxUtils.bind(this, function(evt)
\t\t\t\t{
\t\t\t\t\tif (!mxEvent.isMouseEvent(evt) && evtCache.length == 2)
\t\t\t\t\t{
\t\t\t\t\t\t// Find this event in the cache and update its record with this event
\t\t\t\t\t\tfor (var i = 0; i < evtCache.length; i++)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tif (evt.pointerId == evtCache[i].pointerId)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tevtCache[i] = evt;
\t\t\t\t\t\t\t\tbreak;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t}
\t\t\t\t\t\t
\t\t\t\t\t   \t// Calculate the distance between the two pointers
\t\t\t\t\t\tvar dx = Math.abs(evtCache[0].clientX - evtCache[1].clientX);
\t\t\t\t\t\tvar dy = Math.abs(evtCache[0].clientY - evtCache[1].clientY);
\t\t\t\t\t\tvar tx = Math.abs(dx - dx0);
\t\t\t\t\t\tvar ty = Math.abs(dy - dy0);
\t\t\t\t\t
\t\t\t\t\t\tif (tx > mxEvent.PINCH_THRESHOLD || ty > mxEvent.PINCH_THRESHOLD)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar cx = evtCache[0].clientX + (evtCache[1].clientX - evtCache[0].clientX) / 2;
\t\t\t\t\t\t\tvar cy = evtCache[0].clientY + (evtCache[1].clientY - evtCache[0].clientY) / 2;
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tfunct(evtCache[0], (tx > ty) ? dx > dx0 : dy > dy0, true, cx, cy);
\t\t\t\t\t\t
\t\t\t\t\t\t   \t// Cache the distance for the next move event 
\t\t\t\t\t\t\tdx0 = dx;
\t\t\t\t\t\t\tdy0 = dy;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}),
\t\t\t\tmxUtils.bind(this, function(evt)
\t\t\t\t{
\t\t\t\t\tevtCache = [];
\t\t\t\t\tdx0 = 0;
\t\t\t\t\tdy0 = 0;
\t\t\t\t}));
\t\t\t}
\t\t\t
\t\t\tmxEvent.addListener(target, 'wheel', wheelHandler);
\t\t}
\t},
\t
\t/**
\t * Function: disableContextMenu
\t *
\t * Disables the context menu for the given element.
\t */
\tdisableContextMenu: function(element)
\t{
\t\tmxEvent.addListener(element, 'contextmenu', function(evt)
\t\t{
\t\t\tif (evt.preventDefault)
\t\t\t{
\t\t\t\tevt.preventDefault();
\t\t\t}
\t\t\t
\t\t\treturn false;
\t\t});
\t},
\t
\t/**
\t * Function: getSource
\t * 
\t * Returns the event's target or srcElement depending on the browser.
\t */
\tgetSource: function(evt)
\t{
\t\treturn (evt.srcElement != null) ? evt.srcElement : evt.target;
\t},

\t/**
\t * Function: isConsumed
\t * 
\t * Returns true if the event has been consumed using <consume>.
\t */
\tisConsumed: function(evt)
\t{
\t\treturn evt.isConsumed != null && evt.isConsumed;
\t},

\t/**
\t * Function: isTouchEvent
\t * 
\t * Returns true if the event was generated using a touch device (not a pen or mouse).
\t */
\tisTouchEvent: function(evt)
\t{
\t\treturn (evt.pointerType != null) ? (evt.pointerType == 'touch' || evt.pointerType ===
\t\t\tevt.MSPOINTER_TYPE_TOUCH) : ((evt.mozInputSource != null) ?
\t\t\t\t\tevt.mozInputSource == 5 : evt.type.indexOf('touch') == 0);
\t},

\t/**
\t * Function: isPenEvent
\t * 
\t * Returns true if the event was generated using a pen (not a touch device or mouse).
\t */
\tisPenEvent: function(evt)
\t{
\t\treturn (evt.pointerType != null) ? (evt.pointerType == 'pen' || evt.pointerType ===
\t\t\tevt.MSPOINTER_TYPE_PEN) : ((evt.mozInputSource != null) ?
\t\t\t\t\tevt.mozInputSource == 2 : evt.type.indexOf('pen') == 0);
\t},

\t/**
\t * Function: isMultiTouchEvent
\t * 
\t * Returns true if the event was generated using a touch device (not a pen or mouse).
\t */
\tisMultiTouchEvent: function(evt)
\t{
\t\treturn (evt.type != null && evt.type.indexOf('touch') == 0 && evt.touches != null && evt.touches.length > 1);
\t},

\t/**
\t * Function: isMouseEvent
\t * 
\t * Returns true if the event was generated using a mouse (not a pen or touch device).
\t */
\tisMouseEvent: function(evt)
\t{
\t\treturn (evt.pointerType != null) ? (evt.pointerType == 'mouse' || evt.pointerType ===
\t\t\tevt.MSPOINTER_TYPE_MOUSE) : ((evt.mozInputSource != null) ?
\t\t\t\tevt.mozInputSource == 1 : evt.type.indexOf('mouse') == 0);
\t},
\t
\t/**
\t * Function: isLeftMouseButton
\t * 
\t * Returns true if the left mouse button is pressed for the given event.
\t * To check if a button is pressed during a mouseMove you should use the
\t * <mxGraph.isMouseDown> property. Note that this returns true in Firefox
\t * for control+left-click on the Mac.
\t */
\tisLeftMouseButton: function(evt)
\t{
\t\t// Special case for mousemove and mousedown we check the buttons
\t\t// if it exists because which is 0 even if no button is pressed
\t\tif ('buttons' in evt && (evt.type == 'mousedown' || evt.type == 'mousemove'))
\t\t{
\t\t\treturn evt.buttons == 1;
\t\t}
\t\telse if ('which' in evt)
\t\t{
\t        return evt.which === 1;
\t    }
\t\telse
\t\t{
\t        return evt.button === 1;
\t    }
\t},
\t
\t/**
\t * Function: isMiddleMouseButton
\t * 
\t * Returns true if the middle mouse button is pressed for the given event.
\t * To check if a button is pressed during a mouseMove you should use the
\t * <mxGraph.isMouseDown> property.
\t */
\tisMiddleMouseButton: function(evt)
\t{
\t\tif ('which' in evt)
\t\t{
\t        return evt.which === 2;
\t    }
\t\telse
\t\t{
\t        return evt.button === 4;
\t    }
\t},
\t
\t/**
\t * Function: isRightMouseButton
\t * 
\t * Returns true if the right mouse button was pressed. Note that this
\t * button might not be available on some systems. For handling a popup
\t * trigger <isPopupTrigger> should be used.
\t */
\tisRightMouseButton: function(evt)
\t{
\t\tif ('which' in evt)
\t\t{
\t        return evt.which === 3;
\t    }
\t\telse
\t\t{
\t        return evt.button === 2;
\t    }
\t},

\t/**
\t * Function: isPopupTrigger
\t * 
\t * Returns true if the event is a popup trigger. This implementation
\t * returns true if the right button or the left button and control was
\t * pressed on a Mac.
\t */
\tisPopupTrigger: function(evt)
\t{
\t\treturn mxEvent.isRightMouseButton(evt) || (mxClient.IS_MAC && mxEvent.isControlDown(evt) &&
\t\t\t!mxEvent.isShiftDown(evt) && !mxEvent.isMetaDown(evt) && !mxEvent.isAltDown(evt));
\t},

\t/**
\t * Function: isShiftDown
\t * 
\t * Returns true if the shift key is pressed for the given event.
\t */
\tisShiftDown: function(evt)
\t{
\t\treturn (evt != null) ? evt.shiftKey : false;
\t},

\t/**
\t * Function: isAltDown
\t * 
\t * Returns true if the alt key is pressed for the given event.
\t */
\tisAltDown: function(evt)
\t{
\t\treturn (evt != null) ? evt.altKey : false;
\t},

\t/**
\t * Function: isControlDown
\t * 
\t * Returns true if the control key is pressed for the given event.
\t */
\tisControlDown: function(evt)
\t{
\t\treturn (evt != null) ? evt.ctrlKey : false;
\t},

\t/**
\t * Function: isMetaDown
\t * 
\t * Returns true if the meta key is pressed for the given event.
\t */
\tisMetaDown: function(evt)
\t{
\t\treturn (evt != null) ? evt.metaKey : false;
\t},

\t/**
\t * Function: getMainEvent
\t * 
\t * Returns the touch or mouse event that contains the mouse coordinates.
\t */
\tgetMainEvent: function(e)
\t{
\t\tif ((e.type == 'touchstart' || e.type == 'touchmove') && e.touches != null && e.touches[0] != null)
\t\t{
\t\t\te = e.touches[0];
\t\t}
\t\telse if (e.type == 'touchend' && e.changedTouches != null && e.changedTouches[0] != null)
\t\t{
\t\t\te = e.changedTouches[0];
\t\t}
\t\t
\t\treturn e;
\t},
\t
\t/**
\t * Function: getClientX
\t * 
\t * Returns true if the meta key is pressed for the given event.
\t */
\tgetClientX: function(e)
\t{
\t\treturn mxEvent.getMainEvent(e).clientX;
\t},

\t/**
\t * Function: getClientY
\t * 
\t * Returns true if the meta key is pressed for the given event.
\t */
\tgetClientY: function(e)
\t{
\t\treturn mxEvent.getMainEvent(e).clientY;
\t},

\t/**
\t * Function: consume
\t * 
\t * Consumes the given event.
\t * 
\t * Parameters:
\t * 
\t * evt - Native event to be consumed.
\t * preventDefault - Optional boolean to prevent the default for the event.
\t * Default is true.
\t * stopPropagation - Option boolean to stop event propagation. Default is
\t * true.
\t */
\tconsume: function(evt, preventDefault, stopPropagation)
\t{
\t\tpreventDefault = (preventDefault != null) ? preventDefault : true;
\t\tstopPropagation = (stopPropagation != null) ? stopPropagation : true;
\t\t
\t\tif (preventDefault)
\t\t{
\t\t\tif (evt.preventDefault)
\t\t\t{
\t\t\t\tif (stopPropagation)
\t\t\t\t{
\t\t\t\t\tevt.stopPropagation();
\t\t\t\t}
\t\t\t\t
\t\t\t\tevt.preventDefault();
\t\t\t}
\t\t\telse if (stopPropagation)
\t\t\t{
\t\t\t\tevt.cancelBubble = true;
\t\t\t}
\t\t}

\t\t// Opera
\t\tevt.isConsumed = true;

\t\t// Other browsers
\t\tif (!evt.preventDefault)
\t\t{
\t\t\tevt.returnValue = false;
\t\t}
\t},
\t
\t//
\t// Special handles in mouse events
\t//
\t
\t/**
\t * Variable: LABEL_HANDLE
\t * 
\t * Index for the label handle in an mxMouseEvent. This should be a negative
\t * value that does not interfere with any possible handle indices. Default
\t * is -1.
\t */
\tLABEL_HANDLE: -1,
\t
\t/**
\t * Variable: ROTATION_HANDLE
\t * 
\t * Index for the rotation handle in an mxMouseEvent. This should be a
\t * negative value that does not interfere with any possible handle indices.
\t * Default is -2.
\t */
\tROTATION_HANDLE: -2,
\t
\t/**
\t * Variable: CUSTOM_HANDLE
\t * 
\t * Start index for the custom handles in an mxMouseEvent. This should be a
\t * negative value and is the start index which is decremented for each
\t * custom handle. Default is -100.
\t */
\tCUSTOM_HANDLE: -100,
\t
\t/**
\t * Variable: VIRTUAL_HANDLE
\t * 
\t * Start index for the virtual handles in an mxMouseEvent. This should be a
\t * negative value and is the start index which is decremented for each
\t * virtual handle. Default is -100000. This assumes that there are no more
\t * than VIRTUAL_HANDLE - CUSTOM_HANDLE custom handles.
\t * 
\t */
\tVIRTUAL_HANDLE: -100000,
\t
\t//
\t// Event names
\t//
\t
\t/**
\t * Variable: MOUSE_DOWN
\t *
\t * Specifies the event name for mouseDown.
\t */
\tMOUSE_DOWN: 'mouseDown',
\t
\t/**
\t * Variable: MOUSE_MOVE
\t *
\t * Specifies the event name for mouseMove. 
\t */
\tMOUSE_MOVE: 'mouseMove',
\t
\t/**
\t * Variable: MOUSE_UP
\t *
\t * Specifies the event name for mouseUp. 
\t */
\tMOUSE_UP: 'mouseUp',

\t/**
\t * Variable: ACTIVATE
\t *
\t * Specifies the event name for activate.
\t */
\tACTIVATE: 'activate',

\t/**
\t * Variable: RESIZE_START
\t *
\t * Specifies the event name for resizeStart.
\t */
\tRESIZE_START: 'resizeStart',

\t/**
\t * Variable: RESIZE
\t *
\t * Specifies the event name for resize.
\t */
\tRESIZE: 'resize',

\t/**
\t * Variable: RESIZE_END
\t *
\t * Specifies the event name for resizeEnd.
\t */
\tRESIZE_END: 'resizeEnd',

\t/**
\t * Variable: MOVE_START
\t *
\t * Specifies the event name for moveStart.
\t */
\tMOVE_START: 'moveStart',

\t/**
\t * Variable: MOVE
\t *
\t * Specifies the event name for move.
\t */
\tMOVE: 'move',

\t/**
\t * Variable: MOVE_END
\t *
\t * Specifies the event name for moveEnd.
\t */
\tMOVE_END: 'moveEnd',

\t/**
\t * Variable: PAN_START
\t *
\t * Specifies the event name for panStart.
\t */
\tPAN_START: 'panStart',

\t/**
\t * Variable: PAN
\t *
\t * Specifies the event name for pan.
\t */
\tPAN: 'pan',

\t/**
\t * Variable: PAN_END
\t *
\t * Specifies the event name for panEnd.
\t */
\tPAN_END: 'panEnd',

\t/**
\t * Variable: MINIMIZE
\t *
\t * Specifies the event name for minimize.
\t */
\tMINIMIZE: 'minimize',

\t/**
\t * Variable: NORMALIZE
\t *
\t * Specifies the event name for normalize.
\t */
\tNORMALIZE: 'normalize',

\t/**
\t * Variable: MAXIMIZE
\t *
\t * Specifies the event name for maximize.
\t */
\tMAXIMIZE: 'maximize',

\t/**
\t * Variable: HIDE
\t *
\t * Specifies the event name for hide.
\t */
\tHIDE: 'hide',

\t/**
\t * Variable: SHOW
\t *
\t * Specifies the event name for show.
\t */
\tSHOW: 'show',

\t/**
\t * Variable: CLOSE
\t *
\t * Specifies the event name for close.
\t */
\tCLOSE: 'close',

\t/**
\t * Variable: DESTROY
\t *
\t * Specifies the event name for destroy.
\t */
\tDESTROY: 'destroy',

\t/**
\t * Variable: REFRESH
\t *
\t * Specifies the event name for refresh.
\t */
\tREFRESH: 'refresh',

\t/**
\t * Variable: SIZE
\t *
\t * Specifies the event name for size.
\t */
\tSIZE: 'size',
\t
\t/**
\t * Variable: SELECT
\t *
\t * Specifies the event name for select.
\t */
\tSELECT: 'select',

\t/**
\t * Variable: FIRED
\t *
\t * Specifies the event name for fired.
\t */
\tFIRED: 'fired',

\t/**
\t * Variable: FIRE_MOUSE_EVENT
\t *
\t * Specifies the event name for fireMouseEvent.
\t */
\tFIRE_MOUSE_EVENT: 'fireMouseEvent',

\t/**
\t * Variable: GESTURE
\t *
\t * Specifies the event name for gesture.
\t */
\tGESTURE: 'gesture',

\t/**
\t * Variable: TAP_AND_HOLD
\t *
\t * Specifies the event name for tapAndHold.
\t */
\tTAP_AND_HOLD: 'tapAndHold',

\t/**
\t * Variable: GET
\t *
\t * Specifies the event name for get.
\t */
\tGET: 'get',

\t/**
\t * Variable: RECEIVE
\t *
\t * Specifies the event name for receive.
\t */
\tRECEIVE: 'receive',

\t/**
\t * Variable: CONNECT
\t *
\t * Specifies the event name for connect.
\t */
\tCONNECT: 'connect',

\t/**
\t * Variable: DISCONNECT
\t *
\t * Specifies the event name for disconnect.
\t */
\tDISCONNECT: 'disconnect',

\t/**
\t * Variable: SUSPEND
\t *
\t * Specifies the event name for suspend.
\t */
\tSUSPEND: 'suspend',

\t/**
\t * Variable: RESUME
\t *
\t * Specifies the event name for suspend.
\t */
\tRESUME: 'resume',

\t/**
\t * Variable: MARK
\t *
\t * Specifies the event name for mark.
\t */
\tMARK: 'mark',

\t/**
\t * Variable: ROOT
\t *
\t * Specifies the event name for root.
\t */
\tROOT: 'root',

\t/**
\t * Variable: POST
\t *
\t * Specifies the event name for post.
\t */
\tPOST: 'post',

\t/**
\t * Variable: OPEN
\t *
\t * Specifies the event name for open.
\t */
\tOPEN: 'open',

\t/**
\t * Variable: SAVE
\t *
\t * Specifies the event name for open.
\t */
\tSAVE: 'save',

\t/**
\t * Variable: BEFORE_ADD_VERTEX
\t *
\t * Specifies the event name for beforeAddVertex.
\t */
\tBEFORE_ADD_VERTEX: 'beforeAddVertex',

\t/**
\t * Variable: ADD_VERTEX
\t *
\t * Specifies the event name for addVertex.
\t */
\tADD_VERTEX: 'addVertex',

\t/**
\t * Variable: AFTER_ADD_VERTEX
\t *
\t * Specifies the event name for afterAddVertex.
\t */
\tAFTER_ADD_VERTEX: 'afterAddVertex',

\t/**
\t * Variable: DONE
\t *
\t * Specifies the event name for done.
\t */
\tDONE: 'done',

\t/**
\t * Variable: EXECUTE
\t *
\t * Specifies the event name for execute.
\t */
\tEXECUTE: 'execute',

\t/**
\t * Variable: EXECUTED
\t *
\t * Specifies the event name for executed.
\t */
\tEXECUTED: 'executed',

\t/**
\t * Variable: BEGIN_UPDATE
\t *
\t * Specifies the event name for beginUpdate.
\t */
\tBEGIN_UPDATE: 'beginUpdate',

\t/**
\t * Variable: START_EDIT
\t *
\t * Specifies the event name for startEdit.
\t */
\tSTART_EDIT: 'startEdit',

\t/**
\t * Variable: END_UPDATE
\t *
\t * Specifies the event name for endUpdate.
\t */
\tEND_UPDATE: 'endUpdate',

\t/**
\t * Variable: END_EDIT
\t *
\t * Specifies the event name for endEdit.
\t */
\tEND_EDIT: 'endEdit',

\t/**
\t * Variable: BEFORE_UNDO
\t *
\t * Specifies the event name for beforeUndo.
\t */
\tBEFORE_UNDO: 'beforeUndo',

\t/**
\t * Variable: UNDO
\t *
\t * Specifies the event name for undo.
\t */
\tUNDO: 'undo',

\t/**
\t * Variable: REDO
\t *
\t * Specifies the event name for redo.
\t */
\tREDO: 'redo',

\t/**
\t * Variable: CHANGE
\t *
\t * Specifies the event name for change.
\t */
\tCHANGE: 'change',

\t/**
\t * Variable: NOTIFY
\t *
\t * Specifies the event name for notify.
\t */
\tNOTIFY: 'notify',

\t/**
\t * Variable: LAYOUT_CELLS
\t *
\t * Specifies the event name for layoutCells.
\t */
\tLAYOUT_CELLS: 'layoutCells',

\t/**
\t * Variable: CLICK
\t *
\t * Specifies the event name for click.
\t */
\tCLICK: 'click',

\t/**
\t * Variable: SCALE
\t *
\t * Specifies the event name for scale.
\t */
\tSCALE: 'scale',

\t/**
\t * Variable: TRANSLATE
\t *
\t * Specifies the event name for translate.
\t */
\tTRANSLATE: 'translate',

\t/**
\t * Variable: SCALE_AND_TRANSLATE
\t *
\t * Specifies the event name for scaleAndTranslate.
\t */
\tSCALE_AND_TRANSLATE: 'scaleAndTranslate',

\t/**
\t * Variable: UP
\t *
\t * Specifies the event name for up.
\t */
\tUP: 'up',

\t/**
\t * Variable: DOWN
\t *
\t * Specifies the event name for down.
\t */
\tDOWN: 'down',

\t/**
\t * Variable: ADD
\t *
\t * Specifies the event name for add.
\t */
\tADD: 'add',

\t/**
\t * Variable: REMOVE
\t *
\t * Specifies the event name for remove.
\t */
\tREMOVE: 'remove',
\t
\t/**
\t * Variable: CLEAR
\t *
\t * Specifies the event name for clear.
\t */
\tCLEAR: 'clear',

\t/**
\t * Variable: ADD_CELLS
\t *
\t * Specifies the event name for addCells.
\t */
\tADD_CELLS: 'addCells',

\t/**
\t * Variable: CELLS_ADDED
\t *
\t * Specifies the event name for cellsAdded.
\t */
\tCELLS_ADDED: 'cellsAdded',

\t/**
\t * Variable: MOVE_CELLS
\t *
\t * Specifies the event name for moveCells.
\t */
\tMOVE_CELLS: 'moveCells',

\t/**
\t * Variable: CELLS_MOVED
\t *
\t * Specifies the event name for cellsMoved.
\t */
\tCELLS_MOVED: 'cellsMoved',

\t/**
\t * Variable: RESIZE_CELLS
\t *
\t * Specifies the event name for resizeCells.
\t */
\tRESIZE_CELLS: 'resizeCells',

\t/**
\t * Variable: CELLS_RESIZED
\t *
\t * Specifies the event name for cellsResized.
\t */
\tCELLS_RESIZED: 'cellsResized',

\t/**
\t * Variable: TOGGLE_CELLS
\t *
\t * Specifies the event name for toggleCells.
\t */
\tTOGGLE_CELLS: 'toggleCells',

\t/**
\t * Variable: CELLS_TOGGLED
\t *
\t * Specifies the event name for cellsToggled.
\t */
\tCELLS_TOGGLED: 'cellsToggled',

\t/**
\t * Variable: ORDER_CELLS
\t *
\t * Specifies the event name for orderCells.
\t */
\tORDER_CELLS: 'orderCells',

\t/**
\t * Variable: CELLS_ORDERED
\t *
\t * Specifies the event name for cellsOrdered.
\t */
\tCELLS_ORDERED: 'cellsOrdered',

\t/**
\t * Variable: REMOVE_CELLS
\t *
\t * Specifies the event name for removeCells.
\t */
\tREMOVE_CELLS: 'removeCells',

\t/**
\t * Variable: CELLS_REMOVED
\t *
\t * Specifies the event name for cellsRemoved.
\t */
\tCELLS_REMOVED: 'cellsRemoved',

\t/**
\t * Variable: GROUP_CELLS
\t *
\t * Specifies the event name for groupCells.
\t */
\tGROUP_CELLS: 'groupCells',

\t/**
\t * Variable: UNGROUP_CELLS
\t *
\t * Specifies the event name for ungroupCells.
\t */
\tUNGROUP_CELLS: 'ungroupCells',

\t/**
\t * Variable: REMOVE_CELLS_FROM_PARENT
\t *
\t * Specifies the event name for removeCellsFromParent.
\t */
\tREMOVE_CELLS_FROM_PARENT: 'removeCellsFromParent',

\t/**
\t * Variable: FOLD_CELLS
\t *
\t * Specifies the event name for foldCells.
\t */
\tFOLD_CELLS: 'foldCells',

\t/**
\t * Variable: CELLS_FOLDED
\t *
\t * Specifies the event name for cellsFolded.
\t */
\tCELLS_FOLDED: 'cellsFolded',

\t/**
\t * Variable: ALIGN_CELLS
\t *
\t * Specifies the event name for alignCells.
\t */
\tALIGN_CELLS: 'alignCells',

\t/**
\t * Variable: LABEL_CHANGED
\t *
\t * Specifies the event name for labelChanged.
\t */
\tLABEL_CHANGED: 'labelChanged',

\t/**
\t * Variable: CONNECT_CELL
\t *
\t * Specifies the event name for connectCell.
\t */
\tCONNECT_CELL: 'connectCell',

\t/**
\t * Variable: CELL_CONNECTED
\t *
\t * Specifies the event name for cellConnected.
\t */
\tCELL_CONNECTED: 'cellConnected',

\t/**
\t * Variable: SPLIT_EDGE
\t *
\t * Specifies the event name for splitEdge.
\t */
\tSPLIT_EDGE: 'splitEdge',

\t/**
\t * Variable: FLIP_EDGE
\t *
\t * Specifies the event name for flipEdge.
\t */
\tFLIP_EDGE: 'flipEdge',

\t/**
\t * Variable: START_EDITING
\t *
\t * Specifies the event name for startEditing.
\t */
\tSTART_EDITING: 'startEditing',

\t/**
\t * Variable: EDITING_STARTED
\t *
\t * Specifies the event name for editingStarted.
\t */
\tEDITING_STARTED: 'editingStarted',

\t/**
\t * Variable: EDITING_STOPPED
\t *
\t * Specifies the event name for editingStopped.
\t */
\tEDITING_STOPPED: 'editingStopped',

\t/**
\t * Variable: ADD_OVERLAY
\t *
\t * Specifies the event name for addOverlay.
\t */
\tADD_OVERLAY: 'addOverlay',

\t/**
\t * Variable: REMOVE_OVERLAY
\t *
\t * Specifies the event name for removeOverlay.
\t */
\tREMOVE_OVERLAY: 'removeOverlay',

\t/**
\t * Variable: UPDATE_CELL_SIZE
\t *
\t * Specifies the event name for updateCellSize.
\t */
\tUPDATE_CELL_SIZE: 'updateCellSize',

\t/**
\t * Variable: ESCAPE
\t *
\t * Specifies the event name for escape.
\t */
\tESCAPE: 'escape',

\t/**
\t * Variable: DOUBLE_CLICK
\t *
\t * Specifies the event name for doubleClick.
\t */
\tDOUBLE_CLICK: 'doubleClick',

\t/**
\t * Variable: START
\t *
\t * Specifies the event name for start.
\t */
\tSTART: 'start',

\t/**
\t * Variable: RESET
\t *
\t * Specifies the event name for reset.
\t */
\tRESET: 'reset',

\t/**
\t * Variable: PINCH_THRESHOLD
\t *
\t * Threshold for pinch gestures to fire a mouse wheel event.
\t * Default value is 10.
\t */
\tPINCH_THRESHOLD: 10

};
/**
 * Copyright (c) 2006-2020, JGraph Ltd
 * Copyright (c) 2006-2020, draw.io AG
 */
/**
 * Class: mxXmlRequest
 * 
 * XML HTTP request wrapper. See also: <mxUtils.get>, <mxUtils.post> and
 * <mxUtils.load>. This class provides a cross-browser abstraction for Ajax
 * requests.
 * 
 * Encoding:
 * 
 * For encoding parameter values, the built-in encodeURIComponent JavaScript
 * method must be used. For automatic encoding of post data in <mxEditor> the
 * <mxEditor.escapePostData> switch can be set to true (default). The encoding
 * will be carried out using the conte type of the page. That is, the page
 * containting the editor should contain a meta tag in the header, eg.
 * <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">
 * 
 * Example:
 * 
 * (code)
 * var onload = function(req)
 * {
 *   mxUtils.alert(req.getDocumentElement());
 * }
 * 
 * var onerror = function(req)
 * {
 *   mxUtils.alert('Error');
 * }
 * new mxXmlRequest(url, 'key=value').send(onload, onerror);
 * (end)
 * 
 * Sends an asynchronous POST request to the specified URL.
 * 
 * Example:
 * 
 * (code)
 * var req = new mxXmlRequest(url, 'key=value', 'POST', false);
 * req.send();
 * mxUtils.alert(req.getDocumentElement());
 * (end)
 * 
 * Sends a synchronous POST request to the specified URL.
 * 
 * Example:
 * 
 * (code)
 * var encoder = new mxCodec();
 * var result = encoder.encode(graph.getModel());
 * var xml = encodeURIComponent(mxUtils.getXml(result));
 * new mxXmlRequest(url, 'xml='+xml).send();
 * (end)
 * 
 * Sends an encoded graph model to the specified URL using xml as the
 * parameter name. The parameter can then be retrieved in C# as follows:
 * 
 * (code)
 * string xml = HttpUtility.UrlDecode(context.Request.Params[\"xml\"]);
 * (end)
 * 
 * Or in Java as follows:
 * 
 * (code)
 * String xml = URLDecoder.decode(request.getParameter(\"xml\"), \"UTF-8\").replace(\"\\n\", \"&#xa;\");
 * (end)
 *
 * Note that the linefeeds should only be replaced if the XML is
 * processed in Java, for example when creating an image.
 * 
 * Constructor: mxXmlRequest
 * 
 * Constructs an XML HTTP request.
 * 
 * Parameters:
 * 
 * url - Target URL of the request.
 * params - Form encoded parameters to send with a POST request.
 * method - String that specifies the request method. Possible values are
 * POST and GET. Default is POST.
 * async - Boolean specifying if an asynchronous request should be used.
 * Default is true.
 * username - String specifying the username to be used for the request.
 * password - String specifying the password to be used for the request.
 */
function mxXmlRequest(url, params, method, async, username, password)
{
\tthis.url = url;
\tthis.params = params;
\tthis.method = method || 'POST';
\tthis.async = (async != null) ? async : true;
\tthis.username = username;
\tthis.password = password;
};

/**
 * Variable: url
 * 
 * Holds the target URL of the request.
 */
mxXmlRequest.prototype.url = null;

/**
 * Variable: params
 * 
 * Holds the form encoded data for the POST request.
 */
mxXmlRequest.prototype.params = null;

/**
 * Variable: method
 * 
 * Specifies the request method. Possible values are POST and GET. Default
 * is POST.
 */
mxXmlRequest.prototype.method = null;

/**
 * Variable: async
 * 
 * Boolean indicating if the request is asynchronous.
 */
mxXmlRequest.prototype.async = null;

/**
 * Variable: binary
 * 
 * Boolean indicating if the request is binary. This option is ignored in IE.
 * In all other browsers the requested mime type is set to
 * text/plain; charset=x-user-defined. Default is false.
 */
mxXmlRequest.prototype.binary = false;

/**
 * Variable: withCredentials
 * 
 * Specifies if withCredentials should be used in HTML5-compliant browsers. Default is
 * false.
 */
mxXmlRequest.prototype.withCredentials = false;

/**
 * Variable: username
 * 
 * Specifies the username to be used for authentication.
 */
mxXmlRequest.prototype.username = null;

/**
 * Variable: password
 * 
 * Specifies the password to be used for authentication.
 */
mxXmlRequest.prototype.password = null;

/**
 * Variable: request
 * 
 * Holds the inner, browser-specific request object.
 */
mxXmlRequest.prototype.request = null;

/**
 * Variable: decodeSimulateValues
 * 
 * Specifies if request values should be decoded as URIs before setting the
 * textarea value in <simulate>. Defaults to false for backwards compatibility,
 * to avoid another decode on the server this should be set to true.
 */
mxXmlRequest.prototype.decodeSimulateValues = false;

/**
 * Function: isBinary
 * 
 * Returns <binary>.
 */
mxXmlRequest.prototype.isBinary = function()
{
\treturn this.binary;
};

/**
 * Function: setBinary
 * 
 * Sets <binary>.
 */
mxXmlRequest.prototype.setBinary = function(value)
{
\tthis.binary = value;
};

/**
 * Function: getText
 * 
 * Returns the response as a string.
 */
mxXmlRequest.prototype.getText = function()
{
\treturn this.request.responseText;
};

/**
 * Function: isReady
 * 
 * Returns true if the response is ready.
 */
mxXmlRequest.prototype.isReady = function()
{
\treturn this.request.readyState == 4;
};

/**
 * Function: getDocumentElement
 * 
 * Returns the document element of the response XML document.
 */
mxXmlRequest.prototype.getDocumentElement = function()
{
\tvar doc = this.getXml();
\t
\tif (doc != null)
\t{
\t\treturn doc.documentElement;
\t}
\t
\treturn null;
};

/**
 * Function: getXml
 * 
 * Returns the response as an XML document. Use <getDocumentElement> to get
 * the document element of the XML document.
 */
mxXmlRequest.prototype.getXml = function()
{
\tvar xml = this.request.responseXML;
\t
\t// Handles missing response headers in IE, the first condition handles
\t// the case where responseXML is there, but using its nodes leads to
\t// type errors in the mxCellCodec when putting the nodes into a new
\t// document. This happens in IE9 standards mode and with XML user
\t// objects only, as they are used directly as values in cells.
\tif (document.documentMode >= 9 || xml == null || xml.documentElement == null)
\t{
\t\txml = mxUtils.parseXml(this.request.responseText);
\t}
\t
\treturn xml;
};

/**
 * Function: getStatus
 * 
 * Returns the status as a number, eg. 404 for \"Not found\" or 200 for \"OK\".
 * Note: The NS_ERROR_NOT_AVAILABLE for invalid responses cannot be cought.
 */
mxXmlRequest.prototype.getStatus = function()
{
\treturn (this.request != null) ? this.request.status : null;
};

/**
 * Function: create
 * 
 * Creates and returns the inner <request> object.
 */
mxXmlRequest.prototype.create = function()
{
\tif (window.XMLHttpRequest)
\t{
\t\treturn function()
\t\t{
\t\t\tvar req = new XMLHttpRequest();
\t\t\t
\t\t\t// TODO: Check for overrideMimeType required here?
\t\t\tif (this.isBinary() && req.overrideMimeType)
\t\t\t{
\t\t\t\treq.overrideMimeType('text/plain; charset=x-user-defined');
\t\t\t}

\t\t\treturn req;
\t\t};
\t}
\telse if (typeof(ActiveXObject) != 'undefined')
\t{
\t\treturn function()
\t\t{
\t\t\t// TODO: Implement binary option
\t\t\treturn new ActiveXObject('Microsoft.XMLHTTP');
\t\t};
\t}
}();

/**
 * Function: send
 * 
 * Send the <request> to the target URL using the specified functions to
 * process the response asychronously.
 * 
 * Note: Due to technical limitations, onerror is currently ignored.
 * 
 * Parameters:
 * 
 * onload - Function to be invoked if a successful response was received.
 * onerror - Function to be called on any error. Unused in this implementation, intended for overriden function.
 * timeout - Optional timeout in ms before calling ontimeout.
 * ontimeout - Optional function to execute on timeout.
 */
mxXmlRequest.prototype.send = function(onload, onerror, timeout, ontimeout)
{
\tthis.request = this.create();
\t
\tif (this.request != null)
\t{
\t\tif (onload != null)
\t\t{
\t\t\tthis.request.onreadystatechange = mxUtils.bind(this, function()
\t\t\t{
\t\t\t\tif (this.isReady())
\t\t\t\t{
\t\t\t\t\tonload(this);
\t\t\t\t\tthis.request.onreadystatechange = null;
\t\t\t\t}
\t\t\t});
\t\t}

\t\tthis.request.open(this.method, this.url, this.async,
\t\t\tthis.username, this.password);
\t\tthis.setRequestHeaders(this.request, this.params);
\t\t
\t\tif (window.XMLHttpRequest && this.withCredentials)
\t\t{
\t\t\tthis.request.withCredentials = 'true';
\t\t}
\t\t
\t\tif (!mxClient.IS_QUIRKS && (document.documentMode == null || document.documentMode > 9) &&
\t\t\twindow.XMLHttpRequest && timeout != null && ontimeout != null)
\t\t{
\t\t\tthis.request.timeout = timeout;
\t\t\tthis.request.ontimeout = ontimeout;
\t\t}
\t\t\t\t
\t\tthis.request.send(this.params);
\t}
};

/**
 * Function: setRequestHeaders
 * 
 * Sets the headers for the given request and parameters. This sets the
 * content-type to application/x-www-form-urlencoded if any params exist.
 * 
 * Example:
 * 
 * (code)
 * request.setRequestHeaders = function(request, params)
 * {
 *   if (params != null)
 *   {
 *     request.setRequestHeader('Content-Type',
 *             'multipart/form-data');
 *     request.setRequestHeader('Content-Length',
 *             params.length);
 *   }
 * };
 * (end)
 * 
 * Use the code above before calling <send> if you require a
 * multipart/form-data request.   
 */
mxXmlRequest.prototype.setRequestHeaders = function(request, params)
{
\tif (params != null)
\t{
\t\trequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
\t}
};

/**
 * Function: simulate
 * 
 * Creates and posts a request to the given target URL using a dynamically
 * created form inside the given document.
 * 
 * Parameters:
 * 
 * docs - Document that contains the form element.
 * target - Target to send the form result to.
 */
mxXmlRequest.prototype.simulate = function(doc, target)
{
\tdoc = doc || document;
\tvar old = null;

\tif (doc == document)
\t{
\t\told = window.onbeforeunload;\t\t
\t\twindow.onbeforeunload = null;
\t}
\t\t\t
\tvar form = doc.createElement('form');
\tform.setAttribute('method', this.method);
\tform.setAttribute('action', this.url);

\tif (target != null)
\t{
\t\tform.setAttribute('target', target);
\t}

\tform.style.display = 'none';
\tform.style.visibility = 'hidden';
\t
\tvar pars = (this.params.indexOf('&') > 0) ?
\t\tthis.params.split('&') :
\t\tthis.params.split();

\t// Adds the parameters as textareas to the form
\tfor (var i=0; i<pars.length; i++)
\t{
\t\tvar pos = pars[i].indexOf('=');
\t\t
\t\tif (pos > 0)
\t\t{
\t\t\tvar name = pars[i].substring(0, pos);
\t\t\tvar value = pars[i].substring(pos+1);
\t\t\t
\t\t\tif (this.decodeSimulateValues)
\t\t\t{
\t\t\t\tvalue = decodeURIComponent(value);
\t\t\t}
\t\t\t
\t\t\tvar textarea = doc.createElement('textarea');
\t\t\ttextarea.setAttribute('wrap', 'off');
\t\t\ttextarea.setAttribute('name', name);
\t\t\tmxUtils.write(textarea, value);
\t\t\tform.appendChild(textarea);
\t\t}
\t}
\t
\tdoc.body.appendChild(form);
\tform.submit();
\t
\tif (form.parentNode != null)
\t{
\t\tform.parentNode.removeChild(form);
\t}

\tif (old != null)
\t{\t\t
\t\twindow.onbeforeunload = old;
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxClipboard =
{
\t/**
\t * Class: mxClipboard
\t * 
\t * Singleton that implements a clipboard for graph cells.
\t *
\t * Example:
\t * 
\t * (code)
\t * mxClipboard.copy(graph);
\t * mxClipboard.paste(graph2);
\t * (end)
\t *
\t * This copies the selection cells from the graph to the clipboard and
\t * pastes them into graph2.
\t * 
\t * For fine-grained control of the clipboard data the <mxGraph.canExportCell>
\t * and <mxGraph.canImportCell> functions can be overridden.
\t * 
\t * To restore previous parents for pasted cells, the implementation for
\t * <copy> and <paste> can be changed as follows.
\t * 
\t * (code)
\t * mxClipboard.copy = function(graph, cells)
\t * {
\t *   cells = cells || graph.getSelectionCells();
\t *   var result = graph.getExportableCells(cells);
\t *   
\t *   mxClipboard.parents = new Object();
\t *   
\t *   for (var i = 0; i < result.length; i++)
\t *   {
\t *     mxClipboard.parents[i] = graph.model.getParent(cells[i]);
\t *   }
\t *   
\t *   mxClipboard.insertCount = 1;
\t *   mxClipboard.setCells(graph.cloneCells(result));
\t *   
\t *   return result;
\t * };
\t * 
\t * mxClipboard.paste = function(graph)
\t * {
\t *   if (!mxClipboard.isEmpty())
\t *   {
\t *     var cells = graph.getImportableCells(mxClipboard.getCells());
\t *     var delta = mxClipboard.insertCount * mxClipboard.STEPSIZE;
\t *     var parent = graph.getDefaultParent();
\t *     
\t *     graph.model.beginUpdate();
\t *     try
\t *     {
\t *       for (var i = 0; i < cells.length; i++)
\t *       {
\t *         var tmp = (mxClipboard.parents != null && graph.model.contains(mxClipboard.parents[i])) ?
\t *              mxClipboard.parents[i] : parent;
\t *         cells[i] = graph.importCells([cells[i]], delta, delta, tmp)[0];
\t *       }
\t *     }
\t *     finally
\t *     {
\t *       graph.model.endUpdate();
\t *     }
\t *     
\t *     // Increments the counter and selects the inserted cells
\t *     mxClipboard.insertCount++;
\t *     graph.setSelectionCells(cells);
\t *   }
\t * };
\t * (end)
\t * 
\t * Variable: STEPSIZE
\t * 
\t * Defines the step size to offset the cells after each paste operation.
\t * Default is 10.
\t */
\tSTEPSIZE: 10,

\t/**
\t * Variable: insertCount
\t * 
\t * Counts the number of times the clipboard data has been inserted.
\t */
\tinsertCount: 1,

\t/**
\t * Variable: cells
\t * 
\t * Holds the array of <mxCells> currently in the clipboard.
\t */
\tcells: null,

\t/**
\t * Function: setCells
\t * 
\t * Sets the cells in the clipboard. Fires a <mxEvent.CHANGE> event.
\t */
\tsetCells: function(cells)
\t{
\t\tmxClipboard.cells = cells;
\t},

\t/**
\t * Function: getCells
\t * 
\t * Returns  the cells in the clipboard.
\t */
\tgetCells: function()
\t{
\t\treturn mxClipboard.cells;
\t},
\t
\t/**
\t * Function: isEmpty
\t * 
\t * Returns true if the clipboard currently has not data stored.
\t */
\tisEmpty: function()
\t{
\t\treturn mxClipboard.getCells() == null;
\t},
\t
\t/**
\t * Function: cut
\t * 
\t * Cuts the given array of <mxCells> from the specified graph.
\t * If cells is null then the selection cells of the graph will
\t * be used. Returns the cells that have been cut from the graph.
\t *
\t * Parameters:
\t * 
\t * graph - <mxGraph> that contains the cells to be cut.
\t * cells - Optional array of <mxCells> to be cut.
\t */
\tcut: function(graph, cells)
\t{
\t\tcells = mxClipboard.copy(graph, cells);
\t\tmxClipboard.insertCount = 0;
\t\tmxClipboard.removeCells(graph, cells);
\t\t
\t\treturn cells;
\t},

\t/**
\t * Function: removeCells
\t * 
\t * Hook to remove the given cells from the given graph after
\t * a cut operation.
\t *
\t * Parameters:
\t * 
\t * graph - <mxGraph> that contains the cells to be cut.
\t * cells - Array of <mxCells> to be cut.
\t */
\tremoveCells: function(graph, cells)
\t{
\t\tgraph.removeCells(cells);
\t},

\t/**
\t * Function: copy
\t * 
\t * Copies the given array of <mxCells> from the specified
\t * graph to <cells>. Returns the original array of cells that has
\t * been cloned. Descendants of cells in the array are ignored.
\t * 
\t * Parameters:
\t * 
\t * graph - <mxGraph> that contains the cells to be copied.
\t * cells - Optional array of <mxCells> to be copied.
\t */
\tcopy: function(graph, cells)
\t{
\t\tcells = cells || graph.getSelectionCells();
\t\tvar result = graph.getExportableCells(graph.model.getTopmostCells(cells));
\t\tmxClipboard.insertCount = 1;
\t\tmxClipboard.setCells(graph.cloneCells(result));

\t\treturn result;
\t},

\t/**
\t * Function: paste
\t * 
\t * Pastes the <cells> into the specified graph restoring
\t * the relation to <parents>, if possible. If the parents
\t * are no longer in the graph or invisible then the
\t * cells are added to the graph's default or into the
\t * swimlane under the cell's new location if one exists.
\t * The cells are added to the graph using <mxGraph.importCells>
\t * and returned.
\t * 
\t * Parameters:
\t * 
\t * graph - <mxGraph> to paste the <cells> into.
\t */
\tpaste: function(graph)
\t{
\t\tvar cells = null;
\t\t
\t\tif (!mxClipboard.isEmpty())
\t\t{
\t\t\tcells = graph.getImportableCells(mxClipboard.getCells());
\t\t\tvar delta = mxClipboard.insertCount * mxClipboard.STEPSIZE;
\t\t\tvar parent = graph.getDefaultParent();
\t\t\tcells = graph.importCells(cells, delta, delta, parent);
\t\t\t
\t\t\t// Increments the counter and selects the inserted cells
\t\t\tmxClipboard.insertCount++;
\t\t\tgraph.setSelectionCells(cells);
\t\t}
\t\t
\t\treturn cells;
\t}

};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxWindow
 * 
 * Basic window inside a document.
 * 
 * Examples:
 * 
 * Creating a simple window.
 *
 * (code)
 * var tb = document.createElement('div');
 * var wnd = new mxWindow('Title', tb, 100, 100, 200, 200, true, true);
 * wnd.setVisible(true); 
 * (end)
 *
 * Creating a window that contains an iframe. 
 * 
 * (code)
 * var frame = document.createElement('iframe');
 * frame.setAttribute('width', '192px');
 * frame.setAttribute('height', '172px');
 * frame.setAttribute('src', 'http://www.example.com/');
 * frame.style.backgroundColor = 'white';
 * 
 * var w = document.body.clientWidth;
 * var h = (document.body.clientHeight || document.documentElement.clientHeight);
 * var wnd = new mxWindow('Title', frame, (w-200)/2, (h-200)/3, 200, 200);
 * wnd.setVisible(true);
 * (end)
 * 
 * To limit the movement of a window, eg. to keep it from being moved beyond
 * the top, left corner the following method can be overridden (recommended):
 * 
 * (code)
 * wnd.setLocation = function(x, y)
 * {
 *   x = Math.max(0, x);
 *   y = Math.max(0, y);
 *   mxWindow.prototype.setLocation.apply(this, arguments);
 * };
 * (end)
 * 
 * Or the following event handler can be used:
 * 
 * (code)
 * wnd.addListener(mxEvent.MOVE, function(e)
 * {
 *   wnd.setLocation(Math.max(0, wnd.getX()), Math.max(0, wnd.getY()));
 * });
 * (end)
 * 
 * To keep a window inside the current window:
 * 
 * (code)
 * mxEvent.addListener(window, 'resize', mxUtils.bind(this, function()
 * {
 *   var iw = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
 *   var ih = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
 *   
 *   var x = this.window.getX();
 *   var y = this.window.getY();
 *   
 *   if (x + this.window.table.clientWidth > iw)
 *   {
 *     x = Math.max(0, iw - this.window.table.clientWidth);
 *   }
 *   
 *   if (y + this.window.table.clientHeight > ih)
 *   {
 *     y = Math.max(0, ih - this.window.table.clientHeight);
 *   }
 *   
 *   if (this.window.getX() != x || this.window.getY() != y)
 *   {
 *     this.window.setLocation(x, y);
 *   }
 * }));
 * (end)
 *
 * Event: mxEvent.MOVE_START
 *
 * Fires before the window is moved. The <code>event</code> property contains
 * the corresponding mouse event.
 *
 * Event: mxEvent.MOVE
 *
 * Fires while the window is being moved. The <code>event</code> property
 * contains the corresponding mouse event.
 *
 * Event: mxEvent.MOVE_END
 *
 * Fires after the window is moved. The <code>event</code> property contains
 * the corresponding mouse event.
 *
 * Event: mxEvent.RESIZE_START
 *
 * Fires before the window is resized. The <code>event</code> property contains
 * the corresponding mouse event.
 *
 * Event: mxEvent.RESIZE
 *
 * Fires while the window is being resized. The <code>event</code> property
 * contains the corresponding mouse event.
 *
 * Event: mxEvent.RESIZE_END
 *
 * Fires after the window is resized. The <code>event</code> property contains
 * the corresponding mouse event.
 *
 * Event: mxEvent.MAXIMIZE
 * 
 * Fires after the window is maximized. The <code>event</code> property
 * contains the corresponding mouse event.
 * 
 * Event: mxEvent.MINIMIZE
 * 
 * Fires after the window is minimized. The <code>event</code> property
 * contains the corresponding mouse event.
 * 
 * Event: mxEvent.NORMALIZE
 * 
 * Fires after the window is normalized, that is, it returned from
 * maximized or minimized state. The <code>event</code> property contains the
 * corresponding mouse event.
 *  
 * Event: mxEvent.ACTIVATE
 * 
 * Fires after a window is activated. The <code>previousWindow</code> property
 * contains the previous window. The event sender is the active window.
 * 
 * Event: mxEvent.SHOW
 * 
 * Fires after the window is shown. This event has no properties.
 * 
 * Event: mxEvent.HIDE
 * 
 * Fires after the window is hidden. This event has no properties.
 * 
 * Event: mxEvent.CLOSE
 * 
 * Fires before the window is closed. The <code>event</code> property contains
 * the corresponding mouse event.
 * 
 * Event: mxEvent.DESTROY
 * 
 * Fires before the window is destroyed. This event has no properties.
 * 
 * Constructor: mxWindow
 * 
 * Constructs a new window with the given dimension and title to display
 * the specified content. The window elements use the given style as a
 * prefix for the classnames of the respective window elements, namely,
 * the window title and window pane. The respective postfixes are appended
 * to the given stylename as follows:
 * 
 *   style - Base style for the window.
 *   style+Title - Style for the window title.
 *   style+Pane - Style for the window pane.
 * 
 * The default value for style is mxWindow, resulting in the following
 * classnames for the window elements: mxWindow, mxWindowTitle and
 * mxWindowPane.
 * 
 * If replaceNode is given then the window replaces the given DOM node in
 * the document.
 * 
 * Parameters:
 * 
 * title - String that represents the title of the new window.
 * content - DOM node that is used as the window content.
 * x - X-coordinate of the window location.
 * y - Y-coordinate of the window location.
 * width - Width of the window.
 * height - Optional height of the window. Default is to match the height
 * of the content at the specified width.
 * minimizable - Optional boolean indicating if the window is minimizable.
 * Default is true.
 * movable - Optional boolean indicating if the window is movable. Default
 * is true.
 * replaceNode - Optional DOM node that the window should replace.
 * style - Optional base classname for the window elements. Default is
 * mxWindow.
 */
function mxWindow(title, content, x, y, width, height, minimizable, movable, replaceNode, style)
{
\tif (content != null)
\t{
\t\tminimizable = (minimizable != null) ? minimizable : true;
\t\tthis.content = content;
\t\tthis.init(x, y, width, height, style);
\t\t
\t\tthis.installMaximizeHandler();
\t\tthis.installMinimizeHandler();
\t\tthis.installCloseHandler();
\t\tthis.setMinimizable(minimizable);
\t\tthis.setTitle(title);
\t\t
\t\tif (movable == null || movable)
\t\t{
\t\t\tthis.installMoveHandler();
\t\t}

\t\tif (replaceNode != null && replaceNode.parentNode != null)
\t\t{
\t\t\treplaceNode.parentNode.replaceChild(this.div, replaceNode);
\t\t}
\t\telse
\t\t{
\t\t\tdocument.body.appendChild(this.div);
\t\t}
\t}
};

/**
 * Extends mxEventSource.
 */
mxWindow.prototype = new mxEventSource();
mxWindow.prototype.constructor = mxWindow;

/**
 * Variable: closeImage
 * 
 * URL of the image to be used for the close icon in the titlebar.
 */
mxWindow.prototype.closeImage = mxClient.imageBasePath + '/close.gif';

/**
 * Variable: minimizeImage
 * 
 * URL of the image to be used for the minimize icon in the titlebar.
 */
mxWindow.prototype.minimizeImage = mxClient.imageBasePath + '/minimize.gif';
\t
/**
 * Variable: normalizeImage
 * 
 * URL of the image to be used for the normalize icon in the titlebar.
 */
mxWindow.prototype.normalizeImage = mxClient.imageBasePath + '/normalize.gif';
\t
/**
 * Variable: maximizeImage
 * 
 * URL of the image to be used for the maximize icon in the titlebar.
 */
mxWindow.prototype.maximizeImage = mxClient.imageBasePath + '/maximize.gif';

/**
 * Variable: resizeImage
 * 
 * URL of the image to be used for the resize icon.
 */
mxWindow.prototype.resizeImage = mxClient.imageBasePath + '/resize.gif';

/**
 * Variable: visible
 * 
 * Boolean flag that represents the visible state of the window.
 */
mxWindow.prototype.visible = false;

/**
 * Variable: minimumSize
 * 
 * <mxRectangle> that specifies the minimum width and height of the window.
 * Default is (50, 40).
 */
mxWindow.prototype.minimumSize = new mxRectangle(0, 0, 50, 40);

/**
 * Variable: destroyOnClose
 * 
 * Specifies if the window should be destroyed when it is closed. If this
 * is false then the window is hidden using <setVisible>. Default is true.
 */
mxWindow.prototype.destroyOnClose = true;

/**
 * Variable: contentHeightCorrection
 * 
 * Defines the correction factor for computing the height of the contentWrapper.
 * Default is 6 for IE 7/8 standards mode and 2 for all other browsers and modes.
 */
mxWindow.prototype.contentHeightCorrection = (document.documentMode == 8 || document.documentMode == 7) ? 6 : 2;

/**
 * Variable: title
 * 
 * Reference to the DOM node (TD) that contains the title.
 */
mxWindow.prototype.title = null;

/**
 * Variable: content
 * 
 * Reference to the DOM node that represents the window content.
 */
mxWindow.prototype.content = null;

/**
 * Function: init
 * 
 * Initializes the DOM tree that represents the window.
 */
mxWindow.prototype.init = function(x, y, width, height, style)
{
\tstyle = (style != null) ? style : 'mxWindow';
\t
\tthis.div = document.createElement('div');
\tthis.div.className = style;

\tthis.div.style.left = x + 'px';
\tthis.div.style.top = y + 'px';
\tthis.table = document.createElement('table');
\tthis.table.className = style;

\t// Disables built-in pan and zoom in IE10 and later
\tif (mxClient.IS_POINTER)
\t{
\t\tthis.div.style.touchAction = 'none';
\t}
\t
\t// Workaround for table size problems in FF
\tif (width != null)
\t{
\t\tif (!mxClient.IS_QUIRKS)
\t\t{
\t\t\tthis.div.style.width = width + 'px'; 
\t\t}
\t\t
\t\tthis.table.style.width = width + 'px';
\t} 
\t
\tif (height != null)
\t{
\t\tif (!mxClient.IS_QUIRKS)
\t\t{
\t\t\tthis.div.style.height = height + 'px';
\t\t}
\t\t
\t\tthis.table.style.height = height + 'px';
\t}\t\t
\t
\t// Creates title row
\tvar tbody = document.createElement('tbody');
\tvar tr = document.createElement('tr');
\t
\tthis.title = document.createElement('td');
\tthis.title.className = style + 'Title';
\t
\tthis.buttons = document.createElement('div');
\tthis.buttons.style.position = 'absolute';
\tthis.buttons.style.display = 'inline-block';
\tthis.buttons.style.right = '4px';
\tthis.buttons.style.top = '5px';
\tthis.title.appendChild(this.buttons);
\t
\ttr.appendChild(this.title);
\ttbody.appendChild(tr);
\t
\t// Creates content row and table cell
\ttr = document.createElement('tr');
\tthis.td = document.createElement('td');
\tthis.td.className = style + 'Pane';
\t
\tif (document.documentMode == 7)
\t{
\t\tthis.td.style.height = '100%';
\t}

\tthis.contentWrapper = document.createElement('div');
\tthis.contentWrapper.className = style + 'Pane';
\tthis.contentWrapper.style.width = '100%';
\tthis.contentWrapper.appendChild(this.content);

\t// Workaround for div around div restricts height
\t// of inner div if outerdiv has hidden overflow
\tif (mxClient.IS_QUIRKS || this.content.nodeName.toUpperCase() != 'DIV')
\t{
\t\tthis.contentWrapper.style.height = '100%';
\t}

\t// Puts all content into the DOM
\tthis.td.appendChild(this.contentWrapper);
\ttr.appendChild(this.td);
\ttbody.appendChild(tr);
\tthis.table.appendChild(tbody);
\tthis.div.appendChild(this.table);
\t
\t// Puts the window on top of other windows when clicked
\tvar activator = mxUtils.bind(this, function(evt)
\t{
\t\tthis.activate();
\t});
\t
\tmxEvent.addGestureListeners(this.title, activator);
\tmxEvent.addGestureListeners(this.table, activator);

\tthis.hide();
};

/**
 * Function: setTitle
 * 
 * Sets the window title to the given string. HTML markup inside the title
 * will be escaped.
 */
mxWindow.prototype.setTitle = function(title)
{
\t// Removes all text content nodes (normally just one)
\tvar child = this.title.firstChild;
\t
\twhile (child != null)
\t{
\t\tvar next = child.nextSibling;
\t\t
\t\tif (child.nodeType == mxConstants.NODETYPE_TEXT)
\t\t{
\t\t\tchild.parentNode.removeChild(child);
\t\t}
\t\t
\t\tchild = next;
\t}
\t
\tmxUtils.write(this.title, title || '');
\tthis.title.appendChild(this.buttons);
};

/**
 * Function: setScrollable
 * 
 * Sets if the window contents should be scrollable.
 */
mxWindow.prototype.setScrollable = function(scrollable)
{
\t// Workaround for hang in Presto 2.5.22 (Opera 10.5)
\tif (navigator.userAgent == null ||
\t\tnavigator.userAgent.indexOf('Presto/2.5') < 0)
\t{
\t\tif (scrollable)
\t\t{
\t\t\tthis.contentWrapper.style.overflow = 'auto';
\t\t}
\t\telse
\t\t{
\t\t\tthis.contentWrapper.style.overflow = 'hidden';
\t\t}
\t}
};

/**
 * Function: activate
 * 
 * Puts the window on top of all other windows.
 */
mxWindow.prototype.activate = function()
{
\tif (mxWindow.activeWindow != this)
\t{
\t\tvar style = mxUtils.getCurrentStyle(this.getElement());
\t\tvar index = (style != null) ? style.zIndex : 3;

\t\tif (mxWindow.activeWindow)
\t\t{
\t\t\tvar elt = mxWindow.activeWindow.getElement();
\t\t\t
\t\t\tif (elt != null && elt.style != null)
\t\t\t{
\t\t\t\telt.style.zIndex = index;
\t\t\t}
\t\t}
\t\t
\t\tvar previousWindow = mxWindow.activeWindow;
\t\tthis.getElement().style.zIndex = parseInt(index) + 1;
\t\tmxWindow.activeWindow = this;
\t\t
\t\tthis.fireEvent(new mxEventObject(mxEvent.ACTIVATE, 'previousWindow', previousWindow));
\t}
};

/**
 * Function: getElement
 * 
 * Returuns the outermost DOM node that makes up the window.
 */
mxWindow.prototype.getElement = function()
{
\treturn this.div;
};

/**
 * Function: fit
 * 
 * Makes sure the window is inside the client area of the window.
 */
mxWindow.prototype.fit = function()
{
\tmxUtils.fit(this.div);
};

/**
 * Function: isResizable
 * 
 * Returns true if the window is resizable.
 */
mxWindow.prototype.isResizable = function()
{
\tif (this.resize != null)
\t{
\t\treturn this.resize.style.display != 'none';
\t}
\t
\treturn false;
};

/**
 * Function: setResizable
 * 
 * Sets if the window should be resizable. To avoid interference with some
 * built-in features of IE10 and later, the use of the following code is
 * recommended if there are resizable <mxWindow>s in the page:
 * 
 * (code)
 * if (mxClient.IS_POINTER)
 * {
 *   document.body.style.msTouchAction = 'none';
 * }
 * (end)
 */
mxWindow.prototype.setResizable = function(resizable)
{
\tif (resizable)
\t{
\t\tif (this.resize == null)
\t\t{
\t\t\tthis.resize = document.createElement('img');
\t\t\tthis.resize.style.position = 'absolute';
\t\t\tthis.resize.style.bottom = '2px';
\t\t\tthis.resize.style.right = '2px';

\t\t\tthis.resize.setAttribute('src', this.resizeImage);
\t\t\tthis.resize.style.cursor = 'nw-resize';
\t\t\t
\t\t\tvar startX = null;
\t\t\tvar startY = null;
\t\t\tvar width = null;
\t\t\tvar height = null;
\t\t\t
\t\t\tvar start = mxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\t// LATER: pointerdown starting on border of resize does start
\t\t\t\t// the drag operation but does not fire consecutive events via
\t\t\t\t// one of the listeners below (does pan instead).
\t\t\t\t// Workaround: document.body.style.msTouchAction = 'none'
\t\t\t\tthis.activate();
\t\t\t\tstartX = mxEvent.getClientX(evt);
\t\t\t\tstartY = mxEvent.getClientY(evt);
\t\t\t\twidth = this.div.offsetWidth;
\t\t\t\theight = this.div.offsetHeight;
\t\t\t\t
\t\t\t\tmxEvent.addGestureListeners(document, null, dragHandler, dropHandler);
\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.RESIZE_START, 'event', evt));
\t\t\t\tmxEvent.consume(evt);
\t\t\t});

\t\t\t// Adds a temporary pair of listeners to intercept
\t\t\t// the gesture event in the document
\t\t\tvar dragHandler = mxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tif (startX != null && startY != null)
\t\t\t\t{
\t\t\t\t\tvar dx = mxEvent.getClientX(evt) - startX;
\t\t\t\t\tvar dy = mxEvent.getClientY(evt) - startY;
\t
\t\t\t\t\tthis.setSize(width + dx, height + dy);
\t
\t\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.RESIZE, 'event', evt));
\t\t\t\t\tmxEvent.consume(evt);
\t\t\t\t}
\t\t\t});
\t\t\t
\t\t\tvar dropHandler = mxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tif (startX != null && startY != null)
\t\t\t\t{
\t\t\t\t\tstartX = null;
\t\t\t\t\tstartY = null;
\t\t\t\t\tmxEvent.removeGestureListeners(document, null, dragHandler, dropHandler);
\t\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.RESIZE_END, 'event', evt));
\t\t\t\t\tmxEvent.consume(evt);
\t\t\t\t}
\t\t\t});
\t\t\t
\t\t\tmxEvent.addGestureListeners(this.resize, start, dragHandler, dropHandler);
\t\t\tthis.div.appendChild(this.resize);
\t\t}
\t\telse 
\t\t{
\t\t\tthis.resize.style.display = 'inline';
\t\t}
\t}
\telse if (this.resize != null)
\t{
\t\tthis.resize.style.display = 'none';
\t}
};
\t
/**
 * Function: setSize
 * 
 * Sets the size of the window.
 */
mxWindow.prototype.setSize = function(width, height)
{
\twidth = Math.max(this.minimumSize.width, width);
\theight = Math.max(this.minimumSize.height, height);

\t// Workaround for table size problems in FF
\tif (!mxClient.IS_QUIRKS)
\t{
\t\tthis.div.style.width =  width + 'px';
\t\tthis.div.style.height = height + 'px';
\t}
\t
\tthis.table.style.width =  width + 'px';
\tthis.table.style.height = height + 'px';

\tif (!mxClient.IS_QUIRKS)
\t{
\t\tthis.contentWrapper.style.height = (this.div.offsetHeight -
\t\t\tthis.title.offsetHeight - this.contentHeightCorrection) + 'px';
\t}
};
\t
/**
 * Function: setMinimizable
 * 
 * Sets if the window is minimizable.
 */
mxWindow.prototype.setMinimizable = function(minimizable)
{
\tthis.minimize.style.display = (minimizable) ? '' : 'none';
};

/**
 * Function: getMinimumSize
 * 
 * Returns an <mxRectangle> that specifies the size for the minimized window.
 * A width or height of 0 means keep the existing width or height. This
 * implementation returns the height of the window title and keeps the width.
 */
mxWindow.prototype.getMinimumSize = function()
{
\treturn new mxRectangle(0, 0, 0, this.title.offsetHeight);
};

/**
 * Function: installMinimizeHandler
 * 
 * Installs the event listeners required for minimizing the window.
 */
mxWindow.prototype.installMinimizeHandler = function()
{
\tthis.minimize = document.createElement('img');
\t
\tthis.minimize.setAttribute('src', this.minimizeImage);
\tthis.minimize.setAttribute('title', 'Minimize');
\tthis.minimize.style.cursor = 'pointer';
\tthis.minimize.style.marginLeft = '2px';
\tthis.minimize.style.display = 'none';
\t
\tthis.buttons.appendChild(this.minimize);
\t
\tvar minimized = false;
\tvar maxDisplay = null;
\tvar height = null;

\tvar funct = mxUtils.bind(this, function(evt)
\t{
\t\tthis.activate();
\t\t
\t\tif (!minimized)
\t\t{
\t\t\tminimized = true;
\t\t\t
\t\t\tthis.minimize.setAttribute('src', this.normalizeImage);
\t\t\tthis.minimize.setAttribute('title', 'Normalize');
\t\t\tthis.contentWrapper.style.display = 'none';
\t\t\tmaxDisplay = this.maximize.style.display;
\t\t\t
\t\t\tthis.maximize.style.display = 'none';
\t\t\theight = this.table.style.height;
\t\t\t
\t\t\tvar minSize = this.getMinimumSize();
\t\t\t
\t\t\tif (minSize.height > 0)
\t\t\t{
\t\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t\t{
\t\t\t\t\tthis.div.style.height = minSize.height + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.table.style.height = minSize.height + 'px';
\t\t\t}
\t\t\t
\t\t\tif (minSize.width > 0)
\t\t\t{
\t\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t\t{
\t\t\t\t\tthis.div.style.width = minSize.width + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.table.style.width = minSize.width + 'px';
\t\t\t}
\t\t\t
\t\t\tif (this.resize != null)
\t\t\t{
\t\t\t\tthis.resize.style.visibility = 'hidden';
\t\t\t}
\t\t\t
\t\t\tthis.fireEvent(new mxEventObject(mxEvent.MINIMIZE, 'event', evt));
\t\t}
\t\telse
\t\t{
\t\t\tminimized = false;
\t\t\t
\t\t\tthis.minimize.setAttribute('src', this.minimizeImage);
\t\t\tthis.minimize.setAttribute('title', 'Minimize');
\t\t\tthis.contentWrapper.style.display = ''; // default
\t\t\tthis.maximize.style.display = maxDisplay;
\t\t\t
\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t{
\t\t\t\tthis.div.style.height = height;
\t\t\t}
\t\t\t
\t\t\tthis.table.style.height = height;

\t\t\tif (this.resize != null)
\t\t\t{
\t\t\t\tthis.resize.style.visibility = '';
\t\t\t}
\t\t\t
\t\t\tthis.fireEvent(new mxEventObject(mxEvent.NORMALIZE, 'event', evt));
\t\t}
\t\t
\t\tmxEvent.consume(evt);
\t});
\t
\tmxEvent.addGestureListeners(this.minimize, funct);
};
\t
/**
 * Function: setMaximizable
 * 
 * Sets if the window is maximizable.
 */
mxWindow.prototype.setMaximizable = function(maximizable)
{
\tthis.maximize.style.display = (maximizable) ? '' : 'none';
};

/**
 * Function: installMaximizeHandler
 * 
 * Installs the event listeners required for maximizing the window.
 */
mxWindow.prototype.installMaximizeHandler = function()
{
\tthis.maximize = document.createElement('img');
\t
\tthis.maximize.setAttribute('src', this.maximizeImage);
\tthis.maximize.setAttribute('title', 'Maximize');
\tthis.maximize.style.cursor = 'default';
\tthis.maximize.style.marginLeft = '2px';
\tthis.maximize.style.cursor = 'pointer';
\tthis.maximize.style.display = 'none';
\t
\tthis.buttons.appendChild(this.maximize);
\t
\tvar maximized = false;
\tvar x = null;
\tvar y = null;
\tvar height = null;
\tvar width = null;
\tvar minDisplay = null;

\tvar funct = mxUtils.bind(this, function(evt)
\t{
\t\tthis.activate();
\t\t
\t\tif (this.maximize.style.display != 'none')
\t\t{
\t\t\tif (!maximized)
\t\t\t{
\t\t\t\tmaximized = true;
\t\t\t\t
\t\t\t\tthis.maximize.setAttribute('src', this.normalizeImage);
\t\t\t\tthis.maximize.setAttribute('title', 'Normalize');
\t\t\t\tthis.contentWrapper.style.display = '';
\t\t\t\tminDisplay = this.minimize.style.display;
\t\t\t\tthis.minimize.style.display = 'none';
\t\t\t\t
\t\t\t\t// Saves window state
\t\t\t\tx = parseInt(this.div.style.left);
\t\t\t\ty = parseInt(this.div.style.top);
\t\t\t\theight = this.table.style.height;
\t\t\t\twidth = this.table.style.width;

\t\t\t\tthis.div.style.left = '0px';
\t\t\t\tthis.div.style.top = '0px';
\t\t\t\tvar docHeight = Math.max(document.body.clientHeight || 0, document.documentElement.clientHeight || 0);

\t\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t\t{
\t\t\t\t\tthis.div.style.width = (document.body.clientWidth - 2) + 'px';
\t\t\t\t\tthis.div.style.height = (docHeight - 2) + 'px';
\t\t\t\t}

\t\t\t\tthis.table.style.width = (document.body.clientWidth - 2) + 'px';
\t\t\t\tthis.table.style.height = (docHeight - 2) + 'px';
\t\t\t\t
\t\t\t\tif (this.resize != null)
\t\t\t\t{
\t\t\t\t\tthis.resize.style.visibility = 'hidden';
\t\t\t\t}

\t\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t\t{
\t\t\t\t\tvar style = mxUtils.getCurrentStyle(this.contentWrapper);
\t\t
\t\t\t\t\tif (style.overflow == 'auto' || this.resize != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.contentWrapper.style.height = (this.div.offsetHeight -
\t\t\t\t\t\t\tthis.title.offsetHeight - this.contentHeightCorrection) + 'px';
\t\t\t\t\t}
\t\t\t\t}

\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.MAXIMIZE, 'event', evt));
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tmaximized = false;
\t\t\t\t
\t\t\t\tthis.maximize.setAttribute('src', this.maximizeImage);
\t\t\t\tthis.maximize.setAttribute('title', 'Maximize');
\t\t\t\tthis.contentWrapper.style.display = '';
\t\t\t\tthis.minimize.style.display = minDisplay;

\t\t\t\t// Restores window state
\t\t\t\tthis.div.style.left = x+'px';
\t\t\t\tthis.div.style.top = y+'px';
\t\t\t\t
\t\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t\t{
\t\t\t\t\tthis.div.style.height = height;
\t\t\t\t\tthis.div.style.width = width;

\t\t\t\t\tvar style = mxUtils.getCurrentStyle(this.contentWrapper);
\t\t
\t\t\t\t\tif (style.overflow == 'auto' || this.resize != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.contentWrapper.style.height = (this.div.offsetHeight -
\t\t\t\t\t\t\tthis.title.offsetHeight - this.contentHeightCorrection) + 'px';
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.table.style.height = height;
\t\t\t\tthis.table.style.width = width;

\t\t\t\tif (this.resize != null)
\t\t\t\t{
\t\t\t\t\tthis.resize.style.visibility = '';
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.NORMALIZE, 'event', evt));
\t\t\t}
\t\t\t
\t\t\tmxEvent.consume(evt);
\t\t}
\t});
\t
\tmxEvent.addGestureListeners(this.maximize, funct);
\tmxEvent.addListener(this.title, 'dblclick', funct);
};
\t
/**
 * Function: installMoveHandler
 * 
 * Installs the event listeners required for moving the window.
 */
mxWindow.prototype.installMoveHandler = function()
{
\tthis.title.style.cursor = 'move';
\t
\tmxEvent.addGestureListeners(this.title,
\t\tmxUtils.bind(this, function(evt)
\t\t{
\t\t\tvar startX = mxEvent.getClientX(evt);
\t\t\tvar startY = mxEvent.getClientY(evt);
\t\t\tvar x = this.getX();
\t\t\tvar y = this.getY();
\t\t\t\t\t\t
\t\t\t// Adds a temporary pair of listeners to intercept
\t\t\t// the gesture event in the document
\t\t\tvar dragHandler = mxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tvar dx = mxEvent.getClientX(evt) - startX;
\t\t\t\tvar dy = mxEvent.getClientY(evt) - startY;
\t\t\t\tthis.setLocation(x + dx, y + dy);
\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.MOVE, 'event', evt));
\t\t\t\tmxEvent.consume(evt);
\t\t\t});
\t\t\t
\t\t\tvar dropHandler = mxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tmxEvent.removeGestureListeners(document, null, dragHandler, dropHandler);
\t\t\t\tthis.fireEvent(new mxEventObject(mxEvent.MOVE_END, 'event', evt));
\t\t\t\tmxEvent.consume(evt);
\t\t\t});
\t\t\t
\t\t\tmxEvent.addGestureListeners(document, null, dragHandler, dropHandler);
\t\t\tthis.fireEvent(new mxEventObject(mxEvent.MOVE_START, 'event', evt));
\t\t\tmxEvent.consume(evt);
\t\t}));
\t
\t// Disables built-in pan and zoom in IE10 and later
\tif (mxClient.IS_POINTER)
\t{
\t\tthis.title.style.touchAction = 'none';
\t}
};

/**
 * Function: setLocation
 * 
 * Sets the upper, left corner of the window.
 */
 mxWindow.prototype.setLocation = function(x, y)
 {
\tthis.div.style.left = x + 'px';
\tthis.div.style.top = y + 'px';
 };

/**
 * Function: getX
 *
 * Returns the current position on the x-axis.
 */
mxWindow.prototype.getX = function()
{
\treturn parseInt(this.div.style.left);
};

/**
 * Function: getY
 *
 * Returns the current position on the y-axis.
 */
mxWindow.prototype.getY = function()
{
\treturn parseInt(this.div.style.top);
};

/**
 * Function: installCloseHandler
 *
 * Adds the <closeImage> as a new image node in <closeImg> and installs the
 * <close> event.
 */
mxWindow.prototype.installCloseHandler = function()
{
\tthis.closeImg = document.createElement('img');
\t
\tthis.closeImg.setAttribute('src', this.closeImage);
\tthis.closeImg.setAttribute('title', 'Close');
\tthis.closeImg.style.marginLeft = '2px';
\tthis.closeImg.style.cursor = 'pointer';
\tthis.closeImg.style.display = 'none';
\t
\tthis.buttons.appendChild(this.closeImg);

\tmxEvent.addGestureListeners(this.closeImg,
\t\tmxUtils.bind(this, function(evt)
\t\t{
\t\t\tthis.fireEvent(new mxEventObject(mxEvent.CLOSE, 'event', evt));
\t\t\t
\t\t\tif (this.destroyOnClose)
\t\t\t{
\t\t\t\tthis.destroy();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.setVisible(false);
\t\t\t}
\t\t\t
\t\t\tmxEvent.consume(evt);
\t\t}));
};

/**
 * Function: setImage
 * 
 * Sets the image associated with the window.
 * 
 * Parameters:
 * 
 * image - URL of the image to be used.
 */
mxWindow.prototype.setImage = function(image)
{
\tthis.image = document.createElement('img');
\tthis.image.setAttribute('src', image);
\tthis.image.setAttribute('align', 'left');
\tthis.image.style.marginRight = '4px';
\tthis.image.style.marginLeft = '0px';
\tthis.image.style.marginTop = '-2px';
\t
\tthis.title.insertBefore(this.image, this.title.firstChild);
};

/**
 * Function: setClosable
 * 
 * Sets the image associated with the window.
 * 
 * Parameters:
 * 
 * closable - Boolean specifying if the window should be closable.
 */
mxWindow.prototype.setClosable = function(closable)
{
\tthis.closeImg.style.display = (closable) ? '' : 'none';
};

/**
 * Function: isVisible
 * 
 * Returns true if the window is visible.
 */
mxWindow.prototype.isVisible = function()
{
\tif (this.div != null)
\t{
\t\treturn this.div.style.display != 'none';
\t}
\t
\treturn false;
};

/**
 * Function: setVisible
 *
 * Shows or hides the window depending on the given flag.
 * 
 * Parameters:
 * 
 * visible - Boolean indicating if the window should be made visible.
 */
mxWindow.prototype.setVisible = function(visible)
{
\tif (this.div != null && this.isVisible() != visible)
\t{
\t\tif (visible)
\t\t{
\t\t\tthis.show();
\t\t}
\t\telse
\t\t{
\t\t\tthis.hide();
\t\t}
\t}
};

/**
 * Function: show
 *
 * Shows the window.
 */
mxWindow.prototype.show = function()
{
\tthis.div.style.display = '';
\tthis.activate();
\t
\tvar style = mxUtils.getCurrentStyle(this.contentWrapper);
\t
\tif (!mxClient.IS_QUIRKS && (style.overflow == 'auto' || this.resize != null) &&
\t\tthis.contentWrapper.style.display != 'none')
\t{
\t\tthis.contentWrapper.style.height = (this.div.offsetHeight -
\t\t\t\tthis.title.offsetHeight - this.contentHeightCorrection) + 'px';
\t}
\t
\tthis.fireEvent(new mxEventObject(mxEvent.SHOW));
};

/**
 * Function: hide
 *
 * Hides the window.
 */
mxWindow.prototype.hide = function()
{
\tthis.div.style.display = 'none';
\tthis.fireEvent(new mxEventObject(mxEvent.HIDE));
};

/**
 * Function: destroy
 *
 * Destroys the window and removes all associated resources. Fires a
 * <destroy> event prior to destroying the window.
 */
mxWindow.prototype.destroy = function()
{
\tthis.fireEvent(new mxEventObject(mxEvent.DESTROY));
\t
\tif (this.div != null)
\t{
\t\tmxEvent.release(this.div);
\t\tthis.div.parentNode.removeChild(this.div);
\t\tthis.div = null;
\t}
\t
\tthis.title = null;
\tthis.content = null;
\tthis.contentWrapper = null;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxForm
 * 
 * A simple class for creating HTML forms.
 * 
 * Constructor: mxForm
 * 
 * Creates a HTML table using the specified classname.
 */
function mxForm(className)
{
\tthis.table = document.createElement('table');
\tthis.table.className = className;
\tthis.body = document.createElement('tbody');
\t
\tthis.table.appendChild(this.body);
};

/**
 * Variable: table
 * 
 * Holds the DOM node that represents the table.
 */
mxForm.prototype.table = null;

/**
 * Variable: body
 * 
 * Holds the DOM node that represents the tbody (table body). New rows
 * can be added to this object using DOM API.
 */
mxForm.prototype.body = false;

/**
 * Function: getTable
 * 
 * Returns the table that contains this form.
 */
mxForm.prototype.getTable = function()
{
\treturn this.table;
};

/**
 * Function: addButtons
 * 
 * Helper method to add an OK and Cancel button using the respective
 * functions.
 */
mxForm.prototype.addButtons = function(okFunct, cancelFunct)
{
\tvar tr = document.createElement('tr');
\tvar td = document.createElement('td');
\ttr.appendChild(td);
\ttd = document.createElement('td');

\t// Adds the ok button
\tvar button = document.createElement('button');
\tmxUtils.write(button, mxResources.get('ok') || 'OK');
\ttd.appendChild(button);

\tmxEvent.addListener(button, 'click', function()
\t{
\t\tokFunct();
\t});
\t
\t// Adds the cancel button
\tbutton = document.createElement('button');
\tmxUtils.write(button, mxResources.get('cancel') || 'Cancel');
\ttd.appendChild(button);
\t
\tmxEvent.addListener(button, 'click', function()
\t{
\t\tcancelFunct();
\t});
\t
\ttr.appendChild(td);
\tthis.body.appendChild(tr);
};

/**
 * Function: addText
 * 
 * Adds an input for the given name, type and value and returns it.
 */
mxForm.prototype.addText = function(name, value, type)
{
\tvar input = document.createElement('input');
\t
\tinput.setAttribute('type', type || 'text');
\tinput.value = value;
\t
\treturn this.addField(name, input);
};

/**
 * Function: addCheckbox
 * 
 * Adds a checkbox for the given name and value and returns the textfield.
 */
mxForm.prototype.addCheckbox = function(name, value)
{
\tvar input = document.createElement('input');
\t
\tinput.setAttribute('type', 'checkbox');
\tthis.addField(name, input);

\t// IE can only change the checked value if the input is inside the DOM
\tif (value)
\t{
\t\tinput.checked = true;
\t}

\treturn input;
};

/**
 * Function: addTextarea
 * 
 * Adds a textarea for the given name and value and returns the textarea.
 */
mxForm.prototype.addTextarea = function(name, value, rows)
{
\tvar input = document.createElement('textarea');
\t
\tif (mxClient.IS_NS)
\t{
\t\trows--;
\t}
\t
\tinput.setAttribute('rows', rows || 2);
\tinput.value = value;
\t
\treturn this.addField(name, input);
};

/**
 * Function: addCombo
 * 
 * Adds a combo for the given name and returns the combo.
 */
mxForm.prototype.addCombo = function(name, isMultiSelect, size)
{
\tvar select = document.createElement('select');
\t
\tif (size != null)
\t{
\t\tselect.setAttribute('size', size);
\t}
\t
\tif (isMultiSelect)
\t{
\t\tselect.setAttribute('multiple', 'true');
\t}
\t
\treturn this.addField(name, select);
};

/**
 * Function: addOption
 * 
 * Adds an option for the given label to the specified combo.
 */
mxForm.prototype.addOption = function(combo, label, value, isSelected)
{
\tvar option = document.createElement('option');
\t
\tmxUtils.writeln(option, label);
\toption.setAttribute('value', value);
\t
\tif (isSelected)
\t{
\t\toption.setAttribute('selected', isSelected);
\t}
\t
\tcombo.appendChild(option);
};

/**
 * Function: addField
 * 
 * Adds a new row with the name and the input field in two columns and
 * returns the given input.
 */
mxForm.prototype.addField = function(name, input)
{
\tvar tr = document.createElement('tr');
\tvar td = document.createElement('td');
\tmxUtils.write(td, name);
\ttr.appendChild(td);
\t
\ttd = document.createElement('td');
\ttd.appendChild(input);
\ttr.appendChild(td);
\tthis.body.appendChild(tr);
\t
\treturn input;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxImage
 *
 * Encapsulates the URL, width and height of an image.
 * 
 * Constructor: mxImage
 * 
 * Constructs a new image.
 */
function mxImage(src, width, height)
{
\tthis.src = src;
\tthis.width = width;
\tthis.height = height;
};

/**
 * Variable: src
 *
 * String that specifies the URL of the image.
 */
mxImage.prototype.src = null;

/**
 * Variable: width
 *
 * Integer that specifies the width of the image.
 */
mxImage.prototype.width = null;

/**
 * Variable: height
 *
 * Integer that specifies the height of the image.
 */
mxImage.prototype.height = null;
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxDivResizer
 * 
 * Maintains the size of a div element in Internet Explorer. This is a
 * workaround for the right and bottom style being ignored in IE.
 * 
 * If you need a div to cover the scrollwidth and -height of a document,
 * then you can use this class as follows:
 * 
 * (code)
 * var resizer = new mxDivResizer(background);
 * resizer.getDocumentHeight = function()
 * {
 *   return document.body.scrollHeight;
 * }
 * resizer.getDocumentWidth = function()
 * {
 *   return document.body.scrollWidth;
 * }
 * resizer.resize();
 * (end)
 * 
 * Constructor: mxDivResizer
 * 
 * Constructs an object that maintains the size of a div
 * element when the window is being resized. This is only
 * required for Internet Explorer as it ignores the respective
 * stylesheet information for DIV elements.
 * 
 * Parameters:
 * 
 * div - Reference to the DOM node whose size should be maintained.
 * container - Optional Container that contains the div. Default is the
 * window.
 */
function mxDivResizer(div, container)
{
\tif (div.nodeName.toLowerCase() == 'div')
\t{
\t\tif (container == null)
\t\t{
\t\t\tcontainer = window;
\t\t}

\t\tthis.div = div;
\t\tvar style = mxUtils.getCurrentStyle(div);
\t\t
\t\tif (style != null)
\t\t{
\t\t\tthis.resizeWidth = style.width == 'auto';
\t\t\tthis.resizeHeight = style.height == 'auto';
\t\t}
\t\t
\t\tmxEvent.addListener(container, 'resize',
\t\t\tmxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tif (!this.handlingResize)
\t\t\t\t{
\t\t\t\t\tthis.handlingResize = true;
\t\t\t\t\tthis.resize();
\t\t\t\t\tthis.handlingResize = false;
\t\t\t\t}
\t\t\t})
\t\t);
\t\t
\t\tthis.resize();
\t}
};

/**
 * Function: resizeWidth
 * 
 * Boolean specifying if the width should be updated.
 */
mxDivResizer.prototype.resizeWidth = true;

/**
 * Function: resizeHeight
 * 
 * Boolean specifying if the height should be updated.
 */
mxDivResizer.prototype.resizeHeight = true;

/**
 * Function: handlingResize
 * 
 * Boolean specifying if the width should be updated.
 */
mxDivResizer.prototype.handlingResize = false;

/**
 * Function: resize
 * 
 * Updates the style of the DIV after the window has been resized.
 */
mxDivResizer.prototype.resize = function()
{
\tvar w = this.getDocumentWidth();
\tvar h = this.getDocumentHeight();

\tvar l = parseInt(this.div.style.left);
\tvar r = parseInt(this.div.style.right);
\tvar t = parseInt(this.div.style.top);
\tvar b = parseInt(this.div.style.bottom);
\t
\tif (this.resizeWidth &&
\t\t!isNaN(l) &&
\t\t!isNaN(r) &&
\t\tl >= 0 &&
\t\tr >= 0 &&
\t\tw - r - l > 0)
\t{
\t\tthis.div.style.width = (w - r - l)+'px';
\t}
\t
\tif (this.resizeHeight &&
\t\t!isNaN(t) &&
\t\t!isNaN(b) &&
\t\tt >= 0 &&
\t\tb >= 0 &&
\t\th - t - b > 0)
\t{
\t\tthis.div.style.height = (h - t - b)+'px';
\t}
};

/**
 * Function: getDocumentWidth
 * 
 * Hook for subclassers to return the width of the document (without
 * scrollbars).
 */
mxDivResizer.prototype.getDocumentWidth = function()
{
\treturn document.body.clientWidth;
};

/**
 * Function: getDocumentHeight
 * 
 * Hook for subclassers to return the height of the document (without
 * scrollbars).
 */
mxDivResizer.prototype.getDocumentHeight = function()
{
\treturn document.body.clientHeight;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxDragSource
 * 
 * Wrapper to create a drag source from a DOM element so that the element can
 * be dragged over a graph and dropped into the graph as a new cell.
 * 
 * Problem is that in the dropHandler the current preview location is not
 * available, so the preview and the dropHandler must match.
 * 
 * Constructor: mxDragSource
 * 
 * Constructs a new drag source for the given element.
 */
function mxDragSource(element, dropHandler)
{
\tthis.element = element;
\tthis.dropHandler = dropHandler;
\t
\t// Handles a drag gesture on the element
\tmxEvent.addGestureListeners(element, mxUtils.bind(this, function(evt)
\t{
\t\tthis.mouseDown(evt);
\t}));
\t
\t// Prevents native drag and drop
\tmxEvent.addListener(element, 'dragstart', function(evt)
\t{
\t\tmxEvent.consume(evt);
\t});
\t
\tthis.eventConsumer = function(sender, evt)
\t{
\t\tvar evtName = evt.getProperty('eventName');
\t\tvar me = evt.getProperty('event');
\t\t
\t\tif (evtName != mxEvent.MOUSE_DOWN)
\t\t{
\t\t\tme.consume();
\t\t}
\t};
};

/**
 * Variable: element
 *
 * Reference to the DOM node which was made draggable.
 */
mxDragSource.prototype.element = null;

/**
 * Variable: dropHandler
 *
 * Holds the DOM node that is used to represent the drag preview. If this is
 * null then the source element will be cloned and used for the drag preview.
 */
mxDragSource.prototype.dropHandler = null;

/**
 * Variable: dragOffset
 *
 * <mxPoint> that specifies the offset of the <dragElement>. Default is null.
 */
mxDragSource.prototype.dragOffset = null;

/**
 * Variable: dragElement
 *
 * Holds the DOM node that is used to represent the drag preview. If this is
 * null then the source element will be cloned and used for the drag preview.
 */
mxDragSource.prototype.dragElement = null;

/**
 * Variable: previewElement
 *
 * Optional <mxRectangle> that specifies the unscaled size of the preview.
 */
mxDragSource.prototype.previewElement = null;

/**
 * Variable: previewOffset
 *
 * Optional <mxPoint> that specifies the offset of the preview in pixels.
 */
mxDragSource.prototype.previewOffset = null;

/**
 * Variable: enabled
 *
 * Specifies if this drag source is enabled. Default is true.
 */
mxDragSource.prototype.enabled = true;

/**
 * Variable: currentGraph
 *
 * Reference to the <mxGraph> that is the current drop target.
 */
mxDragSource.prototype.currentGraph = null;

/**
 * Variable: currentDropTarget
 *
 * Holds the current drop target under the mouse.
 */
mxDragSource.prototype.currentDropTarget = null;

/**
 * Variable: currentPoint
 *
 * Holds the current drop location.
 */
mxDragSource.prototype.currentPoint = null;

/**
 * Variable: currentGuide
 *
 * Holds an <mxGuide> for the <currentGraph> if <dragPreview> is not null.
 */
mxDragSource.prototype.currentGuide = null;

/**
 * Variable: currentGuide
 *
 * Holds an <mxGuide> for the <currentGraph> if <dragPreview> is not null.
 */
mxDragSource.prototype.currentHighlight = null;

/**
 * Variable: autoscroll
 *
 * Specifies if the graph should scroll automatically. Default is true.
 */
mxDragSource.prototype.autoscroll = true;

/**
 * Variable: guidesEnabled
 *
 * Specifies if <mxGuide> should be enabled. Default is true.
 */
mxDragSource.prototype.guidesEnabled = true;

/**
 * Variable: gridEnabled
 *
 * Specifies if the grid should be allowed. Default is true.
 */
mxDragSource.prototype.gridEnabled = true;

/**
 * Variable: highlightDropTargets
 *
 * Specifies if drop targets should be highlighted. Default is true.
 */
mxDragSource.prototype.highlightDropTargets = true;

/**
 * Variable: dragElementZIndex
 * 
 * ZIndex for the drag element. Default is 100.
 */
mxDragSource.prototype.dragElementZIndex = 100;

/**
 * Variable: dragElementOpacity
 * 
 * Opacity of the drag element in %. Default is 70.
 */
mxDragSource.prototype.dragElementOpacity = 70;

/**
 * Variable: checkEventSource
 * 
 * Whether the event source should be checked in <graphContainerEvent>. Default
 * is true.
 */
mxDragSource.prototype.checkEventSource = true;

/**
 * Function: isEnabled
 * 
 * Returns <enabled>.
 */
mxDragSource.prototype.isEnabled = function()
{
\treturn this.enabled;
};

/**
 * Function: setEnabled
 * 
 * Sets <enabled>.
 */
mxDragSource.prototype.setEnabled = function(value)
{
\tthis.enabled = value;
};

/**
 * Function: isGuidesEnabled
 * 
 * Returns <guidesEnabled>.
 */
mxDragSource.prototype.isGuidesEnabled = function()
{
\treturn this.guidesEnabled;
};

/**
 * Function: setGuidesEnabled
 * 
 * Sets <guidesEnabled>.
 */
mxDragSource.prototype.setGuidesEnabled = function(value)
{
\tthis.guidesEnabled = value;
};

/**
 * Function: isGridEnabled
 * 
 * Returns <gridEnabled>.
 */
mxDragSource.prototype.isGridEnabled = function()
{
\treturn this.gridEnabled;
};

/**
 * Function: setGridEnabled
 * 
 * Sets <gridEnabled>.
 */
mxDragSource.prototype.setGridEnabled = function(value)
{
\tthis.gridEnabled = value;
};

/**
 * Function: getGraphForEvent
 * 
 * Returns the graph for the given mouse event. This implementation returns
 * null.
 */
mxDragSource.prototype.getGraphForEvent = function(evt)
{
\treturn null;
};

/**
 * Function: getDropTarget
 * 
 * Returns the drop target for the given graph and coordinates. This
 * implementation uses <mxGraph.getCellAt>.
 */
mxDragSource.prototype.getDropTarget = function(graph, x, y, evt)
{
\treturn graph.getCellAt(x, y);
};

/**
 * Function: createDragElement
 * 
 * Creates and returns a clone of the <dragElementPrototype> or the <element>
 * if the former is not defined.
 */
mxDragSource.prototype.createDragElement = function(evt)
{
\treturn this.element.cloneNode(true);
};

/**
 * Function: createPreviewElement
 * 
 * Creates and returns an element which can be used as a preview in the given
 * graph.
 */
mxDragSource.prototype.createPreviewElement = function(graph)
{
\treturn null;
};

/**
 * Function: isActive
 * 
 * Returns true if this drag source is active.
 */
mxDragSource.prototype.isActive = function()
{
\treturn this.mouseMoveHandler != null;
};

/**
 * Function: reset
 * 
 * Stops and removes everything and restores the state of the object.
 */
mxDragSource.prototype.reset = function()
{
\tif (this.currentGraph != null)
\t{
\t\tthis.dragExit(this.currentGraph);
\t\tthis.currentGraph = null;
\t}
\t
\tthis.removeDragElement();
\tthis.removeListeners();
\tthis.stopDrag();
};

/**
 * Function: mouseDown
 * 
 * Returns the drop target for the given graph and coordinates. This
 * implementation uses <mxGraph.getCellAt>.
 * 
 * To ignore popup menu events for a drag source, this function can be
 * overridden as follows.
 * 
 * (code)
 * var mouseDown = dragSource.mouseDown;
 * 
 * dragSource.mouseDown = function(evt)
 * {
 *   if (!mxEvent.isPopupTrigger(evt))
 *   {
 *     mouseDown.apply(this, arguments);
 *   }
 * };
 * (end)
 */
mxDragSource.prototype.mouseDown = function(evt)
{
\tif (this.enabled && !mxEvent.isConsumed(evt) && this.mouseMoveHandler == null)
\t{
\t\tthis.startDrag(evt);
\t\tthis.mouseMoveHandler = mxUtils.bind(this, this.mouseMove);
\t\tthis.mouseUpHandler = mxUtils.bind(this, this.mouseUp);\t\t
\t\tmxEvent.addGestureListeners(document, null, this.mouseMoveHandler, this.mouseUpHandler);
\t\t
\t\tif (mxClient.IS_TOUCH && !mxEvent.isMouseEvent(evt))
\t\t{
\t\t\tthis.eventSource = mxEvent.getSource(evt);
\t\t\tmxEvent.addGestureListeners(this.eventSource, null, this.mouseMoveHandler, this.mouseUpHandler);
\t\t}
\t}
};

/**
 * Function: startDrag
 * 
 * Creates the <dragElement> using <createDragElement>.
 */
mxDragSource.prototype.startDrag = function(evt)
{
\tthis.dragElement = this.createDragElement(evt);
\tthis.dragElement.style.position = 'absolute';
\tthis.dragElement.style.zIndex = this.dragElementZIndex;
\tmxUtils.setOpacity(this.dragElement, this.dragElementOpacity);

\tif (this.checkEventSource && mxClient.IS_SVG)
\t{
\t\tthis.dragElement.style.pointerEvents = 'none';
\t}
};

/**
 * Function: stopDrag
 * 
 * Invokes <removeDragElement>.
 */
mxDragSource.prototype.stopDrag = function()
{
\t// LATER: This used to have a mouse event. If that is still needed we need to add another
\t// final call to the DnD protocol to add a cleanup step in the case of escape press, which
\t// is not associated with a mouse event and which currently calles this method.
\tthis.removeDragElement();
};

/**
 * Function: removeDragElement
 * 
 * Removes and destroys the <dragElement>.
 */
mxDragSource.prototype.removeDragElement = function()
{
\tif (this.dragElement != null)
\t{
\t\tif (this.dragElement.parentNode != null)
\t\t{
\t\t\tthis.dragElement.parentNode.removeChild(this.dragElement);
\t\t}
\t\t
\t\tthis.dragElement = null;
\t}
};

/**
 * Function: getElementForEvent
 * 
 * Returns the topmost element under the given event.
 */
mxDragSource.prototype.getElementForEvent = function(evt)
{
\treturn ((mxEvent.isTouchEvent(evt) || mxEvent.isPenEvent(evt)) ?
\t\t\tdocument.elementFromPoint(mxEvent.getClientX(evt), mxEvent.getClientY(evt)) :
\t\t\t\tmxEvent.getSource(evt));
};

/**
 * Function: graphContainsEvent
 * 
 * Returns true if the given graph contains the given event.
 */
mxDragSource.prototype.graphContainsEvent = function(graph, evt)
{
\tvar x = mxEvent.getClientX(evt);
\tvar y = mxEvent.getClientY(evt);
\tvar offset = mxUtils.getOffset(graph.container);
\tvar origin = mxUtils.getScrollOrigin();
\tvar elt = this.getElementForEvent(evt);
\t
\tif (this.checkEventSource)
\t{
\t\twhile (elt != null && elt != graph.container)
\t\t{
\t\t\telt = elt.parentNode;
\t\t}
\t}

\t// Checks if event is inside the bounds of the graph container
\treturn elt != null && x >= offset.x - origin.x && y >= offset.y - origin.y &&
\t\tx <= offset.x - origin.x + graph.container.offsetWidth &&
\t\ty <= offset.y - origin.y + graph.container.offsetHeight;
};

/**
 * Function: mouseMove
 * 
 * Gets the graph for the given event using <getGraphForEvent>, updates the
 * <currentGraph>, calling <dragEnter> and <dragExit> on the new and old graph,
 * respectively, and invokes <dragOver> if <currentGraph> is not null.
 */
mxDragSource.prototype.mouseMove = function(evt)
{
\tvar graph = this.getGraphForEvent(evt);
\t
\t// Checks if event is inside the bounds of the graph container
\tif (graph != null && !this.graphContainsEvent(graph, evt))
\t{
\t\tgraph = null;
\t}

\tif (graph != this.currentGraph)
\t{
\t\tif (this.currentGraph != null)
\t\t{
\t\t\tthis.dragExit(this.currentGraph, evt);
\t\t}
\t\t
\t\tthis.currentGraph = graph;
\t\t
\t\tif (this.currentGraph != null)
\t\t{
\t\t\tthis.dragEnter(this.currentGraph, evt);
\t\t}
\t}
\t
\tif (this.currentGraph != null)
\t{
\t\tthis.dragOver(this.currentGraph, evt);
\t}

\tif (this.dragElement != null && (this.previewElement == null || this.previewElement.style.visibility != 'visible'))
\t{
\t\tvar x = mxEvent.getClientX(evt);
\t\tvar y = mxEvent.getClientY(evt);
\t\t
\t\tif (this.dragElement.parentNode == null)
\t\t{
\t\t\tdocument.body.appendChild(this.dragElement);
\t\t}

\t\tthis.dragElement.style.visibility = 'visible';
\t\t
\t\tif (this.dragOffset != null)
\t\t{
\t\t\tx += this.dragOffset.x;
\t\t\ty += this.dragOffset.y;
\t\t}
\t\t
\t\tvar offset = mxUtils.getDocumentScrollOrigin(document);
\t\t
\t\tthis.dragElement.style.left = (x + offset.x) + 'px';
\t\tthis.dragElement.style.top = (y + offset.y) + 'px';
\t}
\telse if (this.dragElement != null)
\t{
\t\tthis.dragElement.style.visibility = 'hidden';
\t}
\t
\tmxEvent.consume(evt);
};

/**
 * Function: mouseUp
 * 
 * Processes the mouse up event and invokes <drop>, <dragExit> and <stopDrag>
 * as required.
 */
mxDragSource.prototype.mouseUp = function(evt)
{
\tif (this.currentGraph != null)
\t{
\t\tif (this.currentPoint != null && (this.previewElement == null ||
\t\t\tthis.previewElement.style.visibility != 'hidden'))
\t\t{
\t\t\tvar scale = this.currentGraph.view.scale;
\t\t\tvar tr = this.currentGraph.view.translate;
\t\t\tvar x = this.currentPoint.x / scale - tr.x;
\t\t\tvar y = this.currentPoint.y / scale - tr.y;
\t\t\t
\t\t\tthis.drop(this.currentGraph, evt, this.currentDropTarget, x, y);
\t\t}
\t\t
\t\tthis.dragExit(this.currentGraph);
\t\tthis.currentGraph = null;
\t}

\tthis.stopDrag();
\tthis.removeListeners();
\t
\tmxEvent.consume(evt);
};

/**
 * Function: removeListeners
 * 
 * Actives the given graph as a drop target.
 */
mxDragSource.prototype.removeListeners = function()
{
\tif (this.eventSource != null)
\t{
\t\tmxEvent.removeGestureListeners(this.eventSource, null, this.mouseMoveHandler, this.mouseUpHandler);
\t\tthis.eventSource = null;
\t}
\t
\tmxEvent.removeGestureListeners(document, null, this.mouseMoveHandler, this.mouseUpHandler);
\tthis.mouseMoveHandler = null;
\tthis.mouseUpHandler = null;
};

/**
 * Function: dragEnter
 * 
 * Actives the given graph as a drop target.
 */
mxDragSource.prototype.dragEnter = function(graph, evt)
{
\tgraph.isMouseDown = true;
\tgraph.isMouseTrigger = mxEvent.isMouseEvent(evt);
\tthis.previewElement = this.createPreviewElement(graph);
\t
\tif (this.previewElement != null && this.checkEventSource && mxClient.IS_SVG)
\t{
\t\tthis.previewElement.style.pointerEvents = 'none';
\t}
\t
\t// Guide is only needed if preview element is used
\tif (this.isGuidesEnabled() && this.previewElement != null)
\t{
\t\tthis.currentGuide = new mxGuide(graph, graph.graphHandler.getGuideStates());
\t}
\t
\tif (this.highlightDropTargets)
\t{
\t\tthis.currentHighlight = new mxCellHighlight(graph, mxConstants.DROP_TARGET_COLOR);
\t}
\t
\t// Consumes all events in the current graph before they are fired
\tgraph.addListener(mxEvent.FIRE_MOUSE_EVENT, this.eventConsumer);
};

/**
 * Function: dragExit
 * 
 * Deactivates the given graph as a drop target.
 */
mxDragSource.prototype.dragExit = function(graph, evt)
{
\tthis.currentDropTarget = null;
\tthis.currentPoint = null;
\tgraph.isMouseDown = false;
\t
\t// Consumes all events in the current graph before they are fired
\tgraph.removeListener(this.eventConsumer);
\t
\tif (this.previewElement != null)
\t{
\t\tif (this.previewElement.parentNode != null)
\t\t{
\t\t\tthis.previewElement.parentNode.removeChild(this.previewElement);
\t\t}
\t\t
\t\tthis.previewElement = null;
\t}
\t
\tif (this.currentGuide != null)
\t{
\t\tthis.currentGuide.destroy();
\t\tthis.currentGuide = null;
\t}
\t
\tif (this.currentHighlight != null)
\t{
\t\tthis.currentHighlight.destroy();
\t\tthis.currentHighlight = null;
\t}
};

/**
 * Function: dragOver
 * 
 * Implements autoscroll, updates the <currentPoint>, highlights any drop
 * targets and updates the preview.
 */
mxDragSource.prototype.dragOver = function(graph, evt)
{
\tvar offset = mxUtils.getOffset(graph.container);
\tvar origin = mxUtils.getScrollOrigin(graph.container);
\tvar x = mxEvent.getClientX(evt) - offset.x + origin.x - graph.panDx;
\tvar y = mxEvent.getClientY(evt) - offset.y + origin.y - graph.panDy;

\tif (graph.autoScroll && (this.autoscroll == null || this.autoscroll))
\t{
\t\tgraph.scrollPointToVisible(x, y, graph.autoExtend);
\t}

\t// Highlights the drop target under the mouse
\tif (this.currentHighlight != null && graph.isDropEnabled())
\t{
\t\tthis.currentDropTarget = this.getDropTarget(graph, x, y, evt);
\t\tvar state = graph.getView().getState(this.currentDropTarget);
\t\tthis.currentHighlight.highlight(state);
\t}

\t// Updates the location of the preview
\tif (this.previewElement != null)
\t{
\t\tif (this.previewElement.parentNode == null)
\t\t{
\t\t\tgraph.container.appendChild(this.previewElement);
\t\t\t
\t\t\tthis.previewElement.style.zIndex = '3';
\t\t\tthis.previewElement.style.position = 'absolute';
\t\t}
\t\t
\t\tvar gridEnabled = this.isGridEnabled() && graph.isGridEnabledEvent(evt);
\t\tvar hideGuide = true;

\t\t// Grid and guides
\t\tif (this.currentGuide != null && this.currentGuide.isEnabledForEvent(evt))
\t\t{
\t\t\t// LATER: HTML preview appears smaller than SVG preview
\t\t\tvar w = parseInt(this.previewElement.style.width);
\t\t\tvar h = parseInt(this.previewElement.style.height);
\t\t\tvar bounds = new mxRectangle(0, 0, w, h);
\t\t\tvar delta = new mxPoint(x, y);
\t\t\tdelta = this.currentGuide.move(bounds, delta, gridEnabled, true);
\t\t\thideGuide = false;
\t\t\tx = delta.x;
\t\t\ty = delta.y;
\t\t}
\t\telse if (gridEnabled)
\t\t{
\t\t\tvar scale = graph.view.scale;
\t\t\tvar tr = graph.view.translate;
\t\t\tvar off = graph.gridSize / 2;
\t\t\tx = (graph.snap(x / scale - tr.x - off) + tr.x) * scale;
\t\t\ty = (graph.snap(y / scale - tr.y - off) + tr.y) * scale;
\t\t}
\t\t
\t\tif (this.currentGuide != null && hideGuide)
\t\t{
\t\t\tthis.currentGuide.hide();
\t\t}
\t\t
\t\tif (this.previewOffset != null)
\t\t{
\t\t\tx += this.previewOffset.x;
\t\t\ty += this.previewOffset.y;
\t\t}

\t\tthis.previewElement.style.left = Math.round(x) + 'px';
\t\tthis.previewElement.style.top = Math.round(y) + 'px';
\t\tthis.previewElement.style.visibility = 'visible';
\t}
\t
\tthis.currentPoint = new mxPoint(x, y);
};

/**
 * Function: drop
 * 
 * Returns the drop target for the given graph and coordinates. This
 * implementation uses <mxGraph.getCellAt>.
 */
mxDragSource.prototype.drop = function(graph, evt, dropTarget, x, y)
{
\tthis.dropHandler.apply(this, arguments);
\t
\t// Had to move this to after the insert because it will
\t// affect the scrollbars of the window in IE to try and
\t// make the complete container visible.
\t// LATER: Should be made optional.
\tif (graph.container.style.visibility != 'hidden')
\t{
\t\tgraph.container.focus();
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxToolbar
 * 
 * Creates a toolbar inside a given DOM node. The toolbar may contain icons,
 * buttons and combo boxes.
 * 
 * Event: mxEvent.SELECT
 * 
 * Fires when an item was selected in the toolbar. The <code>function</code>
 * property contains the function that was selected in <selectMode>.
 * 
 * Constructor: mxToolbar
 * 
 * Constructs a toolbar in the specified container.
 *
 * Parameters:
 *
 * container - DOM node that contains the toolbar.
 */
function mxToolbar(container)
{
\tthis.container = container;
};

/**
 * Extends mxEventSource.
 */
mxToolbar.prototype = new mxEventSource();
mxToolbar.prototype.constructor = mxToolbar;

/**
 * Variable: container
 * 
 * Reference to the DOM nodes that contains the toolbar.
 */
mxToolbar.prototype.container = null;

/**
 * Variable: enabled
 * 
 * Specifies if events are handled. Default is true.
 */
mxToolbar.prototype.enabled = true;

/**
 * Variable: noReset
 * 
 * Specifies if <resetMode> requires a forced flag of true for resetting
 * the current mode in the toolbar. Default is false. This is set to true
 * if the toolbar item is double clicked to avoid a reset after a single
 * use of the item.
 */
mxToolbar.prototype.noReset = false;

/**
 * Variable: updateDefaultMode
 * 
 * Boolean indicating if the default mode should be the last selected
 * switch mode or the first inserted switch mode. Default is true, that
 * is the last selected switch mode is the default mode. The default mode
 * is the mode to be selected after a reset of the toolbar. If this is
 * false, then the default mode is the first inserted mode item regardless
 * of what was last selected. Otherwise, the selected item after a reset is
 * the previously selected item.
 */
mxToolbar.prototype.updateDefaultMode = true;

/**
 * Function: addItem
 * 
 * Adds the given function as an image with the specified title and icon
 * and returns the new image node.
 * 
 * Parameters:
 * 
 * title - Optional string that is used as the tooltip.
 * icon - Optional URL of the image to be used. If no URL is given, then a
 * button is created.
 * funct - Function to execute on a mouse click.
 * pressedIcon - Optional URL of the pressed image. Default is a gray
 * background.
 * style - Optional style classname. Default is mxToolbarItem.
 * factoryMethod - Optional factory method for popup menu, eg.
 * function(menu, evt, cell) { menu.addItem('Hello, World!'); }
 */
mxToolbar.prototype.addItem = function(title, icon, funct, pressedIcon, style, factoryMethod)
{
\tvar img = document.createElement((icon != null) ? 'img' : 'button');
\tvar initialClassName = style || ((factoryMethod != null) ?
\t\t\t'mxToolbarMode' : 'mxToolbarItem');
\timg.className = initialClassName;
\timg.setAttribute('src', icon);
\t
\tif (title != null)
\t{
\t\tif (icon != null)
\t\t{
\t\t\timg.setAttribute('title', title);
\t\t}
\t\telse
\t\t{
\t\t\tmxUtils.write(img, title);
\t\t}
\t}
\t
\tthis.container.appendChild(img);

\t// Invokes the function on a click on the toolbar item
\tif (funct != null)
\t{
\t\tmxEvent.addListener(img, 'click', funct);
\t\t
\t\tif (mxClient.IS_TOUCH)
\t\t{
\t\t\tmxEvent.addListener(img, 'touchend', funct);
\t\t}
\t}

\tvar mouseHandler = mxUtils.bind(this, function(evt)
\t{
\t\tif (pressedIcon != null)
\t\t{
\t\t\timg.setAttribute('src', icon);
\t\t}
\t\telse
\t\t{
\t\t\timg.style.backgroundColor = '';
\t\t}
\t});

\t// Highlights the toolbar item with a gray background
\t// while it is being clicked with the mouse
\tmxEvent.addGestureListeners(img, mxUtils.bind(this, function(evt)
\t{
\t\tif (pressedIcon != null)
\t\t{
\t\t\timg.setAttribute('src', pressedIcon);
\t\t}
\t\telse
\t\t{
\t\t\timg.style.backgroundColor = 'gray';
\t\t}
\t\t
\t\t// Popup Menu
\t\tif (factoryMethod != null)
\t\t{
\t\t\tif (this.menu == null)
\t\t\t{
\t\t\t\tthis.menu = new mxPopupMenu();
\t\t\t\tthis.menu.init();
\t\t\t}
\t\t\t
\t\t\tvar last = this.currentImg;
\t\t\t
\t\t\tif (this.menu.isMenuShowing())
\t\t\t{
\t\t\t\tthis.menu.hideMenu();
\t\t\t}
\t\t\t
\t\t\tif (last != img)
\t\t\t{
\t\t\t\t// Redirects factory method to local factory method
\t\t\t\tthis.currentImg = img;
\t\t\t\tthis.menu.factoryMethod = factoryMethod;
\t\t\t\t
\t\t\t\tvar point = new mxPoint(
\t\t\t\t\timg.offsetLeft,
\t\t\t\t\timg.offsetTop + img.offsetHeight);
\t\t\t\tthis.menu.popup(point.x, point.y, null, evt);

\t\t\t\t// Sets and overrides to restore classname
\t\t\t\tif (this.menu.isMenuShowing())
\t\t\t\t{
\t\t\t\t\timg.className = initialClassName + 'Selected';
\t\t\t\t\t
\t\t\t\t\tthis.menu.hideMenu = function()
\t\t\t\t\t{
\t\t\t\t\t\tmxPopupMenu.prototype.hideMenu.apply(this);
\t\t\t\t\t\timg.className = initialClassName;
\t\t\t\t\t\tthis.currentImg = null;
\t\t\t\t\t};
\t\t\t\t}
\t\t\t}
\t\t}
\t}), null, mouseHandler);

\tmxEvent.addListener(img, 'mouseout', mouseHandler);
\t
\treturn img;
};

/**
 * Function: addCombo
 * 
 * Adds and returns a new SELECT element using the given style. The element
 * is placed inside a DIV with the mxToolbarComboContainer style classname.
 * 
 * Parameters:
 * 
 * style - Optional style classname. Default is mxToolbarCombo.
 */
mxToolbar.prototype.addCombo = function(style)
{
\tvar div = document.createElement('div');
\tdiv.style.display = 'inline';
\tdiv.className = 'mxToolbarComboContainer';
\t
\tvar select = document.createElement('select');
\tselect.className = style || 'mxToolbarCombo';
\tdiv.appendChild(select);
\t
\tthis.container.appendChild(div);
\t
\treturn select;
};

/**
 * Function: addActionCombo
 * 
 * Adds and returns a new SELECT element using the given title as the
 * default element. The selection is reset to this element after each
 * change.
 * 
 * Parameters:
 * 
 * title - String that specifies the title of the default element.
 * style - Optional style classname. Default is mxToolbarCombo.
 */
mxToolbar.prototype.addActionCombo = function(title, style)
{
\tvar select = document.createElement('select');
\tselect.className = style || 'mxToolbarCombo';
\tthis.addOption(select, title, null);
\t
\tmxEvent.addListener(select, 'change', function(evt)
\t{
\t\tvar value = select.options[select.selectedIndex];
\t\tselect.selectedIndex = 0;
\t\t
\t\tif (value.funct != null)
\t\t{
\t\t\tvalue.funct(evt);
\t\t}
\t});
\t
\tthis.container.appendChild(select);
\t
\treturn select;
};

/**
 * Function: addOption
 * 
 * Adds and returns a new OPTION element inside the given SELECT element.
 * If the given value is a function then it is stored in the option's funct
 * field.
 * 
 * Parameters:
 * 
 * combo - SELECT element that will contain the new entry.
 * title - String that specifies the title of the option.
 * value - Specifies the value associated with this option.
 */
mxToolbar.prototype.addOption = function(combo, title, value)
{
\tvar option = document.createElement('option');
\tmxUtils.writeln(option, title);
\t
\tif (typeof(value) == 'function')
\t{
\t\toption.funct = value;
\t}
\telse
\t{
\t\toption.setAttribute('value', value);
\t}
\t
\tcombo.appendChild(option);
\t
\treturn option;
};

/**
 * Function: addSwitchMode
 * 
 * Adds a new selectable item to the toolbar. Only one switch mode item may
 * be selected at a time. The currently selected item is the default item
 * after a reset of the toolbar.
 */
mxToolbar.prototype.addSwitchMode = function(title, icon, funct, pressedIcon, style)
{
\tvar img = document.createElement('img');
\timg.initialClassName = style || 'mxToolbarMode';
\timg.className = img.initialClassName;
\timg.setAttribute('src', icon);
\timg.altIcon = pressedIcon;
\t
\tif (title != null)
\t{
\t\timg.setAttribute('title', title);
\t}
\t
\tmxEvent.addListener(img, 'click', mxUtils.bind(this, function(evt)
\t{
\t\tvar tmp = this.selectedMode.altIcon;
\t\t
\t\tif (tmp != null)
\t\t{
\t\t\tthis.selectedMode.altIcon = this.selectedMode.getAttribute('src');
\t\t\tthis.selectedMode.setAttribute('src', tmp);
\t\t}
\t\telse
\t\t{
\t\t\tthis.selectedMode.className = this.selectedMode.initialClassName;
\t\t}
\t\t
\t\tif (this.updateDefaultMode)
\t\t{
\t\t\tthis.defaultMode = img;
\t\t}
\t\t
\t\tthis.selectedMode = img;
\t\t
\t\tvar tmp = img.altIcon;
\t\t
\t\tif (tmp != null)
\t\t{
\t\t\timg.altIcon = img.getAttribute('src');
\t\t\timg.setAttribute('src', tmp);
\t\t}
\t\telse
\t\t{
\t\t\timg.className = img.initialClassName+'Selected';
\t\t}
\t\t
\t\tthis.fireEvent(new mxEventObject(mxEvent.SELECT));
\t\tfunct();
\t}));
\t
\tthis.container.appendChild(img);
\t
\tif (this.defaultMode == null)
\t{
\t\tthis.defaultMode = img;
\t\t
\t\t// Function should fire only once so
\t\t// do not pass it with the select event
\t\tthis.selectMode(img);
\t\tfunct();
\t}
\t
\treturn img;
};

/**
 * Function: addMode
 * 
 * Adds a new item to the toolbar. The selection is typically reset after
 * the item has been consumed, for example by adding a new vertex to the
 * graph. The reset is not carried out if the item is double clicked.
 * 
 * The function argument uses the following signature: funct(evt, cell) where
 * evt is the native mouse event and cell is the cell under the mouse.
 */
mxToolbar.prototype.addMode = function(title, icon, funct, pressedIcon, style, toggle)
{
\ttoggle = (toggle != null) ? toggle : true;
\tvar img = document.createElement((icon != null) ? 'img' : 'button');
\t
\timg.initialClassName = style || 'mxToolbarMode';
\timg.className = img.initialClassName;
\timg.setAttribute('src', icon);
\timg.altIcon = pressedIcon;

\tif (title != null)
\t{
\t\timg.setAttribute('title', title);
\t}
\t
\tif (this.enabled && toggle)
\t{
\t\tmxEvent.addListener(img, 'click', mxUtils.bind(this, function(evt)
\t\t{
\t\t\tthis.selectMode(img, funct);
\t\t\tthis.noReset = false;
\t\t}));
\t\t
\t\tmxEvent.addListener(img, 'dblclick', mxUtils.bind(this, function(evt)
\t\t{
\t\t\tthis.selectMode(img, funct);
\t\t\tthis.noReset = true;
\t\t}));
\t\t
\t\tif (this.defaultMode == null)
\t\t{
\t\t\tthis.defaultMode = img;
\t\t\tthis.defaultFunction = funct;
\t\t\tthis.selectMode(img, funct);
\t\t}
\t}

\tthis.container.appendChild(img);\t\t\t\t\t

\treturn img;
};

/**
 * Function: selectMode
 * 
 * Resets the state of the previously selected mode and displays the given
 * DOM node as selected. This function fires a select event with the given
 * function as a parameter.
 */
mxToolbar.prototype.selectMode = function(domNode, funct)
{
\tif (this.selectedMode != domNode)
\t{
\t\tif (this.selectedMode != null)
\t\t{
\t\t\tvar tmp = this.selectedMode.altIcon;
\t\t\t
\t\t\tif (tmp != null)
\t\t\t{
\t\t\t\tthis.selectedMode.altIcon = this.selectedMode.getAttribute('src');
\t\t\t\tthis.selectedMode.setAttribute('src', tmp);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.selectedMode.className = this.selectedMode.initialClassName;
\t\t\t}
\t\t}
\t\t
\t\tthis.selectedMode = domNode;
\t\tvar tmp = this.selectedMode.altIcon;
\t\t
\t\tif (tmp != null)
\t\t{
\t\t\tthis.selectedMode.altIcon = this.selectedMode.getAttribute('src');
\t\t\tthis.selectedMode.setAttribute('src', tmp);
\t\t}
\t\telse
\t\t{
\t\t\tthis.selectedMode.className = this.selectedMode.initialClassName+'Selected';
\t\t}
\t\t
\t\tthis.fireEvent(new mxEventObject(mxEvent.SELECT, \"function\", funct));
\t}
};

/**
 * Function: resetMode
 * 
 * Selects the default mode and resets the state of the previously selected
 * mode.
 */
mxToolbar.prototype.resetMode = function(forced)
{
\tif ((forced || !this.noReset) && this.selectedMode != this.defaultMode)
\t{
\t\t// The last selected switch mode will be activated
\t\t// so the function was already executed and is
\t\t// no longer required here
\t\tthis.selectMode(this.defaultMode, this.defaultFunction);
\t}
};

/**
 * Function: addSeparator
 * 
 * Adds the specifies image as a separator.
 * 
 * Parameters:
 * 
 * icon - URL of the separator icon.
 */
mxToolbar.prototype.addSeparator = function(icon)
{
\treturn this.addItem(null, icon, null);
};

/**
 * Function: addBreak
 * 
 * Adds a break to the container.
 */
mxToolbar.prototype.addBreak = function()
{
\tmxUtils.br(this.container);
};

/**
 * Function: addLine
 * 
 * Adds a horizontal line to the container.
 */
mxToolbar.prototype.addLine = function()
{
\tvar hr = document.createElement('hr');
\t
\thr.style.marginRight = '6px';
\thr.setAttribute('size', '1');
\t
\tthis.container.appendChild(hr);
};

/**
 * Function: destroy
 * 
 * Removes the toolbar and all its associated resources.
 */
mxToolbar.prototype.destroy = function ()
{
\tmxEvent.release(this.container);
\tthis.container = null;
\tthis.defaultMode = null;
\tthis.defaultFunction = null;
\tthis.selectedMode = null;
\t
\tif (this.menu != null)
\t{
\t\tthis.menu.destroy();
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxUndoableEdit
 * 
 * Implements a composite undoable edit. Here is an example for a custom change
 * which gets executed via the model:
 * 
 * (code)
 * function CustomChange(model, name)
 * {
 *   this.model = model;
 *   this.name = name;
 *   this.previous = name;
 * };
 * 
 * CustomChange.prototype.execute = function()
 * {
 *   var tmp = this.model.name;
 *   this.model.name = this.previous;
 *   this.previous = tmp;
 * };
 * 
 * var name = prompt('Enter name');
 * graph.model.execute(new CustomChange(graph.model, name));
 * (end)
 * 
 * Event: mxEvent.EXECUTED
 * 
 * Fires between START_EDIT and END_EDIT after an atomic change was executed.
 * The <code>change</code> property contains the change that was executed.
 * 
 * Event: mxEvent.START_EDIT
 * 
 * Fires before a set of changes will be executed in <undo> or <redo>.
 * This event contains no properties.
 * 
 * Event: mxEvent.END_EDIT
 *
 * Fires after a set of changeswas executed in <undo> or <redo>.
 * This event contains no properties.
 * 
 * Constructor: mxUndoableEdit
 * 
 * Constructs a new undoable edit for the given source.
 */
function mxUndoableEdit(source, significant)
{
\tthis.source = source;
\tthis.changes = [];
\tthis.significant = (significant != null) ? significant : true;
};

/**
 * Variable: source
 * 
 * Specifies the source of the edit.
 */
mxUndoableEdit.prototype.source = null;

/**
 * Variable: changes
 * 
 * Array that contains the changes that make up this edit. The changes are
 * expected to either have an undo and redo function, or an execute
 * function. Default is an empty array.
 */
mxUndoableEdit.prototype.changes = null;

/**
 * Variable: significant
 * 
 * Specifies if the undoable change is significant.
 * Default is true.
 */
mxUndoableEdit.prototype.significant = null;

/**
 * Variable: undone
 * 
 * Specifies if this edit has been undone. Default is false.
 */
mxUndoableEdit.prototype.undone = false;

/**
 * Variable: redone
 * 
 * Specifies if this edit has been redone. Default is false.
 */
mxUndoableEdit.prototype.redone = false;

/**
 * Function: isEmpty
 * 
 * Returns true if the this edit contains no changes.
 */
mxUndoableEdit.prototype.isEmpty = function()
{
\treturn this.changes.length == 0;
};

/**
 * Function: isSignificant
 * 
 * Returns <significant>.
 */
mxUndoableEdit.prototype.isSignificant = function()
{
\treturn this.significant;
};

/**
 * Function: add
 * 
 * Adds the specified change to this edit. The change is an object that is
 * expected to either have an undo and redo, or an execute function.
 */
mxUndoableEdit.prototype.add = function(change)
{
\tthis.changes.push(change);
};

/**
 * Function: notify
 * 
 * Hook to notify any listeners of the changes after an <undo> or <redo>
 * has been carried out. This implementation is empty.
 */
mxUndoableEdit.prototype.notify = function() { };

/**
 * Function: die
 * 
 * Hook to free resources after the edit has been removed from the command
 * history. This implementation is empty.
 */
mxUndoableEdit.prototype.die = function() { };

/**
 * Function: undo
 * 
 * Undoes all changes in this edit.
 */
mxUndoableEdit.prototype.undo = function()
{
\tif (!this.undone)
\t{
\t\tthis.source.fireEvent(new mxEventObject(mxEvent.START_EDIT));
\t\tvar count = this.changes.length;
\t\t
\t\tfor (var i = count - 1; i >= 0; i--)
\t\t{
\t\t\tvar change = this.changes[i];
\t\t\t
\t\t\tif (change.execute != null)
\t\t\t{
\t\t\t\tchange.execute();
\t\t\t}
\t\t\telse if (change.undo != null)
\t\t\t{
\t\t\t\tchange.undo();
\t\t\t}
\t\t\t
\t\t\t// New global executed event
\t\t\tthis.source.fireEvent(new mxEventObject(mxEvent.EXECUTED, 'change', change));
\t\t}
\t\t
\t\tthis.undone = true;
\t\tthis.redone = false;
\t\tthis.source.fireEvent(new mxEventObject(mxEvent.END_EDIT));
\t}
\t
\tthis.notify();
};

/**
 * Function: redo
 * 
 * Redoes all changes in this edit.
 */
mxUndoableEdit.prototype.redo = function()
{
\tif (!this.redone)
\t{
\t\tthis.source.fireEvent(new mxEventObject(mxEvent.START_EDIT));
\t\tvar count = this.changes.length;
\t\t
\t\tfor (var i = 0; i < count; i++)
\t\t{
\t\t\tvar change = this.changes[i];
\t\t\t
\t\t\tif (change.execute != null)
\t\t\t{
\t\t\t\tchange.execute();
\t\t\t}
\t\t\telse if (change.redo != null)
\t\t\t{
\t\t\t\tchange.redo();
\t\t\t}
\t\t\t
\t\t\t// New global executed event
\t\t\tthis.source.fireEvent(new mxEventObject(mxEvent.EXECUTED, 'change', change));
\t\t}
\t\t
\t\tthis.undone = false;
\t\tthis.redone = true;
\t\tthis.source.fireEvent(new mxEventObject(mxEvent.END_EDIT));
\t}
\t
\tthis.notify();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxUndoManager
 *
 * Implements a command history. When changing the graph model, an
 * <mxUndoableChange> object is created at the start of the transaction (when
 * model.beginUpdate is called). All atomic changes are then added to this
 * object until the last model.endUpdate call, at which point the
 * <mxUndoableEdit> is dispatched in an event, and added to the history inside
 * <mxUndoManager>. This is done by an event listener in
 * <mxEditor.installUndoHandler>.
 * 
 * Each atomic change of the model is represented by an object (eg.
 * <mxRootChange>, <mxChildChange>, <mxTerminalChange> etc) which contains the
 * complete undo information. The <mxUndoManager> also listens to the
 * <mxGraphView> and stores it's changes to the current root as insignificant
 * undoable changes, so that drilling (step into, step up) is undone.
 * 
 * This means when you execute an atomic change on the model, then change the
 * current root on the view and click undo, the change of the root will be
 * undone together with the change of the model so that the display represents
 * the state at which the model was changed. However, these changes are not
 * transmitted for sharing as they do not represent a state change.
 *
 * Example:
 * 
 * When adding an undo manager to a graph, make sure to add it
 * to the model and the view as well to maintain a consistent
 * display across multiple undo/redo steps.
 *
 * (code)
 * var undoManager = new mxUndoManager();
 * var listener = function(sender, evt)
 * {
 *   undoManager.undoableEditHappened(evt.getProperty('edit'));
 * };
 * graph.getModel().addListener(mxEvent.UNDO, listener);
 * graph.getView().addListener(mxEvent.UNDO, listener);
 * (end)
 * 
 * The code creates a function that informs the undoManager
 * of an undoable edit and binds it to the undo event of
 * <mxGraphModel> and <mxGraphView> using
 * <mxEventSource.addListener>.
 * 
 * Event: mxEvent.CLEAR
 * 
 * Fires after <clear> was invoked. This event has no properties.
 * 
 * Event: mxEvent.UNDO
 * 
 * Fires afer a significant edit was undone in <undo>. The <code>edit</code>
 * property contains the <mxUndoableEdit> that was undone.
 * 
 * Event: mxEvent.REDO
 * 
 * Fires afer a significant edit was redone in <redo>. The <code>edit</code>
 * property contains the <mxUndoableEdit> that was redone.
 * 
 * Event: mxEvent.ADD
 * 
 * Fires after an undoable edit was added to the history. The <code>edit</code>
 * property contains the <mxUndoableEdit> that was added.
 * 
 * Constructor: mxUndoManager
 *
 * Constructs a new undo manager with the given history size. If no history
 * size is given, then a default size of 100 steps is used.
 */
function mxUndoManager(size)
{
\tthis.size = (size != null) ? size : 100;
\tthis.clear();
};

/**
 * Extends mxEventSource.
 */
mxUndoManager.prototype = new mxEventSource();
mxUndoManager.prototype.constructor = mxUndoManager;

/**
 * Variable: size
 * 
 * Maximum command history size. 0 means unlimited history. Default is
 * 100.
 */
mxUndoManager.prototype.size = null;

/**
 * Variable: history
 * 
 * Array that contains the steps of the command history.
 */
mxUndoManager.prototype.history = null;

/**
 * Variable: indexOfNextAdd
 * 
 * Index of the element to be added next.
 */
mxUndoManager.prototype.indexOfNextAdd = 0;

/**
 * Function: isEmpty
 * 
 * Returns true if the history is empty.
 */
mxUndoManager.prototype.isEmpty = function()
{
\treturn this.history.length == 0;
};

/**
 * Function: clear
 * 
 * Clears the command history.
 */
mxUndoManager.prototype.clear = function()
{
\tthis.history = [];
\tthis.indexOfNextAdd = 0;
\tthis.fireEvent(new mxEventObject(mxEvent.CLEAR));
};

/**
 * Function: canUndo
 * 
 * Returns true if an undo is possible.
 */
mxUndoManager.prototype.canUndo = function()
{
\treturn this.indexOfNextAdd > 0;
};

/**
 * Function: undo
 * 
 * Undoes the last change.
 */
mxUndoManager.prototype.undo = function()
{
    while (this.indexOfNextAdd > 0)
    {
        var edit = this.history[--this.indexOfNextAdd];
        edit.undo();

\t\tif (edit.isSignificant())
        {
        \tthis.fireEvent(new mxEventObject(mxEvent.UNDO, 'edit', edit));
            break;
        }
    }
};

/**
 * Function: canRedo
 * 
 * Returns true if a redo is possible.
 */
mxUndoManager.prototype.canRedo = function()
{
\treturn this.indexOfNextAdd < this.history.length;
};

/**
 * Function: redo
 * 
 * Redoes the last change.
 */
mxUndoManager.prototype.redo = function()
{
    var n = this.history.length;
    
    while (this.indexOfNextAdd < n)
    {
        var edit =  this.history[this.indexOfNextAdd++];
        edit.redo();
        
        if (edit.isSignificant())
        {
        \tthis.fireEvent(new mxEventObject(mxEvent.REDO, 'edit', edit));
            break;
        }
    }
};

/**
 * Function: undoableEditHappened
 * 
 * Method to be called to add new undoable edits to the <history>.
 */
mxUndoManager.prototype.undoableEditHappened = function(undoableEdit)
{
\tthis.trim();
\t
\tif (this.size > 0 &&
\t\tthis.size == this.history.length)
\t{
\t\tthis.history.shift();
\t}
\t
\tthis.history.push(undoableEdit);
\tthis.indexOfNextAdd = this.history.length;
\tthis.fireEvent(new mxEventObject(mxEvent.ADD, 'edit', undoableEdit));
};

/**
 * Function: trim
 * 
 * Removes all pending steps after <indexOfNextAdd> from the history,
 * invoking die on each edit. This is called from <undoableEditHappened>.
 */
mxUndoManager.prototype.trim = function()
{
\tif (this.history.length > this.indexOfNextAdd)
\t{
\t\tvar edits = this.history.splice(this.indexOfNextAdd,
\t\t\tthis.history.length - this.indexOfNextAdd);
\t\t\t
\t\tfor (var i = 0; i < edits.length; i++)
\t\t{
\t\t\tedits[i].die();
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 *
 * Class: mxUrlConverter
 * 
 * Converts relative and absolute URLs to absolute URLs with protocol and domain.
 */
var mxUrlConverter = function()
{
\t// Empty constructor
};

/**
 * Variable: enabled
 * 
 * Specifies if the converter is enabled. Default is true.
 */
mxUrlConverter.prototype.enabled = true;

/**
 * Variable: baseUrl
 * 
 * Specifies the base URL to be used as a prefix for relative URLs.
 */
mxUrlConverter.prototype.baseUrl = null;

/**
 * Variable: baseDomain
 * 
 * Specifies the base domain to be used as a prefix for absolute URLs.
 */
mxUrlConverter.prototype.baseDomain = null;

/**
 * Function: updateBaseUrl
 * 
 * Private helper function to update the base URL.
 */
mxUrlConverter.prototype.updateBaseUrl = function()
{
\tthis.baseDomain = location.protocol + '//' + location.host;
\tthis.baseUrl = this.baseDomain + location.pathname;
\tvar tmp = this.baseUrl.lastIndexOf('/');
\t
\t// Strips filename etc
\tif (tmp > 0)
\t{
\t\tthis.baseUrl = this.baseUrl.substring(0, tmp + 1);
\t}
};

/**
 * Function: isEnabled
 * 
 * Returns <enabled>.
 */
mxUrlConverter.prototype.isEnabled = function()
{
\treturn this.enabled;
};

/**
 * Function: setEnabled
 * 
 * Sets <enabled>.
 */
mxUrlConverter.prototype.setEnabled = function(value)
{
\tthis.enabled = value;
};

/**
 * Function: getBaseUrl
 * 
 * Returns <baseUrl>.
 */
mxUrlConverter.prototype.getBaseUrl = function()
{
\treturn this.baseUrl;
};

/**
 * Function: setBaseUrl
 * 
 * Sets <baseUrl>.
 */
mxUrlConverter.prototype.setBaseUrl = function(value)
{
\tthis.baseUrl = value;
};

/**
 * Function: getBaseDomain
 * 
 * Returns <baseDomain>.
 */
mxUrlConverter.prototype.getBaseDomain = function()
{
\treturn this.baseDomain;
};

/**
 * Function: setBaseDomain
 * 
 * Sets <baseDomain>.
 */
mxUrlConverter.prototype.setBaseDomain = function(value)
{
\tthis.baseDomain = value;
};

/**
 * Function: isRelativeUrl
 * 
 * Returns true if the given URL is relative.
 */
mxUrlConverter.prototype.isRelativeUrl = function(url)
{
\treturn url != null && url.substring(0, 2) != '//' && url.substring(0, 7) != 'http://' &&
\t\turl.substring(0, 8) != 'https://' && url.substring(0, 10) != 'data:image' &&
\t\turl.substring(0, 7) != 'file://';
};

/**
 * Function: convert
 * 
 * Converts the given URL to an absolute URL with protol and domain.
 * Relative URLs are first converted to absolute URLs.
 */
mxUrlConverter.prototype.convert = function(url)
{
\tif (this.isEnabled() && this.isRelativeUrl(url))
\t{
\t\tif (this.getBaseUrl() == null)
\t\t{
\t\t\tthis.updateBaseUrl();
\t\t}
\t\t
\t\tif (url.charAt(0) == '/')
\t\t{
\t\t\turl = this.getBaseDomain() + url;
\t\t}
\t\telse
\t\t{
\t\t\turl = this.getBaseUrl() + url;
\t\t}
\t}
\t
\treturn url;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxPanningManager
 *
 * Implements a handler for panning.
 */
function mxPanningManager(graph)
{
\tthis.thread = null;
\tthis.active = false;
\tthis.tdx = 0;
\tthis.tdy = 0;
\tthis.t0x = 0;
\tthis.t0y = 0;
\tthis.dx = 0;
\tthis.dy = 0;
\tthis.scrollbars = false;
\tthis.scrollLeft = 0;
\tthis.scrollTop = 0;
\t
\tthis.mouseListener =
\t{
\t    mouseDown: function(sender, me) { },
\t    mouseMove: function(sender, me) { },
\t    mouseUp: mxUtils.bind(this, function(sender, me)
\t    {
\t    \tif (this.active)
\t    \t{
\t    \t\tthis.stop();
\t    \t}
\t    })
\t};
\t
\tgraph.addMouseListener(this.mouseListener);
\t
\tthis.mouseUpListener = mxUtils.bind(this, function()
\t{
\t    \tif (this.active)
\t    \t{
\t    \t\tthis.stop();
\t    \t}
\t});
\t
\t// Stops scrolling on every mouseup anywhere in the document
\tmxEvent.addListener(document, 'mouseup', this.mouseUpListener);
\t
\tvar createThread = mxUtils.bind(this, function()
\t{
\t    \tthis.scrollbars = mxUtils.hasScrollbars(graph.container);
\t    \tthis.scrollLeft = graph.container.scrollLeft;
\t    \tthis.scrollTop = graph.container.scrollTop;
\t
\t    \treturn window.setInterval(mxUtils.bind(this, function()
\t\t{
\t\t\tthis.tdx -= this.dx;
\t\t\tthis.tdy -= this.dy;

\t\t\tif (this.scrollbars)
\t\t\t{
\t\t\t\tvar left = -graph.container.scrollLeft - Math.ceil(this.dx);
\t\t\t\tvar top = -graph.container.scrollTop - Math.ceil(this.dy);
\t\t\t\tgraph.panGraph(left, top);
\t\t\t\tgraph.panDx = this.scrollLeft - graph.container.scrollLeft;
\t\t\t\tgraph.panDy = this.scrollTop - graph.container.scrollTop;
\t\t\t\tgraph.fireEvent(new mxEventObject(mxEvent.PAN));
\t\t\t\t// TODO: Implement graph.autoExtend
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tgraph.panGraph(this.getDx(), this.getDy());
\t\t\t}
\t\t}), this.delay);
\t});
\t
\tthis.isActive = function()
\t{
\t\treturn active;
\t};
\t
\tthis.getDx = function()
\t{
\t\treturn Math.round(this.tdx);
\t};
\t
\tthis.getDy = function()
\t{
\t\treturn Math.round(this.tdy);
\t};
\t
\tthis.start = function()
\t{
\t\tthis.t0x = graph.view.translate.x;
\t\tthis.t0y = graph.view.translate.y;
\t\tthis.active = true;
\t};
\t
\tthis.panTo = function(x, y, w, h)
\t{
\t\tif (!this.active)
\t\t{
\t\t\tthis.start();
\t\t}
\t\t
    \tthis.scrollLeft = graph.container.scrollLeft;
    \tthis.scrollTop = graph.container.scrollTop;
\t\t
\t\tw = (w != null) ? w : 0;
\t\th = (h != null) ? h : 0;
\t\t
\t\tvar c = graph.container;
\t\tthis.dx = x + w - c.scrollLeft - c.clientWidth;
\t\t
\t\tif (this.dx < 0 && Math.abs(this.dx) < this.border)
\t\t{
\t\t\tthis.dx = this.border + this.dx;
\t\t}
\t\telse if (this.handleMouseOut)
\t\t{
\t\t\tthis.dx = Math.max(this.dx, 0);
\t\t}
\t\telse
\t\t{
\t\t\tthis.dx = 0;
\t\t}
\t\t
\t\tif (this.dx == 0)
\t\t{
\t\t\tthis.dx = x - c.scrollLeft;
\t\t\t
\t\t\tif (this.dx > 0 && this.dx < this.border)
\t\t\t{
\t\t\t\tthis.dx = this.dx - this.border;
\t\t\t}
\t\t\telse if (this.handleMouseOut)
\t\t\t{
\t\t\t\tthis.dx = Math.min(0, this.dx);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.dx = 0;
\t\t\t}
\t\t}
\t\t
\t\tthis.dy = y + h - c.scrollTop - c.clientHeight;

\t\tif (this.dy < 0 && Math.abs(this.dy) < this.border)
\t\t{
\t\t\tthis.dy = this.border + this.dy;
\t\t}
\t\telse if (this.handleMouseOut)
\t\t{
\t\t\tthis.dy = Math.max(this.dy, 0);
\t\t}
\t\telse
\t\t{
\t\t\tthis.dy = 0;
\t\t}
\t\t
\t\tif (this.dy == 0)
\t\t{
\t\t\tthis.dy = y - c.scrollTop;
\t\t\t
\t\t\tif (this.dy > 0 && this.dy < this.border)
\t\t\t{
\t\t\t\tthis.dy = this.dy - this.border;
\t\t\t}
\t\t\telse if (this.handleMouseOut)
\t\t\t{
\t\t\t\tthis.dy = Math.min(0, this.dy);
\t\t\t} 
\t\t\telse
\t\t\t{
\t\t\t\tthis.dy = 0;
\t\t\t}
\t\t}
\t\t
\t\tif (this.dx != 0 || this.dy != 0)
\t\t{
\t\t\tthis.dx *= this.damper;
\t\t\tthis.dy *= this.damper;
\t\t\t
\t\t\tif (this.thread == null)
\t\t\t{
\t\t\t\tthis.thread = createThread();
\t\t\t}
\t\t}
\t\telse if (this.thread != null)
\t\t{
\t\t\twindow.clearInterval(this.thread);
\t\t\tthis.thread = null;
\t\t}
\t};
\t
\tthis.stop = function()
\t{
\t\tif (this.active)
\t\t{
\t\t\tthis.active = false;
\t\t
\t\t\tif (this.thread != null)
\t    \t{
\t\t\t\twindow.clearInterval(this.thread);
\t\t\t\tthis.thread = null;
\t    \t}
\t\t\t
\t\t\tthis.tdx = 0;
\t\t\tthis.tdy = 0;
\t\t\t
\t\t\tif (!this.scrollbars)
\t\t\t{
\t\t\t\tvar px = graph.panDx;
\t\t\t\tvar py = graph.panDy;
\t\t    \t
\t\t    \tif (px != 0 || py != 0)
\t\t    \t{
\t\t    \t\tgraph.panGraph(0, 0);
\t\t\t    \tgraph.view.setTranslate(this.t0x + px / graph.view.scale, this.t0y + py / graph.view.scale);
\t\t    \t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tgraph.panDx = 0;
\t\t\t\tgraph.panDy = 0;
\t\t\t\tgraph.fireEvent(new mxEventObject(mxEvent.PAN));
\t\t\t}
\t\t}
\t};
\t
\tthis.destroy = function()
\t{
\t\tgraph.removeMouseListener(this.mouseListener);
\t\tmxEvent.removeListener(document, 'mouseup', this.mouseUpListener);
\t};
};

/**
 * Variable: damper
 * 
 * Damper value for the panning. Default is 1/6.
 */
mxPanningManager.prototype.damper = 1/6;

/**
 * Variable: delay
 * 
 * Delay in milliseconds for the panning. Default is 10.
 */
mxPanningManager.prototype.delay = 10;

/**
 * Variable: handleMouseOut
 * 
 * Specifies if mouse events outside of the component should be handled. Default is true. 
 */
mxPanningManager.prototype.handleMouseOut = true;

/**
 * Variable: border
 * 
 * Border to handle automatic panning inside the component. Default is 0 (disabled).
 */
mxPanningManager.prototype.border = 0;
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxPopupMenu
 * 
 * Basic popup menu. To add a vertical scrollbar to a given submenu, the
 * following code can be used.
 * 
 * (code)
 * var mxPopupMenuShowMenu = mxPopupMenu.prototype.showMenu;
 * mxPopupMenu.prototype.showMenu = function()
 * {
 *   mxPopupMenuShowMenu.apply(this, arguments);
 *   
 *   this.div.style.overflowY = 'auto';
 *   this.div.style.overflowX = 'hidden';
 *   this.div.style.maxHeight = '160px';
 * };
 * (end)
 * 
 * Constructor: mxPopupMenu
 * 
 * Constructs a popupmenu.
 * 
 * Event: mxEvent.SHOW
 *
 * Fires after the menu has been shown in <popup>.
 */
function mxPopupMenu(factoryMethod)
{
\tthis.factoryMethod = factoryMethod;
\t
\tif (factoryMethod != null)
\t{
\t\tthis.init();
\t}
};

/**
 * Extends mxEventSource.
 */
mxPopupMenu.prototype = new mxEventSource();
mxPopupMenu.prototype.constructor = mxPopupMenu;

/**
 * Variable: submenuImage
 * 
 * URL of the image to be used for the submenu icon.
 */
mxPopupMenu.prototype.submenuImage = mxClient.imageBasePath + '/submenu.gif';

/**
 * Variable: zIndex
 * 
 * Specifies the zIndex for the popupmenu and its shadow. Default is 10006.
 */
mxPopupMenu.prototype.zIndex = 10006;

/**
 * Variable: factoryMethod
 * 
 * Function that is used to create the popup menu. The function takes the
 * current panning handler, the <mxCell> under the mouse and the mouse
 * event that triggered the call as arguments.
 */
mxPopupMenu.prototype.factoryMethod = null;

/**
 * Variable: useLeftButtonForPopup
 * 
 * Specifies if popupmenus should be activated by clicking the left mouse
 * button. Default is false.
 */
mxPopupMenu.prototype.useLeftButtonForPopup = false;

/**
 * Variable: enabled
 * 
 * Specifies if events are handled. Default is true.
 */
mxPopupMenu.prototype.enabled = true;

/**
 * Variable: itemCount
 * 
 * Contains the number of times <addItem> has been called for a new menu.
 */
mxPopupMenu.prototype.itemCount = 0;

/**
 * Variable: autoExpand
 * 
 * Specifies if submenus should be expanded on mouseover. Default is false.
 */
mxPopupMenu.prototype.autoExpand = false;

/**
 * Variable: smartSeparators
 * 
 * Specifies if separators should only be added if a menu item follows them.
 * Default is false.
 */
mxPopupMenu.prototype.smartSeparators = false;

/**
 * Variable: labels
 * 
 * Specifies if any labels should be visible. Default is true.
 */
mxPopupMenu.prototype.labels = true;

/**
 * Function: init
 * 
 * Initializes the shapes required for this vertex handler.
 */
mxPopupMenu.prototype.init = function()
{
\t// Adds the inner table
\tthis.table = document.createElement('table');
\tthis.table.className = 'mxPopupMenu';
\t
\tthis.tbody = document.createElement('tbody');
\tthis.table.appendChild(this.tbody);

\t// Adds the outer div
\tthis.div = document.createElement('div');
\tthis.div.className = 'mxPopupMenu';
\tthis.div.style.display = 'inline';
\tthis.div.style.zIndex = this.zIndex;
\tthis.div.appendChild(this.table);

\t// Disables the context menu on the outer div
\tmxEvent.disableContextMenu(this.div);
};

/**
 * Function: isEnabled
 * 
 * Returns true if events are handled. This implementation
 * returns <enabled>.
 */
mxPopupMenu.prototype.isEnabled = function()
{
\treturn this.enabled;
};
\t
/**
 * Function: setEnabled
 * 
 * Enables or disables event handling. This implementation
 * updates <enabled>.
 */
mxPopupMenu.prototype.setEnabled = function(enabled)
{
\tthis.enabled = enabled;
};

/**
 * Function: isPopupTrigger
 * 
 * Returns true if the given event is a popupmenu trigger for the optional
 * given cell.
 * 
 * Parameters:
 * 
 * me - <mxMouseEvent> that represents the mouse event.
 */
mxPopupMenu.prototype.isPopupTrigger = function(me)
{
\treturn me.isPopupTrigger() || (this.useLeftButtonForPopup && mxEvent.isLeftMouseButton(me.getEvent()));
};

/**
 * Function: addItem
 * 
 * Adds the given item to the given parent item. If no parent item is specified
 * then the item is added to the top-level menu. The return value may be used
 * as the parent argument, ie. as a submenu item. The return value is the table
 * row that represents the item.
 * 
 * Paramters:
 * 
 * title - String that represents the title of the menu item.
 * image - Optional URL for the image icon.
 * funct - Function associated that takes a mouseup or touchend event.
 * parent - Optional item returned by <addItem>.
 * iconCls - Optional string that represents the CSS class for the image icon.
 * IconsCls is ignored if image is given.
 * enabled - Optional boolean indicating if the item is enabled. Default is true.
 * active - Optional boolean indicating if the menu should implement any event handling.
 * Default is true.
 * noHover - Optional boolean to disable hover state.
 */
mxPopupMenu.prototype.addItem = function(title, image, funct, parent, iconCls, enabled, active, noHover)
{
\tparent = parent || this;
\tthis.itemCount++;
\t
\t// Smart separators only added if element contains items
\tif (parent.willAddSeparator)
\t{
\t\tif (parent.containsItems)
\t\t{
\t\t\tthis.addSeparator(parent, true);
\t\t}

\t\tparent.willAddSeparator = false;
\t}

\tparent.containsItems = true;
\tvar tr = document.createElement('tr');
\ttr.className = 'mxPopupMenuItem';
\tvar col1 = document.createElement('td');
\tcol1.className = 'mxPopupMenuIcon';

\t// Adds the given image into the first column
\tif (image != null)
\t{
\t\tvar img = document.createElement('img');
\t\timg.src = image;
\t\tcol1.appendChild(img);
\t}
\telse if (iconCls != null)
\t{
\t\tvar div = document.createElement('div');
\t\tdiv.className = iconCls;
\t\tcol1.appendChild(div);
\t}
\t
\ttr.appendChild(col1);
\t
\tif (this.labels)
\t{
\t\tvar col2 = document.createElement('td');
\t\tcol2.className = 'mxPopupMenuItem' +
\t\t\t((enabled != null && !enabled) ? ' mxDisabled' : '');
\t\t
\t\tmxUtils.write(col2, title);
\t\tcol2.align = 'left';
\t\ttr.appendChild(col2);
\t
\t\tvar col3 = document.createElement('td');
\t\tcol3.className = 'mxPopupMenuItem' +
\t\t\t((enabled != null && !enabled) ? ' mxDisabled' : '');
\t\tcol3.style.paddingRight = '6px';
\t\tcol3.style.textAlign = 'right';
\t\t
\t\ttr.appendChild(col3);
\t\t
\t\tif (parent.div == null)
\t\t{
\t\t\tthis.createSubmenu(parent);
\t\t}
\t}
\t
\tparent.tbody.appendChild(tr);

\tif (active != false && enabled != false)
\t{
\t\tvar currentSelection = null;
\t\t
\t\tmxEvent.addGestureListeners(tr,
\t\t\tmxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tthis.eventReceiver = tr;
\t\t\t\t
\t\t\t\tif (parent.activeRow != tr && parent.activeRow != parent)
\t\t\t\t{
\t\t\t\t\tif (parent.activeRow != null && parent.activeRow.div.parentNode != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.hideSubmenu(parent);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (tr.div != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.showSubmenu(parent, tr);
\t\t\t\t\t\tparent.activeRow = tr;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Workaround for lost current selection in page because of focus in IE
\t\t\t\tif (document.selection != null && (mxClient.IS_QUIRKS || document.documentMode == 8))
\t\t\t\t{
\t\t\t\t\tcurrentSelection = document.selection.createRange();
\t\t\t\t}
\t\t\t\t
\t\t\t\tmxEvent.consume(evt);
\t\t\t}),
\t\t\tmxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\tif (parent.activeRow != tr && parent.activeRow != parent)
\t\t\t\t{
\t\t\t\t\tif (parent.activeRow != null && parent.activeRow.div.parentNode != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.hideSubmenu(parent);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (this.autoExpand && tr.div != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.showSubmenu(parent, tr);
\t\t\t\t\t\tparent.activeRow = tr;
\t\t\t\t\t}
\t\t\t\t}
\t\t
\t\t\t\t// Sets hover style because TR in IE doesn't have hover
\t\t\t\tif (!noHover)
\t\t\t\t{
\t\t\t\t\ttr.className = 'mxPopupMenuItemHover';
\t\t\t\t}
\t\t\t}),
\t\t\tmxUtils.bind(this, function(evt)
\t\t\t{
\t\t\t\t// EventReceiver avoids clicks on a submenu item
\t\t\t\t// which has just been shown in the mousedown
\t\t\t\tif (this.eventReceiver == tr)
\t\t\t\t{
\t\t\t\t\tif (parent.activeRow != tr)
\t\t\t\t\t{
\t\t\t\t\t\tthis.hideMenu();
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\t// Workaround for lost current selection in page because of focus in IE
\t\t\t\t\tif (currentSelection != null)
\t\t\t\t\t{
\t\t\t\t\t\t// Workaround for \"unspecified error\" in IE8 standards
\t\t\t\t\t\ttry
\t\t\t\t\t\t{
\t\t\t\t\t\t\tcurrentSelection.select();
\t\t\t\t\t\t}
\t\t\t\t\t\tcatch (e)
\t\t\t\t\t\t{
\t\t\t\t\t\t\t// ignore
\t\t\t\t\t\t}

\t\t\t\t\t\tcurrentSelection = null;
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (funct != null)
\t\t\t\t\t{
\t\t\t\t\t\tfunct(evt);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.eventReceiver = null;
\t\t\t\tmxEvent.consume(evt);
\t\t\t})
\t\t);
\t
\t\t// Resets hover style because TR in IE doesn't have hover
\t\tif (!noHover)
\t\t{
\t\t\tmxEvent.addListener(tr, 'mouseout',
\t\t\t\tmxUtils.bind(this, function(evt)
\t\t\t\t{
\t\t\t\t\ttr.className = 'mxPopupMenuItem';
\t\t\t\t})
\t\t\t);
\t\t}
\t}
\t
\treturn tr;
};

/**
 * Adds a checkmark to the given menuitem.
 */
mxPopupMenu.prototype.addCheckmark = function(item, img)
{
\tvar td = item.firstChild.nextSibling;
\ttd.style.backgroundImage = 'url(\\'' + img + '\\')';
\ttd.style.backgroundRepeat = 'no-repeat';
\ttd.style.backgroundPosition = '2px 50%';
};

/**
 * Function: createSubmenu
 * 
 * Creates the nodes required to add submenu items inside the given parent
 * item. This is called in <addItem> if a parent item is used for the first
 * time. This adds various DOM nodes and a <submenuImage> to the parent.
 * 
 * Parameters:
 * 
 * parent - An item returned by <addItem>.
 */
mxPopupMenu.prototype.createSubmenu = function(parent)
{
\tparent.table = document.createElement('table');
\tparent.table.className = 'mxPopupMenu';

\tparent.tbody = document.createElement('tbody');
\tparent.table.appendChild(parent.tbody);

\tparent.div = document.createElement('div');
\tparent.div.className = 'mxPopupMenu';

\tparent.div.style.position = 'absolute';
\tparent.div.style.display = 'inline';
\tparent.div.style.zIndex = this.zIndex;
\t
\tparent.div.appendChild(parent.table);
\t
\tvar img = document.createElement('img');
\timg.setAttribute('src', this.submenuImage);
\t
\t// Last column of the submenu item in the parent menu
\ttd = parent.firstChild.nextSibling.nextSibling;
\ttd.appendChild(img);
};

/**
 * Function: showSubmenu
 * 
 * Shows the submenu inside the given parent row.
 */
mxPopupMenu.prototype.showSubmenu = function(parent, row)
{
\tif (row.div != null)
\t{
\t\trow.div.style.left = (parent.div.offsetLeft +
\t\t\trow.offsetLeft+row.offsetWidth - 1) + 'px';
\t\trow.div.style.top = (parent.div.offsetTop+row.offsetTop) + 'px';
\t\tdocument.body.appendChild(row.div);
\t\t
\t\t// Moves the submenu to the left side if there is no space
\t\tvar left = parseInt(row.div.offsetLeft);
\t\tvar width = parseInt(row.div.offsetWidth);
\t\tvar offset = mxUtils.getDocumentScrollOrigin(document);
\t\t
\t\tvar b = document.body;
\t\tvar d = document.documentElement;
\t\t
\t\tvar right = offset.x + (b.clientWidth || d.clientWidth);
\t\t
\t\tif (left + width > right)
\t\t{
\t\t\trow.div.style.left = Math.max(0, (parent.div.offsetLeft - width + ((mxClient.IS_IE) ? 6 : -6))) + 'px';
\t\t}
\t\t
\t\tmxUtils.fit(row.div);
\t}
};

/**
 * Function: addSeparator
 * 
 * Adds a horizontal separator in the given parent item or the top-level menu
 * if no parent is specified.
 * 
 * Parameters:
 * 
 * parent - Optional item returned by <addItem>.
 * force - Optional boolean to ignore <smartSeparators>. Default is false.
 */
mxPopupMenu.prototype.addSeparator = function(parent, force)
{
\tparent = parent || this;
\t
\tif (this.smartSeparators && !force)
\t{
\t\tparent.willAddSeparator = true;
\t}
\telse if (parent.tbody != null)
\t{
\t\tparent.willAddSeparator = false;
\t\tvar tr = document.createElement('tr');
\t\t
\t\tvar col1 = document.createElement('td');
\t\tcol1.className = 'mxPopupMenuIcon';
\t\tcol1.style.padding = '0 0 0 0px';
\t\t
\t\ttr.appendChild(col1);
\t\t
\t\tvar col2 = document.createElement('td');
\t\tcol2.style.padding = '0 0 0 0px';
\t\tcol2.setAttribute('colSpan', '2');
\t
\t\tvar hr = document.createElement('hr');
\t\thr.setAttribute('size', '1');
\t\tcol2.appendChild(hr);
\t\t
\t\ttr.appendChild(col2);
\t\t
\t\tparent.tbody.appendChild(tr);
\t}
};

/**
 * Function: popup
 * 
 * Shows the popup menu for the given event and cell.
 * 
 * Example:
 * 
 * (code)
 * graph.panningHandler.popup = function(x, y, cell, evt)
 * {
 *   mxUtils.alert('Hello, World!');
 * }
 * (end)
 */
mxPopupMenu.prototype.popup = function(x, y, cell, evt)
{
\tif (this.div != null && this.tbody != null && this.factoryMethod != null)
\t{
\t\tthis.div.style.left = x + 'px';
\t\tthis.div.style.top = y + 'px';
\t\t
\t\t// Removes all child nodes from the existing menu
\t\twhile (this.tbody.firstChild != null)
\t\t{
\t\t\tmxEvent.release(this.tbody.firstChild);
\t\t\tthis.tbody.removeChild(this.tbody.firstChild);
\t\t}
\t\t
\t\tthis.itemCount = 0;
\t\tthis.factoryMethod(this, cell, evt);
\t\t
\t\tif (this.itemCount > 0)
\t\t{
\t\t\tthis.showMenu();
\t\t\tthis.fireEvent(new mxEventObject(mxEvent.SHOW));
\t\t}
\t}
};

/**
 * Function: isMenuShowing
 * 
 * Returns true if the menu is showing.
 */
mxPopupMenu.prototype.isMenuShowing = function()
{
\treturn this.div != null && this.div.parentNode == document.body;
};

/**
 * Function: showMenu
 * 
 * Shows the menu.
 */
mxPopupMenu.prototype.showMenu = function()
{
\t// Disables filter-based shadow in IE9 standards mode
\tif (document.documentMode >= 9)
\t{
\t\tthis.div.style.filter = 'none';
\t}
\t
\t// Fits the div inside the viewport
\tdocument.body.appendChild(this.div);
\tmxUtils.fit(this.div);
};

/**
 * Function: hideMenu
 * 
 * Removes the menu and all submenus.
 */
mxPopupMenu.prototype.hideMenu = function()
{
\tif (this.div != null)
\t{
\t\tif (this.div.parentNode != null)
\t\t{
\t\t\tthis.div.parentNode.removeChild(this.div);
\t\t}
\t\t
\t\tthis.hideSubmenu(this);
\t\tthis.containsItems = false;
\t\tthis.fireEvent(new mxEventObject(mxEvent.HIDE));
\t}
};

/**
 * Function: hideSubmenu
 * 
 * Removes all submenus inside the given parent.
 * 
 * Parameters:
 * 
 * parent - An item returned by <addItem>.
 */
mxPopupMenu.prototype.hideSubmenu = function(parent)
{
\tif (parent.activeRow != null)
\t{
\t\tthis.hideSubmenu(parent.activeRow);
\t\t
\t\tif (parent.activeRow.div.parentNode != null)
\t\t{
\t\t\tparent.activeRow.div.parentNode.removeChild(parent.activeRow.div);
\t\t}
\t\t
\t\tparent.activeRow = null;
\t}
};

/**
 * Function: destroy
 * 
 * Destroys the handler and all its resources and DOM nodes.
 */
mxPopupMenu.prototype.destroy = function()
{
\tif (this.div != null)
\t{
\t\tmxEvent.release(this.div);
\t\t
\t\tif (this.div.parentNode != null)
\t\t{
\t\t\tthis.div.parentNode.removeChild(this.div);
\t\t}
\t\t
\t\tthis.div = null;
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxAutoSaveManager
 * 
 * Manager for automatically saving diagrams. The <save> hook must be
 * implemented.
 * 
 * Example:
 * 
 * (code)
 * var mgr = new mxAutoSaveManager(editor.graph);
 * mgr.save = function()
 * {
 *   mxLog.show();
 *   mxLog.debug('save');
 * };
 * (end)
 * 
 * Constructor: mxAutoSaveManager
 *
 * Constructs a new automatic layout for the given graph.
 *
 * Arguments:
 * 
 * graph - Reference to the enclosing graph. 
 */
function mxAutoSaveManager(graph)
{
\t// Notifies the manager of a change
\tthis.changeHandler = mxUtils.bind(this, function(sender, evt)
\t{
\t\tif (this.isEnabled())
\t\t{
\t\t\tthis.graphModelChanged(evt.getProperty('edit').changes);
\t\t}
\t});

\tthis.setGraph(graph);
};

/**
 * Extends mxEventSource.
 */
mxAutoSaveManager.prototype = new mxEventSource();
mxAutoSaveManager.prototype.constructor = mxAutoSaveManager;

/**
 * Variable: graph
 * 
 * Reference to the enclosing <mxGraph>.
 */
mxAutoSaveManager.prototype.graph = null;

/**
 * Variable: autoSaveDelay
 * 
 * Minimum amount of seconds between two consecutive autosaves. Eg. a
 * value of 1 (s) means the graph is not stored more than once per second.
 * Default is 10.
 */
mxAutoSaveManager.prototype.autoSaveDelay = 10;

/**
 * Variable: autoSaveThrottle
 * 
 * Minimum amount of seconds between two consecutive autosaves triggered by
 * more than <autoSaveThreshhold> changes within a timespan of less than
 * <autoSaveDelay> seconds. Eg. a value of 1 (s) means the graph is not
 * stored more than once per second even if there are more than
 * <autoSaveThreshold> changes within that timespan. Default is 2.
 */
mxAutoSaveManager.prototype.autoSaveThrottle = 2;

/**
 * Variable: autoSaveThreshold
 * 
 * Minimum amount of ignored changes before an autosave. Eg. a value of 2
 * means after 2 change of the graph model the autosave will trigger if the
 * condition below is true. Default is 5.
 */
mxAutoSaveManager.prototype.autoSaveThreshold = 5;

/**
 * Variable: ignoredChanges
 * 
 * Counter for ignored changes in autosave.
 */
mxAutoSaveManager.prototype.ignoredChanges = 0;

/**
 * Variable: lastSnapshot
 * 
 * Used for autosaving. See <autosave>.
 */
mxAutoSaveManager.prototype.lastSnapshot = 0;

/**
 * Variable: enabled
 * 
 * Specifies if event handling is enabled. Default is true.
 */
mxAutoSaveManager.prototype.enabled = true;

/**
 * Variable: changeHandler
 * 
 * Holds the function that handles graph model changes.
 */
mxAutoSaveManager.prototype.changeHandler = null;

/**
 * Function: isEnabled
 * 
 * Returns true if events are handled. This implementation
 * returns <enabled>.
 */
mxAutoSaveManager.prototype.isEnabled = function()
{
\treturn this.enabled;
};

/**
 * Function: setEnabled
 * 
 * Enables or disables event handling. This implementation
 * updates <enabled>.
 * 
 * Parameters:
 * 
 * enabled - Boolean that specifies the new enabled state.
 */
mxAutoSaveManager.prototype.setEnabled = function(value)
{
\tthis.enabled = value;
};

/**
 * Function: setGraph
 * 
 * Sets the graph that the layouts operate on.
 */
mxAutoSaveManager.prototype.setGraph = function(graph)
{
\tif (this.graph != null)
\t{
\t\tthis.graph.getModel().removeListener(this.changeHandler);
\t}
\t
\tthis.graph = graph;
\t
\tif (this.graph != null)
\t{
\t\tthis.graph.getModel().addListener(mxEvent.CHANGE, this.changeHandler);
\t}
};

/**
 * Function: save
 * 
 * Empty hook that is called if the graph should be saved.
 */
mxAutoSaveManager.prototype.save = function()
{
\t// empty
};

/**
 * Function: graphModelChanged
 * 
 * Invoked when the graph model has changed.
 */
mxAutoSaveManager.prototype.graphModelChanged = function(changes)
{
\tvar now = new Date().getTime();
\tvar dt = (now - this.lastSnapshot) / 1000;
\t
\tif (dt > this.autoSaveDelay ||
\t\t(this.ignoredChanges >= this.autoSaveThreshold &&
\t\t dt > this.autoSaveThrottle))
\t{
\t\tthis.save();
\t\tthis.reset();
\t}
\telse
\t{
\t\t// Increments the number of ignored changes
\t\tthis.ignoredChanges++;
\t}
};

/**
 * Function: reset
 * 
 * Resets all counters.
 */
mxAutoSaveManager.prototype.reset = function()
{
\tthis.lastSnapshot = new Date().getTime();
\tthis.ignoredChanges = 0;
};

/**
 * Function: destroy
 * 
 * Removes all handlers from the <graph> and deletes the reference to it.
 */
mxAutoSaveManager.prototype.destroy = function()
{
\tthis.setGraph(null);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 *
 * Class: mxAnimation
 * 
 * Implements a basic animation in JavaScript.
 * 
 * Constructor: mxAnimation
 * 
 * Constructs an animation.
 * 
 * Parameters:
 * 
 * graph - Reference to the enclosing <mxGraph>.
 */
function mxAnimation(delay)
{
\tthis.delay = (delay != null) ? delay : 20;
};

/**
 * Extends mxEventSource.
 */
mxAnimation.prototype = new mxEventSource();
mxAnimation.prototype.constructor = mxAnimation;

/**
 * Variable: delay
 * 
 * Specifies the delay between the animation steps. Defaul is 30ms.
 */
mxAnimation.prototype.delay = null;

/**
 * Variable: thread
 * 
 * Reference to the thread while the animation is running.
 */
mxAnimation.prototype.thread = null;

/**
 * Function: isRunning
 * 
 * Returns true if the animation is running.
 */
mxAnimation.prototype.isRunning = function()
{
\treturn this.thread != null;
};

/**
 * Function: startAnimation
 *
 * Starts the animation by repeatedly invoking updateAnimation.
 */
mxAnimation.prototype.startAnimation = function()
{
\tif (this.thread == null)
\t{
\t\tthis.thread = window.setInterval(mxUtils.bind(this, this.updateAnimation), this.delay);
\t}
};

/**
 * Function: updateAnimation
 *
 * Hook for subclassers to implement the animation. Invoke stopAnimation
 * when finished, startAnimation to resume. This is called whenever the
 * timer fires and fires an mxEvent.EXECUTE event with no properties.
 */
mxAnimation.prototype.updateAnimation = function()
{
\tthis.fireEvent(new mxEventObject(mxEvent.EXECUTE));
};

/**
 * Function: stopAnimation
 *
 * Stops the animation by deleting the timer and fires an <mxEvent.DONE>.
 */
mxAnimation.prototype.stopAnimation = function()
{
\tif (this.thread != null)
\t{
\t\twindow.clearInterval(this.thread);
\t\tthis.thread = null;
\t\tthis.fireEvent(new mxEventObject(mxEvent.DONE));
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 *
 * Class: mxMorphing
 * 
 * Implements animation for morphing cells. Here is an example of
 * using this class for animating the result of a layout algorithm:
 * 
 * (code)
 * graph.getModel().beginUpdate();
 * try
 * {
 *   var circleLayout = new mxCircleLayout(graph);
 *   circleLayout.execute(graph.getDefaultParent());
 * }
 * finally
 * {
 *   var morph = new mxMorphing(graph);
 *   morph.addListener(mxEvent.DONE, function()
 *   {
 *     graph.getModel().endUpdate();
 *   });
 *   
 *   morph.startAnimation();
 * }
 * (end)
 * 
 * Constructor: mxMorphing
 * 
 * Constructs an animation.
 * 
 * Parameters:
 * 
 * graph - Reference to the enclosing <mxGraph>.
 * steps - Optional number of steps in the morphing animation. Default is 6.
 * ease - Optional easing constant for the animation. Default is 1.5.
 * delay - Optional delay between the animation steps. Passed to <mxAnimation>.
 */
function mxMorphing(graph, steps, ease, delay)
{
\tmxAnimation.call(this, delay);
\tthis.graph = graph;
\tthis.steps = (steps != null) ? steps : 6;
\tthis.ease = (ease != null) ? ease : 1.5;
};

/**
 * Extends mxEventSource.
 */
mxMorphing.prototype = new mxAnimation();
mxMorphing.prototype.constructor = mxMorphing;

/**
 * Variable: graph
 * 
 * Specifies the delay between the animation steps. Defaul is 30ms.
 */
mxMorphing.prototype.graph = null;

/**
 * Variable: steps
 * 
 * Specifies the maximum number of steps for the morphing.
 */
mxMorphing.prototype.steps = null;

/**
 * Variable: step
 * 
 * Contains the current step.
 */
mxMorphing.prototype.step = 0;

/**
 * Variable: ease
 * 
 * Ease-off for movement towards the given vector. Larger values are
 * slower and smoother. Default is 4.
 */
mxMorphing.prototype.ease = null;

/**
 * Variable: cells
 * 
 * Optional array of cells to be animated. If this is not specified
 * then all cells are checked and animated if they have been moved
 * in the current transaction.
 */
mxMorphing.prototype.cells = null;

/**
 * Function: updateAnimation
 *
 * Animation step.
 */
mxMorphing.prototype.updateAnimation = function()
{
\tmxAnimation.prototype.updateAnimation.apply(this, arguments);
\tvar move = new mxCellStatePreview(this.graph);

\tif (this.cells != null)
\t{
\t\t// Animates the given cells individually without recursion
\t\tfor (var i = 0; i < this.cells.length; i++)
\t\t{
\t\t\tthis.animateCell(this.cells[i], move, false);
\t\t}
\t}
\telse
\t{
\t\t// Animates all changed cells by using recursion to find
\t\t// the changed cells but not for the animation itself
\t\tthis.animateCell(this.graph.getModel().getRoot(), move, true);
\t}
\t
\tthis.show(move);
\t
\tif (move.isEmpty() || this.step++ >= this.steps)
\t{
\t\tthis.stopAnimation();
\t}
};

/**
 * Function: show
 *
 * Shows the changes in the given <mxCellStatePreview>.
 */
mxMorphing.prototype.show = function(move)
{
\tmove.show();
};

/**
 * Function: animateCell
 *
 * Animates the given cell state using <mxCellStatePreview.moveState>.
 */
mxMorphing.prototype.animateCell = function(cell, move, recurse)
{
\tvar state = this.graph.getView().getState(cell);
\tvar delta = null;

\tif (state != null)
\t{
\t\t// Moves the animated state from where it will be after the model
\t\t// change by subtracting the given delta vector from that location
\t\tdelta = this.getDelta(state);

\t\tif (this.graph.getModel().isVertex(cell) && (delta.x != 0 || delta.y != 0))
\t\t{
\t\t\tvar translate = this.graph.view.getTranslate();
\t\t\tvar scale = this.graph.view.getScale();
\t\t\t
\t\t\tdelta.x += translate.x * scale;
\t\t\tdelta.y += translate.y * scale;
\t\t\t
\t\t\tmove.moveState(state, -delta.x / this.ease, -delta.y / this.ease);
\t\t}
\t}
\t
\tif (recurse && !this.stopRecursion(state, delta))
\t{
\t\tvar childCount = this.graph.getModel().getChildCount(cell);

\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\tthis.animateCell(this.graph.getModel().getChildAt(cell, i), move, recurse);
\t\t}
\t}
};

/**
 * Function: stopRecursion
 *
 * Returns true if the animation should not recursively find more
 * deltas for children if the given parent state has been animated.
 */
mxMorphing.prototype.stopRecursion = function(state, delta)
{
\treturn delta != null && (delta.x != 0 || delta.y != 0);
};

/**
 * Function: getDelta
 *
 * Returns the vector between the current rendered state and the future
 * location of the state after the display will be updated.
 */
mxMorphing.prototype.getDelta = function(state)
{
\tvar origin = this.getOriginForCell(state.cell);
\tvar translate = this.graph.getView().getTranslate();
\tvar scale = this.graph.getView().getScale();
\tvar x = state.x / scale - translate.x;
\tvar y = state.y / scale - translate.y;

\treturn new mxPoint((origin.x - x) * scale, (origin.y - y) * scale);
};

/**
 * Function: getOriginForCell
 *
 * Returns the top, left corner of the given cell. TODO: Improve performance
 * by using caching inside this method as the result per cell never changes
 * during the lifecycle of this object.
 */
mxMorphing.prototype.getOriginForCell = function(cell)
{
\tvar result = null;
\t
\tif (cell != null)
\t{
\t\tvar parent = this.graph.getModel().getParent(cell);
\t\tvar geo = this.graph.getCellGeometry(cell);
\t\tresult = this.getOriginForCell(parent);
\t\t
\t\t// TODO: Handle offsets
\t\tif (geo != null)
\t\t{
\t\t\tif (geo.relative)
\t\t\t{
\t\t\t\tvar pgeo = this.graph.getCellGeometry(parent);
\t\t\t\t
\t\t\t\tif (pgeo != null)
\t\t\t\t{
\t\t\t\t\tresult.x += geo.x * pgeo.width;
\t\t\t\t\tresult.y += geo.y * pgeo.height;
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tresult.x += geo.x;
\t\t\t\tresult.y += geo.y;
\t\t\t}
\t\t}
\t}
\t
\tif (result == null)
\t{
\t\tvar t = this.graph.view.getTranslate();
\t\tresult = new mxPoint(-t.x, -t.y);
\t}
\t
\treturn result;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxImageBundle
 *
 * Maps from keys to base64 encoded images or file locations. All values must
 * be URLs or use the format data:image/format followed by a comma and the base64
 * encoded image data, eg. \"data:image/gif,XYZ\", where XYZ is the base64 encoded
 * image data.
 * 
 * To add a new image bundle to an existing graph, the following code is used:
 * 
 * (code)
 * var bundle = new mxImageBundle(alt);
 * bundle.putImage('myImage', 'data:image/gif,R0lGODlhEAAQAMIGAAAAAICAAICAgP' +
 *   '//AOzp2O3r2////////yH+FUNyZWF0ZWQgd2l0aCBUaGUgR0lNUAAh+QQBCgAHACwAAAAA' +
 *   'EAAQAAADTXi63AowynnAMDfjPUDlnAAJhmeBFxAEloliKltWmiYCQvfVr6lBPB1ggxN1hi' +
 *   'laSSASFQpIV5HJBDyHpqK2ejVRm2AAgZCdmCGO9CIBADs=', fallback);
 * bundle.putImage('mySvgImage', 'data:image/svg+xml,' + encodeURIComponent(
 *   '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"100%\">' +
 *   '<linearGradient id=\"gradient\"><stop offset=\"10%\" stop-color=\"#F00\"/>' +
 *   '<stop offset=\"90%\" stop-color=\"#fcc\"/></linearGradient>' +
 *   '<rect fill=\"url(#gradient)\" width=\"100%\" height=\"100%\"/></svg>'), fallback);
 * graph.addImageBundle(bundle);
 * (end);
 * 
 * Alt is an optional boolean (default is false) that specifies if the value
 * or the fallback should be returned in <getImage>.
 * 
 * The image can then be referenced in any cell style using image=myImage.
 * If you are using mxOutline, you should use the same image bundles in the
 * graph that renders the outline.
 * 
 * The keys for images are resolved in <mxGraph.postProcessCellStyle> and
 * turned into a data URI if the returned value has a short data URI format
 * as specified above.
 * 
 * A typical value for the fallback is a MTHML link as defined in RFC 2557.
 * Note that this format requires a file to be dynamically created on the
 * server-side, or the page that contains the graph to be modified to contain
 * the resources, this can be done by adding a comment that contains the
 * resource in the HEAD section of the page after the title tag.
 * 
 * This type of fallback mechanism should be used in IE6 and IE7. IE8 does
 * support data URIs, but the maximum size is limited to 32 KB, which means
 * all data URIs should be limited to 32 KB.
 */
function mxImageBundle(alt)
{
\tthis.images = [];
\tthis.alt = (alt != null) ? alt : false;
};

/**
 * Variable: images
 * 
 * Maps from keys to images.
 */
mxImageBundle.prototype.images = null;

/**
 * Variable: alt
 * 
 * Specifies if the fallback representation should be returned.
 */
mxImageBundle.prototype.alt = null;

/**
 * Function: putImage
 * 
 * Adds the specified entry to the map. The entry is an object with a value and
 * fallback property as specified in the arguments.
 */
mxImageBundle.prototype.putImage = function(key, value, fallback)
{
\tthis.images[key] = {value: value, fallback: fallback};
};

/**
 * Function: getImage
 * 
 * Returns the value for the given key. This returns the value
 * or fallback, depending on <alt>. The fallback is returned if
 * <alt> is true, the value is returned otherwise.
 */
mxImageBundle.prototype.getImage = function(key)
{
\tvar result = null;
\t
\tif (key != null)
\t{
\t\tvar img = this.images[key];
\t\t
\t\tif (img != null)
\t\t{
\t\t\tresult = (this.alt) ? img.fallback : img.value;
\t\t}
\t}
\t
\treturn result;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxImageExport
 * 
 * Creates a new image export instance to be used with an export canvas. Here
 * is an example that uses this class to create an image via a backend using
 * <mxXmlExportCanvas>.
 * 
 * (code)
 * var xmlDoc = mxUtils.createXmlDocument();
 * var root = xmlDoc.createElement('output');
 * xmlDoc.appendChild(root);
 * 
 * var xmlCanvas = new mxXmlCanvas2D(root);
 * var imgExport = new mxImageExport();
 * imgExport.drawState(graph.getView().getState(graph.model.root), xmlCanvas);
 * 
 * var bounds = graph.getGraphBounds();
 * var w = Math.ceil(bounds.x + bounds.width);
 * var h = Math.ceil(bounds.y + bounds.height);
 * 
 * var xml = mxUtils.getXml(root);
 * new mxXmlRequest('export', 'format=png&w=' + w +
 * \t\t'&h=' + h + '&bg=#F9F7ED&xml=' + encodeURIComponent(xml))
 * \t\t.simulate(document, '_blank');
 * (end)
 * 
 * Constructor: mxImageExport
 * 
 * Constructs a new image export.
 */
function mxImageExport() { };

/**
 * Variable: includeOverlays
 * 
 * Specifies if overlays should be included in the export. Default is false.
 */
mxImageExport.prototype.includeOverlays = false;

/**
 * Function: drawState
 * 
 * Draws the given state and all its descendants to the given canvas.
 */
mxImageExport.prototype.drawState = function(state, canvas)
{
\tif (state != null)
\t{
\t\tthis.visitStatesRecursive(state, canvas, mxUtils.bind(this, function()
\t\t{
\t\t\tthis.drawCellState.apply(this, arguments);
\t\t}));
\t\t\t\t
\t\t// Paints the overlays
\t\tif (this.includeOverlays)
\t\t{
\t\t\tthis.visitStatesRecursive(state, canvas, mxUtils.bind(this, function()
\t\t\t{
\t\t\t\tthis.drawOverlays.apply(this, arguments);
\t\t\t}));
\t\t}
\t}
};

/**
 * Function: visitStatesRecursive
 * 
 * Visits the given state and all its descendants to the given canvas recursively.
 */
mxImageExport.prototype.visitStatesRecursive = function(state, canvas, visitor)
{
\tif (state != null)
\t{
\t\tvisitor(state, canvas);
\t\t
\t\tvar graph = state.view.graph;
\t\tvar childCount = graph.model.getChildCount(state.cell);
\t\t
\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\tvar childState = graph.view.getState(graph.model.getChildAt(state.cell, i));
\t\t\tthis.visitStatesRecursive(childState, canvas, visitor);
\t\t}
\t}
};

/**
 * Function: getLinkForCellState
 * 
 * Returns the link for the given cell state and canvas. This returns null.
 */
mxImageExport.prototype.getLinkForCellState = function(state, canvas)
{
\treturn null;
};

/**
 * Function: drawCellState
 * 
 * Draws the given state to the given canvas.
 */
mxImageExport.prototype.drawCellState = function(state, canvas)
{
\t// Experimental feature
\tvar link = this.getLinkForCellState(state, canvas);
\t
\tif (link != null)
\t{
\t\tcanvas.setLink(link);
\t}
\t
\t// Paints the shape and text
\tthis.drawShape(state, canvas);
\tthis.drawText(state, canvas);

\tif (link != null)
\t{
\t\tcanvas.setLink(null);
\t}
};

/**
 * Function: drawShape
 * 
 * Draws the shape of the given state.
 */
mxImageExport.prototype.drawShape = function(state, canvas)
{
\tif (state.shape instanceof mxShape && state.shape.checkBounds())
\t{
\t\tcanvas.save();
\t\t
\t\tstate.shape.beforePaint(canvas);
\t\tstate.shape.paint(canvas);
\t\tstate.shape.afterPaint(canvas);
\t\t
\t\tcanvas.restore();
\t}
};

/**
 * Function: drawText
 * 
 * Draws the text of the given state.
 */
mxImageExport.prototype.drawText = function(state, canvas)
{
\tif (state.text != null && state.text.checkBounds())
\t{
\t\tcanvas.save();
\t\t
\t\tstate.text.beforePaint(canvas);
\t\tstate.text.paint(canvas);
\t\tstate.text.afterPaint(canvas);
\t\t
\t\tcanvas.restore();
\t}
};

/**
 * Function: drawOverlays
 * 
 * Draws the overlays for the given state. This is called if <includeOverlays>
 * is true.
 */
mxImageExport.prototype.drawOverlays = function(state, canvas)
{
\tif (state.overlays != null)
\t{
\t\tstate.overlays.visit(function(id, shape)
\t\t{
\t\t\tif (shape instanceof mxShape)
\t\t\t{
\t\t\t\tshape.paint(canvas);
\t\t\t}
\t\t});
\t}
};

/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxAbstractCanvas2D
 *
 * Base class for all canvases. A description of the public API is available in <mxXmlCanvas2D>.
 * All color values of <mxConstants.NONE> will be converted to null in the state.
 * 
 * Constructor: mxAbstractCanvas2D
 *
 * Constructs a new abstract canvas.
 */
function mxAbstractCanvas2D()
{
\t/**
\t * Variable: converter
\t * 
\t * Holds the <mxUrlConverter> to convert image URLs.
\t */
\tthis.converter = this.createUrlConverter();
\t
\tthis.reset();
};

/**
 * Variable: state
 * 
 * Holds the current state.
 */
mxAbstractCanvas2D.prototype.state = null;

/**
 * Variable: states
 * 
 * Stack of states.
 */
mxAbstractCanvas2D.prototype.states = null;

/**
 * Variable: path
 * 
 * Holds the current path as an array.
 */
mxAbstractCanvas2D.prototype.path = null;

/**
 * Variable: rotateHtml
 * 
 * Switch for rotation of HTML. Default is false.
 */
mxAbstractCanvas2D.prototype.rotateHtml = true;

/**
 * Variable: lastX
 * 
 * Holds the last x coordinate.
 */
mxAbstractCanvas2D.prototype.lastX = 0;

/**
 * Variable: lastY
 * 
 * Holds the last y coordinate.
 */
mxAbstractCanvas2D.prototype.lastY = 0;

/**
 * Variable: moveOp
 * 
 * Contains the string used for moving in paths. Default is 'M'.
 */
mxAbstractCanvas2D.prototype.moveOp = 'M';

/**
 * Variable: lineOp
 * 
 * Contains the string used for moving in paths. Default is 'L'.
 */
mxAbstractCanvas2D.prototype.lineOp = 'L';

/**
 * Variable: quadOp
 * 
 * Contains the string used for quadratic paths. Default is 'Q'.
 */
mxAbstractCanvas2D.prototype.quadOp = 'Q';

/**
 * Variable: curveOp
 * 
 * Contains the string used for bezier curves. Default is 'C'.
 */
mxAbstractCanvas2D.prototype.curveOp = 'C';

/**
 * Variable: closeOp
 * 
 * Holds the operator for closing curves. Default is 'Z'.
 */
mxAbstractCanvas2D.prototype.closeOp = 'Z';

/**
 * Variable: pointerEvents
 * 
 * Boolean value that specifies if events should be handled. Default is false.
 */
mxAbstractCanvas2D.prototype.pointerEvents = false;

/**
 * Function: createUrlConverter
 * 
 * Create a new <mxUrlConverter> and returns it.
 */
mxAbstractCanvas2D.prototype.createUrlConverter = function()
{
\treturn new mxUrlConverter();
};

/**
 * Function: reset
 * 
 * Resets the state of this canvas.
 */
mxAbstractCanvas2D.prototype.reset = function()
{
\tthis.state = this.createState();
\tthis.states = [];
};

/**
 * Function: createState
 * 
 * Creates the state of the this canvas.
 */
mxAbstractCanvas2D.prototype.createState = function()
{
\treturn {
\t\tdx: 0,
\t\tdy: 0,
\t\tscale: 1,
\t\talpha: 1,
\t\tfillAlpha: 1,
\t\tstrokeAlpha: 1,
\t\tfillColor: null,
\t\tgradientFillAlpha: 1,
\t\tgradientColor: null,
\t\tgradientAlpha: 1,
\t\tgradientDirection: null,
\t\tstrokeColor: null,
\t\tstrokeWidth: 1,
\t\tdashed: false,
\t\tdashPattern: '3 3',
\t\tfixDash: false,
\t\tlineCap: 'flat',
\t\tlineJoin: 'miter',
\t\tmiterLimit: 10,
\t\tfontColor: '#000000',
\t\tfontBackgroundColor: null,
\t\tfontBorderColor: null,
\t\tfontSize: mxConstants.DEFAULT_FONTSIZE,
\t\tfontFamily: mxConstants.DEFAULT_FONTFAMILY,
\t\tfontStyle: 0,
\t\tshadow: false,
\t\tshadowColor: mxConstants.SHADOWCOLOR,
\t\tshadowAlpha: mxConstants.SHADOW_OPACITY,
\t\tshadowDx: mxConstants.SHADOW_OFFSET_X,
\t\tshadowDy: mxConstants.SHADOW_OFFSET_Y,
\t\trotation: 0,
\t\trotationCx: 0,
\t\trotationCy: 0
\t};
};

/**
 * Function: format
 * 
 * Rounds all numbers to integers.
 */
mxAbstractCanvas2D.prototype.format = function(value)
{
\treturn Math.round(parseFloat(value));
};

/**
 * Function: addOp
 * 
 * Adds the given operation to the path.
 */
mxAbstractCanvas2D.prototype.addOp = function()
{
\tif (this.path != null)
\t{
\t\tthis.path.push(arguments[0]);
\t\t
\t\tif (arguments.length > 2)
\t\t{
\t\t\tvar s = this.state;

\t\t\tfor (var i = 2; i < arguments.length; i += 2)
\t\t\t{
\t\t\t\tthis.lastX = arguments[i - 1];
\t\t\t\tthis.lastY = arguments[i];
\t\t\t\t
\t\t\t\tthis.path.push(this.format((this.lastX + s.dx) * s.scale));
\t\t\t\tthis.path.push(this.format((this.lastY + s.dy) * s.scale));
\t\t\t}
\t\t}
\t}
};

/**
 * Function: rotatePoint
 * 
 * Rotates the given point and returns the result as an <mxPoint>.
 */
mxAbstractCanvas2D.prototype.rotatePoint = function(x, y, theta, cx, cy)
{
\tvar rad = theta * (Math.PI / 180);
\t
\treturn mxUtils.getRotatedPoint(new mxPoint(x, y), Math.cos(rad),
\t\tMath.sin(rad), new mxPoint(cx, cy));
};

/**
 * Function: save
 * 
 * Saves the current state.
 */
mxAbstractCanvas2D.prototype.save = function()
{
\tthis.states.push(this.state);
\tthis.state = mxUtils.clone(this.state);
};

/**
 * Function: restore
 * 
 * Restores the current state.
 */
mxAbstractCanvas2D.prototype.restore = function()
{
\tif (this.states.length > 0)
\t{
\t\tthis.state = this.states.pop();
\t}
};

/**
 * Function: setLink
 * 
 * Sets the current link. Hook for subclassers.
 */
mxAbstractCanvas2D.prototype.setLink = function(link)
{
\t// nop
};

/**
 * Function: scale
 * 
 * Scales the current state.
 */
mxAbstractCanvas2D.prototype.scale = function(value)
{
\tthis.state.scale *= value;
\tthis.state.strokeWidth *= value;
};

/**
 * Function: translate
 * 
 * Translates the current state.
 */
mxAbstractCanvas2D.prototype.translate = function(dx, dy)
{
\tthis.state.dx += dx;
\tthis.state.dy += dy;
};

/**
 * Function: rotate
 * 
 * Rotates the current state.
 */
mxAbstractCanvas2D.prototype.rotate = function(theta, flipH, flipV, cx, cy)
{
\t// nop
};

/**
 * Function: setAlpha
 * 
 * Sets the current alpha.
 */
mxAbstractCanvas2D.prototype.setAlpha = function(value)
{
\tthis.state.alpha = value;
};

/**
 * Function: setFillAlpha
 * 
 * Sets the current solid fill alpha.
 */
mxAbstractCanvas2D.prototype.setFillAlpha = function(value)
{
\tthis.state.fillAlpha = value;
};

/**
 * Function: setStrokeAlpha
 * 
 * Sets the current stroke alpha.
 */
mxAbstractCanvas2D.prototype.setStrokeAlpha = function(value)
{
\tthis.state.strokeAlpha = value;
};

/**
 * Function: setFillColor
 * 
 * Sets the current fill color.
 */
mxAbstractCanvas2D.prototype.setFillColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tthis.state.fillColor = value;
\tthis.state.gradientColor = null;
};

/**
 * Function: setGradient
 * 
 * Sets the current gradient.
 */
mxAbstractCanvas2D.prototype.setGradient = function(color1, color2, x, y, w, h, direction, alpha1, alpha2)
{
\tvar s = this.state;
\ts.fillColor = color1;
\ts.gradientFillAlpha = (alpha1 != null) ? alpha1 : 1;
\ts.gradientColor = color2;
\ts.gradientAlpha = (alpha2 != null) ? alpha2 : 1;
\ts.gradientDirection = direction;
};

/**
 * Function: setStrokeColor
 * 
 * Sets the current stroke color.
 */
mxAbstractCanvas2D.prototype.setStrokeColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tthis.state.strokeColor = value;
};

/**
 * Function: setStrokeWidth
 * 
 * Sets the current stroke width.
 */
mxAbstractCanvas2D.prototype.setStrokeWidth = function(value)
{
\tthis.state.strokeWidth = value;
};

/**
 * Function: setDashed
 * 
 * Enables or disables dashed lines.
 */
mxAbstractCanvas2D.prototype.setDashed = function(value, fixDash)
{
\tthis.state.dashed = value;
\tthis.state.fixDash = fixDash;
};

/**
 * Function: setDashPattern
 * 
 * Sets the current dash pattern.
 */
mxAbstractCanvas2D.prototype.setDashPattern = function(value)
{
\tthis.state.dashPattern = value;
};

/**
 * Function: setLineCap
 * 
 * Sets the current line cap.
 */
mxAbstractCanvas2D.prototype.setLineCap = function(value)
{
\tthis.state.lineCap = value;
};

/**
 * Function: setLineJoin
 * 
 * Sets the current line join.
 */
mxAbstractCanvas2D.prototype.setLineJoin = function(value)
{
\tthis.state.lineJoin = value;
};

/**
 * Function: setMiterLimit
 * 
 * Sets the current miter limit.
 */
mxAbstractCanvas2D.prototype.setMiterLimit = function(value)
{
\tthis.state.miterLimit = value;
};

/**
 * Function: setFontColor
 * 
 * Sets the current font color.
 */
mxAbstractCanvas2D.prototype.setFontColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tthis.state.fontColor = value;
};

/**
 * Function: setFontBackgroundColor
 * 
 * Sets the current font background color.
 */
mxAbstractCanvas2D.prototype.setFontBackgroundColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tthis.state.fontBackgroundColor = value;
};

/**
 * Function: setFontBorderColor
 * 
 * Sets the current font border color.
 */
mxAbstractCanvas2D.prototype.setFontBorderColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tthis.state.fontBorderColor = value;
};

/**
 * Function: setFontSize
 * 
 * Sets the current font size.
 */
mxAbstractCanvas2D.prototype.setFontSize = function(value)
{
\tthis.state.fontSize = parseFloat(value);
};

/**
 * Function: setFontFamily
 * 
 * Sets the current font family.
 */
mxAbstractCanvas2D.prototype.setFontFamily = function(value)
{
\tthis.state.fontFamily = value;
};

/**
 * Function: setFontStyle
 * 
 * Sets the current font style.
 */
mxAbstractCanvas2D.prototype.setFontStyle = function(value)
{
\tif (value == null)
\t{
\t\tvalue = 0;
\t}
\t
\tthis.state.fontStyle = value;
};

/**
 * Function: setShadow
 * 
 * Enables or disables and configures the current shadow.
 */
mxAbstractCanvas2D.prototype.setShadow = function(enabled)
{
\tthis.state.shadow = enabled;
};

/**
 * Function: setShadowColor
 * 
 * Enables or disables and configures the current shadow.
 */
mxAbstractCanvas2D.prototype.setShadowColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tthis.state.shadowColor = value;
};

/**
 * Function: setShadowAlpha
 * 
 * Enables or disables and configures the current shadow.
 */
mxAbstractCanvas2D.prototype.setShadowAlpha = function(value)
{
\tthis.state.shadowAlpha = value;
};

/**
 * Function: setShadowOffset
 * 
 * Enables or disables and configures the current shadow.
 */
mxAbstractCanvas2D.prototype.setShadowOffset = function(dx, dy)
{
\tthis.state.shadowDx = dx;
\tthis.state.shadowDy = dy;
};

/**
 * Function: begin
 * 
 * Starts a new path.
 */
mxAbstractCanvas2D.prototype.begin = function()
{
\tthis.lastX = 0;
\tthis.lastY = 0;
\tthis.path = [];
};

/**
 * Function: moveTo
 * 
 *  Moves the current path the given coordinates.
 */
mxAbstractCanvas2D.prototype.moveTo = function(x, y)
{
\tthis.addOp(this.moveOp, x, y);
};

/**
 * Function: lineTo
 * 
 * Draws a line to the given coordinates. Uses moveTo with the op argument.
 */
mxAbstractCanvas2D.prototype.lineTo = function(x, y)
{
\tthis.addOp(this.lineOp, x, y);
};

/**
 * Function: quadTo
 * 
 * Adds a quadratic curve to the current path.
 */
mxAbstractCanvas2D.prototype.quadTo = function(x1, y1, x2, y2)
{
\tthis.addOp(this.quadOp, x1, y1, x2, y2);
};

/**
 * Function: curveTo
 * 
 * Adds a bezier curve to the current path.
 */
mxAbstractCanvas2D.prototype.curveTo = function(x1, y1, x2, y2, x3, y3)
{
\tthis.addOp(this.curveOp, x1, y1, x2, y2, x3, y3);
};

/**
 * Function: arcTo
 * 
 * Adds the given arc to the current path. This is a synthetic operation that
 * is broken down into curves.
 */
mxAbstractCanvas2D.prototype.arcTo = function(rx, ry, angle, largeArcFlag, sweepFlag, x, y)
{
\tvar curves = mxUtils.arcToCurves(this.lastX, this.lastY, rx, ry, angle, largeArcFlag, sweepFlag, x, y);
\t
\tif (curves != null)
\t{
\t\tfor (var i = 0; i < curves.length; i += 6) 
\t\t{
\t\t\tthis.curveTo(curves[i], curves[i + 1], curves[i + 2],
\t\t\t\tcurves[i + 3], curves[i + 4], curves[i + 5]);
\t\t}
\t}
};

/**
 * Function: close
 * 
 * Closes the current path.
 */
mxAbstractCanvas2D.prototype.close = function(x1, y1, x2, y2, x3, y3)
{
\tthis.addOp(this.closeOp);
};

/**
 * Function: end
 * 
 * Empty implementation for backwards compatibility. This will be removed.
 */
mxAbstractCanvas2D.prototype.end = function() { };
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxXmlCanvas2D
 *
 * Base class for all canvases. The following methods make up the public
 * interface of the canvas 2D for all painting in mxGraph:
 * 
 * - <save>, <restore>
 * - <scale>, <translate>, <rotate>
 * - <setAlpha>, <setFillAlpha>, <setStrokeAlpha>, <setFillColor>, <setGradient>,
 *   <setStrokeColor>, <setStrokeWidth>, <setDashed>, <setDashPattern>, <setLineCap>, 
 *   <setLineJoin>, <setMiterLimit>
 * - <setFontColor>, <setFontBackgroundColor>, <setFontBorderColor>, <setFontSize>,
 *   <setFontFamily>, <setFontStyle>
 * - <setShadow>, <setShadowColor>, <setShadowAlpha>, <setShadowOffset>
 * - <rect>, <roundrect>, <ellipse>, <image>, <text>
 * - <begin>, <moveTo>, <lineTo>, <quadTo>, <curveTo>
 * - <stroke>, <fill>, <fillAndStroke>
 * 
 * <mxAbstractCanvas2D.arcTo> is an additional method for drawing paths. This is
 * a synthetic method, meaning that it is turned into a sequence of curves by
 * default. Subclassers may add native support for arcs.
 * 
 * Constructor: mxXmlCanvas2D
 *
 * Constructs a new abstract canvas.
 */
function mxXmlCanvas2D(root)
{
\tmxAbstractCanvas2D.call(this);

\t/**
\t * Variable: root
\t * 
\t * Reference to the container for the SVG content.
\t */
\tthis.root = root;

\t// Writes default settings;
\tthis.writeDefaults();
};

/**
 * Extends mxAbstractCanvas2D
 */
mxUtils.extend(mxXmlCanvas2D, mxAbstractCanvas2D);

/**
 * Variable: textEnabled
 * 
 * Specifies if text output should be enabled. Default is true.
 */
mxXmlCanvas2D.prototype.textEnabled = true;

/**
 * Variable: compressed
 * 
 * Specifies if the output should be compressed by removing redundant calls.
 * Default is true.
 */
mxXmlCanvas2D.prototype.compressed = true;

/**
 * Function: writeDefaults
 * 
 * Writes the rendering defaults to <root>:
 */
mxXmlCanvas2D.prototype.writeDefaults = function()
{
\tvar elem;
\t
\t// Writes font defaults
\telem = this.createElement('fontfamily');
\telem.setAttribute('family', mxConstants.DEFAULT_FONTFAMILY);
\tthis.root.appendChild(elem);
\t
\telem = this.createElement('fontsize');
\telem.setAttribute('size', mxConstants.DEFAULT_FONTSIZE);
\tthis.root.appendChild(elem);
\t
\t// Writes shadow defaults
\telem = this.createElement('shadowcolor');
\telem.setAttribute('color', mxConstants.SHADOWCOLOR);
\tthis.root.appendChild(elem);
\t
\telem = this.createElement('shadowalpha');
\telem.setAttribute('alpha', mxConstants.SHADOW_OPACITY);
\tthis.root.appendChild(elem);
\t
\telem = this.createElement('shadowoffset');
\telem.setAttribute('dx', mxConstants.SHADOW_OFFSET_X);
\telem.setAttribute('dy', mxConstants.SHADOW_OFFSET_Y);
\tthis.root.appendChild(elem);
};

/**
 * Function: format
 * 
 * Returns a formatted number with 2 decimal places.
 */
mxXmlCanvas2D.prototype.format = function(value)
{
\treturn parseFloat(parseFloat(value).toFixed(2));
};

/**
 * Function: createElement
 * 
 * Creates the given element using the owner document of <root>.
 */
mxXmlCanvas2D.prototype.createElement = function(name)
{
\treturn this.root.ownerDocument.createElement(name);
};

/**
 * Function: save
 * 
 * Saves the drawing state.
 */
mxXmlCanvas2D.prototype.save = function()
{
\tif (this.compressed)
\t{
\t\tmxAbstractCanvas2D.prototype.save.apply(this, arguments);
\t}
\t
\tthis.root.appendChild(this.createElement('save'));
};

/**
 * Function: restore
 * 
 * Restores the drawing state.
 */
mxXmlCanvas2D.prototype.restore = function()
{
\tif (this.compressed)
\t{
\t\tmxAbstractCanvas2D.prototype.restore.apply(this, arguments);
\t}
\t
\tthis.root.appendChild(this.createElement('restore'));
};

/**
 * Function: scale
 * 
 * Scales the output.
 * 
 * Parameters:
 * 
 * scale - Number that represents the scale where 1 is equal to 100%.
 */
mxXmlCanvas2D.prototype.scale = function(value)
{
        var elem = this.createElement('scale');
        elem.setAttribute('scale', value);
        this.root.appendChild(elem);
};

/**
 * Function: translate
 * 
 * Translates the output.
 * 
 * Parameters:
 * 
 * dx - Number that specifies the horizontal translation.
 * dy - Number that specifies the vertical translation.
 */
mxXmlCanvas2D.prototype.translate = function(dx, dy)
{
\tvar elem = this.createElement('translate');
\telem.setAttribute('dx', this.format(dx));
\telem.setAttribute('dy', this.format(dy));
\tthis.root.appendChild(elem);
};

/**
 * Function: rotate
 * 
 * Rotates and/or flips the output around a given center. (Note: Due to
 * limitations in VML, the rotation cannot be concatenated.)
 * 
 * Parameters:
 * 
 * theta - Number that represents the angle of the rotation (in degrees).
 * flipH - Boolean indicating if the output should be flipped horizontally.
 * flipV - Boolean indicating if the output should be flipped vertically.
 * cx - Number that represents the x-coordinate of the rotation center.
 * cy - Number that represents the y-coordinate of the rotation center.
 */
mxXmlCanvas2D.prototype.rotate = function(theta, flipH, flipV, cx, cy)
{
\tvar elem = this.createElement('rotate');
\t
\tif (theta != 0 || flipH || flipV)
\t{
\t\telem.setAttribute('theta', this.format(theta));
\t\telem.setAttribute('flipH', (flipH) ? '1' : '0');
\t\telem.setAttribute('flipV', (flipV) ? '1' : '0');
\t\telem.setAttribute('cx', this.format(cx));
\t\telem.setAttribute('cy', this.format(cy));
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setAlpha
 * 
 * Sets the current alpha.
 * 
 * Parameters:
 * 
 * value - Number that represents the new alpha. Possible values are between
 * 1 (opaque) and 0 (transparent).
 */
mxXmlCanvas2D.prototype.setAlpha = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.alpha == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setAlpha.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('alpha');
\telem.setAttribute('alpha', this.format(value));
\tthis.root.appendChild(elem);
};

/**
 * Function: setFillAlpha
 * 
 * Sets the current fill alpha.
 * 
 * Parameters:
 * 
 * value - Number that represents the new fill alpha. Possible values are between
 * 1 (opaque) and 0 (transparent).
 */
mxXmlCanvas2D.prototype.setFillAlpha = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.fillAlpha == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setFillAlpha.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('fillalpha');
\telem.setAttribute('alpha', this.format(value));
\tthis.root.appendChild(elem);
};

/**
 * Function: setStrokeAlpha
 * 
 * Sets the current stroke alpha.
 * 
 * Parameters:
 * 
 * value - Number that represents the new stroke alpha. Possible values are between
 * 1 (opaque) and 0 (transparent).
 */
mxXmlCanvas2D.prototype.setStrokeAlpha = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.strokeAlpha == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setStrokeAlpha.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('strokealpha');
\telem.setAttribute('alpha', this.format(value));
\tthis.root.appendChild(elem);
};

/**
 * Function: setFillColor
 * 
 * Sets the current fill color.
 * 
 * Parameters:
 * 
 * value - Hexadecimal representation of the color or 'none'.
 */
mxXmlCanvas2D.prototype.setFillColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tif (this.compressed)
\t{
\t\tif (this.state.fillColor == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setFillColor.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('fillcolor');
\telem.setAttribute('color', (value != null) ? value : mxConstants.NONE);
\tthis.root.appendChild(elem);
};

/**
 * Function: setGradient
 * 
 * Sets the gradient. Note that the coordinates may be ignored by some implementations.
 * 
 * Parameters:
 * 
 * color1 - Hexadecimal representation of the start color.
 * color2 - Hexadecimal representation of the end color.
 * x - X-coordinate of the gradient region.
 * y - y-coordinate of the gradient region.
 * w - Width of the gradient region.
 * h - Height of the gradient region.
 * direction - One of <mxConstants.DIRECTION_NORTH>, <mxConstants.DIRECTION_EAST>,
 * <mxConstants.DIRECTION_SOUTH> or <mxConstants.DIRECTION_WEST>.
 * alpha1 - Optional alpha of the start color. Default is 1. Possible values
 * are between 1 (opaque) and 0 (transparent).
 * alpha2 - Optional alpha of the end color. Default is 1. Possible values
 * are between 1 (opaque) and 0 (transparent).
 */
mxXmlCanvas2D.prototype.setGradient = function(color1, color2, x, y, w, h, direction, alpha1, alpha2)
{
\tif (color1 != null && color2 != null)
\t{
\t\tmxAbstractCanvas2D.prototype.setGradient.apply(this, arguments);
\t\t
\t\tvar elem = this.createElement('gradient');
\t\telem.setAttribute('c1', color1);
\t\telem.setAttribute('c2', color2);
\t\telem.setAttribute('x', this.format(x));
\t\telem.setAttribute('y', this.format(y));
\t\telem.setAttribute('w', this.format(w));
\t\telem.setAttribute('h', this.format(h));
\t\t
\t\t// Default direction is south
\t\tif (direction != null)
\t\t{
\t\t\telem.setAttribute('direction', direction);
\t\t}
\t\t
\t\tif (alpha1 != null)
\t\t{
\t\t\telem.setAttribute('alpha1', alpha1);
\t\t}
\t\t
\t\tif (alpha2 != null)
\t\t{
\t\t\telem.setAttribute('alpha2', alpha2);
\t\t}
\t\t
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setStrokeColor
 * 
 * Sets the current stroke color.
 * 
 * Parameters:
 * 
 * value - Hexadecimal representation of the color or 'none'.
 */
mxXmlCanvas2D.prototype.setStrokeColor = function(value)
{
\tif (value == mxConstants.NONE)
\t{
\t\tvalue = null;
\t}
\t
\tif (this.compressed)
\t{
\t\tif (this.state.strokeColor == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setStrokeColor.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('strokecolor');
\telem.setAttribute('color', (value != null) ? value : mxConstants.NONE);
\tthis.root.appendChild(elem);
};

/**
 * Function: setStrokeWidth
 * 
 * Sets the current stroke width.
 * 
 * Parameters:
 * 
 * value - Numeric representation of the stroke width.
 */
mxXmlCanvas2D.prototype.setStrokeWidth = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.strokeWidth == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setStrokeWidth.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('strokewidth');
\telem.setAttribute('width', this.format(value));
\tthis.root.appendChild(elem);
};

/**
 * Function: setDashed
 * 
 * Enables or disables dashed lines.
 * 
 * Parameters:
 * 
 * value - Boolean that specifies if dashed lines should be enabled.
 * value - Boolean that specifies if the stroke width should be ignored
 * for the dash pattern. Default is false.
 */
mxXmlCanvas2D.prototype.setDashed = function(value, fixDash)
{
\tif (this.compressed)
\t{
\t\tif (this.state.dashed == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setDashed.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('dashed');
\telem.setAttribute('dashed', (value) ? '1' : '0');
\t
\tif (fixDash != null)
\t{
\t\telem.setAttribute('fixDash', (fixDash) ? '1' : '0');
\t}
\t
\tthis.root.appendChild(elem);
};

/**
 * Function: setDashPattern
 * 
 * Sets the current dash pattern. Default is '3 3'.
 * 
 * Parameters:
 * 
 * value - String that represents the dash pattern, which is a sequence of
 * numbers defining the length of the dashes and the length of the spaces
 * between the dashes. The lengths are relative to the line width - a length
 * of 1 is equals to the line width.
 */
mxXmlCanvas2D.prototype.setDashPattern = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.dashPattern == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setDashPattern.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('dashpattern');
\telem.setAttribute('pattern', value);
\tthis.root.appendChild(elem);
};

/**
 * Function: setLineCap
 * 
 * Sets the line cap. Default is 'flat' which corresponds to 'butt' in SVG.
 * 
 * Parameters:
 * 
 * value - String that represents the line cap. Possible values are flat, round
 * and square.
 */
mxXmlCanvas2D.prototype.setLineCap = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.lineCap == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setLineCap.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('linecap');
\telem.setAttribute('cap', value);
\tthis.root.appendChild(elem);
};

/**
 * Function: setLineJoin
 * 
 * Sets the line join. Default is 'miter'.
 * 
 * Parameters:
 * 
 * value - String that represents the line join. Possible values are miter,
 * round and bevel.
 */
mxXmlCanvas2D.prototype.setLineJoin = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.lineJoin == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setLineJoin.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('linejoin');
\telem.setAttribute('join', value);
\tthis.root.appendChild(elem);
};

/**
 * Function: setMiterLimit
 * 
 * Sets the miter limit. Default is 10.
 * 
 * Parameters:
 * 
 * value - Number that represents the miter limit.
 */
mxXmlCanvas2D.prototype.setMiterLimit = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.miterLimit == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setMiterLimit.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('miterlimit');
\telem.setAttribute('limit', value);
\tthis.root.appendChild(elem);
};

/**
 * Function: setFontColor
 * 
 * Sets the current font color. Default is '#000000'.
 * 
 * Parameters:
 * 
 * value - Hexadecimal representation of the color or 'none'.
 */
mxXmlCanvas2D.prototype.setFontColor = function(value)
{
\tif (this.textEnabled)
\t{
\t\tif (value == mxConstants.NONE)
\t\t{
\t\t\tvalue = null;
\t\t}
\t\t
\t\tif (this.compressed)
\t\t{
\t\t\tif (this.state.fontColor == value)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\tmxAbstractCanvas2D.prototype.setFontColor.apply(this, arguments);
\t\t}
\t\t
\t\tvar elem = this.createElement('fontcolor');
\t\telem.setAttribute('color', (value != null) ? value : mxConstants.NONE);
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setFontBackgroundColor
 * 
 * Sets the current font background color.
 * 
 * Parameters:
 * 
 * value - Hexadecimal representation of the color or 'none'.
 */
mxXmlCanvas2D.prototype.setFontBackgroundColor = function(value)
{
\tif (this.textEnabled)
\t{
\t\tif (value == mxConstants.NONE)
\t\t{
\t\t\tvalue = null;
\t\t}
\t\t
\t\tif (this.compressed)
\t\t{
\t\t\tif (this.state.fontBackgroundColor == value)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\tmxAbstractCanvas2D.prototype.setFontBackgroundColor.apply(this, arguments);
\t\t}

\t\tvar elem = this.createElement('fontbackgroundcolor');
\t\telem.setAttribute('color', (value != null) ? value : mxConstants.NONE);
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setFontBorderColor
 * 
 * Sets the current font border color.
 * 
 * Parameters:
 * 
 * value - Hexadecimal representation of the color or 'none'.
 */
mxXmlCanvas2D.prototype.setFontBorderColor = function(value)
{
\tif (this.textEnabled)
\t{
\t\tif (value == mxConstants.NONE)
\t\t{
\t\t\tvalue = null;
\t\t}
\t\t
\t\tif (this.compressed)
\t\t{
\t\t\tif (this.state.fontBorderColor == value)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\tmxAbstractCanvas2D.prototype.setFontBorderColor.apply(this, arguments);
\t\t}
\t\t
\t\tvar elem = this.createElement('fontbordercolor');
\t\telem.setAttribute('color', (value != null) ? value : mxConstants.NONE);
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setFontSize
 * 
 * Sets the current font size. Default is <mxConstants.DEFAULT_FONTSIZE>.
 * 
 * Parameters:
 * 
 * value - Numeric representation of the font size.
 */
mxXmlCanvas2D.prototype.setFontSize = function(value)
{
\tif (this.textEnabled)
\t{
\t\tif (this.compressed)
\t\t{
\t\t\tif (this.state.fontSize == value)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\tmxAbstractCanvas2D.prototype.setFontSize.apply(this, arguments);
\t\t}
\t\t
\t\tvar elem = this.createElement('fontsize');
\t\telem.setAttribute('size', value);
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setFontFamily
 * 
 * Sets the current font family. Default is <mxConstants.DEFAULT_FONTFAMILY>.
 * 
 * Parameters:
 * 
 * value - String representation of the font family. This handles the same
 * values as the CSS font-family property.
 */
mxXmlCanvas2D.prototype.setFontFamily = function(value)
{
\tif (this.textEnabled)
\t{
\t\tif (this.compressed)
\t\t{
\t\t\tif (this.state.fontFamily == value)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\tmxAbstractCanvas2D.prototype.setFontFamily.apply(this, arguments);
\t\t}
\t\t
\t\tvar elem = this.createElement('fontfamily');
\t\telem.setAttribute('family', value);
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setFontStyle
 * 
 * Sets the current font style.
 * 
 * Parameters:
 * 
 * value - Numeric representation of the font family. This is the sum of the
 * font styles from <mxConstants>.
 */
mxXmlCanvas2D.prototype.setFontStyle = function(value)
{
\tif (this.textEnabled)
\t{
\t\tif (value == null)
\t\t{
\t\t\tvalue = 0;
\t\t}
\t\t
\t\tif (this.compressed)
\t\t{
\t\t\tif (this.state.fontStyle == value)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\tmxAbstractCanvas2D.prototype.setFontStyle.apply(this, arguments);
\t\t}
\t\t
\t\tvar elem = this.createElement('fontstyle');
\t\telem.setAttribute('style', value);
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: setShadow
 * 
 * Enables or disables shadows.
 * 
 * Parameters:
 * 
 * value - Boolean that specifies if shadows should be enabled.
 */
mxXmlCanvas2D.prototype.setShadow = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.shadow == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setShadow.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('shadow');
\telem.setAttribute('enabled', (value) ? '1' : '0');
\tthis.root.appendChild(elem);
};

/**
 * Function: setShadowColor
 * 
 * Sets the current shadow color. Default is <mxConstants.SHADOWCOLOR>.
 * 
 * Parameters:
 * 
 * value - Hexadecimal representation of the color or 'none'.
 */
mxXmlCanvas2D.prototype.setShadowColor = function(value)
{
\tif (this.compressed)
\t{
\t\tif (value == mxConstants.NONE)
\t\t{
\t\t\tvalue = null;
\t\t}
\t\t
\t\tif (this.state.shadowColor == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setShadowColor.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('shadowcolor');
\telem.setAttribute('color', (value != null) ? value : mxConstants.NONE);
\tthis.root.appendChild(elem);
};

/**
 * Function: setShadowAlpha
 * 
 * Sets the current shadows alpha. Default is <mxConstants.SHADOW_OPACITY>.
 * 
 * Parameters:
 * 
 * value - Number that represents the new alpha. Possible values are between
 * 1 (opaque) and 0 (transparent).
 */
mxXmlCanvas2D.prototype.setShadowAlpha = function(value)
{
\tif (this.compressed)
\t{
\t\tif (this.state.shadowAlpha == value)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setShadowAlpha.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('shadowalpha');
\telem.setAttribute('alpha', value);
\tthis.root.appendChild(elem);
\t
};

/**
 * Function: setShadowOffset
 * 
 * Sets the current shadow offset.
 * 
 * Parameters:
 * 
 * dx - Number that represents the horizontal offset of the shadow.
 * dy - Number that represents the vertical offset of the shadow.
 */
mxXmlCanvas2D.prototype.setShadowOffset = function(dx, dy)
{
\tif (this.compressed)
\t{
\t\tif (this.state.shadowDx == dx && this.state.shadowDy == dy)
\t\t{
\t\t\treturn;
\t\t}
\t\t
\t\tmxAbstractCanvas2D.prototype.setShadowOffset.apply(this, arguments);
\t}
\t
\tvar elem = this.createElement('shadowoffset');
\telem.setAttribute('dx', dx);
\telem.setAttribute('dy', dy);
\tthis.root.appendChild(elem);
\t
};

/**
 * Function: rect
 * 
 * Puts a rectangle into the drawing buffer.
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the rectangle.
 * y - Number that represents the y-coordinate of the rectangle.
 * w - Number that represents the width of the rectangle.
 * h - Number that represents the height of the rectangle.
 */
mxXmlCanvas2D.prototype.rect = function(x, y, w, h)
{
\tvar elem = this.createElement('rect');
\telem.setAttribute('x', this.format(x));
\telem.setAttribute('y', this.format(y));
\telem.setAttribute('w', this.format(w));
\telem.setAttribute('h', this.format(h));
\tthis.root.appendChild(elem);
};

/**
 * Function: roundrect
 * 
 * Puts a rounded rectangle into the drawing buffer.
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the rectangle.
 * y - Number that represents the y-coordinate of the rectangle.
 * w - Number that represents the width of the rectangle.
 * h - Number that represents the height of the rectangle.
 * dx - Number that represents the horizontal rounding.
 * dy - Number that represents the vertical rounding.
 */
mxXmlCanvas2D.prototype.roundrect = function(x, y, w, h, dx, dy)
{
\tvar elem = this.createElement('roundrect');
\telem.setAttribute('x', this.format(x));
\telem.setAttribute('y', this.format(y));
\telem.setAttribute('w', this.format(w));
\telem.setAttribute('h', this.format(h));
\telem.setAttribute('dx', this.format(dx));
\telem.setAttribute('dy', this.format(dy));
\tthis.root.appendChild(elem);
};

/**
 * Function: ellipse
 * 
 * Puts an ellipse into the drawing buffer.
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the ellipse.
 * y - Number that represents the y-coordinate of the ellipse.
 * w - Number that represents the width of the ellipse.
 * h - Number that represents the height of the ellipse.
 */
mxXmlCanvas2D.prototype.ellipse = function(x, y, w, h)
{
\tvar elem = this.createElement('ellipse');
\telem.setAttribute('x', this.format(x));
\telem.setAttribute('y', this.format(y));
\telem.setAttribute('w', this.format(w));
\telem.setAttribute('h', this.format(h));
\tthis.root.appendChild(elem);
};

/**
 * Function: image
 * 
 * Paints an image.
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the image.
 * y - Number that represents the y-coordinate of the image.
 * w - Number that represents the width of the image.
 * h - Number that represents the height of the image.
 * src - String that specifies the URL of the image.
 * aspect - Boolean indicating if the aspect of the image should be preserved.
 * flipH - Boolean indicating if the image should be flipped horizontally.
 * flipV - Boolean indicating if the image should be flipped vertically.
 */
mxXmlCanvas2D.prototype.image = function(x, y, w, h, src, aspect, flipH, flipV)
{
\tsrc = this.converter.convert(src);
\t
\t// LATER: Add option for embedding images as base64.
\tvar elem = this.createElement('image');
\telem.setAttribute('x', this.format(x));
\telem.setAttribute('y', this.format(y));
\telem.setAttribute('w', this.format(w));
\telem.setAttribute('h', this.format(h));
\telem.setAttribute('src', src);
\telem.setAttribute('aspect', (aspect) ? '1' : '0');
\telem.setAttribute('flipH', (flipH) ? '1' : '0');
\telem.setAttribute('flipV', (flipV) ? '1' : '0');
\tthis.root.appendChild(elem);
};

/**
 * Function: begin
 * 
 * Starts a new path and puts it into the drawing buffer.
 */
mxXmlCanvas2D.prototype.begin = function()
{
\tthis.root.appendChild(this.createElement('begin'));
\tthis.lastX = 0;
\tthis.lastY = 0;
};

/**
 * Function: moveTo
 * 
 * Moves the current path the given point.
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the point.
 * y - Number that represents the y-coordinate of the point.
 */
mxXmlCanvas2D.prototype.moveTo = function(x, y)
{
\tvar elem = this.createElement('move');
\telem.setAttribute('x', this.format(x));
\telem.setAttribute('y', this.format(y));
\tthis.root.appendChild(elem);
\tthis.lastX = x;
\tthis.lastY = y;
};

/**
 * Function: lineTo
 * 
 * Draws a line to the given coordinates.
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the endpoint.
 * y - Number that represents the y-coordinate of the endpoint.
 */
mxXmlCanvas2D.prototype.lineTo = function(x, y)
{
\tvar elem = this.createElement('line');
\telem.setAttribute('x', this.format(x));
\telem.setAttribute('y', this.format(y));
\tthis.root.appendChild(elem);
\tthis.lastX = x;
\tthis.lastY = y;
};

/**
 * Function: quadTo
 * 
 * Adds a quadratic curve to the current path.
 * 
 * Parameters:
 * 
 * x1 - Number that represents the x-coordinate of the control point.
 * y1 - Number that represents the y-coordinate of the control point.
 * x2 - Number that represents the x-coordinate of the endpoint.
 * y2 - Number that represents the y-coordinate of the endpoint.
 */
mxXmlCanvas2D.prototype.quadTo = function(x1, y1, x2, y2)
{
\tvar elem = this.createElement('quad');
\telem.setAttribute('x1', this.format(x1));
\telem.setAttribute('y1', this.format(y1));
\telem.setAttribute('x2', this.format(x2));
\telem.setAttribute('y2', this.format(y2));
\tthis.root.appendChild(elem);
\tthis.lastX = x2;
\tthis.lastY = y2;
};

/**
 * Function: curveTo
 * 
 * Adds a bezier curve to the current path.
 * 
 * Parameters:
 * 
 * x1 - Number that represents the x-coordinate of the first control point.
 * y1 - Number that represents the y-coordinate of the first control point.
 * x2 - Number that represents the x-coordinate of the second control point.
 * y2 - Number that represents the y-coordinate of the second control point.
 * x3 - Number that represents the x-coordinate of the endpoint.
 * y3 - Number that represents the y-coordinate of the endpoint.
 */
mxXmlCanvas2D.prototype.curveTo = function(x1, y1, x2, y2, x3, y3)
{
\tvar elem = this.createElement('curve');
\telem.setAttribute('x1', this.format(x1));
\telem.setAttribute('y1', this.format(y1));
\telem.setAttribute('x2', this.format(x2));
\telem.setAttribute('y2', this.format(y2));
\telem.setAttribute('x3', this.format(x3));
\telem.setAttribute('y3', this.format(y3));
\tthis.root.appendChild(elem);
\tthis.lastX = x3;
\tthis.lastY = y3;
};

/**
 * Function: close
 * 
 * Closes the current path.
 */
mxXmlCanvas2D.prototype.close = function()
{
\tthis.root.appendChild(this.createElement('close'));
};

/**
 * Function: text
 * 
 * Paints the given text. Possible values for format are empty string for
 * plain text and html for HTML markup. Background and border color as well
 * as clipping is not available in plain text labels for VML. HTML labels
 * are not available as part of shapes with no foreignObject support in SVG
 * (eg. IE9, IE10).
 * 
 * Parameters:
 * 
 * x - Number that represents the x-coordinate of the text.
 * y - Number that represents the y-coordinate of the text.
 * w - Number that represents the available width for the text or 0 for automatic width.
 * h - Number that represents the available height for the text or 0 for automatic height.
 * str - String that specifies the text to be painted.
 * align - String that represents the horizontal alignment.
 * valign - String that represents the vertical alignment.
 * wrap - Boolean that specifies if word-wrapping is enabled. Requires w > 0.
 * format - Empty string for plain text or 'html' for HTML markup.
 * overflow - Specifies the overflow behaviour of the label. Requires w > 0 and/or h > 0.
 * clip - Boolean that specifies if the label should be clipped. Requires w > 0 and/or h > 0.
 * rotation - Number that specifies the angle of the rotation around the anchor point of the text.
 * dir - Optional string that specifies the text direction. Possible values are rtl and lrt.
 */
mxXmlCanvas2D.prototype.text = function(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation, dir)
{
\tif (this.textEnabled && str != null)
\t{
\t\tif (mxUtils.isNode(str))
\t\t{
\t\t\tstr = mxUtils.getOuterHtml(str);
\t\t}
\t\t
\t\tvar elem = this.createElement('text');
\t\telem.setAttribute('x', this.format(x));
\t\telem.setAttribute('y', this.format(y));
\t\telem.setAttribute('w', this.format(w));
\t\telem.setAttribute('h', this.format(h));
\t\telem.setAttribute('str', str);
\t\t
\t\tif (align != null)
\t\t{
\t\t\telem.setAttribute('align', align);
\t\t}
\t\t
\t\tif (valign != null)
\t\t{
\t\t\telem.setAttribute('valign', valign);
\t\t}
\t\t
\t\telem.setAttribute('wrap', (wrap) ? '1' : '0');
\t\t
\t\tif (format == null)
\t\t{
\t\t\tformat = '';
\t\t}
\t\t
\t\telem.setAttribute('format', format);
\t\t
\t\tif (overflow != null)
\t\t{
\t\t\telem.setAttribute('overflow', overflow);
\t\t}
\t\t
\t\tif (clip != null)
\t\t{
\t\t\telem.setAttribute('clip', (clip) ? '1' : '0');
\t\t}
\t\t
\t\tif (rotation != null)
\t\t{
\t\t\telem.setAttribute('rotation', rotation);
\t\t}
\t\t
\t\tif (dir != null)
\t\t{
\t\t\telem.setAttribute('dir', dir);
\t\t}
\t\t
\t\tthis.root.appendChild(elem);
\t}
};

/**
 * Function: stroke
 * 
 * Paints the outline of the current drawing buffer.
 */
mxXmlCanvas2D.prototype.stroke = function()
{
\tthis.root.appendChild(this.createElement('stroke'));
};

/**
 * Function: fill
 * 
 * Fills the current drawing buffer.
 */
mxXmlCanvas2D.prototype.fill = function()
{
\tthis.root.appendChild(this.createElement('fill'));
};

/**
 * Function: fillAndStroke
 * 
 * Fills the current drawing buffer and its outline.
 */
mxXmlCanvas2D.prototype.fillAndStroke = function()
{
\tthis.root.appendChild(this.createElement('fillstroke'));
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxSvgCanvas2D
 *
 * Extends <mxAbstractCanvas2D> to implement a canvas for SVG. This canvas writes all
 * calls as SVG output to the given SVG root node.
 * 
 * (code)
 * var svgDoc = mxUtils.createXmlDocument();
 * var root = (svgDoc.createElementNS != null) ?
 * \t\tsvgDoc.createElementNS(mxConstants.NS_SVG, 'svg') : svgDoc.createElement('svg');
 * 
 * if (svgDoc.createElementNS == null)
 * {
 *   root.setAttribute('xmlns', mxConstants.NS_SVG);
 *   root.setAttribute('xmlns:xlink', mxConstants.NS_XLINK);
 * }
 * else
 * {
 *   root.setAttributeNS('http://www.w3.org/2000/xmlns/', 'xmlns:xlink', mxConstants.NS_XLINK);
 * }
 * 
 * var bounds = graph.getGraphBounds();
 * root.setAttribute('width', (bounds.x + bounds.width + 4) + 'px');
 * root.setAttribute('height', (bounds.y + bounds.height + 4) + 'px');
 * root.setAttribute('version', '1.1');
 * 
 * svgDoc.appendChild(root);
 * 
 * var svgCanvas = new mxSvgCanvas2D(root);
 * (end)
 * 
 * A description of the public API is available in <mxXmlCanvas2D>.
 * 
 * To disable anti-aliasing in the output, use the following code.
 * 
 * (code)
 * graph.view.canvas.ownerSVGElement.setAttribute('shape-rendering', 'crispEdges');
 * (end)
 * 
 * Or set the respective attribute in the SVG element directly.
 * 
 * Constructor: mxSvgCanvas2D
 *
 * Constructs a new SVG canvas.
 * 
 * Parameters:
 * 
 * root - SVG container for the output.
 * styleEnabled - Optional boolean that specifies if a style section should be
 * added. The style section sets the default font-size, font-family and
 * stroke-miterlimit globally. Default is false.
 */
function mxSvgCanvas2D(root, styleEnabled)
{
\tmxAbstractCanvas2D.call(this);

\t/**
\t * Variable: root
\t * 
\t * Reference to the container for the SVG content.
\t */
\tthis.root = root;

\t/**
\t * Variable: gradients
\t * 
\t * Local cache of gradients for quick lookups.
\t */
\tthis.gradients = [];

\t/**
\t * Variable: defs
\t * 
\t * Reference to the defs section of the SVG document. Only for export.
\t */
\tthis.defs = null;
\t
\t/**
\t * Variable: styleEnabled
\t * 
\t * Stores the value of styleEnabled passed to the constructor.
\t */
\tthis.styleEnabled = (styleEnabled != null) ? styleEnabled : false;
\t
\tvar svg = null;
\t
\t// Adds optional defs section for export
\tif (root.ownerDocument != document)
\t{
\t\tvar node = root;

\t\t// Finds owner SVG element in XML DOM
\t\twhile (node != null && node.nodeName != 'svg')
\t\t{
\t\t\tnode = node.parentNode;
\t\t}
\t\t
\t\tsvg = node;
\t}

\tif (svg != null)
\t{
\t\t// Tries to get existing defs section
\t\tvar tmp = svg.getElementsByTagName('defs');
\t\t
\t\tif (tmp.length > 0)
\t\t{
\t\t\tthis.defs = svg.getElementsByTagName('defs')[0];
\t\t}
\t\t
\t\t// Adds defs section if none exists
\t\tif (this.defs == null)
\t\t{
\t\t\tthis.defs = this.createElement('defs');
\t\t\t
\t\t\tif (svg.firstChild != null)
\t\t\t{
\t\t\t\tsvg.insertBefore(this.defs, svg.firstChild);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tsvg.appendChild(this.defs);
\t\t\t}
\t\t}

\t\t// Adds stylesheet
\t\tif (this.styleEnabled)
\t\t{
\t\t\tthis.defs.appendChild(this.createStyle());
\t\t}
\t}
};

/**
 * Extends mxAbstractCanvas2D
 */
mxUtils.extend(mxSvgCanvas2D, mxAbstractCanvas2D);

/**
 * Capability check for DOM parser and checks if base tag is used.
 */
(function()
{
\tmxSvgCanvas2D.prototype.useDomParser = !mxClient.IS_IE && typeof DOMParser === 'function' && typeof XMLSerializer === 'function';
\t
\tif (mxSvgCanvas2D.prototype.useDomParser)
\t{
\t\t// Checks using a generic test text if the parsing actually works. This is a workaround
\t\t// for older browsers where the capability check returns true but the parsing fails.
\t\ttry
\t\t{
\t\t\tvar doc = new DOMParser().parseFromString('test text', 'text/html');
\t\t\tmxSvgCanvas2D.prototype.useDomParser = doc != null;
\t\t}
\t\tcatch (e)
\t\t{
\t\t\tmxSvgCanvas2D.prototype.useDomParser = false;
\t\t}
\t}
\t
\t// Activates workaround for gradient ID resolution if base tag is used.
\tmxSvgCanvas2D.prototype.useAbsoluteIds = !mxClient.IS_CHROMEAPP && !mxClient.IS_IE && !mxClient.IS_IE11 &&
\t\t!mxClient.IS_EDGE && document.getElementsByTagName('base').length > 0;
})();

/**
 * Variable: path
 * 
 * Holds the current DOM node.
 */
mxSvgCanvas2D.prototype.node = null;

/**
 * Variable: matchHtmlAlignment
 * 
 * Specifies if plain text output should match the vertical HTML alignment.
 * Defaul is true.
 */
mxSvgCanvas2D.prototype.matchHtmlAlignment = true;

/**
 * Variable: textEnabled
 * 
 * Specifies if text output should be enabled. Default is true.
 */
mxSvgCanvas2D.prototype.textEnabled = true;

/**
 * Variable: foEnabled
 * 
 * Specifies if use of foreignObject for HTML markup is allowed. Default is true.
 */
mxSvgCanvas2D.prototype.foEnabled = true;

/**
 * Variable: foAltText
 * 
 * Specifies the fallback text for unsupported foreignObjects in exported
 * documents. Default is '[Object]'. If this is set to null then no fallback
 * text is added to the exported document.
 */
mxSvgCanvas2D.prototype.foAltText = '[Object]';

/**
 * Variable: foOffset
 * 
 * Offset to be used for foreignObjects.
 */
mxSvgCanvas2D.prototype.foOffset = 0;

/**
 * Variable: textOffset
 * 
 * Offset to be used for text elements.
 */
mxSvgCanvas2D.prototype.textOffset = 0;

/**
 * Variable: imageOffset
 * 
 * Offset to be used for image elements.
 */
mxSvgCanvas2D.prototype.imageOffset = 0;

/**
 * Variable: strokeTolerance
 * 
 * Adds transparent paths for strokes.
 */
mxSvgCanvas2D.prototype.strokeTolerance = 0;

/**
 * Variable: minStrokeWidth
 * 
 * Minimum stroke width for output.
 */
mxSvgCanvas2D.prototype.minStrokeWidth = 1;

/**
 * Variable: refCount
 * 
 * Local counter for references in SVG export.
 */
mxSvgCanvas2D.prototype.refCount = 0;

/**
 * Variable: lineHeightCorrection
 * 
 * Correction factor for <mxConstants.LINE_HEIGHT> in HTML output. Default is 1.
 */
mxSvgCanvas2D.prototype.lineHeightCorrection = 1;

/**
 * Variable: pointerEventsValue
 * 
 * Default value for active pointer events. Default is all.
 */
mxSvgCanvas2D.prototype.pointerEventsValue = 'all';

/**
 * Variable: fontMetricsPadding
 * 
 * Padding to be added for text that is not wrapped to account for differences
 * in font metrics on different platforms in pixels. Default is 10.
 */
mxSvgCanvas2D.prototype.fontMetricsPadding = 10;

/**
 * Variable: cacheOffsetSize
 * 
 * Specifies if offsetWidth and offsetHeight should be cached. Default is true.
 * This is used to speed up repaint of text in <updateText>.
 */
mxSvgCanvas2D.prototype.cacheOffsetSize = true;

/**
 * Function: format
 * 
 * Rounds all numbers to 2 decimal points.
 */
mxSvgCanvas2D.prototype.format = function(value)
{
\treturn parseFloat(parseFloat(value).toFixed(2));
};

/**
 * Function: getBaseUrl
 * 
 * Returns the URL of the page without the hash part. This needs to use href to
 * include any search part with no params (ie question mark alone). This is a
 * workaround for the fact that window.location.search is empty if there is
 * no search string behind the question mark.
 */
mxSvgCanvas2D.prototype.getBaseUrl = function()
{
\tvar href = window.location.href;
\tvar hash = href.lastIndexOf('#');
\t
\tif (hash > 0)
\t{
\t\thref = href.substring(0, hash);
\t}
\t
\treturn href;
};

/**
 * Function: reset
 * 
 * Returns any offsets for rendering pixels.
 */
mxSvgCanvas2D.prototype.reset = function()
{
\tmxAbstractCanvas2D.prototype.reset.apply(this, arguments);
\tthis.gradients = [];
};

/**
 * Function: createStyle
 * 
 * Creates the optional style section.
 */
mxSvgCanvas2D.prototype.createStyle = function(x)
{
\tvar style = this.createElement('style');
\tstyle.setAttribute('type', 'text/css');
\tmxUtils.write(style, 'svg{font-family:' + mxConstants.DEFAULT_FONTFAMILY +
\t\t\t';font-size:' + mxConstants.DEFAULT_FONTSIZE +
\t\t\t';fill:none;stroke-miterlimit:10}');
\t
\treturn style;
};

/**
 * Function: createElement
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.createElement = function(tagName, namespace)
{
\tif (this.root.ownerDocument.createElementNS != null)
\t{
\t\treturn this.root.ownerDocument.createElementNS(namespace || mxConstants.NS_SVG, tagName);
\t}
\telse
\t{
\t\tvar elt = this.root.ownerDocument.createElement(tagName);
\t\t
\t\tif (namespace != null)
\t\t{
\t\t\telt.setAttribute('xmlns', namespace);
\t\t}
\t\t
\t\treturn elt;
\t}
};

/**
 * Function: getAlternateText
 * 
 * Returns the alternate text string for the given foreignObject.
 */
mxSvgCanvas2D.prototype.getAlternateText = function(fo, x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation)
{
\treturn (str != null) ? this.foAltText : null;
};

/**
 * Function: getAlternateContent
 * 
 * Returns the alternate content for the given foreignObject.
 */
mxSvgCanvas2D.prototype.createAlternateContent = function(fo, x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation)
{
\tvar text = this.getAlternateText(fo, x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation);
\tvar s = this.state;

\tif (text != null && s.fontSize > 0)
\t{
\t\tvar dy = (valign == mxConstants.ALIGN_TOP) ? 1 :
\t\t\t(valign == mxConstants.ALIGN_BOTTOM) ? 0 : 0.3;
\t\tvar anchor = (align == mxConstants.ALIGN_RIGHT) ? 'end' :
\t\t\t(align == mxConstants.ALIGN_LEFT) ? 'start' :
\t\t\t'middle';
\t
\t\tvar alt = this.createElement('text');
\t\talt.setAttribute('x', Math.round(x + s.dx));
\t\talt.setAttribute('y', Math.round(y + s.dy + dy * s.fontSize));
\t\talt.setAttribute('fill', s.fontColor || 'black');
\t\talt.setAttribute('font-family', s.fontFamily);
\t\talt.setAttribute('font-size', Math.round(s.fontSize) + 'px');

\t\t// Text-anchor start is default in SVG
\t\tif (anchor != 'start')
\t\t{
\t\t\talt.setAttribute('text-anchor', anchor);
\t\t}
\t\t
\t\tif ((s.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t\t{
\t\t\talt.setAttribute('font-weight', 'bold');
\t\t}
\t\t
\t\tif ((s.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t\t{
\t\t\talt.setAttribute('font-style', 'italic');
\t\t}
\t\t
\t\tvar txtDecor = [];
\t\t
\t\tif ((s.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t\t{
\t\t\ttxtDecor.push('underline');
\t\t}
\t\t
\t\tif ((s.fontStyle & mxConstants.FONT_STRIKETHROUGH) == mxConstants.FONT_STRIKETHROUGH)
\t\t{
\t\t\ttxtDecor.push('line-through');
\t\t}
\t\t
\t\tif (txtDecor.length > 0)
\t\t{
\t\t\talt.setAttribute('text-decoration', txtDecor.join(' '));
\t\t}
\t\t
\t\tmxUtils.write(alt, text);
\t\t
\t\treturn alt;
\t}
\telse
\t{
\t\treturn null;
\t}
};

/**
 * Function: createGradientId
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.createGradientId = function(start, end, alpha1, alpha2, direction)
{
\t// Removes illegal characters from gradient ID
\tif (start.charAt(0) == '#')
\t{
\t\tstart = start.substring(1);
\t}
\t
\tif (end.charAt(0) == '#')
\t{
\t\tend = end.substring(1);
\t}
\t
\t// Workaround for gradient IDs not working in Safari 5 / Chrome 6
\t// if they contain uppercase characters
\tstart = start.toLowerCase() + '-' + alpha1;
\tend = end.toLowerCase() + '-' + alpha2;

\t// Wrong gradient directions possible?
\tvar dir = null;
\t
\tif (direction == null || direction == mxConstants.DIRECTION_SOUTH)
\t{
\t\tdir = 's';
\t}
\telse if (direction == mxConstants.DIRECTION_EAST)
\t{
\t\tdir = 'e';
\t}
\telse
\t{
\t\tvar tmp = start;
\t\tstart = end;
\t\tend = tmp;
\t\t
\t\tif (direction == mxConstants.DIRECTION_NORTH)
\t\t{
\t\t\tdir = 's';
\t\t}
\t\telse if (direction == mxConstants.DIRECTION_WEST)
\t\t{
\t\t\tdir = 'e';
\t\t}
\t}
\t
\treturn 'mx-gradient-' + start + '-' + end + '-' + dir;
};

/**
 * Function: getSvgGradient
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.getSvgGradient = function(start, end, alpha1, alpha2, direction)
{
\tvar id = this.createGradientId(start, end, alpha1, alpha2, direction);
\tvar gradient = this.gradients[id];
\t
\tif (gradient == null)
\t{
\t\tvar svg = this.root.ownerSVGElement;

\t\tvar counter = 0;
\t\tvar tmpId = id + '-' + counter;

\t\tif (svg != null)
\t\t{
\t\t\tgradient = svg.ownerDocument.getElementById(tmpId);
\t\t\t
\t\t\twhile (gradient != null && gradient.ownerSVGElement != svg)
\t\t\t{
\t\t\t\ttmpId = id + '-' + counter++;
\t\t\t\tgradient = svg.ownerDocument.getElementById(tmpId);
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\t// Uses shorter IDs for export
\t\t\ttmpId = 'id' + (++this.refCount);
\t\t}
\t\t
\t\tif (gradient == null)
\t\t{
\t\t\tgradient = this.createSvgGradient(start, end, alpha1, alpha2, direction);
\t\t\tgradient.setAttribute('id', tmpId);
\t\t\t
\t\t\tif (this.defs != null)
\t\t\t{
\t\t\t\tthis.defs.appendChild(gradient);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tsvg.appendChild(gradient);
\t\t\t}
\t\t}

\t\tthis.gradients[id] = gradient;
\t}

\treturn gradient.getAttribute('id');
};

/**
 * Function: createSvgGradient
 * 
 * Creates the given SVG gradient.
 */
mxSvgCanvas2D.prototype.createSvgGradient = function(start, end, alpha1, alpha2, direction)
{
\tvar gradient = this.createElement('linearGradient');
\tgradient.setAttribute('x1', '0%');
\tgradient.setAttribute('y1', '0%');
\tgradient.setAttribute('x2', '0%');
\tgradient.setAttribute('y2', '0%');
\t
\tif (direction == null || direction == mxConstants.DIRECTION_SOUTH)
\t{
\t\tgradient.setAttribute('y2', '100%');
\t}
\telse if (direction == mxConstants.DIRECTION_EAST)
\t{
\t\tgradient.setAttribute('x2', '100%');
\t}
\telse if (direction == mxConstants.DIRECTION_NORTH)
\t{
\t\tgradient.setAttribute('y1', '100%');
\t}
\telse if (direction == mxConstants.DIRECTION_WEST)
\t{
\t\tgradient.setAttribute('x1', '100%');
\t}
\t
\tvar op = (alpha1 < 1) ? ';stop-opacity:' + alpha1 : '';
\t
\tvar stop = this.createElement('stop');
\tstop.setAttribute('offset', '0%');
\tstop.setAttribute('style', 'stop-color:' + start + op);
\tgradient.appendChild(stop);
\t
\top = (alpha2 < 1) ? ';stop-opacity:' + alpha2 : '';
\t
\tstop = this.createElement('stop');
\tstop.setAttribute('offset', '100%');
\tstop.setAttribute('style', 'stop-color:' + end + op);
\tgradient.appendChild(stop);
\t
\treturn gradient;
};

/**
 * Function: addNode
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.addNode = function(filled, stroked)
{
\tvar node = this.node;
\tvar s = this.state;

\tif (node != null)
\t{
\t\tif (node.nodeName == 'path')
\t\t{
\t\t\t// Checks if the path is not empty
\t\t\tif (this.path != null && this.path.length > 0)
\t\t\t{
\t\t\t\tnode.setAttribute('d', this.path.join(' '));
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t}

\t\tif (filled && s.fillColor != null)
\t\t{
\t\t\tthis.updateFill();
\t\t}
\t\telse if (!this.styleEnabled)
\t\t{
\t\t\t// Workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=814952
\t\t\tif (node.nodeName == 'ellipse' && mxClient.IS_FF)
\t\t\t{
\t\t\t\tnode.setAttribute('fill', 'transparent');
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tnode.setAttribute('fill', 'none');
\t\t\t}
\t\t\t
\t\t\t// Sets the actual filled state for stroke tolerance
\t\t\tfilled = false;
\t\t}
\t\t
\t\tif (stroked && s.strokeColor != null)
\t\t{
\t\t\tthis.updateStroke();
\t\t}
\t\telse if (!this.styleEnabled)
\t\t{
\t\t\tnode.setAttribute('stroke', 'none');
\t\t}
\t\t
\t\tif (s.transform != null && s.transform.length > 0)
\t\t{
\t\t\tnode.setAttribute('transform', s.transform);
\t\t}
\t\t
\t\tif (s.shadow)
\t\t{
\t\t\tthis.root.appendChild(this.createShadow(node));
\t\t}
\t
\t\t// Adds stroke tolerance
\t\tif (this.strokeTolerance > 0 && !filled)
\t\t{
\t\t\tthis.root.appendChild(this.createTolerance(node));
\t\t}

\t\t// Adds pointer events
\t\tif (this.pointerEvents)
\t\t{
\t\t\tnode.setAttribute('pointer-events', this.pointerEventsValue);
\t\t}
\t\t// Enables clicks for nodes inside a link element
\t\telse if (!this.pointerEvents && this.originalRoot == null)
\t\t{
\t\t\tnode.setAttribute('pointer-events', 'none');
\t\t}
\t\t
\t\t// Removes invisible nodes from output if they don't handle events
\t\tif ((node.nodeName != 'rect' && node.nodeName != 'path' && node.nodeName != 'ellipse') ||
\t\t\t(node.getAttribute('fill') != 'none' && node.getAttribute('fill') != 'transparent') ||
\t\t\tnode.getAttribute('stroke') != 'none' || node.getAttribute('pointer-events') != 'none')
\t\t{
\t\t\t// LATER: Update existing DOM for performance\t\t
\t\t\tthis.root.appendChild(node);
\t\t}
\t\t
\t\tthis.node = null;
\t}
};

/**
 * Function: updateFill
 * 
 * Transfers the stroke attributes from <state> to <node>.
 */
mxSvgCanvas2D.prototype.updateFill = function()
{
\tvar s = this.state;
\t
\tif (s.alpha < 1 || s.fillAlpha < 1)
\t{
\t\tthis.node.setAttribute('fill-opacity', s.alpha * s.fillAlpha);
\t}
\t
\tif (s.fillColor != null)
\t{
\t\tif (s.gradientColor != null)
\t\t{
\t\t\tvar id = this.getSvgGradient(String(s.fillColor), String(s.gradientColor),
\t\t\t\ts.gradientFillAlpha, s.gradientAlpha, s.gradientDirection);
\t\t\t
\t\t\tif (this.root.ownerDocument == document && this.useAbsoluteIds)
\t\t\t{
\t\t\t\t// Workaround for no fill with base tag in page (escape brackets)
\t\t\t\tvar base = this.getBaseUrl().replace(/([\\(\\)])/g, '\\\\\$1');
\t\t\t\tthis.node.setAttribute('fill', 'url(' + base + '#' + id + ')');
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.node.setAttribute('fill', 'url(#' + id + ')');
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tthis.node.setAttribute('fill', String(s.fillColor).toLowerCase());
\t\t}
\t}
};

/**
 * Function: getCurrentStrokeWidth
 * 
 * Returns the current stroke width (>= 1), ie. max(1, this.format(this.state.strokeWidth * this.state.scale)).
 */
mxSvgCanvas2D.prototype.getCurrentStrokeWidth = function()
{
\treturn Math.max(this.minStrokeWidth, Math.max(0.01, this.format(this.state.strokeWidth * this.state.scale)));
};

/**
 * Function: updateStroke
 * 
 * Transfers the stroke attributes from <state> to <node>.
 */
mxSvgCanvas2D.prototype.updateStroke = function()
{
\tvar s = this.state;

\tthis.node.setAttribute('stroke', String(s.strokeColor).toLowerCase());
\t
\tif (s.alpha < 1 || s.strokeAlpha < 1)
\t{
\t\tthis.node.setAttribute('stroke-opacity', s.alpha * s.strokeAlpha);
\t}
\t
\tvar sw = this.getCurrentStrokeWidth();
\t
\tif (sw != 1)
\t{
\t\tthis.node.setAttribute('stroke-width', sw);
\t}
\t
\tif (this.node.nodeName == 'path')
\t{
\t\tthis.updateStrokeAttributes();
\t}
\t
\tif (s.dashed)
\t{
\t\tthis.node.setAttribute('stroke-dasharray', this.createDashPattern(
\t\t\t((s.fixDash) ? 1 : s.strokeWidth) * s.scale));
\t}
};

/**
 * Function: updateStrokeAttributes
 * 
 * Transfers the stroke attributes from <state> to <node>.
 */
mxSvgCanvas2D.prototype.updateStrokeAttributes = function()
{
\tvar s = this.state;
\t
\t// Linejoin miter is default in SVG
\tif (s.lineJoin != null && s.lineJoin != 'miter')
\t{
\t\tthis.node.setAttribute('stroke-linejoin', s.lineJoin);
\t}
\t
\tif (s.lineCap != null)
\t{
\t\t// flat is called butt in SVG
\t\tvar value = s.lineCap;
\t\t
\t\tif (value == 'flat')
\t\t{
\t\t\tvalue = 'butt';
\t\t}
\t\t
\t\t// Linecap butt is default in SVG
\t\tif (value != 'butt')
\t\t{
\t\t\tthis.node.setAttribute('stroke-linecap', value);
\t\t}
\t}
\t
\t// Miterlimit 10 is default in our document
\tif (s.miterLimit != null && (!this.styleEnabled || s.miterLimit != 10))
\t{
\t\tthis.node.setAttribute('stroke-miterlimit', s.miterLimit);
\t}
};

/**
 * Function: createDashPattern
 * 
 * Creates the SVG dash pattern for the given state.
 */
mxSvgCanvas2D.prototype.createDashPattern = function(scale)
{
\tvar pat = [];
\t
\tif (typeof(this.state.dashPattern) === 'string')
\t{
\t\tvar dash = this.state.dashPattern.split(' ');
\t\t
\t\tif (dash.length > 0)
\t\t{
\t\t\tfor (var i = 0; i < dash.length; i++)
\t\t\t{
\t\t\t\tpat[i] = Number(dash[i]) * scale;
\t\t\t}
\t\t}
\t}
\t
\treturn pat.join(' ');
};

/**
 * Function: createTolerance
 * 
 * Creates a hit detection tolerance shape for the given node.
 */
mxSvgCanvas2D.prototype.createTolerance = function(node)
{
\tvar tol = node.cloneNode(true);
\tvar sw = parseFloat(tol.getAttribute('stroke-width') || 1) + this.strokeTolerance;
\ttol.setAttribute('pointer-events', 'stroke');
\ttol.setAttribute('visibility', 'hidden');
\ttol.removeAttribute('stroke-dasharray');
\ttol.setAttribute('stroke-width', sw);
\ttol.setAttribute('fill', 'none');
\t
\t// Workaround for Opera ignoring the visiblity attribute above while
\t// other browsers need a stroke color to perform the hit-detection but
\t// do not ignore the visibility attribute. Side-effect is that Opera's
\t// hit detection for horizontal/vertical edges seems to ignore the tol.
\ttol.setAttribute('stroke', (mxClient.IS_OT) ? 'none' : 'white');
\t
\treturn tol;
};

/**
 * Function: createShadow
 * 
 * Creates a shadow for the given node.
 */
mxSvgCanvas2D.prototype.createShadow = function(node)
{
\tvar shadow = node.cloneNode(true);
\tvar s = this.state;

\t// Firefox uses transparent for no fill in ellipses
\tif (shadow.getAttribute('fill') != 'none' && (!mxClient.IS_FF || shadow.getAttribute('fill') != 'transparent'))
\t{
\t\tshadow.setAttribute('fill', s.shadowColor);
\t}
\t
\tif (shadow.getAttribute('stroke') != 'none')
\t{
\t\tshadow.setAttribute('stroke', s.shadowColor);
\t}

\tshadow.setAttribute('transform', 'translate(' + this.format(s.shadowDx * s.scale) +
\t\t',' + this.format(s.shadowDy * s.scale) + ')' + (s.transform || ''));
\tshadow.setAttribute('opacity', s.shadowAlpha);
\t
\treturn shadow;
};

/**
 * Function: setLink
 * 
 * Experimental implementation for hyperlinks.
 */
mxSvgCanvas2D.prototype.setLink = function(link)
{
\tif (link == null)
\t{
\t\tthis.root = this.originalRoot;
\t}
\telse
\t{
\t\tthis.originalRoot = this.root;
\t\t
\t\tvar node = this.createElement('a');
\t\t
\t\t// Workaround for implicit namespace handling in HTML5 export, IE adds NS1 namespace so use code below
\t\t// in all IE versions except quirks mode. KNOWN: Adds xlink namespace to each image tag in output.
\t\tif (node.setAttributeNS == null || (this.root.ownerDocument != document && document.documentMode == null))
\t\t{
\t\t\tnode.setAttribute('xlink:href', link);
\t\t}
\t\telse
\t\t{
\t\t\tnode.setAttributeNS(mxConstants.NS_XLINK, 'xlink:href', link);
\t\t}
\t\t
\t\tthis.root.appendChild(node);
\t\tthis.root = node;
\t}
};

/**
 * Function: rotate
 * 
 * Sets the rotation of the canvas. Note that rotation cannot be concatenated.
 */
mxSvgCanvas2D.prototype.rotate = function(theta, flipH, flipV, cx, cy)
{
\tif (theta != 0 || flipH || flipV)
\t{
\t\tvar s = this.state;
\t\tcx += s.dx;
\t\tcy += s.dy;
\t
\t\tcx *= s.scale;
\t\tcy *= s.scale;

\t\ts.transform = s.transform || '';
\t\t
\t\t// This implementation uses custom scale/translate and built-in rotation
\t\t// Rotation state is part of the AffineTransform in state.transform
\t\tif (flipH && flipV)
\t\t{
\t\t\ttheta += 180;
\t\t}
\t\telse if (flipH != flipV)
\t\t{
\t\t\tvar tx = (flipH) ? cx : 0;
\t\t\tvar sx = (flipH) ? -1 : 1;
\t
\t\t\tvar ty = (flipV) ? cy : 0;
\t\t\tvar sy = (flipV) ? -1 : 1;

\t\t\ts.transform += 'translate(' + this.format(tx) + ',' + this.format(ty) + ')' +
\t\t\t\t'scale(' + this.format(sx) + ',' + this.format(sy) + ')' +
\t\t\t\t'translate(' + this.format(-tx) + ',' + this.format(-ty) + ')';
\t\t}
\t\t
\t\tif (flipH ? !flipV : flipV)
\t\t{
\t\t\ttheta *= -1;
\t\t}
\t\t
\t\tif (theta != 0)
\t\t{
\t\t\ts.transform += 'rotate(' + this.format(theta) + ',' + this.format(cx) + ',' + this.format(cy) + ')';
\t\t}
\t\t
\t\ts.rotation = s.rotation + theta;
\t\ts.rotationCx = cx;
\t\ts.rotationCy = cy;
\t}
};

/**
 * Function: begin
 * 
 * Extends superclass to create path.
 */
mxSvgCanvas2D.prototype.begin = function()
{
\tmxAbstractCanvas2D.prototype.begin.apply(this, arguments);
\tthis.node = this.createElement('path');
};

/**
 * Function: rect
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.rect = function(x, y, w, h)
{
\tvar s = this.state;
\tvar n = this.createElement('rect');
\tn.setAttribute('x', this.format((x + s.dx) * s.scale));
\tn.setAttribute('y', this.format((y + s.dy) * s.scale));
\tn.setAttribute('width', this.format(w * s.scale));
\tn.setAttribute('height', this.format(h * s.scale));
\t
\tthis.node = n;
};

/**
 * Function: roundrect
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.roundrect = function(x, y, w, h, dx, dy)
{
\tthis.rect(x, y, w, h);
\t
\tif (dx > 0)
\t{
\t\tthis.node.setAttribute('rx', this.format(dx * this.state.scale));
\t}
\t
\tif (dy > 0)
\t{
\t\tthis.node.setAttribute('ry', this.format(dy * this.state.scale));
\t}
};

/**
 * Function: ellipse
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.ellipse = function(x, y, w, h)
{
\tvar s = this.state;
\tvar n = this.createElement('ellipse');
\t// No rounding for consistent output with 1.x
\tn.setAttribute('cx', this.format((x + w / 2 + s.dx) * s.scale));
\tn.setAttribute('cy', this.format((y + h / 2 + s.dy) * s.scale));
\tn.setAttribute('rx', w / 2 * s.scale);
\tn.setAttribute('ry', h / 2 * s.scale);
\tthis.node = n;
};

/**
 * Function: image
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.image = function(x, y, w, h, src, aspect, flipH, flipV)
{
\tsrc = this.converter.convert(src);
\t
\t// LATER: Add option for embedding images as base64.
\taspect = (aspect != null) ? aspect : true;
\tflipH = (flipH != null) ? flipH : false;
\tflipV = (flipV != null) ? flipV : false;
\t
\tvar s = this.state;
\tx += s.dx;
\ty += s.dy;
\t
\tvar node = this.createElement('image');
\tnode.setAttribute('x', this.format(x * s.scale) + this.imageOffset);
\tnode.setAttribute('y', this.format(y * s.scale) + this.imageOffset);
\tnode.setAttribute('width', this.format(w * s.scale));
\tnode.setAttribute('height', this.format(h * s.scale));
\t
\t// Workaround for missing namespace support
\tif (node.setAttributeNS == null)
\t{
\t\tnode.setAttribute('xlink:href', src);
\t}
\telse
\t{
\t\tnode.setAttributeNS(mxConstants.NS_XLINK, 'xlink:href', src);
\t}
\t
\tif (!aspect)
\t{
\t\tnode.setAttribute('preserveAspectRatio', 'none');
\t}

\tif (s.alpha < 1 || s.fillAlpha < 1)
\t{
\t\tnode.setAttribute('opacity', s.alpha * s.fillAlpha);
\t}
\t
\tvar tr = this.state.transform || '';
\t
\tif (flipH || flipV)
\t{
\t\tvar sx = 1;
\t\tvar sy = 1;
\t\tvar dx = 0;
\t\tvar dy = 0;
\t\t
\t\tif (flipH)
\t\t{
\t\t\tsx = -1;
\t\t\tdx = -w - 2 * x;
\t\t}
\t\t
\t\tif (flipV)
\t\t{
\t\t\tsy = -1;
\t\t\tdy = -h - 2 * y;
\t\t}
\t\t
\t\t// Adds image tansformation to existing transform
\t\ttr += 'scale(' + sx + ',' + sy + ')translate(' + (dx * s.scale) + ',' + (dy * s.scale) + ')';
\t}

\tif (tr.length > 0)
\t{
\t\tnode.setAttribute('transform', tr);
\t}
\t
\tif (!this.pointerEvents)
\t{
\t\tnode.setAttribute('pointer-events', 'none');
\t}
\t
\tthis.root.appendChild(node);
};

/**
 * Function: convertHtml
 * 
 * Converts the given HTML string to XHTML.
 */
mxSvgCanvas2D.prototype.convertHtml = function(val)
{
\tif (this.useDomParser)
\t{
\t\tvar doc = new DOMParser().parseFromString(val, 'text/html');

\t\tif (doc != null)
\t\t{
\t\t\tval = new XMLSerializer().serializeToString(doc.body);
\t\t\t
\t\t\t// Extracts body content from DOM
\t\t\tif (val.substring(0, 5) == '<body')
\t\t\t{
\t\t\t\tval = val.substring(val.indexOf('>', 5) + 1);
\t\t\t}
\t\t\t
\t\t\tif (val.substring(val.length - 7, val.length) == '</body>')
\t\t\t{
\t\t\t\tval = val.substring(0, val.length - 7);
\t\t\t}
\t\t}
\t}
\telse if (document.implementation != null && document.implementation.createDocument != null)
\t{
\t\tvar xd = document.implementation.createDocument('http://www.w3.org/1999/xhtml', 'html', null);
\t\tvar xb = xd.createElement('body');
\t\txd.documentElement.appendChild(xb);
\t\t
\t\tvar div = document.createElement('div');
\t\tdiv.innerHTML = val;
\t\tvar child = div.firstChild;
\t\t
\t\twhile (child != null)
\t\t{
\t\t\tvar next = child.nextSibling;
\t\t\txb.appendChild(xd.adoptNode(child));
\t\t\tchild = next;
\t\t}
\t\t
\t\treturn xb.innerHTML;
\t}
\telse
\t{
\t\tvar ta = document.createElement('textarea');
\t\t
\t\t// Handles special HTML entities < and > and double escaping
\t\t// and converts unclosed br, hr and img tags to XHTML
\t\t// LATER: Convert all unclosed tags
\t\tta.innerHTML = val.replace(/&amp;/g, '&amp;amp;').
\t\t\treplace(/&#60;/g, '&amp;lt;').replace(/&#62;/g, '&amp;gt;').
\t\t\treplace(/&lt;/g, '&amp;lt;').replace(/&gt;/g, '&amp;gt;').
\t\t\treplace(/</g, '&lt;').replace(/>/g, '&gt;');
\t\tval = ta.value.replace(/&/g, '&amp;').replace(/&amp;lt;/g, '&lt;').
\t\t\treplace(/&amp;gt;/g, '&gt;').replace(/&amp;amp;/g, '&amp;').
\t\t\treplace(/<br>/g, '<br />').replace(/<hr>/g, '<hr />').
\t\t\treplace(/(<img[^>]+)>/gm, \"\$1 />\");
\t}
\t
\treturn val;
};

/**
 * Function: createDiv
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.createDiv = function(str)
{
\tvar val = str;
\t
\tif (!mxUtils.isNode(val))
\t{
\t\tval = '<div><div>' + this.convertHtml(val) + '</div></div>';
\t}

\t// IE uses this code for export as it cannot render foreignObjects
\tif (!mxClient.IS_IE && !mxClient.IS_IE11 && document.createElementNS)
\t{
\t\tvar div = document.createElementNS('http://www.w3.org/1999/xhtml', 'div');
\t\t
\t\tif (mxUtils.isNode(val))
\t\t{
\t\t\tvar div2 = document.createElement('div');
\t\t\tvar div3 = div2.cloneNode(false);
\t\t\t
\t\t\t// Creates a copy for export
\t\t\tif (this.root.ownerDocument != document)
\t\t\t{
\t\t\t\tdiv2.appendChild(val.cloneNode(true));
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tdiv2.appendChild(val);
\t\t\t}
\t\t\t
\t\t\tdiv3.appendChild(div2);
\t\t\tdiv.appendChild(div3);
\t\t}
\t\telse
\t\t{
\t\t\tdiv.innerHTML = val;
\t\t}
\t\t
\t\treturn div;
\t}
\telse
\t{
\t\tif (mxUtils.isNode(val))
\t\t{
\t\t\tval = '<div><div>' + mxUtils.getXml(val) + '</div></div>';
\t\t}
\t\t
\t\tval = '<div xmlns=\"http://www.w3.org/1999/xhtml\">' + val + '</div>';

\t\t// NOTE: FF 3.6 crashes if content CSS contains \"height:100%\"
\t\treturn  mxUtils.parseXml(val).documentElement;
\t}
};

/**
 * Updates existing DOM nodes for text rendering. LATER: Merge common parts with text function below.
 */
mxSvgCanvas2D.prototype.updateText = function(x, y, w, h, align, valign, wrap, overflow, clip, rotation, node)
{
\tif (node != null && node.firstChild != null && node.firstChild.firstChild != null)
\t{
\t\tthis.updateTextNodes(x, y, w, h, align, valign, wrap, overflow, clip, rotation, node.firstChild);
\t}
};

/**
 * Function: addForeignObject
 * 
 * Creates a foreignObject for the given string and adds it to the given root.
 */
mxSvgCanvas2D.prototype.addForeignObject = function(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation, dir, div, root)
{
\tvar group = this.createElement('g');
\tvar fo = this.createElement('foreignObject');
\t
\t// Workarounds for print clipping and static position in Safari
\tfo.setAttribute('style', 'overflow: visible; text-align: left;');
\tfo.setAttribute('pointer-events', 'none');
\t
\t// Import needed for older versions of IE
\tif (div.ownerDocument != document)
\t{
\t\tdiv = mxUtils.importNodeImplementation(fo.ownerDocument, div, true);
\t}

\tfo.appendChild(div);
\tgroup.appendChild(fo);

\tthis.updateTextNodes(x, y, w, h, align, valign, wrap, overflow, clip, rotation, group);
\t
\t// Alternate content if foreignObject not supported
\tif (this.root.ownerDocument != document)
\t{
\t\tvar alt = this.createAlternateContent(fo, x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation);
\t\t
\t\tif (alt != null)
\t\t{
\t\t\tfo.setAttribute('requiredFeatures', 'http://www.w3.org/TR/SVG11/feature#Extensibility');
\t\t\tvar sw = this.createElement('switch');
\t\t\tsw.appendChild(fo);
\t\t\tsw.appendChild(alt);
\t\t\tgroup.appendChild(sw);
\t\t}
\t}
\t
\troot.appendChild(group);
};

/**
 * Updates existing DOM nodes for text rendering.
 */
mxSvgCanvas2D.prototype.updateTextNodes = function(x, y, w, h, align, valign, wrap, overflow, clip, rotation, g)
{
\tvar s = this.state.scale;

\tmxSvgCanvas2D.createCss(w + 2, h, align, valign, wrap, overflow, clip,
\t\t(this.state.fontBackgroundColor != null) ? this.state.fontBackgroundColor : null,
\t\t(this.state.fontBorderColor != null) ? this.state.fontBorderColor : null,
\t\t'display: flex; align-items: unsafe ' +
\t\t((valign == mxConstants.ALIGN_TOP) ? 'flex-start' :
\t\t((valign == mxConstants.ALIGN_BOTTOM) ? 'flex-end' : 'center'))  + '; ' +
\t\t'justify-content: unsafe ' + ((align == mxConstants.ALIGN_LEFT) ? 'flex-start' :
\t\t((align == mxConstants.ALIGN_RIGHT) ? 'flex-end' : 'center'))  + '; ',
\t\tthis.getTextCss(), s, mxUtils.bind(this, function(dx, dy, flex, item, block)
\t{
\t\tx += this.state.dx;
\t\ty += this.state.dy;

\t\tvar fo = g.firstChild;
\t\tvar div = fo.firstChild;
\t\tvar box = div.firstChild;
\t\tvar text = box.firstChild;
\t\tvar r = ((this.rotateHtml) ? this.state.rotation : 0) + ((rotation != null) ? rotation : 0);
\t\tvar t = ((this.foOffset != 0) ? 'translate(' + this.foOffset + ' ' + this.foOffset + ')' : '') +
\t\t\t((s != 1) ? 'scale(' + s + ')' : '');
\t\t
\t\ttext.setAttribute('style', block);
\t\tbox.setAttribute('style', item);
\t\t
\t\t// Workaround for clipping in Webkit with scrolling and zoom
\t\tfo.setAttribute('width', Math.ceil(1 / Math.min(1, s) * 100) + '%');
\t\tfo.setAttribute('height', Math.ceil(1 / Math.min(1, s) * 100) + '%');
\t\tvar yp = Math.round(y + dy);
\t\t
\t\t// Allows for negative values which are causing problems with
\t\t// transformed content where the top edge of the foreignObject
\t\t// limits the text box being moved further up in the diagram.
\t\t// KNOWN: Possible clipping problems with zoom and scrolling
\t\t// but this is normally not used with scrollbars as the
\t\t// coordinates are always positive with scrollbars.
\t\t// Margin-top is ignored in Safari and no negative values allowed
\t\t// for padding.
\t\tif (yp < 0)
\t\t{
\t\t\tfo.setAttribute('y', yp);
\t\t}
\t\telse
\t\t{
\t\t\tfo.removeAttribute('y');
\t\t\tflex += 'padding-top: ' + yp + 'px; ';
\t\t}
\t\t
\t\tdiv.setAttribute('style', flex + 'margin-left: ' + Math.round(x + dx) + 'px;');
\t\tt += ((r != 0) ? ('rotate(' + r + ' ' + x + ' ' + y + ')') : '');

\t\t// Output allows for reflow but Safari cannot use absolute position,
\t\t// transforms or opacity. https://bugs.webkit.org/show_bug.cgi?id=23113
\t\tif (t != '')
\t\t{\t
\t\t\tg.setAttribute('transform', t);
\t\t}
\t\telse
\t\t{
\t\t\tg.removeAttribute('transform');
\t\t}
\t\t
\t\tif (this.state.alpha != 1)
\t\t{
\t\t\tg.setAttribute('opacity', this.state.alpha);
\t\t}
\t\telse
\t\t{
\t\t\tg.removeAttribute('opacity');
\t\t}
\t}));
};

/**
 * Updates existing DOM nodes for text rendering.
 */
mxSvgCanvas2D.createCss = function(w, h, align, valign, wrap, overflow, clip, bg, border, flex, block, s, callback)
{
\tvar item = 'box-sizing: border-box; font-size: 0; text-align: ' + ((align == mxConstants.ALIGN_LEFT) ? 'left' :
\t\t((align == mxConstants.ALIGN_RIGHT) ? 'right' : 'center')) + '; ';
\tvar pt = mxUtils.getAlignmentAsPoint(align, valign);
\tvar ofl = 'overflow: hidden; ';
\tvar fw = 'width: 1px; ';
\tvar fh = 'height: 1px; ';
\tvar dx = pt.x * w;
\tvar dy = pt.y * h;
\t
\tif (clip)
\t{
\t\tfw = 'width: ' + Math.round(w) + 'px; ';
\t\titem += 'max-height: ' + Math.round(h) + 'px; ';
\t\tdy = 0;
\t}
\telse if (overflow == 'fill')
\t{
\t\tfw = 'width: ' + Math.round(w) + 'px; ';
\t\tfh = 'height: ' + Math.round(h) + 'px; ';
\t\tblock += 'width: 100%; height: 100%; ';
\t\titem += fw + fh;
\t}
\telse if (overflow == 'width')
\t{
\t\tfw = 'width: ' + Math.round(w) + 'px; ';
\t\tblock += 'width: 100%; ';
\t\titem += fw;
\t\tdy = 0;
\t\t
\t\tif (h > 0)
\t\t{
\t\t\titem += 'max-height: ' + Math.round(h) + 'px; ';
\t\t}
\t}
\telse
\t{
\t\tofl = '';
\t\tdy = 0;
\t}
\t
\tvar bgc = '';
\t
\tif (bg != null)
\t{
\t\tbgc += 'background-color: ' + bg + '; ';
\t}
\t
\tif (border != null)
\t{
\t\tbgc += 'border: 1px solid ' + border + '; ';
\t}
\t
\tif (ofl == '' || clip)
\t{
\t\tblock += bgc;
\t}
\telse
\t{
\t\titem += bgc;
\t}

\tif (wrap && w > 0)
\t{
\t\tblock += 'white-space: normal; word-wrap: ' + mxConstants.WORD_WRAP + '; ';
\t\tfw = 'width: ' + Math.round(w) + 'px; ';
\t\t
\t\tif (ofl != '' && overflow != 'fill')
\t\t{
\t\t\tdy = 0;
\t\t}
\t}
\telse
\t{
\t\tblock += 'white-space: nowrap; ';
\t\t
\t\tif (ofl == '')
\t\t{
\t\t\tdx = 0;
\t\t}
\t}
\t
\tcallback(dx, dy, flex + fw + fh, item + ofl, block, ofl);
};

/**
 * Function: getTextCss
 * 
 * Private helper function to create SVG elements
 */
mxSvgCanvas2D.prototype.getTextCss = function()
{
\tvar s = this.state;
\tvar lh = (mxConstants.ABSOLUTE_LINE_HEIGHT) ? (s.fontSize * mxConstants.LINE_HEIGHT) + 'px' :
\t\t(mxConstants.LINE_HEIGHT * this.lineHeightCorrection);
\tvar css = 'display: inline-block; font-size: ' + s.fontSize + 'px; ' +
\t\t'font-family: ' + s.fontFamily + '; color: ' + s.fontColor + '; line-height: ' + lh +
\t\t'; pointer-events: ' + ((this.pointerEvents) ? this.pointerEventsValue : 'none') + '; ';
\t
\tif ((s.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t{
\t\tcss += 'font-weight: bold; ';
\t}

\tif ((s.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t{
\t\tcss += 'font-style: italic; ';
\t}

\tvar deco = [];
\t
\tif ((s.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t{
\t\tdeco.push('underline');
\t}
\t
\tif ((s.fontStyle & mxConstants.FONT_STRIKETHROUGH) == mxConstants.FONT_STRIKETHROUGH)
\t{
\t\tdeco.push('line-through');
\t}
\t
\tif (deco.length > 0)
\t{
\t\tcss += 'text-decoration: ' + deco.join(' ') + '; ';
\t}

\treturn css;
};

/**
 * Function: text
 * 
 * Paints the given text. Possible values for format are empty string for plain
 * text and html for HTML markup. Note that HTML markup is only supported if
 * foreignObject is supported and <foEnabled> is true. (This means IE9 and later
 * does currently not support HTML text as part of shapes.)
 */
mxSvgCanvas2D.prototype.text = function(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation, dir)
{
\tif (this.textEnabled && str != null)
\t{
\t\trotation = (rotation != null) ? rotation : 0;

\t\tif (this.foEnabled && format == 'html')
\t\t{
\t\t\tvar div = this.createDiv(str);
\t\t\t
\t\t\t// Ignores invalid XHTML labels
\t\t\tif (div != null)
\t\t\t{
\t\t\t\tif (dir != null)
\t\t\t\t{
\t\t\t\t\tdiv.setAttribute('dir', dir);
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.addForeignObject(x, y, w, h, str, align, valign, wrap,
\t\t\t\t\tformat, overflow, clip, rotation, dir, div, this.root);
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tthis.plainText(x + this.state.dx, y + this.state.dy, w, h, str,
\t\t\t\talign, valign, wrap, overflow, clip, rotation, dir);
\t\t}
\t}
};

/**
 * Function: createClip
 * 
 * Creates a clip for the given coordinates.
 */
mxSvgCanvas2D.prototype.createClip = function(x, y, w, h)
{
\tx = Math.round(x);
\ty = Math.round(y);
\tw = Math.round(w);
\th = Math.round(h);
\t
\tvar id = 'mx-clip-' + x + '-' + y + '-' + w + '-' + h;

\tvar counter = 0;
\tvar tmp = id + '-' + counter;
\t
\t// Resolves ID conflicts
\twhile (document.getElementById(tmp) != null)
\t{
\t\ttmp = id + '-' + (++counter);
\t}
\t
\tclip = this.createElement('clipPath');
\tclip.setAttribute('id', tmp);
\t
\tvar rect = this.createElement('rect');
\trect.setAttribute('x', x);
\trect.setAttribute('y', y);
\trect.setAttribute('width', w);
\trect.setAttribute('height', h);
\t\t
\tclip.appendChild(rect);
\t
\treturn clip;
};

/**
 * Function: plainText
 * 
 * Paints the given text. Possible values for format are empty string for
 * plain text and html for HTML markup.
 */
mxSvgCanvas2D.prototype.plainText = function(x, y, w, h, str, align, valign, wrap, overflow, clip, rotation, dir)
{
\trotation = (rotation != null) ? rotation : 0;
\tvar s = this.state;
\tvar size = s.fontSize;
\tvar node = this.createElement('g');
\tvar tr = s.transform || '';
\tthis.updateFont(node);
\t\t\t\t
\t// Ignores pointer events
\tif (!this.pointerEvents && this.originalRoot == null)
\t{
\t\tnode.setAttribute('pointer-events', 'none');
\t}
\t\t
\t// Non-rotated text
\tif (rotation != 0)
\t{
\t\ttr += 'rotate(' + rotation  + ',' + this.format(x * s.scale) + ',' + this.format(y * s.scale) + ')';
\t}
\t
\tif (dir != null)
\t{
\t\tnode.setAttribute('direction', dir);
\t}

\tif (clip && w > 0 && h > 0)
\t{
\t\tvar cx = x;
\t\tvar cy = y;
\t\t
\t\tif (align == mxConstants.ALIGN_CENTER)
\t\t{
\t\t\tcx -= w / 2;
\t\t}
\t\telse if (align == mxConstants.ALIGN_RIGHT)
\t\t{
\t\t\tcx -= w;
\t\t}
\t\t
\t\tif (overflow != 'fill')
\t\t{
\t\t\tif (valign == mxConstants.ALIGN_MIDDLE)
\t\t\t{
\t\t\t\tcy -= h / 2;
\t\t\t}
\t\t\telse if (valign == mxConstants.ALIGN_BOTTOM)
\t\t\t{
\t\t\t\tcy -= h;
\t\t\t}
\t\t}
\t\t
\t\t// LATER: Remove spacing from clip rectangle
\t\tvar c = this.createClip(cx * s.scale - 2, cy * s.scale - 2, w * s.scale + 4, h * s.scale + 4);
\t\t
\t\tif (this.defs != null)
\t\t{
\t\t\tthis.defs.appendChild(c);
\t\t}
\t\telse
\t\t{
\t\t\t// Makes sure clip is removed with referencing node
\t\t\tthis.root.appendChild(c);
\t\t}
\t\t
\t\tif (!mxClient.IS_CHROMEAPP && !mxClient.IS_IE && !mxClient.IS_IE11 &&
\t\t\t!mxClient.IS_EDGE && this.root.ownerDocument == document)
\t\t{
\t\t\t// Workaround for potential base tag
\t\t\tvar base = this.getBaseUrl().replace(/([\\(\\)])/g, '\\\\\$1');
\t\t\tnode.setAttribute('clip-path', 'url(' + base + '#' + c.getAttribute('id') + ')');
\t\t}
\t\telse
\t\t{
\t\t\tnode.setAttribute('clip-path', 'url(#' + c.getAttribute('id') + ')');
\t\t}
\t}

\t// Default is left
\tvar anchor = (align == mxConstants.ALIGN_RIGHT) ? 'end' :
\t\t\t\t\t(align == mxConstants.ALIGN_CENTER) ? 'middle' :
\t\t\t\t\t'start';

\t// Text-anchor start is default in SVG
\tif (anchor != 'start')
\t{
\t\tnode.setAttribute('text-anchor', anchor);
\t}
\t
\tif (!this.styleEnabled || size != mxConstants.DEFAULT_FONTSIZE)
\t{
\t\tnode.setAttribute('font-size', (size * s.scale) + 'px');
\t}
\t
\tif (tr.length > 0)
\t{
\t\tnode.setAttribute('transform', tr);
\t}
\t
\tif (s.alpha < 1)
\t{
\t\tnode.setAttribute('opacity', s.alpha);
\t}
\t
\tvar lines = str.split('\\n');
\tvar lh = Math.round(size * mxConstants.LINE_HEIGHT);
\tvar textHeight = size + (lines.length - 1) * lh;

\tvar cy = y + size - 1;

\tif (valign == mxConstants.ALIGN_MIDDLE)
\t{
\t\tif (overflow == 'fill')
\t\t{
\t\t\tcy -= h / 2;
\t\t}
\t\telse
\t\t{
\t\t\tvar dy = ((this.matchHtmlAlignment && clip && h > 0) ? Math.min(textHeight, h) : textHeight) / 2;
\t\t\tcy -= dy;
\t\t}
\t}
\telse if (valign == mxConstants.ALIGN_BOTTOM)
\t{
\t\tif (overflow == 'fill')
\t\t{
\t\t\tcy -= h;
\t\t}
\t\telse
\t\t{
\t\t\tvar dy = (this.matchHtmlAlignment && clip && h > 0) ? Math.min(textHeight, h) : textHeight;
\t\t\tcy -= dy + 1;
\t\t}
\t}

\tfor (var i = 0; i < lines.length; i++)
\t{
\t\t// Workaround for bounding box of empty lines and spaces
\t\tif (lines[i].length > 0 && mxUtils.trim(lines[i]).length > 0)
\t\t{
\t\t\tvar text = this.createElement('text');
\t\t\t// LATER: Match horizontal HTML alignment
\t\t\ttext.setAttribute('x', this.format(x * s.scale) + this.textOffset);
\t\t\ttext.setAttribute('y', this.format(cy * s.scale) + this.textOffset);
\t
\t\t\tmxUtils.write(text, lines[i]);
\t\t\tnode.appendChild(text);
\t\t}

\t\tcy += lh;
\t}

\tthis.root.appendChild(node);
\tthis.addTextBackground(node, str, x, y, w, (overflow == 'fill') ? h : textHeight, align, valign, overflow);
};

/**
 * Function: updateFont
 * 
 * Updates the text properties for the given node. (NOTE: For this to work in
 * IE, the given node must be a text or tspan element.)
 */
mxSvgCanvas2D.prototype.updateFont = function(node)
{
\tvar s = this.state;

\tnode.setAttribute('fill', s.fontColor);
\t
\tif (!this.styleEnabled || s.fontFamily != mxConstants.DEFAULT_FONTFAMILY)
\t{
\t\tnode.setAttribute('font-family', s.fontFamily);
\t}

\tif ((s.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t{
\t\tnode.setAttribute('font-weight', 'bold');
\t}

\tif ((s.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t{
\t\tnode.setAttribute('font-style', 'italic');
\t}
\t
\tvar txtDecor = [];
\t
\tif ((s.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t{
\t\ttxtDecor.push('underline');
\t}
\t
\tif ((s.fontStyle & mxConstants.FONT_STRIKETHROUGH) == mxConstants.FONT_STRIKETHROUGH)
\t{
\t\ttxtDecor.push('line-through');
\t}
\t
\tif (txtDecor.length > 0)
\t{
\t\tnode.setAttribute('text-decoration', txtDecor.join(' '));
\t}
};

/**
 * Function: addTextBackground
 * 
 * Background color and border
 */
mxSvgCanvas2D.prototype.addTextBackground = function(node, str, x, y, w, h, align, valign, overflow)
{
\tvar s = this.state;

\tif (s.fontBackgroundColor != null || s.fontBorderColor != null)
\t{
\t\tvar bbox = null;
\t\t
\t\tif (overflow == 'fill' || overflow == 'width')
\t\t{
\t\t\tif (align == mxConstants.ALIGN_CENTER)
\t\t\t{
\t\t\t\tx -= w / 2;
\t\t\t}
\t\t\telse if (align == mxConstants.ALIGN_RIGHT)
\t\t\t{
\t\t\t\tx -= w;
\t\t\t}
\t\t\t
\t\t\tif (valign == mxConstants.ALIGN_MIDDLE)
\t\t\t{
\t\t\t\ty -= h / 2;
\t\t\t}
\t\t\telse if (valign == mxConstants.ALIGN_BOTTOM)
\t\t\t{
\t\t\t\ty -= h;
\t\t\t}
\t\t\t
\t\t\tbbox = new mxRectangle((x + 1) * s.scale, y * s.scale, (w - 2) * s.scale, (h + 2) * s.scale);
\t\t}
\t\telse if (node.getBBox != null && this.root.ownerDocument == document)
\t\t{
\t\t\t// Uses getBBox only if inside document for correct size
\t\t\ttry
\t\t\t{
\t\t\t\tbbox = node.getBBox();
\t\t\t\tvar ie = mxClient.IS_IE && mxClient.IS_SVG;
\t\t\t\tbbox = new mxRectangle(bbox.x, bbox.y + ((ie) ? 0 : 1), bbox.width, bbox.height + ((ie) ? 1 : 0));
\t\t\t}
\t\t\tcatch (e)
\t\t\t{
\t\t\t\t// Ignores NS_ERROR_FAILURE in FF if container display is none.
\t\t\t}
\t\t}
\t\t
\t\tif (bbox == null || bbox.width == 0 || bbox.height == 0)
\t\t{
\t\t\t// Computes size if not in document or no getBBox available
\t\t\tvar div = document.createElement('div');

\t\t\t// Wrapping and clipping can be ignored here
\t\t\tdiv.style.lineHeight = (mxConstants.ABSOLUTE_LINE_HEIGHT) ? (s.fontSize * mxConstants.LINE_HEIGHT) + 'px' : mxConstants.LINE_HEIGHT;
\t\t\tdiv.style.fontSize = s.fontSize + 'px';
\t\t\tdiv.style.fontFamily = s.fontFamily;
\t\t\tdiv.style.whiteSpace = 'nowrap';
\t\t\tdiv.style.position = 'absolute';
\t\t\tdiv.style.visibility = 'hidden';
\t\t\tdiv.style.display = (mxClient.IS_QUIRKS) ? 'inline' : 'inline-block';
\t\t\tdiv.style.zoom = '1';
\t\t\t
\t\t\tif ((s.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t\t\t{
\t\t\t\tdiv.style.fontWeight = 'bold';
\t\t\t}

\t\t\tif ((s.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t\t\t{
\t\t\t\tdiv.style.fontStyle = 'italic';
\t\t\t}
\t\t\t
\t\t\tstr = mxUtils.htmlEntities(str, false);
\t\t\tdiv.innerHTML = str.replace(/\\n/g, '<br/>');
\t\t\t
\t\t\tdocument.body.appendChild(div);
\t\t\tvar w = div.offsetWidth;
\t\t\tvar h = div.offsetHeight;
\t\t\tdiv.parentNode.removeChild(div);
\t\t\t
\t\t\tif (align == mxConstants.ALIGN_CENTER)
\t\t\t{
\t\t\t\tx -= w / 2;
\t\t\t}
\t\t\telse if (align == mxConstants.ALIGN_RIGHT)
\t\t\t{
\t\t\t\tx -= w;
\t\t\t}
\t\t\t
\t\t\tif (valign == mxConstants.ALIGN_MIDDLE)
\t\t\t{
\t\t\t\ty -= h / 2;
\t\t\t}
\t\t\telse if (valign == mxConstants.ALIGN_BOTTOM)
\t\t\t{
\t\t\t\ty -= h;
\t\t\t}
\t\t\t
\t\t\tbbox = new mxRectangle((x + 1) * s.scale, (y + 2) * s.scale, w * s.scale, (h + 1) * s.scale);
\t\t}
\t\t
\t\tif (bbox != null)
\t\t{
\t\t\tvar n = this.createElement('rect');
\t\t\tn.setAttribute('fill', s.fontBackgroundColor || 'none');
\t\t\tn.setAttribute('stroke', s.fontBorderColor || 'none');
\t\t\tn.setAttribute('x', Math.floor(bbox.x - 1));
\t\t\tn.setAttribute('y', Math.floor(bbox.y - 1));
\t\t\tn.setAttribute('width', Math.ceil(bbox.width + 2));
\t\t\tn.setAttribute('height', Math.ceil(bbox.height));

\t\t\tvar sw = (s.fontBorderColor != null) ? Math.max(1, this.format(s.scale)) : 0;
\t\t\tn.setAttribute('stroke-width', sw);
\t\t\t
\t\t\t// Workaround for crisp rendering - only required if not exporting
\t\t\tif (this.root.ownerDocument == document && mxUtils.mod(sw, 2) == 1)
\t\t\t{
\t\t\t\tn.setAttribute('transform', 'translate(0.5, 0.5)');
\t\t\t}
\t\t\t
\t\t\tnode.insertBefore(n, node.firstChild);
\t\t}
\t}
};

/**
 * Function: stroke
 * 
 * Paints the outline of the current path.
 */
mxSvgCanvas2D.prototype.stroke = function()
{
\tthis.addNode(false, true);
};

/**
 * Function: fill
 * 
 * Fills the current path.
 */
mxSvgCanvas2D.prototype.fill = function()
{
\tthis.addNode(true, false);
};

/**
 * Function: fillAndStroke
 * 
 * Fills and paints the outline of the current path.
 */
mxSvgCanvas2D.prototype.fillAndStroke = function()
{
\tthis.addNode(true, true);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 *
 * Class: mxVmlCanvas2D
 * 
 * Implements a canvas to be used for rendering VML. Here is an example of implementing a
 * fallback for SVG images which are not supported in VML-based browsers.
 * 
 * (code)
 * var mxVmlCanvas2DImage = mxVmlCanvas2D.prototype.image;
 * mxVmlCanvas2D.prototype.image = function(x, y, w, h, src, aspect, flipH, flipV)
 * {
 *   if (src.substring(src.length - 4, src.length) == '.svg')
 *   {
 *     src = 'http://www.jgraph.com/images/mxgraph.gif';
 *   }
 *   
 *   mxVmlCanvas2DImage.apply(this, arguments);
 * };
 * (end)
 * 
 * To disable anti-aliasing in the output, use the following code.
 * 
 * (code)
 * document.createStyleSheet().cssText = mxClient.VML_PREFIX + '\\\\:*{antialias:false;)}';
 * (end)
 * 
 * A description of the public API is available in <mxXmlCanvas2D>. Note that
 * there is a known issue in VML where gradients are painted using the outer
 * bounding box of rotated shapes, not the actual bounds of the shape. See
 * also <text> for plain text label restrictions in shapes for VML.
 */
var mxVmlCanvas2D = function(root)
{
\tmxAbstractCanvas2D.call(this);

\t/**
\t * Variable: root
\t * 
\t * Reference to the container for the SVG content.
\t */
\tthis.root = root;
};

/**
 * Extends mxAbstractCanvas2D
 */
mxUtils.extend(mxVmlCanvas2D, mxAbstractCanvas2D);

/**
 * Variable: path
 * 
 * Holds the current DOM node.
 */
mxVmlCanvas2D.prototype.node = null;

/**
 * Variable: textEnabled
 * 
 * Specifies if text output should be enabledetB. Default is true.
 */
mxVmlCanvas2D.prototype.textEnabled = true;

/**
 * Variable: moveOp
 * 
 * Contains the string used for moving in paths. Default is 'm'.
 */
mxVmlCanvas2D.prototype.moveOp = 'm';

/**
 * Variable: lineOp
 * 
 * Contains the string used for moving in paths. Default is 'l'.
 */
mxVmlCanvas2D.prototype.lineOp = 'l';

/**
 * Variable: curveOp
 * 
 * Contains the string used for bezier curves. Default is 'c'.
 */
mxVmlCanvas2D.prototype.curveOp = 'c';

/**
 * Variable: closeOp
 * 
 * Holds the operator for closing curves. Default is 'x e'.
 */
mxVmlCanvas2D.prototype.closeOp = 'x';

/**
 * Variable: rotatedHtmlBackground
 * 
 * Background color for rotated HTML. Default is ''. This can be set to eg.
 * white to improve rendering of rotated text in VML for IE9.
 */
mxVmlCanvas2D.prototype.rotatedHtmlBackground = '';

/**
 * Variable: vmlScale
 * 
 * Specifies the scale used to draw VML shapes.
 */
mxVmlCanvas2D.prototype.vmlScale = 1;

/**
 * Function: createElement
 * 
 * Creates the given element using the document.
 */
mxVmlCanvas2D.prototype.createElement = function(name)
{
\treturn document.createElement(name);
};

/**
 * Function: createVmlElement
 * 
 * Creates a new element using <createElement> and prefixes the given name with
 * <mxClient.VML_PREFIX>.
 */
mxVmlCanvas2D.prototype.createVmlElement = function(name)
{
\treturn this.createElement(mxClient.VML_PREFIX + ':' + name);
};

/**
 * Function: addNode
 * 
 * Adds the current node to the <root>.
 */
mxVmlCanvas2D.prototype.addNode = function(filled, stroked)
{
\tvar node = this.node;
\tvar s = this.state;
\t
\tif (node != null)
\t{
\t\tif (node.nodeName == 'shape')
\t\t{
\t\t\t// Checks if the path is not empty
\t\t\tif (this.path != null && this.path.length > 0)
\t\t\t{
\t\t\t\tnode.path = this.path.join(' ') + ' e';
\t\t\t\tnode.style.width = this.root.style.width;
\t\t\t\tnode.style.height = this.root.style.height;
\t\t\t\tnode.coordsize = parseInt(node.style.width) + ' ' + parseInt(node.style.height);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t}

\t\tnode.strokeweight = this.format(Math.max(1, s.strokeWidth * s.scale / this.vmlScale)) + 'px';
\t\t
\t\tif (s.shadow)
\t\t{
\t\t\tthis.root.appendChild(this.createShadow(node,
\t\t\t\tfilled && s.fillColor != null,
\t\t\t\tstroked && s.strokeColor != null));
\t\t}
\t\t
\t\tif (stroked && s.strokeColor != null)
\t\t{
\t\t\tnode.stroked = 'true';
\t\t\tnode.strokecolor = s.strokeColor;
\t\t}
\t\telse
\t\t{
\t\t\tnode.stroked = 'false';
\t\t}

\t\tnode.appendChild(this.createStroke());

\t\tif (filled && s.fillColor != null)
\t\t{
\t\t\tnode.appendChild(this.createFill());
\t\t}
\t\telse if (this.pointerEvents && (node.nodeName != 'shape' ||
\t\t\tthis.path[this.path.length - 1] == this.closeOp))
\t\t{
\t\t\tnode.appendChild(this.createTransparentFill());
\t\t}
\t\telse
\t\t{
\t\t\tnode.filled = 'false';
\t\t}

\t\t// LATER: Update existing DOM for performance
\t\tthis.root.appendChild(node);
\t}
};

/**
 * Function: createTransparentFill
 * 
 * Creates a transparent fill.
 */
mxVmlCanvas2D.prototype.createTransparentFill = function()
{
\tvar fill = this.createVmlElement('fill');
\tfill.src = mxClient.imageBasePath + '/transparent.gif';
\tfill.type = 'tile';
\t
\treturn fill;
};

/**
 * Function: createFill
 * 
 * Creates a fill for the current state.
 */
mxVmlCanvas2D.prototype.createFill = function()
{
\tvar s = this.state;
\t
\t// Gradients in foregrounds not supported because special gradients
\t// with bounds must be created for each element in graphics-canvases
\tvar fill = this.createVmlElement('fill');
\tfill.color = s.fillColor;

\tif (s.gradientColor != null)
\t{
\t\tfill.type = 'gradient';
\t\tfill.method = 'none';
\t\tfill.color2 = s.gradientColor;
\t\tvar angle = 180 - s.rotation;
\t\t
\t\tif (s.gradientDirection == mxConstants.DIRECTION_WEST)
\t\t{
\t\t\tangle -= 90 + ((this.root.style.flip == 'x') ? 180 : 0);
\t\t}
\t\telse if (s.gradientDirection == mxConstants.DIRECTION_EAST)
\t\t{
\t\t\tangle += 90 + ((this.root.style.flip == 'x') ? 180 : 0);
\t\t}
\t\telse if (s.gradientDirection == mxConstants.DIRECTION_NORTH)
\t\t{
\t\t\tangle -= 180 + ((this.root.style.flip == 'y') ? -180 : 0);
\t\t}
\t\telse
\t\t{
\t\t\t angle += ((this.root.style.flip == 'y') ? -180 : 0);
\t\t}
\t\t
\t\tif (this.root.style.flip == 'x' || this.root.style.flip == 'y')
\t\t{
\t\t\tangle *= -1;
\t\t}

\t\t// LATER: Fix outer bounding box for rotated shapes used in VML.
\t\tfill.angle = mxUtils.mod(angle, 360);
\t\tfill.opacity = (s.alpha * s.gradientFillAlpha * 100) + '%';
\t\tfill.setAttribute(mxClient.OFFICE_PREFIX + ':opacity2', (s.alpha * s.gradientAlpha * 100) + '%');
\t}
\telse if (s.alpha < 1 || s.fillAlpha < 1)
\t{
\t\tfill.opacity = (s.alpha * s.fillAlpha * 100) + '%';\t\t\t
\t}
\t
\treturn fill;
};
/**
 * Function: createStroke
 * 
 * Creates a fill for the current state.
 */
mxVmlCanvas2D.prototype.createStroke = function()
{
\tvar s = this.state;
\tvar stroke = this.createVmlElement('stroke');
\tstroke.endcap = s.lineCap || 'flat';
\tstroke.joinstyle = s.lineJoin || 'miter';
\tstroke.miterlimit = s.miterLimit || '10';
\t
\tif (s.alpha < 1 || s.strokeAlpha < 1)
\t{
\t\tstroke.opacity = (s.alpha * s.strokeAlpha * 100) + '%';
\t}
\t
\tif (s.dashed)
\t{
\t\tstroke.dashstyle = this.getVmlDashStyle();
\t}
\t
\treturn stroke;
};

/**
 * Function: getVmlDashPattern
 * 
 * Returns a VML dash pattern for the current dashPattern.
 * See http://msdn.microsoft.com/en-us/library/bb264085(v=vs.85).aspx
 */
mxVmlCanvas2D.prototype.getVmlDashStyle = function()
{
\tvar result = 'dash';
\t
\tif (typeof(this.state.dashPattern) === 'string')
\t{
\t\tvar tok = this.state.dashPattern.split(' ');
\t\t
\t\tif (tok.length > 0 && tok[0] == 1)
\t\t{
\t\t\tresult = '0 2';
\t\t}
\t}
\t
\treturn result;
};

/**
 * Function: createShadow
 * 
 * Creates a shadow for the given node.
 */
mxVmlCanvas2D.prototype.createShadow = function(node, filled, stroked)
{
\tvar s = this.state;
\tvar rad = -s.rotation * (Math.PI / 180);
\tvar cos = Math.cos(rad);
\tvar sin = Math.sin(rad);

\tvar dx = s.shadowDx * s.scale;
\tvar dy = s.shadowDy * s.scale;

\tif (this.root.style.flip == 'x')
\t{
\t\tdx *= -1;
\t}
\telse if (this.root.style.flip == 'y')
\t{
\t\tdy *= -1;
\t}
\t
\tvar shadow = node.cloneNode(true);
\tshadow.style.marginLeft = Math.round(dx * cos - dy * sin) + 'px';
\tshadow.style.marginTop = Math.round(dx * sin + dy * cos) + 'px';

\t// Workaround for wrong cloning in IE8 standards mode
\tif (document.documentMode == 8)
\t{
\t\tshadow.strokeweight = node.strokeweight;
\t\t
\t\tif (node.nodeName == 'shape')
\t\t{
\t\t\tshadow.path = this.path.join(' ') + ' e';
\t\t\tshadow.style.width = this.root.style.width;
\t\t\tshadow.style.height = this.root.style.height;
\t\t\tshadow.coordsize = parseInt(node.style.width) + ' ' + parseInt(node.style.height);
\t\t}
\t}
\t
\tif (stroked)
\t{
\t\tshadow.strokecolor = s.shadowColor;
\t\tshadow.appendChild(this.createShadowStroke());
\t}
\telse
\t{
\t\tshadow.stroked = 'false';
\t}
\t
\tif (filled)
\t{
\t\tshadow.appendChild(this.createShadowFill());
\t}
\telse
\t{
\t\tshadow.filled = 'false';
\t}
\t
\treturn shadow;
};

/**
 * Function: createShadowFill
 * 
 * Creates the fill for the shadow.
 */
mxVmlCanvas2D.prototype.createShadowFill = function()
{
\tvar fill = this.createVmlElement('fill');
\tfill.color = this.state.shadowColor;
\tfill.opacity = (this.state.alpha * this.state.shadowAlpha * 100) + '%';
\t
\treturn fill;
};

/**
 * Function: createShadowStroke
 * 
 * Creates the stroke for the shadow.
 */
mxVmlCanvas2D.prototype.createShadowStroke = function()
{
\tvar stroke = this.createStroke();
\tstroke.opacity = (this.state.alpha * this.state.shadowAlpha * 100) + '%';
\t
\treturn stroke;
};

/**
 * Function: rotate
 * 
 * Sets the rotation of the canvas. Note that rotation cannot be concatenated.
 */
mxVmlCanvas2D.prototype.rotate = function(theta, flipH, flipV, cx, cy)
{
\tif (flipH && flipV)
\t{
\t\ttheta += 180;
\t}
\telse if (flipH)
\t{
\t\tthis.root.style.flip = 'x';
\t}
\telse if (flipV)
\t{
\t\tthis.root.style.flip = 'y';
\t}

\tif (flipH ? !flipV : flipV)
\t{
\t\ttheta *= -1;
\t}

\tthis.root.style.rotation = theta;
\tthis.state.rotation = this.state.rotation + theta;
\tthis.state.rotationCx = cx;
\tthis.state.rotationCy = cy;
};

/**
 * Function: begin
 * 
 * Extends superclass to create path.
 */
mxVmlCanvas2D.prototype.begin = function()
{
\tmxAbstractCanvas2D.prototype.begin.apply(this, arguments);
\tthis.node = this.createVmlElement('shape');
\tthis.node.style.position = 'absolute';
};

/**
 * Function: quadTo
 * 
 * Replaces quadratic curve with bezier curve in VML.
 */
mxVmlCanvas2D.prototype.quadTo = function(x1, y1, x2, y2)
{
\tvar s = this.state;

\tvar cpx0 = (this.lastX + s.dx) * s.scale;
\tvar cpy0 = (this.lastY + s.dy) * s.scale;
\tvar qpx1 = (x1 + s.dx) * s.scale;
\tvar qpy1 = (y1 + s.dy) * s.scale;
\tvar cpx3 = (x2 + s.dx) * s.scale;
\tvar cpy3 = (y2 + s.dy) * s.scale;
\t
\tvar cpx1 = cpx0 + 2/3 * (qpx1 - cpx0);
\tvar cpy1 = cpy0 + 2/3 * (qpy1 - cpy0);
\t
\tvar cpx2 = cpx3 + 2/3 * (qpx1 - cpx3);
\tvar cpy2 = cpy3 + 2/3 * (qpy1 - cpy3);
\t
\tthis.path.push('c ' + this.format(cpx1) + ' ' + this.format(cpy1) +
\t\t\t' ' + this.format(cpx2) + ' ' + this.format(cpy2) +
\t\t\t' ' + this.format(cpx3) + ' ' + this.format(cpy3));
\tthis.lastX = (cpx3 / s.scale) - s.dx;
\tthis.lastY = (cpy3 / s.scale) - s.dy;
\t
};

/**
 * Function: createRect
 * 
 * Sets the glass gradient.
 */
mxVmlCanvas2D.prototype.createRect = function(nodeName, x, y, w, h)
{
\tvar s = this.state;
\tvar n = this.createVmlElement(nodeName);
\tn.style.position = 'absolute';
\tn.style.left = this.format((x + s.dx) * s.scale) + 'px';
\tn.style.top = this.format((y + s.dy) * s.scale) + 'px';
\tn.style.width = this.format(w * s.scale) + 'px';
\tn.style.height = this.format(h * s.scale) + 'px';
\t
\treturn n;
};

/**
 * Function: rect
 * 
 * Sets the current path to a rectangle.
 */
mxVmlCanvas2D.prototype.rect = function(x, y, w, h)
{
\tthis.node = this.createRect('rect', x, y, w, h);
};

/**
 * Function: roundrect
 * 
 * Sets the current path to a rounded rectangle.
 */
mxVmlCanvas2D.prototype.roundrect = function(x, y, w, h, dx, dy)
{
\tthis.node = this.createRect('roundrect', x, y, w, h);
\t// SetAttribute needed here for IE8
\tthis.node.setAttribute('arcsize', Math.max(dx * 100 / w, dy * 100 / h) + '%');
};

/**
 * Function: ellipse
 * 
 * Sets the current path to an ellipse.
 */
mxVmlCanvas2D.prototype.ellipse = function(x, y, w, h)
{
\tthis.node = this.createRect('oval', x, y, w, h);
};

/**
 * Function: image
 * 
 * Paints an image.
 */
mxVmlCanvas2D.prototype.image = function(x, y, w, h, src, aspect, flipH, flipV)
{
\tvar node = null;
\t
\tif (!aspect)
\t{
\t\tnode = this.createRect('image', x, y, w, h);
\t\tnode.src = src;
\t}
\telse
\t{
\t\t// Uses fill with aspect to avoid asynchronous update of size
\t\tnode = this.createRect('rect', x, y, w, h);
\t\tnode.stroked = 'false';
\t\t
\t\t// Handles image aspect via fill
\t\tvar fill = this.createVmlElement('fill');
\t\tfill.aspect = (aspect) ? 'atmost' : 'ignore';
\t\tfill.rotate = 'true';
\t\tfill.type = 'frame';
\t\tfill.src = src;

\t\tnode.appendChild(fill);
\t}
\t
\tif (flipH && flipV)
\t{
\t\tnode.style.rotation = '180';
\t}
\telse if (flipH)
\t{
\t\tnode.style.flip = 'x';
\t}
\telse if (flipV)
\t{
\t\tnode.style.flip = 'y';
\t}
\t
\tif (this.state.alpha < 1 || this.state.fillAlpha < 1)
\t{
\t\t// KNOWN: Borders around transparent images in IE<9. Using fill.opacity
\t\t// fixes this problem by adding a white background in all IE versions.
\t\tnode.style.filter += 'alpha(opacity=' + (this.state.alpha * this.state.fillAlpha * 100) + ')';
\t}

\tthis.root.appendChild(node);
};

/**
 * Function: createText
 * 
 * Creates the innermost element that contains the HTML text.
 */
mxVmlCanvas2D.prototype.createDiv = function(str, align, valign, overflow)
{
\tvar div = this.createElement('div');
\tvar state = this.state;

\tvar css = '';
\t
\tif (state.fontBackgroundColor != null)
\t{
\t\tcss += 'background-color:' + mxUtils.htmlEntities(state.fontBackgroundColor) + ';';
\t}
\t
\tif (state.fontBorderColor != null)
\t{
\t\tcss += 'border:1px solid ' + mxUtils.htmlEntities(state.fontBorderColor) + ';';
\t}
\t
\tif (mxUtils.isNode(str))
\t{
\t\tdiv.appendChild(str);
\t}
\telse
\t{
\t\tif (overflow != 'fill' && overflow != 'width')
\t\t{
\t\t\tvar div2 = this.createElement('div');
\t\t\tdiv2.style.cssText = css;
\t\t\tdiv2.style.display = (mxClient.IS_QUIRKS) ? 'inline' : 'inline-block';
\t\t\tdiv2.style.zoom = '1';
\t\t\tdiv2.style.textDecoration = 'inherit';
\t\t\tdiv2.innerHTML = str;
\t\t\tdiv.appendChild(div2);
\t\t}
\t\telse
\t\t{
\t\t\tdiv.style.cssText = css;
\t\t\tdiv.innerHTML = str;
\t\t}
\t}
\t
\tvar style = div.style;

\tstyle.fontSize = (state.fontSize / this.vmlScale) + 'px';
\tstyle.fontFamily = state.fontFamily;
\tstyle.color = state.fontColor;
\tstyle.verticalAlign = 'top';
\tstyle.textAlign = align || 'left';
\tstyle.lineHeight = (mxConstants.ABSOLUTE_LINE_HEIGHT) ? (state.fontSize * mxConstants.LINE_HEIGHT / this.vmlScale) + 'px' : mxConstants.LINE_HEIGHT;

\tif ((state.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t{
\t\tstyle.fontWeight = 'bold';
\t}

\tif ((state.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t{
\t\tstyle.fontStyle = 'italic';
\t}
\t
\tif ((state.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t{
\t\tstyle.textDecoration = 'underline';
\t}
\t
\treturn div;
};

/**
 * Function: text
 * 
 * Paints the given text. Possible values for format are empty string for plain
 * text and html for HTML markup. Clipping, text background and border are not
 * supported for plain text in VML.
 */
mxVmlCanvas2D.prototype.text = function(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation, dir)
{
\tif (this.textEnabled && str != null)
\t{
\t\tvar s = this.state;
\t\t
\t\tif (format == 'html')
\t\t{
\t\t\tif (s.rotation != null)
\t\t\t{
\t\t\t\tvar pt = this.rotatePoint(x, y, s.rotation, s.rotationCx, s.rotationCy);
\t\t\t\t
\t\t\t\tx = pt.x;
\t\t\t\ty = pt.y;
\t\t\t}

\t\t\tif (document.documentMode == 8 && !mxClient.IS_EM)
\t\t\t{
\t\t\t\tx += s.dx;
\t\t\t\ty += s.dy;
\t\t\t\t
\t\t\t\t// Workaround for rendering offsets
\t\t\t\tif (overflow != 'fill' && valign == mxConstants.ALIGN_TOP)
\t\t\t\t{
\t\t\t\t\ty -= 1;
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tx *= s.scale;
\t\t\t\ty *= s.scale;
\t\t\t}

\t\t\t// Adds event transparency in IE8 standards without the transparent background
\t\t\t// filter which cannot be used due to bugs in the zoomed bounding box (too slow)
\t\t\t// FIXME: No event transparency if inside v:rect (ie part of shape)
\t\t\t// KNOWN: Offset wrong for rotated text with word that are longer than the wrapping
\t\t\t// width in IE8 because real width of text cannot be determined here.
\t\t\t// This should be fixed in mxText.updateBoundingBox by calling before this and
\t\t\t// passing the real width to this method if not clipped and wrapped.
\t\t\tvar abs = (document.documentMode == 8 && !mxClient.IS_EM) ? this.createVmlElement('group') : this.createElement('div');
\t\t\tabs.style.position = 'absolute';
\t\t\tabs.style.display = 'inline';
\t\t\tabs.style.left = this.format(x) + 'px';
\t\t\tabs.style.top = this.format(y) + 'px';
\t\t\tabs.style.zoom = s.scale;

\t\t\tvar box = this.createElement('div');
\t\t\tbox.style.position = 'relative';
\t\t\tbox.style.display = 'inline';
\t\t\t
\t\t\tvar margin = mxUtils.getAlignmentAsPoint(align, valign);
\t\t\tvar dx = margin.x;
\t\t\tvar dy = margin.y;

\t\t\tvar div = this.createDiv(str, align, valign, overflow);
\t\t\tvar inner = this.createElement('div');
\t\t\t
\t\t\tif (dir != null)
\t\t\t{
\t\t\t\tdiv.setAttribute('dir', dir);
\t\t\t}

\t\t\tif (wrap && w > 0)
\t\t\t{
\t\t\t\tif (!clip)
\t\t\t\t{
\t\t\t\t\tdiv.style.width = Math.round(w) + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\tdiv.style.wordWrap = mxConstants.WORD_WRAP;
\t\t\t\tdiv.style.whiteSpace = 'normal';
\t\t\t\t
\t\t\t\t// LATER: Check if other cases need to be handled
\t\t\t\tif (div.style.wordWrap == 'break-word')
\t\t\t\t{
\t\t\t\t\tvar tmp = div;
\t\t\t\t\t
\t\t\t\t\tif (tmp.firstChild != null && tmp.firstChild.nodeName == 'DIV')
\t\t\t\t\t{
\t\t\t\t\t\ttmp.firstChild.style.width = '100%';
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tdiv.style.whiteSpace = 'nowrap';
\t\t\t}
\t\t\t
\t\t\tvar rot = s.rotation + (rotation || 0);
\t\t\t
\t\t\tif (this.rotateHtml && rot != 0)
\t\t\t{
\t\t\t\tinner.style.display = 'inline';
\t\t\t\tinner.style.zoom = '1';
\t\t\t\tinner.appendChild(div);

\t\t\t\t// Box not needed for rendering in IE8 standards
\t\t\t\tif (document.documentMode == 8 && !mxClient.IS_EM && this.root.nodeName != 'DIV')
\t\t\t\t{
\t\t\t\t\tbox.appendChild(inner);
\t\t\t\t\tabs.appendChild(box);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tabs.appendChild(inner);
\t\t\t\t}
\t\t\t}
\t\t\telse if (document.documentMode == 8 && !mxClient.IS_EM)
\t\t\t{
\t\t\t\tbox.appendChild(div);
\t\t\t\tabs.appendChild(box);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tdiv.style.display = 'inline';
\t\t\t\tabs.appendChild(div);
\t\t\t}
\t\t\t
\t\t\t// Inserts the node into the DOM
\t\t\tif (this.root.nodeName != 'DIV')
\t\t\t{
\t\t\t\t// Rectangle to fix position in group
\t\t\t\tvar rect = this.createVmlElement('rect');
\t\t\t\trect.stroked = 'false';
\t\t\t\trect.filled = 'false';

\t\t\t\trect.appendChild(abs);
\t\t\t\tthis.root.appendChild(rect);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.root.appendChild(abs);
\t\t\t}
\t\t\t
\t\t\tif (clip)
\t\t\t{
\t\t\t\tdiv.style.overflow = 'hidden';
\t\t\t\tdiv.style.width = Math.round(w) + 'px';
\t\t\t\t
\t\t\t\tif (!mxClient.IS_QUIRKS)
\t\t\t\t{
\t\t\t\t\tdiv.style.maxHeight = Math.round(h) + 'px';
\t\t\t\t}
\t\t\t}
\t\t\telse if (overflow == 'fill')
\t\t\t{
\t\t\t\t// KNOWN: Affects horizontal alignment in quirks
\t\t\t\t// but fill should only be used with align=left
\t\t\t\tdiv.style.overflow = 'hidden';
\t\t\t\tdiv.style.width = (Math.max(0, w) + 1) + 'px';
\t\t\t\tdiv.style.height = (Math.max(0, h) + 1) + 'px';
\t\t\t}
\t\t\telse if (overflow == 'width')
\t\t\t{
\t\t\t\t// KNOWN: Affects horizontal alignment in quirks
\t\t\t\t// but fill should only be used with align=left
\t\t\t\tdiv.style.overflow = 'hidden';
\t\t\t\tdiv.style.width = (Math.max(0, w) + 1) + 'px';
\t\t\t\tdiv.style.maxHeight = (Math.max(0, h) + 1) + 'px';
\t\t\t}
\t\t\t
\t\t\tif (this.rotateHtml && rot != 0)
\t\t\t{
\t\t\t\tvar rad = rot * (Math.PI / 180);
\t\t\t\t
\t\t\t\t// Precalculate cos and sin for the rotation
\t\t\t\tvar real_cos = parseFloat(parseFloat(Math.cos(rad)).toFixed(8));
\t\t\t\tvar real_sin = parseFloat(parseFloat(Math.sin(-rad)).toFixed(8));

\t\t\t\trad %= 2 * Math.PI;
\t\t\t\tif (rad < 0) rad += 2 * Math.PI;
\t\t\t\trad %= Math.PI;
\t\t\t\tif (rad > Math.PI / 2) rad = Math.PI - rad;
\t\t\t\t
\t\t\t\tvar cos = Math.cos(rad);
\t\t\t\tvar sin = Math.sin(rad);

\t\t\t\t// Adds div to document to measure size
\t\t\t\tif (document.documentMode == 8 && !mxClient.IS_EM)
\t\t\t\t{
\t\t\t\t\tdiv.style.display = 'inline-block';
\t\t\t\t\tinner.style.display = 'inline-block';
\t\t\t\t\tbox.style.display = 'inline-block';
\t\t\t\t}
\t\t\t\t
\t\t\t\tdiv.style.visibility = 'hidden';
\t\t\t\tdiv.style.position = 'absolute';
\t\t\t\tdocument.body.appendChild(div);
\t\t\t\t
\t\t\t\tvar sizeDiv = div;
\t\t\t\t
\t\t\t\tif (sizeDiv.firstChild != null && sizeDiv.firstChild.nodeName == 'DIV')
\t\t\t\t{
\t\t\t\t\tsizeDiv = sizeDiv.firstChild;
\t\t\t\t}
\t\t\t\t
\t\t\t\tvar tmp = sizeDiv.offsetWidth + 3;
\t\t\t\tvar oh = sizeDiv.offsetHeight;
\t\t\t\t
\t\t\t\tif (clip)
\t\t\t\t{
\t\t\t\t\tw = Math.min(w, tmp);
\t\t\t\t\toh = Math.min(oh, h);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tw = tmp;
\t\t\t\t}

\t\t\t\t// Handles words that are longer than the given wrapping width
\t\t\t\tif (wrap)
\t\t\t\t{
\t\t\t\t\tdiv.style.width = w + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Simulates max-height in quirks
\t\t\t\tif (mxClient.IS_QUIRKS && (clip || overflow == 'width') && oh > h)
\t\t\t\t{
\t\t\t\t\toh = h;
\t\t\t\t\t
\t\t\t\t\t// Quirks does not support maxHeight
\t\t\t\t\tdiv.style.height = oh + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\th = oh;

\t\t\t\tvar top_fix = (h - h * cos + w * -sin) / 2 - real_sin * w * (dx + 0.5) + real_cos * h * (dy + 0.5);
\t\t\t\tvar left_fix = (w - w * cos + h * -sin) / 2 + real_cos * w * (dx + 0.5) + real_sin * h * (dy + 0.5);

\t\t\t\tif (abs.nodeName == 'group' && this.root.nodeName == 'DIV')
\t\t\t\t{
\t\t\t\t\t// Workaround for bug where group gets moved away if left and top are non-zero in IE8 standards
\t\t\t\t\tvar pos = this.createElement('div');
\t\t\t\t\tpos.style.display = 'inline-block';
\t\t\t\t\tpos.style.position = 'absolute';
\t\t\t\t\tpos.style.left = this.format(x + (left_fix - w / 2) * s.scale) + 'px';
\t\t\t\t\tpos.style.top = this.format(y + (top_fix - h / 2) * s.scale) + 'px';
\t\t\t\t\t
\t\t\t\t\tabs.parentNode.appendChild(pos);
\t\t\t\t\tpos.appendChild(abs);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tvar sc = (document.documentMode == 8 && !mxClient.IS_EM) ? 1 : s.scale;
\t\t\t\t\t
\t\t\t\t\tabs.style.left = this.format(x + (left_fix - w / 2) * sc) + 'px';
\t\t\t\t\tabs.style.top = this.format(y + (top_fix - h / 2) * sc) + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\t// KNOWN: Rotated text rendering quality is bad for IE9 quirks
\t\t\t\tinner.style.filter = \"progid:DXImageTransform.Microsoft.Matrix(M11=\"+real_cos+\", M12=\"+
\t\t\t\t\treal_sin+\", M21=\"+(-real_sin)+\", M22=\"+real_cos+\", sizingMethod='auto expand')\";
\t\t\t\tinner.style.backgroundColor = this.rotatedHtmlBackground;
\t\t\t\t
\t\t\t\tif (this.state.alpha < 1)
\t\t\t\t{
\t\t\t\t\tinner.style.filter += 'alpha(opacity=' + (this.state.alpha * 100) + ')';
\t\t\t\t}

\t\t\t\t// Restore parent node for DIV
\t\t\t\tinner.appendChild(div);
\t\t\t\tdiv.style.position = '';
\t\t\t\tdiv.style.visibility = '';
\t\t\t}
\t\t\telse if (document.documentMode != 8 || mxClient.IS_EM)
\t\t\t{
\t\t\t\tdiv.style.verticalAlign = 'top';
\t\t\t\t
\t\t\t\tif (this.state.alpha < 1)
\t\t\t\t{
\t\t\t\t\tabs.style.filter = 'alpha(opacity=' + (this.state.alpha * 100) + ')';
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Adds div to document to measure size
\t\t\t\tvar divParent = div.parentNode;
\t\t\t\tdiv.style.visibility = 'hidden';
\t\t\t\tdocument.body.appendChild(div);
\t\t\t\t
\t\t\t\tw = div.offsetWidth;
\t\t\t\tvar oh = div.offsetHeight;
\t\t\t\t
\t\t\t\t// Simulates max-height in quirks
\t\t\t\tif (mxClient.IS_QUIRKS && clip && oh > h)
\t\t\t\t{
\t\t\t\t\toh = h;
\t\t\t\t\t
\t\t\t\t\t// Quirks does not support maxHeight
\t\t\t\t\tdiv.style.height = oh + 'px';
\t\t\t\t}
\t\t\t\t
\t\t\t\th = oh;
\t\t\t\t
\t\t\t\tdiv.style.visibility = '';
\t\t\t\tdivParent.appendChild(div);
\t\t\t\t
\t\t\t\tabs.style.left = this.format(x + w * dx * this.state.scale) + 'px';
\t\t\t\tabs.style.top = this.format(y + h * dy * this.state.scale) + 'px';
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tif (this.state.alpha < 1)
\t\t\t\t{
\t\t\t\t\tdiv.style.filter = 'alpha(opacity=' + (this.state.alpha * 100) + ')';
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Faster rendering in IE8 without offsetWidth/Height
\t\t\t\tbox.style.left = (dx * 100) + '%';
\t\t\t\tbox.style.top = (dy * 100) + '%';
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tthis.plainText(x, y, w, h, mxUtils.htmlEntities(str, false), align, valign, wrap, format, overflow, clip, rotation, dir);
\t\t}
\t}
};

/**
 * Function: plainText
 * 
 * Paints the outline of the current path.
 */
mxVmlCanvas2D.prototype.plainText = function(x, y, w, h, str, align, valign, wrap, format, overflow, clip, rotation, dir)
{
\t// TextDirection is ignored since this code is not used (format is always HTML in the text function)
\tvar s = this.state;
\tx = (x + s.dx) * s.scale;
\ty = (y + s.dy) * s.scale;
\t
\tvar node = this.createVmlElement('shape');
\tnode.style.width = '1px';
\tnode.style.height = '1px';
\tnode.stroked = 'false';

\tvar fill = this.createVmlElement('fill');
\tfill.color = s.fontColor;
\tfill.opacity = (s.alpha * 100) + '%';
\tnode.appendChild(fill);
\t
\tvar path = this.createVmlElement('path');
\tpath.textpathok = 'true';
\tpath.v = 'm ' + this.format(0) + ' ' + this.format(0) + ' l ' + this.format(1) + ' ' + this.format(0);
\t
\tnode.appendChild(path);
\t
\t// KNOWN: Font family and text decoration ignored
\tvar tp = this.createVmlElement('textpath');
\ttp.style.cssText = 'v-text-align:' + align;
\ttp.style.align = align;
\ttp.style.fontFamily = s.fontFamily;
\ttp.string = str;
\ttp.on = 'true';
\t
\t// Scale via fontsize instead of node.style.zoom for correct offsets in IE8
\tvar size = s.fontSize * s.scale / this.vmlScale;
\ttp.style.fontSize = size + 'px';
\t
\t// Bold
\tif ((s.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t{
\t\ttp.style.fontWeight = 'bold';
\t}
\t
\t// Italic
\tif ((s.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t{
\t\ttp.style.fontStyle = 'italic';
\t}

\t// Underline
\tif ((s.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t{
\t\ttp.style.textDecoration = 'underline';
\t}

\tvar lines = str.split('\\n');
\tvar textHeight = size + (lines.length - 1) * size * mxConstants.LINE_HEIGHT;
\tvar dx = 0;
\tvar dy = 0;

\tif (valign == mxConstants.ALIGN_BOTTOM)
\t{
\t\tdy = - textHeight / 2;
\t}
\telse if (valign != mxConstants.ALIGN_MIDDLE) // top
\t{
\t\tdy = textHeight / 2;
\t}

\tif (rotation != null)
\t{
\t\tnode.style.rotation = rotation;
\t\tvar rad = rotation * (Math.PI / 180);
\t\tdx = Math.sin(rad) * dy;
\t\tdy = Math.cos(rad) * dy;
\t}

\t// FIXME: Clipping is relative to bounding box
\t/*if (clip)
\t{
\t\tnode.style.clip = 'rect(0px ' + this.format(w) + 'px ' + this.format(h) + 'px 0px)';
\t}*/
\t
\tnode.appendChild(tp);
\tnode.style.left = this.format(x - dx) + 'px';
\tnode.style.top = this.format(y + dy) + 'px';
\t
\tthis.root.appendChild(node);
};

/**
 * Function: stroke
 * 
 * Paints the outline of the current path.
 */
mxVmlCanvas2D.prototype.stroke = function()
{
\tthis.addNode(false, true);
};

/**
 * Function: fill
 * 
 * Fills the current path.
 */
mxVmlCanvas2D.prototype.fill = function()
{
\tthis.addNode(true, false);
};

/**
 * Function: fillAndStroke
 * 
 * Fills and paints the outline of the current path.
 */
mxVmlCanvas2D.prototype.fillAndStroke = function()
{
\tthis.addNode(true, true);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxGuide
 *
 * Implements the alignment of selection cells to other cells in the graph.
 * 
 * Constructor: mxGuide
 * 
 * Constructs a new guide object.
 */
function mxGuide(graph, states)
{
\tthis.graph = graph;
\tthis.setStates(states);
};

/**
 * Variable: graph
 *
 * Reference to the enclosing <mxGraph> instance.
 */
mxGuide.prototype.graph = null;

/**
 * Variable: states
 * 
 * Contains the <mxCellStates> that are used for alignment.
 */
mxGuide.prototype.states = null;

/**
 * Variable: horizontal
 *
 * Specifies if horizontal guides are enabled. Default is true.
 */
mxGuide.prototype.horizontal = true;

/**
 * Variable: vertical
 *
 * Specifies if vertical guides are enabled. Default is true.
 */
mxGuide.prototype.vertical = true;

/**
 * Variable: guideX
 *
 * Holds the <mxShape> for the horizontal guide.
 */
mxGuide.prototype.guideX = null;

/**
 * Variable: guideY
 *
 * Holds the <mxShape> for the vertical guide.
 */
mxGuide.prototype.guideY = null;

/**
 * Variable: rounded
 *
 * Specifies if rounded coordinates should be used. Default is false.
 */
mxGuide.prototype.rounded = false;

/**
 * Variable: tolerance
 * 
 * Default tolerance in px if grid is disabled. Default is 2.
 */
mxGuide.prototype.tolerance = 2;

/**
 * Function: setStates
 * 
 * Sets the <mxCellStates> that should be used for alignment.
 */
mxGuide.prototype.setStates = function(states)
{
\tthis.states = states;
};

/**
 * Function: isEnabledForEvent
 * 
 * Returns true if the guide should be enabled for the given native event. This
 * implementation always returns true.
 */
mxGuide.prototype.isEnabledForEvent = function(evt)
{
\treturn true;
};

/**
 * Function: getGuideTolerance
 * 
 * Returns the tolerance for the guides. Default value is gridSize / 2.
 */
mxGuide.prototype.getGuideTolerance = function(gridEnabled)
{
\treturn (gridEnabled && this.graph.gridEnabled) ? this.graph.gridSize / 2 : this.tolerance;
};

/**
 * Function: createGuideShape
 * 
 * Returns the mxShape to be used for painting the respective guide. This
 * implementation returns a new, dashed and crisp <mxPolyline> using
 * <mxConstants.GUIDE_COLOR> and <mxConstants.GUIDE_STROKEWIDTH> as the format.
 * 
 * Parameters:
 * 
 * horizontal - Boolean that specifies which guide should be created.
 */
mxGuide.prototype.createGuideShape = function(horizontal)
{
\tvar guide = new mxPolyline([], mxConstants.GUIDE_COLOR, mxConstants.GUIDE_STROKEWIDTH);
\tguide.isDashed = true;
\t
\treturn guide;
};

/**
 * Function: isStateIgnored
 * 
 * Returns true if the given state should be ignored.
 */
mxGuide.prototype.isStateIgnored = function(state)
{
\treturn false;
};

/**
 * Function: move
 * 
 * Moves the <bounds> by the given <mxPoint> and returnt the snapped point.
 */
mxGuide.prototype.move = function(bounds, delta, gridEnabled, clone)
{
\tif (this.states != null && (this.horizontal || this.vertical) && bounds != null && delta != null)
\t{
\t\tvar scale = this.graph.getView().scale;
\t\tvar tt = this.getGuideTolerance(gridEnabled) * scale;
\t\tvar b = bounds.clone();
\t\tb.x += delta.x;
\t\tb.y += delta.y;
\t\tvar overrideX = false;
\t\tvar stateX = null;
\t\tvar valueX = null;
\t\tvar overrideY = false;
\t\tvar stateY = null;
\t\tvar valueY = null;
\t\tvar ttX = tt;
\t\tvar ttY = tt;
\t\tvar left = b.x;
\t\tvar right = b.x + b.width;
\t\tvar center = b.getCenterX();
\t\tvar top = b.y;
\t\tvar bottom = b.y + b.height;
\t\tvar middle = b.getCenterY();
\t
\t\t// Snaps the left, center and right to the given x-coordinate
\t\tfunction snapX(x, state, centerAlign)
\t\t{
\t\t\tvar override = false;
\t\t\t
\t\t\tif (centerAlign && Math.abs(x - center) < ttX)
\t\t\t{
\t\t\t\tdelta.x = x - bounds.getCenterX();
\t\t\t\tttX = Math.abs(x - center);
\t\t\t\toverride = true;
\t\t\t}
\t\t\telse if (!centerAlign)
\t\t\t{
\t\t\t\tif (Math.abs(x - left) < ttX)
\t\t\t\t{
\t\t\t\t\tdelta.x = x - bounds.x;
\t\t\t\t\tttX = Math.abs(x - left);
\t\t\t\t\toverride = true;
\t\t\t\t}
\t\t\t\telse if (Math.abs(x - right) < ttX)
\t\t\t\t{
\t\t\t\t\tdelta.x = x - bounds.x - bounds.width;
\t\t\t\t\tttX = Math.abs(x - right);
\t\t\t\t\toverride = true;
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tif (override)
\t\t\t{
\t\t\t\tstateX = state;
\t\t\t\tvalueX = x;
\t\t\t\t
\t\t\t\tif (this.guideX == null)
\t\t\t\t{
\t\t\t\t\tthis.guideX = this.createGuideShape(true);
\t\t\t\t\t
\t\t\t\t\t// Makes sure to use either VML or SVG shapes in order to implement
\t\t\t\t\t// event-transparency on the background area of the rectangle since
\t\t\t\t\t// HTML shapes do not let mouseevents through even when transparent
\t\t\t\t\tthis.guideX.dialect = (this.graph.dialect != mxConstants.DIALECT_SVG) ?
\t\t\t\t\t\tmxConstants.DIALECT_VML : mxConstants.DIALECT_SVG;
\t\t\t\t\tthis.guideX.pointerEvents = false;
\t\t\t\t\tthis.guideX.init(this.graph.getView().getOverlayPane());
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\toverrideX = overrideX || override;
\t\t};
\t\t
\t\t// Snaps the top, middle or bottom to the given y-coordinate
\t\tfunction snapY(y, state, centerAlign)
\t\t{
\t\t\tvar override = false;
\t\t\t
\t\t\tif (centerAlign && Math.abs(y - middle) < ttY)
\t\t\t{
\t\t\t\tdelta.y = y - bounds.getCenterY();
\t\t\t\tttY = Math.abs(y -  middle);
\t\t\t\toverride = true;
\t\t\t}
\t\t\telse if (!centerAlign)
\t\t\t{
\t\t\t\tif (Math.abs(y - top) < ttY)
\t\t\t\t{
\t\t\t\t\tdelta.y = y - bounds.y;
\t\t\t\t\tttY = Math.abs(y - top);
\t\t\t\t\toverride = true;
\t\t\t\t}
\t\t\t\telse if (Math.abs(y - bottom) < ttY)
\t\t\t\t{
\t\t\t\t\tdelta.y = y - bounds.y - bounds.height;
\t\t\t\t\tttY = Math.abs(y - bottom);
\t\t\t\t\toverride = true;
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tif (override)
\t\t\t{
\t\t\t\tstateY = state;
\t\t\t\tvalueY = y;
\t\t\t\t
\t\t\t\tif (this.guideY == null)
\t\t\t\t{
\t\t\t\t\tthis.guideY = this.createGuideShape(false);
\t\t\t\t\t
\t\t\t\t\t// Makes sure to use either VML or SVG shapes in order to implement
\t\t\t\t\t// event-transparency on the background area of the rectangle since
\t\t\t\t\t// HTML shapes do not let mouseevents through even when transparent
\t\t\t\t\tthis.guideY.dialect = (this.graph.dialect != mxConstants.DIALECT_SVG) ?
\t\t\t\t\t\tmxConstants.DIALECT_VML : mxConstants.DIALECT_SVG;
\t\t\t\t\tthis.guideY.pointerEvents = false;
\t\t\t\t\tthis.guideY.init(this.graph.getView().getOverlayPane());
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\toverrideY = overrideY || override;
\t\t};
\t\t
\t\tfor (var i = 0; i < this.states.length; i++)
\t\t{
\t\t\tvar state =  this.states[i];
\t\t\t
\t\t\tif (state != null && !this.isStateIgnored(state))
\t\t\t{
\t\t\t\t// Align x
\t\t\t\tif (this.horizontal)
\t\t\t\t{
\t\t\t\t\tsnapX.call(this, state.getCenterX(), state, true);
\t\t\t\t\tsnapX.call(this, state.x, state, false);
\t\t\t\t\tsnapX.call(this, state.x + state.width, state, false);
\t\t\t\t\t
\t\t\t\t\t// Aligns left and right of shape to center of page
\t\t\t\t\tif (state.cell == null)
\t\t\t\t\t{
\t\t\t\t\t\tsnapX.call(this, state.getCenterX(), state, false);
\t\t\t\t\t}
\t\t\t\t}
\t
\t\t\t\t// Align y
\t\t\t\tif (this.vertical)
\t\t\t\t{
\t\t\t\t\tsnapY.call(this, state.getCenterY(), state, true);
\t\t\t\t\tsnapY.call(this, state.y, state, false);
\t\t\t\t\tsnapY.call(this, state.y + state.height, state, false);
\t\t\t\t\t
\t\t\t\t\t// Aligns left and right of shape to center of page
\t\t\t\t\tif (state.cell == null)
\t\t\t\t\t{
\t\t\t\t\t\tsnapY.call(this, state.getCenterY(), state, false);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}

\t\t// Moves cells to the raster if not aligned
\t\tthis.graph.snapDelta(delta, bounds, !gridEnabled, overrideX, overrideY);
\t\tdelta = this.getDelta(bounds, stateX, delta.x, stateY, delta.y)
\t\t
\t\t// Redraws the guides
\t\tvar c = this.graph.container;
\t\t
\t\tif (!overrideX && this.guideX != null)
\t\t{
\t\t\tthis.guideX.node.style.visibility = 'hidden';
\t\t}
\t\telse if (this.guideX != null)
\t\t{
\t\t\tvar minY = null;
        \tvar maxY = null;
        \t
\t\t\tif (stateX != null && bounds != null)
\t\t\t{
\t\t\t\tminY = Math.min(bounds.y + delta.y - this.graph.panDy, stateX.y);
\t\t\t\tmaxY = Math.max(bounds.y + bounds.height + delta.y - this.graph.panDy, stateX.y + stateX.height);
\t\t\t}
\t\t\t
\t\t\tif (minY != null && maxY != null)
\t\t\t{
\t\t\t\tthis.guideX.points = [new mxPoint(valueX, minY), new mxPoint(valueX, maxY)];
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.guideX.points = [new mxPoint(valueX, -this.graph.panDy),
\t\t\t\t\tnew mxPoint(valueX, c.scrollHeight - 3 - this.graph.panDy)];
\t\t\t}
\t\t\t
\t\t\tthis.guideX.stroke = this.getGuideColor(stateX, true);
\t\t\tthis.guideX.node.style.visibility = 'visible';
\t\t\tthis.guideX.redraw();
\t\t}
\t\t
\t\tif (!overrideY && this.guideY != null)
\t\t{
\t\t\tthis.guideY.node.style.visibility = 'hidden';
\t\t}
\t\telse if (this.guideY != null)
\t\t{
\t\t\tvar minX = null;
        \tvar maxX = null;
        \t
\t\t\tif (stateY != null && bounds != null)
\t\t\t{
\t\t\t\tminX = Math.min(bounds.x + delta.x - this.graph.panDx, stateY.x);
\t\t\t\tmaxX = Math.max(bounds.x + bounds.width + delta.x - this.graph.panDx, stateY.x + stateY.width);
\t\t\t}
\t\t\t
\t\t\tif (minX != null && maxX != null)
\t\t\t{
\t\t\t\tthis.guideY.points = [new mxPoint(minX, valueY), new mxPoint(maxX, valueY)];
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.guideY.points = [new mxPoint(-this.graph.panDx, valueY),
\t\t\t\t\tnew mxPoint(c.scrollWidth - 3 - this.graph.panDx, valueY)];
\t\t\t}
\t\t\t
\t\t\tthis.guideY.stroke = this.getGuideColor(stateY, false);
\t\t\tthis.guideY.node.style.visibility = 'visible';
\t\t\tthis.guideY.redraw();
\t\t}
\t}
\t
\treturn delta;
};

/**
 * Function: getDelta
 * 
 * Rounds to pixels for virtual states (eg. page guides)
 */
mxGuide.prototype.getDelta = function(bounds, stateX, dx, stateY, dy)
{
\tvar s = this.graph.view.scale;
\t
\tif (this.rounded || (stateX != null && stateX.cell == null))
\t{
\t\tdx = Math.round((bounds.x + dx) / s) * s - bounds.x;
\t}

\tif (this.rounded || (stateY != null && stateY.cell == null))
\t{
\t\tdy = Math.round((bounds.y + dy) / s) * s - bounds.y;
\t}
\t
\treturn new mxPoint(dx, dy);
};

/**
 * Function: getGuideColor
 * 
 * Returns the color for the given state.
 */
mxGuide.prototype.getGuideColor = function(state, horizontal)
{
\treturn mxConstants.GUIDE_COLOR;
};

/**
 * Function: hide
 * 
 * Hides all current guides.
 */
mxGuide.prototype.hide = function()
{
\tthis.setVisible(false);
};

/**
 * Function: setVisible
 * 
 * Shows or hides the current guides.
 */
mxGuide.prototype.setVisible = function(visible)
{
\tif (this.guideX != null)
\t{
\t\tthis.guideX.node.style.visibility = (visible) ? 'visible' : 'hidden';
\t}
\t
\tif (this.guideY != null)
\t{
\t\tthis.guideY.node.style.visibility = (visible) ? 'visible' : 'hidden';
\t}
};

/**
 * Function: destroy
 * 
 * Destroys all resources that this object uses.
 */
mxGuide.prototype.destroy = function()
{
\tif (this.guideX != null)
\t{
\t\tthis.guideX.destroy();
\t\tthis.guideX = null;
\t}
\t
\tif (this.guideY != null)
\t{
\t\tthis.guideY.destroy();
\t\tthis.guideY = null;
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxShape
 *
 * Base class for all shapes. A shape in mxGraph is a
 * separate implementation for SVG, VML and HTML. Which
 * implementation to use is controlled by the <dialect>
 * property which is assigned from within the <mxCellRenderer>
 * when the shape is created. The dialect must be assigned
 * for a shape, and it does normally depend on the browser and
 * the confiuration of the graph (see <mxGraph> rendering hint).
 *
 * For each supported shape in SVG and VML, a corresponding
 * shape exists in mxGraph, namely for text, image, rectangle,
 * rhombus, ellipse and polyline. The other shapes are a
 * combination of these shapes (eg. label and swimlane)
 * or they consist of one or more (filled) path objects
 * (eg. actor and cylinder). The HTML implementation is
 * optional but may be required for a HTML-only view of
 * the graph.
 *
 * Custom Shapes:
 *
 * To extend from this class, the basic code looks as follows.
 * In the special case where the custom shape consists only of
 * one filled region or one filled region and an additional stroke
 * the <mxActor> and <mxCylinder> should be subclassed,
 * respectively.
 *
 * (code)
 * function CustomShape() { }
 * 
 * CustomShape.prototype = new mxShape();
 * CustomShape.prototype.constructor = CustomShape; 
 * (end)
 *
 * To register a custom shape in an existing graph instance,
 * one must register the shape under a new name in the graph's
 * cell renderer as follows:
 *
 * (code)
 * mxCellRenderer.registerShape('customShape', CustomShape);
 * (end)
 *
 * The second argument is the name of the constructor.
 *
 * In order to use the shape you can refer to the given name above
 * in a stylesheet. For example, to change the shape for the default
 * vertex style, the following code is used:
 *
 * (code)
 * var style = graph.getStylesheet().getDefaultVertexStyle();
 * style[mxConstants.STYLE_SHAPE] = 'customShape';
 * (end)
 * 
 * Constructor: mxShape
 *
 * Constructs a new shape.
 */
function mxShape(stencil)
{
\tthis.stencil = stencil;
\tthis.initStyles();
};

/**
 * Variable: dialect
 *
 * Holds the dialect in which the shape is to be painted.
 * This can be one of the DIALECT constants in <mxConstants>.
 */
mxShape.prototype.dialect = null;

/**
 * Variable: scale
 *
 * Holds the scale in which the shape is being painted.
 */
mxShape.prototype.scale = 1;

/**
 * Variable: antiAlias
 * 
 * Rendering hint for configuring the canvas.
 */
mxShape.prototype.antiAlias = true;

/**
 * Variable: minSvgStrokeWidth
 * 
 * Minimum stroke width for SVG output.
 */
mxShape.prototype.minSvgStrokeWidth = 1;

/**
 * Variable: bounds
 *
 * Holds the <mxRectangle> that specifies the bounds of this shape.
 */
mxShape.prototype.bounds = null;

/**
 * Variable: points
 *
 * Holds the array of <mxPoints> that specify the points of this shape.
 */
mxShape.prototype.points = null;

/**
 * Variable: node
 *
 * Holds the outermost DOM node that represents this shape.
 */
mxShape.prototype.node = null;
 
/**
 * Variable: state
 * 
 * Optional reference to the corresponding <mxCellState>.
 */
mxShape.prototype.state = null;

/**
 * Variable: style
 *
 * Optional reference to the style of the corresponding <mxCellState>.
 */
mxShape.prototype.style = null;

/**
 * Variable: boundingBox
 *
 * Contains the bounding box of the shape, that is, the smallest rectangle
 * that includes all pixels of the shape.
 */
mxShape.prototype.boundingBox = null;

/**
 * Variable: stencil
 *
 * Holds the <mxStencil> that defines the shape.
 */
mxShape.prototype.stencil = null;

/**
 * Variable: svgStrokeTolerance
 *
 * Event-tolerance for SVG strokes (in px). Default is 8. This is only passed
 * to the canvas in <createSvgCanvas> if <pointerEvents> is true.
 */
mxShape.prototype.svgStrokeTolerance = 8;

/**
 * Variable: pointerEvents
 * 
 * Specifies if pointer events should be handled. Default is true.
 */
mxShape.prototype.pointerEvents = true;

/**
 * Variable: svgPointerEvents
 * 
 * Specifies if pointer events should be handled. Default is true.
 */
mxShape.prototype.svgPointerEvents = 'all';

/**
 * Variable: shapePointerEvents
 * 
 * Specifies if pointer events outside of shape should be handled. Default
 * is false.
 */
mxShape.prototype.shapePointerEvents = false;

/**
 * Variable: stencilPointerEvents
 * 
 * Specifies if pointer events outside of stencils should be handled. Default
 * is false. Set this to true for backwards compatibility with the 1.x branch.
 */
mxShape.prototype.stencilPointerEvents = false;

/**
 * Variable: vmlScale
 * 
 * Scale for improving the precision of VML rendering. Default is 1.
 */
mxShape.prototype.vmlScale = 1;

/**
 * Variable: outline
 * 
 * Specifies if the shape should be drawn as an outline. This disables all
 * fill colors and can be used to disable other drawing states that should
 * not be painted for outlines. Default is false. This should be set before
 * calling <apply>.
 */
mxShape.prototype.outline = false;

/**
 * Variable: visible
 * 
 * Specifies if the shape is visible. Default is true.
 */
mxShape.prototype.visible = true;

/**
 * Variable: useSvgBoundingBox
 * 
 * Allows to use the SVG bounding box in SVG. Default is false for performance
 * reasons.
 */
mxShape.prototype.useSvgBoundingBox = false;

/**
 * Function: init
 *
 * Initializes the shape by creaing the DOM node using <create>
 * and adding it into the given container.
 *
 * Parameters:
 *
 * container - DOM node that will contain the shape.
 */
mxShape.prototype.init = function(container)
{
\tif (this.node == null)
\t{
\t\tthis.node = this.create(container);
\t\t
\t\tif (container != null)
\t\t{
\t\t\tcontainer.appendChild(this.node);
\t\t}
\t}
};

/**
 * Function: initStyles
 *
 * Sets the styles to their default values.
 */
mxShape.prototype.initStyles = function(container)
{
\tthis.strokewidth = 1;
\tthis.rotation = 0;
\tthis.opacity = 100;
\tthis.fillOpacity = 100;
\tthis.strokeOpacity = 100;
\tthis.flipH = false;
\tthis.flipV = false;
};

/**
 * Function: isParseVml
 * 
 * Specifies if any VML should be added via insertAdjacentHtml to the DOM. This
 * is only needed in IE8 and only if the shape contains VML markup. This method
 * returns true.
 */
mxShape.prototype.isParseVml = function()
{
\treturn true;
};

/**
 * Function: isHtmlAllowed
 * 
 * Returns true if HTML is allowed for this shape. This implementation always
 * returns false.
 */
mxShape.prototype.isHtmlAllowed = function()
{
\treturn false;
};

/**
 * Function: getSvgScreenOffset
 * 
 * Returns 0, or 0.5 if <strokewidth> % 2 == 1.
 */
mxShape.prototype.getSvgScreenOffset = function()
{
\tvar sw = this.stencil && this.stencil.strokewidth != 'inherit' ? Number(this.stencil.strokewidth) : this.strokewidth;
\t
\treturn (mxUtils.mod(Math.max(1, Math.round(sw * this.scale)), 2) == 1) ? 0.5 : 0;
};

/**
 * Function: create
 *
 * Creates and returns the DOM node(s) for the shape in
 * the given container. This implementation invokes
 * <createSvg>, <createHtml> or <createVml> depending
 * on the <dialect> and style settings.
 *
 * Parameters:
 *
 * container - DOM node that will contain the shape.
 */
mxShape.prototype.create = function(container)
{
\tvar node = null;
\t
\tif (container != null && container.ownerSVGElement != null)
\t{
\t\tnode = this.createSvg(container);
\t}
\telse if (document.documentMode == 8 || !mxClient.IS_VML ||
\t\t(this.dialect != mxConstants.DIALECT_VML && this.isHtmlAllowed()))
\t{
\t\tnode = this.createHtml(container);
\t}
\telse
\t{
\t\tnode = this.createVml(container);
\t}
\t
\treturn node;
};

/**
 * Function: createSvg
 *
 * Creates and returns the SVG node(s) to represent this shape.
 */
mxShape.prototype.createSvg = function()
{
\treturn document.createElementNS(mxConstants.NS_SVG, 'g');
};

/**
 * Function: createVml
 *
 * Creates and returns the VML node to represent this shape.
 */
mxShape.prototype.createVml = function()
{
\tvar node = document.createElement(mxClient.VML_PREFIX + ':group');
\tnode.style.position = 'absolute';
\t
\treturn node;
};

/**
 * Function: createHtml
 *
 * Creates and returns the HTML DOM node(s) to represent
 * this shape. This implementation falls back to <createVml>
 * so that the HTML creation is optional.
 */
mxShape.prototype.createHtml = function()
{
\tvar node = document.createElement('div');
\tnode.style.position = 'absolute';
\t
\treturn node;
};

/**
 * Function: reconfigure
 *
 * Reconfigures this shape. This will update the colors etc in
 * addition to the bounds or points.
 */
mxShape.prototype.reconfigure = function()
{
\tthis.redraw();
};

/**
 * Function: redraw
 *
 * Creates and returns the SVG node(s) to represent this shape.
 */
mxShape.prototype.redraw = function()
{
\tthis.updateBoundsFromPoints();
\t
\tif (this.visible && this.checkBounds())
\t{
\t\tthis.node.style.visibility = 'visible';
\t\tthis.clear();
\t\t
\t\tif (this.node.nodeName == 'DIV' && (this.isHtmlAllowed() || !mxClient.IS_VML))
\t\t{
\t\t\tthis.redrawHtmlShape();
\t\t}
\t\telse
\t\t{\t
\t\t\tthis.redrawShape();
\t\t}

\t\tthis.updateBoundingBox();
\t}
\telse
\t{
\t\tthis.node.style.visibility = 'hidden';
\t\tthis.boundingBox = null;
\t}
};

/**
 * Function: clear
 * 
 * Removes all child nodes and resets all CSS.
 */
mxShape.prototype.clear = function()
{
\tif (this.node.ownerSVGElement != null)
\t{
\t\twhile (this.node.lastChild != null)
\t\t{
\t\t\tthis.node.removeChild(this.node.lastChild);
\t\t}
\t}
\telse
\t{
\t\tthis.node.style.cssText = 'position:absolute;' + ((this.cursor != null) ?
\t\t\t('cursor:' + this.cursor + ';') : '');
\t\tthis.node.innerHTML = '';
\t}
};

/**
 * Function: updateBoundsFromPoints
 * 
 * Updates the bounds based on the points.
 */
mxShape.prototype.updateBoundsFromPoints = function()
{
\tvar pts = this.points;
\t
\tif (pts != null && pts.length > 0 && pts[0] != null)
\t{
\t\tthis.bounds = new mxRectangle(Number(pts[0].x), Number(pts[0].y), 1, 1);
\t\t
\t\tfor (var i = 1; i < this.points.length; i++)
\t\t{
\t\t\tif (pts[i] != null)
\t\t\t{
\t\t\t\tthis.bounds.add(new mxRectangle(Number(pts[i].x), Number(pts[i].y), 1, 1));
\t\t\t}
\t\t}
\t}
};

/**
 * Function: getLabelBounds
 * 
 * Returns the <mxRectangle> for the label bounds of this shape, based on the
 * given scaled and translated bounds of the shape. This method should not
 * change the rectangle in-place. This implementation returns the given rect.
 */
mxShape.prototype.getLabelBounds = function(rect)
{
\tvar d = mxUtils.getValue(this.style, mxConstants.STYLE_DIRECTION, mxConstants.DIRECTION_EAST);
\tvar bounds = rect;
\t
\t// Normalizes argument for getLabelMargins hook
\tif (d != mxConstants.DIRECTION_SOUTH && d != mxConstants.DIRECTION_NORTH &&
\t\tthis.state != null && this.state.text != null &&
\t\tthis.state.text.isPaintBoundsInverted())
\t{
\t\tbounds = bounds.clone();
\t\tvar tmp = bounds.width;
\t\tbounds.width = bounds.height;
\t\tbounds.height = tmp;
\t}
\t\t
\tvar m = this.getLabelMargins(bounds);
\t
\tif (m != null)
\t{
\t\tvar flipH = mxUtils.getValue(this.style, mxConstants.STYLE_FLIPH, false) == '1';
\t\tvar flipV = mxUtils.getValue(this.style, mxConstants.STYLE_FLIPV, false) == '1';
\t\t
\t\t// Handles special case for vertical labels
\t\tif (this.state != null && this.state.text != null &&
\t\t\tthis.state.text.isPaintBoundsInverted())
\t\t{
\t\t\tvar tmp = m.x;
\t\t\tm.x = m.height;
\t\t\tm.height = m.width;
\t\t\tm.width = m.y;
\t\t\tm.y = tmp;

\t\t\ttmp = flipH;
\t\t\tflipH = flipV;
\t\t\tflipV = tmp;
\t\t}
\t\t
\t\treturn mxUtils.getDirectedBounds(rect, m, this.style, flipH, flipV);
\t}
\t
\treturn rect;
};

/**
 * Function: getLabelMargins
 * 
 * Returns the scaled top, left, bottom and right margin to be used for
 * computing the label bounds as an <mxRectangle>, where the bottom and right
 * margin are defined in the width and height of the rectangle, respectively.
 */
mxShape.prototype.getLabelMargins= function(rect)
{
\treturn null;
};

/**
 * Function: checkBounds
 * 
 * Returns true if the bounds are not null and all of its variables are numeric.
 */
mxShape.prototype.checkBounds = function()
{
\treturn (!isNaN(this.scale) && isFinite(this.scale) && this.scale > 0 &&
\t\t\tthis.bounds != null && !isNaN(this.bounds.x) && !isNaN(this.bounds.y) &&
\t\t\t!isNaN(this.bounds.width) && !isNaN(this.bounds.height) &&
\t\t\tthis.bounds.width > 0 && this.bounds.height > 0);
};

/**
 * Function: createVmlGroup
 *
 * Returns the temporary element used for rendering in IE8 standards mode.
 */
mxShape.prototype.createVmlGroup = function()
{
\tvar node = document.createElement(mxClient.VML_PREFIX + ':group');
\tnode.style.position = 'absolute';
\tnode.style.width = this.node.style.width;
\tnode.style.height = this.node.style.height;
\t
\treturn node;
};

/**
 * Function: redrawShape
 *
 * Updates the SVG or VML shape.
 */
mxShape.prototype.redrawShape = function()
{
\tvar canvas = this.createCanvas();
\t
\tif (canvas != null)
\t{
\t\t// Specifies if events should be handled
\t\tcanvas.pointerEvents = this.pointerEvents;
\t
\t\tthis.beforePaint(canvas);
\t\tthis.paint(canvas);
\t\tthis.afterPaint(canvas);
\t
\t\tif (this.node != canvas.root)
\t\t{
\t\t\t// Forces parsing in IE8 standards mode - slow! avoid
\t\t\tthis.node.insertAdjacentHTML('beforeend', canvas.root.outerHTML);
\t\t}
\t
\t\tif (this.node.nodeName == 'DIV' && document.documentMode == 8)
\t\t{
\t\t\t// Makes DIV transparent to events for IE8 in IE8 standards
\t\t\t// mode (Note: Does not work for IE9 in IE8 standards mode
\t\t\t// and not for IE11 in enterprise mode)
\t\t\tthis.node.style.filter = '';
\t\t\t
\t\t\t// Adds event transparency in IE8 standards
\t\t\tmxUtils.addTransparentBackgroundFilter(this.node);
\t\t}
\t\t
\t\tthis.destroyCanvas(canvas);
\t}
};

/**
 * Function: createCanvas
 * 
 * Creates a new canvas for drawing this shape. May return null.
 */
mxShape.prototype.createCanvas = function()
{
\tvar canvas = null;
\t
\t// LATER: Check if reusing existing DOM nodes improves performance
\tif (this.node.ownerSVGElement != null)
\t{
\t\tcanvas = this.createSvgCanvas();
\t}
\telse if (mxClient.IS_VML)
\t{
\t\tthis.updateVmlContainer();
\t\tcanvas = this.createVmlCanvas();
\t}
\t
\tif (canvas != null && this.outline)
\t{
\t\tcanvas.setStrokeWidth(this.strokewidth);
\t\tcanvas.setStrokeColor(this.stroke);
\t\t
\t\tif (this.isDashed != null)
\t\t{
\t\t\tcanvas.setDashed(this.isDashed);
\t\t}
\t\t
\t\tcanvas.setStrokeWidth = function() {};
\t\tcanvas.setStrokeColor = function() {};
\t\tcanvas.setFillColor = function() {};
\t\tcanvas.setGradient = function() {};
\t\tcanvas.setDashed = function() {};
\t\tcanvas.text = function() {};
\t}

\treturn canvas;
};

/**
 * Function: createSvgCanvas
 * 
 * Creates and returns an <mxSvgCanvas2D> for rendering this shape.
 */
mxShape.prototype.createSvgCanvas = function()
{
\tvar canvas = new mxSvgCanvas2D(this.node, false);
\tcanvas.strokeTolerance = (this.pointerEvents) ? this.svgStrokeTolerance : 0;
\tcanvas.pointerEventsValue = this.svgPointerEvents;
\tvar off = this.getSvgScreenOffset();

\tif (off != 0)
\t{
\t\tthis.node.setAttribute('transform', 'translate(' + off + ',' + off + ')');
\t}
\telse
\t{
\t\tthis.node.removeAttribute('transform');
\t}

\tcanvas.minStrokeWidth = this.minSvgStrokeWidth;
\t
\tif (!this.antiAlias)
\t{
\t\t// Rounds all numbers in the SVG output to integers
\t\tcanvas.format = function(value)
\t\t{
\t\t\treturn Math.round(parseFloat(value));
\t\t};
\t}
\t
\treturn canvas;
};

/**
 * Function: createVmlCanvas
 * 
 * Creates and returns an <mxVmlCanvas2D> for rendering this shape.
 */
mxShape.prototype.createVmlCanvas = function()
{
\t// Workaround for VML rendering bug in IE8 standards mode
\tvar node = (document.documentMode == 8 && this.isParseVml()) ? this.createVmlGroup() : this.node;
\tvar canvas = new mxVmlCanvas2D(node, false);
\t
\tif (node.tagUrn != '')
\t{
\t\tvar w = Math.max(1, Math.round(this.bounds.width));
\t\tvar h = Math.max(1, Math.round(this.bounds.height));
\t\tnode.coordsize = (w * this.vmlScale) + ',' + (h * this.vmlScale);
\t\tcanvas.scale(this.vmlScale);
\t\tcanvas.vmlScale = this.vmlScale;
\t}

\t// Painting relative to top, left shape corner
\tvar s = this.scale;
\tcanvas.translate(-Math.round(this.bounds.x / s), -Math.round(this.bounds.y / s));
\t
\treturn canvas;
};

/**
 * Function: updateVmlContainer
 * 
 * Updates the bounds of the VML container.
 */
mxShape.prototype.updateVmlContainer = function()
{
\tthis.node.style.left = Math.round(this.bounds.x) + 'px';
\tthis.node.style.top = Math.round(this.bounds.y) + 'px';
\tvar w = Math.max(1, Math.round(this.bounds.width));
\tvar h = Math.max(1, Math.round(this.bounds.height));
\tthis.node.style.width = w + 'px';
\tthis.node.style.height = h + 'px';
\tthis.node.style.overflow = 'visible';
};

/**
 * Function: redrawHtml
 *
 * Allow optimization by replacing VML with HTML.
 */
mxShape.prototype.redrawHtmlShape = function()
{
\t// LATER: Refactor methods
\tthis.updateHtmlBounds(this.node);
\tthis.updateHtmlFilters(this.node);
\tthis.updateHtmlColors(this.node);
};

/**
 * Function: updateHtmlFilters
 *
 * Allow optimization by replacing VML with HTML.
 */
mxShape.prototype.updateHtmlFilters = function(node)
{
\tvar f = '';
\t
\tif (this.opacity < 100)
\t{
\t\tf += 'alpha(opacity=' + (this.opacity) + ')';
\t}
\t
\tif (this.isShadow)
\t{
\t\t// FIXME: Cannot implement shadow transparency with filter
\t\tf += 'progid:DXImageTransform.Microsoft.dropShadow (' +
\t\t\t'OffX=\\'' + Math.round(mxConstants.SHADOW_OFFSET_X * this.scale) + '\\', ' +
\t\t\t'OffY=\\'' + Math.round(mxConstants.SHADOW_OFFSET_Y * this.scale) + '\\', ' +
\t\t\t'Color=\\'' + mxConstants.VML_SHADOWCOLOR + '\\')';
\t}
\t
\tif (this.fill != null && this.fill != mxConstants.NONE && this.gradient && this.gradient != mxConstants.NONE)
\t{
\t\tvar start = this.fill;
\t\tvar end = this.gradient;
\t\tvar type = '0';
\t\t
\t\tvar lookup = {east:0,south:1,west:2,north:3};
\t\tvar dir = (this.direction != null) ? lookup[this.direction] : 0;
\t\t
\t\tif (this.gradientDirection != null)
\t\t{
\t\t\tdir = mxUtils.mod(dir + lookup[this.gradientDirection] - 1, 4);
\t\t}

\t\tif (dir == 1)
\t\t{
\t\t\ttype = '1';
\t\t\tvar tmp = start;
\t\t\tstart = end;
\t\t\tend = tmp;
\t\t}
\t\telse if (dir == 2)
\t\t{
\t\t\tvar tmp = start;
\t\t\tstart = end;
\t\t\tend = tmp;
\t\t}
\t\telse if (dir == 3)
\t\t{
\t\t\ttype = '1';
\t\t}
\t\t
\t\tf += 'progid:DXImageTransform.Microsoft.gradient(' +
\t\t\t'startColorStr=\\'' + start + '\\', endColorStr=\\'' + end +
\t\t\t'\\', gradientType=\\'' + type + '\\')';
\t}

\tnode.style.filter = f;
};

/**
 * Function: updateHtmlColors
 *
 * Allow optimization by replacing VML with HTML.
 */
mxShape.prototype.updateHtmlColors = function(node)
{
\tvar color = this.stroke;
\t
\tif (color != null && color != mxConstants.NONE)
\t{
\t\tnode.style.borderColor = color;

\t\tif (this.isDashed)
\t\t{
\t\t\tnode.style.borderStyle = 'dashed';
\t\t}
\t\telse if (this.strokewidth > 0)
\t\t{
\t\t\tnode.style.borderStyle = 'solid';
\t\t}

\t\tnode.style.borderWidth = Math.max(1, Math.ceil(this.strokewidth * this.scale)) + 'px';
\t}
\telse
\t{
\t\tnode.style.borderWidth = '0px';
\t}

\tcolor = (this.outline) ? null : this.fill;
\t
\tif (color != null && color != mxConstants.NONE)
\t{
\t\tnode.style.backgroundColor = color;
\t\tnode.style.backgroundImage = 'none';
\t}
\telse if (this.pointerEvents)
\t{
\t\t node.style.backgroundColor = 'transparent';
\t}
\telse if (document.documentMode == 8)
\t{
\t\tmxUtils.addTransparentBackgroundFilter(node);
\t}
\telse
\t{
\t\tthis.setTransparentBackgroundImage(node);
\t}
};

/**
 * Function: updateHtmlBounds
 *
 * Allow optimization by replacing VML with HTML.
 */
mxShape.prototype.updateHtmlBounds = function(node)
{
\tvar sw = (document.documentMode >= 9) ? 0 : Math.ceil(this.strokewidth * this.scale);
\tnode.style.borderWidth = Math.max(1, sw) + 'px';
\tnode.style.overflow = 'hidden';
\t
\tnode.style.left = Math.round(this.bounds.x - sw / 2) + 'px';
\tnode.style.top = Math.round(this.bounds.y - sw / 2) + 'px';

\tif (document.compatMode == 'CSS1Compat')
\t{
\t\tsw = -sw;
\t}
\t
\tnode.style.width = Math.round(Math.max(0, this.bounds.width + sw)) + 'px';
\tnode.style.height = Math.round(Math.max(0, this.bounds.height + sw)) + 'px';
};

/**
 * Function: destroyCanvas
 * 
 * Destroys the given canvas which was used for drawing. This implementation
 * increments the reference counts on all shared gradients used in the canvas.
 */
mxShape.prototype.destroyCanvas = function(canvas)
{
\t// Manages reference counts
\tif (canvas instanceof mxSvgCanvas2D)
\t{
\t\t// Increments ref counts
\t\tfor (var key in canvas.gradients)
\t\t{
\t\t\tvar gradient = canvas.gradients[key];
\t\t\t
\t\t\tif (gradient != null)
\t\t\t{
\t\t\t\tgradient.mxRefCount = (gradient.mxRefCount || 0) + 1;
\t\t\t}
\t\t}
\t\t
\t\tthis.releaseSvgGradients(this.oldGradients);
\t\tthis.oldGradients = canvas.gradients;
\t}
};

/**
 * Function: beforePaint
 * 
 * Invoked before paint is called.
 */
mxShape.prototype.beforePaint = function(c) { }

/**
 * Function: afterPaint
 * 
 * Invokes after paint was called.
 */
mxShape.prototype.afterPaint = function(c) { }

/**
 * Function: paint
 * 
 * Generic rendering code.
 */
mxShape.prototype.paint = function(c)
{
\tvar strokeDrawn = false;
\t
\tif (c != null && this.outline)
\t{
\t\tvar stroke = c.stroke;
\t\t
\t\tc.stroke = function()
\t\t{
\t\t\tstrokeDrawn = true;
\t\t\tstroke.apply(this, arguments);
\t\t};

\t\tvar fillAndStroke = c.fillAndStroke;
\t\t
\t\tc.fillAndStroke = function()
\t\t{
\t\t\tstrokeDrawn = true;
\t\t\tfillAndStroke.apply(this, arguments);
\t\t};
\t}

\t// Scale is passed-through to canvas
\tvar s = this.scale;
\tvar x = this.bounds.x / s;
\tvar y = this.bounds.y / s;
\tvar w = this.bounds.width / s;
\tvar h = this.bounds.height / s;

\tif (this.isPaintBoundsInverted())
\t{
\t\tvar t = (w - h) / 2;
\t\tx += t;
\t\ty -= t;
\t\tvar tmp = w;
\t\tw = h;
\t\th = tmp;
\t}
\t
\tthis.updateTransform(c, x, y, w, h);
\tthis.configureCanvas(c, x, y, w, h);

\t// Adds background rectangle to capture events
\tvar bg = null;
\t
\tif ((this.stencil == null && this.points == null && this.shapePointerEvents) ||
\t\t(this.stencil != null && this.stencilPointerEvents))
\t{
\t\tvar bb = this.createBoundingBox();
\t\t
\t\tif (this.dialect == mxConstants.DIALECT_SVG)
\t\t{
\t\t\tbg = this.createTransparentSvgRectangle(bb.x, bb.y, bb.width, bb.height);
\t\t\tthis.node.appendChild(bg);
\t\t}
\t\telse
\t\t{
\t\t\tvar rect = c.createRect('rect', bb.x / s, bb.y / s, bb.width / s, bb.height / s);
\t\t\trect.appendChild(c.createTransparentFill());
\t\t\trect.stroked = 'false';
\t\t\tc.root.appendChild(rect);
\t\t}
\t}

\tif (this.stencil != null)
\t{
\t\tthis.stencil.drawShape(c, this, x, y, w, h);
\t}
\telse
\t{
\t\t// Stencils have separate strokewidth
\t\tc.setStrokeWidth(this.strokewidth);
\t\t
\t\tif (this.points != null)
\t\t{
\t\t\t// Paints edge shape
\t\t\tvar pts = [];
\t\t\t
\t\t\tfor (var i = 0; i < this.points.length; i++)
\t\t\t{
\t\t\t\tif (this.points[i] != null)
\t\t\t\t{
\t\t\t\t\tpts.push(new mxPoint(this.points[i].x / s, this.points[i].y / s));
\t\t\t\t}
\t\t\t}

\t\t\tthis.paintEdgeShape(c, pts);
\t\t}
\t\telse
\t\t{
\t\t\t// Paints vertex shape
\t\t\tthis.paintVertexShape(c, x, y, w, h);
\t\t}
\t}
\t
\tif (bg != null && c.state != null && c.state.transform != null)
\t{
\t\tbg.setAttribute('transform', c.state.transform);
\t}
\t
\t// Draws highlight rectangle if no stroke was used
\tif (c != null && this.outline && !strokeDrawn)
\t{
\t\tc.rect(x, y, w, h);
\t\tc.stroke();
\t}
};

/**
 * Function: configureCanvas
 * 
 * Sets the state of the canvas for drawing the shape.
 */
mxShape.prototype.configureCanvas = function(c, x, y, w, h)
{
\tvar dash = null;
\t
\tif (this.style != null)
\t{
\t\tdash = this.style['dashPattern'];\t\t
\t}

\tc.setAlpha(this.opacity / 100);
\tc.setFillAlpha(this.fillOpacity / 100);
\tc.setStrokeAlpha(this.strokeOpacity / 100);

\t// Sets alpha, colors and gradients
\tif (this.isShadow != null)
\t{
\t\tc.setShadow(this.isShadow);
\t}
\t
\t// Dash pattern
\tif (this.isDashed != null)
\t{
\t\tc.setDashed(this.isDashed, (this.style != null) ?
\t\t\tmxUtils.getValue(this.style, mxConstants.STYLE_FIX_DASH, false) == 1 : false);
\t}

\tif (dash != null)
\t{
\t\tc.setDashPattern(dash);
\t}

\tif (this.fill != null && this.fill != mxConstants.NONE && this.gradient && this.gradient != mxConstants.NONE)
\t{
\t\tvar b = this.getGradientBounds(c, x, y, w, h);
\t\tc.setGradient(this.fill, this.gradient, b.x, b.y, b.width, b.height, this.gradientDirection);
\t}
\telse
\t{
\t\tc.setFillColor(this.fill);
\t}

\tc.setStrokeColor(this.stroke);
};

/**
 * Function: getGradientBounds
 * 
 * Returns the bounding box for the gradient box for this shape.
 */
mxShape.prototype.getGradientBounds = function(c, x, y, w, h)
{
\treturn new mxRectangle(x, y, w, h);
};

/**
 * Function: updateTransform
 * 
 * Sets the scale and rotation on the given canvas.
 */
mxShape.prototype.updateTransform = function(c, x, y, w, h)
{
\t// NOTE: Currently, scale is implemented in state and canvas. This will
\t// move to canvas in a later version, so that the states are unscaled
\t// and untranslated and do not need an update after zooming or panning.
\tc.scale(this.scale);
\tc.rotate(this.getShapeRotation(), this.flipH, this.flipV, x + w / 2, y + h / 2);
};

/**
 * Function: paintVertexShape
 * 
 * Paints the vertex shape.
 */
mxShape.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tthis.paintBackground(c, x, y, w, h);
\t
\tif (!this.outline || this.style == null || mxUtils.getValue(
\t\tthis.style, mxConstants.STYLE_BACKGROUND_OUTLINE, 0) == 0)
\t{
\t\tc.setShadow(false);
\t\tthis.paintForeground(c, x, y, w, h);
\t}
};

/**
 * Function: paintBackground
 * 
 * Hook for subclassers. This implementation is empty.
 */
mxShape.prototype.paintBackground = function(c, x, y, w, h) { };

/**
 * Function: paintForeground
 * 
 * Hook for subclassers. This implementation is empty.
 */
mxShape.prototype.paintForeground = function(c, x, y, w, h) { };

/**
 * Function: paintEdgeShape
 * 
 * Hook for subclassers. This implementation is empty.
 */
mxShape.prototype.paintEdgeShape = function(c, pts) { };

/**
 * Function: getArcSize
 * 
 * Returns the arc size for the given dimension.
 */
mxShape.prototype.getArcSize = function(w, h)
{
\tvar r = 0;
\t
\tif (mxUtils.getValue(this.style, mxConstants.STYLE_ABSOLUTE_ARCSIZE, 0) == '1')
\t{
\t\tr = Math.min(w / 2, Math.min(h / 2, mxUtils.getValue(this.style,
\t\t\tmxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2));
\t}
\telse
\t{
\t\tvar f = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE,
\t\t\tmxConstants.RECTANGLE_ROUNDING_FACTOR * 100) / 100;
\t\tr = Math.min(w * f, h * f);
\t}
\t
\treturn r;
};

/**
 * Function: paintGlassEffect
 * 
 * Paints the glass gradient effect.
 */
mxShape.prototype.paintGlassEffect = function(c, x, y, w, h, arc)
{
\tvar sw = Math.ceil(this.strokewidth / 2);
\tvar size = 0.4;
\t
\tc.setGradient('#ffffff', '#ffffff', x, y, w, h * 0.6, 'south', 0.9, 0.1);
\tc.begin();
\tarc += 2 * sw;
\t\t
\tif (this.isRounded)
\t{
\t\tc.moveTo(x - sw + arc, y - sw);
\t\tc.quadTo(x - sw, y - sw, x - sw, y - sw + arc);
\t\tc.lineTo(x - sw, y + h * size);
\t\tc.quadTo(x + w * 0.5, y + h * 0.7, x + w + sw, y + h * size);
\t\tc.lineTo(x + w + sw, y - sw + arc);
\t\tc.quadTo(x + w + sw, y - sw, x + w + sw - arc, y - sw);
\t}
\telse
\t{
\t\tc.moveTo(x - sw, y - sw);
\t\tc.lineTo(x - sw, y + h * size);
\t\tc.quadTo(x + w * 0.5, y + h * 0.7, x + w + sw, y + h * size);
\t\tc.lineTo(x + w + sw, y - sw);
\t}
\t
\tc.close();
\tc.fill();
};

/**
 * Function: addPoints
 * 
 * Paints the given points with rounded corners.
 */
mxShape.prototype.addPoints = function(c, pts, rounded, arcSize, close, exclude, initialMove)
{
\tif (pts != null && pts.length > 0)
\t{
\t\tinitialMove = (initialMove != null) ? initialMove : true;
\t\tvar pe = pts[pts.length - 1];
\t\t
\t\t// Adds virtual waypoint in the center between start and end point
\t\tif (close && rounded)
\t\t{
\t\t\tpts = pts.slice();
\t\t\tvar p0 = pts[0];
\t\t\tvar wp = new mxPoint(pe.x + (p0.x - pe.x) / 2, pe.y + (p0.y - pe.y) / 2);
\t\t\tpts.splice(0, 0, wp);
\t\t}
\t
\t\tvar pt = pts[0];
\t\tvar i = 1;
\t
\t\t// Draws the line segments
\t\tif (initialMove)
\t\t{
\t\t\tc.moveTo(pt.x, pt.y);
\t\t}
\t\telse
\t\t{
\t\t\tc.lineTo(pt.x, pt.y);
\t\t}
\t\t
\t\twhile (i < ((close) ? pts.length : pts.length - 1))
\t\t{
\t\t\tvar tmp = pts[mxUtils.mod(i, pts.length)];
\t\t\tvar dx = pt.x - tmp.x;
\t\t\tvar dy = pt.y - tmp.y;
\t
\t\t\tif (rounded && (dx != 0 || dy != 0) && (exclude == null || mxUtils.indexOf(exclude, i - 1) < 0))
\t\t\t{
\t\t\t\t// Draws a line from the last point to the current
\t\t\t\t// point with a spacing of size off the current point
\t\t\t\t// into direction of the last point
\t\t\t\tvar dist = Math.sqrt(dx * dx + dy * dy);
\t\t\t\tvar nx1 = dx * Math.min(arcSize, dist / 2) / dist;
\t\t\t\tvar ny1 = dy * Math.min(arcSize, dist / 2) / dist;
\t
\t\t\t\tvar x1 = tmp.x + nx1;
\t\t\t\tvar y1 = tmp.y + ny1;
\t\t\t\tc.lineTo(x1, y1);
\t
\t\t\t\t// Draws a curve from the last point to the current
\t\t\t\t// point with a spacing of size off the current point
\t\t\t\t// into direction of the next point
\t\t\t\tvar next = pts[mxUtils.mod(i + 1, pts.length)];
\t\t\t\t
\t\t\t\t// Uses next non-overlapping point
\t\t\t\twhile (i < pts.length - 2 && Math.round(next.x - tmp.x) == 0 && Math.round(next.y - tmp.y) == 0)
\t\t\t\t{
\t\t\t\t\tnext = pts[mxUtils.mod(i + 2, pts.length)];
\t\t\t\t\ti++;
\t\t\t\t}
\t\t\t\t
\t\t\t\tdx = next.x - tmp.x;
\t\t\t\tdy = next.y - tmp.y;
\t
\t\t\t\tdist = Math.max(1, Math.sqrt(dx * dx + dy * dy));
\t\t\t\tvar nx2 = dx * Math.min(arcSize, dist / 2) / dist;
\t\t\t\tvar ny2 = dy * Math.min(arcSize, dist / 2) / dist;
\t
\t\t\t\tvar x2 = tmp.x + nx2;
\t\t\t\tvar y2 = tmp.y + ny2;
\t
\t\t\t\tc.quadTo(tmp.x, tmp.y, x2, y2);
\t\t\t\ttmp = new mxPoint(x2, y2);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tc.lineTo(tmp.x, tmp.y);
\t\t\t}
\t
\t\t\tpt = tmp;
\t\t\ti++;
\t\t}
\t
\t\tif (close)
\t\t{
\t\t\tc.close();
\t\t}
\t\telse
\t\t{
\t\t\tc.lineTo(pe.x, pe.y);
\t\t}
\t}
};

/**
 * Function: resetStyles
 * 
 * Resets all styles.
 */
mxShape.prototype.resetStyles = function()
{
\tthis.initStyles();

\tthis.spacing = 0;
\t
\tdelete this.fill;
\tdelete this.gradient;
\tdelete this.gradientDirection;
\tdelete this.stroke;
\tdelete this.startSize;
\tdelete this.endSize;
\tdelete this.startArrow;
\tdelete this.endArrow;
\tdelete this.direction;
\tdelete this.isShadow;
\tdelete this.isDashed;
\tdelete this.isRounded;
\tdelete this.glass;
};

/**
 * Function: apply
 * 
 * Applies the style of the given <mxCellState> to the shape. This
 * implementation assigns the following styles to local fields:
 * 
 * - <mxConstants.STYLE_FILLCOLOR> => fill
 * - <mxConstants.STYLE_GRADIENTCOLOR> => gradient
 * - <mxConstants.STYLE_GRADIENT_DIRECTION> => gradientDirection
 * - <mxConstants.STYLE_OPACITY> => opacity
 * - <mxConstants.STYLE_FILL_OPACITY> => fillOpacity
 * - <mxConstants.STYLE_STROKE_OPACITY> => strokeOpacity
 * - <mxConstants.STYLE_STROKECOLOR> => stroke
 * - <mxConstants.STYLE_STROKEWIDTH> => strokewidth
 * - <mxConstants.STYLE_SHADOW> => isShadow
 * - <mxConstants.STYLE_DASHED> => isDashed
 * - <mxConstants.STYLE_SPACING> => spacing
 * - <mxConstants.STYLE_STARTSIZE> => startSize
 * - <mxConstants.STYLE_ENDSIZE> => endSize
 * - <mxConstants.STYLE_ROUNDED> => isRounded
 * - <mxConstants.STYLE_STARTARROW> => startArrow
 * - <mxConstants.STYLE_ENDARROW> => endArrow
 * - <mxConstants.STYLE_ROTATION> => rotation
 * - <mxConstants.STYLE_DIRECTION> => direction
 * - <mxConstants.STYLE_GLASS> => glass
 *
 * This keeps a reference to the <style>. If you need to keep a reference to
 * the cell, you can override this method and store a local reference to
 * state.cell or the <mxCellState> itself. If <outline> should be true, make
 * sure to set it before calling this method.
 *
 * Parameters:
 *
 * state - <mxCellState> of the corresponding cell.
 */
mxShape.prototype.apply = function(state)
{
\tthis.state = state;
\tthis.style = state.style;

\tif (this.style != null)
\t{
\t\tthis.fill = mxUtils.getValue(this.style, mxConstants.STYLE_FILLCOLOR, this.fill);
\t\tthis.gradient = mxUtils.getValue(this.style, mxConstants.STYLE_GRADIENTCOLOR, this.gradient);
\t\tthis.gradientDirection = mxUtils.getValue(this.style, mxConstants.STYLE_GRADIENT_DIRECTION, this.gradientDirection);
\t\tthis.opacity = mxUtils.getValue(this.style, mxConstants.STYLE_OPACITY, this.opacity);
\t\tthis.fillOpacity = mxUtils.getValue(this.style, mxConstants.STYLE_FILL_OPACITY, this.fillOpacity);
\t\tthis.strokeOpacity = mxUtils.getValue(this.style, mxConstants.STYLE_STROKE_OPACITY, this.strokeOpacity);
\t\tthis.stroke = mxUtils.getValue(this.style, mxConstants.STYLE_STROKECOLOR, this.stroke);
\t\tthis.strokewidth = mxUtils.getNumber(this.style, mxConstants.STYLE_STROKEWIDTH, this.strokewidth);
\t\tthis.spacing = mxUtils.getValue(this.style, mxConstants.STYLE_SPACING, this.spacing);
\t\tthis.startSize = mxUtils.getNumber(this.style, mxConstants.STYLE_STARTSIZE, this.startSize);
\t\tthis.endSize = mxUtils.getNumber(this.style, mxConstants.STYLE_ENDSIZE, this.endSize);
\t\tthis.startArrow = mxUtils.getValue(this.style, mxConstants.STYLE_STARTARROW, this.startArrow);
\t\tthis.endArrow = mxUtils.getValue(this.style, mxConstants.STYLE_ENDARROW, this.endArrow);
\t\tthis.rotation = mxUtils.getValue(this.style, mxConstants.STYLE_ROTATION, this.rotation);
\t\tthis.direction = mxUtils.getValue(this.style, mxConstants.STYLE_DIRECTION, this.direction);
\t\tthis.flipH = mxUtils.getValue(this.style, mxConstants.STYLE_FLIPH, 0) == 1;
\t\tthis.flipV = mxUtils.getValue(this.style, mxConstants.STYLE_FLIPV, 0) == 1;\t
\t\t
\t\t// Legacy support for stencilFlipH/V
\t\tif (this.stencil != null)
\t\t{
\t\t\tthis.flipH = mxUtils.getValue(this.style, 'stencilFlipH', 0) == 1 || this.flipH;
\t\t\tthis.flipV = mxUtils.getValue(this.style, 'stencilFlipV', 0) == 1 || this.flipV;
\t\t}
\t\t
\t\tif (this.direction == mxConstants.DIRECTION_NORTH || this.direction == mxConstants.DIRECTION_SOUTH)
\t\t{
\t\t\tvar tmp = this.flipH;
\t\t\tthis.flipH = this.flipV;
\t\t\tthis.flipV = tmp;
\t\t}

\t\tthis.isShadow = mxUtils.getValue(this.style, mxConstants.STYLE_SHADOW, this.isShadow) == 1;
\t\tthis.isDashed = mxUtils.getValue(this.style, mxConstants.STYLE_DASHED, this.isDashed) == 1;
\t\tthis.isRounded = mxUtils.getValue(this.style, mxConstants.STYLE_ROUNDED, this.isRounded) == 1;
\t\tthis.glass = mxUtils.getValue(this.style, mxConstants.STYLE_GLASS, this.glass) == 1;
\t\t
\t\tif (this.fill == mxConstants.NONE)
\t\t{
\t\t\tthis.fill = null;
\t\t}

\t\tif (this.gradient == mxConstants.NONE)
\t\t{
\t\t\tthis.gradient = null;
\t\t}

\t\tif (this.stroke == mxConstants.NONE)
\t\t{
\t\t\tthis.stroke = null;
\t\t}
\t}
};

/**
 * Function: setCursor
 * 
 * Sets the cursor on the given shape.
 *
 * Parameters:
 *
 * cursor - The cursor to be used.
 */
mxShape.prototype.setCursor = function(cursor)
{
\tif (cursor == null)
\t{
\t\tcursor = '';
\t}
\t
\tthis.cursor = cursor;

\tif (this.node != null)
\t{
\t\tthis.node.style.cursor = cursor;
\t}
};

/**
 * Function: getCursor
 * 
 * Returns the current cursor.
 */
mxShape.prototype.getCursor = function()
{
\treturn this.cursor;
};

/**
 * Function: isRoundable
 * 
 * Hook for subclassers.
 */
mxShape.prototype.isRoundable = function()
{
\treturn false;
};

/**
 * Function: updateBoundingBox
 *
 * Updates the <boundingBox> for this shape using <createBoundingBox> and
 * <augmentBoundingBox> and stores the result in <boundingBox>.
 */
mxShape.prototype.updateBoundingBox = function()
{
\t// Tries to get bounding box from SVG subsystem
\t// LATER: Use getBoundingClientRect for fallback in VML
\tif (this.useSvgBoundingBox && this.node != null && this.node.ownerSVGElement != null)
\t{
\t\ttry
\t\t{
\t\t\tvar b = this.node.getBBox();
\t
\t\t\tif (b.width > 0 && b.height > 0)
\t\t\t{
\t\t\t\tthis.boundingBox = new mxRectangle(b.x, b.y, b.width, b.height);
\t\t\t\t
\t\t\t\t// Adds strokeWidth
\t\t\t\tthis.boundingBox.grow(this.strokewidth * this.scale / 2);
\t\t\t\t
\t\t\t\treturn;
\t\t\t}
\t\t}
\t\tcatch(e)
\t\t{
\t\t\t// fallback to code below
\t\t}
\t}

\tif (this.bounds != null)
\t{
\t\tvar bbox = this.createBoundingBox();
\t\t
\t\tif (bbox != null)
\t\t{
\t\t\tthis.augmentBoundingBox(bbox);
\t\t\tvar rot = this.getShapeRotation();
\t\t\t
\t\t\tif (rot != 0)
\t\t\t{
\t\t\t\tbbox = mxUtils.getBoundingBox(bbox, rot);
\t\t\t}
\t\t}

\t\tthis.boundingBox = bbox;
\t}
};

/**
 * Function: createBoundingBox
 *
 * Returns a new rectangle that represents the bounding box of the bare shape
 * with no shadows or strokewidths.
 */
mxShape.prototype.createBoundingBox = function()
{
\tvar bb = this.bounds.clone();

\tif ((this.stencil != null && (this.direction == mxConstants.DIRECTION_NORTH ||
\t\tthis.direction == mxConstants.DIRECTION_SOUTH)) || this.isPaintBoundsInverted())
\t{
\t\tbb.rotate90();
\t}
\t
\treturn bb;
};

/**
 * Function: augmentBoundingBox
 *
 * Augments the bounding box with the strokewidth and shadow offsets.
 */
mxShape.prototype.augmentBoundingBox = function(bbox)
{
\tif (this.isShadow)
\t{
\t\tbbox.width += Math.ceil(mxConstants.SHADOW_OFFSET_X * this.scale);
\t\tbbox.height += Math.ceil(mxConstants.SHADOW_OFFSET_Y * this.scale);
\t}
\t
\t// Adds strokeWidth
\tbbox.grow(this.strokewidth * this.scale / 2);
};

/**
 * Function: isPaintBoundsInverted
 * 
 * Returns true if the bounds should be inverted.
 */
mxShape.prototype.isPaintBoundsInverted = function()
{
\t// Stencil implements inversion via aspect
\treturn this.stencil == null && (this.direction == mxConstants.DIRECTION_NORTH ||
\t\t\tthis.direction == mxConstants.DIRECTION_SOUTH);
};

/**
 * Function: getRotation
 * 
 * Returns the rotation from the style.
 */
mxShape.prototype.getRotation = function()
{
\treturn (this.rotation != null) ? this.rotation : 0;
};

/**
 * Function: getTextRotation
 * 
 * Returns the rotation for the text label.
 */
mxShape.prototype.getTextRotation = function()
{
\tvar rot = this.getRotation();
\t
\tif (mxUtils.getValue(this.style, mxConstants.STYLE_HORIZONTAL, 1) != 1)
\t{
\t\trot += mxText.prototype.verticalTextRotation;
\t}
\t
\treturn rot;
};

/**
 * Function: getShapeRotation
 * 
 * Returns the actual rotation of the shape.
 */
mxShape.prototype.getShapeRotation = function()
{
\tvar rot = this.getRotation();
\t
\tif (this.direction != null)
\t{
\t\tif (this.direction == mxConstants.DIRECTION_NORTH)
\t\t{
\t\t\trot += 270;
\t\t}
\t\telse if (this.direction == mxConstants.DIRECTION_WEST)
\t\t{
\t\t\trot += 180;
\t\t}
\t\telse if (this.direction == mxConstants.DIRECTION_SOUTH)
\t\t{
\t\t\trot += 90;
\t\t}
\t}
\t
\treturn rot;
};

/**
 * Function: createTransparentSvgRectangle
 * 
 * Adds a transparent rectangle that catches all events.
 */
mxShape.prototype.createTransparentSvgRectangle = function(x, y, w, h)
{
\tvar rect = document.createElementNS(mxConstants.NS_SVG, 'rect');
\trect.setAttribute('x', x);
\trect.setAttribute('y', y);
\trect.setAttribute('width', w);
\trect.setAttribute('height', h);
\trect.setAttribute('fill', 'none');
\trect.setAttribute('stroke', 'none');
\trect.setAttribute('pointer-events', 'all');
\t
\treturn rect;
};

/**
 * Function: setTransparentBackgroundImage
 * 
 * Sets a transparent background CSS style to catch all events.
 * 
 * Paints the line shape.
 */
mxShape.prototype.setTransparentBackgroundImage = function(node)
{
\tnode.style.backgroundImage = 'url(\\'' + mxClient.imageBasePath + '/transparent.gif\\')';
};

/**
 * Function: releaseSvgGradients
 * 
 * Paints the line shape.
 */
mxShape.prototype.releaseSvgGradients = function(grads)
{
\tif (grads != null)
\t{
\t\tfor (var key in grads)
\t\t{
\t\t\tvar gradient = grads[key];
\t\t\t
\t\t\tif (gradient != null)
\t\t\t{
\t\t\t\tgradient.mxRefCount = (gradient.mxRefCount || 0) - 1;
\t\t\t\t
\t\t\t\tif (gradient.mxRefCount == 0 && gradient.parentNode != null)
\t\t\t\t{
\t\t\t\t\tgradient.parentNode.removeChild(gradient);
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};

/**
 * Function: destroy
 *
 * Destroys the shape by removing it from the DOM and releasing the DOM
 * node associated with the shape using <mxEvent.release>.
 */
mxShape.prototype.destroy = function()
{
\tif (this.node != null)
\t{
\t\tmxEvent.release(this.node);
\t\t
\t\tif (this.node.parentNode != null)
\t\t{
\t\t\tthis.node.parentNode.removeChild(this.node);
\t\t}
\t\t
\t\tthis.node = null;
\t}
\t
\t// Decrements refCount and removes unused
\tthis.releaseSvgGradients(this.oldGradients);
\tthis.oldGradients = null;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxStencil
 *
 * Implements a generic shape which is based on a XML node as a description.
 * 
 * shape:
 * 
 * The outer element is *shape*, that has attributes:
 * 
 * - \"name\", string, required. The stencil name that uniquely identifies the shape.
 * - \"w\" and \"h\" are optional decimal view bounds. This defines your co-ordinate
 * system for the graphics operations in the shape. The default is 100,100.
 * - \"aspect\", optional string. Either \"variable\", the default, or \"fixed\". Fixed
 * means always render the shape with the aspect ratio defined by the ratio w/h.
 * Variable causes the ratio to match that of the geometry of the current vertex.
 * - \"strokewidth\", optional string. Either an integer or the string \"inherit\".
 * \"inherit\" indicates that the strokeWidth of the cell is only changed on scaling,
 * not on resizing. Default is \"1\".
 * If numeric values are used, the strokeWidth of the cell is changed on both
 * scaling and resizing and the value defines the multiple that is applied to
 * the width.
 * 
 * connections:
 * 
 * If you want to define specific fixed connection points on the shape use the
 * *connections* element. Each *constraint* element within connections defines
 * a fixed connection point on the shape. Constraints have attributes:
 * 
 * - \"perimeter\", required. 1 or 0. 0 sets the connection point where specified
 * by x,y. 1 Causes the position of the connection point to be extrapolated from
 * the center of the shape, through x,y to the point of intersection with the
 * perimeter of the shape.
 * - \"x\" and \"y\" are the position of the fixed point relative to the bounds of
 * the shape. They can be automatically adjusted if perimeter=1. So, (0,0) is top
 * left, (0.5,0.5) the center, (1,0.5) the center of the right hand edge of the
 * bounds, etc. Values may be less than 0 or greater than 1 to be positioned
 * outside of the shape.
 * - \"name\", optional string. A unique identifier for the port on the shape.
 * 
 * background and foreground:
 * 
 * The path of the graphics drawing is split into two elements, *foreground* and
 * *background*. The split is to define which part any shadow applied to the shape
 * is derived from (the background). This, generally, means the background is the
 * line tracing of the outside of the shape, but not always.
 * 
 * Any stroke, fill or fillstroke of a background must be the first element of the
 * foreground element, they must not be used within *background*. If the background
 * is empty, this is not required.
 * 
 * Because the background cannot have any fill or stroke, it can contain only one
 * *path*, *rect*, *roundrect* or *ellipse* element (or none). It can also not
 * include *image*, *text* or *include-shape*.
 * 
 * Note that the state, styling and drawing in mxGraph stencils is very close in
 * design to that of HTML 5 canvas. Tutorials on this subject, if you're not
 * familiar with the topic, will give a good high-level introduction to the
 * concepts used.
 * 
 * State:
 * 
 * Rendering within the foreground and background elements has the concept of
 * state. There are two types of operations other than state save/load, styling
 * and drawing. The styling operations change the current state, so you can save
 * the current state with <save/> and pull the last saved state from the state
 * stack using <restore/>.
 * 
 * Styling:
 * 
 * The elements that change colors within the current state all take a hash
 * prefixed hex color code (\"#FFEA80\").
 * 
 * - *strokecolor*, this sets the color that drawing paths will be rendered in
 * when a stroke or fillstroke command is issued.
 * - *fillcolor*, this sets the color that the inside of closed paths will be
 * rendered in when a fill or fillstroke command is issued.
 * - *fontcolor*, this sets the color that fonts are rendered in when text is drawn.
 * 
 * *alpha* defines the degree of transparency used between 1.0 for fully opaque
 * and 0.0 for fully transparent.
 * 
 * *fillalpha* defines the degree of fill transparency used between 1.0 for fully
 * opaque and 0.0 for fully transparent.
 * 
 * *strokealpha* defines the degree of stroke transparency used between 1.0 for
 * fully opaque and 0.0 for fully transparent.
 * 
 * *strokewidth* defines the integer thickness of drawing elements rendered by
 * stroking. Use fixed=\"1\" to apply the value as-is, without scaling.
 * 
 * *dashed* is \"1\" for dashing enabled and \"0\" for disabled.
 * 
 * When *dashed* is enabled the current dash pattern, defined by *dashpattern*,
 * is used on strokes. dashpattern is a sequence of space separated \"on, off\"
 * lengths that define what distance to paint the stroke for, then what distance
 * to paint nothing for, repeat... The default is \"3 3\". You could define a more
 * complex pattern with \"5 3 2 6\", for example. Generally, it makes sense to have
 * an even number of elements in the dashpattern, but that's not required.
 * 
 * *linejoin*, *linecap* and *miterlimit* are best explained by the Mozilla page
 * on Canvas styling (about halfway down). The values are all the same except we
 * use \"flat\" for linecap, instead of Canvas' \"butt\".
 * 
 * For font styling there are.
 * 
 * - *fontsize*, an integer,
 * - *fontstyle*, an ORed bit pattern of bold (1), italic (2) and underline (4),
 * i.e bold underline is \"5\".
 * - *fontfamily*, is a string defining the typeface to be used.
 * 
 * Drawing:
 * 
 * Most drawing is contained within a *path* element. Again, the graphic
 * primitives are very similar to that of HTML 5 canvas.
 * 
 * - *move* to attributes required decimals (x,y).
 * - *line* to attributes required decimals (x,y).
 * - *quad* to required decimals (x2,y2) via control point required decimals
 * (x1,y1).
 * - *curve* to required decimals (x3,y3), via control points required decimals
 * (x1,y1) and (x2,y2).
 * - *arc*, this doesn't follow the HTML Canvas signatures, instead it's a copy
 * of the SVG arc command. The SVG specification documentation gives the best
 * description of its behaviors. The attributes are named identically, they are
 * decimals and all required.
 * - *close* ends the current subpath and causes an automatic straight line to
 * be drawn from the current point to the initial point of the current subpath.
 * 
 * Complex drawing:
 * 
 * In addition to the graphics primitive operations there are non-primitive
 * operations. These provide an easy method to draw some basic shapes.
 * 
 * - *rect*, attributes \"x\", \"y\", \"w\", \"h\", all required decimals
 * - *roundrect*, attributes \"x\", \"y\", \"w\", \"h\", all required decimals. Also
 * \"arcsize\" an optional decimal attribute defining how large, the corner curves
 * are.
 * - *ellipse*, attributes \"x\", \"y\", \"w\", \"h\", all required decimals.
 * 
 * Note that these 3 shapes and all paths must be followed by either a fill,
 * stroke, or fillstroke.
 * 
 * Text:
 * 
 * *text* elements have the following attributes.
 * 
 * - \"str\", the text string to display, required.
 * - \"x\" and \"y\", the decimal location (x,y) of the text element, required.
 * - \"align\", the horizontal alignment of the text element, either \"left\",
 * \"center\" or \"right\". Optional, default is \"left\".
 * - \"valign\", the vertical alignment of the text element, either \"top\", \"middle\"
 * or \"bottom\". Optional, default is \"top\".
 * - \"localized\", 0 or 1, if 1 then the \"str\" actually contains a key to use to
 * fetch the value out of mxResources. Optional, default is
 * <mxStencil.defaultLocalized>.
 * - \"vertical\", 0 or 1, if 1 the label is rendered vertically (rotated by 90
 * degrees). Optional, default is 0.
 * - \"rotation\", angle in degrees (0 to 360). The angle to rotate the text by.
 * Optional, default is 0.
 * - \"align-shape\", 0 or 1, if 0 ignore the rotation of the shape when setting
 * the text rotation. Optional, default is 1.
 * 
 * If <allowEval> is true, then the text content of the this element can define
 * a function which is invoked with the shape as the only argument and returns
 * the value for the text element (ignored if the str attribute is not null).
 * 
 * Images:
 * 
 * *image* elements can either be external URLs, or data URIs, where supported
 * (not in IE 7-). Attributes are:
 * 
 * - \"src\", required string. Either a data URI or URL.
 * - \"x\", \"y\", required decimals. The (x,y) position of the image.
 * - \"w\", \"h\", required decimals. The width and height of the image.
 * - \"flipH\" and \"flipV\", optional 0 or 1. Whether to flip the image along the
 * horizontal/vertical axis. Default is 0 for both.
 * 
 * If <allowEval> is true, then the text content of the this element can define
 * a function which is invoked with the shape as the only argument and returns
 * the value for the image source (ignored if the src attribute is not null).
 * 
 * Sub-shapes:
 * 
 * *include-shape* allow stencils to be rendered within the current stencil by
 * referencing the sub-stencil by name. Attributes are:
 * 
 * - \"name\", required string. The unique shape name of the stencil.
 * - \"x\", \"y\", \"w\", \"h\", required decimals. The (x,y) position of the sub-shape
 * and its width and height.
 * 
 * Constructor: mxStencil
 * 
 * Constructs a new generic shape by setting <desc> to the given XML node and
 * invoking <parseDescription> and <parseConstraints>.
 * 
 * Parameters:
 * 
 * desc - XML node that contains the stencil description.
 */
function mxStencil(desc)
{
\tthis.desc = desc;
\tthis.parseDescription();
\tthis.parseConstraints();
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxStencil, mxShape);

/**
 * Variable: defaultLocalized
 * 
 * Static global variable that specifies the default value for the localized
 * attribute of the text element. Default is false.
 */
mxStencil.defaultLocalized = false;

/**
 * Function: allowEval
 * 
 * Static global switch that specifies if the use of eval is allowed for
 * evaluating text content and images. Default is false. Set this to true
 * if stencils can not contain user input.
 */
mxStencil.allowEval = false;

/**
 * Variable: desc
 *
 * Holds the XML node with the stencil description.
 */
mxStencil.prototype.desc = null;

/**
 * Variable: constraints
 * 
 * Holds an array of <mxConnectionConstraints> as defined in the shape.
 */
mxStencil.prototype.constraints = null;

/**
 * Variable: aspect
 *
 * Holds the aspect of the shape. Default is 'auto'.
 */
mxStencil.prototype.aspect = null;

/**
 * Variable: w0
 *
 * Holds the width of the shape. Default is 100.
 */
mxStencil.prototype.w0 = null;

/**
 * Variable: h0
 *
 * Holds the height of the shape. Default is 100.
 */
mxStencil.prototype.h0 = null;

/**
 * Variable: bgNodes
 *
 * Holds the XML node with the stencil description.
 */
mxStencil.prototype.bgNode = null;

/**
 * Variable: fgNodes
 *
 * Holds the XML node with the stencil description.
 */
mxStencil.prototype.fgNode = null;

/**
 * Variable: strokewidth
 *
 * Holds the strokewidth direction from the description.
 */
mxStencil.prototype.strokewidth = null;

/**
 * Function: parseDescription
 *
 * Reads <w0>, <h0>, <aspect>, <bgNodes> and <fgNodes> from <desc>.
 */
mxStencil.prototype.parseDescription = function()
{
\t// LATER: Preprocess nodes for faster painting
\tthis.fgNode = this.desc.getElementsByTagName('foreground')[0];
\tthis.bgNode = this.desc.getElementsByTagName('background')[0];
\tthis.w0 = Number(this.desc.getAttribute('w') || 100);
\tthis.h0 = Number(this.desc.getAttribute('h') || 100);
\t
\t// Possible values for aspect are: variable and fixed where
\t// variable means fill the available space and fixed means
\t// use w0 and h0 to compute the aspect.
\tvar aspect = this.desc.getAttribute('aspect');
\tthis.aspect = (aspect != null) ? aspect : 'variable';
\t
\t// Possible values for strokewidth are all numbers and \"inherit\"
\t// where the inherit means take the value from the style (ie. the
\t// user-defined stroke-width). Note that the strokewidth is scaled
\t// by the minimum scaling that is used to draw the shape (sx, sy).
\tvar sw = this.desc.getAttribute('strokewidth');
\tthis.strokewidth = (sw != null) ? sw : '1';
};

/**
 * Function: parseConstraints
 *
 * Reads the constraints from <desc> into <constraints> using
 * <parseConstraint>.
 */
mxStencil.prototype.parseConstraints = function()
{
\tvar conns = this.desc.getElementsByTagName('connections')[0];
\t
\tif (conns != null)
\t{
\t\tvar tmp = mxUtils.getChildNodes(conns);
\t\t
\t\tif (tmp != null && tmp.length > 0)
\t\t{
\t\t\tthis.constraints = [];
\t\t\t
\t\t\tfor (var i = 0; i < tmp.length; i++)
\t\t\t{
\t\t\t\tthis.constraints.push(this.parseConstraint(tmp[i]));
\t\t\t}
\t\t}
\t}
};

/**
 * Function: parseConstraint
 *
 * Parses the given XML node and returns its <mxConnectionConstraint>.
 */
mxStencil.prototype.parseConstraint = function(node)
{
\tvar x = Number(node.getAttribute('x'));
\tvar y = Number(node.getAttribute('y'));
\tvar perimeter = node.getAttribute('perimeter') == '1';
\tvar name = node.getAttribute('name');
\t
\treturn new mxConnectionConstraint(new mxPoint(x, y), perimeter, name);
};

/**
 * Function: evaluateTextAttribute
 * 
 * Gets the given attribute as a text. The return value from <evaluateAttribute>
 * is used as a key to <mxResources.get> if the localized attribute in the text
 * node is 1 or if <defaultLocalized> is true.
 */
mxStencil.prototype.evaluateTextAttribute = function(node, attribute, shape)
{
\tvar result = this.evaluateAttribute(node, attribute, shape);
\tvar loc = node.getAttribute('localized');
\t
\tif ((mxStencil.defaultLocalized && loc == null) || loc == '1')
\t{
\t\tresult = mxResources.get(result);
\t}

\treturn result;
};

/**
 * Function: evaluateAttribute
 *
 * Gets the attribute for the given name from the given node. If the attribute
 * does not exist then the text content of the node is evaluated and if it is
 * a function it is invoked with <shape> as the only argument and the return
 * value is used as the attribute value to be returned.
 */
mxStencil.prototype.evaluateAttribute = function(node, attribute, shape)
{
\tvar result = node.getAttribute(attribute);
\t
\tif (result == null)
\t{
\t\tvar text = mxUtils.getTextContent(node);
\t\t
\t\tif (text != null && mxStencil.allowEval)
\t\t{
\t\t\tvar funct = mxUtils.eval(text);
\t\t\t
\t\t\tif (typeof(funct) == 'function')
\t\t\t{
\t\t\t\tresult = funct(shape);
\t\t\t}
\t\t}
\t}
\t
\treturn result;
};

/**
 * Function: drawShape
 *
 * Draws this stencil inside the given bounds.
 */
mxStencil.prototype.drawShape = function(canvas, shape, x, y, w, h)
{
\tvar stack = canvas.states.slice();
\t
\t// TODO: Internal structure (array of special structs?), relative and absolute
\t// coordinates (eg. note shape, process vs star, actor etc.), text rendering
\t// and non-proportional scaling, how to implement pluggable edge shapes
\t// (start, segment, end blocks), pluggable markers, how to implement
\t// swimlanes (title area) with this API, add icon, horizontal/vertical
\t// label, indicator for all shapes, rotation
\tvar direction = mxUtils.getValue(shape.style, mxConstants.STYLE_DIRECTION, null);
\tvar aspect = this.computeAspect(shape.style, x, y, w, h, direction);
\tvar minScale = Math.min(aspect.width, aspect.height);
\tvar sw = (this.strokewidth == 'inherit') ?
\t\t\tNumber(mxUtils.getNumber(shape.style, mxConstants.STYLE_STROKEWIDTH, 1)) :
\t\t\tNumber(this.strokewidth) * minScale;
\tcanvas.setStrokeWidth(sw);

\t// Draws a transparent rectangle for catching events
\tif (shape.style != null && mxUtils.getValue(shape.style, mxConstants.STYLE_POINTER_EVENTS, '0') == '1')
\t{
\t\tcanvas.setStrokeColor(mxConstants.NONE);
\t\tcanvas.rect(x, y, w, h);
\t\tcanvas.stroke();
\t\tcanvas.setStrokeColor(shape.stroke);
\t}

\tthis.drawChildren(canvas, shape, x, y, w, h, this.bgNode, aspect, false, true);
\tthis.drawChildren(canvas, shape, x, y, w, h, this.fgNode, aspect, true,
\t\t!shape.outline || shape.style == null || mxUtils.getValue(
\t\tshape.style, mxConstants.STYLE_BACKGROUND_OUTLINE, 0) == 0);
\t
\t// Restores stack for unequal count of save/restore calls
\tif (canvas.states.length != stack.length)
\t{
\t\tcanvas.states = stack;
\t}
};

/**
 * Function: drawChildren
 *
 * Draws this stencil inside the given bounds.
 */
mxStencil.prototype.drawChildren = function(canvas, shape, x, y, w, h, node, aspect, disableShadow, paint)
{
\tif (node != null && w > 0 && h > 0)
\t{
\t\tvar tmp = node.firstChild;
\t\t
\t\twhile (tmp != null)
\t\t{
\t\t\tif (tmp.nodeType == mxConstants.NODETYPE_ELEMENT)
\t\t\t{
\t\t\t\tthis.drawNode(canvas, shape, tmp, aspect, disableShadow, paint);
\t\t\t}
\t\t\t
\t\t\ttmp = tmp.nextSibling;
\t\t}
\t}
};

/**
 * Function: computeAspect
 *
 * Returns a rectangle that contains the offset in x and y and the horizontal
 * and vertical scale in width and height used to draw this shape inside the
 * given <mxRectangle>.
 * 
 * Parameters:
 * 
 * shape - <mxShape> to be drawn.
 * bounds - <mxRectangle> that should contain the stencil.
 * direction - Optional direction of the shape to be darwn.
 */
mxStencil.prototype.computeAspect = function(shape, x, y, w, h, direction)
{
\tvar x0 = x;
\tvar y0 = y;
\tvar sx = w / this.w0;
\tvar sy = h / this.h0;
\t
\tvar inverse = (direction == mxConstants.DIRECTION_NORTH || direction == mxConstants.DIRECTION_SOUTH);

\tif (inverse)
\t{
\t\tsy = w / this.h0;
\t\tsx = h / this.w0;
\t\t
\t\tvar delta = (w - h) / 2;

\t\tx0 += delta;
\t\ty0 -= delta;
\t}

\tif (this.aspect == 'fixed')
\t{
\t\tsy = Math.min(sx, sy);
\t\tsx = sy;
\t\t
\t\t// Centers the shape inside the available space
\t\tif (inverse)
\t\t{
\t\t\tx0 += (h - this.w0 * sx) / 2;
\t\t\ty0 += (w - this.h0 * sy) / 2;
\t\t}
\t\telse
\t\t{
\t\t\tx0 += (w - this.w0 * sx) / 2;
\t\t\ty0 += (h - this.h0 * sy) / 2;
\t\t}
\t}

\treturn new mxRectangle(x0, y0, sx, sy);
};

/**
 * Function: drawNode
 *
 * Draws this stencil inside the given bounds.
 */
mxStencil.prototype.drawNode = function(canvas, shape, node, aspect, disableShadow, paint)
{
\tvar name = node.nodeName;
\tvar x0 = aspect.x;
\tvar y0 = aspect.y;
\tvar sx = aspect.width;
\tvar sy = aspect.height;
\tvar minScale = Math.min(sx, sy);
\t
\tif (name == 'save')
\t{
\t\tcanvas.save();
\t}
\telse if (name == 'restore')
\t{
\t\tcanvas.restore();
\t}
\telse if (paint)
\t{
\t\tif (name == 'path')
\t\t{
\t\t\tcanvas.begin();
\t\t\t
\t\t\tvar parseRegularly = true;
\t\t\t
\t\t\tif (node.getAttribute('rounded') == '1')
\t\t\t{
\t\t\t\tparseRegularly = false;
\t\t\t\t
\t\t\t\tvar arcSize = Number(node.getAttribute('arcSize'));
\t\t\t\tvar pointCount = 0;
\t\t\t\tvar segs = [];
\t\t\t\t
\t\t\t\t// Renders the elements inside the given path
\t\t\t\tvar childNode = node.firstChild;
\t\t\t\t
\t\t\t\twhile (childNode != null)
\t\t\t\t{
\t\t\t\t\tif (childNode.nodeType == mxConstants.NODETYPE_ELEMENT)
\t\t\t\t\t{
\t\t\t\t\t\tvar childName = childNode.nodeName;
\t\t\t\t\t\t
\t\t\t\t\t\tif (childName == 'move' || childName == 'line')
\t\t\t\t\t\t{
\t\t\t\t\t\t\tif (childName == 'move' || segs.length == 0)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tsegs.push([]);
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tsegs[segs.length - 1].push(new mxPoint(x0 + Number(childNode.getAttribute('x')) * sx,
\t\t\t\t\t\t\t\ty0 + Number(childNode.getAttribute('y')) * sy));
\t\t\t\t\t\t\tpointCount++;
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\t//We only support move and line for rounded corners
\t\t\t\t\t\t\tparseRegularly = true;
\t\t\t\t\t\t\tbreak;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tchildNode = childNode.nextSibling;
\t\t\t\t}

\t\t\t\tif (!parseRegularly && pointCount > 0)
\t\t\t\t{
\t\t\t\t\tfor (var i = 0; i < segs.length; i++)
\t\t\t\t\t{
\t\t\t\t\t\tvar close = false, ps = segs[i][0], pe = segs[i][segs[i].length - 1];
\t\t\t\t\t\t
\t\t\t\t\t\tif (ps.x == pe.x && ps.y == pe.y) 
\t\t\t\t\t\t{
\t\t\t\t\t\t\tsegs[i].pop();
\t\t\t\t\t\t\tclose = true;
\t\t\t\t\t\t}
\t\t\t\t\t\t
\t\t\t\t\t\tthis.addPoints(canvas, segs[i], true, arcSize, close);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tparseRegularly = true;
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tif (parseRegularly)
\t\t\t{
\t\t\t\t// Renders the elements inside the given path
\t\t\t\tvar childNode = node.firstChild;
\t\t\t\t
\t\t\t\twhile (childNode != null)
\t\t\t\t{
\t\t\t\t\tif (childNode.nodeType == mxConstants.NODETYPE_ELEMENT)
\t\t\t\t\t{
\t\t\t\t\t\tthis.drawNode(canvas, shape, childNode, aspect, disableShadow, paint);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tchildNode = childNode.nextSibling;
\t\t\t\t}
\t\t\t}
\t\t}
\t\telse if (name == 'close')
\t\t{
\t\t\tcanvas.close();
\t\t}
\t\telse if (name == 'move')
\t\t{
\t\t\tcanvas.moveTo(x0 + Number(node.getAttribute('x')) * sx, y0 + Number(node.getAttribute('y')) * sy);
\t\t}
\t\telse if (name == 'line')
\t\t{
\t\t\tcanvas.lineTo(x0 + Number(node.getAttribute('x')) * sx, y0 + Number(node.getAttribute('y')) * sy);
\t\t}
\t\telse if (name == 'quad')
\t\t{
\t\t\tcanvas.quadTo(x0 + Number(node.getAttribute('x1')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y1')) * sy,
\t\t\t\t\tx0 + Number(node.getAttribute('x2')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y2')) * sy);
\t\t}
\t\telse if (name == 'curve')
\t\t{
\t\t\tcanvas.curveTo(x0 + Number(node.getAttribute('x1')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y1')) * sy,
\t\t\t\t\tx0 + Number(node.getAttribute('x2')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y2')) * sy,
\t\t\t\t\tx0 + Number(node.getAttribute('x3')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y3')) * sy);
\t\t}
\t\telse if (name == 'arc')
\t\t{
\t\t\tcanvas.arcTo(Number(node.getAttribute('rx')) * sx,
\t\t\t\t\tNumber(node.getAttribute('ry')) * sy,
\t\t\t\t\tNumber(node.getAttribute('x-axis-rotation')),
\t\t\t\t\tNumber(node.getAttribute('large-arc-flag')),
\t\t\t\t\tNumber(node.getAttribute('sweep-flag')),
\t\t\t\t\tx0 + Number(node.getAttribute('x')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y')) * sy);
\t\t}
\t\telse if (name == 'rect')
\t\t{
\t\t\tcanvas.rect(x0 + Number(node.getAttribute('x')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y')) * sy,
\t\t\t\t\tNumber(node.getAttribute('w')) * sx,
\t\t\t\t\tNumber(node.getAttribute('h')) * sy);
\t\t}
\t\telse if (name == 'roundrect')
\t\t{
\t\t\tvar arcsize = Number(node.getAttribute('arcsize'));
\t
\t\t\tif (arcsize == 0)
\t\t\t{
\t\t\t\tarcsize = mxConstants.RECTANGLE_ROUNDING_FACTOR * 100;
\t\t\t}
\t\t\t
\t\t\tvar w = Number(node.getAttribute('w')) * sx;
\t\t\tvar h = Number(node.getAttribute('h')) * sy;
\t\t\tvar factor = Number(arcsize) / 100;
\t\t\tvar r = Math.min(w * factor, h * factor);
\t\t\t
\t\t\tcanvas.roundrect(x0 + Number(node.getAttribute('x')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y')) * sy,
\t\t\t\t\tw, h, r, r);
\t\t}
\t\telse if (name == 'ellipse')
\t\t{
\t\t\tcanvas.ellipse(x0 + Number(node.getAttribute('x')) * sx,
\t\t\t\ty0 + Number(node.getAttribute('y')) * sy,
\t\t\t\tNumber(node.getAttribute('w')) * sx,
\t\t\t\tNumber(node.getAttribute('h')) * sy);
\t\t}
\t\telse if (name == 'image')
\t\t{
\t\t\tif (!shape.outline)
\t\t\t{
\t\t\t\tvar src = this.evaluateAttribute(node, 'src', shape);
\t\t\t\t
\t\t\t\tcanvas.image(x0 + Number(node.getAttribute('x')) * sx,
\t\t\t\t\ty0 + Number(node.getAttribute('y')) * sy,
\t\t\t\t\tNumber(node.getAttribute('w')) * sx,
\t\t\t\t\tNumber(node.getAttribute('h')) * sy,
\t\t\t\t\tsrc, false, node.getAttribute('flipH') == '1',
\t\t\t\t\tnode.getAttribute('flipV') == '1');
\t\t\t}
\t\t}
\t\telse if (name == 'text')
\t\t{
\t\t\tif (!shape.outline)
\t\t\t{
\t\t\t\tvar str = this.evaluateTextAttribute(node, 'str', shape);
\t\t\t\tvar rotation = node.getAttribute('vertical') == '1' ? -90 : 0;
\t\t\t\t
\t\t\t\tif (node.getAttribute('align-shape') == '0')
\t\t\t\t{
\t\t\t\t\tvar dr = shape.rotation;
\t\t
\t\t\t\t\t// Depends on flipping
\t\t\t\t\tvar flipH = mxUtils.getValue(shape.style, mxConstants.STYLE_FLIPH, 0) == 1;
\t\t\t\t\tvar flipV = mxUtils.getValue(shape.style, mxConstants.STYLE_FLIPV, 0) == 1;
\t\t\t\t\t
\t\t\t\t\tif (flipH && flipV)
\t\t\t\t\t{
\t\t\t\t\t\trotation -= dr;
\t\t\t\t\t}
\t\t\t\t\telse if (flipH || flipV)
\t\t\t\t\t{
\t\t\t\t\t\trotation += dr;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\trotation -= dr;
\t\t\t\t\t}
\t\t\t\t}
\t\t
\t\t\t\trotation -= node.getAttribute('rotation');
\t\t
\t\t\t\tcanvas.text(x0 + Number(node.getAttribute('x')) * sx,
\t\t\t\t\t\ty0 + Number(node.getAttribute('y')) * sy,
\t\t\t\t\t\t0, 0, str, node.getAttribute('align') || 'left',
\t\t\t\t\t\tnode.getAttribute('valign') || 'top', false, '',
\t\t\t\t\t\tnull, false, rotation);
\t\t\t}
\t\t}
\t\telse if (name == 'include-shape')
\t\t{
\t\t\tvar stencil = mxStencilRegistry.getStencil(node.getAttribute('name'));
\t\t\t
\t\t\tif (stencil != null)
\t\t\t{
\t\t\t\tvar x = x0 + Number(node.getAttribute('x')) * sx;
\t\t\t\tvar y = y0 + Number(node.getAttribute('y')) * sy;
\t\t\t\tvar w = Number(node.getAttribute('w')) * sx;
\t\t\t\tvar h = Number(node.getAttribute('h')) * sy;
\t\t\t\t
\t\t\t\tstencil.drawShape(canvas, shape, x, y, w, h);
\t\t\t}
\t\t}
\t\telse if (name == 'fillstroke')
\t\t{
\t\t\tcanvas.fillAndStroke();
\t\t}
\t\telse if (name == 'fill')
\t\t{
\t\t\tcanvas.fill();
\t\t}
\t\telse if (name == 'stroke')
\t\t{
\t\t\tcanvas.stroke();
\t\t}
\t\telse if (name == 'strokewidth')
\t\t{
\t\t\tvar s = (node.getAttribute('fixed') == '1') ? 1 : minScale;
\t\t\tcanvas.setStrokeWidth(Number(node.getAttribute('width')) * s);
\t\t}
\t\telse if (name == 'dashed')
\t\t{
\t\t\tcanvas.setDashed(node.getAttribute('dashed') == '1');
\t\t}
\t\telse if (name == 'dashpattern')
\t\t{
\t\t\tvar value = node.getAttribute('pattern');
\t\t\t
\t\t\tif (value != null)
\t\t\t{
\t\t\t\tvar tmp = value.split(' ');
\t\t\t\tvar pat = [];
\t\t\t\t
\t\t\t\tfor (var i = 0; i < tmp.length; i++)
\t\t\t\t{
\t\t\t\t\tif (tmp[i].length > 0)
\t\t\t\t\t{
\t\t\t\t\t\tpat.push(Number(tmp[i]) * minScale);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tvalue = pat.join(' ');
\t\t\t\tcanvas.setDashPattern(value);
\t\t\t}
\t\t}
\t\telse if (name == 'strokecolor')
\t\t{
\t\t\tcanvas.setStrokeColor(node.getAttribute('color'));
\t\t}
\t\telse if (name == 'linecap')
\t\t{
\t\t\tcanvas.setLineCap(node.getAttribute('cap'));
\t\t}
\t\telse if (name == 'linejoin')
\t\t{
\t\t\tcanvas.setLineJoin(node.getAttribute('join'));
\t\t}
\t\telse if (name == 'miterlimit')
\t\t{
\t\t\tcanvas.setMiterLimit(Number(node.getAttribute('limit')));
\t\t}
\t\telse if (name == 'fillcolor')
\t\t{
\t\t\tcanvas.setFillColor(node.getAttribute('color'));
\t\t}
\t\telse if (name == 'alpha')
\t\t{
\t\t\tcanvas.setAlpha(node.getAttribute('alpha'));
\t\t}
\t\telse if (name == 'fillalpha')
\t\t{
\t\t\tcanvas.setAlpha(node.getAttribute('alpha'));
\t\t}
\t\telse if (name == 'strokealpha')
\t\t{
\t\t\tcanvas.setAlpha(node.getAttribute('alpha'));
\t\t}
\t\telse if (name == 'fontcolor')
\t\t{
\t\t\tcanvas.setFontColor(node.getAttribute('color'));
\t\t}
\t\telse if (name == 'fontstyle')
\t\t{
\t\t\tcanvas.setFontStyle(node.getAttribute('style'));
\t\t}
\t\telse if (name == 'fontfamily')
\t\t{
\t\t\tcanvas.setFontFamily(node.getAttribute('family'));
\t\t}
\t\telse if (name == 'fontsize')
\t\t{
\t\t\tcanvas.setFontSize(Number(node.getAttribute('size')) * minScale);
\t\t}
\t\t
\t\tif (disableShadow && (name == 'fillstroke' || name == 'fill' || name == 'stroke'))
\t\t{
\t\t\tdisableShadow = false;
\t\t\tcanvas.setShadow(false);
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 * 
 * Code to add stencils.
 * 
 * (code)
 * var req = mxUtils.load('test/stencils.xml');
 * var root = req.getDocumentElement();
 * var shape = root.firstChild;
 * 
 * while (shape != null)
 * {
 * \t if (shape.nodeType == mxConstants.NODETYPE_ELEMENT)
 *   {
 *     mxStencilRegistry.addStencil(shape.getAttribute('name'), new mxStencil(shape));
 *   }
 *   
 *   shape = shape.nextSibling;
 * }
 * (end)
 */
var mxStencilRegistry =
{
\t/**
\t * Class: mxStencilRegistry
\t * 
\t * A singleton class that provides a registry for stencils and the methods
\t * for painting those stencils onto a canvas or into a DOM.
\t */
\tstencils: {},
\t
\t/**
\t * Function: addStencil
\t * 
\t * Adds the given <mxStencil>.
\t */
\taddStencil: function(name, stencil)
\t{
\t\tmxStencilRegistry.stencils[name] = stencil;
\t},
\t
\t/**
\t * Function: getStencil
\t * 
\t * Returns the <mxStencil> for the given name.
\t */
\tgetStencil: function(name)
\t{
\t\treturn mxStencilRegistry.stencils[name];
\t}

};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
var mxMarker =
{
\t/**
\t * Class: mxMarker
\t * 
\t * A static class that implements all markers for VML and SVG using a
\t * registry. NOTE: The signatures in this class will change.
\t * 
\t * Variable: markers
\t * 
\t * Maps from markers names to functions to paint the markers.
\t */
\tmarkers: [],
\t
\t/**
\t * Function: addMarker
\t * 
\t * Adds a factory method that updates a given endpoint and returns a
\t * function to paint the marker onto the given canvas.
\t */
\taddMarker: function(type, funct)
\t{
\t\tmxMarker.markers[type] = funct;
\t},
\t
\t/**
\t * Function: createMarker
\t * 
\t * Returns a function to paint the given marker.
\t */
\tcreateMarker: function(canvas, shape, type, pe, unitX, unitY, size, source, sw, filled)
\t{
\t\tvar funct = mxMarker.markers[type];
\t\t
\t\treturn (funct != null) ? funct(canvas, shape, type, pe, unitX, unitY, size, source, sw, filled) : null;
\t}

};

/**
 * Adds the classic and block marker factory method.
 */
(function()
{
\tfunction createArrow(widthFactor)
\t{
\t\twidthFactor = (widthFactor != null) ? widthFactor : 2;
\t\t
\t\treturn function(canvas, shape, type, pe, unitX, unitY, size, source, sw, filled)
\t\t{
\t\t\t// The angle of the forward facing arrow sides against the x axis is
\t\t\t// 26.565 degrees, 1/sin(26.565) = 2.236 / 2 = 1.118 ( / 2 allows for
\t\t\t// only half the strokewidth is processed ).
\t\t\tvar endOffsetX = unitX * sw * 1.118;
\t\t\tvar endOffsetY = unitY * sw * 1.118;
\t\t\t
\t\t\tunitX = unitX * (size + sw);
\t\t\tunitY = unitY * (size + sw);
\t
\t\t\tvar pt = pe.clone();
\t\t\tpt.x -= endOffsetX;
\t\t\tpt.y -= endOffsetY;
\t\t\t
\t\t\tvar f = (type != mxConstants.ARROW_CLASSIC && type != mxConstants.ARROW_CLASSIC_THIN) ? 1 : 3 / 4;
\t\t\tpe.x += -unitX * f - endOffsetX;
\t\t\tpe.y += -unitY * f - endOffsetY;
\t\t\t
\t\t\treturn function()
\t\t\t{
\t\t\t\tcanvas.begin();
\t\t\t\tcanvas.moveTo(pt.x, pt.y);
\t\t\t\tcanvas.lineTo(pt.x - unitX - unitY / widthFactor, pt.y - unitY + unitX / widthFactor);
\t\t\t
\t\t\t\tif (type == mxConstants.ARROW_CLASSIC || type == mxConstants.ARROW_CLASSIC_THIN)
\t\t\t\t{
\t\t\t\t\tcanvas.lineTo(pt.x - unitX * 3 / 4, pt.y - unitY * 3 / 4);
\t\t\t\t}
\t\t\t
\t\t\t\tcanvas.lineTo(pt.x + unitY / widthFactor - unitX, pt.y - unitY - unitX / widthFactor);
\t\t\t\tcanvas.close();
\t
\t\t\t\tif (filled)
\t\t\t\t{
\t\t\t\t\tcanvas.fillAndStroke();
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tcanvas.stroke();
\t\t\t\t}
\t\t\t};
\t\t}
\t};
\t
\tmxMarker.addMarker('classic', createArrow(2));
\tmxMarker.addMarker('classicThin', createArrow(3));
\tmxMarker.addMarker('block', createArrow(2));
\tmxMarker.addMarker('blockThin', createArrow(3));
\t
\tfunction createOpenArrow(widthFactor)
\t{
\t\twidthFactor = (widthFactor != null) ? widthFactor : 2;
\t\t
\t\treturn function(canvas, shape, type, pe, unitX, unitY, size, source, sw, filled)
\t\t{
\t\t\t// The angle of the forward facing arrow sides against the x axis is
\t\t\t// 26.565 degrees, 1/sin(26.565) = 2.236 / 2 = 1.118 ( / 2 allows for
\t\t\t// only half the strokewidth is processed ).
\t\t\tvar endOffsetX = unitX * sw * 1.118;
\t\t\tvar endOffsetY = unitY * sw * 1.118;
\t\t\t
\t\t\tunitX = unitX * (size + sw);
\t\t\tunitY = unitY * (size + sw);
\t\t\t
\t\t\tvar pt = pe.clone();
\t\t\tpt.x -= endOffsetX;
\t\t\tpt.y -= endOffsetY;
\t\t\t
\t\t\tpe.x += -endOffsetX * 2;
\t\t\tpe.y += -endOffsetY * 2;

\t\t\treturn function()
\t\t\t{
\t\t\t\tcanvas.begin();
\t\t\t\tcanvas.moveTo(pt.x - unitX - unitY / widthFactor, pt.y - unitY + unitX / widthFactor);
\t\t\t\tcanvas.lineTo(pt.x, pt.y);
\t\t\t\tcanvas.lineTo(pt.x + unitY / widthFactor - unitX, pt.y - unitY - unitX / widthFactor);
\t\t\t\tcanvas.stroke();
\t\t\t};
\t\t}
\t};
\t
\tmxMarker.addMarker('open', createOpenArrow(2));
\tmxMarker.addMarker('openThin', createOpenArrow(3));
\t
\tmxMarker.addMarker('oval', function(canvas, shape, type, pe, unitX, unitY, size, source, sw, filled)
\t{
\t\tvar a = size / 2;
\t\t
\t\tvar pt = pe.clone();
\t\tpe.x -= unitX * a;
\t\tpe.y -= unitY * a;

\t\treturn function()
\t\t{
\t\t\tcanvas.ellipse(pt.x - a, pt.y - a, size, size);
\t\t\t\t\t\t
\t\t\tif (filled)
\t\t\t{
\t\t\t\tcanvas.fillAndStroke();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tcanvas.stroke();
\t\t\t}
\t\t};
\t});

\tfunction diamond(canvas, shape, type, pe, unitX, unitY, size, source, sw, filled)
\t{
\t\t// The angle of the forward facing arrow sides against the x axis is
\t\t// 45 degrees, 1/sin(45) = 1.4142 / 2 = 0.7071 ( / 2 allows for
\t\t// only half the strokewidth is processed ). Or 0.9862 for thin diamond.
\t\t// Note these values and the tk variable below are dependent, update
\t\t// both together (saves trig hard coding it).
\t\tvar swFactor = (type == mxConstants.ARROW_DIAMOND) ?  0.7071 : 0.9862;
\t\tvar endOffsetX = unitX * sw * swFactor;
\t\tvar endOffsetY = unitY * sw * swFactor;
\t\t
\t\tunitX = unitX * (size + sw);
\t\tunitY = unitY * (size + sw);
\t\t
\t\tvar pt = pe.clone();
\t\tpt.x -= endOffsetX;
\t\tpt.y -= endOffsetY;
\t\t
\t\tpe.x += -unitX - endOffsetX;
\t\tpe.y += -unitY - endOffsetY;
\t\t
\t\t// thickness factor for diamond
\t\tvar tk = ((type == mxConstants.ARROW_DIAMOND) ?  2 : 3.4);
\t\t
\t\treturn function()
\t\t{
\t\t\tcanvas.begin();
\t\t\tcanvas.moveTo(pt.x, pt.y);
\t\t\tcanvas.lineTo(pt.x - unitX / 2 - unitY / tk, pt.y + unitX / tk - unitY / 2);
\t\t\tcanvas.lineTo(pt.x - unitX, pt.y - unitY);
\t\t\tcanvas.lineTo(pt.x - unitX / 2 + unitY / tk, pt.y - unitY / 2 - unitX / tk);
\t\t\tcanvas.close();
\t\t\t
\t\t\tif (filled)
\t\t\t{
\t\t\t\tcanvas.fillAndStroke();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tcanvas.stroke();
\t\t\t}
\t\t};
\t};

\tmxMarker.addMarker('diamond', diamond);
\tmxMarker.addMarker('diamondThin', diamond);
})();
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxActor
 *
 * Extends <mxShape> to implement an actor shape. If a custom shape with one
 * filled area is needed, then this shape's <redrawPath> should be overridden.
 * 
 * Example:
 * 
 * (code)
 * function SampleShape() { }
 * 
 * SampleShape.prototype = new mxActor();
 * SampleShape.prototype.constructor = vsAseShape;
 * 
 * mxCellRenderer.registerShape('sample', SampleShape);
 * SampleShape.prototype.redrawPath = function(path, x, y, w, h)
 * {
 *   path.moveTo(0, 0);
 *   path.lineTo(w, h);
 *   // ...
 *   path.close();
 * }
 * (end)
 * 
 * This shape is registered under <mxConstants.SHAPE_ACTOR> in
 * <mxCellRenderer>.
 * 
 * Constructor: mxActor
 *
 * Constructs a new actor shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxActor(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxActor, mxShape);

/**
 * Function: paintVertexShape
 * 
 * Redirects to redrawPath for subclasses to work.
 */
mxActor.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tc.translate(x, y);
\tc.begin();
\tthis.redrawPath(c, x, y, w, h);
\tc.fillAndStroke();
};

/**
 * Function: redrawPath
 *
 * Draws the path for this shape.
 */
mxActor.prototype.redrawPath = function(c, x, y, w, h)
{
\tvar width = w/3;
\tc.moveTo(0, h);
\tc.curveTo(0, 3 * h / 5, 0, 2 * h / 5, w / 2, 2 * h / 5);
\tc.curveTo(w / 2 - width, 2 * h / 5, w / 2 - width, 0, w / 2, 0);
\tc.curveTo(w / 2 + width, 0, w / 2 + width, 2 * h / 5, w / 2, 2 * h / 5);
\tc.curveTo(w, 2 * h / 5, w, 3 * h / 5, w, h);
\tc.close();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxCloud
 *
 * Extends <mxActor> to implement a cloud shape.
 * 
 * This shape is registered under <mxConstants.SHAPE_CLOUD> in
 * <mxCellRenderer>.
 * 
 * Constructor: mxCloud
 *
 * Constructs a new cloud shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxCloud(bounds, fill, stroke, strokewidth)
{
\tmxActor.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxActor.
 */
mxUtils.extend(mxCloud, mxActor);

/**
 * Function: redrawPath
 *
 * Draws the path for this shape.
 */
mxCloud.prototype.redrawPath = function(c, x, y, w, h)
{
\tc.moveTo(0.25 * w, 0.25 * h);
\tc.curveTo(0.05 * w, 0.25 * h, 0, 0.5 * h, 0.16 * w, 0.55 * h);
\tc.curveTo(0, 0.66 * h, 0.18 * w, 0.9 * h, 0.31 * w, 0.8 * h);
\tc.curveTo(0.4 * w, h, 0.7 * w, h, 0.8 * w, 0.8 * h);
\tc.curveTo(w, 0.8 * h, w, 0.6 * h, 0.875 * w, 0.5 * h);
\tc.curveTo(w, 0.3 * h, 0.8 * w, 0.1 * h, 0.625 * w, 0.2 * h);
\tc.curveTo(0.5 * w, 0.05 * h, 0.3 * w, 0.05 * h, 0.25 * w, 0.25 * h);
\tc.close();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxRectangleShape
 *
 * Extends <mxShape> to implement a rectangle shape.
 * This shape is registered under <mxConstants.SHAPE_RECTANGLE>
 * in <mxCellRenderer>.
 * 
 * Constructor: mxRectangleShape
 *
 * Constructs a new rectangle shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxRectangleShape(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxRectangleShape, mxShape);

/**
 * Function: isHtmlAllowed
 *
 * Returns true for non-rounded, non-rotated shapes with no glass gradient.
 */
mxRectangleShape.prototype.isHtmlAllowed = function()
{
\tvar events = true;
\t
\tif (this.style != null)
\t{
\t\tevents = mxUtils.getValue(this.style, mxConstants.STYLE_POINTER_EVENTS, '1') == '1';\t\t
\t}
\t
\treturn !this.isRounded && !this.glass && this.rotation == 0 && (events ||
\t\t(this.fill != null && this.fill != mxConstants.NONE));
};

/**
 * Function: paintBackground
 * 
 * Generic background painting implementation.
 */
mxRectangleShape.prototype.paintBackground = function(c, x, y, w, h)
{
\tvar events = true;
\t
\tif (this.style != null)
\t{
\t\tevents = mxUtils.getValue(this.style, mxConstants.STYLE_POINTER_EVENTS, '1') == '1';
\t}
\t
\tif (events || (this.fill != null && this.fill != mxConstants.NONE) ||
\t\t(this.stroke != null && this.stroke != mxConstants.NONE))
\t{
\t\tif (!events && (this.fill == null || this.fill == mxConstants.NONE))
\t\t{
\t\t\tc.pointerEvents = false;
\t\t}
\t\t
\t\tif (this.isRounded)
\t\t{
\t\t\tvar r = 0;
\t\t\t
\t\t\tif (mxUtils.getValue(this.style, mxConstants.STYLE_ABSOLUTE_ARCSIZE, 0) == '1')
\t\t\t{
\t\t\t\tr = Math.min(w / 2, Math.min(h / 2, mxUtils.getValue(this.style,
\t\t\t\t\tmxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2));
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tvar f = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE,
\t\t\t\t\tmxConstants.RECTANGLE_ROUNDING_FACTOR * 100) / 100;
\t\t\t\tr = Math.min(w * f, h * f);
\t\t\t}
\t\t\t
\t\t\tc.roundrect(x, y, w, h, r, r);
\t\t}
\t\telse
\t\t{
\t\t\tc.rect(x, y, w, h);
\t\t}
\t\t\t
\t\tc.fillAndStroke();
\t}
};

/**
 * Function: isRoundable
 * 
 * Adds roundable support.
 */
mxRectangleShape.prototype.isRoundable = function(c, x, y, w, h)
{
\treturn true;
};

/**
 * Function: paintForeground
 * 
 * Generic background painting implementation.
 */
mxRectangleShape.prototype.paintForeground = function(c, x, y, w, h)
{
\tif (this.glass && !this.outline && this.fill != null && this.fill != mxConstants.NONE)
\t{
\t\tthis.paintGlassEffect(c, x, y, w, h, this.getArcSize(w + this.strokewidth, h + this.strokewidth));
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxEllipse
 *
 * Extends <mxShape> to implement an ellipse shape.
 * This shape is registered under <mxConstants.SHAPE_ELLIPSE>
 * in <mxCellRenderer>.
 * 
 * Constructor: mxEllipse
 *
 * Constructs a new ellipse shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxEllipse(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxEllipse, mxShape);

/**
 * Function: paintVertexShape
 * 
 * Paints the ellipse shape.
 */
mxEllipse.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tc.ellipse(x, y, w, h);
\tc.fillAndStroke();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxDoubleEllipse
 *
 * Extends <mxShape> to implement a double ellipse shape. This shape is
 * registered under <mxConstants.SHAPE_DOUBLE_ELLIPSE> in <mxCellRenderer>.
 * Use the following override to only fill the inner ellipse in this shape:
 * 
 * (code)
 * mxDoubleEllipse.prototype.paintVertexShape = function(c, x, y, w, h)
 * {
 *   c.ellipse(x, y, w, h);
 *   c.stroke();
 *   
 *   var inset = mxUtils.getValue(this.style, mxConstants.STYLE_MARGIN, Math.min(3 + this.strokewidth, Math.min(w / 5, h / 5)));
 *   x += inset;
 *   y += inset;
 *   w -= 2 * inset;
 *   h -= 2 * inset;
 *   
 *   if (w > 0 && h > 0)
 *   {
 *     c.ellipse(x, y, w, h);
 *   }
 *   
 *   c.fillAndStroke();
 * };
 * (end)
 * 
 * Constructor: mxDoubleEllipse
 *
 * Constructs a new ellipse shape.
 *
 * Parameters:
 *
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxDoubleEllipse(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxDoubleEllipse, mxShape);

/**
 * Variable: vmlScale
 * 
 * Scale for improving the precision of VML rendering. Default is 10.
 */
mxDoubleEllipse.prototype.vmlScale = 10;

/**
 * Function: paintBackground
 * 
 * Paints the background.
 */
mxDoubleEllipse.prototype.paintBackground = function(c, x, y, w, h)
{
\tc.ellipse(x, y, w, h);
\tc.fillAndStroke();
};

/**
 * Function: paintForeground
 * 
 * Paints the foreground.
 */
mxDoubleEllipse.prototype.paintForeground = function(c, x, y, w, h)
{
\tif (!this.outline)
\t{
\t\tvar margin = mxUtils.getValue(this.style, mxConstants.STYLE_MARGIN, Math.min(3 + this.strokewidth, Math.min(w / 5, h / 5)));
\t\tx += margin;
\t\ty += margin;
\t\tw -= 2 * margin;
\t\th -= 2 * margin;
\t\t
\t\t// FIXME: Rounding issues in IE8 standards mode (not in 1.x)
\t\tif (w > 0 && h > 0)
\t\t{
\t\t\tc.ellipse(x, y, w, h);
\t\t}
\t\t
\t\tc.stroke();
\t}
};

/**
 * Function: getLabelBounds
 * 
 * Returns the bounds for the label.
 */
mxDoubleEllipse.prototype.getLabelBounds = function(rect)
{
\tvar margin = (mxUtils.getValue(this.style, mxConstants.STYLE_MARGIN, Math.min(3 + this.strokewidth,
\t\t\tMath.min(rect.width / 5 / this.scale, rect.height / 5 / this.scale)))) * this.scale;

\treturn new mxRectangle(rect.x + margin, rect.y + margin, rect.width - 2 * margin, rect.height - 2 * margin);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxRhombus
 *
 * Extends <mxShape> to implement a rhombus (aka diamond) shape.
 * This shape is registered under <mxConstants.SHAPE_RHOMBUS>
 * in <mxCellRenderer>.
 * 
 * Constructor: mxRhombus
 *
 * Constructs a new rhombus shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxRhombus(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxRhombus, mxShape);

/**
 * Function: isRoundable
 * 
 * Adds roundable support.
 */
mxRhombus.prototype.isRoundable = function()
{
\treturn true;
};

/**
 * Function: paintVertexShape
 * 
 * Generic painting implementation.
 */
mxRhombus.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tvar hw = w / 2;
\tvar hh = h / 2;
\t
\tvar arcSize = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2;
\tc.begin();
\tthis.addPoints(c, [new mxPoint(x + hw, y), new mxPoint(x + w, y + hh), new mxPoint(x + hw, y + h),
\t     new mxPoint(x, y + hh)], this.isRounded, arcSize, true);
\tc.fillAndStroke();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxPolyline
 *
 * Extends <mxShape> to implement a polyline (a line with multiple points).
 * This shape is registered under <mxConstants.SHAPE_POLYLINE> in
 * <mxCellRenderer>.
 * 
 * Constructor: mxPolyline
 *
 * Constructs a new polyline shape.
 * 
 * Parameters:
 * 
 * points - Array of <mxPoints> that define the points. This is stored in
 * <mxShape.points>.
 * stroke - String that defines the stroke color. Default is 'black'. This is
 * stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxPolyline(points, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.points = points;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxPolyline, mxShape);

/**
 * Function: getRotation
 * 
 * Returns 0.
 */
mxPolyline.prototype.getRotation = function()
{
\treturn 0;
};

/**
 * Function: getShapeRotation
 * 
 * Returns 0.
 */
mxPolyline.prototype.getShapeRotation = function()
{
\treturn 0;
};

/**
 * Function: isPaintBoundsInverted
 * 
 * Returns false.
 */
mxPolyline.prototype.isPaintBoundsInverted = function()
{
\treturn false;
};

/**
 * Function: paintEdgeShape
 * 
 * Paints the line shape.
 */
mxPolyline.prototype.paintEdgeShape = function(c, pts)
{
\tvar prev = c.pointerEventsValue;
\tc.pointerEventsValue = 'stroke';
\t
\tif (this.style == null || this.style[mxConstants.STYLE_CURVED] != 1)
\t{
\t\tthis.paintLine(c, pts, this.isRounded);
\t}
\telse
\t{
\t\tthis.paintCurvedLine(c, pts);
\t}
\t
\tc.pointerEventsValue = prev;
};

/**
 * Function: paintLine
 * 
 * Paints the line shape.
 */
mxPolyline.prototype.paintLine = function(c, pts, rounded)
{
\tvar arcSize = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2;
\tc.begin();
\tthis.addPoints(c, pts, rounded, arcSize, false);
\tc.stroke();
};

/**
 * Function: paintCurvedLine
 * 
 * Paints a curved line.
 */
mxPolyline.prototype.paintCurvedLine = function(c, pts)
{
\tc.begin();
\t
\tvar pt = pts[0];
\tvar n = pts.length;
\t
\tc.moveTo(pt.x, pt.y);
\t
\tfor (var i = 1; i < n - 2; i++)
\t{
\t\tvar p0 = pts[i];
\t\tvar p1 = pts[i + 1];
\t\tvar ix = (p0.x + p1.x) / 2;
\t\tvar iy = (p0.y + p1.y) / 2;
\t\t
\t\tc.quadTo(p0.x, p0.y, ix, iy);
\t}
\t
\tvar p0 = pts[n - 2];
\tvar p1 = pts[n - 1];
\t
\tc.quadTo(p0.x, p0.y, p1.x, p1.y);
\tc.stroke();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxArrow
 *
 * Extends <mxShape> to implement an arrow shape. (The shape
 * is used to represent edges, not vertices.)
 * This shape is registered under <mxConstants.SHAPE_ARROW>
 * in <mxCellRenderer>.
 * 
 * Constructor: mxArrow
 *
 * Constructs a new arrow shape.
 * 
 * Parameters:
 * 
 * points - Array of <mxPoints> that define the points. This is stored in
 * <mxShape.points>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 * arrowWidth - Optional integer that defines the arrow width. Default is
 * <mxConstants.ARROW_WIDTH>. This is stored in <arrowWidth>.
 * spacing - Optional integer that defines the spacing between the arrow shape
 * and its endpoints. Default is <mxConstants.ARROW_SPACING>. This is stored in
 * <spacing>.
 * endSize - Optional integer that defines the size of the arrowhead. Default
 * is <mxConstants.ARROW_SIZE>. This is stored in <endSize>.
 */
function mxArrow(points, fill, stroke, strokewidth, arrowWidth, spacing, endSize)
{
\tmxShape.call(this);
\tthis.points = points;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
\tthis.arrowWidth = (arrowWidth != null) ? arrowWidth : mxConstants.ARROW_WIDTH;
\tthis.spacing = (spacing != null) ? spacing : mxConstants.ARROW_SPACING;
\tthis.endSize = (endSize != null) ? endSize : mxConstants.ARROW_SIZE;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxArrow, mxShape);

/**
 * Function: augmentBoundingBox
 *
 * Augments the bounding box with the edge width and markers.
 */
mxArrow.prototype.augmentBoundingBox = function(bbox)
{
\tmxShape.prototype.augmentBoundingBox.apply(this, arguments);
\t
\tvar w = Math.max(this.arrowWidth, this.endSize);
\tbbox.grow((w / 2 + this.strokewidth) * this.scale);
};

/**
 * Function: paintEdgeShape
 * 
 * Paints the line shape.
 */
mxArrow.prototype.paintEdgeShape = function(c, pts)
{
\t// Geometry of arrow
\tvar spacing =  mxConstants.ARROW_SPACING;
\tvar width = mxConstants.ARROW_WIDTH;
\tvar arrow = mxConstants.ARROW_SIZE;

\t// Base vector (between end points)
\tvar p0 = pts[0];
\tvar pe = pts[pts.length - 1];
\tvar dx = pe.x - p0.x;
\tvar dy = pe.y - p0.y;
\tvar dist = Math.sqrt(dx * dx + dy * dy);
\tvar length = dist - 2 * spacing - arrow;
\t
\t// Computes the norm and the inverse norm
\tvar nx = dx / dist;
\tvar ny = dy / dist;
\tvar basex = length * nx;
\tvar basey = length * ny;
\tvar floorx = width * ny/3;
\tvar floory = -width * nx/3;
\t
\t// Computes points
\tvar p0x = p0.x - floorx / 2 + spacing * nx;
\tvar p0y = p0.y - floory / 2 + spacing * ny;
\tvar p1x = p0x + floorx;
\tvar p1y = p0y + floory;
\tvar p2x = p1x + basex;
\tvar p2y = p1y + basey;
\tvar p3x = p2x + floorx;
\tvar p3y = p2y + floory;
\t// p4 not necessary
\tvar p5x = p3x - 3 * floorx;
\tvar p5y = p3y - 3 * floory;
\t
\tc.begin();
\tc.moveTo(p0x, p0y);
\tc.lineTo(p1x, p1y);
\tc.lineTo(p2x, p2y);
\tc.lineTo(p3x, p3y);
\tc.lineTo(pe.x - spacing * nx, pe.y - spacing * ny);
\tc.lineTo(p5x, p5y);
\tc.lineTo(p5x + floorx, p5y + floory);
\tc.close();

\tc.fillAndStroke();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxArrowConnector
 *
 * Extends <mxShape> to implement an new rounded arrow shape with support for
 * waypoints and double arrows. (The shape is used to represent edges, not
 * vertices.) This shape is registered under <mxConstants.SHAPE_ARROW_CONNECTOR>
 * in <mxCellRenderer>.
 * 
 * Constructor: mxArrowConnector
 *
 * Constructs a new arrow shape.
 * 
 * Parameters:
 * 
 * points - Array of <mxPoints> that define the points. This is stored in
 * <mxShape.points>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 * arrowWidth - Optional integer that defines the arrow width. Default is
 * <mxConstants.ARROW_WIDTH>. This is stored in <arrowWidth>.
 * spacing - Optional integer that defines the spacing between the arrow shape
 * and its endpoints. Default is <mxConstants.ARROW_SPACING>. This is stored in
 * <spacing>.
 * endSize - Optional integer that defines the size of the arrowhead. Default
 * is <mxConstants.ARROW_SIZE>. This is stored in <endSize>.
 */
function mxArrowConnector(points, fill, stroke, strokewidth, arrowWidth, spacing, endSize)
{
\tmxShape.call(this);
\tthis.points = points;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
\tthis.arrowWidth = (arrowWidth != null) ? arrowWidth : mxConstants.ARROW_WIDTH;
\tthis.arrowSpacing = (spacing != null) ? spacing : mxConstants.ARROW_SPACING;
\tthis.startSize = mxConstants.ARROW_SIZE / 5;
\tthis.endSize = mxConstants.ARROW_SIZE / 5;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxArrowConnector, mxShape);

/**
 * Variable: useSvgBoundingBox
 * 
 * Allows to use the SVG bounding box in SVG. Default is false for performance
 * reasons.
 */
mxArrowConnector.prototype.useSvgBoundingBox = true;

/**
 * Function: isRoundable
 * 
 * Hook for subclassers.
 */
mxArrowConnector.prototype.isRoundable = function()
{
\treturn true;
};

/**
 * Variable: resetStyles
 * 
 * Overrides mxShape to reset spacing.
 */
mxArrowConnector.prototype.resetStyles = function()
{
\tmxShape.prototype.resetStyles.apply(this, arguments);
\t
\tthis.arrowSpacing = mxConstants.ARROW_SPACING;
};

/**
 * Overrides apply to get smooth transition from default start- and endsize.
 */
mxArrowConnector.prototype.apply = function(state)
{
\tmxShape.prototype.apply.apply(this, arguments);

\tif (this.style != null)
\t{
\t\tthis.startSize = mxUtils.getNumber(this.style, mxConstants.STYLE_STARTSIZE, mxConstants.ARROW_SIZE / 5) * 3;
\t\tthis.endSize = mxUtils.getNumber(this.style, mxConstants.STYLE_ENDSIZE, mxConstants.ARROW_SIZE / 5) * 3;
\t}
};

/**
 * Function: augmentBoundingBox
 *
 * Augments the bounding box with the edge width and markers.
 */
mxArrowConnector.prototype.augmentBoundingBox = function(bbox)
{
\tmxShape.prototype.augmentBoundingBox.apply(this, arguments);
\t
\tvar w = this.getEdgeWidth();
\t
\tif (this.isMarkerStart())
\t{
\t\tw = Math.max(w, this.getStartArrowWidth());
\t}
\t
\tif (this.isMarkerEnd())
\t{
\t\tw = Math.max(w, this.getEndArrowWidth());
\t}
\t
\tbbox.grow((w / 2 + this.strokewidth) * this.scale);
};

/**
 * Function: paintEdgeShape
 * 
 * Paints the line shape.
 */
mxArrowConnector.prototype.paintEdgeShape = function(c, pts)
{
\t// Geometry of arrow
\tvar strokeWidth = this.strokewidth;
\t
\tif (this.outline)
\t{
\t\tstrokeWidth = Math.max(1, mxUtils.getNumber(this.style, mxConstants.STYLE_STROKEWIDTH, this.strokewidth));
\t}
\t
\tvar startWidth = this.getStartArrowWidth() + strokeWidth;
\tvar endWidth = this.getEndArrowWidth() + strokeWidth;
\tvar edgeWidth = this.outline ? this.getEdgeWidth() + strokeWidth : this.getEdgeWidth();
\tvar openEnded = this.isOpenEnded();
\tvar markerStart = this.isMarkerStart();
\tvar markerEnd = this.isMarkerEnd();
\tvar spacing = (openEnded) ? 0 : this.arrowSpacing + strokeWidth / 2;
\tvar startSize = this.startSize + strokeWidth;
\tvar endSize = this.endSize + strokeWidth;
\tvar isRounded = this.isArrowRounded();
\t
\t// Base vector (between first points)
\tvar pe = pts[pts.length - 1];

\t// Finds first non-overlapping point
\tvar i0 = 1;
\t
\twhile (i0 < pts.length - 1 && pts[i0].x == pts[0].x && pts[i0].y == pts[0].y)
\t{
\t\ti0++;
\t}
\t
\tvar dx = pts[i0].x - pts[0].x;
\tvar dy = pts[i0].y - pts[0].y;
\tvar dist = Math.sqrt(dx * dx + dy * dy);
\t
\tif (dist == 0)
\t{
\t\treturn;
\t}
\t
\t// Computes the norm and the inverse norm
\tvar nx = dx / dist;
\tvar nx2, nx1 = nx;
\tvar ny = dy / dist;
\tvar ny2, ny1 = ny;
\tvar orthx = edgeWidth * ny;
\tvar orthy = -edgeWidth * nx;
\t
\t// Stores the inbound function calls in reverse order in fns
\tvar fns = [];
\t
\tif (isRounded)
\t{
\t\tc.setLineJoin('round');
\t}
\telse if (pts.length > 2)
\t{
\t\t// Only mitre if there are waypoints
\t\tc.setMiterLimit(1.42);
\t}

\tc.begin();

\tvar startNx = nx;
\tvar startNy = ny;

\tif (markerStart && !openEnded)
\t{
\t\tthis.paintMarker(c, pts[0].x, pts[0].y, nx, ny, startSize, startWidth, edgeWidth, spacing, true);
\t}
\telse
\t{
\t\tvar outStartX = pts[0].x + orthx / 2 + spacing * nx;
\t\tvar outStartY = pts[0].y + orthy / 2 + spacing * ny;
\t\tvar inEndX = pts[0].x - orthx / 2 + spacing * nx;
\t\tvar inEndY = pts[0].y - orthy / 2 + spacing * ny;
\t\t
\t\tif (openEnded)
\t\t{
\t\t\tc.moveTo(outStartX, outStartY);
\t\t\t
\t\t\tfns.push(function()
\t\t\t{
\t\t\t\tc.lineTo(inEndX, inEndY);
\t\t\t});
\t\t}
\t\telse
\t\t{
\t\t\tc.moveTo(inEndX, inEndY);
\t\t\tc.lineTo(outStartX, outStartY);
\t\t}
\t}
\t
\tvar dx1 = 0;
\tvar dy1 = 0;
\tvar dist1 = 0;

\tfor (var i = 0; i < pts.length - 2; i++)
\t{
\t\t// Work out in which direction the line is bending
\t\tvar pos = mxUtils.relativeCcw(pts[i].x, pts[i].y, pts[i+1].x, pts[i+1].y, pts[i+2].x, pts[i+2].y);

\t\tdx1 = pts[i+2].x - pts[i+1].x;
\t\tdy1 = pts[i+2].y - pts[i+1].y;

\t\tdist1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
\t\t
\t\tif (dist1 != 0)
\t\t{
\t\t\tnx1 = dx1 / dist1;
\t\t\tny1 = dy1 / dist1;
\t\t\t
\t\t\tvar tmp1 = nx * nx1 + ny * ny1;
\t\t\tvar tmp = Math.max(Math.sqrt((tmp1 + 1) / 2), 0.04);
\t\t\t
\t\t\t// Work out the normal orthogonal to the line through the control point and the edge sides intersection
\t\t\tnx2 = (nx + nx1);
\t\t\tny2 = (ny + ny1);
\t
\t\t\tvar dist2 = Math.sqrt(nx2 * nx2 + ny2 * ny2);
\t\t\t
\t\t\tif (dist2 != 0)
\t\t\t{
\t\t\t\tnx2 = nx2 / dist2;
\t\t\t\tny2 = ny2 / dist2;
\t\t\t\t
\t\t\t\t// Higher strokewidths require a larger minimum bend, 0.35 covers all but the most extreme cases
\t\t\t\tvar strokeWidthFactor = Math.max(tmp, Math.min(this.strokewidth / 200 + 0.04, 0.35));
\t\t\t\tvar angleFactor = (pos != 0 && isRounded) ? Math.max(0.1, strokeWidthFactor) : Math.max(tmp, 0.06);

\t\t\t\tvar outX = pts[i+1].x + ny2 * edgeWidth / 2 / angleFactor;
\t\t\t\tvar outY = pts[i+1].y - nx2 * edgeWidth / 2 / angleFactor;
\t\t\t\tvar inX = pts[i+1].x - ny2 * edgeWidth / 2 / angleFactor;
\t\t\t\tvar inY = pts[i+1].y + nx2 * edgeWidth / 2 / angleFactor;
\t\t\t\t
\t\t\t\tif (pos == 0 || !isRounded)
\t\t\t\t{
\t\t\t\t\t// If the two segments are aligned, or if we're not drawing curved sections between segments
\t\t\t\t\t// just draw straight to the intersection point
\t\t\t\t\tc.lineTo(outX, outY);
\t\t\t\t\t
\t\t\t\t\t(function(x, y)
\t\t\t\t\t{
\t\t\t\t\t\tfns.push(function()
\t\t\t\t\t\t{
\t\t\t\t\t\t\tc.lineTo(x, y);
\t\t\t\t\t\t});
\t\t\t\t\t})(inX, inY);
\t\t\t\t}
\t\t\t\telse if (pos == -1)
\t\t\t\t{
\t\t\t\t\tvar c1x = inX + ny * edgeWidth;
\t\t\t\t\tvar c1y = inY - nx * edgeWidth;
\t\t\t\t\tvar c2x = inX + ny1 * edgeWidth;
\t\t\t\t\tvar c2y = inY - nx1 * edgeWidth;
\t\t\t\t\tc.lineTo(c1x, c1y);
\t\t\t\t\tc.quadTo(outX, outY, c2x, c2y);
\t\t\t\t\t
\t\t\t\t\t(function(x, y)
\t\t\t\t\t{
\t\t\t\t\t\tfns.push(function()
\t\t\t\t\t\t{
\t\t\t\t\t\t\tc.lineTo(x, y);
\t\t\t\t\t\t});
\t\t\t\t\t})(inX, inY);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tc.lineTo(outX, outY);
\t\t\t\t\t
\t\t\t\t\t(function(x, y)
\t\t\t\t\t{
\t\t\t\t\t\tvar c1x = outX - ny * edgeWidth;
\t\t\t\t\t\tvar c1y = outY + nx * edgeWidth;
\t\t\t\t\t\tvar c2x = outX - ny1 * edgeWidth;
\t\t\t\t\t\tvar c2y = outY + nx1 * edgeWidth;
\t\t\t\t\t\t
\t\t\t\t\t\tfns.push(function()
\t\t\t\t\t\t{
\t\t\t\t\t\t\tc.quadTo(x, y, c1x, c1y);
\t\t\t\t\t\t});
\t\t\t\t\t\tfns.push(function()
\t\t\t\t\t\t{
\t\t\t\t\t\t\tc.lineTo(c2x, c2y);
\t\t\t\t\t\t});
\t\t\t\t\t})(inX, inY);
\t\t\t\t}
\t\t\t\t
\t\t\t\tnx = nx1;
\t\t\t\tny = ny1;
\t\t\t}
\t\t}
\t}
\t
\torthx = edgeWidth * ny1;
\torthy = - edgeWidth * nx1;

\tif (markerEnd && !openEnded)
\t{
\t\tthis.paintMarker(c, pe.x, pe.y, -nx, -ny, endSize, endWidth, edgeWidth, spacing, false);
\t}
\telse
\t{
\t\tc.lineTo(pe.x - spacing * nx1 + orthx / 2, pe.y - spacing * ny1 + orthy / 2);
\t\t
\t\tvar inStartX = pe.x - spacing * nx1 - orthx / 2;
\t\tvar inStartY = pe.y - spacing * ny1 - orthy / 2;

\t\tif (!openEnded)
\t\t{
\t\t\tc.lineTo(inStartX, inStartY);
\t\t}
\t\telse
\t\t{
\t\t\tc.moveTo(inStartX, inStartY);
\t\t\t
\t\t\tfns.splice(0, 0, function()
\t\t\t{
\t\t\t\tc.moveTo(inStartX, inStartY);
\t\t\t});
\t\t}
\t}
\t
\tfor (var i = fns.length - 1; i >= 0; i--)
\t{
\t\tfns[i]();
\t}

\tif (openEnded)
\t{
\t\tc.end();
\t\tc.stroke();
\t}
\telse
\t{
\t\tc.close();
\t\tc.fillAndStroke();
\t}
\t
\t// Workaround for shadow on top of base arrow
\tc.setShadow(false);
\t
\t// Need to redraw the markers without the low miter limit
\tc.setMiterLimit(4);
\t
\tif (isRounded)
\t{
\t\tc.setLineJoin('flat');
\t}

\tif (pts.length > 2)
\t{
\t\t// Only to repaint markers if no waypoints
\t\t// Need to redraw the markers without the low miter limit
\t\tc.setMiterLimit(4);
\t\tif (markerStart && !openEnded)
\t\t{
\t\t\tc.begin();
\t\t\tthis.paintMarker(c, pts[0].x, pts[0].y, startNx, startNy, startSize, startWidth, edgeWidth, spacing, true);
\t\t\tc.stroke();
\t\t\tc.end();
\t\t}
\t\t
\t\tif (markerEnd && !openEnded)
\t\t{
\t\t\tc.begin();
\t\t\tthis.paintMarker(c, pe.x, pe.y, -nx, -ny, endSize, endWidth, edgeWidth, spacing, true);
\t\t\tc.stroke();
\t\t\tc.end();
\t\t}
\t}
};

/**
 * Function: paintMarker
 * 
 * Paints the marker.
 */
mxArrowConnector.prototype.paintMarker = function(c, ptX, ptY, nx, ny, size, arrowWidth, edgeWidth, spacing, initialMove)
{
\tvar widthArrowRatio = edgeWidth / arrowWidth;
\tvar orthx = edgeWidth * ny / 2;
\tvar orthy = -edgeWidth * nx / 2;

\tvar spaceX = (spacing + size) * nx;
\tvar spaceY = (spacing + size) * ny;

\tif (initialMove)
\t{
\t\tc.moveTo(ptX - orthx + spaceX, ptY - orthy + spaceY);
\t}
\telse
\t{
\t\tc.lineTo(ptX - orthx + spaceX, ptY - orthy + spaceY);
\t}

\tc.lineTo(ptX - orthx / widthArrowRatio + spaceX, ptY - orthy / widthArrowRatio + spaceY);
\tc.lineTo(ptX + spacing * nx, ptY + spacing * ny);
\tc.lineTo(ptX + orthx / widthArrowRatio + spaceX, ptY + orthy / widthArrowRatio + spaceY);
\tc.lineTo(ptX + orthx + spaceX, ptY + orthy + spaceY);
}

/**
 * Function: isArrowRounded
 * 
 * Returns wether the arrow is rounded
 */
mxArrowConnector.prototype.isArrowRounded = function()
{
\treturn this.isRounded;
};

/**
 * Function: getStartArrowWidth
 * 
 * Returns the width of the start arrow
 */
mxArrowConnector.prototype.getStartArrowWidth = function()
{
\treturn mxConstants.ARROW_WIDTH;
};

/**
 * Function: getEndArrowWidth
 * 
 * Returns the width of the end arrow
 */
mxArrowConnector.prototype.getEndArrowWidth = function()
{
\treturn mxConstants.ARROW_WIDTH;
};

/**
 * Function: getEdgeWidth
 * 
 * Returns the width of the body of the edge
 */
mxArrowConnector.prototype.getEdgeWidth = function()
{
\treturn mxConstants.ARROW_WIDTH / 3;
};

/**
 * Function: isOpenEnded
 * 
 * Returns whether the ends of the shape are drawn
 */
mxArrowConnector.prototype.isOpenEnded = function()
{
\treturn false;
};

/**
 * Function: isMarkerStart
 * 
 * Returns whether the start marker is drawn
 */
mxArrowConnector.prototype.isMarkerStart = function()
{
\treturn (mxUtils.getValue(this.style, mxConstants.STYLE_STARTARROW, mxConstants.NONE) != mxConstants.NONE);
};

/**
 * Function: isMarkerEnd
 * 
 * Returns whether the end marker is drawn
 */
mxArrowConnector.prototype.isMarkerEnd = function()
{
\treturn (mxUtils.getValue(this.style, mxConstants.STYLE_ENDARROW, mxConstants.NONE) != mxConstants.NONE);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxText
 *
 * Extends <mxShape> to implement a text shape. To change vertical text from
 * bottom to top to top to bottom, the following code can be used:
 * 
 * (code)
 * mxText.prototype.verticalTextRotation = 90;
 * (end)
 * 
 * Constructor: mxText
 *
 * Constructs a new text shape.
 * 
 * Parameters:
 * 
 * value - String that represents the text to be displayed. This is stored in
 * <value>.
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * align - Specifies the horizontal alignment. Default is ''. This is stored in
 * <align>.
 * valign - Specifies the vertical alignment. Default is ''. This is stored in
 * <valign>.
 * color - String that specifies the text color. Default is 'black'. This is
 * stored in <color>.
 * family - String that specifies the font family. Default is
 * <mxConstants.DEFAULT_FONTFAMILY>. This is stored in <family>.
 * size - Integer that specifies the font size. Default is
 * <mxConstants.DEFAULT_FONTSIZE>. This is stored in <size>.
 * fontStyle - Specifies the font style. Default is 0. This is stored in
 * <fontStyle>.
 * spacing - Integer that specifies the global spacing. Default is 2. This is
 * stored in <spacing>.
 * spacingTop - Integer that specifies the top spacing. Default is 0. The
 * sum of the spacing and this is stored in <spacingTop>.
 * spacingRight - Integer that specifies the right spacing. Default is 0. The
 * sum of the spacing and this is stored in <spacingRight>.
 * spacingBottom - Integer that specifies the bottom spacing. Default is 0.The
 * sum of the spacing and this is stored in <spacingBottom>.
 * spacingLeft - Integer that specifies the left spacing. Default is 0. The
 * sum of the spacing and this is stored in <spacingLeft>.
 * horizontal - Boolean that specifies if the label is horizontal. Default is
 * true. This is stored in <horizontal>.
 * background - String that specifies the background color. Default is null.
 * This is stored in <background>.
 * border - String that specifies the label border color. Default is null.
 * This is stored in <border>.
 * wrap - Specifies if word-wrapping should be enabled. Default is false.
 * This is stored in <wrap>.
 * clipped - Specifies if the label should be clipped. Default is false.
 * This is stored in <clipped>.
 * overflow - Value of the overflow style. Default is 'visible'.
 */
function mxText(value, bounds, align, valign, color,
\tfamily,\tsize, fontStyle, spacing, spacingTop, spacingRight,
\tspacingBottom, spacingLeft, horizontal, background, border,
\twrap, clipped, overflow, labelPadding, textDirection)
{
\tmxShape.call(this);
\tthis.value = value;
\tthis.bounds = bounds;
\tthis.color = (color != null) ? color : 'black';
\tthis.align = (align != null) ? align : mxConstants.ALIGN_CENTER;
\tthis.valign = (valign != null) ? valign : mxConstants.ALIGN_MIDDLE;
\tthis.family = (family != null) ? family : mxConstants.DEFAULT_FONTFAMILY;
\tthis.size = (size != null) ? size : mxConstants.DEFAULT_FONTSIZE;
\tthis.fontStyle = (fontStyle != null) ? fontStyle : mxConstants.DEFAULT_FONTSTYLE;
\tthis.spacing = parseInt(spacing || 2);
\tthis.spacingTop = this.spacing + parseInt(spacingTop || 0);
\tthis.spacingRight = this.spacing + parseInt(spacingRight || 0);
\tthis.spacingBottom = this.spacing + parseInt(spacingBottom || 0);
\tthis.spacingLeft = this.spacing + parseInt(spacingLeft || 0);
\tthis.horizontal = (horizontal != null) ? horizontal : true;
\tthis.background = background;
\tthis.border = border;
\tthis.wrap = (wrap != null) ? wrap : false;
\tthis.clipped = (clipped != null) ? clipped : false;
\tthis.overflow = (overflow != null) ? overflow : 'visible';
\tthis.labelPadding = (labelPadding != null) ? labelPadding : 0;
\tthis.textDirection = textDirection;
\tthis.rotation = 0;
\tthis.updateMargin();
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxText, mxShape);

/**
 * Variable: baseSpacingTop
 * 
 * Specifies the spacing to be added to the top spacing. Default is 0. Use the
 * value 5 here to get the same label positions as in mxGraph 1.x.
 */
mxText.prototype.baseSpacingTop = 0;

/**
 * Variable: baseSpacingBottom
 * 
 * Specifies the spacing to be added to the bottom spacing. Default is 0. Use the
 * value 1 here to get the same label positions as in mxGraph 1.x.
 */
mxText.prototype.baseSpacingBottom = 0;

/**
 * Variable: baseSpacingLeft
 * 
 * Specifies the spacing to be added to the left spacing. Default is 0.
 */
mxText.prototype.baseSpacingLeft = 0;

/**
 * Variable: baseSpacingRight
 * 
 * Specifies the spacing to be added to the right spacing. Default is 0.
 */
mxText.prototype.baseSpacingRight = 0;

/**
 * Variable: replaceLinefeeds
 * 
 * Specifies if linefeeds in HTML labels should be replaced with BR tags.
 * Default is true.
 */
mxText.prototype.replaceLinefeeds = true;

/**
 * Variable: verticalTextRotation
 * 
 * Rotation for vertical text. Default is -90 (bottom to top).
 */
mxText.prototype.verticalTextRotation = -90;

/**
 * Variable: ignoreClippedStringSize
 * 
 * Specifies if the string size should be measured in <updateBoundingBox> if
 * the label is clipped and the label position is center and middle. If this is
 * true, then the bounding box will be set to <bounds>. Default is true.
 * <ignoreStringSize> has precedence over this switch.
 */
mxText.prototype.ignoreClippedStringSize = true;

/**
 * Variable: ignoreStringSize
 * 
 * Specifies if the actual string size should be measured. If disabled the
 * boundingBox will not ignore the actual size of the string, otherwise
 * <bounds> will be used instead. Default is false.
 */
mxText.prototype.ignoreStringSize = false;

/**
 * Variable: textWidthPadding
 * 
 * Specifies the padding to be added to the text width for the bounding box.
 * This is needed to make sure no clipping is applied to borders. Default is 4
 * for IE 8 standards mode and 3 for all others.
 */
mxText.prototype.textWidthPadding = (document.documentMode == 8 && !mxClient.IS_EM) ? 4 : 3;

/**
 * Variable: lastValue
 * 
 * Contains the last rendered text value. Used for caching.
 */
mxText.prototype.lastValue = null;

/**
 * Variable: cacheEnabled
 * 
 * Specifies if caching for HTML labels should be enabled. Default is true.
 */
mxText.prototype.cacheEnabled = true;

/**
 * Function: isParseVml
 * 
 * Text shapes do not contain VML markup and do not need to be parsed. This
 * method returns false to speed up rendering in IE8.
 */
mxText.prototype.isParseVml = function()
{
\treturn false;
};

/**
 * Function: isHtmlAllowed
 * 
 * Returns true if HTML is allowed for this shape. This implementation returns
 * true if the browser is not in IE8 standards mode.
 */
mxText.prototype.isHtmlAllowed = function()
{
\treturn document.documentMode != 8 || mxClient.IS_EM;
};

/**
 * Function: getSvgScreenOffset
 * 
 * Disables offset in IE9 for crisper image output.
 */
mxText.prototype.getSvgScreenOffset = function()
{
\treturn 0;
};

/**
 * Function: checkBounds
 * 
 * Returns true if the bounds are not null and all of its variables are numeric.
 */
mxText.prototype.checkBounds = function()
{
\treturn (!isNaN(this.scale) && isFinite(this.scale) && this.scale > 0 &&
\t\t\tthis.bounds != null && !isNaN(this.bounds.x) && !isNaN(this.bounds.y) &&
\t\t\t!isNaN(this.bounds.width) && !isNaN(this.bounds.height));
};

/**
 * Function: paint
 * 
 * Generic rendering code.
 */
mxText.prototype.paint = function(c, update)
{
\t// Scale is passed-through to canvas
\tvar s = this.scale;
\tvar x = this.bounds.x / s;
\tvar y = this.bounds.y / s;
\tvar w = this.bounds.width / s;
\tvar h = this.bounds.height / s;
\t
\tthis.updateTransform(c, x, y, w, h);
\tthis.configureCanvas(c, x, y, w, h);
\t
\tif (update)
\t{
\t\tc.updateText(x, y, w, h, this.align, this.valign, this.wrap, this.overflow,
\t\t\t\tthis.clipped, this.getTextRotation(), this.node);
\t}
\telse
\t{
\t\t// Checks if text contains HTML markup
\t\tvar realHtml = mxUtils.isNode(this.value) || this.dialect == mxConstants.DIALECT_STRICTHTML;
\t\t
\t\t// Always renders labels as HTML in VML
\t\tvar fmt = (realHtml || c instanceof mxVmlCanvas2D) ? 'html' : '';
\t\tvar val = this.value;
\t\t
\t\tif (!realHtml && fmt == 'html')
\t\t{
\t\t\tval = mxUtils.htmlEntities(val, false);
\t\t}
\t\t
\t\tif (fmt == 'html' && !mxUtils.isNode(this.value))
\t\t{
\t\t\tval = mxUtils.replaceTrailingNewlines(val, '<div><br></div>');\t\t\t
\t\t}
\t\t
\t\t// Handles trailing newlines to make sure they are visible in rendering output
\t\tval = (!mxUtils.isNode(this.value) && this.replaceLinefeeds && fmt == 'html') ?
\t\t\tval.replace(/\\n/g, '<br/>') : val;
\t\t\t
\t\tvar dir = this.textDirection;
\t
\t\tif (dir == mxConstants.TEXT_DIRECTION_AUTO && !realHtml)
\t\t{
\t\t\tdir = this.getAutoDirection();
\t\t}
\t\t
\t\tif (dir != mxConstants.TEXT_DIRECTION_LTR && dir != mxConstants.TEXT_DIRECTION_RTL)
\t\t{
\t\t\tdir = null;
\t\t}
\t\t
\t\tc.text(x, y, w, h, val, this.align, this.valign, this.wrap, fmt,
\t\t\tthis.overflow, this.clipped, this.getTextRotation(), dir);
\t}
};

/**
 * Function: redraw
 * 
 * Renders the text using the given DOM nodes.
 */
mxText.prototype.redraw = function()
{
\tif (this.visible && this.checkBounds() && this.cacheEnabled && this.lastValue == this.value &&
\t\t(mxUtils.isNode(this.value) || this.dialect == mxConstants.DIALECT_STRICTHTML))
\t{
\t\tif (this.node.nodeName == 'DIV' && (this.isHtmlAllowed() || !mxClient.IS_VML))
\t\t{
\t\t\tif (mxClient.IS_SVG)
\t\t\t{
\t\t\t\tthis.redrawHtmlShapeWithCss3();\t
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.updateSize(this.node, (this.state == null || this.state.view.textDiv == null));
\t
\t\t\t\tif (mxClient.IS_IE && (document.documentMode == null || document.documentMode <= 8))
\t\t\t\t{
\t\t\t\t\tthis.updateHtmlFilter();
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tthis.updateHtmlTransform();
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tthis.updateBoundingBox();
\t\t}
\t\telse
\t\t{
\t\t\tvar canvas = this.createCanvas();

\t\t\tif (canvas != null && canvas.updateText != null)
\t\t\t{
\t\t\t\t// Specifies if events should be handled
\t\t\t\tcanvas.pointerEvents = this.pointerEvents;
\t
\t\t\t\tthis.paint(canvas, true);
\t\t\t\tthis.destroyCanvas(canvas);
\t\t\t\tthis.updateBoundingBox();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// Fallback if canvas does not support updateText (VML)
\t\t\t\tmxShape.prototype.redraw.apply(this, arguments);
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\tmxShape.prototype.redraw.apply(this, arguments);
\t\t
\t\tif (mxUtils.isNode(this.value) || this.dialect == mxConstants.DIALECT_STRICTHTML)
\t\t{
\t\t\tthis.lastValue = this.value;
\t\t}
\t\telse
\t\t{
\t\t\tthis.lastValue = null;
\t\t}
\t}
};

/**
 * Function: resetStyles
 * 
 * Resets all styles.
 */
mxText.prototype.resetStyles = function()
{
\tmxShape.prototype.resetStyles.apply(this, arguments);
\t
\tthis.color = 'black';
\tthis.align = mxConstants.ALIGN_CENTER;
\tthis.valign = mxConstants.ALIGN_MIDDLE;
\tthis.family = mxConstants.DEFAULT_FONTFAMILY;
\tthis.size = mxConstants.DEFAULT_FONTSIZE;
\tthis.fontStyle = mxConstants.DEFAULT_FONTSTYLE;
\tthis.spacing = 2;
\tthis.spacingTop = 2;
\tthis.spacingRight = 2;
\tthis.spacingBottom = 2;
\tthis.spacingLeft = 2;
\tthis.horizontal = true;
\tdelete this.background;
\tdelete this.border;
\tthis.textDirection = mxConstants.DEFAULT_TEXT_DIRECTION;
\tdelete this.margin;
};

/**
 * Function: apply
 * 
 * Extends mxShape to update the text styles.
 *
 * Parameters:
 *
 * state - <mxCellState> of the corresponding cell.
 */
mxText.prototype.apply = function(state)
{
\tvar old = this.spacing;
\tmxShape.prototype.apply.apply(this, arguments);
\t
\tif (this.style != null)
\t{
\t\tthis.fontStyle = mxUtils.getValue(this.style, mxConstants.STYLE_FONTSTYLE, this.fontStyle);
\t\tthis.family = mxUtils.getValue(this.style, mxConstants.STYLE_FONTFAMILY, this.family);
\t\tthis.size = mxUtils.getValue(this.style, mxConstants.STYLE_FONTSIZE, this.size);
\t\tthis.color = mxUtils.getValue(this.style, mxConstants.STYLE_FONTCOLOR, this.color);
\t\tthis.align = mxUtils.getValue(this.style, mxConstants.STYLE_ALIGN, this.align);
\t\tthis.valign = mxUtils.getValue(this.style, mxConstants.STYLE_VERTICAL_ALIGN, this.valign);
\t\tthis.spacing = parseInt(mxUtils.getValue(this.style, mxConstants.STYLE_SPACING, this.spacing));
\t\tthis.spacingTop = parseInt(mxUtils.getValue(this.style, mxConstants.STYLE_SPACING_TOP, this.spacingTop - old)) + this.spacing;
\t\tthis.spacingRight = parseInt(mxUtils.getValue(this.style, mxConstants.STYLE_SPACING_RIGHT, this.spacingRight - old)) + this.spacing;
\t\tthis.spacingBottom = parseInt(mxUtils.getValue(this.style, mxConstants.STYLE_SPACING_BOTTOM, this.spacingBottom - old)) + this.spacing;
\t\tthis.spacingLeft = parseInt(mxUtils.getValue(this.style, mxConstants.STYLE_SPACING_LEFT, this.spacingLeft - old)) + this.spacing;
\t\tthis.horizontal = mxUtils.getValue(this.style, mxConstants.STYLE_HORIZONTAL, this.horizontal);
\t\tthis.background = mxUtils.getValue(this.style, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR, this.background);
\t\tthis.border = mxUtils.getValue(this.style, mxConstants.STYLE_LABEL_BORDERCOLOR, this.border);
\t\tthis.textDirection = mxUtils.getValue(this.style, mxConstants.STYLE_TEXT_DIRECTION, mxConstants.DEFAULT_TEXT_DIRECTION);
\t\tthis.opacity = mxUtils.getValue(this.style, mxConstants.STYLE_TEXT_OPACITY, 100);
\t\tthis.updateMargin();
\t}
\t
\tthis.flipV = null;
\tthis.flipH = null;
};

/**
 * Function: getAutoDirection
 * 
 * Used to determine the automatic text direction. Returns
 * <mxConstants.TEXT_DIRECTION_LTR> or <mxConstants.TEXT_DIRECTION_RTL>
 * depending on the contents of <value>. This is not invoked for HTML, wrapped
 * content or if <value> is a DOM node.
 */
mxText.prototype.getAutoDirection = function()
{
\t// Looks for strong (directional) characters
\tvar tmp = /[A-Za-z\\u05d0-\\u065f\\u066a-\\u06ef\\u06fa-\\u07ff\\ufb1d-\\ufdff\\ufe70-\\ufefc]/.exec(this.value);
\t
\t// Returns the direction defined by the character
\treturn (tmp != null && tmp.length > 0 && tmp[0] > 'z') ?
\t\tmxConstants.TEXT_DIRECTION_RTL : mxConstants.TEXT_DIRECTION_LTR;
};

/**
 * Function: getContentNode
 * 
 * Returns the node that contains the rendered input.
 */
mxText.prototype.getContentNode = function()
{
\tvar result = this.node;
\t
\tif (result != null)
\t{
\t\t// Rendered with no foreignObject
\t\tif (result.ownerSVGElement == null)
\t\t{
\t\t\tresult = this.node.firstChild.firstChild;
\t\t}
\t\telse
\t\t{
\t\t\t// Innermost DIV that contains the actual content
\t\t\tresult = result.firstChild.firstChild.firstChild.firstChild.firstChild;
\t\t}
\t}
\t
\treturn result;
};

/**
 * Function: updateBoundingBox
 *
 * Updates the <boundingBox> for this shape using the given node and position.
 */
mxText.prototype.updateBoundingBox = function()
{
\tvar node = this.node;
\tthis.boundingBox = this.bounds.clone();
\tvar rot = this.getTextRotation();
\t
\tvar h = (this.style != null) ? mxUtils.getValue(this.style, mxConstants.STYLE_LABEL_POSITION, mxConstants.ALIGN_CENTER) : null;
\tvar v = (this.style != null) ? mxUtils.getValue(this.style, mxConstants.STYLE_VERTICAL_LABEL_POSITION, mxConstants.ALIGN_MIDDLE) : null;

\tif (!this.ignoreStringSize && node != null && this.overflow != 'fill' && (!this.clipped ||
\t\t!this.ignoreClippedStringSize || h != mxConstants.ALIGN_CENTER || v != mxConstants.ALIGN_MIDDLE))
\t{
\t\tvar ow = null;
\t\tvar oh = null;
\t\t
\t\tif (node.ownerSVGElement != null)
\t\t{
\t\t\tif (node.firstChild != null && node.firstChild.firstChild != null &&
\t\t\t\tnode.firstChild.firstChild.nodeName == 'foreignObject')
\t\t\t{
\t\t\t\t// Uses second inner DIV for font metrics
\t\t\t\tnode = node.firstChild.firstChild.firstChild.firstChild;
\t\t\t\toh = node.offsetHeight * this.scale;
\t\t\t\t
\t\t\t\tif (this.overflow == 'width')
\t\t\t\t{
\t\t\t\t\tow = this.boundingBox.width;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tow = node.offsetWidth * this.scale;\t
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\ttry
\t\t\t\t{
\t\t\t\t\tvar b = node.getBBox();
\t\t\t\t\t
\t\t\t\t\t// Workaround for bounding box of empty string
\t\t\t\t\tif (typeof(this.value) == 'string' && mxUtils.trim(this.value) == 0)
\t\t\t\t\t{
\t\t\t\t\t\tthis.boundingBox = null;
\t\t\t\t\t}
\t\t\t\t\telse if (b.width == 0 && b.height == 0)
\t\t\t\t\t{
\t\t\t\t\t\tthis.boundingBox = null;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tthis.boundingBox = new mxRectangle(b.x, b.y, b.width, b.height);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\treturn;
\t\t\t\t}
\t\t\t\tcatch (e)
\t\t\t\t{
\t\t\t\t\t// Ignores NS_ERROR_FAILURE in FF if container display is none.
\t\t\t\t}
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tvar td = (this.state != null) ? this.state.view.textDiv : null;

\t\t\t// Use cached offset size
\t\t\tif (this.offsetWidth != null && this.offsetHeight != null)
\t\t\t{
\t\t\t\tow = this.offsetWidth * this.scale;
\t\t\t\toh = this.offsetHeight * this.scale;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// Cannot get node size while container hidden so a
\t\t\t\t// shared temporary DIV is used for text measuring
\t\t\t\tif (td != null)
\t\t\t\t{
\t\t\t\t\tthis.updateFont(td);
\t\t\t\t\tthis.updateSize(td, false);
\t\t\t\t\tthis.updateInnerHtml(td);

\t\t\t\t\tnode = td;
\t\t\t\t}
\t\t\t\t
\t\t\t\tvar sizeDiv = node;

\t\t\t\tif (document.documentMode == 8 && !mxClient.IS_EM)
\t\t\t\t{
\t\t\t\t\tvar w = Math.round(this.bounds.width / this.scale);
\t
\t\t\t\t\tif (this.wrap && w > 0)
\t\t\t\t\t{
\t\t\t\t\t\tnode.style.wordWrap = mxConstants.WORD_WRAP;
\t\t\t\t\t\tnode.style.whiteSpace = 'normal';

\t\t\t\t\t\tif (node.style.wordWrap != 'break-word')
\t\t\t\t\t\t{
\t\t\t\t\t\t\t// Innermost DIV is used for measuring text
\t\t\t\t\t\t\tvar divs = sizeDiv.getElementsByTagName('div');
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tif (divs.length > 0)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tsizeDiv = divs[divs.length - 1];
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tow = sizeDiv.offsetWidth + 2;
\t\t\t\t\t\t\tdivs = this.node.getElementsByTagName('div');
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tif (this.clipped)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tow = Math.min(w, ow);
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t
\t\t\t\t\t\t\t// Second last DIV width must be updated in DOM tree
\t\t\t\t\t\t\tif (divs.length > 1)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tdivs[divs.length - 2].style.width = ow + 'px';
\t\t\t\t\t\t\t}
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tnode.style.whiteSpace = 'nowrap';
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse if (sizeDiv.firstChild != null && sizeDiv.firstChild.nodeName == 'DIV')
\t\t\t\t{
\t\t\t\t\tsizeDiv = sizeDiv.firstChild;
\t\t\t\t}

\t\t\t\tthis.offsetWidth = sizeDiv.offsetWidth + this.textWidthPadding;
\t\t\t\tthis.offsetHeight = sizeDiv.offsetHeight;
\t\t\t\t
\t\t\t\tow = this.offsetWidth * this.scale;
\t\t\t\toh = this.offsetHeight * this.scale;
\t\t\t}
\t\t}

\t\tif (ow != null && oh != null)
\t\t{\t
\t\t\tthis.boundingBox = new mxRectangle(this.bounds.x,
\t\t\t\tthis.bounds.y, ow, oh);
\t\t}
\t}

\tif (this.boundingBox != null)
\t{
\t\tif (rot != 0)
\t\t{
\t\t\t// Accounts for pre-rotated x and y
\t\t\tvar bbox = mxUtils.getBoundingBox(new mxRectangle(
\t\t\t\tthis.margin.x * this.boundingBox.width,
\t\t\t\tthis.margin.y * this.boundingBox.height,
\t\t\t\tthis.boundingBox.width, this.boundingBox.height),
\t\t\t\trot, new mxPoint(0, 0));
\t\t\t
\t\t\tthis.unrotatedBoundingBox = mxRectangle.fromRectangle(this.boundingBox);
\t\t\tthis.unrotatedBoundingBox.x += this.margin.x * this.unrotatedBoundingBox.width;
\t\t\tthis.unrotatedBoundingBox.y += this.margin.y * this.unrotatedBoundingBox.height;
\t\t\t
\t\t\tthis.boundingBox.x += bbox.x;
\t\t\tthis.boundingBox.y += bbox.y;
\t\t\tthis.boundingBox.width = bbox.width;
\t\t\tthis.boundingBox.height = bbox.height;
\t\t}
\t\telse
\t\t{
\t\t\tthis.boundingBox.x += this.margin.x * this.boundingBox.width;
\t\t\tthis.boundingBox.y += this.margin.y * this.boundingBox.height;
\t\t\tthis.unrotatedBoundingBox = null;
\t\t}
\t}
};

/**
 * Function: getShapeRotation
 * 
 * Returns 0 to avoid using rotation in the canvas via updateTransform.
 */
mxText.prototype.getShapeRotation = function()
{
\treturn 0;
};

/**
 * Function: getTextRotation
 * 
 * Returns the rotation for the text label of the corresponding shape.
 */
mxText.prototype.getTextRotation = function()
{
\treturn (this.state != null && this.state.shape != null) ? this.state.shape.getTextRotation() : 0;
};

/**
 * Function: isPaintBoundsInverted
 * 
 * Inverts the bounds if <mxShape.isBoundsInverted> returns true or if the
 * horizontal style is false.
 */
mxText.prototype.isPaintBoundsInverted = function()
{
\treturn !this.horizontal && this.state != null && this.state.view.graph.model.isVertex(this.state.cell);
};

/**
 * Function: configureCanvas
 * 
 * Sets the state of the canvas for drawing the shape.
 */
mxText.prototype.configureCanvas = function(c, x, y, w, h)
{
\tmxShape.prototype.configureCanvas.apply(this, arguments);
\t
\tc.setFontColor(this.color);
\tc.setFontBackgroundColor(this.background);
\tc.setFontBorderColor(this.border);
\tc.setFontFamily(this.family);
\tc.setFontSize(this.size);
\tc.setFontStyle(this.fontStyle);
};

/**
 * Function: updateVmlContainer
 * 
 * Sets the width and height of the container to 1px.
 */
mxText.prototype.updateVmlContainer = function()
{
\tthis.node.style.left = Math.round(this.bounds.x) + 'px';
\tthis.node.style.top = Math.round(this.bounds.y) + 'px';
\tthis.node.style.width = '1px';
\tthis.node.style.height = '1px';
\tthis.node.style.overflow = 'visible';
};

/**
 * Function: getHtmlValue
 * 
 * Private helper function to create SVG elements
 */
mxText.prototype.getHtmlValue = function()
{
\tvar val = this.value;
\t
\tif (this.dialect != mxConstants.DIALECT_STRICTHTML)
\t{
\t\tval = mxUtils.htmlEntities(val, false);
\t}
\t
\t// Handles trailing newlines to make sure they are visible in rendering output
\tval = mxUtils.replaceTrailingNewlines(val, '<div><br></div>');
\tval = (this.replaceLinefeeds) ? val.replace(/\\n/g, '<br/>') : val;
\t
\treturn val;
};

/**
 * Function: getTextCss
 * 
 * Private helper function to create SVG elements
 */
mxText.prototype.getTextCss = function()
{
\tvar lh = (mxConstants.ABSOLUTE_LINE_HEIGHT) ? (this.size * mxConstants.LINE_HEIGHT) + 'px' :
\t\tmxConstants.LINE_HEIGHT;

\tvar css = 'display: inline-block; font-size: ' + this.size + 'px; ' +
\t\t'font-family: ' + this.family + '; color: ' + this.color + '; line-height: ' + lh +
\t\t'; pointer-events: ' + ((this.pointerEvents) ? 'all' : 'none') + '; ';

\tif ((this.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t{
\t\tcss += 'font-weight: bold; ';
\t}

\tif ((this.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t{
\t\tcss += 'font-style: italic; ';
\t}
\t
\tvar deco = [];
\t
\tif ((this.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t{
\t\tdeco.push('underline');
\t}
\t
\tif ((this.fontStyle & mxConstants.FONT_STRIKETHROUGH) == mxConstants.FONT_STRIKETHROUGH)
\t{
\t\tdeco.push('line-through');
\t}
\t
\tif (deco.length > 0)
\t{
\t\tcss += 'text-decoration: ' + deco.join(' ') + '; ';
\t}

\treturn css;
};

/**
 * Function: redrawHtmlShape
 *
 * Updates the HTML node(s) to reflect the latest bounds and scale.
 */
mxText.prototype.redrawHtmlShape = function()
{
\tif (mxClient.IS_SVG)
\t{
\t\tthis.redrawHtmlShapeWithCss3();\t
\t}
\telse
\t{
\t\tvar style = this.node.style;
\t
\t\t// Resets CSS styles
\t\tstyle.whiteSpace = 'normal';
\t\tstyle.overflow = '';
\t\tstyle.width = '';
\t\tstyle.height = '';
\t\t
\t\tthis.updateValue();
\t\tthis.updateFont(this.node);
\t\tthis.updateSize(this.node, (this.state == null || this.state.view.textDiv == null));
\t\t
\t\tthis.offsetWidth = null;
\t\tthis.offsetHeight = null;
\t
\t\tif (mxClient.IS_IE && (document.documentMode == null || document.documentMode <= 8))
\t\t{
\t\t\tthis.updateHtmlFilter();
\t\t}
\t\telse
\t\t{
\t\t\tthis.updateHtmlTransform();
\t\t}
\t}
};

/**
 * Function: redrawHtmlShapeWithCss3
 *
 * Updates the HTML node(s) to reflect the latest bounds and scale.
 */
mxText.prototype.redrawHtmlShapeWithCss3 = function()
{
\tvar w = Math.max(0, Math.round(this.bounds.width / this.scale));
\tvar h = Math.max(0, Math.round(this.bounds.height / this.scale));
\tvar flex = 'position: absolute; left: ' + Math.round(this.bounds.x) + 'px; ' +
\t\t'top: ' + Math.round(this.bounds.y) + 'px; pointer-events: none; ';
\tvar block = this.getTextCss();
\t
\tmxSvgCanvas2D.createCss(w + 2, h, this.align, this.valign, this.wrap, this.overflow, this.clipped,
\t\t(this.background != null) ? mxUtils.htmlEntities(this.background) : null,
\t\t(this.border != null) ? mxUtils.htmlEntities(this.border) : null,
\t\tflex, block, this.scale, mxUtils.bind(this, function(dx, dy, flex, item, block, ofl)
\t{
\t\tvar r = this.getTextRotation();
\t\tvar tr = ((this.scale != 1) ? 'scale(' + this.scale + ') ' : '') +
\t\t\t((r != 0) ? 'rotate(' + r + 'deg) ' : '') +
\t\t\t((this.margin.x != 0 || this.margin.y != 0) ?
\t\t\t\t'translate(' + (this.margin.x * 100) + '%,' +
\t\t\t\t\t(this.margin.y * 100) + '%)' : '');
\t\t
\t\tif (tr != '')
\t\t{
\t\t\ttr = 'transform-origin: 0 0; transform: ' + tr + '; ';
\t\t}

\t\tif (ofl == '')
\t\t{
\t\t\tflex += item;
\t\t\titem = 'display:inline-block; min-width: 100%; ' + tr;
\t\t}
\t\telse
\t\t{
\t\t\titem += tr;
\t\t\t
\t\t\tif (mxClient.IS_SF)
\t\t\t{
\t\t\t\titem += '-webkit-clip-path: content-box;';
\t\t\t}
\t\t}

\t\tif (this.opacity < 100)
\t\t{
\t\t\tblock += 'opacity: ' + (this.opacity / 100) + '; ';
\t\t}
\t\t
\t\tthis.node.setAttribute('style', flex);
\t\t
\t\tvar html = (mxUtils.isNode(this.value)) ? this.value.outerHTML : this.getHtmlValue();
\t\t
\t\tif (this.node.firstChild == null)
\t\t{
\t\t\tthis.node.innerHTML = '<div><div>' + html +'</div></div>';
\t\t}

\t\tthis.node.firstChild.firstChild.setAttribute('style', block);
\t\tthis.node.firstChild.setAttribute('style', item);
\t}));
};

/**
 * Function: updateHtmlTransform
 *
 * Returns the spacing as an <mxPoint>.
 */
mxText.prototype.updateHtmlTransform = function()
{
\tvar theta = this.getTextRotation();
\tvar style = this.node.style;
\tvar dx = this.margin.x;
\tvar dy = this.margin.y;
\t
\tif (theta != 0)
\t{
\t\tmxUtils.setPrefixedStyle(style, 'transformOrigin', (-dx * 100) + '%' + ' ' + (-dy * 100) + '%');
\t\tmxUtils.setPrefixedStyle(style, 'transform', 'translate(' + (dx * 100) + '%' + ',' + (dy * 100) + '%) ' +
\t\t\t'scale(' + this.scale + ') rotate(' + theta + 'deg)');
\t}
\telse
\t{
\t\tmxUtils.setPrefixedStyle(style, 'transformOrigin', '0% 0%');
\t\tmxUtils.setPrefixedStyle(style, 'transform', 'scale(' + this.scale + ') ' +
\t\t\t'translate(' + (dx * 100) + '%' + ',' + (dy * 100) + '%)');
\t}

\tstyle.left = Math.round(this.bounds.x - Math.ceil(dx * ((this.overflow != 'fill' &&
\t\tthis.overflow != 'width') ? 3 : 1))) + 'px';
\tstyle.top = Math.round(this.bounds.y - dy * ((this.overflow != 'fill') ? 3 : 1)) + 'px';
\t
\tif (this.opacity < 100)
\t{
\t\tstyle.opacity = this.opacity / 100;
\t}
\telse
\t{
\t\tstyle.opacity = '';
\t}
};

/**
 * Function: updateInnerHtml
 * 
 * Sets the inner HTML of the given element to the <value>.
 */
mxText.prototype.updateInnerHtml = function(elt)
{
\tif (mxUtils.isNode(this.value))
\t{
\t\telt.innerHTML = this.value.outerHTML;
\t}
\telse
\t{
\t\tvar val = this.value;
\t\t
\t\tif (this.dialect != mxConstants.DIALECT_STRICTHTML)
\t\t{
\t\t\t// LATER: Can be cached in updateValue
\t\t\tval = mxUtils.htmlEntities(val, false);
\t\t}
\t\t
\t\t// Handles trailing newlines to make sure they are visible in rendering output
\t\tval = mxUtils.replaceTrailingNewlines(val, '<div>&nbsp;</div>');
\t\tval = (this.replaceLinefeeds) ? val.replace(/\\n/g, '<br/>') : val;
\t\tval = '<div style=\"display:inline-block;_display:inline;\">' + val + '</div>';
\t\t
\t\telt.innerHTML = val;
\t}
};

/**
 * Function: updateHtmlFilter
 *
 * Rotated text rendering quality is bad for IE9 quirks/IE8 standards
 */
mxText.prototype.updateHtmlFilter = function()
{
\tvar style = this.node.style;
\tvar dx = this.margin.x;
\tvar dy = this.margin.y;
\tvar s = this.scale;
\t
\t// Resets filter before getting offsetWidth
\tmxUtils.setOpacity(this.node, this.opacity);
\t
\t// Adds 1 to match table height in 1.x
\tvar ow = 0;
\tvar oh = 0;
\tvar td = (this.state != null) ? this.state.view.textDiv : null;
\tvar sizeDiv = this.node;
\t
\t// Fallback for hidden text rendering in IE quirks mode
\tif (td != null)
\t{
\t\ttd.style.overflow = '';
\t\ttd.style.height = '';
\t\ttd.style.width = '';
\t\t
\t\tthis.updateFont(td);
\t\tthis.updateSize(td, false);
\t\tthis.updateInnerHtml(td);
\t\t
\t\tvar w = Math.round(this.bounds.width / this.scale);

\t\tif (this.wrap && w > 0)
\t\t{
\t\t\ttd.style.whiteSpace = 'normal';
\t\t\ttd.style.wordWrap = mxConstants.WORD_WRAP;
\t\t\tow = w;
\t\t\t
\t\t\tif (this.clipped)
\t\t\t{
\t\t\t\tow = Math.min(ow, this.bounds.width);
\t\t\t}

\t\t\ttd.style.width = ow + 'px';
\t\t}
\t\telse
\t\t{
\t\t\ttd.style.whiteSpace = 'nowrap';
\t\t}
\t\t
\t\tsizeDiv = td;
\t\t
\t\tif (sizeDiv.firstChild != null && sizeDiv.firstChild.nodeName == 'DIV')
\t\t{
\t\t\tsizeDiv = sizeDiv.firstChild;
\t\t\t
\t\t\tif (this.wrap && td.style.wordWrap == 'break-word')
\t\t\t{
\t\t\t\tsizeDiv.style.width = '100%';
\t\t\t}
\t\t}

\t\t// Required to update the height of the text box after wrapping width is known 
\t\tif (!this.clipped && this.wrap && w > 0)
\t\t{
\t\t\tow = sizeDiv.offsetWidth + this.textWidthPadding;
\t\t\ttd.style.width = ow + 'px';
\t\t}
\t\t
\t\toh = sizeDiv.offsetHeight + 2;
\t\t
\t\tif (mxClient.IS_QUIRKS && this.border != null && this.border != mxConstants.NONE)
\t\t{
\t\t\toh += 3;
\t\t}
\t}
\telse if (sizeDiv.firstChild != null && sizeDiv.firstChild.nodeName == 'DIV')
\t{
\t\tsizeDiv = sizeDiv.firstChild;
\t\toh = sizeDiv.offsetHeight;
\t}

\tow = sizeDiv.offsetWidth + this.textWidthPadding;
\t
\tif (this.clipped)
\t{
\t\toh = Math.min(oh, this.bounds.height);
\t}

\tvar w = this.bounds.width / s;
\tvar h = this.bounds.height / s;

\t// Handles special case for live preview with no wrapper DIV and no textDiv
\tif (this.overflow == 'fill')
\t{
\t\toh = h;
\t\tow = w;
\t}
\telse if (this.overflow == 'width')
\t{
\t\toh = sizeDiv.scrollHeight;
\t\tow = w;
\t}
\t
\t// Stores for later use
\tthis.offsetWidth = ow;
\tthis.offsetHeight = oh;
\t
\t// Simulates max-height CSS in quirks mode
\tif (mxClient.IS_QUIRKS && (this.clipped || (this.overflow == 'width' && h > 0)))
\t{
\t\th = Math.min(h, oh);
\t\tstyle.height = Math.round(h) + 'px';
\t}
\telse
\t{
\t\th = oh;
\t}

\tif (this.overflow != 'fill' && this.overflow != 'width')
\t{
\t\tif (this.clipped)
\t\t{
\t\t\tow = Math.min(w, ow);
\t\t}
\t\t
\t\tw = ow;

\t\t// Simulates max-width CSS in quirks mode
\t\tif ((mxClient.IS_QUIRKS && this.clipped) || this.wrap)
\t\t{
\t\t\tstyle.width = Math.round(w) + 'px';
\t\t}
\t}

\th *= s;
\tw *= s;
\t
\t// Rotation case is handled via VML canvas
\tvar rad = this.getTextRotation() * (Math.PI / 180);
\t
\t// Precalculate cos and sin for the rotation
\tvar real_cos = parseFloat(parseFloat(Math.cos(rad)).toFixed(8));
\tvar real_sin = parseFloat(parseFloat(Math.sin(-rad)).toFixed(8));

\trad %= 2 * Math.PI;
\t
\tif (rad < 0)
\t{
\t\trad += 2 * Math.PI;
\t}
\t
\trad %= Math.PI;
\t
\tif (rad > Math.PI / 2)
\t{
\t\trad = Math.PI - rad;
\t}
\t
\tvar cos = Math.cos(rad);
\tvar sin = Math.sin(-rad);

\tvar tx = w * -(dx + 0.5);
\tvar ty = h * -(dy + 0.5);

\tvar top_fix = (h - h * cos + w * sin) / 2 + real_sin * tx - real_cos * ty;
\tvar left_fix = (w - w * cos + h * sin) / 2 - real_cos * tx - real_sin * ty;
\t
\tif (rad != 0)
\t{
\t\tvar f = 'progid:DXImageTransform.Microsoft.Matrix(M11=' + real_cos + ', M12='+
\t\t\treal_sin + ', M21=' + (-real_sin) + ', M22=' + real_cos + ', sizingMethod=\\'auto expand\\')';
\t\t
\t\tif (style.filter != null && style.filter.length > 0)
\t\t{
\t\t\tstyle.filter += ' ' + f;
\t\t}
\t\telse
\t\t{
\t\t\tstyle.filter = f;
\t\t}
\t}
\t
\t// Workaround for rendering offsets
\tvar dy = 0;
\t
\tif (this.overflow != 'fill' && mxClient.IS_QUIRKS)
\t{
\t\tif (this.valign == mxConstants.ALIGN_TOP)
\t\t{
\t\t\tdy -= 1;
\t\t}
\t\telse if (this.valign == mxConstants.ALIGN_BOTTOM)
\t\t{
\t\t\tdy += 2;
\t\t}
\t\telse
\t\t{
\t\t\tdy += 1;
\t\t}
\t}

\tstyle.zoom = s;
\tstyle.left = Math.round(this.bounds.x + left_fix - w / 2) + 'px';
\tstyle.top = Math.round(this.bounds.y + top_fix - h / 2 + dy) + 'px';
};

/**
 * Function: updateValue
 *
 * Updates the HTML node(s) to reflect the latest bounds and scale.
 */
mxText.prototype.updateValue = function()
{
\tif (mxUtils.isNode(this.value))
\t{
\t\tthis.node.innerHTML = '';
\t\tthis.node.appendChild(this.value);
\t}
\telse
\t{
\t\tvar val = this.value;
\t\t
\t\tif (this.dialect != mxConstants.DIALECT_STRICTHTML)
\t\t{
\t\t\tval = mxUtils.htmlEntities(val, false);
\t\t}
\t\t
\t\t// Handles trailing newlines to make sure they are visible in rendering output
\t\tval = mxUtils.replaceTrailingNewlines(val, '<div><br></div>');
\t\tval = (this.replaceLinefeeds) ? val.replace(/\\n/g, '<br/>') : val;
\t\tvar bg = (this.background != null && this.background != mxConstants.NONE) ? this.background : null;
\t\tvar bd = (this.border != null && this.border != mxConstants.NONE) ? this.border : null;

\t\tif (this.overflow == 'fill' || this.overflow == 'width')
\t\t{
\t\t\tif (bg != null)
\t\t\t{
\t\t\t\tthis.node.style.backgroundColor = bg;
\t\t\t}
\t\t\t
\t\t\tif (bd != null)
\t\t\t{
\t\t\t\tthis.node.style.border = '1px solid ' + bd;
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tvar css = '';
\t\t\t
\t\t\tif (bg != null)
\t\t\t{
\t\t\t\tcss += 'background-color:' + mxUtils.htmlEntities(bg) + ';';
\t\t\t}
\t\t\t
\t\t\tif (bd != null)
\t\t\t{
\t\t\t\tcss += 'border:1px solid ' + mxUtils.htmlEntities(bd) + ';';
\t\t\t}
\t\t\t
\t\t\t// Wrapper DIV for background, zoom needed for inline in quirks
\t\t\t// and to measure wrapped font sizes in all browsers
\t\t\t// FIXME: Background size in quirks mode for wrapped text
\t\t\tvar lh = (mxConstants.ABSOLUTE_LINE_HEIGHT) ? (this.size * mxConstants.LINE_HEIGHT) + 'px' :
\t\t\t\tmxConstants.LINE_HEIGHT;
\t\t\tval = '<div style=\"zoom:1;' + css + 'display:inline-block;_display:inline;text-decoration:inherit;' +
\t\t\t\t'padding-bottom:1px;padding-right:1px;line-height:' + lh + '\">' + val + '</div>';
\t\t}

\t\tthis.node.innerHTML = val;
\t\t
\t\t// Sets text direction
\t\tvar divs = this.node.getElementsByTagName('div');
\t\t
\t\tif (divs.length > 0)
\t\t{
\t\t\tvar dir = this.textDirection;

\t\t\tif (dir == mxConstants.TEXT_DIRECTION_AUTO && this.dialect != mxConstants.DIALECT_STRICTHTML)
\t\t\t{
\t\t\t\tdir = this.getAutoDirection();
\t\t\t}
\t\t\t
\t\t\tif (dir == mxConstants.TEXT_DIRECTION_LTR || dir == mxConstants.TEXT_DIRECTION_RTL)
\t\t\t{
\t\t\t\tdivs[divs.length - 1].setAttribute('dir', dir);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tdivs[divs.length - 1].removeAttribute('dir');
\t\t\t}
\t\t}
\t}
};

/**
 * Function: updateFont
 *
 * Updates the HTML node(s) to reflect the latest bounds and scale.
 */
mxText.prototype.updateFont = function(node)
{
\tvar style = node.style;
\t
\tstyle.lineHeight = (mxConstants.ABSOLUTE_LINE_HEIGHT) ? (this.size * mxConstants.LINE_HEIGHT) + 'px' : mxConstants.LINE_HEIGHT;
\tstyle.fontSize = this.size + 'px';
\tstyle.fontFamily = this.family;
\tstyle.verticalAlign = 'top';
\tstyle.color = this.color;
\t
\tif ((this.fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD)
\t{
\t\tstyle.fontWeight = 'bold';
\t}
\telse
\t{
\t\tstyle.fontWeight = '';
\t}

\tif ((this.fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
\t{
\t\tstyle.fontStyle = 'italic';
\t}
\telse
\t{
\t\tstyle.fontStyle = '';
\t}
\t
\tvar txtDecor = [];
\t
\tif ((this.fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
\t{
\t\ttxtDecor.push('underline');
\t}
\t
\tif ((this.fontStyle & mxConstants.FONT_STRIKETHROUGH) == mxConstants.FONT_STRIKETHROUGH)
\t{
\t\ttxtDecor.push('line-through');
\t}
\t
\tstyle.textDecoration = txtDecor.join(' ');
\t
\tif (this.align == mxConstants.ALIGN_CENTER)
\t{
\t\tstyle.textAlign = 'center';
\t}
\telse if (this.align == mxConstants.ALIGN_RIGHT)
\t{
\t\tstyle.textAlign = 'right';
\t}
\telse
\t{
\t\tstyle.textAlign = 'left';
\t}
};

/**
 * Function: updateSize
 *
 * Updates the HTML node(s) to reflect the latest bounds and scale.
 */
mxText.prototype.updateSize = function(node, enableWrap)
{
\tvar w = Math.max(0, Math.round(this.bounds.width / this.scale));
\tvar h = Math.max(0, Math.round(this.bounds.height / this.scale));
\tvar style = node.style;
\t
\t// NOTE: Do not use maxWidth here because wrapping will
\t// go wrong if the cell is outside of the viewable area
\tif (this.clipped)
\t{
\t\tstyle.overflow = 'hidden';
\t\t
\t\tif (!mxClient.IS_QUIRKS)
\t\t{
\t\t\tstyle.maxHeight = h + 'px';
\t\t\tstyle.maxWidth = w + 'px';
\t\t}
\t\telse
\t\t{
\t\t\tstyle.width = w + 'px';
\t\t}
\t}
\telse if (this.overflow == 'fill')
\t{
\t\tstyle.width = (w + 1) + 'px';
\t\tstyle.height = (h + 1) + 'px';
\t\tstyle.overflow = 'hidden';
\t}
\telse if (this.overflow == 'width')
\t{
\t\tstyle.width = (w + 1) + 'px';
\t\tstyle.maxHeight = (h + 1) + 'px';
\t\tstyle.overflow = 'hidden';
\t}
\t
\tif (this.wrap && w > 0)
\t{
\t\tstyle.wordWrap = mxConstants.WORD_WRAP;
\t\tstyle.whiteSpace = 'normal';
\t\tstyle.width = w + 'px';

\t\tif (enableWrap && this.overflow != 'fill' && this.overflow != 'width')
\t\t{
\t\t\tvar sizeDiv = node;
\t\t\t
\t\t\tif (sizeDiv.firstChild != null && sizeDiv.firstChild.nodeName == 'DIV')
\t\t\t{
\t\t\t\tsizeDiv = sizeDiv.firstChild;
\t\t\t\t
\t\t\t\tif (node.style.wordWrap == 'break-word')
\t\t\t\t{
\t\t\t\t\tsizeDiv.style.width = '100%';
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tvar tmp = sizeDiv.offsetWidth;
\t\t\t
\t\t\t// Workaround for text measuring in hidden containers
\t\t\tif (tmp == 0)
\t\t\t{
\t\t\t\tvar prev = node.parentNode;
\t\t\t\tnode.style.visibility = 'hidden';
\t\t\t\tdocument.body.appendChild(node);
\t\t\t\ttmp = sizeDiv.offsetWidth;
\t\t\t\tnode.style.visibility = '';
\t\t\t\tprev.appendChild(node);
\t\t\t}

\t\t\ttmp += 3;
\t\t\t
\t\t\tif (this.clipped)
\t\t\t{
\t\t\t\ttmp = Math.min(tmp, w);
\t\t\t}
\t\t\t
\t\t\tstyle.width = tmp + 'px';
\t\t}
\t}
\telse
\t{
\t\tstyle.whiteSpace = 'nowrap';
\t}
};

/**
 * Function: getMargin
 *
 * Returns the spacing as an <mxPoint>.
 */
mxText.prototype.updateMargin = function()
{
\tthis.margin = mxUtils.getAlignmentAsPoint(this.align, this.valign);
};

/**
 * Function: getSpacing
 *
 * Returns the spacing as an <mxPoint>.
 */
mxText.prototype.getSpacing = function()
{
\tvar dx = 0;
\tvar dy = 0;

\tif (this.align == mxConstants.ALIGN_CENTER)
\t{
\t\tdx = (this.spacingLeft - this.spacingRight) / 2;
\t}
\telse if (this.align == mxConstants.ALIGN_RIGHT)
\t{
\t\tdx = -this.spacingRight - this.baseSpacingRight;
\t}
\telse
\t{
\t\tdx = this.spacingLeft + this.baseSpacingLeft;
\t}

\tif (this.valign == mxConstants.ALIGN_MIDDLE)
\t{
\t\tdy = (this.spacingTop - this.spacingBottom) / 2;
\t}
\telse if (this.valign == mxConstants.ALIGN_BOTTOM)
\t{
\t\tdy = -this.spacingBottom - this.baseSpacingBottom;;
\t}
\telse
\t{
\t\tdy = this.spacingTop + this.baseSpacingTop;
\t}
\t
\treturn new mxPoint(dx, dy);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxTriangle
 * 
 * Implementation of the triangle shape.
 * 
 * Constructor: mxTriangle
 *
 * Constructs a new triangle shape.
 */
function mxTriangle()
{
\tmxActor.call(this);
};

/**
 * Extends mxActor.
 */
mxUtils.extend(mxTriangle, mxActor);

/**
 * Function: isRoundable
 * 
 * Adds roundable support.
 */
mxTriangle.prototype.isRoundable = function()
{
\treturn true;
};

/**
 * Function: redrawPath
 *
 * Draws the path for this shape.
 */
mxTriangle.prototype.redrawPath = function(c, x, y, w, h)
{
\tvar arcSize = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2;
\tthis.addPoints(c, [new mxPoint(0, 0), new mxPoint(w, 0.5 * h), new mxPoint(0, h)], this.isRounded, arcSize, true);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxHexagon
 * 
 * Implementation of the hexagon shape.
 * 
 * Constructor: mxHexagon
 *
 * Constructs a new hexagon shape.
 */
function mxHexagon()
{
\tmxActor.call(this);
};

/**
 * Extends mxActor.
 */
mxUtils.extend(mxHexagon, mxActor);

/**
 * Function: redrawPath
 *
 * Draws the path for this shape.
 */
mxHexagon.prototype.redrawPath = function(c, x, y, w, h)
{
\tvar arcSize = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2;
\tthis.addPoints(c, [new mxPoint(0.25 * w, 0), new mxPoint(0.75 * w, 0), new mxPoint(w, 0.5 * h), new mxPoint(0.75 * w, h),
\t                   new mxPoint(0.25 * w, h), new mxPoint(0, 0.5 * h)], this.isRounded, arcSize, true);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxLine
 *
 * Extends <mxShape> to implement a horizontal line shape.
 * This shape is registered under <mxConstants.SHAPE_LINE> in
 * <mxCellRenderer>.
 * 
 * Constructor: mxLine
 *
 * Constructs a new line shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * stroke - String that defines the stroke color. Default is 'black'. This is
 * stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxLine(bounds, stroke, strokewidth, vertical)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
\tthis.vertical = (vertical != null) ? vertical : this.vertical;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxLine, mxShape);

/**
 * Function: vertical
 * 
 * Whether to paint a vertical line.
 */
mxLine.prototype.vertical = false;

/**
 * Function: paintVertexShape
 * 
 * Redirects to redrawPath for subclasses to work.
 */
mxLine.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tc.begin();

\tif (this.vertical)
\t{
\t\tvar mid = x + w / 2;
\t\tc.moveTo(mid, y);
\t\tc.lineTo(mid, y + h);
\t}
\telse
\t{
\t\tvar mid = y + h / 2;
\t\tc.moveTo(x, mid);
\t\tc.lineTo(x + w, mid);
\t}

\tc.stroke();
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxImageShape
 *
 * Extends <mxShape> to implement an image shape. This shape is registered
 * under <mxConstants.SHAPE_IMAGE> in <mxCellRenderer>.
 * 
 * Constructor: mxImageShape
 * 
 * Constructs a new image shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * image - String that specifies the URL of the image. This is stored in
 * <image>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 0. This is stored in <strokewidth>.
 */
function mxImageShape(bounds, image, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.image = image;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
\tthis.shadow = false;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxImageShape, mxRectangleShape);

/**
 * Variable: preserveImageAspect
 *
 * Switch to preserve image aspect. Default is true.
 */
mxImageShape.prototype.preserveImageAspect = true;

/**
 * Function: getSvgScreenOffset
 * 
 * Disables offset in IE9 for crisper image output.
 */
mxImageShape.prototype.getSvgScreenOffset = function()
{
\treturn 0;
};

/**
 * Function: apply
 * 
 * Overrides <mxShape.apply> to replace the fill and stroke colors with the
 * respective values from <mxConstants.STYLE_IMAGE_BACKGROUND> and
 * <mxConstants.STYLE_IMAGE_BORDER>.
 * 
 * Applies the style of the given <mxCellState> to the shape. This
 * implementation assigns the following styles to local fields:
 * 
 * - <mxConstants.STYLE_IMAGE_BACKGROUND> => fill
 * - <mxConstants.STYLE_IMAGE_BORDER> => stroke
 *
 * Parameters:
 *
 * state - <mxCellState> of the corresponding cell.
 */
mxImageShape.prototype.apply = function(state)
{
\tmxShape.prototype.apply.apply(this, arguments);
\t
\tthis.fill = null;
\tthis.stroke = null;
\tthis.gradient = null;
\t
\tif (this.style != null)
\t{
\t\tthis.preserveImageAspect = mxUtils.getNumber(this.style, mxConstants.STYLE_IMAGE_ASPECT, 1) == 1;
\t\t
\t\t// Legacy support for imageFlipH/V
\t\tthis.flipH = this.flipH || mxUtils.getValue(this.style, 'imageFlipH', 0) == 1;
\t\tthis.flipV = this.flipV || mxUtils.getValue(this.style, 'imageFlipV', 0) == 1;
\t}
};

/**
 * Function: isHtmlAllowed
 * 
 * Returns true if HTML is allowed for this shape. This implementation always
 * returns false.
 */
mxImageShape.prototype.isHtmlAllowed = function()
{
\treturn !this.preserveImageAspect;
};

/**
 * Function: createHtml
 *
 * Creates and returns the HTML DOM node(s) to represent
 * this shape. This implementation falls back to <createVml>
 * so that the HTML creation is optional.
 */
mxImageShape.prototype.createHtml = function()
{
\tvar node = document.createElement('div');
\tnode.style.position = 'absolute';

\treturn node;
};

/**
 * Function: isRoundable
 * 
 * Disables inherited roundable support.
 */
mxImageShape.prototype.isRoundable = function(c, x, y, w, h)
{
\treturn false;
};

/**
 * Function: paintVertexShape
 * 
 * Generic background painting implementation.
 */
mxImageShape.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tif (this.image != null)
\t{
\t\tvar fill = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_BACKGROUND, null);
\t\tvar stroke = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_BORDER, null);
\t\t
\t\tif (fill != null)
\t\t{
\t\t\t// Stroke rendering required for shadow
\t\t\tc.setFillColor(fill);
\t\t\tc.setStrokeColor(stroke);
\t\t\tc.rect(x, y, w, h);
\t\t\tc.fillAndStroke();
\t\t}

\t\t// FlipH/V are implicit via mxShape.updateTransform
\t\tc.image(x, y, w, h, this.image, this.preserveImageAspect, false, false);
\t\t
\t\tvar stroke = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_BORDER, null);
\t\t
\t\tif (stroke != null)
\t\t{
\t\t\tc.setShadow(false);
\t\t\tc.setStrokeColor(stroke);
\t\t\tc.rect(x, y, w, h);
\t\t\tc.stroke();
\t\t}
\t}
\telse
\t{
\t\tmxRectangleShape.prototype.paintBackground.apply(this, arguments);
\t}
};

/**
 * Function: redraw
 * 
 * Overrides <mxShape.redraw> to preserve the aspect ratio of images.
 */
mxImageShape.prototype.redrawHtmlShape = function()
{
\tthis.node.style.left = Math.round(this.bounds.x) + 'px';
\tthis.node.style.top = Math.round(this.bounds.y) + 'px';
\tthis.node.style.width = Math.max(0, Math.round(this.bounds.width)) + 'px';
\tthis.node.style.height = Math.max(0, Math.round(this.bounds.height)) + 'px';
\tthis.node.innerHTML = '';

\tif (this.image != null)
\t{
\t\tvar fill = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_BACKGROUND, '');
\t\tvar stroke = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_BORDER, '');
\t\tthis.node.style.backgroundColor = fill;
\t\tthis.node.style.borderColor = stroke;
\t\t
\t\t// VML image supports PNG in IE6
\t\tvar useVml = mxClient.IS_IE6 || ((document.documentMode == null || document.documentMode <= 8) && this.rotation != 0);
\t\tvar img = document.createElement((useVml) ? mxClient.VML_PREFIX + ':image' : 'img');
\t\timg.setAttribute('border', '0');
\t\timg.style.position = 'absolute';
\t\timg.src = this.image;

\t\tvar filter = (this.opacity < 100) ? 'alpha(opacity=' + this.opacity + ')' : '';
\t\tthis.node.style.filter = filter;
\t\t
\t\tif (this.flipH && this.flipV)
\t\t{
\t\t\tfilter += 'progid:DXImageTransform.Microsoft.BasicImage(rotation=2)';
\t\t}
\t\telse if (this.flipH)
\t\t{
\t\t\tfilter += 'progid:DXImageTransform.Microsoft.BasicImage(mirror=1)';
\t\t}
\t\telse if (this.flipV)
\t\t{
\t\t\tfilter += 'progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)';
\t\t}

\t\tif (img.style.filter != filter)
\t\t{
\t\t\timg.style.filter = filter;
\t\t}

\t\tif (img.nodeName == 'image')
\t\t{
\t\t\timg.style.rotation = this.rotation;
\t\t}
\t\telse if (this.rotation != 0)
\t\t{
\t\t\t// LATER: Add flipV/H support
\t\t\tmxUtils.setPrefixedStyle(img.style, 'transform', 'rotate(' + this.rotation + 'deg)');
\t\t}
\t\telse
\t\t{
\t\t\tmxUtils.setPrefixedStyle(img.style, 'transform', '');
\t\t}

\t\t// Known problem: IE clips top line of image for certain angles
\t\timg.style.width = this.node.style.width;
\t\timg.style.height = this.node.style.height;
\t\t
\t\tthis.node.style.backgroundImage = '';
\t\tthis.node.appendChild(img);
\t}
\telse
\t{
\t\tthis.setTransparentBackgroundImage(this.node);
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxLabel
 *
 * Extends <mxShape> to implement an image shape with a label.
 * This shape is registered under <mxConstants.SHAPE_LABEL> in
 * <mxCellRenderer>.
 * 
 * Constructor: mxLabel
 *
 * Constructs a new label shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxLabel(bounds, fill, stroke, strokewidth)
{
\tmxRectangleShape.call(this, bounds, fill, stroke, strokewidth);
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxLabel, mxRectangleShape);

/**
 * Variable: imageSize
 *
 * Default width and height for the image. Default is
 * <mxConstants.DEFAULT_IMAGESIZE>.
 */
mxLabel.prototype.imageSize = mxConstants.DEFAULT_IMAGESIZE;

/**
 * Variable: spacing
 *
 * Default value for image spacing. Default is 2.
 */
mxLabel.prototype.spacing = 2;

/**
 * Variable: indicatorSize
 *
 * Default width and height for the indicicator. Default is 10.
 */
mxLabel.prototype.indicatorSize = 10;

/**
 * Variable: indicatorSpacing
 *
 * Default spacing between image and indicator. Default is 2.
 */
mxLabel.prototype.indicatorSpacing = 2;

/**
 * Function: init
 *
 * Initializes the shape and the <indicator>.
 */
mxLabel.prototype.init = function(container)
{
\tmxShape.prototype.init.apply(this, arguments);

\tif (this.indicatorShape != null)
\t{
\t\tthis.indicator = new this.indicatorShape();
\t\tthis.indicator.dialect = this.dialect;
\t\tthis.indicator.init(this.node);
\t}
};

/**
 * Function: redraw
 *
 * Reconfigures this shape. This will update the colors of the indicator
 * and reconfigure it if required.
 */
mxLabel.prototype.redraw = function()
{
\tif (this.indicator != null)
\t{
\t\tthis.indicator.fill = this.indicatorColor;
\t\tthis.indicator.stroke = this.indicatorStrokeColor;
\t\tthis.indicator.gradient = this.indicatorGradientColor;
\t\tthis.indicator.direction = this.indicatorDirection;
\t\tthis.indicator.redraw();
\t}
\t
\tmxShape.prototype.redraw.apply(this, arguments);
};

/**
 * Function: isHtmlAllowed
 *
 * Returns true for non-rounded, non-rotated shapes with no glass gradient and
 * no indicator shape.
 */
mxLabel.prototype.isHtmlAllowed = function()
{
\treturn mxRectangleShape.prototype.isHtmlAllowed.apply(this, arguments) &&
\t\tthis.indicatorColor == null && this.indicatorShape == null;
};

/**
 * Function: paintForeground
 * 
 * Generic background painting implementation.
 */
mxLabel.prototype.paintForeground = function(c, x, y, w, h)
{
\tthis.paintImage(c, x, y, w, h);
\tthis.paintIndicator(c, x, y, w, h);
\t
\tmxRectangleShape.prototype.paintForeground.apply(this, arguments);
};

/**
 * Function: paintImage
 * 
 * Generic background painting implementation.
 */
mxLabel.prototype.paintImage = function(c, x, y, w, h)
{
\tif (this.image != null)
\t{
\t\tvar bounds = this.getImageBounds(x, y, w, h);
\t\tc.image(bounds.x, bounds.y, bounds.width, bounds.height, this.image, false, false, false);
\t}
};

/**
 * Function: getImageBounds
 * 
 * Generic background painting implementation.
 */
mxLabel.prototype.getImageBounds = function(x, y, w, h)
{
\tvar align = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_ALIGN, mxConstants.ALIGN_LEFT);
\tvar valign = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, mxConstants.ALIGN_MIDDLE);
\tvar width = mxUtils.getNumber(this.style, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE);
\tvar height = mxUtils.getNumber(this.style, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE);
\tvar spacing = mxUtils.getNumber(this.style, mxConstants.STYLE_SPACING, this.spacing) + 5;

\tif (align == mxConstants.ALIGN_CENTER)
\t{
\t\tx += (w - width) / 2;
\t}
\telse if (align == mxConstants.ALIGN_RIGHT)
\t{
\t\tx += w - width - spacing;
\t}
\telse // default is left
\t{
\t\tx += spacing;
\t}

\tif (valign == mxConstants.ALIGN_TOP)
\t{
\t\ty += spacing;
\t}
\telse if (valign == mxConstants.ALIGN_BOTTOM)
\t{
\t\ty += h - height - spacing;
\t}
\telse // default is middle
\t{
\t\ty += (h - height) / 2;
\t}
\t
\treturn new mxRectangle(x, y, width, height);
};

/**
 * Function: paintIndicator
 * 
 * Generic background painting implementation.
 */
mxLabel.prototype.paintIndicator = function(c, x, y, w, h)
{
\tif (this.indicator != null)
\t{
\t\tthis.indicator.bounds = this.getIndicatorBounds(x, y, w, h);
\t\tthis.indicator.paint(c);
\t}
\telse if (this.indicatorImage != null)
\t{
\t\tvar bounds = this.getIndicatorBounds(x, y, w, h);
\t\tc.image(bounds.x, bounds.y, bounds.width, bounds.height, this.indicatorImage, false, false, false);
\t}
};

/**
 * Function: getIndicatorBounds
 * 
 * Generic background painting implementation.
 */
mxLabel.prototype.getIndicatorBounds = function(x, y, w, h)
{
\tvar align = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_ALIGN, mxConstants.ALIGN_LEFT);
\tvar valign = mxUtils.getValue(this.style, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, mxConstants.ALIGN_MIDDLE);
\tvar width = mxUtils.getNumber(this.style, mxConstants.STYLE_INDICATOR_WIDTH, this.indicatorSize);
\tvar height = mxUtils.getNumber(this.style, mxConstants.STYLE_INDICATOR_HEIGHT, this.indicatorSize);
\tvar spacing = this.spacing + 5;\t\t
\t
\tif (align == mxConstants.ALIGN_RIGHT)
\t{
\t\tx += w - width - spacing;
\t}
\telse if (align == mxConstants.ALIGN_CENTER)
\t{
\t\tx += (w - width) / 2;
\t}
\telse // default is left
\t{
\t\tx += spacing;
\t}
\t
\tif (valign == mxConstants.ALIGN_BOTTOM)
\t{
\t\ty += h - height - spacing;
\t}
\telse if (valign == mxConstants.ALIGN_TOP)
\t{
\t\ty += spacing;
\t}
\telse // default is middle
\t{
\t\ty += (h - height) / 2;
\t}
\t
\treturn new mxRectangle(x, y, width, height);
};
/**
 * Function: redrawHtmlShape
 * 
 * Generic background painting implementation.
 */
mxLabel.prototype.redrawHtmlShape = function()
{
\tmxRectangleShape.prototype.redrawHtmlShape.apply(this, arguments);
\t
\t// Removes all children
\twhile(this.node.hasChildNodes())
\t{
\t\tthis.node.removeChild(this.node.lastChild);
\t}
\t
\tif (this.image != null)
\t{
\t\tvar node = document.createElement('img');
\t\tnode.style.position = 'relative';
\t\tnode.setAttribute('border', '0');
\t\t
\t\tvar bounds = this.getImageBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
\t\tbounds.x -= this.bounds.x;
\t\tbounds.y -= this.bounds.y;

\t\tnode.style.left = Math.round(bounds.x) + 'px';
\t\tnode.style.top = Math.round(bounds.y) + 'px';
\t\tnode.style.width = Math.round(bounds.width) + 'px';
\t\tnode.style.height = Math.round(bounds.height) + 'px';
\t\t
\t\tnode.src = this.image;
\t\t
\t\tthis.node.appendChild(node);
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxCylinder
 *
 * Extends <mxShape> to implement an cylinder shape. If a
 * custom shape with one filled area and an overlay path is
 * needed, then this shape's <redrawPath> should be overridden.
 * This shape is registered under <mxConstants.SHAPE_CYLINDER>
 * in <mxCellRenderer>.
 * 
 * Constructor: mxCylinder
 *
 * Constructs a new cylinder shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxCylinder(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxCylinder, mxShape);

/**
 * Variable: maxHeight
 *
 * Defines the maximum height of the top and bottom part
 * of the cylinder shape.
 */
mxCylinder.prototype.maxHeight = 40;

/**
 * Variable: svgStrokeTolerance
 *
 * Sets stroke tolerance to 0 for SVG.
 */
mxCylinder.prototype.svgStrokeTolerance = 0;

/**
 * Function: paintVertexShape
 * 
 * Redirects to redrawPath for subclasses to work.
 */
mxCylinder.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tc.translate(x, y);
\tc.begin();
\tthis.redrawPath(c, x, y, w, h, false);
\tc.fillAndStroke();
\t
\tif (!this.outline || this.style == null || mxUtils.getValue(
\t\tthis.style, mxConstants.STYLE_BACKGROUND_OUTLINE, 0) == 0)
\t{
\t\tc.setShadow(false);
\t\tc.begin();
\t\tthis.redrawPath(c, x, y, w, h, true);
\t\tc.stroke();
\t}
};

/**
 * Function: getCylinderSize
 *
 * Returns the cylinder size.
 */
mxCylinder.prototype.getCylinderSize = function(x, y, w, h)
{
\treturn Math.min(this.maxHeight, Math.round(h / 5));
};

/**
 * Function: redrawPath
 *
 * Draws the path for this shape.
 */
mxCylinder.prototype.redrawPath = function(c, x, y, w, h, isForeground)
{
\tvar dy = this.getCylinderSize(x, y, w, h);
\t
\tif ((isForeground && this.fill != null) || (!isForeground && this.fill == null))
\t{
\t\tc.moveTo(0, dy);
\t\tc.curveTo(0, 2 * dy, w, 2 * dy, w, dy);
\t\t
\t\t// Needs separate shapes for correct hit-detection
\t\tif (!isForeground)
\t\t{
\t\t\tc.stroke();
\t\t\tc.begin();
\t\t}
\t}
\t
\tif (!isForeground)
\t{
\t\tc.moveTo(0, dy);
\t\tc.curveTo(0, -dy / 3, w, -dy / 3, w, dy);
\t\tc.lineTo(w, h - dy);
\t\tc.curveTo(w, h + dy / 3, 0, h + dy / 3, 0, h - dy);
\t\tc.close();
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxConnector
 * 
 * Extends <mxShape> to implement a connector shape. The connector
 * shape allows for arrow heads on either side.
 * 
 * This shape is registered under <mxConstants.SHAPE_CONNECTOR> in
 * <mxCellRenderer>.
 * 
 * Constructor: mxConnector
 * 
 * Constructs a new connector shape.
 * 
 * Parameters:
 * 
 * points - Array of <mxPoints> that define the points. This is stored in
 * <mxShape.points>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * Default is 'black'.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxConnector(points, stroke, strokewidth)
{
\tmxPolyline.call(this, points, stroke, strokewidth);
};

/**
 * Extends mxPolyline.
 */
mxUtils.extend(mxConnector, mxPolyline);

/**
 * Function: updateBoundingBox
 *
 * Updates the <boundingBox> for this shape using <createBoundingBox> and
 * <augmentBoundingBox> and stores the result in <boundingBox>.
 */
mxConnector.prototype.updateBoundingBox = function()
{
\tthis.useSvgBoundingBox = this.style != null && this.style[mxConstants.STYLE_CURVED] == 1;
\tmxShape.prototype.updateBoundingBox.apply(this, arguments);
};

/**
 * Function: paintEdgeShape
 * 
 * Paints the line shape.
 */
mxConnector.prototype.paintEdgeShape = function(c, pts)
{
\t// The indirection via functions for markers is needed in
\t// order to apply the offsets before painting the line and
\t// paint the markers after painting the line.
\tvar sourceMarker = this.createMarker(c, pts, true);
\tvar targetMarker = this.createMarker(c, pts, false);

\tmxPolyline.prototype.paintEdgeShape.apply(this, arguments);
\t
\t// Disables shadows, dashed styles and fixes fill color for markers
\tc.setFillColor(this.stroke);
\tc.setShadow(false);
\tc.setDashed(false);
\t
\tif (sourceMarker != null)
\t{
\t\tsourceMarker();
\t}
\t
\tif (targetMarker != null)
\t{
\t\ttargetMarker();
\t}
};

/**
 * Function: createMarker
 * 
 * Prepares the marker by adding offsets in pts and returning a function to
 * paint the marker.
 */
mxConnector.prototype.createMarker = function(c, pts, source)
{
\tvar result = null;
\tvar n = pts.length;
\tvar type = mxUtils.getValue(this.style, (source) ? mxConstants.STYLE_STARTARROW : mxConstants.STYLE_ENDARROW);
\tvar p0 = (source) ? pts[1] : pts[n - 2];
\tvar pe = (source) ? pts[0] : pts[n - 1];
\t
\tif (type != null && p0 != null && pe != null)
\t{
\t\tvar count = 1;
\t\t
\t\t// Uses next non-overlapping point
\t\twhile (count < n - 1 && Math.round(p0.x - pe.x) == 0 && Math.round(p0.y - pe.y) == 0)
\t\t{
\t\t\tp0 = (source) ? pts[1 + count] : pts[n - 2 - count];
\t\t\tcount++;
\t\t}
\t
\t\t// Computes the norm and the inverse norm
\t\tvar dx = pe.x - p0.x;
\t\tvar dy = pe.y - p0.y;
\t
\t\tvar dist = Math.max(1, Math.sqrt(dx * dx + dy * dy));
\t\t
\t\tvar unitX = dx / dist;
\t\tvar unitY = dy / dist;
\t
\t\tvar size = mxUtils.getNumber(this.style, (source) ? mxConstants.STYLE_STARTSIZE : mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE);
\t\t
\t\t// Allow for stroke width in the end point used and the 
\t\t// orthogonal vectors describing the direction of the marker
\t\tvar filled = this.style[(source) ? mxConstants.STYLE_STARTFILL : mxConstants.STYLE_ENDFILL] != 0;
\t\t
\t\tresult = mxMarker.createMarker(c, this, type, pe, unitX, unitY, size, source, this.strokewidth, filled);
\t}
\t
\treturn result;
};

/**
 * Function: augmentBoundingBox
 *
 * Augments the bounding box with the strokewidth and shadow offsets.
 */
mxConnector.prototype.augmentBoundingBox = function(bbox)
{
\tmxShape.prototype.augmentBoundingBox.apply(this, arguments);
\t
\t// Adds marker sizes
\tvar size = 0;
\t
\tif (mxUtils.getValue(this.style, mxConstants.STYLE_STARTARROW, mxConstants.NONE) != mxConstants.NONE)
\t{
\t\tsize = mxUtils.getNumber(this.style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE) + 1;
\t}
\t
\tif (mxUtils.getValue(this.style, mxConstants.STYLE_ENDARROW, mxConstants.NONE) != mxConstants.NONE)
\t{
\t\tsize = Math.max(size, mxUtils.getNumber(this.style, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE)) + 1;
\t}
\t
\tbbox.grow(size * this.scale);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxSwimlane
 *
 * Extends <mxShape> to implement a swimlane shape. This shape is registered
 * under <mxConstants.SHAPE_SWIMLANE> in <mxCellRenderer>. Use the
 * <mxConstants.STYLE_STYLE_STARTSIZE> to define the size of the title
 * region, <mxConstants.STYLE_SWIMLANE_FILLCOLOR> for the content area fill,
 * <mxConstants.STYLE_SEPARATORCOLOR> to draw an additional vertical separator
 * and <mxConstants.STYLE_SWIMLANE_LINE> to hide the line between the title
 * region and the content area. The <mxConstants.STYLE_HORIZONTAL> affects
 * the orientation of this shape, not only its label.
 * 
 * Constructor: mxSwimlane
 *
 * Constructs a new swimlane shape.
 * 
 * Parameters:
 * 
 * bounds - <mxRectangle> that defines the bounds. This is stored in
 * <mxShape.bounds>.
 * fill - String that defines the fill color. This is stored in <fill>.
 * stroke - String that defines the stroke color. This is stored in <stroke>.
 * strokewidth - Optional integer that defines the stroke width. Default is
 * 1. This is stored in <strokewidth>.
 */
function mxSwimlane(bounds, fill, stroke, strokewidth)
{
\tmxShape.call(this);
\tthis.bounds = bounds;
\tthis.fill = fill;
\tthis.stroke = stroke;
\tthis.strokewidth = (strokewidth != null) ? strokewidth : 1;
};

/**
 * Extends mxShape.
 */
mxUtils.extend(mxSwimlane, mxShape);

/**
 * Variable: imageSize
 *
 * Default imagewidth and imageheight if an image but no imagewidth
 * and imageheight are defined in the style. Value is 16.
 */
mxSwimlane.prototype.imageSize = 16;

/**
 * Function: isRoundable
 * 
 * Adds roundable support.
 */
mxSwimlane.prototype.isRoundable = function(c, x, y, w, h)
{
\treturn true;
};

/**
 * Function: getTitleSize
 * 
 * Returns the title size.
 */
mxSwimlane.prototype.getTitleSize = function()
{
\treturn Math.max(0, mxUtils.getValue(this.style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE));
};

/**
 * Function: getLabelBounds
 * 
 * Returns the bounding box for the label.
 */
mxSwimlane.prototype.getLabelBounds = function(rect)
{
\tvar start = this.getTitleSize();
\tvar bounds = new mxRectangle(rect.x, rect.y, rect.width, rect.height);
\tvar horizontal = this.isHorizontal();
\t
\tvar flipH = mxUtils.getValue(this.style, mxConstants.STYLE_FLIPH, 0) == 1;
\tvar flipV = mxUtils.getValue(this.style, mxConstants.STYLE_FLIPV, 0) == 1;\t
\t
\t// East is default
\tvar shapeVertical = (this.direction == mxConstants.DIRECTION_NORTH ||
\t\t\tthis.direction == mxConstants.DIRECTION_SOUTH);
\tvar realHorizontal = horizontal == !shapeVertical;
\t
\tvar realFlipH = !realHorizontal && flipH != (this.direction == mxConstants.DIRECTION_SOUTH ||
\t\t\tthis.direction == mxConstants.DIRECTION_WEST);
\tvar realFlipV = realHorizontal && flipV != (this.direction == mxConstants.DIRECTION_SOUTH ||
\t\t\tthis.direction == mxConstants.DIRECTION_WEST);

\t// Shape is horizontal
\tif (!shapeVertical)
\t{
\t\tvar tmp = Math.min(bounds.height, start * this.scale);

\t\tif (realFlipH || realFlipV)
\t\t{
\t\t\tbounds.y += bounds.height - tmp;
\t\t}

\t\tbounds.height = tmp;
\t}
\telse
\t{
\t\tvar tmp = Math.min(bounds.width, start * this.scale);
\t\t
\t\tif (realFlipH || realFlipV)
\t\t{
\t\t\tbounds.x += bounds.width - tmp;\t
\t\t}

\t\tbounds.width = tmp;
\t}
\t
\treturn bounds;
};

/**
 * Function: getGradientBounds
 * 
 * Returns the bounding box for the gradient box for this shape.
 */
mxSwimlane.prototype.getGradientBounds = function(c, x, y, w, h)
{
\tvar start = this.getTitleSize();
\t
\tif (this.isHorizontal())
\t{
\t\tstart = Math.min(start, h);
\t\treturn new mxRectangle(x, y, w, start);
\t}
\telse
\t{
\t\tstart = Math.min(start, w);
\t\treturn new mxRectangle(x, y, start, h);
\t}
};

/**
 * Function: getSwimlaneArcSize
 * 
 * Returns the arcsize for the swimlane.
 */
mxSwimlane.prototype.getSwimlaneArcSize = function(w, h, start)
{
\tif (mxUtils.getValue(this.style, mxConstants.STYLE_ABSOLUTE_ARCSIZE, 0) == '1')
\t{
\t\treturn Math.min(w / 2, Math.min(h / 2, mxUtils.getValue(this.style,
\t\t\tmxConstants.STYLE_ARCSIZE, mxConstants.LINE_ARCSIZE) / 2));
\t}
\telse
\t{
\t\tvar f = mxUtils.getValue(this.style, mxConstants.STYLE_ARCSIZE, mxConstants.RECTANGLE_ROUNDING_FACTOR * 100) / 100;

\t\treturn start * f * 3; 
\t}
};

/**
 * Function: isHorizontal
 *
 * Paints the swimlane vertex shape.
 */
mxSwimlane.prototype.isHorizontal = function()
{
\treturn mxUtils.getValue(this.style, mxConstants.STYLE_HORIZONTAL, 1) == 1;
};

/**
 * Function: paintVertexShape
 *
 * Paints the swimlane vertex shape.
 */
mxSwimlane.prototype.paintVertexShape = function(c, x, y, w, h)
{
\tvar start = this.getTitleSize();
\tvar fill = mxUtils.getValue(this.style, mxConstants.STYLE_SWIMLANE_FILLCOLOR, mxConstants.NONE);
\tvar swimlaneLine = mxUtils.getValue(this.style, mxConstants.STYLE_SWIMLANE_LINE, 1) == 1;
\tvar r = 0;
\t
\tif (this.isHorizontal())
\t{
\t\tstart = Math.min(start, h);
\t}
\telse
\t{
\t\tstart = Math.min(start, w);
\t}
\t
\tc.translate(x, y);
\t
\tif (!this.isRounded)
\t{
\t\tthis.paintSwimlane(c, x, y, w, h, start, fill, swimlaneLine);
\t}
\telse
\t{
\t\tr = this.getSwimlaneArcSize(w, h, start);
\t\tr = Math.min(((this.isHorizontal()) ? h : w) - start, Math.min(start, r));
\t\tthis.paintRoundedSwimlane(c, x, y, w, h, start, r, fill, swimlaneLine);
\t}
\t
\tvar sep = mxUtils.getValue(this.style, mxConstants.STYLE_SEPARATORCOLOR, mxConstants.NONE);
\tthis.paintSeparator(c, x, y, w, h, start, sep);

\tif (this.image != null)
\t{
\t\tvar bounds = this.getImageBounds(x, y, w, h);
\t\tc.image(bounds.x - x, bounds.y - y, bounds.width, bounds.height,
\t\t\t\tthis.image, false, false, false);
\t}
\t
\tif (this.glass)
\t{
\t\tc.setShadow(false);
\t\tthis.paintGlassEffect(c, 0, 0, w, start, r);
\t}
};

/**
 * Function: paintSwimlane
 *
 * Paints the swimlane vertex shape.
 */
mxSwimlane.prototype.paintSwimlane = function(c, x, y, w, h, start, fill, swimlaneLine)
{
\tc.begin();
\t
\tvar events = true;
\t
\tif (this.style != null)
\t{
\t\tevents = mxUtils.getValue(this.style, mxConstants.STYLE_POINTER_EVENTS, '1') == '1';
\t}
\t
\tif (!events && (this.fill == null || this.fill == mxConstants.NONE))
\t{
\t\tc.pointerEvents = false;
\t}
\t
\tif (this.isHorizontal())
\t{
\t\tc.moveTo(0, start);
\t\tc.lineTo(0, 0);
\t\tc.lineTo(w, 0);
\t\tc.lineTo(w, start);
\t\tc.fillAndStroke();

\t\tif (start < h)
\t\t{
\t\t\tif (fill == mxConstants.NONE || !events)
\t\t\t{
\t\t\t\tc.pointerEvents = false;
\t\t\t}
\t\t\t
\t\t\tif (fill != mxConstants.NONE)
\t\t\t{
\t\t\t\tc.setFillColor(fill);
\t\t\t}
\t\t\t
\t\t\tc.begin();
\t\t\tc.moveTo(0, start);
\t\t\tc.lineTo(0, h);
\t\t\tc.lineTo(w, h);
\t\t\tc.lineTo(w, start);
\t\t\t
\t\t\tif (fill == mxConstants.NONE)
\t\t\t{
\t\t\t\tc.stroke();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tc.fillAndStroke();
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\tc.moveTo(start, 0);
\t\tc.lineTo(0, 0);
\t\tc.lineTo(0, h);
\t\tc.lineTo(start, h);
\t\tc.fillAndStroke();
\t\t
\t\tif (start < w)
\t\t{
\t\t\tif (fill == mxConstants.NONE || !events)
\t\t\t{
\t\t\t\tc.pointerEvents = false;
\t\t\t}
\t\t\t
\t\t\tif (fill != mxConstants.NONE)
\t\t\t{
\t\t\t\tc.setFillColor(fill);
\t\t\t}
\t\t\t
\t\t\tc.begin();
\t\t\tc.moveTo(start, 0);
\t\t\tc.lineTo(w, 0);
\t\t\tc.lineTo(w, h);
\t\t\tc.lineTo(start, h);
\t\t\t
\t\t\tif (fill == mxConstants.NONE)
\t\t\t{
\t\t\t\tc.stroke();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tc.fillAndStroke();
\t\t\t}
\t\t}
\t}
\t
\tif (swimlaneLine)
\t{
\t\tthis.paintDivider(c, x, y, w, h, start, fill == mxConstants.NONE);
\t}
};

/**
 * Function: paintRoundedSwimlane
 *
 * Paints the swimlane vertex shape.
 */
mxSwimlane.prototype.paintRoundedSwimlane = function(c, x, y, w, h, start, r, fill, swimlaneLine)
{
\tc.begin();
\t
\tvar events = true;
\t
\tif (this.style != null)
\t{
\t\tevents = mxUtils.getValue(this.style, mxConstants.STYLE_POINTER_EVENTS, '1') == '1';
\t}
\t
\tif (!events && (this.fill == null || this.fill == mxConstants.NONE))
\t{
\t\tc.pointerEvents = false;
\t}
\t
\tif (this.isHorizontal())
\t{
\t\tc.moveTo(w, start);
\t\tc.lineTo(w, r);
\t\tc.quadTo(w, 0, w - Math.min(w / 2, r), 0);
\t\tc.lineTo(Math.min(w / 2, r), 0);
\t\tc.quadTo(0, 0, 0, r);
\t\tc.lineTo(0, start);
\t\tc.fillAndStroke();
\t\t
\t\tif (start < h)
\t\t{
\t\t\tif (fill == mxConstants.NONE || !events)
\t\t\t{
\t\t\t\tc.pointerEvents = false;
\t\t\t}
\t\t\t
\t\t\tif (fill != mxConstants.NONE)
\t\t\t{
\t\t\t\tc.setFillColor(fill);
\t\t\t}
\t\t\t
\t\t\tc.begin();
\t\t\tc.moveTo(0, start);
\t\t\tc.lineTo(0, h - r);
\t\t\tc.quadTo(0, h, Math.min(w / 2, r), h);
\t\t\tc.lineTo(w - Math.min(w / 2, r), h);
\t\t\tc.quadTo(w, h, w, h - r);
\t\t\tc.lineTo(w, start);
\t\t\t
\t\t\tif (fill == mxConstants.NONE)
\t\t\t{
\t\t\t\tc.stroke();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tc.fillAndStroke();
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\tc.moveTo(start, 0);
\t\tc.lineTo(r, 0);
\t\tc.quadTo(0, 0, 0, Math.min(h / 2, r));
\t\tc.lineTo(0, h - Math.min(h / 2, r));
\t\tc.quadTo(0, h, r, h);
\t\tc.lineTo(start, h);
\t\tc.fillAndStroke();

\t\tif (start < w)
\t\t{
\t\t\tif (fill == mxConstants.NONE || !events)
\t\t\t{
\t\t\t\tc.pointerEvents = false;
\t\t\t}
\t\t\t
\t\t\tif (fill != mxConstants.NONE)
\t\t\t{
\t\t\t\tc.setFillColor(fill);
\t\t\t}
\t\t\t
\t\t\tc.begin();
\t\t\tc.moveTo(start, h);
\t\t\tc.lineTo(w - r, h);
\t\t\tc.quadTo(w, h, w, h - Math.min(h / 2, r));
\t\t\tc.lineTo(w, Math.min(h / 2, r));
\t\t\tc.quadTo(w, 0, w - r, 0);
\t\t\tc.lineTo(start, 0);
\t\t\t
\t\t\tif (fill == mxConstants.NONE)
\t\t\t{
\t\t\t\tc.stroke();
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tc.fillAndStroke();
\t\t\t}
\t\t}
\t}

\tif (swimlaneLine)
\t{
\t\tthis.paintDivider(c, x, y, w, h, start, fill == mxConstants.NONE);
\t}
};

/**
 * Function: paintDivider
 *
 * Paints the divider between swimlane title and content area.
 */
mxSwimlane.prototype.paintDivider = function(c, x, y, w, h, start, shadow)
{
\tif (!shadow)
\t{
\t\tc.setShadow(false);
\t}

\tc.begin();
\t
\tif (this.isHorizontal())
\t{
\t\tc.moveTo(0, start);
\t\tc.lineTo(w, start);
\t}
\telse
\t{
\t\tc.moveTo(start, 0);
\t\tc.lineTo(start, h);
\t}

\tc.stroke();
};

/**
 * Function: paintSeparator
 *
 * Paints the vertical or horizontal separator line between swimlanes.
 */
mxSwimlane.prototype.paintSeparator = function(c, x, y, w, h, start, color)
{
\tif (color != mxConstants.NONE)
\t{
\t\tc.setStrokeColor(color);
\t\tc.setDashed(true);
\t\tc.begin();
\t\t
\t\tif (this.isHorizontal())
\t\t{
\t\t\tc.moveTo(w, start);
\t\t\tc.lineTo(w, h);
\t\t}
\t\telse
\t\t{
\t\t\tc.moveTo(start, 0);
\t\t\tc.lineTo(w, 0);
\t\t}
\t\t
\t\tc.stroke();
\t\tc.setDashed(false);
\t}
};

/**
 * Function: getImageBounds
 *
 * Paints the swimlane vertex shape.
 */
mxSwimlane.prototype.getImageBounds = function(x, y, w, h)
{
\tif (this.isHorizontal())
\t{
\t\treturn new mxRectangle(x + w - this.imageSize, y, this.imageSize, this.imageSize);
\t}
\telse
\t{
\t\treturn new mxRectangle(x, y, this.imageSize, this.imageSize);
\t}
};
/**
 * Copyright (c) 2006-2018, JGraph Ltd
 * Copyright (c) 2006-2018, Gaudenz Alder
 */
/**
 * Class: mxGraphLayout
 * 
 * Base class for all layout algorithms in mxGraph. Main public functions are
 * <moveCell> for handling a moved cell within a layouted parent, and <execute> for
 * running the layout on a given parent cell.
 *
 * Known Subclasses:
 *
 * <mxCircleLayout>, <mxCompactTreeLayout>, <mxCompositeLayout>,
 * <mxFastOrganicLayout>, <mxParallelEdgeLayout>, <mxPartitionLayout>,
 * <mxStackLayout>
 * 
 * Constructor: mxGraphLayout
 *
 * Constructs a new layout using the given layouts.
 *
 * Arguments:
 * 
 * graph - Enclosing 
 */
function mxGraphLayout(graph)
{
\tthis.graph = graph;
};

/**
 * Variable: graph
 * 
 * Reference to the enclosing <mxGraph>.
 */
mxGraphLayout.prototype.graph = null;

/**
 * Variable: useBoundingBox
 *
 * Boolean indicating if the bounding box of the label should be used if
 * its available. Default is true.
 */
mxGraphLayout.prototype.useBoundingBox = true;

/**
 * Variable: parent
 *
 * The parent cell of the layout, if any
 */
mxGraphLayout.prototype.parent = null;

/**
 * Function: moveCell
 * 
 * Notified when a cell is being moved in a parent that has automatic
 * layout to update the cell state (eg. index) so that the outcome of the
 * layout will position the vertex as close to the point (x, y) as
 * possible.
 * 
 * Empty implementation.
 * 
 * Parameters:
 * 
 * cell - <mxCell> which has been moved.
 * x - X-coordinate of the new cell location.
 * y - Y-coordinate of the new cell location.
 */
mxGraphLayout.prototype.moveCell = function(cell, x, y) { };

/**
 * Function: resizeCell
 * 
 * Notified when a cell is being resized in a parent that has automatic
 * layout to update the other cells in the layout.
 * 
 * Empty implementation.
 * 
 * Parameters:
 * 
 * cell - <mxCell> which has been moved.
 * bounds - <mxRectangle> that represents the new cell bounds.
 */
mxGraphLayout.prototype.resizeCell = function(cell, bounds) { };

/**
 * Function: execute
 * 
 * Executes the layout algorithm for the children of the given parent.
 * 
 * Parameters:
 * 
 * parent - <mxCell> whose children should be layed out.
 */
mxGraphLayout.prototype.execute = function(parent) { };

/**
 * Function: getGraph
 * 
 * Returns the graph that this layout operates on.
 */
mxGraphLayout.prototype.getGraph = function()
{
\treturn this.graph;
};

/**
 * Function: getConstraint
 * 
 * Returns the constraint for the given key and cell. The optional edge and
 * source arguments are used to return inbound and outgoing routing-
 * constraints for the given edge and vertex. This implementation always
 * returns the value for the given key in the style of the given cell.
 * 
 * Parameters:
 * 
 * key - Key of the constraint to be returned.
 * cell - <mxCell> whose constraint should be returned.
 * edge - Optional <mxCell> that represents the connection whose constraint
 * should be returned. Default is null.
 * source - Optional boolean that specifies if the connection is incoming
 * or outgoing. Default is null.
 */
mxGraphLayout.prototype.getConstraint = function(key, cell, edge, source)
{
\treturn this.graph.getCurrentCellStyle(cell)[key]
};

/**
 * Function: traverse
 * 
 * Traverses the (directed) graph invoking the given function for each
 * visited vertex and edge. The function is invoked with the current vertex
 * and the incoming edge as a parameter. This implementation makes sure
 * each vertex is only visited once. The function may return false if the
 * traversal should stop at the given vertex.
 * 
 * Example:
 * 
 * (code)
 * mxLog.show();
 * var cell = graph.getSelectionCell();
 * graph.traverse(cell, false, function(vertex, edge)
 * {
 *   mxLog.debug(graph.getLabel(vertex));
 * });
 * (end)
 * 
 * Parameters:
 * 
 * vertex - <mxCell> that represents the vertex where the traversal starts.
 * directed - Optional boolean indicating if edges should only be traversed
 * from source to target. Default is true.
 * func - Visitor function that takes the current vertex and the incoming
 * edge as arguments. The traversal stops if the function returns false.
 * edge - Optional <mxCell> that represents the incoming edge. This is
 * null for the first step of the traversal.
 * visited - Optional <mxDictionary> of cell paths for the visited cells.
 */
mxGraphLayout.traverse = function(vertex, directed, func, edge, visited)
{
\tif (func != null && vertex != null)
\t{
\t\tdirected = (directed != null) ? directed : true;
\t\tvisited = visited || new mxDictionary();
\t\t
\t\tif (!visited.get(vertex))
\t\t{
\t\t\tvisited.put(vertex, true);
\t\t\tvar result = func(vertex, edge);
\t\t\t
\t\t\tif (result == null || result)
\t\t\t{
\t\t\t\tvar edgeCount = this.graph.model.getEdgeCount(vertex);
\t\t\t\t
\t\t\t\tif (edgeCount > 0)
\t\t\t\t{
\t\t\t\t\tfor (var i = 0; i < edgeCount; i++)
\t\t\t\t\t{
\t\t\t\t\t\tvar e = this.graph.model.getEdgeAt(vertex, i);
\t\t\t\t\t\tvar isSource = this.graph.model.getTerminal(e, true) == vertex;
\t\t\t\t\t\t\t\t\t\t\t\t
\t\t\t\t\t\tif (!directed || isSource)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar next = this.graph.view.getVisibleTerminal(e, !isSource);
\t\t\t\t\t\t\tthis.traverse(next, directed, func, e, visited);
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};

/**
 * Function: isAncestor
 * 
 * Returns true if the given parent is an ancestor of the given child.
 *
 * Parameters:
 * 
 * parent - <mxCell> that specifies the parent.
 * child - <mxCell> that specifies the child.
 * traverseAncestors - boolean whether to 
 */
mxGraphLayout.prototype.isAncestor = function(parent, child, traverseAncestors)
{
\tif (!traverseAncestors)
\t{
\t\treturn (this.graph.model.getParent(child) == parent);
\t}\t
\t
\tif (child == parent)
\t{
\t\treturn false;
\t}

\twhile (child != null && child != parent)
\t{
\t\tchild = this.graph.model.getParent(child);
\t}
\t
\treturn child == parent;
};

/**
 * Function: isVertexMovable
 * 
 * Returns a boolean indicating if the given <mxCell> is movable or
 * bendable by the algorithm. This implementation returns true if the given
 * cell is movable in the graph.
 * 
 * Parameters:
 * 
 * cell - <mxCell> whose movable state should be returned.
 */
mxGraphLayout.prototype.isVertexMovable = function(cell)
{
\treturn this.graph.isCellMovable(cell);
};

/**
 * Function: isVertexIgnored
 * 
 * Returns a boolean indicating if the given <mxCell> should be ignored by
 * the algorithm. This implementation returns false for all vertices.
 * 
 * Parameters:
 * 
 * vertex - <mxCell> whose ignored state should be returned.
 */
mxGraphLayout.prototype.isVertexIgnored = function(vertex)
{
\treturn !this.graph.getModel().isVertex(vertex) ||
\t\t!this.graph.isCellVisible(vertex);
};

/**
 * Function: isEdgeIgnored
 * 
 * Returns a boolean indicating if the given <mxCell> should be ignored by
 * the algorithm. This implementation returns false for all vertices.
 * 
 * Parameters:
 * 
 * cell - <mxCell> whose ignored state should be returned.
 */
mxGraphLayout.prototype.isEdgeIgnored = function(edge)
{
\tvar model = this.graph.getModel();
\t
\treturn !model.isEdge(edge) ||
\t\t!this.graph.isCellVisible(edge) ||
\t\tmodel.getTerminal(edge, true) == null ||
\t\tmodel.getTerminal(edge, false) == null;
};

/**
 * Function: setEdgeStyleEnabled
 * 
 * Disables or enables the edge style of the given edge.
 */
mxGraphLayout.prototype.setEdgeStyleEnabled = function(edge, value)
{
\tthis.graph.setCellStyles(mxConstants.STYLE_NOEDGESTYLE,
\t\t\t(value) ? '0' : '1', [edge]);
};

/**
 * Function: setOrthogonalEdge
 * 
 * Disables or enables orthogonal end segments of the given edge.
 */
mxGraphLayout.prototype.setOrthogonalEdge = function(edge, value)
{
\tthis.graph.setCellStyles(mxConstants.STYLE_ORTHOGONAL,
\t\t\t(value) ? '1' : '0', [edge]);
};

/**
 * Function: getParentOffset
 * 
 * Determines the offset of the given parent to the parent
 * of the layout
 */
mxGraphLayout.prototype.getParentOffset = function(parent)
{
\tvar result = new mxPoint();

\tif (parent != null && parent != this.parent)
\t{
\t\tvar model = this.graph.getModel();

\t\tif (model.isAncestor(this.parent, parent))
\t\t{
\t\t\tvar parentGeo = model.getGeometry(parent);

\t\t\twhile (parent != this.parent)
\t\t\t{
\t\t\t\tresult.x = result.x + parentGeo.x;
\t\t\t\tresult.y = result.y + parentGeo.y;

\t\t\t\tparent = model.getParent(parent);;
\t\t\t\tparentGeo = model.getGeometry(parent);
\t\t\t}
\t\t}
\t}

\treturn result;
};

/**
 * Function: setEdgePoints
 * 
 * Replaces the array of mxPoints in the geometry of the given edge
 * with the given array of mxPoints.
 */
mxGraphLayout.prototype.setEdgePoints = function(edge, points)
{
\tif (edge != null)
\t{
\t\tvar model = this.graph.model;
\t\tvar geometry = model.getGeometry(edge);

\t\tif (geometry == null)
\t\t{
\t\t\tgeometry = new mxGeometry();
\t\t\tgeometry.setRelative(true);
\t\t}
\t\telse
\t\t{
\t\t\tgeometry = geometry.clone();
\t\t}

\t\tif (this.parent != null && points != null)
\t\t{
\t\t\tvar parent = model.getParent(edge);

\t\t\tvar parentOffset = this.getParentOffset(parent);

\t\t\tfor (var i = 0; i < points.length; i++)
\t\t\t{
\t\t\t\tpoints[i].x = points[i].x - parentOffset.x;
\t\t\t\tpoints[i].y = points[i].y - parentOffset.y;
\t\t\t}
\t\t}

\t\tgeometry.points = points;
\t\tmodel.setGeometry(edge, geometry);
\t}
};

/**
 * Function: setVertexLocation
 * 
 * Sets the new position of the given cell taking into account the size of
 * the bounding box if <useBoundingBox> is true. The change is only carried
 * out if the new location is not equal to the existing location, otherwise
 * the geometry is not replaced with an updated instance. The new or old
 * bounds are returned (including overlapping labels).
 * 
 * Parameters:
 * 
 * cell - <mxCell> whose geometry is to be set.
 * x - Integer that defines the x-coordinate of the new location.
 * y - Integer that defines the y-coordinate of the new location.
 */
mxGraphLayout.prototype.setVertexLocation = function(cell, x, y)
{
\tvar model = this.graph.getModel();
\tvar geometry = model.getGeometry(cell);
\tvar result = null;
\t
\tif (geometry != null)
\t{
\t\tresult = new mxRectangle(x, y, geometry.width, geometry.height);
\t\t
\t\t// Checks for oversize labels and shifts the result
\t\t// TODO: Use mxUtils.getStringSize for label bounds
\t\tif (this.useBoundingBox)
\t\t{
\t\t\tvar state = this.graph.getView().getState(cell);
\t\t\t
\t\t\tif (state != null && state.text != null && state.text.boundingBox != null)
\t\t\t{
\t\t\t\tvar scale = this.graph.getView().scale;
\t\t\t\tvar box = state.text.boundingBox;
\t\t\t\t
\t\t\t\tif (state.text.boundingBox.x < state.x)
\t\t\t\t{
\t\t\t\t\tx += (state.x - box.x) / scale;
\t\t\t\t\tresult.width = box.width;
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (state.text.boundingBox.y < state.y)
\t\t\t\t{
\t\t\t\t\ty += (state.y - box.y) / scale;
\t\t\t\t\tresult.height = box.height;
\t\t\t\t}
\t\t\t}
\t\t}

\t\tif (this.parent != null)
\t\t{
\t\t\tvar parent = model.getParent(cell);

\t\t\tif (parent != null && parent != this.parent)
\t\t\t{
\t\t\t\tvar parentOffset = this.getParentOffset(parent);

\t\t\t\tx = x - parentOffset.x;
\t\t\t\ty = y - parentOffset.y;
\t\t\t}
\t\t}

\t\tif (geometry.x != x || geometry.y != y)
\t\t{
\t\t\tgeometry = geometry.clone();
\t\t\tgeometry.x = x;
\t\t\tgeometry.y = y;
\t\t\t
\t\t\tmodel.setGeometry(cell, geometry);
\t\t}
\t}
\t
\treturn result;
};

/**
 * Function: getVertexBounds
 * 
 * Returns an <mxRectangle> that defines the bounds of the given cell or
 * the bounding box if <useBoundingBox> is true.
 */
mxGraphLayout.prototype.getVertexBounds = function(cell)
{
\tvar geo = this.graph.getModel().getGeometry(cell);

\t// Checks for oversize label bounding box and corrects
\t// the return value accordingly
\t// TODO: Use mxUtils.getStringSize for label bounds
\tif (this.useBoundingBox)
\t{
\t\tvar state = this.graph.getView().getState(cell);

\t\tif (state != null && state.text != null && state.text.boundingBox != null)
\t\t{
\t\t\tvar scale = this.graph.getView().scale;
\t\t\tvar tmp = state.text.boundingBox;

\t\t\tvar dx0 = Math.max(state.x - tmp.x, 0) / scale;
\t\t\tvar dy0 = Math.max(state.y - tmp.y, 0) / scale;
\t\t\tvar dx1 = Math.max((tmp.x + tmp.width) - (state.x + state.width), 0) / scale;
  \t\t\tvar dy1 = Math.max((tmp.y + tmp.height) - (state.y + state.height), 0) / scale;

\t\t\tgeo = new mxRectangle(geo.x - dx0, geo.y - dy0, geo.width + dx0 + dx1, geo.height + dy0 + dy1);
\t\t}
\t}

\tif (this.parent != null)
\t{
\t\tvar parent = this.graph.getModel().getParent(cell);
\t\tgeo = geo.clone();

\t\tif (parent != null && parent != this.parent)
\t\t{
\t\t\tvar parentOffset = this.getParentOffset(parent);
\t\t\tgeo.x = geo.x + parentOffset.x;
\t\t\tgeo.y = geo.y + parentOffset.y;
\t\t}
\t}

\treturn new mxRectangle(geo.x, geo.y, geo.width, geo.height);
};

/**
 * Function: arrangeGroups
 * 
 * Shortcut to <mxGraph.updateGroupBounds> with moveGroup set to true.
 */
mxGraphLayout.prototype.arrangeGroups = function(cells, border, topBorder, rightBorder, bottomBorder, leftBorder)
{
\treturn this.graph.updateGroupBounds(cells, border, true, topBorder, rightBorder, bottomBorder, leftBorder);
};

/**
 * Class: WeightedCellSorter
 * 
 * A utility class used to track cells whilst sorting occurs on the weighted
 * sum of their connected edges. Does not violate (x.compareTo(y)==0) ==
 * (x.equals(y))
 *
 * Constructor: WeightedCellSorter
 * 
 * Constructs a new weighted cell sorted for the given cell and weight.
 */
function WeightedCellSorter(cell, weightedValue)
{
\tthis.cell = cell;
\tthis.weightedValue = weightedValue;
};

/**
 * Variable: weightedValue
 * 
 * The weighted value of the cell stored.
 */
WeightedCellSorter.prototype.weightedValue = 0;

/**
 * Variable: nudge
 * 
 * Whether or not to flip equal weight values.
 */
WeightedCellSorter.prototype.nudge = false;

/**
 * Variable: visited
 * 
 * Whether or not this cell has been visited in the current assignment.
 */
WeightedCellSorter.prototype.visited = false;

/**
 * Variable: rankIndex
 * 
 * The index this cell is in the model rank.
 */
WeightedCellSorter.prototype.rankIndex = null;

/**
 * Variable: cell
 * 
 * The cell whose median value is being calculated.
 */
WeightedCellSorter.prototype.cell = null;

/**
 * Function: compare
 * 
 * Compares two WeightedCellSorters.
 */
WeightedCellSorter.prototype.compare = function(a, b)
{
\tif (a != null && b != null)
\t{
\t\tif (b.weightedValue > a.weightedValue)
\t\t{
\t\t\treturn -1;
\t\t}
\t\telse if (b.weightedValue < a.weightedValue)
\t\t{
\t\t\treturn 1;
\t\t}
\t\telse
\t\t{
\t\t\tif (b.nudge)
\t\t\t{
\t\t\t\treturn -1;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\treturn 1;
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\treturn 0;
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxStackLayout
 * 
 * Extends <mxGraphLayout> to create a horizontal or vertical stack of the
 * child vertices. The children do not need to be connected for this layout
 * to work.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxStackLayout(graph, true);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxStackLayout
 * 
 * Constructs a new stack layout layout for the specified graph,
 * spacing, orientation and offset.
 */
function mxStackLayout(graph, horizontal, spacing, x0, y0, border)
{
\tmxGraphLayout.call(this, graph);
\tthis.horizontal = (horizontal != null) ? horizontal : true;
\tthis.spacing = (spacing != null) ? spacing : 0;
\tthis.x0 = (x0 != null) ? x0 : 0;
\tthis.y0 = (y0 != null) ? y0 : 0;
\tthis.border = (border != null) ? border : 0;
};

/**
 * Extends mxGraphLayout.
 */
mxStackLayout.prototype = new mxGraphLayout();
mxStackLayout.prototype.constructor = mxStackLayout;

/**
 * Variable: horizontal
 *
 * Specifies the orientation of the layout. Default is true.
 */
mxStackLayout.prototype.horizontal = null;

/**
 * Variable: spacing
 *
 * Specifies the spacing between the cells. Default is 0.
 */
mxStackLayout.prototype.spacing = null;

/**
 * Variable: x0
 *
 * Specifies the horizontal origin of the layout. Default is 0.
 */
mxStackLayout.prototype.x0 = null;

/**
 * Variable: y0
 *
 * Specifies the vertical origin of the layout. Default is 0.
 */
mxStackLayout.prototype.y0 = null;

/**
 * Variable: border
 *
 * Border to be added if fill is true. Default is 0.
 */
mxStackLayout.prototype.border = 0;

/**
 * Variable: marginTop
 * 
 * Top margin for the child area. Default is 0.
 */
mxStackLayout.prototype.marginTop = 0;

/**
 * Variable: marginLeft
 * 
 * Top margin for the child area. Default is 0.
 */
mxStackLayout.prototype.marginLeft = 0;

/**
 * Variable: marginRight
 * 
 * Top margin for the child area. Default is 0.
 */
mxStackLayout.prototype.marginRight = 0;

/**
 * Variable: marginBottom
 * 
 * Top margin for the child area. Default is 0.
 */
mxStackLayout.prototype.marginBottom = 0;

/**
 * Variable: keepFirstLocation
 * 
 * Boolean indicating if the location of the first cell should be
 * kept, that is, it will not be moved to x0 or y0. Default is false.
 */
mxStackLayout.prototype.keepFirstLocation = false;

/**
 * Variable: fill
 * 
 * Boolean indicating if dimension should be changed to fill out the parent
 * cell. Default is false.
 */
mxStackLayout.prototype.fill = false;
\t
/**
 * Variable: resizeParent
 * 
 * If the parent should be resized to match the width/height of the
 * stack. Default is false.
 */
mxStackLayout.prototype.resizeParent = false;

/**
 * Variable: resizeParentMax
 * 
 * Use maximum of existing value and new value for resize of parent.
 * Default is false.
 */
mxStackLayout.prototype.resizeParentMax = false;

/**
 * Variable: resizeLast
 * 
 * If the last element should be resized to fill out the parent. Default is
 * false. If <resizeParent> is true then this is ignored.
 */
mxStackLayout.prototype.resizeLast = false;

/**
 * Variable: wrap
 * 
 * Value at which a new column or row should be created. Default is null.
 */
mxStackLayout.prototype.wrap = null;

/**
 * Variable: borderCollapse
 * 
 * If the strokeWidth should be ignored. Default is true.
 */
mxStackLayout.prototype.borderCollapse = true;

/**
 * Variable: allowGaps
 * 
 * If gaps should be allowed in the stack. Default is false.
 */
mxStackLayout.prototype.allowGaps = false;

/**
 * Variable: gridSize
 * 
 * Grid size for alignment of position and size. Default is 0.
 */
mxStackLayout.prototype.gridSize = 0;

/**
 * Function: isHorizontal
 * 
 * Returns <horizontal>.
 */
mxStackLayout.prototype.isHorizontal = function()
{
\treturn this.horizontal;
};

/**
 * Function: moveCell
 * 
 * Implements <mxGraphLayout.moveCell>.
 */
mxStackLayout.prototype.moveCell = function(cell, x, y)
{
\tvar model = this.graph.getModel();
\tvar parent = model.getParent(cell);
\tvar horizontal = this.isHorizontal();
\t
\tif (cell != null && parent != null)
\t{
\t\tvar i = 0;
\t\tvar last = 0;
\t\tvar childCount = model.getChildCount(parent);
\t\tvar value = (horizontal) ? x : y;
\t\tvar pstate = this.graph.getView().getState(parent);

\t\tif (pstate != null)
\t\t{
\t\t\tvalue -= (horizontal) ? pstate.x : pstate.y;
\t\t}
\t\t
\t\tvalue /= this.graph.view.scale;
\t\t
\t\tfor (i = 0; i < childCount; i++)
\t\t{
\t\t\tvar child = model.getChildAt(parent, i);
\t\t\t
\t\t\tif (child != cell)
\t\t\t{
\t\t\t\tvar bounds = model.getGeometry(child);
\t\t\t\t
\t\t\t\tif (bounds != null)
\t\t\t\t{
\t\t\t\t\tvar tmp = (horizontal) ?
\t\t\t\t\t\tbounds.x + bounds.width / 2 :
\t\t\t\t\t\tbounds.y + bounds.height / 2;
\t\t\t\t\t
\t\t\t\t\tif (last <= value && tmp > value)
\t\t\t\t\t{
\t\t\t\t\t\tbreak;
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tlast = tmp;
\t\t\t\t}
\t\t\t}
\t\t}

\t\t// Changes child order in parent
\t\tvar idx = parent.getIndex(cell);
\t\tidx = Math.max(0, i - ((i > idx) ? 1 : 0));

\t\tmodel.add(parent, cell, idx);
\t}
};

/**
 * Function: getParentSize
 * 
 * Returns the size for the parent container or the size of the graph
 * container if the parent is a layer or the root of the model.
 */
mxStackLayout.prototype.getParentSize = function(parent)
{
\tvar model = this.graph.getModel();\t\t\t
\tvar pgeo = model.getGeometry(parent);
\t
\t// Handles special case where the parent is either a layer with no
\t// geometry or the current root of the view in which case the size
\t// of the graph's container will be used.
\tif (this.graph.container != null && ((pgeo == null &&
\t\tmodel.isLayer(parent)) || parent == this.graph.getView().currentRoot))
\t{
\t\tvar width = this.graph.container.offsetWidth - 1;
\t\tvar height = this.graph.container.offsetHeight - 1;
\t\tpgeo = new mxRectangle(0, 0, width, height);
\t}
\t
\treturn pgeo;
};

/**
 * Function: getLayoutCells
 * 
 * Returns the cells to be layouted.
 */
mxStackLayout.prototype.getLayoutCells = function(parent)
{
\tvar model = this.graph.getModel();
\tvar childCount = model.getChildCount(parent);
\tvar cells = [];
\t
\tfor (var i = 0; i < childCount; i++)
\t{
\t\tvar child = model.getChildAt(parent, i);
\t\t
\t\tif (!this.isVertexIgnored(child) && this.isVertexMovable(child))
\t\t{
\t\t\tcells.push(child);
\t\t}
\t}
\t
\tif (this.allowGaps)
\t{
\t\tcells.sort(mxUtils.bind(this, function(c1, c2)
\t\t{
\t\t\tvar geo1 = this.graph.getCellGeometry(c1);
\t\t\tvar geo2 = this.graph.getCellGeometry(c2);
\t\t\t
\t\t\treturn (this.horizontal) ?
\t\t\t\t((geo1.x == geo2.x) ? 0 : ((geo1.x > geo2.x > 0) ? 1 : -1)) :
\t\t\t\t((geo1.y == geo2.y) ? 0 : ((geo1.y > geo2.y > 0) ? 1 : -1));
\t\t}));
\t}
\t
\treturn cells;
};

/**
 * Function: snap
 * 
 * Snaps the given value to the grid size.
 */
mxStackLayout.prototype.snap = function(value)
{
\tif (this.gridSize != null && this.gridSize > 0)
\t{
\t\tvalue = Math.max(value, this.gridSize);
\t\t
\t\tif (value / this.gridSize > 1)
\t\t{
\t\t\tvar mod = value % this.gridSize;
\t\t\tvalue += mod > this.gridSize / 2 ? (this.gridSize - mod) : -mod;
\t\t}
\t}
\t
\treturn value;
};

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>.
 * 
 * Only children where <isVertexIgnored> returns false are taken into
 * account.
 */
mxStackLayout.prototype.execute = function(parent)
{
\tif (parent != null)
\t{
\t\tvar pgeo = this.getParentSize(parent);
\t\tvar horizontal = this.isHorizontal();
\t\tvar model = this.graph.getModel();\t
\t\tvar fillValue = null;
\t\t
\t\tif (pgeo != null)
\t\t{
\t\t\tfillValue = (horizontal) ? pgeo.height - this.marginTop - this.marginBottom :
\t\t\t\tpgeo.width - this.marginLeft - this.marginRight;
\t\t}
\t\t
\t\tfillValue -= 2 * this.border;
\t\tvar x0 = this.x0 + this.border + this.marginLeft;
\t\tvar y0 = this.y0 + this.border + this.marginTop;
\t\t
\t\t// Handles swimlane start size
\t\tif (this.graph.isSwimlane(parent))
\t\t{
\t\t\t// Uses computed style to get latest 
\t\t\tvar style = this.graph.getCellStyle(parent);
\t\t\tvar start = mxUtils.getNumber(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE);
\t\t\tvar horz = mxUtils.getValue(style, mxConstants.STYLE_HORIZONTAL, true) == 1;

\t\t\tif (pgeo != null)
\t\t\t{
\t\t\t\tif (horz)
\t\t\t\t{
\t\t\t\t\tstart = Math.min(start, pgeo.height);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tstart = Math.min(start, pgeo.width);
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tif (horizontal == horz)
\t\t\t{
\t\t\t\tfillValue -= start;
\t\t\t}

\t\t\tif (horz)
\t\t\t{
\t\t\t\ty0 += start;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tx0 += start;
\t\t\t}
\t\t}

\t\tmodel.beginUpdate();
\t\ttry
\t\t{
\t\t\tvar tmp = 0;
\t\t\tvar last = null;
\t\t\tvar lastValue = 0;
\t\t\tvar lastChild = null;
\t\t\tvar cells = this.getLayoutCells(parent);
\t\t\t
\t\t\tfor (var i = 0; i < cells.length; i++)
\t\t\t{
\t\t\t\tvar child = cells[i];
\t\t\t\tvar geo = model.getGeometry(child);
\t\t\t\t
\t\t\t\tif (geo != null)
\t\t\t\t{
\t\t\t\t\tgeo = geo.clone();
\t\t\t\t\t
\t\t\t\t\tif (this.wrap != null && last != null)
\t\t\t\t\t{
\t\t\t\t\t\tif ((horizontal && last.x + last.width +
\t\t\t\t\t\t\tgeo.width + 2 * this.spacing > this.wrap) ||
\t\t\t\t\t\t\t(!horizontal && last.y + last.height +
\t\t\t\t\t\t\tgeo.height + 2 * this.spacing > this.wrap))
\t\t\t\t\t\t{
\t\t\t\t\t\t\tlast = null;
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tif (horizontal)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\ty0 += tmp + this.spacing;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\telse
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tx0 += tmp + this.spacing;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t
\t\t\t\t\t\t\ttmp = 0;
\t\t\t\t\t\t}\t
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\ttmp = Math.max(tmp, (horizontal) ? geo.height : geo.width);
\t\t\t\t\tvar sw = 0;
\t\t\t\t\t
\t\t\t\t\tif (!this.borderCollapse)
\t\t\t\t\t{
\t\t\t\t\t\tvar childStyle = this.graph.getCellStyle(child);
\t\t\t\t\t\tsw = mxUtils.getNumber(childStyle, mxConstants.STYLE_STROKEWIDTH, 1);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (last != null)
\t\t\t\t\t{
\t\t\t\t\t\tvar temp = lastValue + this.spacing + Math.floor(sw / 2);
\t\t\t\t\t\t
\t\t\t\t\t\tif (horizontal)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo.x = this.snap(((this.allowGaps) ? Math.max(temp, geo.x) :
\t\t\t\t\t\t\t\ttemp) - this.marginLeft) + this.marginLeft;
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo.y = this.snap(((this.allowGaps) ? Math.max(temp, geo.y) :
\t\t\t\t\t\t\t\ttemp) - this.marginTop) + this.marginTop;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t\telse if (!this.keepFirstLocation)
\t\t\t\t\t{
\t\t\t\t\t\tif (horizontal)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo.x = (this.allowGaps && geo.x > x0) ? Math.max(this.snap(geo.x -
\t\t\t\t\t\t\t\tthis.marginLeft) + this.marginLeft, x0) : x0;
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo.y = (this.allowGaps && geo.y > y0) ? Math.max(this.snap(geo.y -
\t\t\t\t\t\t\t\tthis.marginTop) + this.marginTop, y0) : y0;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (horizontal)
\t\t\t\t\t{
\t\t\t\t\t\tgeo.y = y0;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tgeo.x = x0;
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (this.fill && fillValue != null)
\t\t\t\t\t{
\t\t\t\t\t\tif (horizontal)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo.height = fillValue;
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo.width = fillValue;\t\t\t\t\t\t\t\t\t
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (horizontal)
\t\t\t\t\t{
\t\t\t\t\t\tgeo.width = this.snap(geo.width);
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tgeo.height = this.snap(geo.height);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tthis.setChildGeometry(child, geo);
\t\t\t\t\tlastChild = child;
\t\t\t\t\tlast = geo;
\t\t\t\t\t
\t\t\t\t\tif (horizontal)
\t\t\t\t\t{
\t\t\t\t\t\tlastValue = last.x + last.width + Math.floor(sw / 2);
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tlastValue = last.y + last.height + Math.floor(sw / 2);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}

\t\t\tif (this.resizeParent && pgeo != null && last != null && !this.graph.isCellCollapsed(parent))
\t\t\t{
\t\t\t\tthis.updateParentGeometry(parent, pgeo, last);
\t\t\t}
\t\t\telse if (this.resizeLast && pgeo != null && last != null && lastChild != null)
\t\t\t{
\t\t\t\tif (horizontal)
\t\t\t\t{
\t\t\t\t\tlast.width = pgeo.width - last.x - this.spacing - this.marginRight - this.marginLeft;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tlast.height = pgeo.height - last.y - this.spacing - this.marginBottom;
\t\t\t\t}
\t\t\t\t
\t\t\t\tthis.setChildGeometry(lastChild, last);
\t\t\t}
\t\t}
\t\tfinally
\t\t{
\t\t\tmodel.endUpdate();
\t\t}
\t}
};

/**
 * Function: setChildGeometry
 * 
 * Sets the specific geometry to the given child cell.
 * 
 * Parameters:
 * 
 * child - The given child of <mxCell>.
 * geo - The specific geometry of <mxGeometry>.
 */
mxStackLayout.prototype.setChildGeometry = function(child, geo)
{
\tvar geo2 = this.graph.getCellGeometry(child);
\t
\tif (geo2 == null || geo.x != geo2.x || geo.y != geo2.y ||
\t\tgeo.width != geo2.width || geo.height != geo2.height)
\t{
\t\tthis.graph.getModel().setGeometry(child, geo);
\t}
};

/**
 * Function: updateParentGeometry
 * 
 * Updates the geometry of the given parent cell.
 * 
 * Parameters:
 * 
 * parent - The given parent of <mxCell>.
 * pgeo - The new <mxGeometry> for parent.
 * last - The last <mxGeometry>.
 */
mxStackLayout.prototype.updateParentGeometry = function(parent, pgeo, last)
{
\tvar horizontal = this.isHorizontal();
\tvar model = this.graph.getModel();\t

\tvar pgeo2 = pgeo.clone();
\t
\tif (horizontal)
\t{
\t\tvar tmp = last.x + last.width + this.marginRight + this.border;
\t\t
\t\tif (this.resizeParentMax)
\t\t{
\t\t\tpgeo2.width = Math.max(pgeo2.width, tmp);
\t\t}
\t\telse
\t\t{
\t\t\tpgeo2.width = tmp;
\t\t}
\t}
\telse
\t{
\t\tvar tmp = last.y + last.height + this.marginBottom + this.border;
\t\t
\t\tif (this.resizeParentMax)
\t\t{
\t\t\tpgeo2.height = Math.max(pgeo2.height, tmp);
\t\t}
\t\telse
\t\t{
\t\t\tpgeo2.height = tmp;
\t\t}
\t}
\t
\tif (pgeo.x != pgeo2.x || pgeo.y != pgeo2.y ||
\t\tpgeo.width != pgeo2.width || pgeo.height != pgeo2.height)
\t{
\t\tmodel.setGeometry(parent, pgeo2);
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxPartitionLayout
 * 
 * Extends <mxGraphLayout> for partitioning the parent cell vertically or
 * horizontally by filling the complete area with the child cells. A horizontal
 * layout partitions the height of the given parent whereas a a non-horizontal
 * layout partitions the width. If the parent is a layer (that is, a child of
 * the root node), then the current graph size is partitioned. The children do
 * not need to be connected for this layout to work.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxPartitionLayout(graph, true, 10, 20);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxPartitionLayout
 * 
 * Constructs a new stack layout layout for the specified graph,
 * spacing, orientation and offset.
 */
function mxPartitionLayout(graph, horizontal, spacing, border)
{
\tmxGraphLayout.call(this, graph);
\tthis.horizontal = (horizontal != null) ? horizontal : true;
\tthis.spacing = spacing || 0;
\tthis.border = border || 0;
};

/**
 * Extends mxGraphLayout.
 */
mxPartitionLayout.prototype = new mxGraphLayout();
mxPartitionLayout.prototype.constructor = mxPartitionLayout;

/**
 * Variable: horizontal
 * 
 * Boolean indicating the direction in which the space is partitioned.
 * Default is true.
 */
mxPartitionLayout.prototype.horizontal = null;

/**
 * Variable: spacing
 * 
 * Integer that specifies the absolute spacing in pixels between the
 * children. Default is 0.
 */
mxPartitionLayout.prototype.spacing = null;

/**
 * Variable: border
 * 
 * Integer that specifies the absolute inset in pixels for the parent that
 * contains the children. Default is 0.
 */
mxPartitionLayout.prototype.border = null;

/**
 * Variable: resizeVertices
 * 
 * Boolean that specifies if vertices should be resized. Default is true.
 */
mxPartitionLayout.prototype.resizeVertices = true;

/**
 * Function: isHorizontal
 * 
 * Returns <horizontal>.
 */
mxPartitionLayout.prototype.isHorizontal = function()
{
\treturn this.horizontal;
};

/**
 * Function: moveCell
 * 
 * Implements <mxGraphLayout.moveCell>.
 */
mxPartitionLayout.prototype.moveCell = function(cell, x, y)
{
\tvar model = this.graph.getModel();
\tvar parent = model.getParent(cell);
\t
\tif (cell != null &&
\t\tparent != null)
\t{
\t\tvar i = 0;
\t\tvar last = 0;
\t\tvar childCount = model.getChildCount(parent);
\t\t
\t\t// Finds index of the closest swimlane
\t\t// TODO: Take into account the orientation
\t\tfor (i = 0; i < childCount; i++)
\t\t{
\t\t\tvar child = model.getChildAt(parent, i);
\t\t\tvar bounds = this.getVertexBounds(child);
\t\t\t
\t\t\tif (bounds != null)
\t\t\t{
\t\t\t\tvar tmp = bounds.x + bounds.width / 2;
\t\t\t\t
\t\t\t\tif (last < x && tmp > x)
\t\t\t\t{
\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t\t
\t\t\t\tlast = tmp;
\t\t\t}
\t\t}
\t\t
\t\t// Changes child order in parent
\t\tvar idx = parent.getIndex(cell);
\t\tidx = Math.max(0, i - ((i > idx) ? 1 : 0));
\t\t
\t\tmodel.add(parent, cell, idx);
\t}
};

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>. All children where <isVertexIgnored>
 * returns false and <isVertexMovable> returns true are modified.
 */
mxPartitionLayout.prototype.execute = function(parent)
{
\tvar horizontal = this.isHorizontal();
\tvar model = this.graph.getModel();
\tvar pgeo = model.getGeometry(parent);
\t
\t// Handles special case where the parent is either a layer with no
\t// geometry or the current root of the view in which case the size
\t// of the graph's container will be used.
\tif (this.graph.container != null &&
\t\t((pgeo == null &&
\t\tmodel.isLayer(parent)) ||
\t\tparent == this.graph.getView().currentRoot))
\t{
\t\tvar width = this.graph.container.offsetWidth - 1;
\t\tvar height = this.graph.container.offsetHeight - 1;
\t\tpgeo = new mxRectangle(0, 0, width, height);
\t}

\tif (pgeo != null)
\t{
\t\tvar children = [];
\t\tvar childCount = model.getChildCount(parent);
\t\t
\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\tvar child = model.getChildAt(parent, i);
\t\t\t
\t\t\tif (!this.isVertexIgnored(child) &&
\t\t\t\tthis.isVertexMovable(child))
\t\t\t{
\t\t\t\tchildren.push(child);
\t\t\t}
\t\t}
\t\t
\t\tvar n = children.length;

\t\tif (n > 0)
\t\t{
\t\t\tvar x0 = this.border;
\t\t\tvar y0 = this.border;
\t\t\tvar other = (horizontal) ? pgeo.height : pgeo.width;
\t\t\tother -= 2 * this.border;

\t\t\tvar size = (this.graph.isSwimlane(parent)) ?
\t\t\t\tthis.graph.getStartSize(parent) :
\t\t\t\tnew mxRectangle();

\t\t\tother -= (horizontal) ? size.height : size.width;
\t\t\tx0 = x0 + size.width;
\t\t\ty0 = y0 + size.height;

\t\t\tvar tmp = this.border + (n - 1) * this.spacing;
\t\t\tvar value = (horizontal) ?
\t\t\t\t((pgeo.width - x0 - tmp) / n) :
\t\t\t\t((pgeo.height - y0 - tmp) / n);
\t\t\t
\t\t\t// Avoids negative values, that is values where the sum of the
\t\t\t// spacing plus the border is larger then the available space
\t\t\tif (value > 0)
\t\t\t{
\t\t\t\tmodel.beginUpdate();
\t\t\t\ttry
\t\t\t\t{
\t\t\t\t\tfor (var i = 0; i < n; i++)
\t\t\t\t\t{
\t\t\t\t\t\tvar child = children[i];
\t\t\t\t\t\tvar geo = model.getGeometry(child);
\t\t\t\t\t
\t\t\t\t\t\tif (geo != null)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tgeo = geo.clone();
\t\t\t\t\t\t\tgeo.x = x0;
\t\t\t\t\t\t\tgeo.y = y0;

\t\t\t\t\t\t\tif (horizontal)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tif (this.resizeVertices)
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tgeo.width = value;
\t\t\t\t\t\t\t\t\tgeo.height = other;
\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t\t
\t\t\t\t\t\t\t\tx0 += value + this.spacing;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\telse
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tif (this.resizeVertices)
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tgeo.height = value;
\t\t\t\t\t\t\t\t\tgeo.width = other;
\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t\t
\t\t\t\t\t\t\t\ty0 += value + this.spacing;
\t\t\t\t\t\t\t}

\t\t\t\t\t\t\tmodel.setGeometry(child, geo);
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\tfinally
\t\t\t\t{
\t\t\t\t\tmodel.endUpdate();
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2018, JGraph Ltd
 * Copyright (c) 2006-2018, Gaudenz Alder
 */
/**
 * Class: mxCompactTreeLayout
 * 
 * Extends <mxGraphLayout> to implement a compact tree (Moen) algorithm. This
 * layout is suitable for graphs that have no cycles (trees). Vertices that are
 * not connected to the tree will be ignored by this layout.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxCompactTreeLayout(graph);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxCompactTreeLayout
 * 
 * Constructs a new compact tree layout for the specified graph
 * and orientation.
 */
function mxCompactTreeLayout(graph, horizontal, invert)
{
\tmxGraphLayout.call(this, graph);
\tthis.horizontal = (horizontal != null) ? horizontal : true;
\tthis.invert = (invert != null) ? invert : false;
};

/**
 * Extends mxGraphLayout.
 */
mxCompactTreeLayout.prototype = new mxGraphLayout();
mxCompactTreeLayout.prototype.constructor = mxCompactTreeLayout;

/**
 * Variable: horizontal
 *
 * Specifies the orientation of the layout. Default is true.
 */
mxCompactTreeLayout.prototype.horizontal = null;\t 

/**
 * Variable: invert
 *
 * Specifies if edge directions should be inverted. Default is false.
 */
mxCompactTreeLayout.prototype.invert = null;\t 

/**
 * Variable: resizeParent
 * 
 * If the parents should be resized to match the width/height of the
 * children. Default is true.
 */
mxCompactTreeLayout.prototype.resizeParent = true;

/**
 * Variable: maintainParentLocation
 * 
 * Specifies if the parent location should be maintained, so that the
 * top, left corner stays the same before and after execution of
 * the layout. Default is false for backwards compatibility.
 */
mxCompactTreeLayout.prototype.maintainParentLocation = false;

/**
 * Variable: groupPadding
 * 
 * Padding added to resized parents. Default is 10.
 */
mxCompactTreeLayout.prototype.groupPadding = 10;

/**
 * Variable: groupPaddingTop
 * 
 * Top padding added to resized parents. Default is 0.
 */
mxCompactTreeLayout.prototype.groupPaddingTop = 0;

/**
 * Variable: groupPaddingRight
 * 
 * Right padding added to resized parents. Default is 0.
 */
mxCompactTreeLayout.prototype.groupPaddingRight = 0;

/**
 * Variable: groupPaddingBottom
 * 
 * Bottom padding added to resized parents. Default is 0.
 */
mxCompactTreeLayout.prototype.groupPaddingBottom = 0;

/**
 * Variable: groupPaddingLeft
 * 
 * Left padding added to resized parents. Default is 0.
 */
mxCompactTreeLayout.prototype.groupPaddingLeft = 0;

/**
 * Variable: parentsChanged
 *
 * A set of the parents that need updating based on children
 * process as part of the layout.
 */
mxCompactTreeLayout.prototype.parentsChanged = null;

/**
 * Variable: moveTree
 * 
 * Specifies if the tree should be moved to the top, left corner
 * if it is inside a top-level layer. Default is false.
 */
mxCompactTreeLayout.prototype.moveTree = false;

/**
 * Variable: visited
 * 
 * Specifies if the tree should be moved to the top, left corner
 * if it is inside a top-level layer. Default is false.
 */
mxCompactTreeLayout.prototype.visited = null;

/**
 * Variable: levelDistance
 *
 * Holds the levelDistance. Default is 10.
 */
mxCompactTreeLayout.prototype.levelDistance = 10;

/**
 * Variable: nodeDistance
 *
 * Holds the nodeDistance. Default is 20.
 */
mxCompactTreeLayout.prototype.nodeDistance = 20;

/**
 * Variable: resetEdges
 * 
 * Specifies if all edge points of traversed edges should be removed.
 * Default is true.
 */
mxCompactTreeLayout.prototype.resetEdges = true;

/**
 * Variable: prefHozEdgeSep
 * 
 * The preferred horizontal distance between edges exiting a vertex.
 */
mxCompactTreeLayout.prototype.prefHozEdgeSep = 5;

/**
 * Variable: prefVertEdgeOff
 * 
 * The preferred vertical offset between edges exiting a vertex.
 */
mxCompactTreeLayout.prototype.prefVertEdgeOff = 4;

/**
 * Variable: minEdgeJetty
 * 
 * The minimum distance for an edge jetty from a vertex.
 */
mxCompactTreeLayout.prototype.minEdgeJetty = 8;

/**
 * Variable: channelBuffer
 * 
 * The size of the vertical buffer in the center of inter-rank channels
 * where edge control points should not be placed.
 */
mxCompactTreeLayout.prototype.channelBuffer = 4;

/**
 * Variable: edgeRouting
 * 
 * Whether or not to apply the internal tree edge routing.
 */
mxCompactTreeLayout.prototype.edgeRouting = true;

/**
 * Variable: sortEdges
 * 
 * Specifies if edges should be sorted according to the order of their
 * opposite terminal cell in the model.
 */
mxCompactTreeLayout.prototype.sortEdges = false;

/**
 * Variable: alignRanks
 * 
 * Whether or not the tops of cells in each rank should be aligned
 * across the rank
 */
mxCompactTreeLayout.prototype.alignRanks = false;

/**
 * Variable: maxRankHeight
 * 
 * An array of the maximum height of cells (relative to the layout direction)
 * per rank
 */
mxCompactTreeLayout.prototype.maxRankHeight = null;

/**
 * Variable: root
 * 
 * The cell to use as the root of the tree
 */
mxCompactTreeLayout.prototype.root = null;

/**
 * Variable: node
 * 
 * The internal node representation of the root cell. Do not set directly
 * , this value is only exposed to assist with post-processing functionality
 */
mxCompactTreeLayout.prototype.node = null;

/**
 * Function: isVertexIgnored
 * 
 * Returns a boolean indicating if the given <mxCell> should be ignored as a
 * vertex. This returns true if the cell has no connections.
 * 
 * Parameters:
 * 
 * vertex - <mxCell> whose ignored state should be returned.
 */
mxCompactTreeLayout.prototype.isVertexIgnored = function(vertex)
{
\treturn mxGraphLayout.prototype.isVertexIgnored.apply(this, arguments) ||
\t\tthis.graph.getConnections(vertex).length == 0;
};

/**
 * Function: isHorizontal
 * 
 * Returns <horizontal>.
 */
mxCompactTreeLayout.prototype.isHorizontal = function()
{
\treturn this.horizontal;
};

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>.
 * 
 * If the parent has any connected edges, then it is used as the root of
 * the tree. Else, <mxGraph.findTreeRoots> will be used to find a suitable
 * root node within the set of children of the given parent.
 * 
 * Parameters:
 * 
 * parent - <mxCell> whose children should be laid out.
 * root - Optional <mxCell> that will be used as the root of the tree.
 * Overrides <root> if specified.
 */
mxCompactTreeLayout.prototype.execute = function(parent, root)
{
\tthis.parent = parent;
\tvar model = this.graph.getModel();

\tif (root == null)
\t{
\t\t// Takes the parent as the root if it has outgoing edges
\t\tif (this.graph.getEdges(parent, model.getParent(parent),
\t\t\tthis.invert, !this.invert, false).length > 0)
\t\t{
\t\t\tthis.root = parent;
\t\t}
\t\t
\t\t// Tries to find a suitable root in the parent's
\t\t// children
\t\telse
\t\t{
\t\t\tvar roots = this.graph.findTreeRoots(parent, true, this.invert);
\t\t\t
\t\t\tif (roots.length > 0)
\t\t\t{
\t\t\t\tfor (var i = 0; i < roots.length; i++)
\t\t\t\t{
\t\t\t\t\tif (!this.isVertexIgnored(roots[i]) &&
\t\t\t\t\t\tthis.graph.getEdges(roots[i], null,
\t\t\t\t\t\t\tthis.invert, !this.invert, false).length > 0)
\t\t\t\t\t{
\t\t\t\t\t\tthis.root = roots[i];
\t\t\t\t\t\tbreak;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\tthis.root = root;
\t}
\t
\tif (this.root != null)
\t{
\t\tif (this.resizeParent)
\t\t{
\t\t\tthis.parentsChanged = new Object();
\t\t}
\t\telse
\t\t{
\t\t\tthis.parentsChanged = null;
\t\t}

\t\t//  Maintaining parent location
\t\tthis.parentX = null;
\t\tthis.parentY = null;
\t\t
\t\tif (parent != this.root && model.isVertex(parent) != null && this.maintainParentLocation)
\t\t{
\t\t\tvar geo = this.graph.getCellGeometry(parent);
\t\t\t
\t\t\tif (geo != null)
\t\t\t{
\t\t\t\tthis.parentX = geo.x;
\t\t\t\tthis.parentY = geo.y;
\t\t\t}
\t\t}
\t\t
\t\tmodel.beginUpdate();
\t\t
\t\ttry
\t\t{
\t\t\tthis.visited = new Object();
\t\t\tthis.node = this.dfs(this.root, parent);
\t\t\t
\t\t\tif (this.alignRanks)
\t\t\t{
\t\t\t\tthis.maxRankHeight = [];
\t\t\t\tthis.findRankHeights(this.node, 0);
\t\t\t\tthis.setCellHeights(this.node, 0);
\t\t\t}
\t\t\t
\t\t\tif (this.node != null)
\t\t\t{
\t\t\t\tthis.layout(this.node);
\t\t\t\tvar x0 = this.graph.gridSize;
\t\t\t\tvar y0 = x0;
\t\t\t\t
\t\t\t\tif (!this.moveTree)
\t\t\t\t{
\t\t\t\t\tvar g = this.getVertexBounds(this.root);
\t\t\t\t\t
\t\t\t\t\tif (g != null)
\t\t\t\t\t{
\t\t\t\t\t\tx0 = g.x;
\t\t\t\t\t\ty0 = g.y;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tvar bounds = null;
\t\t\t\t
\t\t\t\tif (this.isHorizontal())
\t\t\t\t{
\t\t\t\t\tbounds = this.horizontalLayout(this.node, x0, y0);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tbounds = this.verticalLayout(this.node, null, x0, y0);
\t\t\t\t}

\t\t\t\tif (bounds != null)
\t\t\t\t{
\t\t\t\t\tvar dx = 0;
\t\t\t\t\tvar dy = 0;

\t\t\t\t\tif (bounds.x < 0)
\t\t\t\t\t{
\t\t\t\t\t\tdx = Math.abs(x0 - bounds.x);
\t\t\t\t\t}

\t\t\t\t\tif (bounds.y < 0)
\t\t\t\t\t{
\t\t\t\t\t\tdy = Math.abs(y0 - bounds.y);\t
\t\t\t\t\t}

\t\t\t\t\tif (dx != 0 || dy != 0)
\t\t\t\t\t{
\t\t\t\t\t\tthis.moveNode(this.node, dx, dy);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (this.resizeParent)
\t\t\t\t\t{
\t\t\t\t\t\tthis.adjustParents();
\t\t\t\t\t}

\t\t\t\t\tif (this.edgeRouting)
\t\t\t\t\t{
\t\t\t\t\t\t// Iterate through all edges setting their positions
\t\t\t\t\t\tthis.localEdgeProcessing(this.node);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Maintaining parent location
\t\t\t\tif (this.parentX != null && this.parentY != null)
\t\t\t\t{
\t\t\t\t\tvar geo = this.graph.getCellGeometry(parent);
\t\t\t\t\t
\t\t\t\t\tif (geo != null)
\t\t\t\t\t{
\t\t\t\t\t\tgeo = geo.clone();
\t\t\t\t\t\tgeo.x = this.parentX;
\t\t\t\t\t\tgeo.y = this.parentY;
\t\t\t\t\t\tmodel.setGeometry(parent, geo);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t\tfinally
\t\t{
\t\t\tmodel.endUpdate();
\t\t}
\t}
};

/**
 * Function: moveNode
 * 
 * Moves the specified node and all of its children by the given amount.
 */
mxCompactTreeLayout.prototype.moveNode = function(node, dx, dy)
{
\tnode.x += dx;
\tnode.y += dy;
\tthis.apply(node);
\t
\tvar child = node.child;
\t
\twhile (child != null)
\t{
\t\tthis.moveNode(child, dx, dy);
\t\tchild = child.next;
\t}
};


/**
 * Function: sortOutgoingEdges
 * 
 * Called if <sortEdges> is true to sort the array of outgoing edges in place.
 */
mxCompactTreeLayout.prototype.sortOutgoingEdges = function(source, edges)
{
\tvar lookup = new mxDictionary();
\t
\tedges.sort(function(e1, e2)
\t{
\t\tvar end1 = e1.getTerminal(e1.getTerminal(false) == source);
\t\tvar p1 = lookup.get(end1);
\t\t
\t\tif (p1 == null)
\t\t{
\t\t\tp1 = mxCellPath.create(end1).split(mxCellPath.PATH_SEPARATOR);
\t\t\tlookup.put(end1, p1);
\t\t}

\t\tvar end2 = e2.getTerminal(e2.getTerminal(false) == source);
\t\tvar p2 = lookup.get(end2);
\t\t
\t\tif (p2 == null)
\t\t{
\t\t\tp2 = mxCellPath.create(end2).split(mxCellPath.PATH_SEPARATOR);
\t\t\tlookup.put(end2, p2);
\t\t}

\t\treturn mxCellPath.compare(p1, p2);
\t});
};

/**
 * Function: findRankHeights
 * 
 * Stores the maximum height (relative to the layout
 * direction) of cells in each rank
 */
mxCompactTreeLayout.prototype.findRankHeights = function(node, rank)
{
\tif (this.maxRankHeight[rank] == null || this.maxRankHeight[rank] < node.height)
\t{
\t\tthis.maxRankHeight[rank] = node.height;
\t}

\tvar child = node.child;
\t
\twhile (child != null)
\t{
\t\tthis.findRankHeights(child, rank + 1);
\t\tchild = child.next;
\t}
};

/**
 * Function: setCellHeights
 * 
 * Set the cells heights (relative to the layout
 * direction) when the tops of each rank are to be aligned
 */
mxCompactTreeLayout.prototype.setCellHeights = function(node, rank)
{
\tif (this.maxRankHeight[rank] != null && this.maxRankHeight[rank] > node.height)
\t{
\t\tnode.height = this.maxRankHeight[rank];
\t}

\tvar child = node.child;
\t
\twhile (child != null)
\t{
\t\tthis.setCellHeights(child, rank + 1);
\t\tchild = child.next;
\t}
};

/**
 * Function: dfs
 * 
 * Does a depth first search starting at the specified cell.
 * Makes sure the specified parent is never left by the
 * algorithm.
 */
mxCompactTreeLayout.prototype.dfs = function(cell, parent)
{
\tvar id = mxCellPath.create(cell);
\tvar node = null;
\t
\tif (cell != null && this.visited[id] == null && !this.isVertexIgnored(cell))
\t{
\t\tthis.visited[id] = cell;
\t\tnode = this.createNode(cell);

\t\tvar model = this.graph.getModel();
\t\tvar prev = null;
\t\tvar out = this.graph.getEdges(cell, parent, this.invert, !this.invert, false, true);
\t\tvar view = this.graph.getView();
\t\t
\t\tif (this.sortEdges)
\t\t{
\t\t\tthis.sortOutgoingEdges(cell, out);
\t\t}

\t\tfor (var i = 0; i < out.length; i++)
\t\t{
\t\t\tvar edge = out[i];
\t\t\t
\t\t\tif (!this.isEdgeIgnored(edge))
\t\t\t{
\t\t\t\t// Resets the points on the traversed edge
\t\t\t\tif (this.resetEdges)
\t\t\t\t{
\t\t\t\t\tthis.setEdgePoints(edge, null);
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (this.edgeRouting)
\t\t\t\t{
\t\t\t\t\tthis.setEdgeStyleEnabled(edge, false);
\t\t\t\t\tthis.setEdgePoints(edge, null);
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Checks if terminal in same swimlane
\t\t\t\tvar state = view.getState(edge);
\t\t\t\tvar target = (state != null) ? state.getVisibleTerminal(this.invert) : view.getVisibleTerminal(edge, this.invert);
\t\t\t\tvar tmp = this.dfs(target, parent);
\t\t\t\t
\t\t\t\tif (tmp != null && model.getGeometry(target) != null)
\t\t\t\t{
\t\t\t\t\tif (prev == null)
\t\t\t\t\t{
\t\t\t\t\t\tnode.child = tmp;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tprev.next = tmp;
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tprev = tmp;
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\t
\treturn node;
};

/**
 * Function: layout
 * 
 * Starts the actual compact tree layout algorithm
 * at the given node.
 */
mxCompactTreeLayout.prototype.layout = function(node)
{
\tif (node != null)
\t{
\t\tvar child = node.child;
\t\t
\t\twhile (child != null)
\t\t{
\t\t\tthis.layout(child);
\t\t\tchild = child.next;
\t\t}
\t\t
\t\tif (node.child != null)
\t\t{
\t\t\tthis.attachParent(node, this.join(node));
\t\t}
\t\telse
\t\t{
\t\t\tthis.layoutLeaf(node);
\t\t}
\t}
};

/**
 * Function: horizontalLayout
 */
mxCompactTreeLayout.prototype.horizontalLayout = function(node, x0, y0, bounds)
{
\tnode.x += x0 + node.offsetX;
\tnode.y += y0 + node.offsetY;
\tbounds = this.apply(node, bounds);
\tvar child = node.child;
\t
\tif (child != null)
\t{
\t\tbounds = this.horizontalLayout(child, node.x, node.y, bounds);
\t\tvar siblingOffset = node.y + child.offsetY;
\t\tvar s = child.next;
\t\t
\t\twhile (s != null)
\t\t{
\t\t\tbounds = this.horizontalLayout(s, node.x + child.offsetX, siblingOffset, bounds);
\t\t\tsiblingOffset += s.offsetY;
\t\t\ts = s.next;
\t\t}
\t}
\t
\treturn bounds;
};
\t
/**
 * Function: verticalLayout
 */
mxCompactTreeLayout.prototype.verticalLayout = function(node, parent, x0, y0, bounds)
{
\tnode.x += x0 + node.offsetY;
\tnode.y += y0 + node.offsetX;
\tbounds = this.apply(node, bounds);
\tvar child = node.child;
\t
\tif (child != null)
\t{
\t\tbounds = this.verticalLayout(child, node, node.x, node.y, bounds);
\t\tvar siblingOffset = node.x + child.offsetY;
\t\tvar s = child.next;
\t\t
\t\twhile (s != null)
\t\t{
\t\t\tbounds = this.verticalLayout(s, node, siblingOffset, node.y + child.offsetX, bounds);
\t\t\tsiblingOffset += s.offsetY;
\t\t\ts = s.next;
\t\t}
\t}
\t
\treturn bounds;
};

/**
 * Function: attachParent
 */
mxCompactTreeLayout.prototype.attachParent = function(node, height)
{
\tvar x = this.nodeDistance + this.levelDistance;
\tvar y2 = (height - node.width) / 2 - this.nodeDistance;
\tvar y1 = y2 + node.width + 2 * this.nodeDistance - height;
\t
\tnode.child.offsetX = x + node.height;
\tnode.child.offsetY = y1;
\t
\tnode.contour.upperHead = this.createLine(node.height, 0,
\t\tthis.createLine(x, y1, node.contour.upperHead));
\tnode.contour.lowerHead = this.createLine(node.height, 0,
\t\tthis.createLine(x, y2, node.contour.lowerHead));
};

/**
 * Function: layoutLeaf
 */
mxCompactTreeLayout.prototype.layoutLeaf = function(node)
{
\tvar dist = 2 * this.nodeDistance;
\t
\tnode.contour.upperTail = this.createLine(
\t\tnode.height + dist, 0);
\tnode.contour.upperHead = node.contour.upperTail;
\tnode.contour.lowerTail = this.createLine(
\t\t0, -node.width - dist);
\tnode.contour.lowerHead = this.createLine(
\t\tnode.height + dist, 0, node.contour.lowerTail);
};

/**
 * Function: join
 */
mxCompactTreeLayout.prototype.join = function(node)
{
\tvar dist = 2 * this.nodeDistance;
\t
\tvar child = node.child;
\tnode.contour = child.contour;
\tvar h = child.width + dist;
\tvar sum = h;
\tchild = child.next;
\t
\twhile (child != null)
\t{
\t\tvar d = this.merge(node.contour, child.contour);
\t\tchild.offsetY = d + h;
\t\tchild.offsetX = 0;
\t\th = child.width + dist;
\t\tsum += d + h;
\t\tchild = child.next;
\t}
\t
\treturn sum;
};

/**
 * Function: merge
 */
mxCompactTreeLayout.prototype.merge = function(p1, p2)
{
\tvar x = 0;
\tvar y = 0;
\tvar total = 0;
\t
\tvar upper = p1.lowerHead;
\tvar lower = p2.upperHead;
\t
\twhile (lower != null && upper != null)
\t{
\t\tvar d = this.offset(x, y, lower.dx, lower.dy,
\t\t\tupper.dx, upper.dy);
\t\ty += d;
\t\ttotal += d;
\t\t
\t\tif (x + lower.dx <= upper.dx)
\t\t{
\t\t\tx += lower.dx;
\t\t\ty += lower.dy;
\t\t\tlower = lower.next;
\t\t}
\t\telse
\t\t{\t\t\t\t
\t\t\tx -= upper.dx;
\t\t\ty -= upper.dy;
\t\t\tupper = upper.next;
\t\t}
\t}
\t
\tif (lower != null)
\t{
\t\tvar b = this.bridge(p1.upperTail, 0, 0, lower, x, y);
\t\tp1.upperTail = (b.next != null) ? p2.upperTail : b;
\t\tp1.lowerTail = p2.lowerTail;
\t}
\telse
\t{
\t\tvar b = this.bridge(p2.lowerTail, x, y, upper, 0, 0);
\t\t
\t\tif (b.next == null)
\t\t{
\t\t\tp1.lowerTail = b;
\t\t}
\t}
\t
\tp1.lowerHead = p2.lowerHead;
\t
\treturn total;
};

/**
 * Function: offset
 */
mxCompactTreeLayout.prototype.offset = function(p1, p2, a1, a2, b1, b2)
{
\tvar d = 0;
\t
\tif (b1 <= p1 || p1 + a1 <= 0)
\t{
\t\treturn 0;
\t}

\tvar t = b1 * a2 - a1 * b2;
\t
\tif (t > 0)
\t{
\t\tif (p1 < 0)
\t\t{
\t\t\tvar s = p1 * a2;
\t\t\td = s / a1 - p2;
\t\t}
\t\telse if (p1 > 0)
\t\t{
\t\t\tvar s = p1 * b2;
\t\t\td = s / b1 - p2;
\t\t}
\t\telse
\t\t{
\t\t\td = -p2;
\t\t}
\t}
\telse if (b1 < p1 + a1)
\t{
\t\tvar s = (b1 - p1) * a2;
\t\td = b2 - (p2 + s / a1);
\t}
\telse if (b1 > p1 + a1)
\t{
\t\tvar s = (a1 + p1) * b2;
\t\td = s / b1 - (p2 + a2);
\t}
\telse
\t{
\t\td = b2 - (p2 + a2);
\t}

\tif (d > 0)
\t{
\t\treturn d;
\t}
\telse
\t{
\t\treturn 0;
\t}
};

/**
 * Function: bridge
 */
mxCompactTreeLayout.prototype.bridge = function(line1, x1, y1, line2, x2, y2)
{
\tvar dx = x2 + line2.dx - x1;
\tvar dy = 0;
\tvar s = 0;
\t
\tif (line2.dx == 0)
\t{
\t\tdy = line2.dy;
\t}
\telse
\t{
\t\ts = dx * line2.dy;
\t\tdy = s / line2.dx;
\t}
\t
\tvar r = this.createLine(dx, dy, line2.next);
\tline1.next = this.createLine(0, y2 + line2.dy - dy - y1, r);
\t
\treturn r;
};

/**
 * Function: createNode
 */
mxCompactTreeLayout.prototype.createNode = function(cell)
{
\tvar node = new Object();
\tnode.cell = cell;
\tnode.x = 0;
\tnode.y = 0;
\tnode.width = 0;
\tnode.height = 0;
\t
\tvar geo = this.getVertexBounds(cell);
\t
\tif (geo != null)
\t{
\t\tif (this.isHorizontal())
\t\t{
\t\t\tnode.width = geo.height;
\t\t\tnode.height = geo.width;\t\t\t
\t\t}
\t\telse
\t\t{
\t\t\tnode.width = geo.width;
\t\t\tnode.height = geo.height;
\t\t}
\t}
\t
\tnode.offsetX = 0;
\tnode.offsetY = 0;
\tnode.contour = new Object();
\t
\treturn node;
};

/**
 * Function: apply
 */
mxCompactTreeLayout.prototype.apply = function(node, bounds)
{
\tvar model = this.graph.getModel();
\tvar cell = node.cell;
\tvar g = model.getGeometry(cell);

\tif (cell != null && g != null)
\t{
\t\tif (this.isVertexMovable(cell))
\t\t{
\t\t\tg = this.setVertexLocation(cell, node.x, node.y);
\t\t\t
\t\t\tif (this.resizeParent)
\t\t\t{
\t\t\t\tvar parent = model.getParent(cell);
\t\t\t\tvar id = mxCellPath.create(parent);
\t\t\t\t
\t\t\t\t// Implements set semantic
\t\t\t\tif (this.parentsChanged[id] == null)
\t\t\t\t{
\t\t\t\t\tthis.parentsChanged[id] = parent;\t\t\t\t\t
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tif (bounds == null)
\t\t{
\t\t\tbounds = new mxRectangle(g.x, g.y, g.width, g.height);
\t\t}
\t\telse
\t\t{
\t\t\tbounds = new mxRectangle(Math.min(bounds.x, g.x),
\t\t\t\tMath.min(bounds.y, g.y),
\t\t\t\tMath.max(bounds.x + bounds.width, g.x + g.width),
\t\t\t\tMath.max(bounds.y + bounds.height, g.y + g.height));
\t\t}
\t}
\t
\treturn bounds;
};

/**
 * Function: createLine
 */
mxCompactTreeLayout.prototype.createLine = function(dx, dy, next)
{
\tvar line = new Object();
\tline.dx = dx;
\tline.dy = dy;
\tline.next = next;
\t
\treturn line;
};

/**
 * Function: adjustParents
 * 
 * Adjust parent cells whose child geometries have changed. The default 
 * implementation adjusts the group to just fit around the children with 
 * a padding.
 */
mxCompactTreeLayout.prototype.adjustParents = function()
{
\tvar tmp = [];
\t
\tfor (var id in this.parentsChanged)
\t{
\t\ttmp.push(this.parentsChanged[id]);
\t}
\t
\tthis.arrangeGroups(mxUtils.sortCells(tmp, true), this.groupPadding, this.groupPaddingTop,
\t\tthis.groupPaddingRight, this.groupPaddingBottom, this.groupPaddingLeft);
};

/**
 * Function: localEdgeProcessing
 *
 * Moves the specified node and all of its children by the given amount.
 */
mxCompactTreeLayout.prototype.localEdgeProcessing = function(node)
{
\tthis.processNodeOutgoing(node);
\tvar child = node.child;

\twhile (child != null)
\t{
\t\tthis.localEdgeProcessing(child);
\t\tchild = child.next;
\t}
};

/**
 * Function: processNodeOutgoing
 *
 * Separates the x position of edges as they connect to vertices
 */
mxCompactTreeLayout.prototype.processNodeOutgoing = function(node)
{
\tvar child = node.child;
\tvar parentCell = node.cell;

\tvar childCount = 0;
\tvar sortedCells = [];

\twhile (child != null)
\t{
\t\tchildCount++;

\t\tvar sortingCriterion = child.x;

\t\tif (this.horizontal)
\t\t{
\t\t\tsortingCriterion = child.y;
\t\t}

\t\tsortedCells.push(new WeightedCellSorter(child, sortingCriterion));
\t\tchild = child.next;
\t}

\tsortedCells.sort(WeightedCellSorter.prototype.compare);

\tvar availableWidth = node.width;

\tvar requiredWidth = (childCount + 1) * this.prefHozEdgeSep;

\t// Add a buffer on the edges of the vertex if the edge count allows
\tif (availableWidth > requiredWidth + (2 * this.prefHozEdgeSep))
\t{
\t\tavailableWidth -= 2 * this.prefHozEdgeSep;
\t}

\tvar edgeSpacing = availableWidth / childCount;

\tvar currentXOffset = edgeSpacing / 2.0;

\tif (availableWidth > requiredWidth + (2 * this.prefHozEdgeSep))
\t{
\t\tcurrentXOffset += this.prefHozEdgeSep;
\t}

\tvar currentYOffset = this.minEdgeJetty - this.prefVertEdgeOff;
\tvar maxYOffset = 0;

\tvar parentBounds = this.getVertexBounds(parentCell);
\tchild = node.child;

\tfor (var j = 0; j < sortedCells.length; j++)
\t{
\t\tvar childCell = sortedCells[j].cell.cell;
\t\tvar childBounds = this.getVertexBounds(childCell);

\t\tvar edges = this.graph.getEdgesBetween(parentCell,
\t\t\t\tchildCell, false);
\t\t
\t\tvar newPoints = [];
\t\tvar x = 0;
\t\tvar y = 0;

\t\tfor (var i = 0; i < edges.length; i++)
\t\t{
\t\t\tif (this.horizontal)
\t\t\t{
\t\t\t\t// Use opposite co-ords, calculation was done for 
\t\t\t\t// 
\t\t\t\tx = parentBounds.x + parentBounds.width;
\t\t\t\ty = parentBounds.y + currentXOffset;
\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\tx = parentBounds.x + parentBounds.width
\t\t\t\t\t\t+ currentYOffset;
\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\ty = childBounds.y + childBounds.height / 2.0;
\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\tthis.setEdgePoints(edges[i], newPoints);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tx = parentBounds.x + currentXOffset;
\t\t\t\ty = parentBounds.y + parentBounds.height;
\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\ty = parentBounds.y + parentBounds.height
\t\t\t\t\t\t+ currentYOffset;
\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\tx = childBounds.x + childBounds.width / 2.0;
\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\tthis.setEdgePoints(edges[i], newPoints);
\t\t\t}
\t\t}

\t\tif (j < childCount / 2)
\t\t{
\t\t\tcurrentYOffset += this.prefVertEdgeOff;
\t\t}
\t\telse if (j > childCount / 2)
\t\t{
\t\t\tcurrentYOffset -= this.prefVertEdgeOff;
\t\t}
\t\t// Ignore the case if equals, this means the second of 2
\t\t// jettys with the same y (even number of edges)

\t\t//\t\t\t\t\t\t\t\tpos[k * 2] = currentX;
\t\tcurrentXOffset += edgeSpacing;
\t\t//\t\t\t\t\t\t\t\tpos[k * 2 + 1] = currentYOffset;

\t\tmaxYOffset = Math.max(maxYOffset, currentYOffset);
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxRadialTreeLayout
 * 
 * Extends <mxGraphLayout> to implement a radial tree algorithm. This
 * layout is suitable for graphs that have no cycles (trees). Vertices that are
 * not connected to the tree will be ignored by this layout.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxRadialTreeLayout(graph);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxRadialTreeLayout
 * 
 * Constructs a new radial tree layout for the specified graph
 */
function mxRadialTreeLayout(graph)
{
\tmxCompactTreeLayout.call(this, graph , false);
};

/**
 * Extends mxGraphLayout.
 */
mxUtils.extend(mxRadialTreeLayout, mxCompactTreeLayout);

/**
 * Variable: angleOffset
 *
 * The initial offset to compute the angle position.
 */
mxRadialTreeLayout.prototype.angleOffset = 0.5;

/**
 * Variable: rootx
 *
 * The X co-ordinate of the root cell
 */
mxRadialTreeLayout.prototype.rootx = 0;

/**
 * Variable: rooty
 *
 * The Y co-ordinate of the root cell
 */
mxRadialTreeLayout.prototype.rooty = 0;

/**
 * Variable: levelDistance
 *
 * Holds the levelDistance. Default is 120.
 */
mxRadialTreeLayout.prototype.levelDistance = 120;

/**
 * Variable: nodeDistance
 *
 * Holds the nodeDistance. Default is 10.
 */
mxRadialTreeLayout.prototype.nodeDistance = 10;

/**
 * Variable: autoRadius
 * 
 * Specifies if the radios should be computed automatically
 */
mxRadialTreeLayout.prototype.autoRadius = false;

/**
 * Variable: sortEdges
 * 
 * Specifies if edges should be sorted according to the order of their
 * opposite terminal cell in the model.
 */
mxRadialTreeLayout.prototype.sortEdges = false;

/**
 * Variable: rowMinX
 * 
 * Array of leftmost x coordinate of each row
 */
mxRadialTreeLayout.prototype.rowMinX = [];

/**
 * Variable: rowMaxX
 * 
 * Array of rightmost x coordinate of each row
 */
mxRadialTreeLayout.prototype.rowMaxX = [];

/**
 * Variable: rowMinCenX
 * 
 * Array of x coordinate of leftmost vertex of each row
 */
mxRadialTreeLayout.prototype.rowMinCenX = [];

/**
 * Variable: rowMaxCenX
 * 
 * Array of x coordinate of rightmost vertex of each row
 */
mxRadialTreeLayout.prototype.rowMaxCenX = [];

/**
 * Variable: rowRadi
 * 
 * Array of y deltas of each row behind root vertex, also the radius in the tree
 */
mxRadialTreeLayout.prototype.rowRadi = [];

/**
 * Variable: row
 * 
 * Array of vertices on each row
 */
mxRadialTreeLayout.prototype.row = [];

/**
 * Function: isVertexIgnored
 * 
 * Returns a boolean indicating if the given <mxCell> should be ignored as a
 * vertex. This returns true if the cell has no connections.
 * 
 * Parameters:
 * 
 * vertex - <mxCell> whose ignored state should be returned.
 */
mxRadialTreeLayout.prototype.isVertexIgnored = function(vertex)
{
\treturn mxGraphLayout.prototype.isVertexIgnored.apply(this, arguments) ||
\t\tthis.graph.getConnections(vertex).length == 0;
};

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>.
 * 
 * If the parent has any connected edges, then it is used as the root of
 * the tree. Else, <mxGraph.findTreeRoots> will be used to find a suitable
 * root node within the set of children of the given parent.
 * 
 * Parameters:
 * 
 * parent - <mxCell> whose children should be laid out.
 * root - Optional <mxCell> that will be used as the root of the tree.
 */
mxRadialTreeLayout.prototype.execute = function(parent, root)
{
\tthis.parent = parent;
\t
\tthis.useBoundingBox = false;
\tthis.edgeRouting = false;
\t//this.horizontal = false;

\tmxCompactTreeLayout.prototype.execute.apply(this, arguments);
\t
\tvar bounds = null;
\tvar rootBounds = this.getVertexBounds(this.root);
\tthis.centerX = rootBounds.x + rootBounds.width / 2;
\tthis.centerY = rootBounds.y + rootBounds.height / 2;

\t// Calculate the bounds of the involved vertices directly from the values set in the compact tree
\tfor (var vertex in this.visited)
\t{
\t\tvar vertexBounds = this.getVertexBounds(this.visited[vertex]);
\t\tbounds = (bounds != null) ? bounds : vertexBounds.clone();
\t\tbounds.add(vertexBounds);
\t}
\t
\tthis.calcRowDims([this.node], 0);
\t
\tvar maxLeftGrad = 0;
\tvar maxRightGrad = 0;

\t// Find the steepest left and right gradients
\tfor (var i = 0; i < this.row.length; i++)
\t{
\t\tvar leftGrad = (this.centerX - this.rowMinX[i] - this.nodeDistance) / this.rowRadi[i];
\t\tvar rightGrad = (this.rowMaxX[i] - this.centerX - this.nodeDistance) / this.rowRadi[i];
\t\t
\t\tmaxLeftGrad = Math.max (maxLeftGrad, leftGrad);
\t\tmaxRightGrad = Math.max (maxRightGrad, rightGrad);
\t}
\t
\t// Extend out row so they meet the maximum gradient and convert to polar co-ords
\tfor (var i = 0; i < this.row.length; i++)
\t{
\t\tvar xLeftLimit = this.centerX - this.nodeDistance - maxLeftGrad * this.rowRadi[i];
\t\tvar xRightLimit = this.centerX + this.nodeDistance + maxRightGrad * this.rowRadi[i];
\t\tvar fullWidth = xRightLimit - xLeftLimit;
\t\t
\t\tfor (var j = 0; j < this.row[i].length; j ++)
\t\t{
\t\t\tvar row = this.row[i];
\t\t\tvar node = row[j];
\t\t\tvar vertexBounds = this.getVertexBounds(node.cell);
\t\t\tvar xProportion = (vertexBounds.x + vertexBounds.width / 2 - xLeftLimit) / (fullWidth);
\t\t\tvar theta =  2 * Math.PI * xProportion;
\t\t\tnode.theta = theta;
\t\t}
\t}

\t// Post-process from outside inwards to try to align parents with children
\tfor (var i = this.row.length - 2; i >= 0; i--)
\t{
\t\tvar row = this.row[i];
\t\t
\t\tfor (var j = 0; j < row.length; j++)
\t\t{
\t\t\tvar node = row[j];
\t\t\tvar child = node.child;
\t\t\tvar counter = 0;
\t\t\tvar totalTheta = 0;
\t\t\t
\t\t\twhile (child != null)
\t\t\t{
\t\t\t\ttotalTheta += child.theta;
\t\t\t\tcounter++;
\t\t\t\tchild = child.next;
\t\t\t}
\t\t\t
\t\t\tif (counter > 0)
\t\t\t{
\t\t\t\tvar averTheta = totalTheta / counter;
\t\t\t\t
\t\t\t\tif (averTheta > node.theta && j < row.length - 1)
\t\t\t\t{
\t\t\t\t\tvar nextTheta = row[j+1].theta;
\t\t\t\t\tnode.theta = Math.min (averTheta, nextTheta - Math.PI/10);
\t\t\t\t}
\t\t\t\telse if (averTheta < node.theta && j > 0 )
\t\t\t\t{
\t\t\t\t\tvar lastTheta = row[j-1].theta;
\t\t\t\t\tnode.theta = Math.max (averTheta, lastTheta + Math.PI/10);
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\t
\t// Set locations
\tfor (var i = 0; i < this.row.length; i++)
\t{
\t\tfor (var j = 0; j < this.row[i].length; j ++)
\t\t{
\t\t\tvar row = this.row[i];
\t\t\tvar node = row[j];
\t\t\tvar vertexBounds = this.getVertexBounds(node.cell);
\t\t\tthis.setVertexLocation(node.cell,
\t\t\t\t\t\t\t\t\tthis.centerX - vertexBounds.width / 2 + this.rowRadi[i] * Math.cos(node.theta),
\t\t\t\t\t\t\t\t\tthis.centerY - vertexBounds.height / 2 + this.rowRadi[i] * Math.sin(node.theta));
\t\t}
\t}
};

/**
 * Function: calcRowDims
 * 
 * Recursive function to calculate the dimensions of each row
 * 
 * Parameters:
 * 
 * row - Array of internal nodes, the children of which are to be processed.
 * rowNum - Integer indicating which row is being processed.
 */
mxRadialTreeLayout.prototype.calcRowDims = function(row, rowNum)
{
\tif (row == null || row.length == 0)
\t{
\t\treturn;
\t}

\t// Place root's children proportionally around the first level
\tthis.rowMinX[rowNum] = this.centerX;
\tthis.rowMaxX[rowNum] = this.centerX;
\tthis.rowMinCenX[rowNum] = this.centerX;
\tthis.rowMaxCenX[rowNum] = this.centerX;
\tthis.row[rowNum] = [];

\tvar rowHasChildren = false;

\tfor (var i = 0; i < row.length; i++)
\t{
\t\tvar child = row[i] != null ? row[i].child : null;

\t\twhile (child != null)
\t\t{
\t\t\tvar cell = child.cell;
\t\t\tvar vertexBounds = this.getVertexBounds(cell);
\t\t\t
\t\t\tthis.rowMinX[rowNum] = Math.min(vertexBounds.x, this.rowMinX[rowNum]);
\t\t\tthis.rowMaxX[rowNum] = Math.max(vertexBounds.x + vertexBounds.width, this.rowMaxX[rowNum]);
\t\t\tthis.rowMinCenX[rowNum] = Math.min(vertexBounds.x + vertexBounds.width / 2, this.rowMinCenX[rowNum]);
\t\t\tthis.rowMaxCenX[rowNum] = Math.max(vertexBounds.x + vertexBounds.width / 2, this.rowMaxCenX[rowNum]);
\t\t\tthis.rowRadi[rowNum] = vertexBounds.y - this.getVertexBounds(this.root).y;
\t
\t\t\tif (child.child != null)
\t\t\t{
\t\t\t\trowHasChildren = true;
\t\t\t}
\t\t\t
\t\t\tthis.row[rowNum].push(child);
\t\t\tchild = child.next;
\t\t}
\t}
\t
\tif (rowHasChildren)
\t{
\t\tthis.calcRowDims(this.row[rowNum], rowNum + 1);
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxFastOrganicLayout
 * 
 * Extends <mxGraphLayout> to implement a fast organic layout algorithm.
 * The vertices need to be connected for this layout to work, vertices
 * with no connections are ignored.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxFastOrganicLayout(graph);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxCompactTreeLayout
 * 
 * Constructs a new fast organic layout for the specified graph.
 */
function mxFastOrganicLayout(graph)
{
\tmxGraphLayout.call(this, graph);
};

/**
 * Extends mxGraphLayout.
 */
mxFastOrganicLayout.prototype = new mxGraphLayout();
mxFastOrganicLayout.prototype.constructor = mxFastOrganicLayout;

/**
 * Variable: useInputOrigin
 * 
 * Specifies if the top left corner of the input cells should be the origin
 * of the layout result. Default is true.
 */
mxFastOrganicLayout.prototype.useInputOrigin = true;

/**
 * Variable: resetEdges
 * 
 * Specifies if all edge points of traversed edges should be removed.
 * Default is true.
 */
mxFastOrganicLayout.prototype.resetEdges = true;

/**
 * Variable: disableEdgeStyle
 * 
 * Specifies if the STYLE_NOEDGESTYLE flag should be set on edges that are
 * modified by the result. Default is true.
 */
mxFastOrganicLayout.prototype.disableEdgeStyle = true;

/**
 * Variable: forceConstant
 * 
 * The force constant by which the attractive forces are divided and the
 * replusive forces are multiple by the square of. The value equates to the
 * average radius there is of free space around each node. Default is 50.
 */
mxFastOrganicLayout.prototype.forceConstant = 50;

/**
 * Variable: forceConstantSquared
 * 
 * Cache of <forceConstant>^2 for performance.
 */
mxFastOrganicLayout.prototype.forceConstantSquared = 0;

/**
 * Variable: minDistanceLimit
 * 
 * Minimal distance limit. Default is 2. Prevents of
 * dividing by zero.
 */
mxFastOrganicLayout.prototype.minDistanceLimit = 2;

/**
 * Variable: maxDistanceLimit
 * 
 * Maximal distance limit. Default is 500. Prevents of
 * dividing by zero.
 */
mxFastOrganicLayout.prototype.maxDistanceLimit = 500;

/**
 * Variable: minDistanceLimitSquared
 * 
 * Cached version of <minDistanceLimit> squared.
 */
mxFastOrganicLayout.prototype.minDistanceLimitSquared = 4;

/**
 * Variable: initialTemp
 * 
 * Start value of temperature. Default is 200.
 */
mxFastOrganicLayout.prototype.initialTemp = 200;

/**
 * Variable: temperature
 * 
 * Temperature to limit displacement at later stages of layout.
 */
mxFastOrganicLayout.prototype.temperature = 0;

/**
 * Variable: maxIterations
 * 
 * Total number of iterations to run the layout though.
 */
mxFastOrganicLayout.prototype.maxIterations = 0;

/**
 * Variable: iteration
 * 
 * Current iteration count.
 */
mxFastOrganicLayout.prototype.iteration = 0;

/**
 * Variable: vertexArray
 * 
 * An array of all vertices to be laid out.
 */
mxFastOrganicLayout.prototype.vertexArray;

/**
 * Variable: dispX
 * 
 * An array of locally stored X co-ordinate displacements for the vertices.
 */
mxFastOrganicLayout.prototype.dispX;

/**
 * Variable: dispY
 * 
 * An array of locally stored Y co-ordinate displacements for the vertices.
 */
mxFastOrganicLayout.prototype.dispY;

/**
 * Variable: cellLocation
 * 
 * An array of locally stored co-ordinate positions for the vertices.
 */
mxFastOrganicLayout.prototype.cellLocation;

/**
 * Variable: radius
 * 
 * The approximate radius of each cell, nodes only.
 */
mxFastOrganicLayout.prototype.radius;

/**
 * Variable: radiusSquared
 * 
 * The approximate radius squared of each cell, nodes only.
 */
mxFastOrganicLayout.prototype.radiusSquared;

/**
 * Variable: isMoveable
 * 
 * Array of booleans representing the movable states of the vertices.
 */
mxFastOrganicLayout.prototype.isMoveable;

/**
 * Variable: neighbours
 * 
 * Local copy of cell neighbours.
 */
mxFastOrganicLayout.prototype.neighbours;

/**
 * Variable: indices
 * 
 * Hashtable from cells to local indices.
 */
mxFastOrganicLayout.prototype.indices;

/**
 * Variable: allowedToRun
 * 
 * Boolean flag that specifies if the layout is allowed to run. If this is
 * set to false, then the layout exits in the following iteration.
 */
mxFastOrganicLayout.prototype.allowedToRun = true;

/**
 * Function: isVertexIgnored
 * 
 * Returns a boolean indicating if the given <mxCell> should be ignored as a
 * vertex. This returns true if the cell has no connections.
 * 
 * Parameters:
 * 
 * vertex - <mxCell> whose ignored state should be returned.
 */
mxFastOrganicLayout.prototype.isVertexIgnored = function(vertex)
{
\treturn mxGraphLayout.prototype.isVertexIgnored.apply(this, arguments) ||
\t\tthis.graph.getConnections(vertex).length == 0;
};

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>. This operates on all children of the
 * given parent where <isVertexIgnored> returns false.
 */
mxFastOrganicLayout.prototype.execute = function(parent)
{
\tvar model = this.graph.getModel();
\tthis.vertexArray = [];
\tvar cells = this.graph.getChildVertices(parent);
\t
\tfor (var i = 0; i < cells.length; i++)
\t{
\t\tif (!this.isVertexIgnored(cells[i]))
\t\t{
\t\t\tthis.vertexArray.push(cells[i]);
\t\t}
\t}
\t
\tvar initialBounds = (this.useInputOrigin) ?
\t\t\tthis.graph.getBoundingBoxFromGeometry(this.vertexArray) :
\t\t\t\tnull;
\tvar n = this.vertexArray.length;

\tthis.indices = [];
\tthis.dispX = [];
\tthis.dispY = [];
\tthis.cellLocation = [];
\tthis.isMoveable = [];
\tthis.neighbours = [];
\tthis.radius = [];
\tthis.radiusSquared = [];

\tif (this.forceConstant < 0.001)
\t{
\t\tthis.forceConstant = 0.001;
\t}

\tthis.forceConstantSquared = this.forceConstant * this.forceConstant;

\t// Create a map of vertices first. This is required for the array of
\t// arrays called neighbours which holds, for each vertex, a list of
\t// ints which represents the neighbours cells to that vertex as
\t// the indices into vertexArray
\tfor (var i = 0; i < this.vertexArray.length; i++)
\t{
\t\tvar vertex = this.vertexArray[i];
\t\tthis.cellLocation[i] = [];
\t\t
\t\t// Set up the mapping from array indices to cells
\t\tvar id = mxObjectIdentity.get(vertex);
\t\tthis.indices[id] = i;
\t\tvar bounds = this.getVertexBounds(vertex);

\t\t// Set the X,Y value of the internal version of the cell to
\t\t// the center point of the vertex for better positioning
\t\tvar width = bounds.width;
\t\tvar height = bounds.height;
\t\t
\t\t// Randomize (0, 0) locations
\t\tvar x = bounds.x;
\t\tvar y = bounds.y;
\t\t
\t\tthis.cellLocation[i][0] = x + width / 2.0;
\t\tthis.cellLocation[i][1] = y + height / 2.0;
\t\tthis.radius[i] = Math.min(width, height);
\t\tthis.radiusSquared[i] = this.radius[i] * this.radius[i];
\t}

\t// Moves cell location back to top-left from center locations used in
\t// algorithm, resetting the edge points is part of the transaction
\tmodel.beginUpdate();
\ttry
\t{
\t\tfor (var i = 0; i < n; i++)
\t\t{
\t\t\tthis.dispX[i] = 0;
\t\t\tthis.dispY[i] = 0;
\t\t\tthis.isMoveable[i] = this.isVertexMovable(this.vertexArray[i]);

\t\t\t// Get lists of neighbours to all vertices, translate the cells
\t\t\t// obtained in indices into vertexArray and store as an array
\t\t\t// against the orginial cell index
\t\t\tvar edges = this.graph.getConnections(this.vertexArray[i], parent);
\t\t\tvar cells = this.graph.getOpposites(edges, this.vertexArray[i]);
\t\t\tthis.neighbours[i] = [];

\t\t\tfor (var j = 0; j < cells.length; j++)
\t\t\t{
\t\t\t\t// Resets the points on the traversed edge
\t\t\t\tif (this.resetEdges)
\t\t\t\t{
\t\t\t\t\tthis.graph.resetEdge(edges[j]);
\t\t\t\t}

\t\t\t    if (this.disableEdgeStyle)
\t\t\t    {
\t\t\t    \tthis.setEdgeStyleEnabled(edges[j], false);
\t\t\t    }

\t\t\t\t// Looks the cell up in the indices dictionary
\t\t\t\tvar id = mxObjectIdentity.get(cells[j]);
\t\t\t\tvar index = this.indices[id];

\t\t\t\t// Check the connected cell in part of the vertex list to be
\t\t\t\t// acted on by this layout
\t\t\t\tif (index != null)
\t\t\t\t{
\t\t\t\t\tthis.neighbours[i][j] = index;
\t\t\t\t}

\t\t\t\t// Else if index of the other cell doesn't correspond to
\t\t\t\t// any cell listed to be acted upon in this layout. Set
\t\t\t\t// the index to the value of this vertex (a dummy self-loop)
\t\t\t\t// so the attraction force of the edge is not calculated
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tthis.neighbours[i][j] = i;
\t\t\t\t}
\t\t\t}
\t\t}
\t\tthis.temperature = this.initialTemp;

\t\t// If max number of iterations has not been set, guess it
\t\tif (this.maxIterations == 0)
\t\t{
\t\t\tthis.maxIterations = 20 * Math.sqrt(n);
\t\t}
\t\t
\t\t// Main iteration loop
\t\tfor (this.iteration = 0; this.iteration < this.maxIterations; this.iteration++)
\t\t{
\t\t\tif (!this.allowedToRun)
\t\t\t{
\t\t\t\treturn;
\t\t\t}
\t\t\t
\t\t\t// Calculate repulsive forces on all vertices
\t\t\tthis.calcRepulsion();

\t\t\t// Calculate attractive forces through edges
\t\t\tthis.calcAttraction();

\t\t\tthis.calcPositions();
\t\t\tthis.reduceTemperature();
\t\t}

\t\tvar minx = null;
\t\tvar miny = null;
\t\t
\t\tfor (var i = 0; i < this.vertexArray.length; i++)
\t\t{
\t\t\tvar vertex = this.vertexArray[i];
\t\t\t
\t\t\tif (this.isVertexMovable(vertex))
\t\t\t{
\t\t\t\tvar bounds = this.getVertexBounds(vertex);
\t\t\t\t
\t\t\t\tif (bounds != null)
\t\t\t\t{
\t\t\t\t\tthis.cellLocation[i][0] -= bounds.width / 2.0;
\t\t\t\t\tthis.cellLocation[i][1] -= bounds.height / 2.0;
\t\t\t\t\t
\t\t\t\t\tvar x = this.graph.snap(Math.round(this.cellLocation[i][0]));
\t\t\t\t\tvar y = this.graph.snap(Math.round(this.cellLocation[i][1]));
\t\t\t\t\t
\t\t\t\t\tthis.setVertexLocation(vertex, x, y);
\t\t\t\t\t
\t\t\t\t\tif (minx == null)
\t\t\t\t\t{
\t\t\t\t\t\tminx = x;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tminx = Math.min(minx, x);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tif (miny == null)
\t\t\t\t\t{
\t\t\t\t\t\tminy = y;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tminy = Math.min(miny, y);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\t// Modifies the cloned geometries in-place. Not needed
\t\t// to clone the geometries again as we're in the same
\t\t// undoable change.
\t\tvar dx = -(minx || 0) + 1;
\t\tvar dy = -(miny || 0) + 1;
\t\t
\t\tif (initialBounds != null)
\t\t{
\t\t\tdx += initialBounds.x;
\t\t\tdy += initialBounds.y;
\t\t}
\t\t
\t\tthis.graph.moveCells(this.vertexArray, dx, dy);
\t}
\tfinally
\t{
\t\tmodel.endUpdate();
\t}
};

/**
 * Function: calcPositions
 * 
 * Takes the displacements calculated for each cell and applies them to the
 * local cache of cell positions. Limits the displacement to the current
 * temperature.
 */
mxFastOrganicLayout.prototype.calcPositions = function()
{
\tfor (var index = 0; index < this.vertexArray.length; index++)
\t{
\t\tif (this.isMoveable[index])
\t\t{
\t\t\t// Get the distance of displacement for this node for this
\t\t\t// iteration
\t\t\tvar deltaLength = Math.sqrt(this.dispX[index] * this.dispX[index] +
\t\t\t\tthis.dispY[index] * this.dispY[index]);

\t\t\tif (deltaLength < 0.001)
\t\t\t{
\t\t\t\tdeltaLength = 0.001;
\t\t\t}

\t\t\t// Scale down by the current temperature if less than the
\t\t\t// displacement distance
\t\t\tvar newXDisp = this.dispX[index] / deltaLength
\t\t\t\t* Math.min(deltaLength, this.temperature);

\t\t\tvar newYDisp = this.dispY[index] / deltaLength
\t\t\t\t* Math.min(deltaLength, this.temperature);

\t\t\t// reset displacements
\t\t\tthis.dispX[index] = 0;
\t\t\tthis.dispY[index] = 0;

\t\t\t// Update the cached cell locations
\t\t\tthis.cellLocation[index][0] += newXDisp;
\t\t\tthis.cellLocation[index][1] += newYDisp;
\t\t}
\t}
};

/**
 * Function: calcAttraction
 * 
 * Calculates the attractive forces between all laid out nodes linked by
 * edges
 */
mxFastOrganicLayout.prototype.calcAttraction = function()
{
\t// Check the neighbours of each vertex and calculate the attractive
\t// force of the edge connecting them
\tfor (var i = 0; i < this.vertexArray.length; i++)
\t{
\t\tfor (var k = 0; k < this.neighbours[i].length; k++)
\t\t{
\t\t\t// Get the index of the othe cell in the vertex array
\t\t\tvar j = this.neighbours[i][k];
\t\t\t
\t\t\t// Do not proceed self-loops
\t\t\tif (i != j &&
\t\t\t\tthis.isMoveable[i] &&
\t\t\t\tthis.isMoveable[j])
\t\t\t{
\t\t\t\tvar xDelta = this.cellLocation[i][0] - this.cellLocation[j][0];
\t\t\t\tvar yDelta = this.cellLocation[i][1] - this.cellLocation[j][1];

\t\t\t\t// The distance between the nodes
\t\t\t\tvar deltaLengthSquared = xDelta * xDelta + yDelta
\t\t\t\t\t\t* yDelta - this.radiusSquared[i] - this.radiusSquared[j];

\t\t\t\tif (deltaLengthSquared < this.minDistanceLimitSquared)
\t\t\t\t{
\t\t\t\t\tdeltaLengthSquared = this.minDistanceLimitSquared;
\t\t\t\t}
\t\t\t\t
\t\t\t\tvar deltaLength = Math.sqrt(deltaLengthSquared);
\t\t\t\tvar force = (deltaLengthSquared) / this.forceConstant;

\t\t\t\tvar displacementX = (xDelta / deltaLength) * force;
\t\t\t\tvar displacementY = (yDelta / deltaLength) * force;
\t\t\t\t
\t\t\t\tthis.dispX[i] -= displacementX;
\t\t\t\tthis.dispY[i] -= displacementY;
\t\t\t\t
\t\t\t\tthis.dispX[j] += displacementX;
\t\t\t\tthis.dispY[j] += displacementY;
\t\t\t}
\t\t}
\t}
};

/**
 * Function: calcRepulsion
 * 
 * Calculates the repulsive forces between all laid out nodes
 */
mxFastOrganicLayout.prototype.calcRepulsion = function()
{
\tvar vertexCount = this.vertexArray.length;

\tfor (var i = 0; i < vertexCount; i++)
\t{
\t\tfor (var j = i; j < vertexCount; j++)
\t\t{
\t\t\t// Exits if the layout is no longer allowed to run
\t\t\tif (!this.allowedToRun)
\t\t\t{
\t\t\t\treturn;
\t\t\t}

\t\t\tif (j != i &&
\t\t\t\tthis.isMoveable[i] &&
\t\t\t\tthis.isMoveable[j])
\t\t\t{
\t\t\t\tvar xDelta = this.cellLocation[i][0] - this.cellLocation[j][0];
\t\t\t\tvar yDelta = this.cellLocation[i][1] - this.cellLocation[j][1];

\t\t\t\tif (xDelta == 0)
\t\t\t\t{
\t\t\t\t\txDelta = 0.01 + Math.random();
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (yDelta == 0)
\t\t\t\t{
\t\t\t\t\tyDelta = 0.01 + Math.random();
\t\t\t\t}
\t\t\t\t
\t\t\t\t// Distance between nodes
\t\t\t\tvar deltaLength = Math.sqrt((xDelta * xDelta)
\t\t\t\t\t\t+ (yDelta * yDelta));
\t\t\t\tvar deltaLengthWithRadius = deltaLength - this.radius[i]
\t\t\t\t\t\t- this.radius[j];

\t\t\t\tif (deltaLengthWithRadius > this.maxDistanceLimit)
\t\t\t\t{
\t\t\t\t\t// Ignore vertices too far apart
\t\t\t\t\tcontinue;
\t\t\t\t}

\t\t\t\tif (deltaLengthWithRadius < this.minDistanceLimit)
\t\t\t\t{
\t\t\t\t\tdeltaLengthWithRadius = this.minDistanceLimit;
\t\t\t\t}

\t\t\t\tvar force = this.forceConstantSquared / deltaLengthWithRadius;

\t\t\t\tvar displacementX = (xDelta / deltaLength) * force;
\t\t\t\tvar displacementY = (yDelta / deltaLength) * force;
\t\t\t\t
\t\t\t\tthis.dispX[i] += displacementX;
\t\t\t\tthis.dispY[i] += displacementY;

\t\t\t\tthis.dispX[j] -= displacementX;
\t\t\t\tthis.dispY[j] -= displacementY;
\t\t\t}
\t\t}
\t}
};

/**
 * Function: reduceTemperature
 * 
 * Reduces the temperature of the layout from an initial setting in a linear
 * fashion to zero.
 */
mxFastOrganicLayout.prototype.reduceTemperature = function()
{
\tthis.temperature = this.initialTemp * (1.0 - this.iteration / this.maxIterations);
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxCircleLayout
 * 
 * Extends <mxGraphLayout> to implement a circluar layout for a given radius.
 * The vertices do not need to be connected for this layout to work and all
 * connections between vertices are not taken into account.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxCircleLayout(graph);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxCircleLayout
 *
 * Constructs a new circular layout for the specified radius.
 *
 * Arguments:
 * 
 * graph - <mxGraph> that contains the cells.
 * radius - Optional radius as an int. Default is 100.
 */
function mxCircleLayout(graph, radius)
{
\tmxGraphLayout.call(this, graph);
\tthis.radius = (radius != null) ? radius : 100;
};

/**
 * Extends mxGraphLayout.
 */
mxCircleLayout.prototype = new mxGraphLayout();
mxCircleLayout.prototype.constructor = mxCircleLayout;

/**
 * Variable: radius
 * 
 * Integer specifying the size of the radius. Default is 100.
 */
mxCircleLayout.prototype.radius = null;

/**
 * Variable: moveCircle
 * 
 * Boolean specifying if the circle should be moved to the top,
 * left corner specified by <x0> and <y0>. Default is false.
 */
mxCircleLayout.prototype.moveCircle = false;

/**
 * Variable: x0
 * 
 * Integer specifying the left coordinate of the circle.
 * Default is 0.
 */
mxCircleLayout.prototype.x0 = 0;

/**
 * Variable: y0
 * 
 * Integer specifying the top coordinate of the circle.
 * Default is 0.
 */
mxCircleLayout.prototype.y0 = 0;

/**
 * Variable: resetEdges
 * 
 * Specifies if all edge points of traversed edges should be removed.
 * Default is true.
 */
mxCircleLayout.prototype.resetEdges = true;

/**
 * Variable: disableEdgeStyle
 * 
 * Specifies if the STYLE_NOEDGESTYLE flag should be set on edges that are
 * modified by the result. Default is true.
 */
mxCircleLayout.prototype.disableEdgeStyle = true;

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>.
 */
mxCircleLayout.prototype.execute = function(parent)
{
\tvar model = this.graph.getModel();

\t// Moves the vertices to build a circle. Makes sure the
\t// radius is large enough for the vertices to not
\t// overlap
\tmodel.beginUpdate();
\ttry
\t{
\t\t// Gets all vertices inside the parent and finds
\t\t// the maximum dimension of the largest vertex
\t\tvar max = 0;
\t\tvar top = null;
\t\tvar left = null;
\t\tvar vertices = [];
\t\tvar childCount = model.getChildCount(parent);
\t\t
\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\tvar cell = model.getChildAt(parent, i);
\t\t\t
\t\t\tif (!this.isVertexIgnored(cell))
\t\t\t{
\t\t\t\tvertices.push(cell);
\t\t\t\tvar bounds = this.getVertexBounds(cell);
\t\t\t\t
\t\t\t\tif (top == null)
\t\t\t\t{
\t\t\t\t\ttop = bounds.y;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\ttop = Math.min(top, bounds.y);
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (left == null)
\t\t\t\t{
\t\t\t\t\tleft = bounds.x;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tleft = Math.min(left, bounds.x);
\t\t\t\t}
\t\t\t\t
\t\t\t\tmax = Math.max(max, Math.max(bounds.width, bounds.height));
\t\t\t}
\t\t\telse if (!this.isEdgeIgnored(cell))
\t\t\t{
\t\t\t\t// Resets the points on the traversed edge
\t\t\t\tif (this.resetEdges)
\t\t\t\t{
\t\t\t\t\tthis.graph.resetEdge(cell);
\t\t\t\t}

\t\t\t    if (this.disableEdgeStyle)
\t\t\t    {
\t\t\t    \t\tthis.setEdgeStyleEnabled(cell, false);
\t\t\t    }
\t\t\t}
\t\t}
\t\t
\t\tvar r = this.getRadius(vertices.length, max);

\t\t// Moves the circle to the specified origin
\t\tif (this.moveCircle)
\t\t{
\t\t\tleft = this.x0;
\t\t\ttop = this.y0;
\t\t}
\t\t
\t\tthis.circle(vertices, r, left, top);
\t}
\tfinally
\t{
\t\tmodel.endUpdate();
\t}
};

/**
 * Function: getRadius
 * 
 * Returns the radius to be used for the given vertex count. Max is the maximum
 * width or height of all vertices in the layout.
 */
mxCircleLayout.prototype.getRadius = function(count, max)
{
\treturn Math.max(count * max / Math.PI, this.radius);
};

/**
 * Function: circle
 * 
 * Executes the circular layout for the specified array
 * of vertices and the given radius. This is called from
 * <execute>.
 */
mxCircleLayout.prototype.circle = function(vertices, r, left, top)
{
\tvar vertexCount = vertices.length;
\tvar phi = 2 * Math.PI / vertexCount;
\t
\tfor (var i = 0; i < vertexCount; i++)
\t{
\t\tif (this.isVertexMovable(vertices[i]))
\t\t{
\t\t\tthis.setVertexLocation(vertices[i],
\t\t\t\tMath.round(left + r + r * Math.sin(i * phi)),
\t\t\t\tMath.round(top + r + r * Math.cos(i * phi)));
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxParallelEdgeLayout
 * 
 * Extends <mxGraphLayout> for arranging parallel edges. This layout works
 * on edges for all pairs of vertices where there is more than one edge
 * connecting the latter.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxParallelEdgeLayout(graph);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * To run the layout for the parallel edges of a changed edge only, the
 * following code can be used.
 * 
 * (code)
 * var layout = new mxParallelEdgeLayout(graph);
 * 
 * graph.addListener(mxEvent.CELL_CONNECTED, function(sender, evt)
 * {
 *   var model = graph.getModel();
 *   var edge = evt.getProperty('edge');
 *   var src = model.getTerminal(edge, true);
 *   var trg = model.getTerminal(edge, false);
 *   
 *   layout.isEdgeIgnored = function(edge2)
 *   {
 *     var src2 = model.getTerminal(edge2, true);
 *     var trg2 = model.getTerminal(edge2, false);
 *     
 *     return !(model.isEdge(edge2) && ((src == src2 && trg == trg2) || (src == trg2 && trg == src2)));
 *   };
 *   
 *   layout.execute(graph.getDefaultParent());
 * });
 * (end)
 * 
 * Constructor: mxParallelEdgeLayout
 * 
 * Constructs a new parallel edge layout for the specified graph.
 */
function mxParallelEdgeLayout(graph)
{
\tmxGraphLayout.call(this, graph);
};

/**
 * Extends mxGraphLayout.
 */
mxParallelEdgeLayout.prototype = new mxGraphLayout();
mxParallelEdgeLayout.prototype.constructor = mxParallelEdgeLayout;

/**
 * Variable: spacing
 * 
 * Defines the spacing between the parallels. Default is 20.
 */
mxParallelEdgeLayout.prototype.spacing = 20;

/**
 * Variable: checkOverlap
 * 
 * Specifies if only overlapping edges should be considered
 * parallel. Default is false.
 */
mxParallelEdgeLayout.prototype.checkOverlap = false;

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>.
 */
mxParallelEdgeLayout.prototype.execute = function(parent, cells)
{
\tvar lookup = this.findParallels(parent, cells);
\t
\tthis.graph.model.beginUpdate();\t
\ttry
\t{
\t\tfor (var i in lookup)
\t\t{
\t\t\tvar parallels = lookup[i];

\t\t\tif (parallels.length > 1)
\t\t\t{
\t\t\t\tthis.layout(parallels);
\t\t\t}
\t\t}
\t}
\tfinally
\t{
\t\tthis.graph.model.endUpdate();
\t}
};

/**
 * Function: findParallels
 * 
 * Finds the parallel edges in the given parent.
 */
mxParallelEdgeLayout.prototype.findParallels = function(parent, cells)
{
\tvar lookup = [];
\t
\tvar addCell = mxUtils.bind(this, function(cell)
\t{
\t\tif (!this.isEdgeIgnored(cell))
\t\t{
\t\t\tvar id = this.getEdgeId(cell);
\t\t\t
\t\t\tif (id != null)
\t\t\t{
\t\t\t\tif (lookup[id] == null)
\t\t\t\t{
\t\t\t\t\tlookup[id] = [];
\t\t\t\t}
\t\t\t\t
\t\t\t\tlookup[id].push(cell);
\t\t\t}
\t\t}
\t});
\t
\tif (cells != null)
\t{
\t\tfor (var i = 0; i < cells.length; i++)
\t\t{
\t\t\taddCell(cells[i]);
\t\t}
\t}
\telse
\t{
\t\tvar model = this.graph.getModel();
\t\tvar childCount = model.getChildCount(parent);
\t\t
\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\taddCell(model.getChildAt(parent, i));
\t\t}
\t}
\t
\treturn lookup;
};

/**
 * Function: getEdgeId
 * 
 * Returns a unique ID for the given edge. The id is independent of the
 * edge direction and is built using the visible terminal of the given
 * edge.
 */
mxParallelEdgeLayout.prototype.getEdgeId = function(edge)
{
\tvar view = this.graph.getView();
\t
\t// Cannot used cached visible terminal because this could be triggered in BEFORE_UNDO
\tvar src = view.getVisibleTerminal(edge, true);
\tvar trg = view.getVisibleTerminal(edge, false);
\tvar pts = '';

\tif (src != null && trg != null)
\t{
\t\tsrc = mxObjectIdentity.get(src);
\t\ttrg = mxObjectIdentity.get(trg);
\t\t
\t\tif (this.checkOverlap)
\t\t{
\t\t\tvar state = this.graph.view.getState(edge);
\t\t\t
\t\t\tif (state != null && state.absolutePoints != null)
\t\t\t{
\t\t\t\tvar tmp = [];
\t\t\t\t
\t\t\t\tfor (var i = 0; i < state.absolutePoints.length; i++)
\t\t\t\t{
\t\t\t\t\tvar pt = state.absolutePoints[i];
\t\t\t\t\t
\t\t\t\t\tif (pt != null)
\t\t\t\t\t{
\t\t\t\t\t\ttmp.push(pt.x, pt.y);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tpts = tmp.join(',');
\t\t\t}
\t\t};
\t\t
\t\treturn ((src > trg) ? trg + '-' + src : src + '-' + trg) + pts;
\t}
\t
\treturn null;
};

/**
 * Function: layout
 * 
 * Lays out the parallel edges in the given array.
 */
mxParallelEdgeLayout.prototype.layout = function(parallels)
{
\tvar edge = parallels[0];
\tvar view = this.graph.getView();
\tvar model = this.graph.getModel();
\tvar src = model.getGeometry(view.getVisibleTerminal(edge, true));
\tvar trg = model.getGeometry(view.getVisibleTerminal(edge, false));
\t
\t// Routes multiple loops
\tif (src == trg)
\t{
\t\tvar x0 = src.x + src.width + this.spacing;
\t\tvar y0 = src.y + src.height / 2;

\t\tfor (var i = 0; i < parallels.length; i++)
\t\t{
\t\t\tthis.route(parallels[i], x0, y0);
\t\t\tx0 += this.spacing;
\t\t}
\t}
\telse if (src != null && trg != null)
\t{
\t\t// Routes parallel edges
\t\tvar scx = src.x + src.width / 2;
\t\tvar scy = src.y + src.height / 2;
\t\t
\t\tvar tcx = trg.x + trg.width / 2;
\t\tvar tcy = trg.y + trg.height / 2;
\t\t
\t\tvar dx = tcx - scx;
\t\tvar dy = tcy - scy;

\t\tvar len = Math.sqrt(dx * dx + dy * dy);
\t\t
\t\tif (len > 0)
\t\t{
\t\t\tvar x0 = scx + dx / 2;
\t\t\tvar y0 = scy + dy / 2;
\t\t\t
\t\t\tvar nx = dy * this.spacing / len;
\t\t\tvar ny = dx * this.spacing / len;
\t\t\t
\t\t\tx0 += nx * (parallels.length - 1) / 2;
\t\t\ty0 -= ny * (parallels.length - 1) / 2;
\t
\t\t\tfor (var i = 0; i < parallels.length; i++)
\t\t\t{
\t\t\t\tthis.route(parallels[i], x0, y0);
\t\t\t\tx0 -= nx;
\t\t\t\ty0 += ny;
\t\t\t}
\t\t}
\t}
};

/**
 * Function: route
 * 
 * Routes the given edge via the given point.
 */
mxParallelEdgeLayout.prototype.route = function(edge, x, y)
{
\tif (this.graph.isCellMovable(edge))
\t{
\t\tthis.setEdgePoints(edge, [new mxPoint(x, y)]);
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxCompositeLayout
 * 
 * Allows to compose multiple layouts into a single layout. The master layout
 * is the layout that handles move operations if another layout than the first
 * element in <layouts> should be used. The <master> layout is not executed as
 * the code assumes that it is part of <layouts>.
 * 
 * Example:
 * (code)
 * var first = new mxFastOrganicLayout(graph);
 * var second = new mxParallelEdgeLayout(graph);
 * var layout = new mxCompositeLayout(graph, [first, second], first);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxCompositeLayout
 *
 * Constructs a new layout using the given layouts. The graph instance is
 * required for creating the transaction that contains all layouts.
 *
 * Arguments:
 * 
 * graph - Reference to the enclosing <mxGraph>.
 * layouts - Array of <mxGraphLayouts>.
 * master - Optional layout that handles moves. If no layout is given then
 * the first layout of the above array is used to handle moves.
 */
function mxCompositeLayout(graph, layouts, master)
{
\tmxGraphLayout.call(this, graph);
\tthis.layouts = layouts;
\tthis.master = master;
};

/**
 * Extends mxGraphLayout.
 */
mxCompositeLayout.prototype = new mxGraphLayout();
mxCompositeLayout.prototype.constructor = mxCompositeLayout;
\t
/**
 * Variable: layouts
 * 
 * Holds the array of <mxGraphLayouts> that this layout contains.
 */
mxCompositeLayout.prototype.layouts = null;

/**
 * Variable: master
 * 
 * Reference to the <mxGraphLayouts> that handles moves. If this is null
 * then the first layout in <layouts> is used.
 */
mxCompositeLayout.prototype.master = null;

/**
 * Function: moveCell
 * 
 * Implements <mxGraphLayout.moveCell> by calling move on <master> or the first
 * layout in <layouts>.
 */
mxCompositeLayout.prototype.moveCell = function(cell, x, y)
{
\tif (this.master != null)
\t{
\t\tthis.master.moveCell.apply(this.master, arguments);
\t}
\telse
\t{
\t\tthis.layouts[0].moveCell.apply(this.layouts[0], arguments);
\t}
};

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute> by executing all <layouts> in a
 * single transaction.
 */
mxCompositeLayout.prototype.execute = function(parent)
{
\tvar model = this.graph.getModel();
\t
\tmodel.beginUpdate();
\ttry
\t{
\t\tfor (var i = 0; i < this.layouts.length; i++)
\t\t{
\t\t\tthis.layouts[i].execute.apply(this.layouts[i], arguments);
\t\t}
\t}
\tfinally
\t{
\t\tmodel.endUpdate();
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxEdgeLabelLayout
 * 
 * Extends <mxGraphLayout> to implement an edge label layout. This layout
 * makes use of cell states, which means the graph must be validated in
 * a graph view (so that the label bounds are available) before this layout
 * can be executed.
 * 
 * Example:
 * 
 * (code)
 * var layout = new mxEdgeLabelLayout(graph);
 * layout.execute(graph.getDefaultParent());
 * (end)
 * 
 * Constructor: mxEdgeLabelLayout
 *
 * Constructs a new edge label layout.
 *
 * Arguments:
 * 
 * graph - <mxGraph> that contains the cells.
 */
function mxEdgeLabelLayout(graph, radius)
{
\tmxGraphLayout.call(this, graph);
};

/**
 * Extends mxGraphLayout.
 */
mxEdgeLabelLayout.prototype = new mxGraphLayout();
mxEdgeLabelLayout.prototype.constructor = mxEdgeLabelLayout;

/**
 * Function: execute
 * 
 * Implements <mxGraphLayout.execute>.
 */
mxEdgeLabelLayout.prototype.execute = function(parent)
{
\tvar view = this.graph.view;
\tvar model = this.graph.getModel();
\t
\t// Gets all vertices and edges inside the parent
\tvar edges = [];
\tvar vertices = [];
\tvar childCount = model.getChildCount(parent);
\t
\tfor (var i = 0; i < childCount; i++)
\t{
\t\tvar cell = model.getChildAt(parent, i);
\t\tvar state = view.getState(cell);
\t\t
\t\tif (state != null)
\t\t{
\t\t\tif (!this.isVertexIgnored(cell))
\t\t\t{
\t\t\t\tvertices.push(state);
\t\t\t}
\t\t\telse if (!this.isEdgeIgnored(cell))
\t\t\t{
\t\t\t\tedges.push(state);
\t\t\t}
\t\t}
\t}
\t
\tthis.placeLabels(vertices, edges);
};

/**
 * Function: placeLabels
 * 
 * Places the labels of the given edges.
 */
mxEdgeLabelLayout.prototype.placeLabels = function(v, e)
{
\tvar model = this.graph.getModel();
\t
\t// Moves the vertices to build a circle. Makes sure the
\t// radius is large enough for the vertices to not
\t// overlap
\tmodel.beginUpdate();
\ttry
\t{
\t\tfor (var i = 0; i < e.length; i++)
\t\t{
\t\t\tvar edge = e[i];
\t\t\t
\t\t\tif (edge != null && edge.text != null &&
\t\t\t\tedge.text.boundingBox != null)
\t\t\t{
\t\t\t\tfor (var j = 0; j < v.length; j++)
\t\t\t\t{
\t\t\t\t\tvar vertex = v[j];
\t\t\t\t\t
\t\t\t\t\tif (vertex != null)
\t\t\t\t\t{
\t\t\t\t\t\tthis.avoid(edge, vertex);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\tfinally
\t{
\t\tmodel.endUpdate();
\t}
};

/**
 * Function: avoid
 * 
 * Places the labels of the given edges.
 */
mxEdgeLabelLayout.prototype.avoid = function(edge, vertex)
{
\tvar model = this.graph.getModel();
\tvar labRect = edge.text.boundingBox;
\t
\tif (mxUtils.intersects(labRect, vertex))
\t{
\t\tvar dy1 = -labRect.y - labRect.height + vertex.y;
\t\tvar dy2 = -labRect.y + vertex.y + vertex.height;
\t\t
\t\tvar dy = (Math.abs(dy1) < Math.abs(dy2)) ? dy1 : dy2;
\t\t
\t\tvar dx1 = -labRect.x - labRect.width + vertex.x;
\t\tvar dx2 = -labRect.x + vertex.x + vertex.width;
\t
\t\tvar dx = (Math.abs(dx1) < Math.abs(dx2)) ? dx1 : dx2;
\t\t
\t\tif (Math.abs(dx) < Math.abs(dy))
\t\t{
\t\t\tdy = 0;
\t\t}
\t\telse
\t\t{
\t\t\tdx = 0;
\t\t}
\t
\t\tvar g = model.getGeometry(edge.cell);
\t\t
\t\tif (g != null)
\t\t{
\t\t\tg = g.clone();
\t\t\t
\t\t\tif (g.offset != null)
\t\t\t{
\t\t\t\tg.offset.x += dx;
\t\t\t\tg.offset.y += dy;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tg.offset = new mxPoint(dx, dy);
\t\t\t}
\t\t\t
\t\t\tmodel.setGeometry(edge.cell, g);
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxGraphAbstractHierarchyCell
 * 
 * An abstraction of an internal hierarchy node or edge
 * 
 * Constructor: mxGraphAbstractHierarchyCell
 *
 * Constructs a new hierarchical layout algorithm.
 */
function mxGraphAbstractHierarchyCell()
{
\tthis.x = [];
\tthis.y = [];
\tthis.temp = [];
};

/**
 * Variable: maxRank
 * 
 * The maximum rank this cell occupies. Default is -1.
 */
mxGraphAbstractHierarchyCell.prototype.maxRank = -1;

/**
 * Variable: minRank
 * 
 * The minimum rank this cell occupies. Default is -1.
 */
mxGraphAbstractHierarchyCell.prototype.minRank = -1;

/**
 * Variable: x
 * 
 * The x position of this cell for each layer it occupies
 */
mxGraphAbstractHierarchyCell.prototype.x = null;

/**
 * Variable: y
 * 
 * The y position of this cell for each layer it occupies
 */
mxGraphAbstractHierarchyCell.prototype.y = null;

/**
 * Variable: width
 * 
 * The width of this cell. Default is 0.
 */
mxGraphAbstractHierarchyCell.prototype.width = 0;

/**
 * Variable: height
 * 
 * The height of this cell. Default is 0.
 */
mxGraphAbstractHierarchyCell.prototype.height = 0;

/**
 * Variable: nextLayerConnectedCells
 * 
 * A cached version of the cells this cell connects to on the next layer up
 */
mxGraphAbstractHierarchyCell.prototype.nextLayerConnectedCells = null;

/**
 * Variable: previousLayerConnectedCells
 * 
 * A cached version of the cells this cell connects to on the next layer down
 */
mxGraphAbstractHierarchyCell.prototype.previousLayerConnectedCells = null;

/**
 * Variable: temp
 * 
 * Temporary variable for general use. Generally, try to avoid
 * carrying information between stages. Currently, the longest
 * path layering sets temp to the rank position in fixRanks()
 * and the crossing reduction uses this. This meant temp couldn't
 * be used for hashing the nodes in the model dfs and so hashCode
 * was created
 */
mxGraphAbstractHierarchyCell.prototype.temp = null;

/**
 * Function: getNextLayerConnectedCells
 * 
 * Returns the cells this cell connects to on the next layer up
 */
mxGraphAbstractHierarchyCell.prototype.getNextLayerConnectedCells = function(layer)
{
\treturn null;
};

/**
 * Function: getPreviousLayerConnectedCells
 * 
 * Returns the cells this cell connects to on the next layer down
 */
mxGraphAbstractHierarchyCell.prototype.getPreviousLayerConnectedCells = function(layer)
{
\treturn null;
};

/**
 * Function: isEdge
 * 
 * Returns whether or not this cell is an edge
 */
mxGraphAbstractHierarchyCell.prototype.isEdge = function()
{
\treturn false;
};

/**
 * Function: isVertex
 * 
 * Returns whether or not this cell is a node
 */
mxGraphAbstractHierarchyCell.prototype.isVertex = function()
{
\treturn false;
};

/**
 * Function: getGeneralPurposeVariable
 * 
 * Gets the value of temp for the specified layer
 */
mxGraphAbstractHierarchyCell.prototype.getGeneralPurposeVariable = function(layer)
{
\treturn null;
};

/**
 * Function: setGeneralPurposeVariable
 * 
 * Set the value of temp for the specified layer
 */
mxGraphAbstractHierarchyCell.prototype.setGeneralPurposeVariable = function(layer, value)
{
\treturn null;
};

/**
 * Function: setX
 * 
 * Set the value of x for the specified layer
 */
mxGraphAbstractHierarchyCell.prototype.setX = function(layer, value)
{
\tif (this.isVertex())
\t{
\t\tthis.x[0] = value;
\t}
\telse if (this.isEdge())
\t{
\t\tthis.x[layer - this.minRank - 1] = value;
\t}
};

/**
 * Function: getX
 * 
 * Gets the value of x on the specified layer
 */
mxGraphAbstractHierarchyCell.prototype.getX = function(layer)
{
\tif (this.isVertex())
\t{
\t\treturn this.x[0];
\t}
\telse if (this.isEdge())
\t{
\t\treturn this.x[layer - this.minRank - 1];
\t}

\treturn 0.0;
};

/**
 * Function: setY
 * 
 * Set the value of y for the specified layer
 */
mxGraphAbstractHierarchyCell.prototype.setY = function(layer, value)
{
\tif (this.isVertex())
\t{
\t\tthis.y[0] = value;
\t}
\telse if (this.isEdge())
\t{
\t\tthis.y[layer -this. minRank - 1] = value;
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxGraphHierarchyNode
 * 
 * An abstraction of a hierarchical edge for the hierarchy layout
 * 
 * Constructor: mxGraphHierarchyNode
 *
 * Constructs an internal node to represent the specified real graph cell
 *
 * Arguments:
 * 
 * cell - the real graph cell this node represents
 */
function mxGraphHierarchyNode(cell)
{
\tmxGraphAbstractHierarchyCell.apply(this, arguments);
\tthis.cell = cell;
\tthis.id = mxObjectIdentity.get(cell);
\tthis.connectsAsTarget = [];
\tthis.connectsAsSource = [];
};

/**
 * Extends mxGraphAbstractHierarchyCell.
 */
mxGraphHierarchyNode.prototype = new mxGraphAbstractHierarchyCell();
mxGraphHierarchyNode.prototype.constructor = mxGraphHierarchyNode;

/**
 * Variable: cell
 * 
 * The graph cell this object represents.
 */
mxGraphHierarchyNode.prototype.cell = null;

/**
 * Variable: id
 * 
 * The object identity of the wrapped cell
 */
mxGraphHierarchyNode.prototype.id = null;

/**
 * Variable: connectsAsTarget
 * 
 * Collection of hierarchy edges that have this node as a target
 */
mxGraphHierarchyNode.prototype.connectsAsTarget = null;

/**
 * Variable: connectsAsSource
 * 
 * Collection of hierarchy edges that have this node as a source
 */
mxGraphHierarchyNode.prototype.connectsAsSource = null;

/**
 * Variable: hashCode
 * 
 * Assigns a unique hashcode for each node. Used by the model dfs instead
 * of copying HashSets
 */
mxGraphHierarchyNode.prototype.hashCode = false;

/**
 * Function: getRankValue
 * 
 * Returns the integer value of the layer that this node resides in
 */
mxGraphHierarchyNode.prototype.getRankValue = function(layer)
{
\treturn this.maxRank;
};

/**
 * Function: getNextLayerConnectedCells
 * 
 * Returns the cells this cell connects to on the next layer up
 */
mxGraphHierarchyNode.prototype.getNextLayerConnectedCells = function(layer)
{
\tif (this.nextLayerConnectedCells == null)
\t{
\t\tthis.nextLayerConnectedCells = [];
\t\tthis.nextLayerConnectedCells[0] = [];
\t\t
\t\tfor (var i = 0; i < this.connectsAsTarget.length; i++)
\t\t{
\t\t\tvar edge = this.connectsAsTarget[i];

\t\t\tif (edge.maxRank == -1 || edge.maxRank == layer + 1)
\t\t\t{
\t\t\t\t// Either edge is not in any rank or
\t\t\t\t// no dummy nodes in edge, add node of other side of edge
\t\t\t\tthis.nextLayerConnectedCells[0].push(edge.source);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// Edge spans at least two layers, add edge
\t\t\t\tthis.nextLayerConnectedCells[0].push(edge);
\t\t\t}
\t\t}
\t}

\treturn this.nextLayerConnectedCells[0];
};

/**
 * Function: getPreviousLayerConnectedCells
 * 
 * Returns the cells this cell connects to on the next layer down
 */
mxGraphHierarchyNode.prototype.getPreviousLayerConnectedCells = function(layer)
{
\tif (this.previousLayerConnectedCells == null)
\t{
\t\tthis.previousLayerConnectedCells = [];
\t\tthis.previousLayerConnectedCells[0] = [];
\t\t
\t\tfor (var i = 0; i < this.connectsAsSource.length; i++)
\t\t{
\t\t\tvar edge = this.connectsAsSource[i];

\t\t\tif (edge.minRank == -1 || edge.minRank == layer - 1)
\t\t\t{
\t\t\t\t// No dummy nodes in edge, add node of other side of edge
\t\t\t\tthis.previousLayerConnectedCells[0].push(edge.target);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// Edge spans at least two layers, add edge
\t\t\t\tthis.previousLayerConnectedCells[0].push(edge);
\t\t\t}
\t\t}
\t}

\treturn this.previousLayerConnectedCells[0];
};

/**
 * Function: isVertex
 * 
 * Returns true.
 */
mxGraphHierarchyNode.prototype.isVertex = function()
{
\treturn true;
};

/**
 * Function: getGeneralPurposeVariable
 * 
 * Gets the value of temp for the specified layer
 */
mxGraphHierarchyNode.prototype.getGeneralPurposeVariable = function(layer)
{
\treturn this.temp[0];
};

/**
 * Function: setGeneralPurposeVariable
 * 
 * Set the value of temp for the specified layer
 */
mxGraphHierarchyNode.prototype.setGeneralPurposeVariable = function(layer, value)
{
\tthis.temp[0] = value;
};

/**
 * Function: isAncestor
 */
mxGraphHierarchyNode.prototype.isAncestor = function(otherNode)
{
\t// Firstly, the hash code of this node needs to be shorter than the
\t// other node
\tif (otherNode != null && this.hashCode != null && otherNode.hashCode != null
\t\t\t&& this.hashCode.length < otherNode.hashCode.length)
\t{
\t\tif (this.hashCode == otherNode.hashCode)
\t\t{
\t\t\treturn true;
\t\t}
\t\t
\t\tif (this.hashCode == null || this.hashCode == null)
\t\t{
\t\t\treturn false;
\t\t}
\t\t
\t\t// Secondly, this hash code must match the start of the other
\t\t// node's hash code. Arrays.equals cannot be used here since
\t\t// the arrays are different length, and we do not want to
\t\t// perform another array copy.
\t\tfor (var i = 0; i < this.hashCode.length; i++)
\t\t{
\t\t\tif (this.hashCode[i] != otherNode.hashCode[i])
\t\t\t{
\t\t\t\treturn false;
\t\t\t}
\t\t}

\t\treturn true;
\t}

\treturn false;
};

/**
 * Function: getCoreCell
 * 
 * Gets the core vertex associated with this wrapper
 */
mxGraphHierarchyNode.prototype.getCoreCell = function()
{
\treturn this.cell;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxGraphHierarchyEdge
 * 
 * An abstraction of a hierarchical edge for the hierarchy layout
 * 
 * Constructor: mxGraphHierarchyEdge
 *
 * Constructs a hierarchy edge
 *
 * Arguments:
 * 
 * edges - a list of real graph edges this abstraction represents
 */
function mxGraphHierarchyEdge(edges)
{
\tmxGraphAbstractHierarchyCell.apply(this, arguments);
\tthis.edges = edges;
\tthis.ids = [];
\t
\tfor (var i = 0; i < edges.length; i++)
\t{
\t\tthis.ids.push(mxObjectIdentity.get(edges[i]));
\t}
};

/**
 * Extends mxGraphAbstractHierarchyCell.
 */
mxGraphHierarchyEdge.prototype = new mxGraphAbstractHierarchyCell();
mxGraphHierarchyEdge.prototype.constructor = mxGraphHierarchyEdge;

/**
 * Variable: edges
 * 
 * The graph edge(s) this object represents. Parallel edges are all grouped
 * together within one hierarchy edge.
 */
mxGraphHierarchyEdge.prototype.edges = null;

/**
 * Variable: ids
 * 
 * The object identities of the wrapped cells
 */
mxGraphHierarchyEdge.prototype.ids = null;

/**
 * Variable: source
 * 
 * The node this edge is sourced at
 */
mxGraphHierarchyEdge.prototype.source = null;

/**
 * Variable: target
 * 
 * The node this edge targets
 */
mxGraphHierarchyEdge.prototype.target = null;

/**
 * Variable: isReversed
 * 
 * Whether or not the direction of this edge has been reversed
 * internally to create a DAG for the hierarchical layout
 */
mxGraphHierarchyEdge.prototype.isReversed = false;

/**
 * Function: invert
 * 
 * Inverts the direction of this internal edge(s)
 */
mxGraphHierarchyEdge.prototype.invert = function(layer)
{
\tvar temp = this.source;
\tthis.source = this.target;
\tthis.target = temp;
\tthis.isReversed = !this.isReversed;
};

/**
 * Function: getNextLayerConnectedCells
 * 
 * Returns the cells this cell connects to on the next layer up
 */
mxGraphHierarchyEdge.prototype.getNextLayerConnectedCells = function(layer)
{
\tif (this.nextLayerConnectedCells == null)
\t{
\t\tthis.nextLayerConnectedCells = [];
\t\t
\t\tfor (var i = 0; i < this.temp.length; i++)
\t\t{
\t\t\tthis.nextLayerConnectedCells[i] = [];
\t\t\t
\t\t\tif (i == this.temp.length - 1)
\t\t\t{
\t\t\t\tthis.nextLayerConnectedCells[i].push(this.source);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.nextLayerConnectedCells[i].push(this);
\t\t\t}
\t\t}
\t}
\t
\treturn this.nextLayerConnectedCells[layer - this.minRank - 1];
};

/**
 * Function: getPreviousLayerConnectedCells
 * 
 * Returns the cells this cell connects to on the next layer down
 */
mxGraphHierarchyEdge.prototype.getPreviousLayerConnectedCells = function(layer)
{
\tif (this.previousLayerConnectedCells == null)
\t{
\t\tthis.previousLayerConnectedCells = [];

\t\tfor (var i = 0; i < this.temp.length; i++)
\t\t{
\t\t\tthis.previousLayerConnectedCells[i] = [];
\t\t\t
\t\t\tif (i == 0)
\t\t\t{
\t\t\t\tthis.previousLayerConnectedCells[i].push(this.target);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tthis.previousLayerConnectedCells[i].push(this);
\t\t\t}
\t\t}
\t}

\treturn this.previousLayerConnectedCells[layer - this.minRank - 1];
};

/**
 * Function: isEdge
 * 
 * Returns true.
 */
mxGraphHierarchyEdge.prototype.isEdge = function()
{
\treturn true;
};

/**
 * Function: getGeneralPurposeVariable
 * 
 * Gets the value of temp for the specified layer
 */
mxGraphHierarchyEdge.prototype.getGeneralPurposeVariable = function(layer)
{
\treturn this.temp[layer - this.minRank - 1];
};

/**
 * Function: setGeneralPurposeVariable
 * 
 * Set the value of temp for the specified layer
 */
mxGraphHierarchyEdge.prototype.setGeneralPurposeVariable = function(layer, value)
{
\tthis.temp[layer - this.minRank - 1] = value;
};

/**
 * Function: getCoreCell
 * 
 * Gets the first core edge associated with this wrapper
 */
mxGraphHierarchyEdge.prototype.getCoreCell = function()
{
\tif (this.edges != null && this.edges.length > 0)
\t{
\t\treturn this.edges[0];
\t}
\t
\treturn null;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxGraphHierarchyModel
 *
 * Internal model of a hierarchical graph. This model stores nodes and edges
 * equivalent to the real graph nodes and edges, but also stores the rank of the
 * cells, the order within the ranks and the new candidate locations of cells.
 * The internal model also reverses edge direction were appropriate , ignores
 * self-loop and groups parallels together under one edge object.
 *
 * Constructor: mxGraphHierarchyModel
 *
 * Creates an internal ordered graph model using the vertices passed in. If
 * there are any, leftward edge need to be inverted in the internal model
 *
 * Arguments:
 *
 * graph - the facade describing the graph to be operated on
 * vertices - the vertices for this hierarchy
 * ordered - whether or not the vertices are already ordered
 * deterministic - whether or not this layout should be deterministic on each
 * tightenToSource - whether or not to tighten vertices towards the sources
 * scanRanksFromSinks - Whether rank assignment is from the sinks or sources.
 * usage
 */
function mxGraphHierarchyModel(layout, vertices, roots, parent, tightenToSource)
{
\tvar graph = layout.getGraph();
\tthis.tightenToSource = tightenToSource;
\tthis.roots = roots;
\tthis.parent = parent;

\t// map of cells to internal cell needed for second run through
\t// to setup the sink of edges correctly
\tthis.vertexMapper = new mxDictionary();
\tthis.edgeMapper = new mxDictionary();
\tthis.maxRank = 0;
\tvar internalVertices = [];

\tif (vertices == null)
\t{
\t\tvertices = this.graph.getChildVertices(parent);
\t}

\tthis.maxRank = this.SOURCESCANSTARTRANK;
\t// map of cells to internal cell needed for second run through
\t// to setup the sink of edges correctly. Guess size by number
\t// of edges is roughly same as number of vertices.
\tthis.createInternalCells(layout, vertices, internalVertices);

\t// Go through edges set their sink values. Also check the
\t// ordering if and invert edges if necessary
\tfor (var i = 0; i < vertices.length; i++)
\t{
\t\tvar edges = internalVertices[i].connectsAsSource;

\t\tfor (var j = 0; j < edges.length; j++)
\t\t{
\t\t\tvar internalEdge = edges[j];
\t\t\tvar realEdges = internalEdge.edges;

\t\t\t// Only need to process the first real edge, since
\t\t\t// all the edges connect to the same other vertex
\t\t\tif (realEdges != null && realEdges.length > 0)
\t\t\t{
\t\t\t\tvar realEdge = realEdges[0];
\t\t\t\tvar targetCell = layout.getVisibleTerminal(
\t\t\t\t\t\trealEdge, false);
\t\t\t\tvar internalTargetCell = this.vertexMapper.get(targetCell);

\t\t\t\tif (internalVertices[i] == internalTargetCell)
\t\t\t\t{
\t\t\t\t\t// If there are parallel edges going between two vertices and not all are in the same direction
\t\t\t\t\t// you can have navigated across one direction when doing the cycle reversal that isn't the same
\t\t\t\t\t// direction as the first real edge in the array above. When that happens the if above catches
\t\t\t\t\t// that and we correct the target cell before continuing.
\t\t\t\t\t// This branch only detects this single case
\t\t\t\t\ttargetCell = layout.getVisibleTerminal(
\t\t\t\t\t\t\trealEdge, true);
\t\t\t\t\tinternalTargetCell = this.vertexMapper.get(targetCell);
\t\t\t\t}
\t\t\t\t
\t\t\t\tif (internalTargetCell != null
\t\t\t\t\t\t&& internalVertices[i] != internalTargetCell)
\t\t\t\t{
\t\t\t\t\tinternalEdge.target = internalTargetCell;

\t\t\t\t\tif (internalTargetCell.connectsAsTarget.length == 0)
\t\t\t\t\t{
\t\t\t\t\t\tinternalTargetCell.connectsAsTarget = [];
\t\t\t\t\t}

\t\t\t\t\tif (mxUtils.indexOf(internalTargetCell.connectsAsTarget, internalEdge) < 0)
\t\t\t\t\t{
\t\t\t\t\t\tinternalTargetCell.connectsAsTarget.push(internalEdge);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}

\t\t// Use the temp variable in the internal nodes to mark this
\t\t// internal vertex as having been visited.
\t\tinternalVertices[i].temp[0] = 1;
\t}
};

/**
 * Variable: maxRank
 *
 * Stores the largest rank number allocated
 */
mxGraphHierarchyModel.prototype.maxRank = null;

/**
 * Variable: vertexMapper
 *
 * Map from graph vertices to internal model nodes.
 */
mxGraphHierarchyModel.prototype.vertexMapper = null;

/**
 * Variable: edgeMapper
 *
 * Map from graph edges to internal model edges
 */
mxGraphHierarchyModel.prototype.edgeMapper = null;

/**
 * Variable: ranks
 *
 * Mapping from rank number to actual rank
 */
mxGraphHierarchyModel.prototype.ranks = null;

/**
 * Variable: roots
 *
 * Store of roots of this hierarchy model, these are real graph cells, not
 * internal cells
 */
mxGraphHierarchyModel.prototype.roots = null;

/**
 * Variable: parent
 *
 * The parent cell whose children are being laid out
 */
mxGraphHierarchyModel.prototype.parent = null;

/**
 * Variable: dfsCount
 *
 * Count of the number of times the ancestor dfs has been used.
 */
mxGraphHierarchyModel.prototype.dfsCount = 0;

/**
 * Variable: SOURCESCANSTARTRANK
 *
 * High value to start source layering scan rank value from.
 */
mxGraphHierarchyModel.prototype.SOURCESCANSTARTRANK = 100000000;

/**
 * Variable: tightenToSource
 *
 * Whether or not to tighten the assigned ranks of vertices up towards
 * the source cells.
 */
mxGraphHierarchyModel.prototype.tightenToSource = false;

/**
 * Function: createInternalCells
 *
 * Creates all edges in the internal model
 *
 * Parameters:
 *
 * layout - Reference to the <mxHierarchicalLayout> algorithm.
 * vertices - Array of <mxCells> that represent the vertices whom are to
 * have an internal representation created.
 * internalVertices - The array of <mxGraphHierarchyNodes> to have their
 * information filled in using the real vertices.
 */
mxGraphHierarchyModel.prototype.createInternalCells = function(layout, vertices, internalVertices)
{
\tvar graph = layout.getGraph();

\t// Create internal edges
\tfor (var i = 0; i < vertices.length; i++)
\t{
\t\tinternalVertices[i] = new mxGraphHierarchyNode(vertices[i]);
\t\tthis.vertexMapper.put(vertices[i], internalVertices[i]);

\t\t// If the layout is deterministic, order the cells
\t\t//List outgoingCells = graph.getNeighbours(vertices[i], deterministic);
\t\tvar conns = layout.getEdges(vertices[i]);
\t\tinternalVertices[i].connectsAsSource = [];

\t\t// Create internal edges, but don't do any rank assignment yet
\t\t// First use the information from the greedy cycle remover to
\t\t// invert the leftward edges internally
\t\tfor (var j = 0; j < conns.length; j++)
\t\t{
\t\t\tvar cell = layout.getVisibleTerminal(conns[j], false);

\t\t\t// Looking for outgoing edges only
\t\t\tif (cell != vertices[i] && layout.graph.model.isVertex(cell) &&
\t\t\t\t\t!layout.isVertexIgnored(cell))
\t\t\t{
\t\t\t\t// We process all edge between this source and its targets
\t\t\t\t// If there are edges going both ways, we need to collect
\t\t\t\t// them all into one internal edges to avoid looping problems
\t\t\t\t// later. We assume this direction (source -> target) is the 
\t\t\t\t// natural direction if at least half the edges are going in
\t\t\t\t// that direction.

\t\t\t\t// The check below for edges[0] being in the vertex mapper is
\t\t\t\t// in case we've processed this the other way around
\t\t\t\t// (target -> source) and the number of edges in each direction
\t\t\t\t// are the same. All the graph edges will have been assigned to
\t\t\t\t// an internal edge going the other way, so we don't want to 
\t\t\t\t// process them again
\t\t\t\tvar undirectedEdges = layout.getEdgesBetween(vertices[i],
\t\t\t\t\t\tcell, false);
\t\t\t\tvar directedEdges = layout.getEdgesBetween(vertices[i],
\t\t\t\t\t\tcell, true);
\t\t\t\t
\t\t\t\tif (undirectedEdges != null &&
\t\t\t\t\t\tundirectedEdges.length > 0 &&
\t\t\t\t\t\tthis.edgeMapper.get(undirectedEdges[0]) == null &&
\t\t\t\t\t\tdirectedEdges.length * 2 >= undirectedEdges.length)
\t\t\t\t{
\t\t\t\t\tvar internalEdge = new mxGraphHierarchyEdge(undirectedEdges);

\t\t\t\t\tfor (var k = 0; k < undirectedEdges.length; k++)
\t\t\t\t\t{
\t\t\t\t\t\tvar edge = undirectedEdges[k];
\t\t\t\t\t\tthis.edgeMapper.put(edge, internalEdge);

\t\t\t\t\t\t// Resets all point on the edge and disables the edge style
\t\t\t\t\t\t// without deleting it from the cell style
\t\t\t\t\t\tgraph.resetEdge(edge);

\t\t\t\t\t    if (layout.disableEdgeStyle)
\t\t\t\t\t    {
\t\t\t\t\t    \tlayout.setEdgeStyleEnabled(edge, false);
\t\t\t\t\t    \tlayout.setOrthogonalEdge(edge,true);
\t\t\t\t\t    }
\t\t\t\t\t}

\t\t\t\t\tinternalEdge.source = internalVertices[i];

\t\t\t\t\tif (mxUtils.indexOf(internalVertices[i].connectsAsSource, internalEdge) < 0)
\t\t\t\t\t{
\t\t\t\t\t\tinternalVertices[i].connectsAsSource.push(internalEdge);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}

\t\t// Ensure temp variable is cleared from any previous use
\t\tinternalVertices[i].temp[0] = 0;
\t}
};

/**
 * Function: initialRank
 *
 * Basic determination of minimum layer ranking by working from from sources
 * or sinks and working through each node in the relevant edge direction.
 * Starting at the sinks is basically a longest path layering algorithm.
*/
mxGraphHierarchyModel.prototype.initialRank = function()
{
\tvar startNodes = [];

\tif (this.roots != null)
\t{
\t\tfor (var i = 0; i < this.roots.length; i++)
\t\t{
\t\t\tvar internalNode = this.vertexMapper.get(this.roots[i]);

\t\t\tif (internalNode != null)
\t\t\t{
\t\t\t\tstartNodes.push(internalNode);
\t\t\t}
\t\t}
\t}

\tvar internalNodes = this.vertexMapper.getValues();
\t
\tfor (var i=0; i < internalNodes.length; i++)
\t{
\t\t// Mark the node as not having had a layer assigned
\t\tinternalNodes[i].temp[0] = -1;
\t}

\tvar startNodesCopy = startNodes.slice();

\twhile (startNodes.length > 0)
\t{
\t\tvar internalNode = startNodes[0];
\t\tvar layerDeterminingEdges;
\t\tvar edgesToBeMarked;

\t\tlayerDeterminingEdges = internalNode.connectsAsTarget;
\t\tedgesToBeMarked = internalNode.connectsAsSource;

\t\t// flag to keep track of whether or not all layer determining
\t\t// edges have been scanned
\t\tvar allEdgesScanned = true;

\t\t// Work out the layer of this node from the layer determining
\t\t// edges. The minimum layer number of any node connected by one of
\t\t// the layer determining edges variable
\t\tvar minimumLayer = this.SOURCESCANSTARTRANK;

\t\tfor (var i = 0; i < layerDeterminingEdges.length; i++)
\t\t{
\t\t\tvar internalEdge = layerDeterminingEdges[i];

\t\t\tif (internalEdge.temp[0] == 5270620)
\t\t\t{
\t\t\t\t// This edge has been scanned, get the layer of the
\t\t\t\t// node on the other end
\t\t\t\tvar otherNode = internalEdge.source;
\t\t\t\tminimumLayer = Math.min(minimumLayer, otherNode.temp[0] - 1);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tallEdgesScanned = false;

\t\t\t\tbreak;
\t\t\t}
\t\t}

\t\t// If all edge have been scanned, assign the layer, mark all
\t\t// edges in the other direction and remove from the nodes list
\t\tif (allEdgesScanned)
\t\t{
\t\t\tinternalNode.temp[0] = minimumLayer;
\t\t\tthis.maxRank = Math.min(this.maxRank, minimumLayer);

\t\t\tif (edgesToBeMarked != null)
\t\t\t{
\t\t\t\tfor (var i = 0; i < edgesToBeMarked.length; i++)
\t\t\t\t{
\t\t\t\t\tvar internalEdge = edgesToBeMarked[i];

\t\t\t\t\t// Assign unique stamp ( y/m/d/h )
\t\t\t\t\tinternalEdge.temp[0] = 5270620;

\t\t\t\t\t// Add node on other end of edge to LinkedList of
\t\t\t\t\t// nodes to be analysed
\t\t\t\t\tvar otherNode = internalEdge.target;

\t\t\t\t\t// Only add node if it hasn't been assigned a layer
\t\t\t\t\tif (otherNode.temp[0] == -1)
\t\t\t\t\t{
\t\t\t\t\t\tstartNodes.push(otherNode);

\t\t\t\t\t\t// Mark this other node as neither being
\t\t\t\t\t\t// unassigned nor assigned so it isn't
\t\t\t\t\t\t// added to this list again, but it's
\t\t\t\t\t\t// layer isn't used in any calculation.
\t\t\t\t\t\totherNode.temp[0] = -2;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}

\t\t\tstartNodes.shift();
\t\t}
\t\telse
\t\t{
\t\t\t// Not all the edges have been scanned, get to the back of
\t\t\t// the class and put the dunces cap on
\t\t\tvar removedCell = startNodes.shift();
\t\t\tstartNodes.push(internalNode);

\t\t\tif (removedCell == internalNode && startNodes.length == 1)
\t\t\t{
\t\t\t\t// This is an error condition, we can't get out of
\t\t\t\t// this loop. It could happen for more than one node
\t\t\t\t// but that's a lot harder to detect. Log the error
\t\t\t\t// TODO make log comment
\t\t\t\tbreak;
\t\t\t}
\t\t}
\t}

\t// Normalize the ranks down from their large starting value to place
\t// at least 1 sink on layer 0
\tfor (var i=0; i < internalNodes.length; i++)
\t{
\t\t// Mark the node as not having had a layer assigned
\t\tinternalNodes[i].temp[0] -= this.maxRank;
\t}
\t
\t// Tighten the rank 0 nodes as far as possible
\tfor ( var i = 0; i < startNodesCopy.length; i++)
\t{
\t\tvar internalNode = startNodesCopy[i];
\t\tvar currentMaxLayer = 0;
\t\tvar layerDeterminingEdges = internalNode.connectsAsSource;

\t\tfor ( var j = 0; j < layerDeterminingEdges.length; j++)
\t\t{
\t\t\tvar internalEdge = layerDeterminingEdges[j];
\t\t\tvar otherNode = internalEdge.target;
\t\t\tinternalNode.temp[0] = Math.max(currentMaxLayer,
\t\t\t\t\totherNode.temp[0] + 1);
\t\t\tcurrentMaxLayer = internalNode.temp[0];
\t\t}
\t}
\t
\t// Reset the maxRank to that which would be expected for a from-sink
\t// scan
\tthis.maxRank = this.SOURCESCANSTARTRANK - this.maxRank;
};

/**
 * Function: fixRanks
 *
 * Fixes the layer assignments to the values stored in the nodes. Also needs
 * to create dummy nodes for edges that cross layers.
 */
mxGraphHierarchyModel.prototype.fixRanks = function()
{
\tvar rankList = [];
\tthis.ranks = [];

\tfor (var i = 0; i < this.maxRank + 1; i++)
\t{
\t\trankList[i] = [];
\t\tthis.ranks[i] = rankList[i];
\t}

\t// Perform a DFS to obtain an initial ordering for each rank.
\t// Without doing this you would end up having to process
\t// crossings for a standard tree.
\tvar rootsArray = null;

\tif (this.roots != null)
\t{
\t\tvar oldRootsArray = this.roots;
\t\trootsArray = [];

\t\tfor (var i = 0; i < oldRootsArray.length; i++)
\t\t{
\t\t\tvar cell = oldRootsArray[i];
\t\t\tvar internalNode = this.vertexMapper.get(cell);
\t\t\trootsArray[i] = internalNode;
\t\t}
\t}

\tthis.visit(function(parent, node, edge, layer, seen)
\t{
\t\tif (seen == 0 && node.maxRank < 0 && node.minRank < 0)
\t\t{
\t\t\trankList[node.temp[0]].push(node);
\t\t\tnode.maxRank = node.temp[0];
\t\t\tnode.minRank = node.temp[0];

\t\t\t// Set temp[0] to the nodes position in the rank
\t\t\tnode.temp[0] = rankList[node.maxRank].length - 1;
\t\t}

\t\tif (parent != null && edge != null)
\t\t{
\t\t\tvar parentToCellRankDifference = parent.maxRank - node.maxRank;

\t\t\tif (parentToCellRankDifference > 1)
\t\t\t{
\t\t\t\t// There are ranks in between the parent and current cell
\t\t\t\tedge.maxRank = parent.maxRank;
\t\t\t\tedge.minRank = node.maxRank;
\t\t\t\tedge.temp = [];
\t\t\t\tedge.x = [];
\t\t\t\tedge.y = [];

\t\t\t\tfor (var i = edge.minRank + 1; i < edge.maxRank; i++)
\t\t\t\t{
\t\t\t\t\t// The connecting edge must be added to the
\t\t\t\t\t// appropriate ranks
\t\t\t\t\trankList[i].push(edge);
\t\t\t\t\tedge.setGeneralPurposeVariable(i, rankList[i]
\t\t\t\t\t\t\t.length - 1);
\t\t\t\t}
\t\t\t}
\t\t}
\t}, rootsArray, false, null);
};

/**
 * Function: visit
 *
 * A depth first search through the internal heirarchy model.
 *
 * Parameters:
 *
 * visitor - The visitor function pattern to be called for each node.
 * trackAncestors - Whether or not the search is to keep track all nodes
 * directly above this one in the search path.
 */
mxGraphHierarchyModel.prototype.visit = function(visitor, dfsRoots, trackAncestors, seenNodes)
{
\t// Run dfs through on all roots
\tif (dfsRoots != null)
\t{
\t\tfor (var i = 0; i < dfsRoots.length; i++)
\t\t{
\t\t\tvar internalNode = dfsRoots[i];

\t\t\tif (internalNode != null)
\t\t\t{
\t\t\t\tif (seenNodes == null)
\t\t\t\t{
\t\t\t\t\tseenNodes = new Object();
\t\t\t\t}

\t\t\t\tif (trackAncestors)
\t\t\t\t{
\t\t\t\t\t// Set up hash code for root
\t\t\t\t\tinternalNode.hashCode = [];
\t\t\t\t\tinternalNode.hashCode[0] = this.dfsCount;
\t\t\t\t\tinternalNode.hashCode[1] = i;
\t\t\t\t\tthis.extendedDfs(null, internalNode, null, visitor, seenNodes,
\t\t\t\t\t\t\tinternalNode.hashCode, i, 0);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tthis.dfs(null, internalNode, null, visitor, seenNodes, 0);
\t\t\t\t}
\t\t\t}
\t\t}

\t\tthis.dfsCount++;
\t}
};

/**
 * Function: dfs
 *
 * Performs a depth first search on the internal hierarchy model
 *
 * Parameters:
 *
 * parent - the parent internal node of the current internal node
 * root - the current internal node
 * connectingEdge - the internal edge connecting the internal node and the parent
 * internal node, if any
 * visitor - the visitor pattern to be called for each node
 * seen - a set of all nodes seen by this dfs a set of all of the
 * ancestor node of the current node
 * layer - the layer on the dfs tree ( not the same as the model ranks )
 */
mxGraphHierarchyModel.prototype.dfs = function(parent, root, connectingEdge, visitor, seen, layer)
{
\tif (root != null)
\t{
\t\tvar rootId = root.id;

\t\tif (seen[rootId] == null)
\t\t{
\t\t\tseen[rootId] = root;
\t\t\tvisitor(parent, root, connectingEdge, layer, 0);

\t\t\t// Copy the connects as source list so that visitors
\t\t\t// can change the original for edge direction inversions
\t\t\tvar outgoingEdges = root.connectsAsSource.slice();
\t\t\t
\t\t\tfor (var i = 0; i< outgoingEdges.length; i++)
\t\t\t{
\t\t\t\tvar internalEdge = outgoingEdges[i];
\t\t\t\tvar targetNode = internalEdge.target;

\t\t\t\t// Root check is O(|roots|)
\t\t\t\tthis.dfs(root, targetNode, internalEdge, visitor, seen,
\t\t\t\t\t\tlayer + 1);
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\t// Use the int field to indicate this node has been seen
\t\t\tvisitor(parent, root, connectingEdge, layer, 1);
\t\t}
\t}
};

/**
 * Function: extendedDfs
 *
 * Performs a depth first search on the internal hierarchy model. This dfs
 * extends the default version by keeping track of cells ancestors, but it
 * should be only used when necessary because of it can be computationally
 * intensive for deep searches.
 *
 * Parameters:
 *
 * parent - the parent internal node of the current internal node
 * root - the current internal node
 * connectingEdge - the internal edge connecting the internal node and the parent
 * internal node, if any
 * visitor - the visitor pattern to be called for each node
 * seen - a set of all nodes seen by this dfs
 * ancestors - the parent hash code
 * childHash - the new hash code for this node
 * layer - the layer on the dfs tree ( not the same as the model ranks )
 */
mxGraphHierarchyModel.prototype.extendedDfs = function(parent, root, connectingEdge, visitor, seen, ancestors, childHash, layer)
{
\t// Explanation of custom hash set. Previously, the ancestors variable
\t// was passed through the dfs as a HashSet. The ancestors were copied
\t// into a new HashSet and when the new child was processed it was also
\t// added to the set. If the current node was in its ancestor list it
\t// meant there is a cycle in the graph and this information is passed
\t// to the visitor.visit() in the seen parameter. The HashSet clone was
\t// very expensive on CPU so a custom hash was developed using primitive
\t// types. temp[] couldn't be used so hashCode[] was added to each node.
\t// Each new child adds another int to the array, copying the prefix
\t// from its parent. Child of the same parent add different ints (the
\t// limit is therefore 2^32 children per parent...). If a node has a
\t// child with the hashCode already set then the child code is compared
\t// to the same portion of the current nodes array. If they match there
\t// is a loop.
\t// Note that the basic mechanism would only allow for 1 use of this
\t// functionality, so the root nodes have two ints. The second int is
\t// incremented through each node root and the first is incremented
\t// through each run of the dfs algorithm (therefore the dfs is not
\t// thread safe). The hash code of each node is set if not already set,
\t// or if the first int does not match that of the current run.
\tif (root != null)
\t{
\t\tif (parent != null)
\t\t{
\t\t\t// Form this nodes hash code if necessary, that is, if the
\t\t\t// hashCode variable has not been initialized or if the
\t\t\t// start of the parent hash code does not equal the start of
\t\t\t// this nodes hash code, indicating the code was set on a
\t\t\t// previous run of this dfs.
\t\t\tif (root.hashCode == null ||
\t\t\t\troot.hashCode[0] != parent.hashCode[0])
\t\t\t{
\t\t\t\tvar hashCodeLength = parent.hashCode.length + 1;
\t\t\t\troot.hashCode = parent.hashCode.slice();
\t\t\t\troot.hashCode[hashCodeLength - 1] = childHash;
\t\t\t}
\t\t}

\t\tvar rootId = root.id;

\t\tif (seen[rootId] == null)
\t\t{
\t\t\tseen[rootId] = root;
\t\t\tvisitor(parent, root, connectingEdge, layer, 0);

\t\t\t// Copy the connects as source list so that visitors
\t\t\t// can change the original for edge direction inversions
\t\t\tvar outgoingEdges = root.connectsAsSource.slice();

\t\t\tfor (var i = 0; i < outgoingEdges.length; i++)
\t\t\t{
\t\t\t\tvar internalEdge = outgoingEdges[i];
\t\t\t\tvar targetNode = internalEdge.target;

\t\t\t\t// Root check is O(|roots|)
\t\t\t\tthis.extendedDfs(root, targetNode, internalEdge, visitor, seen,
\t\t\t\t\t\troot.hashCode, i, layer + 1);
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\t// Use the int field to indicate this node has been seen
\t\t\tvisitor(parent, root, connectingEdge, layer, 1);
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2018, JGraph Ltd
 * Copyright (c) 2006-2018, Gaudenz Alder
 */
/**
 * Class: mxSwimlaneModel
 *
 * Internal model of a hierarchical graph. This model stores nodes and edges
 * equivalent to the real graph nodes and edges, but also stores the rank of the
 * cells, the order within the ranks and the new candidate locations of cells.
 * The internal model also reverses edge direction were appropriate , ignores
 * self-loop and groups parallels together under one edge object.
 *
 * Constructor: mxSwimlaneModel
 *
 * Creates an internal ordered graph model using the vertices passed in. If
 * there are any, leftward edge need to be inverted in the internal model
 *
 * Arguments:
 *
 * graph - the facade describing the graph to be operated on
 * vertices - the vertices for this hierarchy
 * ordered - whether or not the vertices are already ordered
 * deterministic - whether or not this layout should be deterministic on each
 * tightenToSource - whether or not to tighten vertices towards the sources
 * scanRanksFromSinks - Whether rank assignment is from the sinks or sources.
 * usage
 */
function mxSwimlaneModel(layout, vertices, roots, parent, tightenToSource)
{
\tvar graph = layout.getGraph();
\tthis.tightenToSource = tightenToSource;
\tthis.roots = roots;
\tthis.parent = parent;

\t// map of cells to internal cell needed for second run through
\t// to setup the sink of edges correctly
\tthis.vertexMapper = new mxDictionary();
\tthis.edgeMapper = new mxDictionary();
\tthis.maxRank = 0;
\tvar internalVertices = [];

\tif (vertices == null)
\t{
\t\tvertices = this.graph.getChildVertices(parent);
\t}

\tthis.maxRank = this.SOURCESCANSTARTRANK;
\t// map of cells to internal cell needed for second run through
\t// to setup the sink of edges correctly. Guess size by number
\t// of edges is roughly same as number of vertices.
\tthis.createInternalCells(layout, vertices, internalVertices);

\t// Go through edges set their sink values. Also check the
\t// ordering if and invert edges if necessary
\tfor (var i = 0; i < vertices.length; i++)
\t{
\t\tvar edges = internalVertices[i].connectsAsSource;

\t\tfor (var j = 0; j < edges.length; j++)
\t\t{
\t\t\tvar internalEdge = edges[j];
\t\t\tvar realEdges = internalEdge.edges;

\t\t\t// Only need to process the first real edge, since
\t\t\t// all the edges connect to the same other vertex
\t\t\tif (realEdges != null && realEdges.length > 0)
\t\t\t{
\t\t\t\tvar realEdge = realEdges[0];
\t\t\t\tvar targetCell = layout.getVisibleTerminal(
\t\t\t\t\t\trealEdge, false);
\t\t\t\tvar internalTargetCell = this.vertexMapper.get(targetCell);

\t\t\t\tif (internalVertices[i] == internalTargetCell)
\t\t\t\t{
\t\t\t\t\t// If there are parallel edges going between two vertices and not all are in the same direction
\t\t\t\t\t// you can have navigated across one direction when doing the cycle reversal that isn't the same
\t\t\t\t\t// direction as the first real edge in the array above. When that happens the if above catches
\t\t\t\t\t// that and we correct the target cell before continuing.
\t\t\t\t\t// This branch only detects this single case
\t\t\t\t\ttargetCell = layout.getVisibleTerminal(
\t\t\t\t\t\t\trealEdge, true);
\t\t\t\t\tinternalTargetCell = this.vertexMapper.get(targetCell);
\t\t\t\t}

\t\t\t\tif (internalTargetCell != null
\t\t\t\t\t\t&& internalVertices[i] != internalTargetCell)
\t\t\t\t{
\t\t\t\t\tinternalEdge.target = internalTargetCell;

\t\t\t\t\tif (internalTargetCell.connectsAsTarget.length == 0)
\t\t\t\t\t{
\t\t\t\t\t\tinternalTargetCell.connectsAsTarget = [];
\t\t\t\t\t}

\t\t\t\t\tif (mxUtils.indexOf(internalTargetCell.connectsAsTarget, internalEdge) < 0)
\t\t\t\t\t{
\t\t\t\t\t\tinternalTargetCell.connectsAsTarget.push(internalEdge);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}

\t\t// Use the temp variable in the internal nodes to mark this
\t\t// internal vertex as having been visited.
\t\tinternalVertices[i].temp[0] = 1;
\t}
};

/**
 * Variable: maxRank
 *
 * Stores the largest rank number allocated
 */
mxSwimlaneModel.prototype.maxRank = null;

/**
 * Variable: vertexMapper
 *
 * Map from graph vertices to internal model nodes.
 */
mxSwimlaneModel.prototype.vertexMapper = null;

/**
 * Variable: edgeMapper
 *
 * Map from graph edges to internal model edges
 */
mxSwimlaneModel.prototype.edgeMapper = null;

/**
 * Variable: ranks
 *
 * Mapping from rank number to actual rank
 */
mxSwimlaneModel.prototype.ranks = null;

/**
 * Variable: roots
 *
 * Store of roots of this hierarchy model, these are real graph cells, not
 * internal cells
 */
mxSwimlaneModel.prototype.roots = null;

/**
 * Variable: parent
 *
 * The parent cell whose children are being laid out
 */
mxSwimlaneModel.prototype.parent = null;

/**
 * Variable: dfsCount
 *
 * Count of the number of times the ancestor dfs has been used.
 */
mxSwimlaneModel.prototype.dfsCount = 0;

/**
 * Variable: SOURCESCANSTARTRANK
 *
 * High value to start source layering scan rank value from.
 */
mxSwimlaneModel.prototype.SOURCESCANSTARTRANK = 100000000;

/**
 * Variable: tightenToSource
 *
 * Whether or not to tighten the assigned ranks of vertices up towards
 * the source cells.
 */
mxSwimlaneModel.prototype.tightenToSource = false;

/**
 * Variable: ranksPerGroup
 *
 * An array of the number of ranks within each swimlane
 */
mxSwimlaneModel.prototype.ranksPerGroup = null;

/**
 * Function: createInternalCells
 *
 * Creates all edges in the internal model
 *
 * Parameters:
 *
 * layout - Reference to the <mxHierarchicalLayout> algorithm.
 * vertices - Array of <mxCells> that represent the vertices whom are to
 * have an internal representation created.
 * internalVertices - The array of <mxGraphHierarchyNodes> to have their
 * information filled in using the real vertices.
 */
mxSwimlaneModel.prototype.createInternalCells = function(layout, vertices, internalVertices)
{
\tvar graph = layout.getGraph();
\tvar swimlanes = layout.swimlanes;

\t// Create internal edges
\tfor (var i = 0; i < vertices.length; i++)
\t{
\t\tinternalVertices[i] = new mxGraphHierarchyNode(vertices[i]);
\t\tthis.vertexMapper.put(vertices[i], internalVertices[i]);
\t\tinternalVertices[i].swimlaneIndex = -1;

\t\tfor (var ii = 0; ii < swimlanes.length; ii++)
\t\t{
\t\t\tif (graph.model.getParent(vertices[i]) == swimlanes[ii])
\t\t\t{
\t\t\t\tinternalVertices[i].swimlaneIndex = ii;
\t\t\t\tbreak;
\t\t\t}
\t\t}

\t\t// If the layout is deterministic, order the cells
\t\t//List outgoingCells = graph.getNeighbours(vertices[i], deterministic);
\t\tvar conns = layout.getEdges(vertices[i]);
\t\tinternalVertices[i].connectsAsSource = [];

\t\t// Create internal edges, but don't do any rank assignment yet
\t\t// First use the information from the greedy cycle remover to
\t\t// invert the leftward edges internally
\t\tfor (var j = 0; j < conns.length; j++)
\t\t{
\t\t\tvar cell = layout.getVisibleTerminal(conns[j], false);

\t\t\t// Looking for outgoing edges only
\t\t\tif (cell != vertices[i] && layout.graph.model.isVertex(cell) &&
\t\t\t\t\t!layout.isVertexIgnored(cell))
\t\t\t{
\t\t\t\t// We process all edge between this source and its targets
\t\t\t\t// If there are edges going both ways, we need to collect
\t\t\t\t// them all into one internal edges to avoid looping problems
\t\t\t\t// later. We assume this direction (source -> target) is the 
\t\t\t\t// natural direction if at least half the edges are going in
\t\t\t\t// that direction.

\t\t\t\t// The check below for edges[0] being in the vertex mapper is
\t\t\t\t// in case we've processed this the other way around
\t\t\t\t// (target -> source) and the number of edges in each direction
\t\t\t\t// are the same. All the graph edges will have been assigned to
\t\t\t\t// an internal edge going the other way, so we don't want to 
\t\t\t\t// process them again
\t\t\t\tvar undirectedEdges = layout.getEdgesBetween(vertices[i],
\t\t\t\t\t\tcell, false);
\t\t\t\tvar directedEdges = layout.getEdgesBetween(vertices[i],
\t\t\t\t\t\tcell, true);
\t\t\t\t
\t\t\t\tif (undirectedEdges != null &&
\t\t\t\t\t\tundirectedEdges.length > 0 &&
\t\t\t\t\t\tthis.edgeMapper.get(undirectedEdges[0]) == null &&
\t\t\t\t\t\tdirectedEdges.length * 2 >= undirectedEdges.length)
\t\t\t\t{
\t\t\t\t\tvar internalEdge = new mxGraphHierarchyEdge(undirectedEdges);

\t\t\t\t\tfor (var k = 0; k < undirectedEdges.length; k++)
\t\t\t\t\t{
\t\t\t\t\t\tvar edge = undirectedEdges[k];
\t\t\t\t\t\tthis.edgeMapper.put(edge, internalEdge);

\t\t\t\t\t\t// Resets all point on the edge and disables the edge style
\t\t\t\t\t\t// without deleting it from the cell style
\t\t\t\t\t\tgraph.resetEdge(edge);

\t\t\t\t\t    if (layout.disableEdgeStyle)
\t\t\t\t\t    {
\t\t\t\t\t    \tlayout.setEdgeStyleEnabled(edge, false);
\t\t\t\t\t    \tlayout.setOrthogonalEdge(edge,true);
\t\t\t\t\t    }
\t\t\t\t\t}

\t\t\t\t\tinternalEdge.source = internalVertices[i];

\t\t\t\t\tif (mxUtils.indexOf(internalVertices[i].connectsAsSource, internalEdge) < 0)
\t\t\t\t\t{
\t\t\t\t\t\tinternalVertices[i].connectsAsSource.push(internalEdge);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}

\t\t// Ensure temp variable is cleared from any previous use
\t\tinternalVertices[i].temp[0] = 0;
\t}
};

/**
 * Function: initialRank
 *
 * Basic determination of minimum layer ranking by working from from sources
 * or sinks and working through each node in the relevant edge direction.
 * Starting at the sinks is basically a longest path layering algorithm.
*/
mxSwimlaneModel.prototype.initialRank = function()
{
\tthis.ranksPerGroup = [];
\t
\tvar startNodes = [];
\tvar seen = new Object();

\tif (this.roots != null)
\t{
\t\tfor (var i = 0; i < this.roots.length; i++)
\t\t{
\t\t\tvar internalNode = this.vertexMapper.get(this.roots[i]);
\t\t\tthis.maxChainDfs(null, internalNode, null, seen, 0);

\t\t\tif (internalNode != null)
\t\t\t{
\t\t\t\tstartNodes.push(internalNode);
\t\t\t}
\t\t}
\t}

\t// Calculate the lower and upper rank bounds of each swimlane
\tvar lowerRank = [];
\tvar upperRank = [];
\t
\tfor (var i = this.ranksPerGroup.length - 1; i >= 0; i--)
\t{
\t\tif (i == this.ranksPerGroup.length - 1)
\t\t{
\t\t\tlowerRank[i] = 0;
\t\t}
\t\telse
\t\t{
\t\t\tlowerRank[i] = upperRank[i+1] + 1;
\t\t}
\t\t
\t\tupperRank[i] = lowerRank[i] + this.ranksPerGroup[i];
\t}
\t
\tthis.maxRank = upperRank[0];

\tvar internalNodes = this.vertexMapper.getValues();
\t
\tfor (var i=0; i < internalNodes.length; i++)
\t{
\t\t// Mark the node as not having had a layer assigned
\t\tinternalNodes[i].temp[0] = -1;
\t}

\tvar startNodesCopy = startNodes.slice();
\t
\twhile (startNodes.length > 0)
\t{
\t\tvar internalNode = startNodes[0];
\t\tvar layerDeterminingEdges;
\t\tvar edgesToBeMarked;

\t\tlayerDeterminingEdges = internalNode.connectsAsTarget;
\t\tedgesToBeMarked = internalNode.connectsAsSource;

\t\t// flag to keep track of whether or not all layer determining
\t\t// edges have been scanned
\t\tvar allEdgesScanned = true;

\t\t// Work out the layer of this node from the layer determining
\t\t// edges. The minimum layer number of any node connected by one of
\t\t// the layer determining edges variable
\t\tvar minimumLayer = upperRank[0];

\t\tfor (var i = 0; i < layerDeterminingEdges.length; i++)
\t\t{
\t\t\tvar internalEdge = layerDeterminingEdges[i];

\t\t\tif (internalEdge.temp[0] == 5270620)
\t\t\t{
\t\t\t\t// This edge has been scanned, get the layer of the
\t\t\t\t// node on the other end
\t\t\t\tvar otherNode = internalEdge.source;
\t\t\t\tminimumLayer = Math.min(minimumLayer, otherNode.temp[0] - 1);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tallEdgesScanned = false;

\t\t\t\tbreak;
\t\t\t}
\t\t}

\t\t// If all edge have been scanned, assign the layer, mark all
\t\t// edges in the other direction and remove from the nodes list
\t\tif (allEdgesScanned)
\t\t{
\t\t\tif (minimumLayer > upperRank[internalNode.swimlaneIndex])
\t\t\t{
\t\t\t\tminimumLayer = upperRank[internalNode.swimlaneIndex];
\t\t\t}

\t\t\tinternalNode.temp[0] = minimumLayer;

\t\t\tif (edgesToBeMarked != null)
\t\t\t{
\t\t\t\tfor (var i = 0; i < edgesToBeMarked.length; i++)
\t\t\t\t{
\t\t\t\t\tvar internalEdge = edgesToBeMarked[i];

\t\t\t\t\t// Assign unique stamp ( y/m/d/h )
\t\t\t\t\tinternalEdge.temp[0] = 5270620;

\t\t\t\t\t// Add node on other end of edge to LinkedList of
\t\t\t\t\t// nodes to be analysed
\t\t\t\t\tvar otherNode = internalEdge.target;

\t\t\t\t\t// Only add node if it hasn't been assigned a layer
\t\t\t\t\tif (otherNode.temp[0] == -1)
\t\t\t\t\t{
\t\t\t\t\t\tstartNodes.push(otherNode);

\t\t\t\t\t\t// Mark this other node as neither being
\t\t\t\t\t\t// unassigned nor assigned so it isn't
\t\t\t\t\t\t// added to this list again, but it's
\t\t\t\t\t\t// layer isn't used in any calculation.
\t\t\t\t\t\totherNode.temp[0] = -2;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}

\t\t\tstartNodes.shift();
\t\t}
\t\telse
\t\t{
\t\t\t// Not all the edges have been scanned, get to the back of
\t\t\t// the class and put the dunces cap on
\t\t\tvar removedCell = startNodes.shift();
\t\t\tstartNodes.push(internalNode);

\t\t\tif (removedCell == internalNode && startNodes.length == 1)
\t\t\t{
\t\t\t\t// This is an error condition, we can't get out of
\t\t\t\t// this loop. It could happen for more than one node
\t\t\t\t// but that's a lot harder to detect. Log the error
\t\t\t\t// TODO make log comment
\t\t\t\tbreak;
\t\t\t}
\t\t}
\t}

\t// Normalize the ranks down from their large starting value to place
\t// at least 1 sink on layer 0
//\tfor (var key in this.vertexMapper)
//\t{
//\t\tvar internalNode = this.vertexMapper[key];
//\t\t// Mark the node as not having had a layer assigned
//\t\tinternalNode.temp[0] -= this.maxRank;
//\t}
\t
\t// Tighten the rank 0 nodes as far as possible
//\tfor ( var i = 0; i < startNodesCopy.length; i++)
//\t{
//\t\tvar internalNode = startNodesCopy[i];
//\t\tvar currentMaxLayer = 0;
//\t\tvar layerDeterminingEdges = internalNode.connectsAsSource;
//
//\t\tfor ( var j = 0; j < layerDeterminingEdges.length; j++)
//\t\t{
//\t\t\tvar internalEdge = layerDeterminingEdges[j];
//\t\t\tvar otherNode = internalEdge.target;
//\t\t\tinternalNode.temp[0] = Math.max(currentMaxLayer,
//\t\t\t\t\totherNode.temp[0] + 1);
//\t\t\tcurrentMaxLayer = internalNode.temp[0];
//\t\t}
//\t}
};

/**
 * Function: maxChainDfs
 *
 * Performs a depth first search on the internal hierarchy model. This dfs
 * extends the default version by keeping track of chains within groups.
 * Any cycles should be removed prior to running, but previously seen cells
 * are ignored.
 *
 * Parameters:
 *
 * parent - the parent internal node of the current internal node
 * root - the current internal node
 * connectingEdge - the internal edge connecting the internal node and the parent
 * internal node, if any
 * seen - a set of all nodes seen by this dfs
 * chainCount - the number of edges in the chain of vertices going through
 * the current swimlane
 */
mxSwimlaneModel.prototype.maxChainDfs = function(parent, root, connectingEdge, seen, chainCount)
{
\tif (root != null)
\t{
\t\tvar rootId = mxCellPath.create(root.cell);

\t\tif (seen[rootId] == null)
\t\t{
\t\t\tseen[rootId] = root;
\t\t\tvar slIndex = root.swimlaneIndex;
\t\t\t
\t\t\tif (this.ranksPerGroup[slIndex] == null || this.ranksPerGroup[slIndex] < chainCount)
\t\t\t{
\t\t\t\tthis.ranksPerGroup[slIndex] = chainCount;
\t\t\t}

\t\t\t// Copy the connects as source list so that visitors
\t\t\t// can change the original for edge direction inversions
\t\t\tvar outgoingEdges = root.connectsAsSource.slice();

\t\t\tfor (var i = 0; i < outgoingEdges.length; i++)
\t\t\t{
\t\t\t\tvar internalEdge = outgoingEdges[i];
\t\t\t\tvar targetNode = internalEdge.target;

\t\t\t\t// Only navigate in source->target direction within the same
\t\t\t\t// swimlane, or from a lower index swimlane to a higher one
\t\t\t\tif (root.swimlaneIndex < targetNode.swimlaneIndex)
\t\t\t\t{
\t\t\t\t\tthis.maxChainDfs(root, targetNode, internalEdge, mxUtils.clone(seen, null , true), 0);
\t\t\t\t}
\t\t\t\telse if (root.swimlaneIndex == targetNode.swimlaneIndex)
\t\t\t\t{
\t\t\t\t\tthis.maxChainDfs(root, targetNode, internalEdge, mxUtils.clone(seen, null , true), chainCount + 1);
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};

/**
 * Function: fixRanks
 *
 * Fixes the layer assignments to the values stored in the nodes. Also needs
 * to create dummy nodes for edges that cross layers.
 */
mxSwimlaneModel.prototype.fixRanks = function()
{
\tvar rankList = [];
\tthis.ranks = [];

\tfor (var i = 0; i < this.maxRank + 1; i++)
\t{
\t\trankList[i] = [];
\t\tthis.ranks[i] = rankList[i];
\t}

\t// Perform a DFS to obtain an initial ordering for each rank.
\t// Without doing this you would end up having to process
\t// crossings for a standard tree.
\tvar rootsArray = null;

\tif (this.roots != null)
\t{
\t\tvar oldRootsArray = this.roots;
\t\trootsArray = [];

\t\tfor (var i = 0; i < oldRootsArray.length; i++)
\t\t{
\t\t\tvar cell = oldRootsArray[i];
\t\t\tvar internalNode = this.vertexMapper.get(cell);
\t\t\trootsArray[i] = internalNode;
\t\t}
\t}

\tthis.visit(function(parent, node, edge, layer, seen)
\t{
\t\tif (seen == 0 && node.maxRank < 0 && node.minRank < 0)
\t\t{
\t\t\trankList[node.temp[0]].push(node);
\t\t\tnode.maxRank = node.temp[0];
\t\t\tnode.minRank = node.temp[0];

\t\t\t// Set temp[0] to the nodes position in the rank
\t\t\tnode.temp[0] = rankList[node.maxRank].length - 1;
\t\t}

\t\tif (parent != null && edge != null)
\t\t{
\t\t\tvar parentToCellRankDifference = parent.maxRank - node.maxRank;

\t\t\tif (parentToCellRankDifference > 1)
\t\t\t{
\t\t\t\t// There are ranks in between the parent and current cell
\t\t\t\tedge.maxRank = parent.maxRank;
\t\t\t\tedge.minRank = node.maxRank;
\t\t\t\tedge.temp = [];
\t\t\t\tedge.x = [];
\t\t\t\tedge.y = [];

\t\t\t\tfor (var i = edge.minRank + 1; i < edge.maxRank; i++)
\t\t\t\t{
\t\t\t\t\t// The connecting edge must be added to the
\t\t\t\t\t// appropriate ranks
\t\t\t\t\trankList[i].push(edge);
\t\t\t\t\tedge.setGeneralPurposeVariable(i, rankList[i]
\t\t\t\t\t\t\t.length - 1);
\t\t\t\t}
\t\t\t}
\t\t}
\t}, rootsArray, false, null);
};

/**
 * Function: visit
 *
 * A depth first search through the internal heirarchy model.
 *
 * Parameters:
 *
 * visitor - The visitor function pattern to be called for each node.
 * trackAncestors - Whether or not the search is to keep track all nodes
 * directly above this one in the search path.
 */
mxSwimlaneModel.prototype.visit = function(visitor, dfsRoots, trackAncestors, seenNodes)
{
\t// Run dfs through on all roots
\tif (dfsRoots != null)
\t{
\t\tfor (var i = 0; i < dfsRoots.length; i++)
\t\t{
\t\t\tvar internalNode = dfsRoots[i];

\t\t\tif (internalNode != null)
\t\t\t{
\t\t\t\tif (seenNodes == null)
\t\t\t\t{
\t\t\t\t\tseenNodes = new Object();
\t\t\t\t}

\t\t\t\tif (trackAncestors)
\t\t\t\t{
\t\t\t\t\t// Set up hash code for root
\t\t\t\t\tinternalNode.hashCode = [];
\t\t\t\t\tinternalNode.hashCode[0] = this.dfsCount;
\t\t\t\t\tinternalNode.hashCode[1] = i;
\t\t\t\t\tthis.extendedDfs(null, internalNode, null, visitor, seenNodes,
\t\t\t\t\t\t\tinternalNode.hashCode, i, 0);
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tthis.dfs(null, internalNode, null, visitor, seenNodes, 0);
\t\t\t\t}
\t\t\t}
\t\t}

\t\tthis.dfsCount++;
\t}
};

/**
 * Function: dfs
 *
 * Performs a depth first search on the internal hierarchy model
 *
 * Parameters:
 *
 * parent - the parent internal node of the current internal node
 * root - the current internal node
 * connectingEdge - the internal edge connecting the internal node and the parent
 * internal node, if any
 * visitor - the visitor pattern to be called for each node
 * seen - a set of all nodes seen by this dfs a set of all of the
 * ancestor node of the current node
 * layer - the layer on the dfs tree ( not the same as the model ranks )
 */
mxSwimlaneModel.prototype.dfs = function(parent, root, connectingEdge, visitor, seen, layer)
{
\tif (root != null)
\t{
\t\tvar rootId = root.id;

\t\tif (seen[rootId] == null)
\t\t{
\t\t\tseen[rootId] = root;
\t\t\tvisitor(parent, root, connectingEdge, layer, 0);

\t\t\t// Copy the connects as source list so that visitors
\t\t\t// can change the original for edge direction inversions
\t\t\tvar outgoingEdges = root.connectsAsSource.slice();
\t\t\t
\t\t\tfor (var i = 0; i< outgoingEdges.length; i++)
\t\t\t{
\t\t\t\tvar internalEdge = outgoingEdges[i];
\t\t\t\tvar targetNode = internalEdge.target;

\t\t\t\t// Root check is O(|roots|)
\t\t\t\tthis.dfs(root, targetNode, internalEdge, visitor, seen,
\t\t\t\t\t\tlayer + 1);
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\t// Use the int field to indicate this node has been seen
\t\t\tvisitor(parent, root, connectingEdge, layer, 1);
\t\t}
\t}
};

/**
 * Function: extendedDfs
 *
 * Performs a depth first search on the internal hierarchy model. This dfs
 * extends the default version by keeping track of cells ancestors, but it
 * should be only used when necessary because of it can be computationally
 * intensive for deep searches.
 *
 * Parameters:
 *
 * parent - the parent internal node of the current internal node
 * root - the current internal node
 * connectingEdge - the internal edge connecting the internal node and the parent
 * internal node, if any
 * visitor - the visitor pattern to be called for each node
 * seen - a set of all nodes seen by this dfs
 * ancestors - the parent hash code
 * childHash - the new hash code for this node
 * layer - the layer on the dfs tree ( not the same as the model ranks )
 */
mxSwimlaneModel.prototype.extendedDfs = function(parent, root, connectingEdge, visitor, seen, ancestors, childHash, layer)
{
\t// Explanation of custom hash set. Previously, the ancestors variable
\t// was passed through the dfs as a HashSet. The ancestors were copied
\t// into a new HashSet and when the new child was processed it was also
\t// added to the set. If the current node was in its ancestor list it
\t// meant there is a cycle in the graph and this information is passed
\t// to the visitor.visit() in the seen parameter. The HashSet clone was
\t// very expensive on CPU so a custom hash was developed using primitive
\t// types. temp[] couldn't be used so hashCode[] was added to each node.
\t// Each new child adds another int to the array, copying the prefix
\t// from its parent. Child of the same parent add different ints (the
\t// limit is therefore 2^32 children per parent...). If a node has a
\t// child with the hashCode already set then the child code is compared
\t// to the same portion of the current nodes array. If they match there
\t// is a loop.
\t// Note that the basic mechanism would only allow for 1 use of this
\t// functionality, so the root nodes have two ints. The second int is
\t// incremented through each node root and the first is incremented
\t// through each run of the dfs algorithm (therefore the dfs is not
\t// thread safe). The hash code of each node is set if not already set,
\t// or if the first int does not match that of the current run.
\tif (root != null)
\t{
\t\tif (parent != null)
\t\t{
\t\t\t// Form this nodes hash code if necessary, that is, if the
\t\t\t// hashCode variable has not been initialized or if the
\t\t\t// start of the parent hash code does not equal the start of
\t\t\t// this nodes hash code, indicating the code was set on a
\t\t\t// previous run of this dfs.
\t\t\tif (root.hashCode == null ||
\t\t\t\troot.hashCode[0] != parent.hashCode[0])
\t\t\t{
\t\t\t\tvar hashCodeLength = parent.hashCode.length + 1;
\t\t\t\troot.hashCode = parent.hashCode.slice();
\t\t\t\troot.hashCode[hashCodeLength - 1] = childHash;
\t\t\t}
\t\t}

\t\tvar rootId = root.id;

\t\tif (seen[rootId] == null)
\t\t{
\t\t\tseen[rootId] = root;
\t\t\tvisitor(parent, root, connectingEdge, layer, 0);

\t\t\t// Copy the connects as source list so that visitors
\t\t\t// can change the original for edge direction inversions
\t\t\tvar outgoingEdges = root.connectsAsSource.slice();
\t\t\tvar incomingEdges = root.connectsAsTarget.slice();

\t\t\tfor (var i = 0; i < outgoingEdges.length; i++)
\t\t\t{
\t\t\t\tvar internalEdge = outgoingEdges[i];
\t\t\t\tvar targetNode = internalEdge.target;
\t\t\t\t
\t\t\t\t// Only navigate in source->target direction within the same
\t\t\t\t// swimlane, or from a lower index swimlane to a higher one
\t\t\t\tif (root.swimlaneIndex <= targetNode.swimlaneIndex)
\t\t\t\t{
\t\t\t\t\tthis.extendedDfs(root, targetNode, internalEdge, visitor, seen,
\t\t\t\t\t\t\troot.hashCode, i, layer + 1);
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tfor (var i = 0; i < incomingEdges.length; i++)
\t\t\t{
\t\t\t\tvar internalEdge = incomingEdges[i];
\t\t\t\tvar targetNode = internalEdge.source;

\t\t\t\t// Only navigate in target->source direction from a lower index 
\t\t\t\t// swimlane to a higher one
\t\t\t\tif (root.swimlaneIndex < targetNode.swimlaneIndex)
\t\t\t\t{
\t\t\t\t\tthis.extendedDfs(root, targetNode, internalEdge, visitor, seen,
\t\t\t\t\t\t\troot.hashCode, i, layer + 1);
\t\t\t\t}
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\t// Use the int field to indicate this node has been seen
\t\t\tvisitor(parent, root, connectingEdge, layer, 1);
\t\t}
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxHierarchicalLayoutStage
 * 
 * The specific layout interface for hierarchical layouts. It adds a
 * <code>run</code> method with a parameter for the hierarchical layout model
 * that is shared between the layout stages.
 * 
 * Constructor: mxHierarchicalLayoutStage
 *
 * Constructs a new hierarchical layout stage.
 */
function mxHierarchicalLayoutStage() { };

/**
 * Function: execute
 * 
 * Takes the graph detail and configuration information within the facade
 * and creates the resulting laid out graph within that facade for further
 * use.
 */
mxHierarchicalLayoutStage.prototype.execute = function(parent) { };
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxMedianHybridCrossingReduction
 * 
 * Sets the horizontal locations of node and edge dummy nodes on each layer.
 * Uses median down and up weighings as well heuristic to straighten edges as
 * far as possible.
 * 
 * Constructor: mxMedianHybridCrossingReduction
 *
 * Creates a coordinate assignment.
 * 
 * Arguments:
 * 
 * intraCellSpacing - the minimum buffer between cells on the same rank
 * interRankCellSpacing - the minimum distance between cells on adjacent ranks
 * orientation - the position of the root node(s) relative to the graph
 * initialX - the leftmost coordinate node placement starts at
 */
function mxMedianHybridCrossingReduction(layout)
{
\tthis.layout = layout;
};

/**
 * Extends mxMedianHybridCrossingReduction.
 */
mxMedianHybridCrossingReduction.prototype = new mxHierarchicalLayoutStage();
mxMedianHybridCrossingReduction.prototype.constructor = mxMedianHybridCrossingReduction;

/**
 * Variable: layout
 * 
 * Reference to the enclosing <mxHierarchicalLayout>.
 */
mxMedianHybridCrossingReduction.prototype.layout = null;

/**
 * Variable: maxIterations
 * 
 * The maximum number of iterations to perform whilst reducing edge
 * crossings. Default is 24.
 */
mxMedianHybridCrossingReduction.prototype.maxIterations = 24;

/**
 * Variable: nestedBestRanks
 * 
 * Stores each rank as a collection of cells in the best order found for
 * each layer so far
 */
mxMedianHybridCrossingReduction.prototype.nestedBestRanks = null;

/**
 * Variable: currentBestCrossings
 * 
 * The total number of crossings found in the best configuration so far
 */
mxMedianHybridCrossingReduction.prototype.currentBestCrossings = 0;

/**
 * Variable: iterationsWithoutImprovement
 * 
 * The total number of crossings found in the best configuration so far
 */
mxMedianHybridCrossingReduction.prototype.iterationsWithoutImprovement = 0;

/**
 * Variable: maxNoImprovementIterations
 * 
 * The total number of crossings found in the best configuration so far
 */
mxMedianHybridCrossingReduction.prototype.maxNoImprovementIterations = 2;

/**
 * Function: execute
 * 
 * Performs a vertex ordering within ranks as described by Gansner et al
 * 1993
 */
mxMedianHybridCrossingReduction.prototype.execute = function(parent)
{
\tvar model = this.layout.getModel();

\t// Stores initial ordering as being the best one found so far
\tthis.nestedBestRanks = [];
\t
\tfor (var i = 0; i < model.ranks.length; i++)
\t{
\t\tthis.nestedBestRanks[i] = model.ranks[i].slice();
\t}

\tvar iterationsWithoutImprovement = 0;
\tvar currentBestCrossings = this.calculateCrossings(model);

\tfor (var i = 0; i < this.maxIterations &&
\t\titerationsWithoutImprovement < this.maxNoImprovementIterations; i++)
\t{
\t\tthis.weightedMedian(i, model);
\t\tthis.transpose(i, model);
\t\tvar candidateCrossings = this.calculateCrossings(model);

\t\tif (candidateCrossings < currentBestCrossings)
\t\t{
\t\t\tcurrentBestCrossings = candidateCrossings;
\t\t\titerationsWithoutImprovement = 0;

\t\t\t// Store the current rankings as the best ones
\t\t\tfor (var j = 0; j < this.nestedBestRanks.length; j++)
\t\t\t{
\t\t\t\tvar rank = model.ranks[j];

\t\t\t\tfor (var k = 0; k < rank.length; k++)
\t\t\t\t{
\t\t\t\t\tvar cell = rank[k];
\t\t\t\t\tthis.nestedBestRanks[j][cell.getGeneralPurposeVariable(j)] = cell;
\t\t\t\t}
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\t// Increase count of iterations where we haven't improved the
\t\t\t// layout
\t\t\titerationsWithoutImprovement++;

\t\t\t// Restore the best values to the cells
\t\t\tfor (var j = 0; j < this.nestedBestRanks.length; j++)
\t\t\t{
\t\t\t\tvar rank = model.ranks[j];
\t\t\t\t
\t\t\t\tfor (var k = 0; k < rank.length; k++)
\t\t\t\t{
\t\t\t\t\tvar cell = rank[k];
\t\t\t\t\tcell.setGeneralPurposeVariable(j, k);
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tif (currentBestCrossings == 0)
\t\t{
\t\t\t// Do nothing further
\t\t\tbreak;
\t\t}
\t}

\t// Store the best rankings but in the model
\tvar ranks = [];
\tvar rankList = [];

\tfor (var i = 0; i < model.maxRank + 1; i++)
\t{
\t\trankList[i] = [];
\t\tranks[i] = rankList[i];
\t}

\tfor (var i = 0; i < this.nestedBestRanks.length; i++)
\t{
\t\tfor (var j = 0; j < this.nestedBestRanks[i].length; j++)
\t\t{
\t\t\trankList[i].push(this.nestedBestRanks[i][j]);
\t\t}
\t}

\tmodel.ranks = ranks;
};


/**
 * Function: calculateCrossings
 * 
 * Calculates the total number of edge crossing in the current graph.
 * Returns the current number of edge crossings in the hierarchy graph
 * model in the current candidate layout
 * 
 * Parameters:
 * 
 * model - the internal model describing the hierarchy
 */
mxMedianHybridCrossingReduction.prototype.calculateCrossings = function(model)
{
\tvar numRanks = model.ranks.length;
\tvar totalCrossings = 0;

\tfor (var i = 1; i < numRanks; i++)
\t{
\t\ttotalCrossings += this.calculateRankCrossing(i, model);
\t}
\t
\treturn totalCrossings;
};

/**
 * Function: calculateRankCrossing
 * 
 * Calculates the number of edges crossings between the specified rank and
 * the rank below it. Returns the number of edges crossings with the rank
 * beneath
 * 
 * Parameters:
 * 
 * i -  the topmost rank of the pair ( higher rank value )
 * model - the internal model describing the hierarchy
 */
mxMedianHybridCrossingReduction.prototype.calculateRankCrossing = function(i, model)
{
\tvar totalCrossings = 0;
\tvar rank = model.ranks[i];
\tvar previousRank = model.ranks[i - 1];

\tvar tmpIndices = [];

\t// Iterate over the top rank and fill in the connection information
\tfor (var j = 0; j < rank.length; j++)
\t{
\t\tvar node = rank[j];
\t\tvar rankPosition = node.getGeneralPurposeVariable(i);
\t\tvar connectedCells = node.getPreviousLayerConnectedCells(i);
\t\tvar nodeIndices = [];

\t\tfor (var k = 0; k < connectedCells.length; k++)
\t\t{
\t\t\tvar connectedNode = connectedCells[k];
\t\t\tvar otherCellRankPosition = connectedNode.getGeneralPurposeVariable(i - 1);
\t\t\tnodeIndices.push(otherCellRankPosition);
\t\t}
\t\t
\t\tnodeIndices.sort(function(x, y) { return x - y; });
\t\ttmpIndices[rankPosition] = nodeIndices;
\t}
\t
\tvar indices = [];

\tfor (var j = 0; j < tmpIndices.length; j++)
\t{
\t\tindices = indices.concat(tmpIndices[j]);
\t}

\tvar firstIndex = 1;
\t
\twhile (firstIndex < previousRank.length)
\t{
\t\tfirstIndex <<= 1;
\t}

\tvar treeSize = 2 * firstIndex - 1;
\tfirstIndex -= 1;

\tvar tree = [];
\t
\tfor (var j = 0; j < treeSize; ++j)
\t{
\t\ttree[j] = 0;
\t}

\tfor (var j = 0; j < indices.length; j++)
\t{
\t\tvar index = indices[j];
\t    var treeIndex = index + firstIndex;
\t    ++tree[treeIndex];
\t    
\t    while (treeIndex > 0)
\t    {
\t    \tif (treeIndex % 2)
\t    \t{
\t    \t\ttotalCrossings += tree[treeIndex + 1];
\t    \t}
\t      
\t    \ttreeIndex = (treeIndex - 1) >> 1;
\t    \t++tree[treeIndex];
\t    }
\t}

\treturn totalCrossings;
};

/**
 * Function: transpose
 * 
 * Takes each possible adjacent cell pair on each rank and checks if
 * swapping them around reduces the number of crossing
 * 
 * Parameters:
 * 
 * mainLoopIteration - the iteration number of the main loop
 * model - the internal model describing the hierarchy
 */
mxMedianHybridCrossingReduction.prototype.transpose = function(mainLoopIteration, model)
{
\tvar improved = true;

\t// Track the number of iterations in case of looping
\tvar count = 0;
\tvar maxCount = 10;
\twhile (improved && count++ < maxCount)
\t{
\t\t// On certain iterations allow allow swapping of cell pairs with
\t\t// equal edge crossings switched or not switched. This help to
\t\t// nudge a stuck layout into a lower crossing total.
\t\tvar nudge = mainLoopIteration % 2 == 1 && count % 2 == 1;
\t\timproved = false;
\t\t
\t\tfor (var i = 0; i < model.ranks.length; i++)
\t\t{
\t\t\tvar rank = model.ranks[i];
\t\t\tvar orderedCells = [];
\t\t\t
\t\t\tfor (var j = 0; j < rank.length; j++)
\t\t\t{
\t\t\t\tvar cell = rank[j];
\t\t\t\tvar tempRank = cell.getGeneralPurposeVariable(i);
\t\t\t\t
\t\t\t\t// FIXME: Workaround to avoid negative tempRanks
\t\t\t\tif (tempRank < 0)
\t\t\t\t{
\t\t\t\t\ttempRank = j;
\t\t\t\t}
\t\t\t\torderedCells[tempRank] = cell;
\t\t\t}
\t\t\t
\t\t\tvar leftCellAboveConnections = null;
\t\t\tvar leftCellBelowConnections = null;
\t\t\tvar rightCellAboveConnections = null;
\t\t\tvar rightCellBelowConnections = null;
\t\t\t
\t\t\tvar leftAbovePositions = null;
\t\t\tvar leftBelowPositions = null;
\t\t\tvar rightAbovePositions = null;
\t\t\tvar rightBelowPositions = null;
\t\t\t
\t\t\tvar leftCell = null;
\t\t\tvar rightCell = null;

\t\t\tfor (var j = 0; j < (rank.length - 1); j++)
\t\t\t{
\t\t\t\t// For each intra-rank adjacent pair of cells
\t\t\t\t// see if swapping them around would reduce the
\t\t\t\t// number of edges crossing they cause in total
\t\t\t\t// On every cell pair except the first on each rank, we
\t\t\t\t// can save processing using the previous values for the
\t\t\t\t// right cell on the new left cell
\t\t\t\tif (j == 0)
\t\t\t\t{
\t\t\t\t\tleftCell = orderedCells[j];
\t\t\t\t\tleftCellAboveConnections = leftCell
\t\t\t\t\t\t\t.getNextLayerConnectedCells(i);
\t\t\t\t\tleftCellBelowConnections = leftCell
\t\t\t\t\t\t\t.getPreviousLayerConnectedCells(i);
\t\t\t\t\tleftAbovePositions = [];
\t\t\t\t\tleftBelowPositions = [];
\t\t\t\t\t
\t\t\t\t\tfor (var k = 0; k < leftCellAboveConnections.length; k++)
\t\t\t\t\t{
\t\t\t\t\t\tleftAbovePositions[k] = leftCellAboveConnections[k].getGeneralPurposeVariable(i + 1);
\t\t\t\t\t}
\t\t\t\t\t
\t\t\t\t\tfor (var k = 0; k < leftCellBelowConnections.length; k++)
\t\t\t\t\t{
\t\t\t\t\t\tleftBelowPositions[k] = leftCellBelowConnections[k].getGeneralPurposeVariable(i - 1);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tleftCellAboveConnections = rightCellAboveConnections;
\t\t\t\t\tleftCellBelowConnections = rightCellBelowConnections;
\t\t\t\t\tleftAbovePositions = rightAbovePositions;
\t\t\t\t\tleftBelowPositions = rightBelowPositions;
\t\t\t\t\tleftCell = rightCell;
\t\t\t\t}
\t\t\t\t
\t\t\t\trightCell = orderedCells[j + 1];
\t\t\t\trightCellAboveConnections = rightCell
\t\t\t\t\t\t.getNextLayerConnectedCells(i);
\t\t\t\trightCellBelowConnections = rightCell
\t\t\t\t\t\t.getPreviousLayerConnectedCells(i);

\t\t\t\trightAbovePositions = [];
\t\t\t\trightBelowPositions = [];

\t\t\t\tfor (var k = 0; k < rightCellAboveConnections.length; k++)
\t\t\t\t{
\t\t\t\t\trightAbovePositions[k] = rightCellAboveConnections[k].getGeneralPurposeVariable(i + 1);
\t\t\t\t}
\t\t\t\t
\t\t\t\tfor (var k = 0; k < rightCellBelowConnections.length; k++)
\t\t\t\t{
\t\t\t\t\trightBelowPositions[k] = rightCellBelowConnections[k].getGeneralPurposeVariable(i - 1);
\t\t\t\t}

\t\t\t\tvar totalCurrentCrossings = 0;
\t\t\t\tvar totalSwitchedCrossings = 0;
\t\t\t\t
\t\t\t\tfor (var k = 0; k < leftAbovePositions.length; k++)
\t\t\t\t{
\t\t\t\t\tfor (var ik = 0; ik < rightAbovePositions.length; ik++)
\t\t\t\t\t{
\t\t\t\t\t\tif (leftAbovePositions[k] > rightAbovePositions[ik])
\t\t\t\t\t\t{
\t\t\t\t\t\t\ttotalCurrentCrossings++;
\t\t\t\t\t\t}

\t\t\t\t\t\tif (leftAbovePositions[k] < rightAbovePositions[ik])
\t\t\t\t\t\t{
\t\t\t\t\t\t\ttotalSwitchedCrossings++;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tfor (var k = 0; k < leftBelowPositions.length; k++)
\t\t\t\t{
\t\t\t\t\tfor (var ik = 0; ik < rightBelowPositions.length; ik++)
\t\t\t\t\t{
\t\t\t\t\t\tif (leftBelowPositions[k] > rightBelowPositions[ik])
\t\t\t\t\t\t{
\t\t\t\t\t\t\ttotalCurrentCrossings++;
\t\t\t\t\t\t}

\t\t\t\t\t\tif (leftBelowPositions[k] < rightBelowPositions[ik])
\t\t\t\t\t\t{
\t\t\t\t\t\t\ttotalSwitchedCrossings++;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tif ((totalSwitchedCrossings < totalCurrentCrossings) ||
\t\t\t\t\t(totalSwitchedCrossings == totalCurrentCrossings &&
\t\t\t\t\tnudge))
\t\t\t\t{
\t\t\t\t\tvar temp = leftCell.getGeneralPurposeVariable(i);
\t\t\t\t\tleftCell.setGeneralPurposeVariable(i, rightCell
\t\t\t\t\t\t\t.getGeneralPurposeVariable(i));
\t\t\t\t\trightCell.setGeneralPurposeVariable(i, temp);

\t\t\t\t\t// With this pair exchanged we have to switch all of
\t\t\t\t\t// values for the left cell to the right cell so the
\t\t\t\t\t// next iteration for this rank uses it as the left
\t\t\t\t\t// cell again
\t\t\t\t\trightCellAboveConnections = leftCellAboveConnections;
\t\t\t\t\trightCellBelowConnections = leftCellBelowConnections;
\t\t\t\t\trightAbovePositions = leftAbovePositions;
\t\t\t\t\trightBelowPositions = leftBelowPositions;
\t\t\t\t\trightCell = leftCell;
\t\t\t\t\t
\t\t\t\t\tif (!nudge)
\t\t\t\t\t{
\t\t\t\t\t\t// Don't count nudges as improvement or we'll end
\t\t\t\t\t\t// up stuck in two combinations and not finishing
\t\t\t\t\t\t// as early as we should
\t\t\t\t\t\timproved = true;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};

/**
 * Function: weightedMedian
 * 
 * Sweeps up or down the layout attempting to minimise the median placement
 * of connected cells on adjacent ranks
 * 
 * Parameters:
 * 
 * iteration - the iteration number of the main loop
 * model - the internal model describing the hierarchy
 */
mxMedianHybridCrossingReduction.prototype.weightedMedian = function(iteration, model)
{
\t// Reverse sweep direction each time through this method
\tvar downwardSweep = (iteration % 2 == 0);
\tif (downwardSweep)
\t{
\t\tfor (var j = model.maxRank - 1; j >= 0; j--)
\t\t{
\t\t\tthis.medianRank(j, downwardSweep);
\t\t}
\t}
\telse
\t{
\t\tfor (var j = 1; j < model.maxRank; j++)
\t\t{
\t\t\tthis.medianRank(j, downwardSweep);
\t\t}
\t}
};

/**
 * Function: medianRank
 * 
 * Attempts to minimise the median placement of connected cells on this rank
 * and one of the adjacent ranks
 * 
 * Parameters:
 * 
 * rankValue - the layer number of this rank
 * downwardSweep - whether or not this is a downward sweep through the graph
 */
mxMedianHybridCrossingReduction.prototype.medianRank = function(rankValue, downwardSweep)
{
\tvar numCellsForRank = this.nestedBestRanks[rankValue].length;
\tvar medianValues = [];
\tvar reservedPositions = [];

\tfor (var i = 0; i < numCellsForRank; i++)
\t{
\t\tvar cell = this.nestedBestRanks[rankValue][i];
\t\tvar sorterEntry = new MedianCellSorter();
\t\tsorterEntry.cell = cell;

\t\t// Flip whether or not equal medians are flipped on up and down
\t\t// sweeps
\t\t// TODO re-implement some kind of nudge
\t\t// medianValues[i].nudge = !downwardSweep;
\t\tvar nextLevelConnectedCells;
\t\t
\t\tif (downwardSweep)
\t\t{
\t\t\tnextLevelConnectedCells = cell
\t\t\t\t\t.getNextLayerConnectedCells(rankValue);
\t\t}
\t\telse
\t\t{
\t\t\tnextLevelConnectedCells = cell
\t\t\t\t\t.getPreviousLayerConnectedCells(rankValue);
\t\t}
\t\t
\t\tvar nextRankValue;
\t\t
\t\tif (downwardSweep)
\t\t{
\t\t\tnextRankValue = rankValue + 1;
\t\t}
\t\telse
\t\t{
\t\t\tnextRankValue = rankValue - 1;
\t\t}

\t\tif (nextLevelConnectedCells != null
\t\t\t\t&& nextLevelConnectedCells.length != 0)
\t\t{
\t\t\tsorterEntry.medianValue = this.medianValue(
\t\t\t\t\tnextLevelConnectedCells, nextRankValue);
\t\t\tmedianValues.push(sorterEntry);
\t\t}
\t\telse
\t\t{
\t\t\t// Nodes with no adjacent vertices are flagged in the reserved array
\t\t\t// to indicate they should be left in their current position.
\t\t\treservedPositions[cell.getGeneralPurposeVariable(rankValue)] = true;
\t\t}
\t}
\t
\tmedianValues.sort(MedianCellSorter.prototype.compare);
\t
\t// Set the new position of each node within the rank using
\t// its temp variable
\tfor (var i = 0; i < numCellsForRank; i++)
\t{
\t\tif (reservedPositions[i] == null)
\t\t{
\t\t\tvar cell = medianValues.shift().cell;
\t\t\tcell.setGeneralPurposeVariable(rankValue, i);
\t\t}
\t}
};

/**
 * Function: medianValue
 * 
 * Calculates the median rank order positioning for the specified cell using
 * the connected cells on the specified rank. Returns the median rank
 * ordering value of the connected cells
 * 
 * Parameters:
 * 
 * connectedCells - the cells on the specified rank connected to the
 * specified cell
 * rankValue - the rank that the connected cell lie upon
 */
mxMedianHybridCrossingReduction.prototype.medianValue = function(connectedCells, rankValue)
{
\tvar medianValues = [];
\tvar arrayCount = 0;
\t
\tfor (var i = 0; i < connectedCells.length; i++)
\t{
\t\tvar cell = connectedCells[i];
\t\tmedianValues[arrayCount++] = cell.getGeneralPurposeVariable(rankValue);
\t}

\t// Sort() sorts lexicographically by default (i.e. 11 before 9) so force
\t// numerical order sort
\tmedianValues.sort(function(a,b){return a - b;});
\t
\tif (arrayCount % 2 == 1)
\t{
\t\t// For odd numbers of adjacent vertices return the median
\t\treturn medianValues[Math.floor(arrayCount / 2)];
\t}
\telse if (arrayCount == 2)
\t{
\t\treturn ((medianValues[0] + medianValues[1]) / 2.0);
\t}
\telse
\t{
\t\tvar medianPoint = arrayCount / 2;
\t\tvar leftMedian = medianValues[medianPoint - 1] - medianValues[0];
\t\tvar rightMedian = medianValues[arrayCount - 1]
\t\t\t\t- medianValues[medianPoint];

\t\treturn (medianValues[medianPoint - 1] * rightMedian + medianValues[medianPoint]
\t\t\t\t* leftMedian)
\t\t\t\t/ (leftMedian + rightMedian);
\t}
};

/**
 * Class: MedianCellSorter
 * 
 * A utility class used to track cells whilst sorting occurs on the median
 * values. Does not violate (x.compareTo(y)==0) == (x.equals(y))
 *
 * Constructor: MedianCellSorter
 * 
 * Constructs a new median cell sorter.
 */
function MedianCellSorter()
{
\t// empty
};

/**
 * Variable: medianValue
 * 
 * The weighted value of the cell stored.
 */
MedianCellSorter.prototype.medianValue = 0;

/**
 * Variable: cell
 * 
 * The cell whose median value is being calculated
 */
MedianCellSorter.prototype.cell = false;

/**
 * Function: compare
 * 
 * Compares two MedianCellSorters.
 */
MedianCellSorter.prototype.compare = function(a, b)
{
\tif (a != null && b != null)
\t{
\t\tif (b.medianValue > a.medianValue)
\t\t{
\t\t\treturn -1;
\t\t}
\t\telse if (b.medianValue < a.medianValue)
\t\t{
\t\t\treturn 1;
\t\t}
\t\telse
\t\t{
\t\t\treturn 0;
\t\t}
\t}
\telse
\t{
\t\treturn 0;
\t}
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxMinimumCycleRemover
 * 
 * An implementation of the first stage of the Sugiyama layout. Straightforward
 * longest path calculation of layer assignment
 * 
 * Constructor: mxMinimumCycleRemover
 *
 * Creates a cycle remover for the given internal model.
 */
function mxMinimumCycleRemover(layout)
{
\tthis.layout = layout;
};

/**
 * Extends mxHierarchicalLayoutStage.
 */
mxMinimumCycleRemover.prototype = new mxHierarchicalLayoutStage();
mxMinimumCycleRemover.prototype.constructor = mxMinimumCycleRemover;

/**
 * Variable: layout
 * 
 * Reference to the enclosing <mxHierarchicalLayout>.
 */
mxMinimumCycleRemover.prototype.layout = null;

/**
 * Function: execute
 * 
 * Takes the graph detail and configuration information within the facade
 * and creates the resulting laid out graph within that facade for further
 * use.
 */
mxMinimumCycleRemover.prototype.execute = function(parent)
{
\tvar model = this.layout.getModel();
\tvar seenNodes = new Object();
\tvar unseenNodesArray = model.vertexMapper.getValues();
\tvar unseenNodes = new Object();
\t
\tfor (var i = 0; i < unseenNodesArray.length; i++)
\t{
\t\tunseenNodes[unseenNodesArray[i].id] = unseenNodesArray[i];
\t}
\t
\t// Perform a dfs through the internal model. If a cycle is found,
\t// reverse it.
\tvar rootsArray = null;
\t
\tif (model.roots != null)
\t{
\t\tvar modelRoots = model.roots;
\t\trootsArray = [];
\t\t
\t\tfor (var i = 0; i < modelRoots.length; i++)
\t\t{
\t\t\trootsArray[i] = model.vertexMapper.get(modelRoots[i]);
\t\t}
\t}

\tmodel.visit(function(parent, node, connectingEdge, layer, seen)
\t{
\t\t// Check if the cell is in it's own ancestor list, if so
\t\t// invert the connecting edge and reverse the target/source
\t\t// relationship to that edge in the parent and the cell
\t\tif (node.isAncestor(parent))
\t\t{
\t\t\tconnectingEdge.invert();
\t\t\tmxUtils.remove(connectingEdge, parent.connectsAsSource);
\t\t\tparent.connectsAsTarget.push(connectingEdge);
\t\t\tmxUtils.remove(connectingEdge, node.connectsAsTarget);
\t\t\tnode.connectsAsSource.push(connectingEdge);
\t\t}
\t\t
\t\tseenNodes[node.id] = node;
\t\tdelete unseenNodes[node.id];
\t}, rootsArray, true, null);

\t// If there are any nodes that should be nodes that the dfs can miss
\t// these need to be processed with the dfs and the roots assigned
\t// correctly to form a correct internal model
\tvar seenNodesCopy = mxUtils.clone(seenNodes, null, true);

\t// Pick a random cell and dfs from it
\tmodel.visit(function(parent, node, connectingEdge, layer, seen)
\t{
\t\t// Check if the cell is in it's own ancestor list, if so
\t\t// invert the connecting edge and reverse the target/source
\t\t// relationship to that edge in the parent and the cell
\t\tif (node.isAncestor(parent))
\t\t{
\t\t\tconnectingEdge.invert();
\t\t\tmxUtils.remove(connectingEdge, parent.connectsAsSource);
\t\t\tnode.connectsAsSource.push(connectingEdge);
\t\t\tparent.connectsAsTarget.push(connectingEdge);
\t\t\tmxUtils.remove(connectingEdge, node.connectsAsTarget);
\t\t}
\t\t
\t\tseenNodes[node.id] = node;
\t\tdelete unseenNodes[node.id];
\t}, unseenNodes, true, seenNodesCopy);
};
/**
 * Copyright (c) 2006-2018, JGraph Ltd
 * Copyright (c) 2006-2018, Gaudenz Alder
 */
/**
 * Class: mxCoordinateAssignment
 * 
 * Sets the horizontal locations of node and edge dummy nodes on each layer.
 * Uses median down and up weighings as well as heuristics to straighten edges as
 * far as possible.
 * 
 * Constructor: mxCoordinateAssignment
 *
 * Creates a coordinate assignment.
 * 
 * Arguments:
 * 
 * intraCellSpacing - the minimum buffer between cells on the same rank
 * interRankCellSpacing - the minimum distance between cells on adjacent ranks
 * orientation - the position of the root node(s) relative to the graph
 * initialX - the leftmost coordinate node placement starts at
 */
function mxCoordinateAssignment(layout, intraCellSpacing, interRankCellSpacing,
\torientation, initialX, parallelEdgeSpacing)
{
\tthis.layout = layout;
\tthis.intraCellSpacing = intraCellSpacing;
\tthis.interRankCellSpacing = interRankCellSpacing;
\tthis.orientation = orientation;
\tthis.initialX = initialX;
\tthis.parallelEdgeSpacing = parallelEdgeSpacing;
};

/**
 * Extends mxHierarchicalLayoutStage.
 */
mxCoordinateAssignment.prototype = new mxHierarchicalLayoutStage();
mxCoordinateAssignment.prototype.constructor = mxCoordinateAssignment;

/**
 * Variable: layout
 * 
 * Reference to the enclosing <mxHierarchicalLayout>.
 */
mxCoordinateAssignment.prototype.layout = null;

/**
 * Variable: intraCellSpacing
 * 
 * The minimum buffer between cells on the same rank. Default is 30.
 */
mxCoordinateAssignment.prototype.intraCellSpacing = 30;

/**
 * Variable: interRankCellSpacing
 * 
 * The minimum distance between cells on adjacent ranks. Default is 100.
 */
mxCoordinateAssignment.prototype.interRankCellSpacing = 100;

/**
 * Variable: parallelEdgeSpacing
 * 
 * The distance between each parallel edge on each ranks for long edges.
 * Default is 10.
 */
mxCoordinateAssignment.prototype.parallelEdgeSpacing = 10;

/**
 * Variable: maxIterations
 * 
 * The number of heuristic iterations to run. Default is 8.
 */
mxCoordinateAssignment.prototype.maxIterations = 8;

/**
 * Variable: prefHozEdgeSep
 * 
 * The preferred horizontal distance between edges exiting a vertex Default is 5.
 */
mxCoordinateAssignment.prototype.prefHozEdgeSep = 5;

/**
 * Variable: prefVertEdgeOff
 * 
 * The preferred vertical offset between edges exiting a vertex Default is 2.
 */
mxCoordinateAssignment.prototype.prefVertEdgeOff = 2;

/**
 * Variable: minEdgeJetty
 * 
 * The minimum distance for an edge jetty from a vertex Default is 12.
 */
mxCoordinateAssignment.prototype.minEdgeJetty = 12;

/**
 * Variable: channelBuffer
 * 
 * The size of the vertical buffer in the center of inter-rank channels
 * where edge control points should not be placed Default is 4.
 */
mxCoordinateAssignment.prototype.channelBuffer = 4;

/**
 * Variable: jettyPositions
 * 
 * Map of internal edges and (x,y) pair of positions of the start and end jetty
 * for that edge where it connects to the source and target vertices.
 * Note this should technically be a WeakHashMap, but since JS does not
 * have an equivalent, housekeeping must be performed before using.
 * i.e. check all edges are still in the model and clear the values.
 * Note that the y co-ord is the offset of the jetty, not the
 * absolute point
 */
mxCoordinateAssignment.prototype.jettyPositions = null;

/**
 * Variable: orientation
 * 
 * The position of the root ( start ) node(s) relative to the rest of the
 * laid out graph. Default is <mxConstants.DIRECTION_NORTH>.
 */
mxCoordinateAssignment.prototype.orientation = mxConstants.DIRECTION_NORTH;

/**
 * Variable: initialX
 * 
 * The minimum x position node placement starts at
 */
mxCoordinateAssignment.prototype.initialX = null;

/**
 * Variable: limitX
 * 
 * The maximum x value this positioning lays up to
 */
mxCoordinateAssignment.prototype.limitX = null;

/**
 * Variable: currentXDelta
 * 
 * The sum of x-displacements for the current iteration
 */
mxCoordinateAssignment.prototype.currentXDelta = null;

/**
 * Variable: widestRank
 * 
 * The rank that has the widest x position
 */
mxCoordinateAssignment.prototype.widestRank = null;

/**
 * Variable: rankTopY
 * 
 * Internal cache of top-most values of Y for each rank
 */
mxCoordinateAssignment.prototype.rankTopY = null;

/**
 * Variable: rankBottomY
 * 
 * Internal cache of bottom-most value of Y for each rank
 */
mxCoordinateAssignment.prototype.rankBottomY = null;

/**
 * Variable: widestRankValue
 * 
 * The X-coordinate of the edge of the widest rank
 */
mxCoordinateAssignment.prototype.widestRankValue = null;

/**
 * Variable: rankWidths
 * 
 * The width of all the ranks
 */
mxCoordinateAssignment.prototype.rankWidths = null;

/**
 * Variable: rankY
 * 
 * The Y-coordinate of all the ranks
 */
mxCoordinateAssignment.prototype.rankY = null;

/**
 * Variable: fineTuning
 * 
 * Whether or not to perform local optimisations and iterate multiple times
 * through the algorithm. Default is true.
 */
mxCoordinateAssignment.prototype.fineTuning = true;

/**
 * Variable: nextLayerConnectedCache
 * 
 * A store of connections to the layer above for speed
 */
mxCoordinateAssignment.prototype.nextLayerConnectedCache = null;

/**
 * Variable: previousLayerConnectedCache
 * 
 * A store of connections to the layer below for speed
 */
mxCoordinateAssignment.prototype.previousLayerConnectedCache = null;

/**
 * Variable: groupPadding
 * 
 * Padding added to resized parents Default is 10.
 */
mxCoordinateAssignment.prototype.groupPadding = 10;

/**
 * Utility method to display current positions
 */
mxCoordinateAssignment.prototype.printStatus = function()
{
\tvar model = this.layout.getModel();
\tmxLog.show();

\tmxLog.writeln('======Coord assignment debug=======');

\tfor (var j = 0; j < model.ranks.length; j++)
\t{
\t\tmxLog.write('Rank ', j, ' : ' );
\t\tvar rank = model.ranks[j];
\t\t
\t\tfor (var k = 0; k < rank.length; k++)
\t\t{
\t\t\tvar cell = rank[k];
\t\t\t
\t\t\tmxLog.write(cell.getGeneralPurposeVariable(j), '  ');
\t\t}
\t\tmxLog.writeln();
\t}
\t
\tmxLog.writeln('====================================');
};

/**
 * Function: execute
 * 
 * A basic horizontal coordinate assignment algorithm
 */
mxCoordinateAssignment.prototype.execute = function(parent)
{
\tthis.jettyPositions = Object();
\tvar model = this.layout.getModel();
\tthis.currentXDelta = 0.0;

\tthis.initialCoords(this.layout.getGraph(), model);
\t
//\tthis.printStatus();
\t
\tif (this.fineTuning)
\t{
\t\tthis.minNode(model);
\t}
\t
\tvar bestXDelta = 100000000.0;
\t
\tif (this.fineTuning)
\t{
\t\tfor (var i = 0; i < this.maxIterations; i++)
\t\t{
//\t\t\tthis.printStatus();
\t\t
\t\t\t// Median Heuristic
\t\t\tif (i != 0)
\t\t\t{
\t\t\t\tthis.medianPos(i, model);
\t\t\t\tthis.minNode(model);
\t\t\t}
\t\t\t
\t\t\t// if the total offset is less for the current positioning,
\t\t\t// there are less heavily angled edges and so the current
\t\t\t// positioning is used
\t\t\tif (this.currentXDelta < bestXDelta)
\t\t\t{
\t\t\t\tfor (var j = 0; j < model.ranks.length; j++)
\t\t\t\t{
\t\t\t\t\tvar rank = model.ranks[j];
\t\t\t\t\t
\t\t\t\t\tfor (var k = 0; k < rank.length; k++)
\t\t\t\t\t{
\t\t\t\t\t\tvar cell = rank[k];
\t\t\t\t\t\tcell.setX(j, cell.getGeneralPurposeVariable(j));
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\t
\t\t\t\tbestXDelta = this.currentXDelta;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// Restore the best positions
\t\t\t\tfor (var j = 0; j < model.ranks.length; j++)
\t\t\t\t{
\t\t\t\t\tvar rank = model.ranks[j];
\t\t\t\t\t
\t\t\t\t\tfor (var k = 0; k < rank.length; k++)
\t\t\t\t\t{
\t\t\t\t\t\tvar cell = rank[k];
\t\t\t\t\t\tcell.setGeneralPurposeVariable(j, cell.getX(j));
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t\t
\t\t\tthis.minPath(this.layout.getGraph(), model);
\t\t\t
\t\t\tthis.currentXDelta = 0;
\t\t}
\t}
\t
\tthis.setCellLocations(this.layout.getGraph(), model);
};

/**
 * Function: minNode
 * 
 * Performs one median positioning sweep in both directions
 */
mxCoordinateAssignment.prototype.minNode = function(model)
{
\t// Queue all nodes
\tvar nodeList = [];
\t
\t// Need to be able to map from cell to cellWrapper
\tvar map = new mxDictionary();
\tvar rank = [];
\t
\tfor (var i = 0; i <= model.maxRank; i++)
\t{
\t\trank[i] = model.ranks[i];
\t\t
\t\tfor (var j = 0; j < rank[i].length; j++)
\t\t{
\t\t\t// Use the weight to store the rank and visited to store whether
\t\t\t// or not the cell is in the list
\t\t\tvar node = rank[i][j];
\t\t\tvar nodeWrapper = new WeightedCellSorter(node, i);
\t\t\tnodeWrapper.rankIndex = j;
\t\t\tnodeWrapper.visited = true;
\t\t\tnodeList.push(nodeWrapper);
\t\t\t
\t\t\tmap.put(node, nodeWrapper);
\t\t}
\t}
\t
\t// Set a limit of the maximum number of times we will access the queue
\t// in case a loop appears
\tvar maxTries = nodeList.length * 10;
\tvar count = 0;
\t
\t// Don't move cell within this value of their median
\tvar tolerance = 1;
\t
\twhile (nodeList.length > 0 && count <= maxTries)
\t{
\t\tvar cellWrapper = nodeList.shift();
\t\tvar cell = cellWrapper.cell;
\t\t
\t\tvar rankValue = cellWrapper.weightedValue;
\t\tvar rankIndex = parseInt(cellWrapper.rankIndex);
\t\t
\t\tvar nextLayerConnectedCells = cell.getNextLayerConnectedCells(rankValue);
\t\tvar previousLayerConnectedCells = cell.getPreviousLayerConnectedCells(rankValue);
\t\t
\t\tvar numNextLayerConnected = nextLayerConnectedCells.length;
\t\tvar numPreviousLayerConnected = previousLayerConnectedCells.length;

\t\tvar medianNextLevel = this.medianXValue(nextLayerConnectedCells,
\t\t\t\trankValue + 1);
\t\tvar medianPreviousLevel = this.medianXValue(previousLayerConnectedCells,
\t\t\t\trankValue - 1);

\t\tvar numConnectedNeighbours = numNextLayerConnected
\t\t\t\t+ numPreviousLayerConnected;
\t\tvar currentPosition = cell.getGeneralPurposeVariable(rankValue);
\t\tvar cellMedian = currentPosition;
\t\t
\t\tif (numConnectedNeighbours > 0)
\t\t{
\t\t\tcellMedian = (medianNextLevel * numNextLayerConnected + medianPreviousLevel
\t\t\t\t\t* numPreviousLayerConnected)
\t\t\t\t\t/ numConnectedNeighbours;
\t\t}

\t\t// Flag storing whether or not position has changed
\t\tvar positionChanged = false;
\t\t
\t\tif (cellMedian < currentPosition - tolerance)
\t\t{
\t\t\tif (rankIndex == 0)
\t\t\t{
\t\t\t\tcell.setGeneralPurposeVariable(rankValue, cellMedian);
\t\t\t\tpositionChanged = true;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tvar leftCell = rank[rankValue][rankIndex - 1];
\t\t\t\tvar leftLimit = leftCell
\t\t\t\t\t\t.getGeneralPurposeVariable(rankValue);
\t\t\t\tleftLimit = leftLimit + leftCell.width / 2
\t\t\t\t\t\t+ this.intraCellSpacing + cell.width / 2;

\t\t\t\tif (leftLimit < cellMedian)
\t\t\t\t{
\t\t\t\t\tcell.setGeneralPurposeVariable(rankValue, cellMedian);
\t\t\t\t\tpositionChanged = true;
\t\t\t\t}
\t\t\t\telse if (leftLimit < cell
\t\t\t\t\t\t.getGeneralPurposeVariable(rankValue)
\t\t\t\t\t\t- tolerance)
\t\t\t\t{
\t\t\t\t\tcell.setGeneralPurposeVariable(rankValue, leftLimit);
\t\t\t\t\tpositionChanged = true;
\t\t\t\t}
\t\t\t}
\t\t}
\t\telse if (cellMedian > currentPosition + tolerance)
\t\t{
\t\t\tvar rankSize = rank[rankValue].length;
\t\t\t
\t\t\tif (rankIndex == rankSize - 1)
\t\t\t{
\t\t\t\tcell.setGeneralPurposeVariable(rankValue, cellMedian);
\t\t\t\tpositionChanged = true;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tvar rightCell = rank[rankValue][rankIndex + 1];
\t\t\t\tvar rightLimit = rightCell
\t\t\t\t\t\t.getGeneralPurposeVariable(rankValue);
\t\t\t\trightLimit = rightLimit - rightCell.width / 2
\t\t\t\t\t\t- this.intraCellSpacing - cell.width / 2;
\t\t\t\t
\t\t\t\tif (rightLimit > cellMedian)
\t\t\t\t{
\t\t\t\t\tcell.setGeneralPurposeVariable(rankValue, cellMedian);
\t\t\t\t\tpositionChanged = true;
\t\t\t\t}
\t\t\t\telse if (rightLimit > cell
\t\t\t\t\t\t.getGeneralPurposeVariable(rankValue)
\t\t\t\t\t\t+ tolerance)
\t\t\t\t{
\t\t\t\t\tcell.setGeneralPurposeVariable(rankValue, rightLimit);
\t\t\t\t\tpositionChanged = true;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tif (positionChanged)
\t\t{
\t\t\t// Add connected nodes to map and list
\t\t\tfor (var i = 0; i < nextLayerConnectedCells.length; i++)
\t\t\t{
\t\t\t\tvar connectedCell = nextLayerConnectedCells[i];
\t\t\t\tvar connectedCellWrapper = map.get(connectedCell);
\t\t\t\t
\t\t\t\tif (connectedCellWrapper != null)
\t\t\t\t{
\t\t\t\t\tif (connectedCellWrapper.visited == false)
\t\t\t\t\t{
\t\t\t\t\t\tconnectedCellWrapper.visited = true;
\t\t\t\t\t\tnodeList.push(connectedCellWrapper);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}

\t\t\t// Add connected nodes to map and list
\t\t\tfor (var i = 0; i < previousLayerConnectedCells.length; i++)
\t\t\t{
\t\t\t\tvar connectedCell = previousLayerConnectedCells[i];
\t\t\t\tvar connectedCellWrapper = map.get(connectedCell);

\t\t\t\tif (connectedCellWrapper != null)
\t\t\t\t{
\t\t\t\t\tif (connectedCellWrapper.visited == false)
\t\t\t\t\t{
\t\t\t\t\t\tconnectedCellWrapper.visited = true;
\t\t\t\t\t\tnodeList.push(connectedCellWrapper);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tcellWrapper.visited = false;
\t\tcount++;
\t}
};

/**
 * Function: medianPos
 * 
 * Performs one median positioning sweep in one direction
 * 
 * Parameters:
 * 
 * i - the iteration of the whole process
 * model - an internal model of the hierarchical layout
 */
mxCoordinateAssignment.prototype.medianPos = function(i, model)
{
\t// Reverse sweep direction each time through this method
\tvar downwardSweep = (i % 2 == 0);
\t
\tif (downwardSweep)
\t{
\t\tfor (var j = model.maxRank; j > 0; j--)
\t\t{
\t\t\tthis.rankMedianPosition(j - 1, model, j);
\t\t}
\t}
\telse
\t{
\t\tfor (var j = 0; j < model.maxRank - 1; j++)
\t\t{
\t\t\tthis.rankMedianPosition(j + 1, model, j);
\t\t}
\t}
};

/**
 * Function: rankMedianPosition
 * 
 * Performs median minimisation over one rank.
 * 
 * Parameters:
 * 
 * rankValue - the layer number of this rank
 * model - an internal model of the hierarchical layout
 * nextRankValue - the layer number whose connected cels are to be laid out
 * relative to
 */
mxCoordinateAssignment.prototype.rankMedianPosition = function(rankValue, model, nextRankValue)
{
\tvar rank = model.ranks[rankValue];

\t// Form an array of the order in which the cell are to be processed
\t// , the order is given by the weighted sum of the in or out edges,
\t// depending on whether we're traveling up or down the hierarchy.
\tvar weightedValues = [];
\tvar cellMap = new Object();

\tfor (var i = 0; i < rank.length; i++)
\t{
\t\tvar currentCell = rank[i];
\t\tweightedValues[i] = new WeightedCellSorter();
\t\tweightedValues[i].cell = currentCell;
\t\tweightedValues[i].rankIndex = i;
\t\tcellMap[currentCell.id] = weightedValues[i];
\t\tvar nextLayerConnectedCells = null;
\t\t
\t\tif (nextRankValue < rankValue)
\t\t{
\t\t\tnextLayerConnectedCells = currentCell
\t\t\t\t\t.getPreviousLayerConnectedCells(rankValue);
\t\t}
\t\telse
\t\t{
\t\t\tnextLayerConnectedCells = currentCell
\t\t\t\t\t.getNextLayerConnectedCells(rankValue);
\t\t}

\t\t// Calculate the weighing based on this node type and those this
\t\t// node is connected to on the next layer
\t\tweightedValues[i].weightedValue = this.calculatedWeightedValue(
\t\t\t\tcurrentCell, nextLayerConnectedCells);
\t}

\tweightedValues.sort(WeightedCellSorter.prototype.compare);

\t// Set the new position of each node within the rank using
\t// its temp variable
\t
\tfor (var i = 0; i < weightedValues.length; i++)
\t{
\t\tvar numConnectionsNextLevel = 0;
\t\tvar cell = weightedValues[i].cell;
\t\tvar nextLayerConnectedCells = null;
\t\tvar medianNextLevel = 0;

\t\tif (nextRankValue < rankValue)
\t\t{
\t\t\tnextLayerConnectedCells = cell.getPreviousLayerConnectedCells(
\t\t\t\t\trankValue).slice();
\t\t}
\t\telse
\t\t{
\t\t\tnextLayerConnectedCells = cell.getNextLayerConnectedCells(
\t\t\t\t\trankValue).slice();
\t\t}

\t\tif (nextLayerConnectedCells != null)
\t\t{
\t\t\tnumConnectionsNextLevel = nextLayerConnectedCells.length;
\t\t\t
\t\t\tif (numConnectionsNextLevel > 0)
\t\t\t{
\t\t\t\tmedianNextLevel = this.medianXValue(nextLayerConnectedCells,
\t\t\t\t\t\tnextRankValue);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\t// For case of no connections on the next level set the
\t\t\t\t// median to be the current position and try to be
\t\t\t\t// positioned there
\t\t\t\tmedianNextLevel = cell.getGeneralPurposeVariable(rankValue);
\t\t\t}
\t\t}

\t\tvar leftBuffer = 0.0;
\t\tvar leftLimit = -100000000.0;
\t\t
\t\tfor (var j = weightedValues[i].rankIndex - 1; j >= 0;)
\t\t{
\t\t\tvar weightedValue = cellMap[rank[j].id];
\t\t\t
\t\t\tif (weightedValue != null)
\t\t\t{
\t\t\t\tvar leftCell = weightedValue.cell;
\t\t\t\t
\t\t\t\tif (weightedValue.visited)
\t\t\t\t{
\t\t\t\t\t// The left limit is the right hand limit of that
\t\t\t\t\t// cell plus any allowance for unallocated cells
\t\t\t\t\t// in-between
\t\t\t\t\tleftLimit = leftCell
\t\t\t\t\t\t\t.getGeneralPurposeVariable(rankValue)
\t\t\t\t\t\t\t+ leftCell.width
\t\t\t\t\t\t\t/ 2.0
\t\t\t\t\t\t\t+ this.intraCellSpacing
\t\t\t\t\t\t\t+ leftBuffer + cell.width / 2.0;
\t\t\t\t\tj = -1;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tleftBuffer += leftCell.width + this.intraCellSpacing;
\t\t\t\t\tj--;
\t\t\t\t}
\t\t\t}
\t\t}

\t\tvar rightBuffer = 0.0;
\t\tvar rightLimit = 100000000.0;
\t\t
\t\tfor (var j = weightedValues[i].rankIndex + 1; j < weightedValues.length;)
\t\t{
\t\t\tvar weightedValue = cellMap[rank[j].id];
\t\t\t
\t\t\tif (weightedValue != null)
\t\t\t{
\t\t\t\tvar rightCell = weightedValue.cell;
\t\t\t\t
\t\t\t\tif (weightedValue.visited)
\t\t\t\t{
\t\t\t\t\t// The left limit is the right hand limit of that
\t\t\t\t\t// cell plus any allowance for unallocated cells
\t\t\t\t\t// in-between
\t\t\t\t\trightLimit = rightCell
\t\t\t\t\t\t\t.getGeneralPurposeVariable(rankValue)
\t\t\t\t\t\t\t- rightCell.width
\t\t\t\t\t\t\t/ 2.0
\t\t\t\t\t\t\t- this.intraCellSpacing
\t\t\t\t\t\t\t- rightBuffer - cell.width / 2.0;
\t\t\t\t\tj = weightedValues.length;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\trightBuffer += rightCell.width + this.intraCellSpacing;
\t\t\t\t\tj++;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tif (medianNextLevel >= leftLimit && medianNextLevel <= rightLimit)
\t\t{
\t\t\tcell.setGeneralPurposeVariable(rankValue, medianNextLevel);
\t\t}
\t\telse if (medianNextLevel < leftLimit)
\t\t{
\t\t\t// Couldn't place at median value, place as close to that
\t\t\t// value as possible
\t\t\tcell.setGeneralPurposeVariable(rankValue, leftLimit);
\t\t\tthis.currentXDelta += leftLimit - medianNextLevel;
\t\t}
\t\telse if (medianNextLevel > rightLimit)
\t\t{
\t\t\t// Couldn't place at median value, place as close to that
\t\t\t// value as possible
\t\t\tcell.setGeneralPurposeVariable(rankValue, rightLimit);
\t\t\tthis.currentXDelta += medianNextLevel - rightLimit;
\t\t}

\t\tweightedValues[i].visited = true;
\t}
};

/**
 * Function: calculatedWeightedValue
 * 
 * Calculates the priority the specified cell has based on the type of its
 * cell and the cells it is connected to on the next layer
 * 
 * Parameters:
 * 
 * currentCell - the cell whose weight is to be calculated
 * collection - the cells the specified cell is connected to
 */
mxCoordinateAssignment.prototype.calculatedWeightedValue = function(currentCell, collection)
{
\tvar totalWeight = 0;
\t
\tfor (var i = 0; i < collection.length; i++)
\t{
\t\tvar cell = collection[i];

\t\tif (currentCell.isVertex() && cell.isVertex())
\t\t{
\t\t\ttotalWeight++;
\t\t}
\t\telse if (currentCell.isEdge() && cell.isEdge())
\t\t{
\t\t\ttotalWeight += 8;
\t\t}
\t\telse
\t\t{
\t\t\ttotalWeight += 2;
\t\t}
\t}

\treturn totalWeight;
};

/**
 * Function: medianXValue
 * 
 * Calculates the median position of the connected cell on the specified
 * rank
 * 
 * Parameters:
 * 
 * connectedCells - the cells the candidate connects to on this level
 * rankValue - the layer number of this rank
 */
mxCoordinateAssignment.prototype.medianXValue = function(connectedCells, rankValue)
{
\tif (connectedCells.length == 0)
\t{
\t\treturn 0;
\t}

\tvar medianValues = [];

\tfor (var i = 0; i < connectedCells.length; i++)
\t{
\t\tmedianValues[i] = connectedCells[i].getGeneralPurposeVariable(rankValue);
\t}

\tmedianValues.sort(function(a,b){return a - b;});
\t
\tif (connectedCells.length % 2 == 1)
\t{
\t\t// For odd numbers of adjacent vertices return the median
\t\treturn medianValues[Math.floor(connectedCells.length / 2)];
\t}
\telse
\t{
\t\tvar medianPoint = connectedCells.length / 2;
\t\tvar leftMedian = medianValues[medianPoint - 1];
\t\tvar rightMedian = medianValues[medianPoint];

\t\treturn ((leftMedian + rightMedian) / 2);
\t}
};

/**
 * Function: initialCoords
 * 
 * Sets up the layout in an initial positioning. The ranks are all centered
 * as much as possible along the middle vertex in each rank. The other cells
 * are then placed as close as possible on either side.
 * 
 * Parameters:
 * 
 * facade - the facade describing the input graph
 * model - an internal model of the hierarchical layout
 */
mxCoordinateAssignment.prototype.initialCoords = function(facade, model)
{
\tthis.calculateWidestRank(facade, model);

\t// Sweep up and down from the widest rank
\tfor (var i = this.widestRank; i >= 0; i--)
\t{
\t\tif (i < model.maxRank)
\t\t{
\t\t\tthis.rankCoordinates(i, facade, model);
\t\t}
\t}

\tfor (var i = this.widestRank+1; i <= model.maxRank; i++)
\t{
\t\tif (i > 0)
\t\t{
\t\t\tthis.rankCoordinates(i, facade, model);
\t\t}
\t}
};

/**
 * Function: rankCoordinates
 * 
 * Sets up the layout in an initial positioning. All the first cells in each
 * rank are moved to the left and the rest of the rank inserted as close
 * together as their size and buffering permits. This method works on just
 * the specified rank.
 * 
 * Parameters:
 * 
 * rankValue - the current rank being processed
 * graph - the facade describing the input graph
 * model - an internal model of the hierarchical layout
 */
mxCoordinateAssignment.prototype.rankCoordinates = function(rankValue, graph, model)
{
\tvar rank = model.ranks[rankValue];
\tvar maxY = 0.0;
\tvar localX = this.initialX + (this.widestRankValue - this.rankWidths[rankValue])
\t\t\t/ 2;

\t// Store whether or not any of the cells' bounds were unavailable so
\t// to only issue the warning once for all cells
\tvar boundsWarning = false;
\t
\tfor (var i = 0; i < rank.length; i++)
\t{
\t\tvar node = rank[i];
\t\t
\t\tif (node.isVertex())
\t\t{
\t\t\tvar bounds = this.layout.getVertexBounds(node.cell);

\t\t\tif (bounds != null)
\t\t\t{
\t\t\t\tif (this.orientation == mxConstants.DIRECTION_NORTH ||
\t\t\t\t\tthis.orientation == mxConstants.DIRECTION_SOUTH)
\t\t\t\t{
\t\t\t\t\tnode.width = bounds.width;
\t\t\t\t\tnode.height = bounds.height;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tnode.width = bounds.height;
\t\t\t\t\tnode.height = bounds.width;
\t\t\t\t}
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tboundsWarning = true;
\t\t\t}

\t\t\tmaxY = Math.max(maxY, node.height);
\t\t}
\t\telse if (node.isEdge())
\t\t{
\t\t\t// The width is the number of additional parallel edges
\t\t\t// time the parallel edge spacing
\t\t\tvar numEdges = 1;

\t\t\tif (node.edges != null)
\t\t\t{
\t\t\t\tnumEdges = node.edges.length;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tmxLog.warn('edge.edges is null');
\t\t\t}

\t\t\tnode.width = (numEdges - 1) * this.parallelEdgeSpacing;
\t\t}

\t\t// Set the initial x-value as being the best result so far
\t\tlocalX += node.width / 2.0;
\t\tnode.setX(rankValue, localX);
\t\tnode.setGeneralPurposeVariable(rankValue, localX);
\t\tlocalX += node.width / 2.0;
\t\tlocalX += this.intraCellSpacing;
\t}

\tif (boundsWarning == true)
\t{
\t\tmxLog.warn('At least one cell has no bounds');
\t}
};

/**
 * Function: calculateWidestRank
 * 
 * Calculates the width rank in the hierarchy. Also set the y value of each
 * rank whilst performing the calculation
 * 
 * Parameters:
 * 
 * graph - the facade describing the input graph
 * model - an internal model of the hierarchical layout
 */
mxCoordinateAssignment.prototype.calculateWidestRank = function(graph, model)
{
\t// Starting y co-ordinate
\tvar y = -this.interRankCellSpacing;
\t
\t// Track the widest cell on the last rank since the y
\t// difference depends on it
\tvar lastRankMaxCellHeight = 0.0;
\tthis.rankWidths = [];
\tthis.rankY = [];

\tfor (var rankValue = model.maxRank; rankValue >= 0; rankValue--)
\t{
\t\t// Keep track of the widest cell on this rank
\t\tvar maxCellHeight = 0.0;
\t\tvar rank = model.ranks[rankValue];
\t\tvar localX = this.initialX;

\t\t// Store whether or not any of the cells' bounds were unavailable so
\t\t// to only issue the warning once for all cells
\t\tvar boundsWarning = false;
\t\t
\t\tfor (var i = 0; i < rank.length; i++)
\t\t{
\t\t\tvar node = rank[i];

\t\t\tif (node.isVertex())
\t\t\t{
\t\t\t\tvar bounds = this.layout.getVertexBounds(node.cell);

\t\t\t\tif (bounds != null)
\t\t\t\t{
\t\t\t\t\tif (this.orientation == mxConstants.DIRECTION_NORTH ||
\t\t\t\t\t\tthis.orientation == mxConstants.DIRECTION_SOUTH)
\t\t\t\t\t{
\t\t\t\t\t\tnode.width = bounds.width;
\t\t\t\t\t\tnode.height = bounds.height;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tnode.width = bounds.height;
\t\t\t\t\t\tnode.height = bounds.width;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tboundsWarning = true;
\t\t\t\t}

\t\t\t\tmaxCellHeight = Math.max(maxCellHeight, node.height);
\t\t\t}
\t\t\telse if (node.isEdge())
\t\t\t{
\t\t\t\t// The width is the number of additional parallel edges
\t\t\t\t// time the parallel edge spacing
\t\t\t\tvar numEdges = 1;

\t\t\t\tif (node.edges != null)
\t\t\t\t{
\t\t\t\t\tnumEdges = node.edges.length;
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tmxLog.warn('edge.edges is null');
\t\t\t\t}

\t\t\t\tnode.width = (numEdges - 1) * this.parallelEdgeSpacing;
\t\t\t}

\t\t\t// Set the initial x-value as being the best result so far
\t\t\tlocalX += node.width / 2.0;
\t\t\tnode.setX(rankValue, localX);
\t\t\tnode.setGeneralPurposeVariable(rankValue, localX);
\t\t\tlocalX += node.width / 2.0;
\t\t\tlocalX += this.intraCellSpacing;

\t\t\tif (localX > this.widestRankValue)
\t\t\t{
\t\t\t\tthis.widestRankValue = localX;
\t\t\t\tthis.widestRank = rankValue;
\t\t\t}

\t\t\tthis.rankWidths[rankValue] = localX;
\t\t}

\t\tif (boundsWarning == true)
\t\t{
\t\t\tmxLog.warn('At least one cell has no bounds');
\t\t}

\t\tthis.rankY[rankValue] = y;
\t\tvar distanceToNextRank = maxCellHeight / 2.0
\t\t\t\t+ lastRankMaxCellHeight / 2.0 + this.interRankCellSpacing;
\t\tlastRankMaxCellHeight = maxCellHeight;

\t\tif (this.orientation == mxConstants.DIRECTION_NORTH ||
\t\t\tthis.orientation == mxConstants.DIRECTION_WEST)
\t\t{
\t\t\ty += distanceToNextRank;
\t\t}
\t\telse
\t\t{
\t\t\ty -= distanceToNextRank;
\t\t}

\t\tfor (var i = 0; i < rank.length; i++)
\t\t{
\t\t\tvar cell = rank[i];
\t\t\tcell.setY(rankValue, y);
\t\t}
\t}
};

/**
 * Function: minPath
 * 
 * Straightens out chains of virtual nodes where possibleacade to those stored after this layout
 * processing step has completed.
 * 
 * Parameters:
 *
 * graph - the facade describing the input graph
 * model - an internal model of the hierarchical layout
 */
mxCoordinateAssignment.prototype.minPath = function(graph, model)
{
\t// Work down and up each edge with at least 2 control points
\t// trying to straighten each one out. If the same number of
\t// straight segments are formed in both directions, the 
\t// preferred direction used is the one where the final
\t// control points have the least offset from the connectable 
\t// region of the terminating vertices
\tvar edges = model.edgeMapper.getValues();
\t
\tfor (var j = 0; j < edges.length; j++)
\t{
\t\tvar cell = edges[j];
\t\t
\t\tif (cell.maxRank - cell.minRank - 1 < 1)
\t\t{
\t\t\tcontinue;
\t\t}

\t\t// At least two virtual nodes in the edge
\t\t// Check first whether the edge is already straight
\t\tvar referenceX = cell
\t\t\t\t.getGeneralPurposeVariable(cell.minRank + 1);
\t\tvar edgeStraight = true;
\t\tvar refSegCount = 0;
\t\t
\t\tfor (var i = cell.minRank + 2; i < cell.maxRank; i++)
\t\t{
\t\t\tvar x = cell.getGeneralPurposeVariable(i);

\t\t\tif (referenceX != x)
\t\t\t{
\t\t\t\tedgeStraight = false;
\t\t\t\treferenceX = x;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\trefSegCount++;
\t\t\t}
\t\t}

\t\tif (!edgeStraight)
\t\t{
\t\t\tvar upSegCount = 0;
\t\t\tvar downSegCount = 0;
\t\t\tvar upXPositions = [];
\t\t\tvar downXPositions = [];

\t\t\tvar currentX = cell.getGeneralPurposeVariable(cell.minRank + 1);

\t\t\tfor (var i = cell.minRank + 1; i < cell.maxRank - 1; i++)
\t\t\t{
\t\t\t\t// Attempt to straight out the control point on the
\t\t\t\t// next segment up with the current control point.
\t\t\t\tvar nextX = cell.getX(i + 1);

\t\t\t\tif (currentX == nextX)
\t\t\t\t{
\t\t\t\t\tupXPositions[i - cell.minRank - 1] = currentX;
\t\t\t\t\tupSegCount++;
\t\t\t\t}
\t\t\t\telse if (this.repositionValid(model, cell, i + 1, currentX))
\t\t\t\t{
\t\t\t\t\tupXPositions[i - cell.minRank - 1] = currentX;
\t\t\t\t\tupSegCount++;
\t\t\t\t\t// Leave currentX at same value
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tupXPositions[i - cell.minRank - 1] = nextX;
\t\t\t\t\tcurrentX = nextX;
\t\t\t\t}\t\t\t\t
\t\t\t}

\t\t\tcurrentX = cell.getX(i);

\t\t\tfor (var i = cell.maxRank - 1; i > cell.minRank + 1; i--)
\t\t\t{
\t\t\t\t// Attempt to straight out the control point on the
\t\t\t\t// next segment down with the current control point.
\t\t\t\tvar nextX = cell.getX(i - 1);

\t\t\t\tif (currentX == nextX)
\t\t\t\t{
\t\t\t\t\tdownXPositions[i - cell.minRank - 2] = currentX;
\t\t\t\t\tdownSegCount++;
\t\t\t\t}
\t\t\t\telse if (this.repositionValid(model, cell, i - 1, currentX))
\t\t\t\t{
\t\t\t\t\tdownXPositions[i - cell.minRank - 2] = currentX;
\t\t\t\t\tdownSegCount++;
\t\t\t\t\t// Leave currentX at same value
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tdownXPositions[i - cell.minRank - 2] = cell.getX(i-1);
\t\t\t\t\tcurrentX = nextX;
\t\t\t\t}
\t\t\t}

\t\t\tif (downSegCount > refSegCount || upSegCount > refSegCount)
\t\t\t{
\t\t\t\tif (downSegCount >= upSegCount)
\t\t\t\t{
\t\t\t\t\t// Apply down calculation values
\t\t\t\t\tfor (var i = cell.maxRank - 2; i > cell.minRank; i--)
\t\t\t\t\t{
\t\t\t\t\t\tcell.setX(i, downXPositions[i - cell.minRank - 1]);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse if (upSegCount > downSegCount)
\t\t\t\t{
\t\t\t\t\t// Apply up calculation values
\t\t\t\t\tfor (var i = cell.minRank + 2; i < cell.maxRank; i++)
\t\t\t\t\t{
\t\t\t\t\t\tcell.setX(i, upXPositions[i - cell.minRank - 2]);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\t// Neither direction provided a favourable result
\t\t\t\t\t// But both calculations are better than the
\t\t\t\t\t// existing solution, so apply the one with minimal
\t\t\t\t\t// offset to attached vertices at either end.
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};

/**
 * Function: repositionValid
 * 
 * Determines whether or not a node may be moved to the specified x 
 * position on the specified rank
 * 
 * Parameters:
 *
 * model - the layout model
 * cell - the cell being analysed
 * rank - the layer of the cell
 * position - the x position being sought
 */
mxCoordinateAssignment.prototype.repositionValid = function(model, cell, rank, position)
{
\tvar rankArray = model.ranks[rank];
\tvar rankIndex = -1;

\tfor (var i = 0; i < rankArray.length; i++)
\t{
\t\tif (cell == rankArray[i])
\t\t{
\t\t\trankIndex = i;
\t\t\tbreak;
\t\t}
\t}

\tif (rankIndex < 0)
\t{
\t\treturn false;
\t}

\tvar currentX = cell.getGeneralPurposeVariable(rank);

\tif (position < currentX)
\t{
\t\t// Trying to move node to the left.
\t\tif (rankIndex == 0)
\t\t{
\t\t\t// Left-most node, can move anywhere
\t\t\treturn true;
\t\t}

\t\tvar leftCell = rankArray[rankIndex - 1];
\t\tvar leftLimit = leftCell.getGeneralPurposeVariable(rank);
\t\tleftLimit = leftLimit + leftCell.width / 2
\t\t\t\t+ this.intraCellSpacing + cell.width / 2;

\t\tif (leftLimit <= position)
\t\t{
\t\t\treturn true;
\t\t}
\t\telse
\t\t{
\t\t\treturn false;
\t\t}
\t}
\telse if (position > currentX)
\t{
\t\t// Trying to move node to the right.
\t\tif (rankIndex == rankArray.length - 1)
\t\t{
\t\t\t// Right-most node, can move anywhere
\t\t\treturn true;
\t\t}

\t\tvar rightCell = rankArray[rankIndex + 1];
\t\tvar rightLimit = rightCell.getGeneralPurposeVariable(rank);
\t\trightLimit = rightLimit - rightCell.width / 2
\t\t\t\t- this.intraCellSpacing - cell.width / 2;

\t\tif (rightLimit >= position)
\t\t{
\t\t\treturn true;
\t\t}
\t\telse
\t\t{
\t\t\treturn false;
\t\t}
\t}

\treturn true;
};

/**
 * Function: setCellLocations
 * 
 * Sets the cell locations in the facade to those stored after this layout
 * processing step has completed.
 * 
 * Parameters:
 *
 * graph - the input graph
 * model - the layout model
 */
mxCoordinateAssignment.prototype.setCellLocations = function(graph, model)
{
\tthis.rankTopY = [];
\tthis.rankBottomY = [];

\tfor (var i = 0; i < model.ranks.length; i++)
\t{
\t\tthis.rankTopY[i] = Number.MAX_VALUE;
\t\tthis.rankBottomY[i] = -Number.MAX_VALUE;
\t}
\t
\tvar vertices = model.vertexMapper.getValues();

\t// Process vertices all first, since they define the lower and 
\t// limits of each rank. Between these limits lie the channels
\t// where the edges can be routed across the graph

\tfor (var i = 0; i < vertices.length; i++)
\t{
\t\tthis.setVertexLocation(vertices[i]);
\t}
\t
\t// Post process edge styles. Needs the vertex locations set for initial
\t// values of the top and bottoms of each rank
\tif (this.layout.edgeStyle == mxHierarchicalEdgeStyle.ORTHOGONAL
\t\t\t|| this.layout.edgeStyle == mxHierarchicalEdgeStyle.POLYLINE
\t\t\t|| this.layout.edgeStyle == mxHierarchicalEdgeStyle.CURVE)
\t{
\t\tthis.localEdgeProcessing(model);
\t}

\tvar edges = model.edgeMapper.getValues();

\tfor (var i = 0; i < edges.length; i++)
\t{
\t\tthis.setEdgePosition(edges[i]);
\t}
};

/**
 * Function: localEdgeProcessing
 * 
 * Separates the x position of edges as they connect to vertices
 * 
 * Parameters:
 *
 * model - the layout model
 */
mxCoordinateAssignment.prototype.localEdgeProcessing = function(model)
{
\t// Iterate through each vertex, look at the edges connected in
\t// both directions.
\tfor (var rankIndex = 0; rankIndex < model.ranks.length; rankIndex++)
\t{
\t\tvar rank = model.ranks[rankIndex];

\t\tfor (var cellIndex = 0; cellIndex < rank.length; cellIndex++)
\t\t{
\t\t\tvar cell = rank[cellIndex];

\t\t\tif (cell.isVertex())
\t\t\t{
\t\t\t\tvar currentCells = cell.getPreviousLayerConnectedCells(rankIndex);

\t\t\t\tvar currentRank = rankIndex - 1;

\t\t\t\t// Two loops, last connected cells, and next
\t\t\t\tfor (var k = 0; k < 2; k++)
\t\t\t\t{
\t\t\t\t\tif (currentRank > -1
\t\t\t\t\t\t\t&& currentRank < model.ranks.length
\t\t\t\t\t\t\t&& currentCells != null
\t\t\t\t\t\t\t&& currentCells.length > 0)
\t\t\t\t\t{
\t\t\t\t\t\tvar sortedCells = [];

\t\t\t\t\t\tfor (var j = 0; j < currentCells.length; j++)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar sorter = new WeightedCellSorter(
\t\t\t\t\t\t\t\t\tcurrentCells[j], currentCells[j].getX(currentRank));
\t\t\t\t\t\t\tsortedCells.push(sorter);
\t\t\t\t\t\t}

\t\t\t\t\t\tsortedCells.sort(WeightedCellSorter.prototype.compare);

\t\t\t\t\t\tvar leftLimit = cell.x[0] - cell.width / 2;
\t\t\t\t\t\tvar rightLimit = leftLimit + cell.width;

\t\t\t\t\t\t// Connected edge count starts at 1 to allow for buffer
\t\t\t\t\t\t// with edge of vertex
\t\t\t\t\t\tvar connectedEdgeCount = 0;
\t\t\t\t\t\tvar connectedEdgeGroupCount = 0;
\t\t\t\t\t\tvar connectedEdges = [];
\t\t\t\t\t\t// Calculate width requirements for all connected edges
\t\t\t\t\t\tfor (var j = 0; j < sortedCells.length; j++)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar innerCell = sortedCells[j].cell;
\t\t\t\t\t\t\tvar connections;

\t\t\t\t\t\t\tif (innerCell.isVertex())
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t// Get the connecting edge
\t\t\t\t\t\t\t\tif (k == 0)
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tconnections = cell.connectsAsSource;

\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t\telse
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tconnections = cell.connectsAsTarget;
\t\t\t\t\t\t\t\t}

\t\t\t\t\t\t\t\tfor (var connIndex = 0; connIndex < connections.length; connIndex++)
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tif (connections[connIndex].source == innerCell
\t\t\t\t\t\t\t\t\t\t\t|| connections[connIndex].target == innerCell)
\t\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\t\tconnectedEdgeCount += connections[connIndex].edges
\t\t\t\t\t\t\t\t\t\t\t\t.length;
\t\t\t\t\t\t\t\t\t\tconnectedEdgeGroupCount++;

\t\t\t\t\t\t\t\t\t\tconnectedEdges.push(connections[connIndex]);
\t\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\telse
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tconnectedEdgeCount += innerCell.edges.length;
\t\t\t\t\t\t\t\tconnectedEdgeGroupCount++;
\t\t\t\t\t\t\t\tconnectedEdges.push(innerCell);
\t\t\t\t\t\t\t}
\t\t\t\t\t\t}

\t\t\t\t\t\tvar requiredWidth = (connectedEdgeCount + 1)
\t\t\t\t\t\t\t\t* this.prefHozEdgeSep;

\t\t\t\t\t\t// Add a buffer on the edges of the vertex if the edge count allows
\t\t\t\t\t\tif (cell.width > requiredWidth
\t\t\t\t\t\t\t\t+ (2 * this.prefHozEdgeSep))
\t\t\t\t\t\t{
\t\t\t\t\t\t\tleftLimit += this.prefHozEdgeSep;
\t\t\t\t\t\t\trightLimit -= this.prefHozEdgeSep;
\t\t\t\t\t\t}

\t\t\t\t\t\tvar availableWidth = rightLimit - leftLimit;
\t\t\t\t\t\tvar edgeSpacing = availableWidth / connectedEdgeCount;

\t\t\t\t\t\tvar currentX = leftLimit + edgeSpacing / 2.0;
\t\t\t\t\t\tvar currentYOffset = this.minEdgeJetty - this.prefVertEdgeOff;
\t\t\t\t\t\tvar maxYOffset = 0;

\t\t\t\t\t\tfor (var j = 0; j < connectedEdges.length; j++)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar numActualEdges = connectedEdges[j].edges
\t\t\t\t\t\t\t\t\t.length;
\t\t\t\t\t\t\tvar pos = this.jettyPositions[connectedEdges[j].ids[0]];
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tif (pos == null)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tpos = [];
\t\t\t\t\t\t\t\tthis.jettyPositions[connectedEdges[j].ids[0]] = pos;
\t\t\t\t\t\t\t}

\t\t\t\t\t\t\tif (j < connectedEdgeCount / 2)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tcurrentYOffset += this.prefVertEdgeOff;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\telse if (j > connectedEdgeCount / 2)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tcurrentYOffset -= this.prefVertEdgeOff;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t// Ignore the case if equals, this means the second of 2
\t\t\t\t\t\t\t// jettys with the same y (even number of edges)

\t\t\t\t\t\t\tfor (var m = 0; m < numActualEdges; m++)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tpos[m * 4 + k * 2] = currentX;
\t\t\t\t\t\t\t\tcurrentX += edgeSpacing;
\t\t\t\t\t\t\t\tpos[m * 4 + k * 2 + 1] = currentYOffset;
\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tmaxYOffset = Math.max(maxYOffset,
\t\t\t\t\t\t\t\t\tcurrentYOffset);
\t\t\t\t\t\t}
\t\t\t\t\t}

\t\t\t\t\tcurrentCells = cell.getNextLayerConnectedCells(rankIndex);

\t\t\t\t\tcurrentRank = rankIndex + 1;
\t\t\t\t}
\t\t\t}
\t\t}
\t}
};

/**
 * Function: setEdgePosition
 * 
 * Fixes the control points
 */
mxCoordinateAssignment.prototype.setEdgePosition = function(cell)
{
\t// For parallel edges we need to seperate out the points a
\t// little
\tvar offsetX = 0;
\t// Only set the edge control points once

\tif (cell.temp[0] != 101207)
\t{
\t\tvar maxRank = cell.maxRank;
\t\tvar minRank = cell.minRank;
\t\t
\t\tif (maxRank == minRank)
\t\t{
\t\t\tmaxRank = cell.source.maxRank;
\t\t\tminRank = cell.target.minRank;
\t\t}
\t\t
\t\tvar parallelEdgeCount = 0;
\t\tvar jettys = this.jettyPositions[cell.ids[0]];

\t\tvar source = cell.isReversed ? cell.target.cell : cell.source.cell;
\t\tvar graph = this.layout.graph;
\t\tvar layoutReversed = this.orientation == mxConstants.DIRECTION_EAST
\t\t\t\t|| this.orientation == mxConstants.DIRECTION_SOUTH;

\t\tfor (var i = 0; i < cell.edges.length; i++)
\t\t{
\t\t\tvar realEdge = cell.edges[i];
\t\t\tvar realSource = this.layout.getVisibleTerminal(realEdge, true);

\t\t\t//List oldPoints = graph.getPoints(realEdge);
\t\t\tvar newPoints = [];

\t\t\t// Single length reversed edges end up with the jettys in the wrong
\t\t\t// places. Since single length edges only have jettys, not segment
\t\t\t// control points, we just say the edge isn't reversed in this section
\t\t\tvar reversed = cell.isReversed;
\t\t\t
\t\t\tif (realSource != source)
\t\t\t{
\t\t\t\t// The real edges include all core model edges and these can go
\t\t\t\t// in both directions. If the source of the hierarchical model edge
\t\t\t\t// isn't the source of the specific real edge in this iteration
\t\t\t\t// treat if as reversed
\t\t\t\treversed = !reversed;
\t\t\t}

\t\t\t// First jetty of edge
\t\t\tif (jettys != null)
\t\t\t{
\t\t\t\tvar arrayOffset = reversed ? 2 : 0;
\t\t\t\tvar y = reversed ?
\t\t\t\t\t\t(layoutReversed ? this.rankBottomY[minRank] : this.rankTopY[minRank]) :
\t\t\t\t\t\t\t(layoutReversed ? this.rankTopY[maxRank] : this.rankBottomY[maxRank]);
\t\t\t\tvar jetty = jettys[parallelEdgeCount * 4 + 1 + arrayOffset];
\t\t\t\t
\t\t\t\tif (reversed != layoutReversed)
\t\t\t\t{
\t\t\t\t\tjetty = -jetty;
\t\t\t\t}
\t\t\t\t
\t\t\t\ty += jetty;
\t\t\t\tvar x = jettys[parallelEdgeCount * 4 + arrayOffset];
\t\t\t\t
\t\t\t\tvar modelSource = graph.model.getTerminal(realEdge, true);

\t\t\t\tif (this.layout.isPort(modelSource) && graph.model.getParent(modelSource) == realSource)
\t\t\t\t{
\t\t\t\t\tvar state = graph.view.getState(modelSource);
\t\t\t\t\t
\t\t\t\t\tif (state != null)
\t\t\t\t\t{
\t\t\t\t\t\tx = state.x;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tx = realSource.geometry.x + cell.source.width * modelSource.geometry.x;
\t\t\t\t\t}
\t\t\t\t}

\t\t\t\tif (this.orientation == mxConstants.DIRECTION_NORTH
\t\t\t\t\t\t|| this.orientation == mxConstants.DIRECTION_SOUTH)
\t\t\t\t{
\t\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\t\t
\t\t\t\t\tif (this.layout.edgeStyle == mxHierarchicalEdgeStyle.CURVE)
\t\t\t\t\t{
\t\t\t\t\t\tnewPoints.push(new mxPoint(x, y + jetty));
\t\t\t\t\t}
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tnewPoints.push(new mxPoint(y, x));
\t\t\t\t\t
\t\t\t\t\tif (this.layout.edgeStyle == mxHierarchicalEdgeStyle.CURVE)
\t\t\t\t\t{
\t\t\t\t\t\tnewPoints.push(new mxPoint(y + jetty, x));
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}

\t\t\t// Declare variables to define loop through edge points and 
\t\t\t// change direction if edge is reversed

\t\t\tvar loopStart = cell.x.length - 1;
\t\t\tvar loopLimit = -1;
\t\t\tvar loopDelta = -1;
\t\t\tvar currentRank = cell.maxRank - 1;

\t\t\tif (reversed)
\t\t\t{
\t\t\t\tloopStart = 0;
\t\t\t\tloopLimit = cell.x.length;
\t\t\t\tloopDelta = 1;
\t\t\t\tcurrentRank = cell.minRank + 1;
\t\t\t}
\t\t\t// Reversed edges need the points inserted in
\t\t\t// reverse order
\t\t\tfor (var j = loopStart; (cell.maxRank != cell.minRank) && j != loopLimit; j += loopDelta)
\t\t\t{
\t\t\t\t// The horizontal position in a vertical layout
\t\t\t\tvar positionX = cell.x[j] + offsetX;

\t\t\t\t// Work out the vertical positions in a vertical layout
\t\t\t\t// in the edge buffer channels above and below this rank
\t\t\t\tvar topChannelY = (this.rankTopY[currentRank] + this.rankBottomY[currentRank + 1]) / 2.0;
\t\t\t\tvar bottomChannelY = (this.rankTopY[currentRank - 1] + this.rankBottomY[currentRank]) / 2.0;

\t\t\t\tif (reversed)
\t\t\t\t{
\t\t\t\t\tvar tmp = topChannelY;
\t\t\t\t\ttopChannelY = bottomChannelY;
\t\t\t\t\tbottomChannelY = tmp;
\t\t\t\t}

\t\t\t\tif (this.orientation == mxConstants.DIRECTION_NORTH ||
\t\t\t\t\tthis.orientation == mxConstants.DIRECTION_SOUTH)
\t\t\t\t{
\t\t\t\t\tnewPoints.push(new mxPoint(positionX, topChannelY));
\t\t\t\t\tnewPoints.push(new mxPoint(positionX, bottomChannelY));
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tnewPoints.push(new mxPoint(topChannelY, positionX));
\t\t\t\t\tnewPoints.push(new mxPoint(bottomChannelY, positionX));
\t\t\t\t}

\t\t\t\tthis.limitX = Math.max(this.limitX, positionX);
\t\t\t\tcurrentRank += loopDelta;
\t\t\t}

\t\t\t// Second jetty of edge
\t\t\tif (jettys != null)
\t\t\t{
\t\t\t\tvar arrayOffset = reversed ? 2 : 0;
\t\t\t\tvar rankY = reversed ?
\t\t\t\t\t\t(layoutReversed ? this.rankTopY[maxRank] : this.rankBottomY[maxRank]) :
\t\t\t\t\t\t\t(layoutReversed ? this.rankBottomY[minRank] : this.rankTopY[minRank]);
\t\t\t\tvar jetty = jettys[parallelEdgeCount * 4 + 3 - arrayOffset];
\t\t\t\t
\t\t\t\tif (reversed != layoutReversed)
\t\t\t\t{
\t\t\t\t\tjetty = -jetty;
\t\t\t\t}
\t\t\t\tvar y = rankY - jetty;
\t\t\t\tvar x = jettys[parallelEdgeCount * 4 + 2 - arrayOffset];
\t\t\t\t
\t\t\t\tvar modelTarget = graph.model.getTerminal(realEdge, false);
\t\t\t\tvar realTarget = this.layout.getVisibleTerminal(realEdge, false);

\t\t\t\tif (this.layout.isPort(modelTarget) && graph.model.getParent(modelTarget) == realTarget)
\t\t\t\t{
\t\t\t\t\tvar state = graph.view.getState(modelTarget);
\t\t\t\t\t
\t\t\t\t\tif (state != null)
\t\t\t\t\t{
\t\t\t\t\t\tx = state.x;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tx = realTarget.geometry.x + cell.target.width * modelTarget.geometry.x;
\t\t\t\t\t}
\t\t\t\t}

\t\t\t\tif (this.orientation == mxConstants.DIRECTION_NORTH ||
\t\t\t\t\t\tthis.orientation == mxConstants.DIRECTION_SOUTH)
\t\t\t\t{
\t\t\t\t\tif (this.layout.edgeStyle == mxHierarchicalEdgeStyle.CURVE)
\t\t\t\t\t{
\t\t\t\t\t\tnewPoints.push(new mxPoint(x, y - jetty));
\t\t\t\t\t}

\t\t\t\t\tnewPoints.push(new mxPoint(x, y));
\t\t\t\t}
\t\t\t\telse
\t\t\t\t{
\t\t\t\t\tif (this.layout.edgeStyle == mxHierarchicalEdgeStyle.CURVE)
\t\t\t\t\t{
\t\t\t\t\t\tnewPoints.push(new mxPoint(y - jetty, x));
\t\t\t\t\t}

\t\t\t\t\tnewPoints.push(new mxPoint(y, x));
\t\t\t\t}
\t\t\t}

\t\t\tif (cell.isReversed)
\t\t\t{
\t\t\t\tthis.processReversedEdge(cell, realEdge);
\t\t\t}

\t\t\tthis.layout.setEdgePoints(realEdge, newPoints);

\t\t\t// Increase offset so next edge is drawn next to
\t\t\t// this one
\t\t\tif (offsetX == 0.0)
\t\t\t{
\t\t\t\toffsetX = this.parallelEdgeSpacing;
\t\t\t}
\t\t\telse if (offsetX > 0)
\t\t\t{
\t\t\t\toffsetX = -offsetX;
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\toffsetX = -offsetX + this.parallelEdgeSpacing;
\t\t\t}
\t\t\t
\t\t\tparallelEdgeCount++;
\t\t}

\t\tcell.temp[0] = 101207;
\t}
};


/**
 * Function: setVertexLocation
 * 
 * Fixes the position of the specified vertex.
 * 
 * Parameters:
 * 
 * cell - the vertex to position
 */
mxCoordinateAssignment.prototype.setVertexLocation = function(cell)
{
\tvar realCell = cell.cell;
\tvar positionX = cell.x[0] - cell.width / 2;
\tvar positionY = cell.y[0] - cell.height / 2;

\tthis.rankTopY[cell.minRank] = Math.min(this.rankTopY[cell.minRank], positionY);
\tthis.rankBottomY[cell.minRank] = Math.max(this.rankBottomY[cell.minRank],
\t\t\tpositionY + cell.height);

\tif (this.orientation == mxConstants.DIRECTION_NORTH ||
\t\tthis.orientation == mxConstants.DIRECTION_SOUTH)
\t{
\t\tthis.layout.setVertexLocation(realCell, positionX, positionY);
\t}
\telse
\t{
\t\tthis.layout.setVertexLocation(realCell, positionY, positionX);
\t}

\tthis.limitX = Math.max(this.limitX, positionX + cell.width);
};

/**
 * Function: processReversedEdge
 * 
 * Hook to add additional processing
 * 
 * Parameters:
 * 
 * edge - the hierarchical model edge
 * realEdge - the real edge in the graph
 */
mxCoordinateAssignment.prototype.processReversedEdge = function(graph, model)
{
\t// hook for subclassers
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxSwimlaneOrdering
 * 
 * An implementation of the first stage of the Sugiyama layout. Straightforward
 * longest path calculation of layer assignment
 * 
 * Constructor: mxSwimlaneOrdering
 *
 * Creates a cycle remover for the given internal model.
 */
function mxSwimlaneOrdering(layout)
{
\tthis.layout = layout;
};

/**
 * Extends mxHierarchicalLayoutStage.
 */
mxSwimlaneOrdering.prototype = new mxHierarchicalLayoutStage();
mxSwimlaneOrdering.prototype.constructor = mxSwimlaneOrdering;

/**
 * Variable: layout
 * 
 * Reference to the enclosing <mxHierarchicalLayout>.
 */
mxSwimlaneOrdering.prototype.layout = null;

/**
 * Function: execute
 * 
 * Takes the graph detail and configuration information within the facade
 * and creates the resulting laid out graph within that facade for further
 * use.
 */
mxSwimlaneOrdering.prototype.execute = function(parent)
{
\tvar model = this.layout.getModel();
\tvar seenNodes = new Object();
\tvar unseenNodes = mxUtils.clone(model.vertexMapper, null, true);
\t
\t// Perform a dfs through the internal model. If a cycle is found,
\t// reverse it.
\tvar rootsArray = null;
\t
\tif (model.roots != null)
\t{
\t\tvar modelRoots = model.roots;
\t\trootsArray = [];
\t\t
\t\tfor (var i = 0; i < modelRoots.length; i++)
\t\t{
\t\t\trootsArray[i] = model.vertexMapper.get(modelRoots[i]);
\t\t}
\t}

\tmodel.visit(function(parent, node, connectingEdge, layer, seen)
\t{
\t\t// Check if the cell is in it's own ancestor list, if so
\t\t// invert the connecting edge and reverse the target/source
\t\t// relationship to that edge in the parent and the cell
\t\t// Ancestor hashes only line up within a swimlane
\t\tvar isAncestor = parent != null && parent.swimlaneIndex == node.swimlaneIndex && node.isAncestor(parent);

\t\t// If the source->target swimlane indices go from higher to
\t\t// lower, the edge is reverse
\t\tvar reversedOverSwimlane = parent != null && connectingEdge != null &&
\t\t\t\t\t\tparent.swimlaneIndex < node.swimlaneIndex && connectingEdge.source == node;

\t\tif (isAncestor)
\t\t{
\t\t\tconnectingEdge.invert();
\t\t\tmxUtils.remove(connectingEdge, parent.connectsAsSource);
\t\t\tnode.connectsAsSource.push(connectingEdge);
\t\t\tparent.connectsAsTarget.push(connectingEdge);
\t\t\tmxUtils.remove(connectingEdge, node.connectsAsTarget);
\t\t}
\t\telse if (reversedOverSwimlane)
\t\t{
\t\t\tconnectingEdge.invert();
\t\t\tmxUtils.remove(connectingEdge, parent.connectsAsTarget);
\t\t\tnode.connectsAsTarget.push(connectingEdge);
\t\t\tparent.connectsAsSource.push(connectingEdge);
\t\t\tmxUtils.remove(connectingEdge, node.connectsAsSource);
\t\t}
\t\t
\t\tvar cellId = mxCellPath.create(node.cell);
\t\tseenNodes[cellId] = node;
\t\tdelete unseenNodes[cellId];
\t}, rootsArray, true, null);
};
/**
 * Copyright (c) 2006-2018, JGraph Ltd
 * Copyright (c) 2006-2018, Gaudenz Alder
 */
/**
 * Class: mxHierarchicalLayout
 * 
 * A hierarchical layout algorithm.
 * 
 * Constructor: mxHierarchicalLayout
 *
 * Constructs a new hierarchical layout algorithm.
 *
 * Arguments:
 * 
 * graph - Reference to the enclosing <mxGraph>.
 * orientation - Optional constant that defines the orientation of this
 * layout.
 * deterministic - Optional boolean that specifies if this layout should be
 * deterministic. Default is true.
 */
function mxHierarchicalLayout(graph, orientation, deterministic)
{
\tmxGraphLayout.call(this, graph);
\tthis.orientation = (orientation != null) ? orientation : mxConstants.DIRECTION_NORTH;
\tthis.deterministic = (deterministic != null) ? deterministic : true;
};

var mxHierarchicalEdgeStyle =
{
\tORTHOGONAL: 1,
\tPOLYLINE: 2,
\tSTRAIGHT: 3,
\tCURVE: 4
};

/**
 * Extends mxGraphLayout.
 */
mxHierarchicalLayout.prototype = new mxGraphLayout();
mxHierarchicalLayout.prototype.constructor = mxHierarchicalLayout;

/**
 * Variable: roots
 * 
 * Holds the array of <mxCell> that this layout contains.
 */
mxHierarchicalLayout.prototype.roots = null;

/**
 * Variable: resizeParent
 * 
 * Specifies if the parent should be resized after the layout so that it
 * contains all the child cells. Default is false. See also <parentBorder>.
 */
mxHierarchicalLayout.prototype.resizeParent = false;

/**
 * Variable: maintainParentLocation
 * 
 * Specifies if the parent location should be maintained, so that the
 * top, left corner stays the same before and after execution of
 * the layout. Default is false for backwards compatibility.
 */
mxHierarchicalLayout.prototype.maintainParentLocation = false;

/**
 * Variable: moveParent
 * 
 * Specifies if the parent should be moved if <resizeParent> is enabled.
 * Default is false.
 */
mxHierarchicalLayout.prototype.moveParent = false;

/**
 * Variable: parentBorder
 * 
 * The border to be added around the children if the parent is to be
 * resized using <resizeParent>. Default is 0.
 */
mxHierarchicalLayout.prototype.parentBorder = 0;

/**
 * Variable: intraCellSpacing
 * 
 * The spacing buffer added between cells on the same layer. Default is 30.
 */
mxHierarchicalLayout.prototype.intraCellSpacing = 30;

/**
 * Variable: interRankCellSpacing
 * 
 * The spacing buffer added between cell on adjacent layers. Default is 100.
 */
mxHierarchicalLayout.prototype.interRankCellSpacing = 100;

/**
 * Variable: interHierarchySpacing
 * 
 * The spacing buffer between unconnected hierarchies. Default is 60.
 */
mxHierarchicalLayout.prototype.interHierarchySpacing = 60;

/**
 * Variable: parallelEdgeSpacing
 * 
 * The distance between each parallel edge on each ranks for long edges.
 * Default is 10.
 */
mxHierarchicalLayout.prototype.parallelEdgeSpacing = 10;

/**
 * Variable: orientation
 * 
 * The position of the root node(s) relative to the laid out graph in.
 * Default is <mxConstants.DIRECTION_NORTH>.
 */
mxHierarchicalLayout.prototype.orientation = mxConstants.DIRECTION_NORTH;

/**
 * Variable: fineTuning
 * 
 * Whether or not to perform local optimisations and iterate multiple times
 * through the algorithm. Default is true.
 */
mxHierarchicalLayout.prototype.fineTuning = true;

/**
 * 
 * Variable: tightenToSource
 * 
 * Whether or not to tighten the assigned ranks of vertices up towards
 * the source cells. Default is true.
 */
mxHierarchicalLayout.prototype.tightenToSource = true;

/**
 * Variable: disableEdgeStyle
 * 
 * Specifies if the STYLE_NOEDGESTYLE flag should be set on edges that are
 * modified by the result. Default is true.
 */
mxHierarchicalLayout.prototype.disableEdgeStyle = true;

/**
 * Variable: traverseAncestors
 * 
 * Whether or not to drill into child cells and layout in reverse
 * group order. This also cause the layout to navigate edges whose 
 * terminal vertices have different parents but are in the same 
 * ancestry chain. Default is true.
 */
mxHierarchicalLayout.prototype.traverseAncestors = true;

/**
 * Variable: model
 * 
 * The internal <mxGraphHierarchyModel> formed of the layout.
 */
mxHierarchicalLayout.prototype.model = null;

/**
 * Variable: edgesSet
 * 
 * A cache of edges whose source terminal is the key
 */
mxHierarchicalLayout.prototype.edgesCache = null;

/**
 * Variable: edgesSet
 * 
 * A cache of edges whose source terminal is the key
 */
mxHierarchicalLayout.prototype.edgeSourceTermCache = null;

/**
 * Variable: edgesSet
 * 
 * A cache of edges whose source terminal is the key
 */
mxHierarchicalLayout.prototype.edgesTargetTermCache = null;

/**
 * Variable: edgeStyle
 * 
 * The style to apply between cell layers to edge segments.
 * Default is <mxHierarchicalEdgeStyle.POLYLINE>.
 */
mxHierarchicalLayout.prototype.edgeStyle = mxHierarchicalEdgeStyle.POLYLINE;

/**
 * Function: getModel
 * 
 * Returns the internal <mxGraphHierarchyModel> for this layout algorithm.
 */
mxHierarchicalLayout.prototype.getModel = function()
{
\treturn this.model;
};

/**
 * Function: execute
 * 
 * Executes the layout for the children of the specified parent.
 * 
 * Parameters:
 * 
 * parent - Parent <mxCell> that contains the children to be laid out.
 * roots - Optional starting roots of the layout.
 */
mxHierarchicalLayout.prototype.execute = function(parent, roots)
{
\tthis.parent = parent;
\tvar model = this.graph.model;
\tthis.edgesCache = new mxDictionary();
\tthis.edgeSourceTermCache = new mxDictionary();
\tthis.edgesTargetTermCache = new mxDictionary();

\tif (roots != null && !(roots instanceof Array))
\t{
\t\troots = [roots];
\t}
\t
\t// If the roots are set and the parent is set, only
\t// use the roots that are some dependent of the that
\t// parent.
\t// If just the root are set, use them as-is
\t// If just the parent is set use it's immediate
\t// children as the initial set

\tif (roots == null && parent == null)
\t{
\t\t// TODO indicate the problem
\t\treturn;
\t}
\t
\t//  Maintaining parent location
\tthis.parentX = null;
\tthis.parentY = null;
\t
\tif (parent != this.root && model.isVertex(parent) != null && this.maintainParentLocation)
\t{
\t\tvar geo = this.graph.getCellGeometry(parent);
\t\t
\t\tif (geo != null)
\t\t{
\t\t\tthis.parentX = geo.x;
\t\t\tthis.parentY = geo.y;
\t\t}
\t}
\t
\tif (roots != null)
\t{
\t\tvar rootsCopy = [];

\t\tfor (var i = 0; i < roots.length; i++)
\t\t{
\t\t\tvar ancestor = parent != null ? model.isAncestor(parent, roots[i]) : true;
\t\t\t
\t\t\tif (ancestor && model.isVertex(roots[i]))
\t\t\t{
\t\t\t\trootsCopy.push(roots[i]);
\t\t\t}
\t\t}

\t\tthis.roots = rootsCopy;
\t}
\t
\tmodel.beginUpdate();
\ttry
\t{
\t\tthis.run(parent);
\t\t
\t\tif (this.resizeParent && !this.graph.isCellCollapsed(parent))
\t\t{
\t\t\tthis.graph.updateGroupBounds([parent], this.parentBorder, this.moveParent);
\t\t}
\t\t
\t\t// Maintaining parent location
\t\tif (this.parentX != null && this.parentY != null)
\t\t{
\t\t\tvar geo = this.graph.getCellGeometry(parent);
\t\t\t
\t\t\tif (geo != null)
\t\t\t{
\t\t\t\tgeo = geo.clone();
\t\t\t\tgeo.x = this.parentX;
\t\t\t\tgeo.y = this.parentY;
\t\t\t\tmodel.setGeometry(parent, geo);
\t\t\t}
\t\t}
\t}
\tfinally
\t{
\t\tmodel.endUpdate();
\t}
};

/**
 * Function: findRoots
 * 
 * Returns all visible children in the given parent which do not have
 * incoming edges. If the result is empty then the children with the
 * maximum difference between incoming and outgoing edges are returned.
 * This takes into account edges that are being promoted to the given
 * root due to invisible children or collapsed cells.
 * 
 * Parameters:
 * 
 * parent - <mxCell> whose children should be checked.
 * vertices - array of vertices to limit search to
 */
mxHierarchicalLayout.prototype.findRoots = function(parent, vertices)
{
\tvar roots = [];
\t
\tif (parent != null && vertices != null)
\t{
\t\tvar model = this.graph.model;
\t\tvar best = null;
\t\tvar maxDiff = -100000;
\t\t
\t\tfor (var i in vertices)
\t\t{
\t\t\tvar cell = vertices[i];

\t\t\tif (model.isVertex(cell) && this.graph.isCellVisible(cell))
\t\t\t{
\t\t\t\tvar conns = this.getEdges(cell);
\t\t\t\tvar fanOut = 0;
\t\t\t\tvar fanIn = 0;

\t\t\t\tfor (var k = 0; k < conns.length; k++)
\t\t\t\t{
\t\t\t\t\tvar src = this.getVisibleTerminal(conns[k], true);

\t\t\t\t\tif (src == cell)
\t\t\t\t\t{
\t\t\t\t\t\tfanOut++;
\t\t\t\t\t}
\t\t\t\t\telse
\t\t\t\t\t{
\t\t\t\t\t\tfanIn++;
\t\t\t\t\t}
\t\t\t\t}

\t\t\t\tif (fanIn == 0 && fanOut > 0)
\t\t\t\t{
\t\t\t\t\troots.push(cell);
\t\t\t\t}

\t\t\t\tvar diff = fanOut - fanIn;

\t\t\t\tif (diff > maxDiff)
\t\t\t\t{
\t\t\t\t\tmaxDiff = diff;
\t\t\t\t\tbest = cell;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tif (roots.length == 0 && best != null)
\t\t{
\t\t\troots.push(best);
\t\t}
\t}
\t
\treturn roots;
};

/**
 * Function: getEdges
 * 
 * Returns the connected edges for the given cell.
 * 
 * Parameters:
 * 
 * cell - <mxCell> whose edges should be returned.
 */
mxHierarchicalLayout.prototype.getEdges = function(cell)
{
\tvar cachedEdges = this.edgesCache.get(cell);
\t
\tif (cachedEdges != null)
\t{
\t\treturn cachedEdges;
\t}

\tvar model = this.graph.model;
\tvar edges = [];
\tvar isCollapsed = this.graph.isCellCollapsed(cell);
\tvar childCount = model.getChildCount(cell);

\tfor (var i = 0; i < childCount; i++)
\t{
\t\tvar child = model.getChildAt(cell, i);

\t\tif (this.isPort(child))
\t\t{
\t\t\tedges = edges.concat(model.getEdges(child, true, true));
\t\t}
\t\telse if (isCollapsed || !this.graph.isCellVisible(child))
\t\t{
\t\t\tedges = edges.concat(model.getEdges(child, true, true));
\t\t}
\t}

\tedges = edges.concat(model.getEdges(cell, true, true));
\tvar result = [];
\t
\tfor (var i = 0; i < edges.length; i++)
\t{
\t\tvar source = this.getVisibleTerminal(edges[i], true);
\t\tvar target = this.getVisibleTerminal(edges[i], false);
\t\t
\t\tif ((source == target) ||
\t\t\t\t((source != target) &&
\t\t\t\t\t\t((target == cell && (this.parent == null || this.isAncestor(this.parent, source, this.traverseAncestors))) ||
\t\t\t\t\t\t \t(source == cell && (this.parent == null || this.isAncestor(this.parent, target, this.traverseAncestors))))))
\t\t{
\t\t\tresult.push(edges[i]);
\t\t}
\t}

\tthis.edgesCache.put(cell, result);

\treturn result;
};

/**
 * Function: getVisibleTerminal
 * 
 * Helper function to return visible terminal for edge allowing for ports
 * 
 * Parameters:
 * 
 * edge - <mxCell> whose edges should be returned.
 * source - Boolean that specifies whether the source or target terminal is to be returned
 */
mxHierarchicalLayout.prototype.getVisibleTerminal = function(edge, source)
{
\tvar terminalCache = this.edgesTargetTermCache;
\t
\tif (source)
\t{
\t\tterminalCache = this.edgeSourceTermCache;
\t}

\tvar term = terminalCache.get(edge);

\tif (term != null)
\t{
\t\treturn term;
\t}

\tvar state = this.graph.view.getState(edge);
\t
\tvar terminal = (state != null) ? state.getVisibleTerminal(source) : this.graph.view.getVisibleTerminal(edge, source);
\t
\tif (terminal == null)
\t{
\t\tterminal = (state != null) ? state.getVisibleTerminal(source) : this.graph.view.getVisibleTerminal(edge, source);
\t}

\tif (terminal != null)
\t{
\t\tif (this.isPort(terminal))
\t\t{
\t\t\tterminal = this.graph.model.getParent(terminal);
\t\t}
\t\t
\t\tterminalCache.put(edge, terminal);
\t}

\treturn terminal;
};

/**
 * Function: run
 * 
 * The API method used to exercise the layout upon the graph description
 * and produce a separate description of the vertex position and edge
 * routing changes made. It runs each stage of the layout that has been
 * created.
 */
mxHierarchicalLayout.prototype.run = function(parent)
{
\t// Separate out unconnected hierarchies
\tvar hierarchyVertices = [];
\tvar allVertexSet = [];

\tif (this.roots == null && parent != null)
\t{
\t\tvar filledVertexSet = Object();
\t\tthis.filterDescendants(parent, filledVertexSet);

\t\tthis.roots = [];
\t\tvar filledVertexSetEmpty = true;

\t\t// Poor man's isSetEmpty
\t\tfor (var key in filledVertexSet)
\t\t{
\t\t\tif (filledVertexSet[key] != null)
\t\t\t{
\t\t\t\tfilledVertexSetEmpty = false;
\t\t\t\tbreak;
\t\t\t}
\t\t}

\t\twhile (!filledVertexSetEmpty)
\t\t{
\t\t\tvar candidateRoots = this.findRoots(parent, filledVertexSet);
\t\t\t
\t\t\t// If the candidate root is an unconnected group cell, remove it from
\t\t\t// the layout. We may need a custom set that holds such groups and forces
\t\t\t// them to be processed for resizing and/or moving.
\t\t\t

\t\t\tfor (var i = 0; i < candidateRoots.length; i++)
\t\t\t{
\t\t\t\tvar vertexSet = Object();
\t\t\t\thierarchyVertices.push(vertexSet);

\t\t\t\tthis.traverse(candidateRoots[i], true, null, allVertexSet, vertexSet,
\t\t\t\t\t\thierarchyVertices, filledVertexSet);
\t\t\t}

\t\t\tfor (var i = 0; i < candidateRoots.length; i++)
\t\t\t{
\t\t\t\tthis.roots.push(candidateRoots[i]);
\t\t\t}
\t\t\t
\t\t\tfilledVertexSetEmpty = true;
\t\t\t
\t\t\t// Poor man's isSetEmpty
\t\t\tfor (var key in filledVertexSet)
\t\t\t{
\t\t\t\tif (filledVertexSet[key] != null)
\t\t\t\t{
\t\t\t\t\tfilledVertexSetEmpty = false;
\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\t// Find vertex set as directed traversal from roots

\t\tfor (var i = 0; i < this.roots.length; i++)
\t\t{
\t\t\tvar vertexSet = Object();
\t\t\thierarchyVertices.push(vertexSet);

\t\t\tthis.traverse(this.roots[i], true, null, allVertexSet, vertexSet,
\t\t\t\t\thierarchyVertices, null);
\t\t}
\t}

\t// Iterate through the result removing parents who have children in this layout
\t
\t// Perform a layout for each seperate hierarchy
\t// Track initial coordinate x-positioning
\tvar initialX = 0;

\tfor (var i = 0; i < hierarchyVertices.length; i++)
\t{
\t\tvar vertexSet = hierarchyVertices[i];
\t\tvar tmp = [];
\t\t
\t\tfor (var key in vertexSet)
\t\t{
\t\t\ttmp.push(vertexSet[key]);
\t\t}
\t\t
\t\tthis.model = new mxGraphHierarchyModel(this, tmp, this.roots,
\t\t\tparent, this.tightenToSource);

\t\tthis.cycleStage(parent);
\t\tthis.layeringStage();
\t\t
\t\tthis.crossingStage(parent);
\t\tinitialX = this.placementStage(initialX, parent);
\t}
};

/**
 * Function: filterDescendants
 * 
 * Creates an array of descendant cells
 */
mxHierarchicalLayout.prototype.filterDescendants = function(cell, result)
{
\tvar model = this.graph.model;

\tif (model.isVertex(cell) && cell != this.parent && this.graph.isCellVisible(cell))
\t{
\t\tresult[mxObjectIdentity.get(cell)] = cell;
\t}

\tif (this.traverseAncestors || cell == this.parent
\t\t\t&& this.graph.isCellVisible(cell))
\t{
\t\tvar childCount = model.getChildCount(cell);

\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\tvar child = model.getChildAt(cell, i);
\t\t\t
\t\t\t// Ignore ports in the layout vertex list, they are dealt with
\t\t\t// in the traversal mechanisms
\t\t\tif (!this.isPort(child))
\t\t\t{
\t\t\t\tthis.filterDescendants(child, result);
\t\t\t}
\t\t}
\t}
};

/**
 * Function: isPort
 * 
 * Returns true if the given cell is a \"port\", that is, when connecting to
 * it, its parent is the connecting vertex in terms of graph traversal
 * 
 * Parameters:
 * 
 * cell - <mxCell> that represents the port.
 */
mxHierarchicalLayout.prototype.isPort = function(cell)
{
\tif (cell != null && cell.geometry != null)
\t{
\t\treturn cell.geometry.relative;
\t}
\telse
\t{
\t\treturn false;
\t}
};

/**
 * Function: getEdgesBetween
 * 
 * Returns the edges between the given source and target. This takes into
 * account collapsed and invisible cells and ports.
 * 
 * Parameters:
 * 
 * source -
 * target -
 * directed -
 */
mxHierarchicalLayout.prototype.getEdgesBetween = function(source, target, directed)
{
\tdirected = (directed != null) ? directed : false;
\tvar edges = this.getEdges(source);
\tvar result = [];

\t// Checks if the edge is connected to the correct
\t// cell and returns the first match
\tfor (var i = 0; i < edges.length; i++)
\t{
\t\tvar src = this.getVisibleTerminal(edges[i], true);
\t\tvar trg = this.getVisibleTerminal(edges[i], false);

\t\tif ((src == source && trg == target) || (!directed && src == target && trg == source))
\t\t{
\t\t\tresult.push(edges[i]);
\t\t}
\t}

\treturn result;
};

/**
 * Traverses the (directed) graph invoking the given function for each
 * visited vertex and edge. The function is invoked with the current vertex
 * and the incoming edge as a parameter. This implementation makes sure
 * each vertex is only visited once. The function may return false if the
 * traversal should stop at the given vertex.
 * 
 * Parameters:
 * 
 * vertex - <mxCell> that represents the vertex where the traversal starts.
 * directed - boolean indicating if edges should only be traversed
 * from source to target. Default is true.
 * edge - Optional <mxCell> that represents the incoming edge. This is
 * null for the first step of the traversal.
 * allVertices - Array of cell paths for the visited cells.
 */
mxHierarchicalLayout.prototype.traverse = function(vertex, directed, edge, allVertices, currentComp,
\t\t\t\t\t\t\t\t\t\t\thierarchyVertices, filledVertexSet)
{
\tif (vertex != null && allVertices != null)
\t{
\t\t// Has this vertex been seen before in any traversal
\t\t// And if the filled vertex set is populated, only 
\t\t// process vertices in that it contains
\t\tvar vertexID = mxObjectIdentity.get(vertex);
\t\t
\t\tif ((allVertices[vertexID] == null)
\t\t\t\t&& (filledVertexSet == null ? true : filledVertexSet[vertexID] != null))
\t\t{
\t\t\tif (currentComp[vertexID] == null)
\t\t\t{
\t\t\t\tcurrentComp[vertexID] = vertex;
\t\t\t}
\t\t\tif (allVertices[vertexID] == null)
\t\t\t{
\t\t\t\tallVertices[vertexID] = vertex;
\t\t\t}

\t\t\tif (filledVertexSet !== null)
\t\t\t{
\t\t\t\tdelete filledVertexSet[vertexID];
\t\t\t}

\t\t\tvar edges = this.getEdges(vertex);
\t\t\tvar edgeIsSource = [];

\t\t\tfor (var i = 0; i < edges.length; i++)
\t\t\t{
\t\t\t\tedgeIsSource[i] = (this.getVisibleTerminal(edges[i], true) == vertex);
\t\t\t}

\t\t\tfor (var i = 0; i < edges.length; i++)
\t\t\t{
\t\t\t\tif (!directed || edgeIsSource[i])
\t\t\t\t{
\t\t\t\t\tvar next = this.getVisibleTerminal(edges[i], !edgeIsSource[i]);
\t\t\t\t\t
\t\t\t\t\t// Check whether there are more edges incoming from the target vertex than outgoing
\t\t\t\t\t// The hierarchical model treats bi-directional parallel edges as being sourced
\t\t\t\t\t// from the more \"sourced\" terminal. If the directions are equal in number, the direction
\t\t\t\t\t// is that of the natural direction from the roots of the layout.
\t\t\t\t\t// The checks below are slightly more verbose than need be for performance reasons
\t\t\t\t\tvar netCount = 1;

\t\t\t\t\tfor (var j = 0; j < edges.length; j++)
\t\t\t\t\t{
\t\t\t\t\t\tif (j == i)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tcontinue;
\t\t\t\t\t\t}
\t\t\t\t\t\telse
\t\t\t\t\t\t{
\t\t\t\t\t\t\tvar isSource2 = edgeIsSource[j];
\t\t\t\t\t\t\tvar otherTerm = this.getVisibleTerminal(edges[j], !isSource2);
\t\t\t\t\t\t\t
\t\t\t\t\t\t\tif (otherTerm == next)
\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\tif (isSource2)
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tnetCount++;
\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t\telse
\t\t\t\t\t\t\t\t{
\t\t\t\t\t\t\t\t\tnetCount--;
\t\t\t\t\t\t\t\t}
\t\t\t\t\t\t\t}
\t\t\t\t\t\t}
\t\t\t\t\t}

\t\t\t\t\tif (netCount >= 0)
\t\t\t\t\t{
\t\t\t\t\t\tcurrentComp = this.traverse(next, directed, edges[i], allVertices,
\t\t\t\t\t\t\tcurrentComp, hierarchyVertices,
\t\t\t\t\t\t\tfilledVertexSet);
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t\telse
\t\t{
\t\t\tif (currentComp[vertexID] == null)
\t\t\t{
\t\t\t\t// We've seen this vertex before, but not in the current component
\t\t\t\t// This component and the one it's in need to be merged

\t\t\t\tfor (var i = 0; i < hierarchyVertices.length; i++)
\t\t\t\t{
\t\t\t\t\tvar comp = hierarchyVertices[i];

\t\t\t\t\tif (comp[vertexID] != null)
\t\t\t\t\t{
\t\t\t\t\t\tfor (var key in comp)
\t\t\t\t\t\t{
\t\t\t\t\t\t\tcurrentComp[key] = comp[key];
\t\t\t\t\t\t}
\t\t\t\t\t\t
\t\t\t\t\t\t// Remove the current component from the hierarchy set
\t\t\t\t\t\thierarchyVertices.splice(i, 1);
\t\t\t\t\t\treturn currentComp;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\t
\treturn currentComp;
};

/**
 * Function: cycleStage
 * 
 * Executes the cycle stage using mxMinimumCycleRemover.
 */
mxHierarchicalLayout.prototype.cycleStage = function(parent)
{
\tvar cycleStage = new mxMinimumCycleRemover(this);
\tcycleStage.execute(parent);
};

/**
 * Function: layeringStage
 * 
 * Implements first stage of a Sugiyama layout.
 */
mxHierarchicalLayout.prototype.layeringStage = function()
{
\tthis.model.initialRank();
\tthis.model.fixRanks();
};

/**
 * Function: crossingStage
 * 
 * Executes the crossing stage using mxMedianHybridCrossingReduction.
 */
mxHierarchicalLayout.prototype.crossingStage = function(parent)
{
\tvar crossingStage = new mxMedianHybridCrossingReduction(this);
\tcrossingStage.execute(parent);
};

/**
 * Function: placementStage
 * 
 * Executes the placement stage using mxCoordinateAssignment.
 */
mxHierarchicalLayout.prototype.placementStage = function(initialX, parent)
{
\tvar placementStage = new mxCoordinateAssignment(this, this.intraCellSpacing,
\t\t\tthis.interRankCellSpacing, this.orientation, initialX,
\t\t\tthis.parallelEdgeSpacing);
\tplacementStage.fineTuning = this.fineTuning;
\tplacementStage.execute(parent);
\t
\treturn placementStage.limitX + this.interHierarchySpacing;
};
/**
 * Copyright (c) 2006-2015, JGraph Ltd
 * Copyright (c) 2006-2015, Gaudenz Alder
 */
/**
 * Class: mxSwimlaneLayout
 * 
 * A hierarchical layout algorithm.
 * 
 * Constructor: mxSwimlaneLayout
 *
 * Constructs a new hierarchical layout algorithm.
 *
 * Arguments:
 * 
 * graph - Reference to the enclosing <mxGraph>.
 * orientation - Optional constant that defines the orientation of this
 * layout.
 * deterministic - Optional boolean that specifies if this layout should be
 * deterministic. Default is true.
 */
function mxSwimlaneLayout(graph, orientation, deterministic)
{
\tmxGraphLayout.call(this, graph);
\tthis.orientation = (orientation != null) ? orientation : mxConstants.DIRECTION_NORTH;
\tthis.deterministic = (deterministic != null) ? deterministic : true;
};

/**
 * Extends mxGraphLayout.
 */
mxSwimlaneLayout.prototype = new mxGraphLayout();
mxSwimlaneLayout.prototype.constructor = mxSwimlaneLayout;

/**
 * Variable: roots
 * 
 * Holds the array of <mxCell> that this layout contains.
 */
mxSwimlaneLayout.prototype.roots = null;

/**
 * Variable: swimlanes
 * 
 * Holds the array of <mxCell> of the ordered swimlanes to lay out
 */
mxSwimlaneLayout.prototype.swimlanes = null;

/**
 * Variable: dummyVertexWidth
 * 
 * The cell width of any dummy vertices inserted
 */
mxSwimlaneLayout.prototype.dummyVertexWidth = 50;

/**
 * Variable: resizeParent
 * 
 * Specifies if the parent should be resized after the layout so that it
 * contains all the child cells. Default is false. See also <parentBorder>.
 */
mxSwimlaneLayout.prototype.resizeParent = false;

/**
 * Variable: maintainParentLocation
 * 
 * Specifies if the parent location should be maintained, so that the
 * top, left corner stays the same before and after execution of
 * the layout. Default is false for backwards compatibility.
 */
mxSwimlaneLayout.prototype.maintainParentLocation = false;

/**
 * Variable: moveParent
 * 
 * Specifies if the parent should be moved if <resizeParent> is enabled.
 * Default is false.
 */
mxSwimlaneLayout.prototype.moveParent = false;

/**
 * Variable: parentBorder
 * 
 * The border to be added around the children if the parent is to be
 * resized using <resizeParent>. Default is 30.
 */
mxSwimlaneLayout.prototype.parentBorder = 30;

/**
 * Variable: intraCellSpacing
 * 
 * The spacing buffer added between cells on the same layer. Default is 30.
 */
mxSwimlaneLayout.prototype.intraCellSpacing = 30;

/**
 * Variable: interRankCellSpacing
 * 
 * The spacing buffer added between cell on adjacent layers. Default is 100.
 */
mxSwimlaneLayout.prototype.interRankCellSpacing = 100;

/**
 * Variable: interHierarchySpacing
 * 
 * The spacing buffer between unconnected hierarchies. Default is 60.
 */
mxSwimlaneLayout.prototype.interHierarchySpacing = 60;

/**
 * Variable: parallelEdgeSpacing
 * 
 * The distance between each parallel edge on each ranks for long edges.
 * Default is 10.
 */
mxSwimlaneLayout.prototype.parallelEdgeSpacing = 10;

/**
 * Variable: orientation
 * 
 * The position of the root node(s) relative to the laid out graph in.
 * Default is <mxConstants.DIRECTION_NORTH>.
 */
mxSwimlaneLayout.prototype.orientation = mxConstants.DIRECTION_NORTH;

/**
 * Variable: fineTuning
 * 
 * Whether or not to perform local optimisations and iterate multiple times
 * through the algorithm. Default is true.
 */
mxSwimlaneLayout.prototype.fineTuning = true;

/**
 * Variable: tightenToSource
 * 
 * Whether or not to tighten the assigned ranks of vertices up towards
 * the source cells. Default is true.
 */
mxSwimlaneLayout.prototype.tightenToSource = true;

/**
 * Variable: disableEdgeStyle
 * 
 * Specifies if the STYLE_NOEDGESTYLE flag should be set on edges that are
 * modified by the result. Default is true.
 */
mxSwimlaneLayout.prototype.disableEdgeStyle = true;

/**
 * Variable: traverseAncestors
 * 
 * Whether or not to drill into child cells and layout in reverse
 * group order. This also cause the layout to navigate edges whose 
 * terminal vertices have different parents but are in the same
 * ancestry chain. Default is true.
 */
mxSwimlaneLayout.prototype.traverseAncestors = true;

/**
 * Variable: model
 * 
 * The internal <mxSwimlaneModel> formed of the layout.
 */
mxSwimlaneLayout.prototype.model = null;

/**
 * Variable: edgesSet
 * 
 * A cache of edges whose source terminal is the key
 */
mxSwimlaneLayout.prototype.edgesCache = null;

/**
 * Variable: edgesSet
 * 
 * A cache of edges whose source terminal is the key
 */
mxHierarchicalLayout.prototype.edgeSourceTermCache = null;

/**
 * Variable: edgesSet
 * 
 * A cache of edges whose source terminal is the key
 */
mxHierarchicalLayout.prototype.edgesTargetTermCache = null;

/**
 * Variable: edgeStyle
 * 
 * The style to apply between cell layers to edge segments.
 * Default is <mxHierarchicalEdgeStyle.POLYLINE>.
 */
mxHierarchicalLayout.prototype.edgeStyle = mxHierarchicalEdgeStyle.POLYLINE;

/**
 * Function: getModel
 * 
 * Returns the internal <mxSwimlaneModel> for this layout algorithm.
 */
mxSwimlaneLayout.prototype.getModel = function()
{
\treturn this.model;
};

/**
 * Function: execute
 * 
 * Executes the layout for the children of the specified parent.
 * 
 * Parameters:
 * 
 * parent - Parent <mxCell> that contains the children to be laid out.
 * swimlanes - Ordered array of swimlanes to be laid out
 */
mxSwimlaneLayout.prototype.execute = function(parent, swimlanes)
{
\tthis.parent = parent;
\tvar model = this.graph.model;
\tthis.edgesCache = new mxDictionary();
\tthis.edgeSourceTermCache = new mxDictionary();
\tthis.edgesTargetTermCache = new mxDictionary();

\t// If the roots are set and the parent is set, only
\t// use the roots that are some dependent of the that
\t// parent.
\t// If just the root are set, use them as-is
\t// If just the parent is set use it's immediate
\t// children as the initial set

\tif (swimlanes == null || swimlanes.length < 1)
\t{
\t\t// TODO indicate the problem
\t\treturn;
\t}

\tif (parent == null)
\t{
\t\tparent = model.getParent(swimlanes[0]);
\t}

\t//  Maintaining parent location
\tthis.parentX = null;
\tthis.parentY = null;
\t
\tif (parent != this.root && model.isVertex(parent) != null && this.maintainParentLocation)
\t{
\t\tvar geo = this.graph.getCellGeometry(parent);
\t\t
\t\tif (geo != null)
\t\t{
\t\t\tthis.parentX = geo.x;
\t\t\tthis.parentY = geo.y;
\t\t}
\t}

\tthis.swimlanes = swimlanes;
\tvar dummyVertices = [];
\t// Check the swimlanes all have vertices
\t// in them
\tfor (var i = 0; i < swimlanes.length; i++)
\t{
\t\tvar children = this.graph.getChildCells(swimlanes[i]);
\t\t
\t\tif (children == null || children.length == 0)
\t\t{
\t\t\tvar vertex = this.graph.insertVertex(swimlanes[i], null, null, 0, 0, this.dummyVertexWidth, 0);
\t\t\tdummyVertices.push(vertex);
\t\t}
\t}
\t
\tmodel.beginUpdate();
\ttry
\t{
\t\tthis.run(parent);
\t\t
\t\tif (this.resizeParent && !this.graph.isCellCollapsed(parent))
\t\t{
\t\t\tthis.graph.updateGroupBounds([parent], this.parentBorder, this.moveParent);
\t\t}
\t\t
\t\t// Maintaining parent location
\t\tif (this.parentX != null && this.parentY != null)
\t\t{
\t\t\tvar geo = this.graph.getCellGeometry(parent);
\t\t\t
\t\t\tif (geo != null)
\t\t\t{
\t\t\t\tgeo = geo.clone();
\t\t\t\tgeo.x = this.parentX;
\t\t\t\tgeo.y = this.parentY;
\t\t\t\tmodel.setGeometry(parent, geo);
\t\t\t}
\t\t}

\t\tthis.graph.removeCells(dummyVertices);
\t}
\tfinally
\t{
\t\tmodel.endUpdate();
\t}
};

/**
 * Function: updateGroupBounds
 * 
 * Updates the bounds of the given array of groups so that it includes
 * all child vertices.
 * 
 */
mxSwimlaneLayout.prototype.updateGroupBounds = function()
{
\t// Get all vertices and edge in the layout
\tvar cells = [];
\tvar model = this.model;
\t
\tfor (var key in model.edgeMapper)
\t{
\t\tvar edge = model.edgeMapper[key];
\t\t
\t\tfor (var i = 0; i < edge.edges.length; i++)
\t\t{
\t\t\tcells.push(edge.edges[i]);
\t\t}
\t}
\t
\tvar layoutBounds = this.graph.getBoundingBoxFromGeometry(cells, true);
\tvar childBounds = [];

\tfor (var i = 0; i < this.swimlanes.length; i++)
\t{
\t\tvar lane = this.swimlanes[i];
\t\tvar geo = this.graph.getCellGeometry(lane);
\t\t
\t\tif (geo != null)
\t\t{
\t\t\tvar children = this.graph.getChildCells(lane);
\t\t\t
\t\t\tvar size = (this.graph.isSwimlane(lane)) ?
\t\t\t\t\tthis.graph.getStartSize(lane) : new mxRectangle();

\t\t\tvar bounds = this.graph.getBoundingBoxFromGeometry(children);
\t\t\tchildBounds[i] = bounds;
\t\t\tvar childrenY = bounds.y + geo.y - size.height - this.parentBorder;
\t\t\tvar maxChildrenY = bounds.y + geo.y + bounds.height;

\t\t\tif (layoutBounds == null)
\t\t\t{
\t\t\t\tlayoutBounds = new mxRectangle(0, childrenY, 0, maxChildrenY - childrenY);
\t\t\t}
\t\t\telse
\t\t\t{
\t\t\t\tlayoutBounds.y = Math.min(layoutBounds.y, childrenY);
\t\t\t\tvar maxY = Math.max(layoutBounds.y + layoutBounds.height, maxChildrenY);
\t\t\t\tlayoutBounds.height = maxY - layoutBounds.y;
\t\t\t}
\t\t}
\t}

\t
\tfor (var i = 0; i < this.swimlanes.length; i++)
\t{
\t\tvar lane = this.swimlanes[i];
\t\tvar geo = this.graph.getCellGeometry(lane);
\t\t
\t\tif (geo != null)
\t\t{
\t\t\tvar children = this.graph.getChildCells(lane);
\t\t\t
\t\t\tvar size = (this.graph.isSwimlane(lane)) ?
\t\t\t\t\tthis.graph.getStartSize(lane) : new mxRectangle();

\t\t\tvar newGeo = geo.clone();
\t\t\t
\t\t\tvar leftGroupBorder = (i == 0) ? this.parentBorder : this.interRankCellSpacing/2;
\t\t\tvar w = size.width + leftGroupBorder;
\t\t\tvar x = childBounds[i].x - w;
\t\t\tvar y = layoutBounds.y - this.parentBorder;

\t\t\tnewGeo.x += x;
\t\t\tnewGeo.y = y;
\t\t\t
\t\t\tnewGeo.width = childBounds[i].width + w + this.interRankCellSpacing/2;
\t\t\tnewGeo.height = layoutBounds.height + size.height + 2 * this.parentBorder;
\t\t\t
\t\t\tthis.graph.model.setGeometry(lane, newGeo);
\t\t\tthis.graph.moveCells(children, -x, geo.y - y);
\t\t}
\t}
};

/**
 * Function: findRoots
 * 
 * Returns all visible children in the given parent which do not have
 * incoming edges. If the result is empty then the children with the
 * maximum difference between incoming and outgoing edges are returned.
 * This takes into account edges that are being promoted to the given
 * root due to invisible children or collapsed cells.
 * 
 * Parameters:
 * 
 * parent - <mxCell> whose children should be checked.
 * vertices - array of vertices to limit search to
 */
mxSwimlaneLayout.prototype.findRoots = function(parent, vertices)
{
\tvar roots = [];
\t
\tif (parent != null && vertices != null)
\t{
\t\tvar model = this.graph.model;
\t\tvar best = null;
\t\tvar maxDiff = -100000;
\t\t
\t\tfor (var i in vertices)
\t\t{
\t\t\tvar cell = vertices[i];

\t\t\tif (cell != null && model.isVertex(cell) && this.graph.isCellVisible(cell) && model.isAncestor(parent, cell))
\t\t\t{
\t\t\t\tvar conns = this.getEdges(cell);
\t\t\t\tvar fanOut = 0;
\t\t\t\tvar fanIn = 0;

\t\t\t\tfor (var k = 0; k < conns.length; k++)
\t\t\t\t{
\t\t\t\t\tvar src = this.getVisibleTerminal(conns[k], true);

\t\t\t\t\tif (src == cell)
\t\t\t\t\t{
\t\t\t\t\t\t// Only count connection within this swimlane
\t\t\t\t\t\tvar other = this.getVisibleTerminal(conns[k], false);
\t\t\t\t\t\t
\t\t\t\t\t\tif (model.isAncestor(parent, other))
\t\t\t\t\t\t{
\t\t\t\t\t\t\tfanOut++;
\t\t\t\t\t\t}
\t\t\t\t\t}
\t\t\t\t\telse if (model.isAncestor(parent, src))
\t\t\t\t\t{
\t\t\t\t\t\tfanIn++;
\t\t\t\t\t}
\t\t\t\t}

\t\t\t\tif (fanIn == 0 && fanOut > 0)
\t\t\t\t{
\t\t\t\t\troots.push(cell);
\t\t\t\t}

\t\t\t\tvar diff = fanOut - fanIn;

\t\t\t\tif (diff > maxDiff)
\t\t\t\t{
\t\t\t\t\tmaxDiff = diff;
\t\t\t\t\tbest = cell;
\t\t\t\t}
\t\t\t}
\t\t}
\t\t
\t\tif (roots.length == 0 && best != null)
\t\t{
\t\t\troots.push(best);
\t\t}
\t}
\t
\treturn roots;
};

/**
 * Function: getEdges
 * 
 * Returns the connected edges for the given cell.
 * 
 * Parameters:
 * 
 * cell - <mxCell> whose edges should be returned.
 */
mxSwimlaneLayout.prototype.getEdges = function(cell)
{
\tvar cachedEdges = this.edgesCache.get(cell);
\t
\tif (cachedEdges != null)
\t{
\t\treturn cachedEdges;
\t}

\tvar model = this.graph.model;
\tvar edges = [];
\tvar isCollapsed = this.graph.isCellCollapsed(cell);
\tvar childCount = model.getChildCount(cell);

\tfor (var i = 0; i < childCount; i++)
\t{
\t\tvar child = model.getChildAt(cell, i);

\t\tif (this.isPort(child))
\t\t{
\t\t\tedges = edges.concat(model.getEdges(child, true, true));
\t\t}
\t\telse if (isCollapsed || !this.graph.isCellVisible(child))
\t\t{
\t\t\tedges = edges.concat(model.getEdges(child, true, true));
\t\t}
\t}

\tedges = edges.concat(model.getEdges(cell, true, true));
\tvar result = [];
\t
\tfor (var i = 0; i < edges.length; i++)
\t{
\t\tvar source = this.getVisibleTerminal(edges[i], true);
\t\tvar target = this.getVisibleTerminal(edges[i], false);
\t\t
\t\tif ((source == target) || ((source != target) && ((target == cell && (this.parent == null || this.graph.isValidAncestor(source, this.parent, this.traverseAncestors))) ||
\t\t\t(source == cell && (this.parent == null ||
\t\t\t\t\tthis.graph.isValidAncestor(target, this.parent, this.traverseAncestors))))))
\t\t{
\t\t\tresult.push(edges[i]);
\t\t}
\t}

\tthis.edgesCache.put(cell, result);

\treturn result;
};

/**
 * Function: getVisibleTerminal
 * 
 * Helper function to return visible terminal for edge allowing for ports
 * 
 * Parameters:
 * 
 * edge - <mxCell> whose edges should be returned.
 * source - Boolean that specifies whether the source or target terminal is to be returned
 */
mxSwimlaneLayout.prototype.getVisibleTerminal = function(edge, source)
{
\tvar terminalCache = this.edgesTargetTermCache;
\t
\tif (source)
\t{
\t\tterminalCache = this.edgeSourceTermCache;
\t}

\tvar term = terminalCache.get(edge);

\tif (term != null)
\t{
\t\treturn term;
\t}

\tvar state = this.graph.view.getState(edge);
\t
\tvar terminal = (state != null) ? state.getVisibleTerminal(source) : this.graph.view.getVisibleTerminal(edge, source);
\t
\tif (terminal == null)
\t{
\t\tterminal = (state != null) ? state.getVisibleTerminal(source) : this.graph.view.getVisibleTerminal(edge, source);
\t}

\tif (terminal != null)
\t{
\t\tif (this.isPort(terminal))
\t\t{
\t\t\tterminal = this.graph.model.getParent(terminal);
\t\t}
\t\t
\t\tterminalCache.put(edge, terminal);
\t}

\treturn terminal;
};

/**
 * Function: run
 * 
 * The API method used to exercise the layout upon the graph description
 * and produce a separate description of the vertex position and edge
 * routing changes made. It runs each stage of the layout that has been
 * created.
 */
mxSwimlaneLayout.prototype.run = function(parent)
{
\t// Separate out unconnected hierarchies
\tvar hierarchyVertices = [];
\tvar allVertexSet = Object();

\tif (this.swimlanes != null && this.swimlanes.length > 0 && parent != null)
\t{
\t\tvar filledVertexSet = Object();
\t\t
\t\tfor (var i = 0; i < this.swimlanes.length; i++)
\t\t{
\t\t\tthis.filterDescendants(this.swimlanes[i], filledVertexSet);
\t\t}

\t\tthis.roots = [];
\t\tvar filledVertexSetEmpty = true;

\t\t// Poor man's isSetEmpty
\t\tfor (var key in filledVertexSet)
\t\t{
\t\t\tif (filledVertexSet[key] != null)
\t\t\t{
\t\t\t\tfilledVertexSetEmpty = false;
\t\t\t\tbreak;
\t\t\t}
\t\t}

\t\t// Only test for candidates in each swimlane in order
\t\tvar laneCounter = 0;

\t\twhile (!filledVertexSetEmpty && laneCounter < this.swimlanes.length)
\t\t{
\t\t\tvar candidateRoots = this.findRoots(this.swimlanes[laneCounter], filledVertexSet);
\t\t\t
\t\t\tif (candidateRoots.length == 0)
\t\t\t{
\t\t\t\tlaneCounter++;
\t\t\t\tcontinue;
\t\t\t}
\t\t\t
\t\t\t// If the candidate root is an unconnected group cell, remove it from
\t\t\t// the layout. We may need a custom set that holds such groups and forces
\t\t\t// them to be processed for resizing and/or moving.
\t\t\tfor (var i = 0; i < candidateRoots.length; i++)
\t\t\t{
\t\t\t\tvar vertexSet = Object();
\t\t\t\thierarchyVertices.push(vertexSet);

\t\t\t\tthis.traverse(candidateRoots[i], true, null, allVertexSet, vertexSet,
\t\t\t\t\t\thierarchyVertices, filledVertexSet, laneCounter);
\t\t\t}

\t\t\tfor (var i = 0; i < candidateRoots.length; i++)
\t\t\t{
\t\t\t\tthis.roots.push(candidateRoots[i]);
\t\t\t}
\t\t\t
\t\t\tfilledVertexSetEmpty = true;
\t\t\t
\t\t\t// Poor man's isSetEmpty
\t\t\tfor (var key in filledVertexSet)
\t\t\t{
\t\t\t\tif (filledVertexSet[key] != null)
\t\t\t\t{
\t\t\t\t\tfilledVertexSetEmpty = false;
\t\t\t\t\tbreak;
\t\t\t\t}
\t\t\t}
\t\t}
\t}
\telse
\t{
\t\t// Find vertex set as directed traversal from roots

\t\tfor (var i = 0; i < this.roots.length; i++)
\t\t{
\t\t\tvar vertexSet = Object();
\t\t\thierarchyVertices.push(vertexSet);

\t\t\tthis.traverse(this.roots[i], true, null, allVertexSet, vertexSet,
\t\t\t\t\thierarchyVertices, null);
\t\t}
\t}

\tvar tmp = [];
\t
\tfor (var key in allVertexSet)
\t{
\t\ttmp.push(allVertexSet[key]);
\t}
\t
\tthis.model = new mxSwimlaneModel(this, tmp, this.roots,
\t\tparent, this.tightenToSource);

\tthis.cycleStage(parent);
\tthis.layeringStage();
\t
\tthis.crossingStage(parent);
\tthis.placementStage(0, parent);
};

/**
 * Function: filterDescendants
 * 
 * Creates an array of descendant cells
 */
mxSwimlaneLayout.prototype.filterDescendants = function(cell, result)
{
\tvar model = this.graph.model;

\tif (model.isVertex(cell) && cell != this.parent && model.getParent(cell) != this.parent && this.graph.isCellVisible(cell))
\t{
\t\tresult[mxObjectIdentity.get(cell)] = cell;
\t}

\tif (this.traverseAncestors || cell == this.parent
\t\t\t&& this.graph.isCellVisible(cell))
\t{
\t\tvar childCount = model.getChildCount(cell);

\t\tfor (var i = 0; i < childCount; i++)
\t\t{
\t\t\tvar child = model.getChildAt(cell, i);
\t\t\t
\t\t\t// Ignore ports in the layout vertex list, they are dealt with
\t\t\t// in the traversal mechanisms
\t\t\tif (!this.isPort(child))
\t\t\t{
\t\t\t\tthis.filterDescendants(child, result);
\t\t\t}
\t\t}
\t}
};

/**
 * Function: isPort
 * 
 * Returns true if the given cell is a \"port\", that is, when connecting to
 * it, its parent is the connecting vertex in terms of graph traversal
 * 
 * Parameters:
 * 
 * cell - <mxCell> that represents the port.
 */
mxSwimlaneLayout.prototype.isPort = function(cell)
{
\tif (cell.geometry.relative)
\t{
\t\treturn true;
\t}
\t
\treturn false;
};

/**
 * Function: getEdgesBetween
 * 
 * Returns the edges between the given source and target. This takes into
 * account collapsed and invisible cells and ports.
 * 
 * Parameters:
 * 
 * source -
 * target -
 * directed -
 */
mxSwimlaneLayout.prototype.getEdgesBetween = function(source, target, directed)
{
\tdirected = (directed != null) ? directed : false;
\tvar edges = this.getEdges(source);
\tvar result = [];

\t// Checks if the edge is connected to the correct
\t// cell and returns the first match
\tfor (var i = 0; i < edges.length; i++)
\t{
\t\tvar src = this.getVisibleTerminal(edges[i], true);
\t\tvar trg = this.getVisibleTerminal(edges[i], false);

\t\tif ((src == source && trg == target) || (!directed && src == target && trg == source))
\t\t{
\t\t\tresult.push(edges[i]);
\t\t}
\t}

\treturn result;
};

/**
 * Traverses the (directed) graph invoking the given function for each
 * visited vertex and edge. The function is invoked with the current vertex
 * and the incoming edge as a parameter. This implementation makes sure
 * each vertex is only visited once. The function may return false if the
 * traversal should stop at the given vertex.
 * 
 * Parameters:
 * 
 * vertex - <mxCell> that represents the vertex where the traversal starts.
 * directed - boolean indicating if edges should only be traversed
 * from source to target. Default is true.
 * edge - Optional <mxCell> that represents the incoming edge. This is
 * null for the first step of the traversal.
 * allVertices - Array of cell paths for the visited cells.
 * swimlaneIndex - the laid out order index of the swimlane vertex is contained in
 */
mxSwimlaneLayout.prototype.traverse = function(vertex, directed,