<?php

namespace UVDesk\CommunityPackages\UVDesk\CustomFields\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Collections;
use Doctrine\ORM\Tools\Pagination\Paginator;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Query;

/**
 * CustomFieldDecryptLogRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CustomFieldDecryptLogRepository extends EntityRepository
{

	public $safeFields = array('page','limit','sort','order','direction');
    const LIMIT = 10;

	public function getCustomFieldLogs(\Symfony\Component\HttpFoundation\ParameterBag $obj = null, $container)
	{
		$json = array();
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select("cfl.id, cfl.userType as userType, cfl.accessGranted as accessGranted, cfl.createdAt as createdAt, t.incrementId as ticketId, cf.name as customFieldName, u.id as userId, CONCAT(ad.firstName,' ', ad.lastName) as userName")->from($this->getEntityName(), 'cfl')
			->leftJoin('cfl.user', 'u')
			->leftJoin('u.data', 'ad')
			->leftJoin('cfl.ticketCustomFieldsValues', 'cfv')
			->leftJoin('cfv.ticketCustomFieldsValues', 'cf')
			->leftJoin('cfv.ticket', 't')
			->andwhere("(cfl.userType = 'member' AND ad.userRole != 4) OR (cfl.userType = 'customer' AND ad.userRole = 4)");
;
        $data = $obj->all();
        $data = array_reverse($data);
        foreach ($data as $key => $value) {
            if(!in_array($key,$this->safeFields)) {
				if($key == 'search') {
					$qb->andwhere("cf.name LIKE :customFieldName OR CONCAT(ad.firstName,' ', ad.lastName) LIKE :userName OR t.incrementId LIKE :ticketId");
					$qb->setParameter('customFieldName', '%'.urldecode($value).'%'); 
					$qb->setParameter('userName', '%'.urldecode($value).'%');
					$qb->setParameter('ticketId', '%'.urldecode($value).'%'); 
				}
            }
        }   

        if(!isset($data['sort']))
            $qb->orderBy('cfl.id', Criteria::DESC);

        $paginator  = $container->get('knp_paginator');

        $newQb = clone $qb;
        $newQb->select('COUNT(DISTINCT cfl.id)');
        $results = $paginator->paginate(
            $qb->getQuery()->setHydrationMode(Query::HYDRATE_ARRAY)->setHint('knp_paginator.count', $newQb->getQuery()->getSingleScalarResult()),
            isset($data['page']) ? $data['page'] : 1,
            self::LIMIT,
            array('distinct' => false)
        );

		$data = $results->getItems();
		foreach ($data as $key => $row) {
			$data[$key]['formatedCreatedAt'] = $container->get('user.service')->convertToTimezone($row['createdAt']);
		}

        $paginationData = $results->getPaginationData();
        $queryParameters = $results->getParams();

        $paginationData['url'] = '#'.$container->get('default.service')->symfony_http_build_query($queryParameters);

        $json['logs'] = $data;
        $json['pagination_data'] = $paginationData;
       
        return $json;
	}
}
